/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtConvertCase()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtCPP_Proc(dpy, sym, lower, upper)
Display *dpy;
KeySym sym;
KeySym *lower;
KeySym *upper;
{
	avs_set_event(1,1);
	*upper = XStringToKeysym("u");
	*lower = XStringToKeysym("l");
}


#define T_XtConvertCase	1
char    *TestName = "XtConvertCase";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display;
KeySym keysym;
KeySym lower_return;
KeySym upper_return;
int invoked;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtConvertCase-1.(A)");
	report_assertion("A successful call to void XtConvertCase(display, keysym,");
	report_assertion("lower_return, upper_return) shall call the case converter");
	report_assertion("for the KeySym keysym associated with the display display");
	report_assertion("and return the upper and lower case equivalents for the");
	report_assertion("KeySym in the locations specified by upper_return and");
	report_assertion("lower_return respectively.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcnvrtcas1", "XtConvertCase");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Get keysym for alphabet 'a'");
	keysym = XStringToKeysym("a");
	tet_infoline("PREP: Register case converter XtCPP_Proc");
	XtRegisterCaseConverter(display, &XtCPP_Proc, keysym, keysym);
	tet_infoline("PREP: Get upper and lower case version of a keysym");
	XtConvertCase(display, keysym, &lower_return, &upper_return);
	tet_infoline("TEST: Case converter XtCPP_Proc was indeed invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCPP_Proc invoked status");
	tet_infoline("TEST: Values returned");
	if (strcmp(XKeysymToString(lower_return), "l") != 0) {
		sprintf(ebuf, "ERROR: Expected lower_return to be keysym for \"l\", is keysym for \"%s\"",  XKeysymToString(lower_return));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (strcmp(XKeysymToString(upper_return), "u") != 0) {
		sprintf(ebuf, "ERROR: Expected upper_return to be keysym for \"u\", is keysym for \"%s\"",  XKeysymToString(upper_return));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11894 */
/* End of included file Mdefcode.tmc.11894 */

/* Including from file Mdefcode.tmc.11894 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtConvertCase-2.(B)");
	report_assertion("A call to void XtConvertCase(display, keysym, lower_return,");
	report_assertion("upper_return) when no user-registered case converter exists");
	report_assertion("for keysym shall invoke the default case converter.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11894 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
