/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XKillClient(display, resource)
 *   Display	*display;
 *   XID 	resource;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XKillClient	1
char    *TestName = "XKillClient";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XKillClient function
 */
static Display	*display;
static XID 	resource;



#define	N_RES	4	


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	resource = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display	*client1;
Window	win;
Pixmap	pix;
Colormap	cm;
unsigned int 	width, height;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XKillClient-1.(A)");
	report_assertion("A call to XKillClient forces a close-down of the client");
	report_assertion("that created the specified resource.");

	report_strategy("Create a client client1.");
	report_strategy("Create several resources using client1.");
	report_strategy("Call XKillClient with one of these resources.");
	report_strategy("Verify that all client1's resources are destroyed and infer that client1 was");
	report_strategy("destroyed.");

	tpstartup();
	setargs();
/* We must disable resource registration here to prevent attempted
   deallocation of closed connections and deleted resources. */
	regdisable(); 
	client1 = opendisplay();
	if (client1 == 0) {
		delete("Could not open display");
		regenable();
		return;
	}

	win = defwin(client1);
	pix = XCreatePixmap(client1, DRW(display), 2, 3,
		DefaultDepth(client1, DefaultScreen(client1)));
	cm = makecolmap(client1, DefaultVisual(client1, DefaultScreen(client1)), AllocNone);

	regenable();

	XSync(client1, False);
	if (isdeleted())
		return;

	resource = (XID) cm;
	startcall(display);
	if (isdeleted())
		return;
	XKillClient(display, resource);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	CATCH_ERROR(Dsp);
	getsize(Dsp, win, &width, &height);
	if (GET_ERROR(Dsp) == BadDrawable)
		CHECK;
	else {
		report("Window was not destroyed");
		FAIL;
	}

	reseterr();
	getsize(Dsp, pix, &width, &height);
	if (GET_ERROR(Dsp) == BadDrawable)
		CHECK;
	else {
		report("Pixmap was not destroyed");
		FAIL;
	}
	RESTORE_ERROR(Dsp);

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*client1;
Window	w[N_RES];
XWindowAttributes	atts;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XKillClient-2.(A)");
	report_assertion("When the client that created the resource has already");
	report_assertion("terminated in either RetainPermanent or RetainTemporary");
	report_assertion("mode, then all the resources of that client are destroyed.");

	report_strategy("Create a connection, client1.");
	report_strategy("Create resources for client1.");
	report_strategy("Set close-down mode to RetainPermanent.");
	report_strategy("Close client1 connection with XCloseDisplay.");
	report_strategy("Check client1 resources still exist.");
	report_strategy("Call XKillClient with one of the client1 resources.");
	report_strategy("Verify that all client1 resources are destroyed.");

	tpstartup();
	setargs();
/* We must disable resource registration here to prevent attempted
   deallocation of closed connections and deleted resources. */
	regdisable(); 

	client1 = opendisplay();
	if (client1 == 0) {
		delete("Could not open display");
		regenable();
		return;
	}

	w[0] = defwin(client1);
	w[1] = defwin(client1);
	w[2] = defwin(client1);
	w[3] = defwin(client1);
	regenable();

	XSetCloseDownMode(client1, RetainPermanent);
	XCloseDisplay(client1);

	CATCH_ERROR(Dsp);
	for (i = 0; i < N_RES; i++) {
		if (XGetWindowAttributes(Dsp, w[i], &atts) == False) {
			delete("RetainPermanent windows were destroyed");
			return;
		}
	}
	RESTORE_ERROR(Dsp);

	resource = w[2];
	startcall(display);
	if (isdeleted())
		return;
	XKillClient(display, resource);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	CATCH_ERROR(Dsp);
	for (i = 0; i < N_RES; i++) {
		if (XGetWindowAttributes(Dsp, w[i], &atts) == True) {
			report("RetainPermanent window was not destroyed");
			FAIL;
		} else
			CHECK;
	}
	RESTORE_ERROR(Dsp);

	CHECKPASS(N_RES);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XWindowAttributes	atts;
Display	*client1;
Display	*client2;
Window	w1;
Window	w2;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XKillClient-3.(A)");
	report_assertion("When a resource of AllTemporary is specified, then the");
	report_assertion("resources of all clients that have terminated in");
	report_assertion("RetainTemporary mode are destroyed.");

	report_strategy("Open connection client1.");
	report_strategy("Open connextion client2.");
	report_strategy("Make resources for both clients.");
	report_strategy("Set close-down mode of RetainTemporary for both.");
	report_strategy("Close both clients with XCloseDisplay.");
	report_strategy("Call XKillClient with ID AllTemporary.");
	report_strategy("Verify that all clients 1 and 2 resources are destroyed.");

	tpstartup();
	setargs();
/* We must disable resource registration here to prevent attempted
   deallocation of closed connections and deleted resources. */
	regdisable(); 

	if ((client1 = opendisplay()) == NULL) {
		delete("Could not open display");
		regenable();
		return;
	}
	if ((client2 = opendisplay()) == NULL) {
		delete("Could not open display");
		regenable();
		return;
	}

	w1 = defwin(client1);
	w2 = defwin(client2);

	regenable();

	XSetCloseDownMode(client1, RetainTemporary);
	XSetCloseDownMode(client2, RetainTemporary);

	XCloseDisplay(client1);
	XCloseDisplay(client2);

	resource = AllTemporary;
	startcall(display);
	if (isdeleted())
		return;
	XKillClient(display, resource);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	CATCH_ERROR(Dsp);
	if (XGetWindowAttributes(Dsp, w1, &atts) == True) {
		report("RetainTemporary window was not destroyed");
		FAIL;
	} else
		CHECK;
	if (XGetWindowAttributes(Dsp, w2, &atts) == True) {
		report("RetainTemporary window was not destroyed");
		FAIL;
	} else
		CHECK;
	RESTORE_ERROR(Dsp);

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XKillClient-4.(A)");
	report_assertion("When the specified resource is not valid, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Get bad id using badwin().");
	report_strategy("Call XKillClient with this value.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	resource = badwin(Dsp);
	startcall(display);
	if (isdeleted())
		return;
	XKillClient(display, resource);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
