/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtNextEvent()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
XtInputId input_ret;
char *msg = "Hello World";
int acount = 0;
FILE *fid;

/*
** XtTMO2_Proc
*/
void XtTMO2_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	send_event(topLevel, KeyPress, KeyPressMask, TRUE );
}

/*
** XtTMO3_Proc()
*/
void XtTMO3_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(1, 1);
	exit(0);
	
}

static void analyse_events(quit)
Widget quit;
{
int i;
	Display *display;
	XEvent loop_event;
	XEvent event_return;
	Widget widget;
	widget = XtParent(quit);
	display = XtDisplay(widget);
	for (i = 0;i == 0;) {
	 	XNextEvent(display, &loop_event);
	 	XSync(display, False);
	 	if (loop_event.type == KeyPress) {
			/*
			** KeyRelease to follow KeyPress event.
			*/
			XtNextEvent(&loop_event);
			if ( loop_event.type == KeyRelease ) {
	 			XtDispatchEvent(&loop_event);
				exit(0);
			}
			else {
	 			sprintf(ebuf, "ERROR: Expected KeyRelease to Follow KeyPress");
				tet_infoline(ebuf);
				tet_result(TET_FAIL);
			}
	 }
	 XtDispatchEvent(&loop_event);
	} /* end for */
}
/*
** Procedure XtIOP_Proc
*/
void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(2, 1);
}


#define T_XtNextEvent	1
char    *TestName = "XtNextEvent";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_msg;
char *msg = "Event widget";
pid_t pid2;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtNextEvent-1.(A)");
	report_assertion("When the calling process has an X event in the input queue");
	report_assertion("a successful call to void XtNextEvent(event_return) shall");
	report_assertion("remove the X event from the head of the queue and return it");
	report_assertion("in event_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tnxtevnt1", "XtNextEvent");
	FORK(pid2);
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send KeyPress and KeyRelease event over wire");
	send_event(labelw_msg, KeyPress, KeyPressMask, TRUE);
	send_event(labelw_msg, KeyRelease,KeyReleaseMask, TRUE);
	tet_infoline("TEST: XtNextEvent returns KeyRelease event after KeyPress event");
	analyse_events(click_quit);
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else
		tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12335 */
/* End of included file Mdefcode.tmc.12335 */

static void t002(){

pid_t pid2;
int waited = 0;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtNextEvent-2.(A)");
	report_assertion("When there are no events in the X input queue for the");
	report_assertion("calling process a call to void XtNextEvent(event_return)");
	report_assertion("shall flush the X output buffers of each display in the");
	report_assertion("calling process and wait until an event from the X server is");
	report_assertion("available.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tnxtevnt2", "XtNextEvent");
	FORK(pid2);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO2_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: XtNextEvent waits for next event");
	display = XtDisplay(rowcolw);
	for (i = 0; i == 0;) {
		XtNextEvent(&loop_event);
		XSync(display, False);
		XtDispatchEvent(&loop_event);
		/*
		** receiving events:	 proccessing = non zero
		** no events in wait state: processing = 0
		*/
		processing = XtPending();
		if (loop_event.type == KeyPress) {
			exit(0);
		}
		/*
		** No events XtNextEvent() waits for events.
		*/
		if (!processing)
			avs_set_event(1, 1);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_result(TET_UNRESOLVED);
        }
	else {
		waited = avs_get_event(1);
		if (!waited) {
			sprintf(ebuf, "ERROR: XtNextEvent did not wait for the event");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12335 */
/* End of included file Mdefcode.tmc.12335 */

static void t003(){

pid_t pid2;
int status = 0;
int waited = 0;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtNextEvent-3.(A)");
	report_assertion("When a timeout occurs in the calling process while a call");
	report_assertion("to void XtNextEvent(event_return) is blocked the designated");
	report_assertion("callback procedure for the timeout shall be called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tnxtevnt3", "XtNextEvent");
	FORK(pid2);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO3_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Procedure XtTMO3_Proc was invoked and XtNextEvent");
	tet_infoline("      indeed waited for next event");
	display = XtDisplay(topLevel);
	for (i = 0; i == 0;) {
		XtNextEvent(&loop_event);
		XSync(display, False);
		XtDispatchEvent(&loop_event);
	} /*end for*/
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_result(TET_UNRESOLVED);
        }
	else {
		status = avs_get_event(1);
		if (!status) {
			sprintf(ebuf, "ERROR: XtTMO3_Proc was not invoked");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12335 */
/* End of included file Mdefcode.tmc.12335 */

static void t004(){

pid_t pid2;
int status = 0;
int waited = 0;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
pid_t pid3;
int pstatus;
char *data;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtNextEvent-4.(A)");
	report_assertion("When input for an alternate input source occurs in the");
	report_assertion("calling process while a call to void");
	report_assertion("XtNextEvent(event_return) is blocked the designated callback");
	report_assertion("procedure for the input source shall be called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tnxtevnt3", "XtNextEvent");
	data = "data1";
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	FORK(pid2);
	tet_infoline("TEST: Register file as an input source");
	input_ret = XtAddInput(fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO3_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Callback for input is called");
	display = XtDisplay(topLevel);
	for (i = 0; i == 0;) {
		XtNextEvent(&loop_event);
		XSync(display, False);
		XtDispatchEvent(&loop_event);
	} /*end for*/
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(data);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_result(TET_UNRESOLVED);
        }
	else {
		status = avs_get_event(2);
		if (!status) {
			sprintf(ebuf, "ERROR: callback was not invoked");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.12335 */
/* End of included file Mdefcode.tmc.12335 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
