/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtDestroyWidget()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/* procedure XtTMO_Proc */
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
        exit(0);
}

void analyse_events(widget)
Widget widget;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	XEvent return_event;
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 XSync(display, False);
	 if (loop_event.type == DestroyNotify) {
		avs_set_event(1,1);
		XtAppNextEvent(app_context, &return_event);
		if (return_event.type == DestroyNotify) {
				avs_set_event(2,1);
			exit(0);
		}
	 } /* end if */
	 XtDispatchEvent(&loop_event);
	} /* end for */
}

Boolean flag;

Widget labelw_msg1;

void XtCBP(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	tet_infoline("TEST: Destroy labelw_msg1 widget within destroy callback");
	XtDestroyWidget(labelw_msg1);
	avs_set_event(2, avs_get_event(2)+1);
}
void XtCBP_ChildProc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	flag = True;
	avs_set_event(1, 1);
}
void XtCBP_ParentProc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	/*
	** XtCBP_ChildProc to be invoked before XtCBP_ParentProc
	*/
	if (flag)
	avs_set_event(2, 1);
	else {
		sprintf(ebuf, "ERROR: XtCBP_ChildProc to be invoked before XtCBP_ParentProc");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}


#define T_XtDestroyWidget	1
char    *TestName = "XtDestroyWidget";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XEvent loop_event;
char *msg = "Test widget";
Display *display;
Window window;
int status = 0;
pid_t	pid2;
int	i;
Widget rowcolw_good;
Widget labelw_good;
Window rowcolw_good_window;
Window labelw_good_window;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDestroyWidget-1.(A)");
	report_assertion("A call to void XtDestroyWidget(w) when the being_destroyed");
	report_assertion("field of the widget w is True shall return immediately.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tdestywid1", "XtDestroyWidget");
	tet_infoline("PREP: Create labelw_msg1 widget in boxw1 widget");
	labelw_msg1 = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Catch DestroyNotify event");
	display = XtDisplay(labelw_msg1);
	window = XtWindow(labelw_msg1);
	XSelectInput(display, window, StructureNotifyMask);
	tet_infoline("PREP: Add callback procedure XtCBP_ParentProc() to labelw_msg1");
	XtAddCallback(labelw_msg1,
			XtNdestroyCallback,
			XtCBP,
			(XtPointer)NULL
			);
	tet_infoline("TEST: Destroy labelw_msg1 widget");
	XtDestroyWidget(labelw_msg1);
	tet_infoline("PREP: Register timeout");
        XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: DestroyNotify event generated just once");
	for (i = 0; i < 10; i++) {
		XtAppNextEvent(app_ctext, &loop_event);
		XSync(display, False);
		if (loop_event.type == DestroyNotify)
			avs_set_event(1,avs_get_event(1)+1);
		XtDispatchEvent(&loop_event);
		i= 0;
	}
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(1, status, "DestroyNotify event count");
	tet_infoline("TEST: Destroy callback called just once");
	status = avs_get_event(2);
	check_dec(1, status, "Destroy callback count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.10923 */
/* End of included file Mdefcode.tmc.10923 */

static void t002(){

XEvent loop_event;
Widget labelw_msg;
char *msg = "Test widget";
Display *display;
Window window;
int status = 0;
pid_t	pid2;
int	i;
Widget rowcolw_good;
Widget labelw_good;
Window rowcolw_good_window;
Window labelw_good_window;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDestroyWidget-2.(A)");
	report_assertion("When it is not called from within an application callback");
	report_assertion("routine and the widget w is not already being destroyed a");
	report_assertion("call to void XtDestroyWidget(w) shall perform the following");
	report_assertion("actions in the order specified: - call the destroy callback");
	report_assertion("procedures registered for the widget w and all normal and");
	report_assertion("pop-up descendents in postorder. - if the widget w is not a");
	report_assertion("pop-up child and the widget's parent is a subclass of");
	report_assertion("compositeWidgetClass, and if the parent is not being");
	report_assertion("destroyed, unmanage on the widget and call the widget's");
	report_assertion("parent's delete_child procedure. - if the widget w is not a");
	report_assertion("pop-up child and the widget's parent is a subclass of");
	report_assertion("constraintWidgetClass, call the ConstraintClassPart destroy");
	report_assertion("procedure for the parent, followed by the destroy procedures");
	report_assertion("of the parent's superclass, up to and including the");
	report_assertion("ConstraintClassPart destroy procedure for");
	report_assertion("constraintWidgetClass. - calls the destroy procedures for");
	report_assertion("the widget and all normal and pop-up descendents in");
	report_assertion("postorder, calling the CoreClassPart destroy procedure in");
	report_assertion("each widget followed by the destroy procedures in its");
	report_assertion("superclasses, up to and including the Object class. - if the");
	report_assertion("widget w is realized destroy the window for the widget and");
	report_assertion("the windows for all its normal descendents. - recursively");
	report_assertion("descend the tree and destroy the windows for all realized");
	report_assertion("popup descendents.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	/*this is catenation of the earlier tests - needs enhancement*/
	avs_set_event(1,0);
	avs_set_event(2,0);
	FORK(pid2);
	avs_xt_hier("Tdestywid1", "XtDestroyWidget");
	tet_infoline("PREP: Create labelw_msg widget in boxw1 widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Catch DestroyNotify event");
	display = XtDisplay(labelw_msg);
	window = XtWindow(labelw_msg);
	XSelectInput(display, window, StructureNotifyMask);
	tet_infoline("TEST: Destroy labelw_msg widget");
	XtDestroyWidget(labelw_msg);
	tet_infoline("TEST: DestroyNotify event generated");
	for (i = 0; i < 10; i++) {
	 XtAppNextEvent(app_ctext, &loop_event);
	 XSync(display, False);
	 if (loop_event.type == DestroyNotify) {
		avs_set_event(1,1);
		exit(0);
	 }
	 XtDispatchEvent(&loop_event);
	 i= 0;
	}
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(1, status, "DestroyNotify event count");
	avs_set_event(1,0);
	avs_set_event(2,0);
	FORK(pid2);
	avs_xt_hier("Tdestywid2", "XtDestroyWidget");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good widget in rowcolw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Catch DestroyNotify event");
	display = XtDisplay(rowcolw_good);
	rowcolw_good_window = XtWindow(rowcolw_good);
	XSelectInput(display, rowcolw_good_window, StructureNotifyMask);
	labelw_good_window = XtWindow(labelw_good);
	XSelectInput(display, labelw_good_window, StructureNotifyMask);
	tet_infoline("TEST: Destroy rowcolw_good widget");
	XtDestroyWidget(rowcolw_good);
	analyse_events(rowcolw);
	KROF(pid2);
	tet_infoline("TEST: DestroyNotify event was generated for labelw_good");
	status = avs_get_event(1);
	check_dec(1, status, "DestroyNotify event count");
	tet_infoline("TEST: DestroyNotify event was generated for rowcolw_good");
	status = avs_get_event(2);
	check_dec(1, status, "DestroyNotify event count");
	avs_set_event(1,0);
	avs_set_event(2,0);
	FORK(pid2);
	avs_xt_hier("Tdestywid3", "XtDestroyWidget");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Add callback procedure XtCBP_ParentProc() to rowcolw_good");
	XtAddCallback(rowcolw_good,
			XtNdestroyCallback,
			XtCBP_ParentProc,
			(XtPointer)NULL
			);
	tet_infoline("PREP: Create labelw_good widget in rowcolw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Add callback procedure XtCBP_ChildProc to labelw_good");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP_ChildProc,
			(XtPointer)NULL
			);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Destroy rowcolw_good widget");
	XtDestroyWidget(rowcolw_good);
	KROF(pid2);
	tet_infoline("TEST: XtCBP_ChildProc procedure was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "callback called count");
	tet_infoline("TEST: XtCBP_ParentProc procedure was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "callback called count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.10923 */
/* End of included file Mdefcode.tmc.10923 */

/* Including from file Mdefcode.tmc.10923 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtDestroyWidget-3.(B)");
	report_assertion("When called from within an application callback routine, if");
	report_assertion("the widget w is not already being destroyed a call to void");
	report_assertion("XtDestroyWidget(w) shall set the being_destroyed field of");
	report_assertion("the widget w and its normal and pop-up children but shall");
	report_assertion("not take other action until XtDispatchEvent is about to");
	report_assertion("return, at which point it shall perform the following");
	report_assertion("actions in the order specified: - call the destroy callback");
	report_assertion("procedures registered for the widget w and all normal and");
	report_assertion("pop-up descendents in postorder. - if the widget w is not a");
	report_assertion("pop-up child and the widget's parent is a subclass of");
	report_assertion("compositeWidgetClass, and if the parent is not being");
	report_assertion("destroyed, unmanage on the widget and call the widget's");
	report_assertion("parent's delete_child procedure. - if the widget w is not a");
	report_assertion("pop-up child and the widget's parent is a subclass of");
	report_assertion("constraintWidgetClass, call the ConstraintClassPart destroy");
	report_assertion("procedure for the parent, followed by the destroy procedures");
	report_assertion("of the parent's superclass, up to and including the");
	report_assertion("ConstraintClassPart destroy procedure for");
	report_assertion("constraintWidgetClass. - calls the destroy procedures for");
	report_assertion("the widget and all normal and pop-up descendents in");
	report_assertion("postorder, calling the CoreClassPart destroy procedure in");
	report_assertion("each widget followed by the destroy procedures in its");
	report_assertion("superclasses, up to and including the Object class. - if the");
	report_assertion("widget w is realized destroy the window for the widget and");
	report_assertion("the windows for all its normal descendents. - recursively");
	report_assertion("descend the tree and destroy the windows for all realized");
	report_assertion("popup descendents.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.10923 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
