/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtWindowToWidget()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtWindowToWidget	1
char    *TestName = "XtWindowToWidget";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char string[10];
Window window_good;
Widget widget_good, labelw_good;
Display *display_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtWindowToWidget-1.(A)");
	report_assertion("A successful call to Widget XtWindowToWidget(display,");
	report_assertion("window) shall return a pointer to the widget that is");
	report_assertion("realized and whose window is window on the display display.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Twindtowd1", "XtWindowToWidget");
	tet_infoline("PREP: Create test label widget `Hello' in box widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get window id and display pointer of the labelw_good widget");
	window_good = XtWindow(labelw_good);
	display_good = XtDisplay(labelw_good);
	tet_infoline("TEST: XtWindowToWidget translates to widget ID");
	widget_good = XtWindowToWidget(display_good, window_good);
	strcpy(string, XtName(widget_good) );
	check_str("Hello", string, "widget name");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12089 */
/* End of included file Mdefcode.tmc.12089 */

static void t002(){

char ret_str[10];
Widget widget_bad, labelw_good;
Display *display_good; 
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtWindowToWidget-2.(A)");
	report_assertion("A call to Widget XtWindowToWidget(display, window) when no");
	report_assertion("realized widget exists whose window is window on the");
	report_assertion("specified display shall return NULL.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Twindtowd2", "XtWindowToWidget");
	tet_infoline("PREP: Create test label widget `Hello' in box widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display pointer of the test label widget");
	display_good = XtDisplay(labelw_good);
	tet_infoline("TEST: Invalid window id should not translate to widget ID");
	widget_bad = XtWindowToWidget(display_good, -999);
	if (widget_bad != NULL) {
		sprintf(ebuf, "ERROR: Expected NULL returned widget instance");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12089 */
/* End of included file Mdefcode.tmc.12089 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
