/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   char *
 *   XtMalloc()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern void alloc_handler();
extern int alloc_handler_called;


#define T_XtMalloc	1
char    *TestName = "XtMalloc";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *ptr, *ptr1;
size_t max_limit;
int i;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtMalloc-1.(A)");
	report_assertion("A successful call to char *XtMalloc(size) shall return a");
	report_assertion("pointer to a block of storage of at least size bytes.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmalloc1", "XtMalloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Determine largest malloc");
	max_limit = mem_limit();
	tet_infoline("TEST: Allocate memory");
	ptr = (char *) XtMalloc(max_limit);
	if (ptr == (char *)0) {
		sprintf(ebuf, "ERROR: Malloc could not allocate %d bytes", max_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	XtFree(ptr);
	tet_infoline("CLEANUP: Free memory");
 
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12066 */
/* End of included file Mdefcode.tmc.12066 */

static void t002(){

char *ptr, *ptr1;
size_t max_limit;
int i;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtMalloc-2.(A)");
	report_assertion("When there is insufficient memory to allocate the requested");
	report_assertion("block a call to char *XtMalloc(size) shall issue an");
	report_assertion("allocError error and return NULL.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmalloc2", "XtMalloc");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Set up toolkit handler for XtMalloc failure");
	XtAppSetErrorMsgHandler(app_ctext, alloc_handler);
	tet_infoline("PREP: Determine largest malloc");
	max_limit = mem_limit();
	tet_infoline("PREP: Allocate that much and the check over the limit XtMalloc calls XtErrorMsg");
	ptr = (char *) XtMalloc(max_limit);
	if (ptr == (char *)0) {
		sprintf(ebuf, "ERROR: XtMalloc could not allocate %d bytes", max_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	ptr1 = (char *)XtMalloc(max_limit);
	if (ptr1 != (char *)0) {
		sprintf(ebuf, "ERROR: XtMalloc could still allocate %d bytes", max_limit);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	XtFree(ptr);
	tet_infoline("CLEANUP: Free memory");
	if (alloc_handler_called != 1) {
		sprintf(ebuf, "ERROR: XtMalloc did not generate toolkit error message");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12066 */
/* End of included file Mdefcode.tmc.12066 */

/* Including from file Mdefcode.tmc.12066 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtMalloc-3.(B)");
	report_assertion("The order and contiguity of the storage allocated by");
	report_assertion("successive calls to char *XtMalloc(size).");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12066 */

/* Including from file Mdefcode.tmc.12066 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtMalloc-4.(B)");
	report_assertion("A successful call to char *XtMalloc(size) shall return a");
	report_assertion("pointer to an object that is disjoint from any other object.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12066 */

/* Including from file Mdefcode.tmc.12066 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtMalloc-5.(B)");
	report_assertion("The pointer returned by a successful call to char");
	report_assertion("*XtMalloc(size) shall point to the lowest byte address of");
	report_assertion("the allocated space.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12066 */

/* Including from file Mdefcode.tmc.12066 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtMalloc-6.(B)");
	report_assertion("The pointer returned by a call to char *XtMalloc(size) when");
	report_assertion("size is zero.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12066 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
