/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* 
* SCCS:  @(#)  kysym.m Rel 1.11	    (5/12/92)
* 
* 	UniSoft Ltd., London, England
* 
* (C) Copyright 1991 X/Open Company Limited
* 
* All rights reserved.  No part of this source code may be reproduced,
* stored in a retrieval system, or transmitted, in any form or by any
* means, electronic, mechanical, photocopying, recording or otherwise,
* except as stated in the end-user licence agreement, without the prior
* permission of the copyright owners.
* 
* X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
* the UK and other countries.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_keysym	1
char    *TestName = "keysym";



int 	tet_thistest;

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion keysym-1.(A)");
	report_assertion("When the header file <X11/keysym.h> is included, then the");
	report_assertion("symbols in the table which have code 1 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Include header file <X11/keysym.h>");
	report_strategy("For each KeySym in table with code 1:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysym1();

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion keysym-2.(A)");
	report_assertion("When the header file <X11/keysym.h> is included, then the");
	report_assertion("symbols in the table which have code 2 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Include header file <X11/keysym.h>");
	report_strategy("For each KeySym in table with code 2:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysym2();

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion keysym-3.(A)");
	report_assertion("When the header file <X11/keysym.h> is included, then the");
	report_assertion("symbols in the table which have code 3 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Include header file <X11/keysym.h>");
	report_strategy("For each KeySym in table with code 3:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysym3();

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion keysym-4.(A)");
	report_assertion("When the header file <X11/keysym.h> is included, then the");
	report_assertion("symbols in the table which have code 4 are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Include header file <X11/keysym.h>");
	report_strategy("For each KeySym in table with code 4:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysym4();

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion keysym-5.(A)");
	report_assertion("When the header file <X11/keysym.h> is included, then the");
	report_assertion("symbols in the table which have code G are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Include header file <X11/keysym.h>");
	report_strategy("For each KeySym in table with code G:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymG();

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion keysym-6.(A)");
	report_assertion("When the header file <X11/keysym.h> is included, then the");
	report_assertion("symbols in the table which have code M are defined to have");
	report_assertion("the hexadecimal values given in the table.");

	report_strategy("Include header file <X11/keysym.h>");
	report_strategy("For each KeySym in table with code M:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysymM();

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion keysym-7.(A)");
	report_assertion("When the header file <X11/keysym.h> is included, then the");
	report_assertion("symbols in the table are defined to have the hexadecimal");
	report_assertion("values given in the table.");

	report_strategy("Include header file <X11/keysym.h>");
	report_strategy("For each KeySym in table:");
	report_strategy("	Verify that the symbol is defined using #ifdef.");
	report_strategy("	Verify that the symbol has the expected value using #if.");

	tpstartup();
	kysym0();
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
