/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Font
 *   XLoadFont(display, name)
 *   Display	*display;
 *   char	*name;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XLoadFont	1
char    *TestName = "XLoadFont";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XLoadFont function
 */
static Display	*display;
static char	*name;


#define TEXTSTRING "AbyZ%~"

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	name = "xtfont1";
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Font	font;
int 	i;
char	fname[64];
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XLoadFont-1.(A)");
	report_assertion("When name is a NULL terminated string in ISO Latin-1");
	report_assertion("encoding, then a call to XLoadFont loads the specified font");
	report_assertion("and returns its font ID.");

	report_strategy("For each VSW5 font:");
	report_strategy("  Load font.");
	report_strategy("  Make some simple checks to see if a font ID is returned.");

	tpstartup();
	setargs();
	for (i = 0; i < XT_NFONTS; i++) {
		sprintf(fname, "xtfont%d", i);
		trace("Loading font %s", fname);
		name = fname;

		startcall(display);
		if (isdeleted())
			return;
		font = XLoadFont(display, name);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (geterr() != Success) {
			report("font %s could not be loaded", fname);
			report("Check that VSW5 fonts have been installed");
			FAIL;
		} else if (font == 0 || (font & 0xc0000000)) {
			report("An invalid font ID was returned");
			FAIL;
		} else
			CHECK;
	}
	CHECKPASS(XT_NFONTS);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo	*vp;
Font	font;
char	*fname = "xtfont1";
Drawable d;
GC	gc;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XLoadFont-2.(A)");
	report_assertion("The font ID returned by a call to XLoadFont is usable on");
	report_assertion("any GC created for any screen of the display.");

	report_strategy("For each visual supported for the default screen:");
	report_strategy("  Load font \"xtfont1\".");
	report_strategy("  Create window.");
	report_strategy("  Create GC for window.");
	report_strategy("  Set font component in GC to loaded font.");
	report_strategy("  Draw string with single character.");
	report_strategy("  Pixmap verify.");
	report_strategy("Note: this tests the GC's for the default screen. ");
	report_strategy("To test for other screens, re-run the test suite with DISPLAY set ");
	report_strategy("to number of required screen.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN_PIX); nextvinf(&vp); ) {
		name = fname;

		startcall(display);
		if (isdeleted())
			return;
		font = XLoadFont(display, name);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (geterr() != Success) {
			/* Already done after calling XLoadFont */
			report("font %s could not be loaded", fname);
			report("Check that VSW5 fonts have been installed");
			FAIL;
		} else {
			d = makewin(display, vp);
			gc = makegc(display, d);
			XSetFont(display, gc, font);
			XDrawString(display, d, gc, 20, 20, "z", 1);
			PIXCHECK(display, d);
			dclear(display, d);
			XUnloadFont(display, font);
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Font	font;
static char	*names[] = {
	"xtfont1",
	"Xtfont1",
	"XTFONT1",
	"xTfOnT1",
	"XtFoNt1",
};
int 	i;
Drawable	draw;
XImage	*sav;
GC		gc;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XLoadFont-3.(A)");
	report_assertion("Upper and lower case characters in the name argument refer");
	report_assertion("to the same font.");

	report_strategy("Try series of name differing only in case.");
	report_strategy("Font ID is different each time so have to..");
	report_strategy("Draw string and save result in original font.");
	report_strategy("Verify that font returned using each name draws same string.");

	tpstartup();
	setargs();
	name = "xtfont1";
	startcall(display);
	if (isdeleted())
		return;
	font = XLoadFont(display, name);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() != Success) {
		/* Test has already failed */
		delete("Font could not be loaded");
		return;
	}

	draw = defdraw(display, VI_WIN_PIX);
	gc = makegc(display, draw);
	XSetFont(display, gc, font);

	XDrawString(display, draw, gc, 30, 30, TEXTSTRING, strlen(TEXTSTRING));
	sav = savimage(display, draw);

	if (isdeleted())
		return;

	for (i = 0; i < NELEM(names); i++) {

		dclear(display, draw);
		name = names[i];
		startcall(display);
		if (isdeleted())
			return;
		font = XLoadFont(display, name);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (geterr() == Success) {
			XSetFont(display, gc, font);
			XDrawString(display, draw, gc, 30, 30, TEXTSTRING, strlen(TEXTSTRING));
			if (compsavimage(display, draw, sav))
				CHECK;
			else {
				report("Font %s was different to xtfont1", name);
				FAIL;
			}
		} else {
			report("Font load failed with name %s", name);
			FAIL;	/* Has been done already */
		}
	}
	CHECKPASS(NELEM(names));
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ENam1.mc */
/* End of included file error/ENam1.mc */

/* Including from file error/ENam1.mc */
static void t004(){

Font	font;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XLoadFont-4.(A)");
	report_assertion("When the specified font does not exist, then a BadName");
	report_assertion("error occurs.");

	report_strategy("Call test function with non-existent font as the font name argument.");
	report_strategy("Verify that a BadName error occurs.");

	tpstartup();
	setargs();
	/* Note:  the argument has to be called 'name' */
	name = config.bad_font_name;

	startcall(display);
	if (isdeleted())
		return;
	font = XLoadFont(display, name);
	endcall(display);
	if (geterr() != BadName) {
		report("Got %s, Expecting BadName", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadName)
		PASS;
	else
		FAIL;	/* For safty, this should already have been issued */
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ENam1.mc */

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XLoadFont-5.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
