/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetGCValues(display, gc, valuemask, values)
 *   Display *display;
 *   GC gc;
 *   unsigned long valuemask;
 *   XGCValues *values;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetGCValues	1
char    *TestName = "XGetGCValues";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_GC gc


/*
 * Arguments to the XGetGCValues function
 */
static Display *display;
static GC gc;
static unsigned long valuemask;
static XGCValues *values;


static int 	StatusReturn;

#define FONTNAME "xtfont0"
XGCValues rvals;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	gc = 0;
	valuemask = 0;
	values = &rvals;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	gc = ErrdefGC;
}

static void t001(){

XVisualInfo	*vp;
XGCValues	vals;
Pixmap		tile, stipple;
Status		status;
Font 		font;
XFontStruct	*fontinfo;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetGCValues-1.(A)");
	report_assertion("A call to XGetGCValues copies the components specified by");
	report_assertion("the valuemask argument from the specified GC to the contents");
	report_assertion("of the values_return argument.");

	report_strategy("Create a GC with non-default values for function,");
	report_strategy(" planemask, foreground, background, linewidth, linestyle,");
	report_strategy(" capstyle, joinstyle, fillstyle, fillrule, tile, stipple,");
	report_strategy(" stipple origin, font, subwindowmode, graphics exposures,");
	report_strategy(" clip origin, dash offset and arcmode using XCreateGC.");
	report_strategy("Read the GC structure components using XGetGCValues.");
	report_strategy("Verify that the returned values match the created values.");

	tpstartup();
	setargs();
	if( (fontinfo = XLoadQueryFont(display, FONTNAME)) == (XFontStruct *) 0) {
		delete("Could not load font %s",FONTNAME);
		return;
	} else
		CHECK;

	resetvinf(VI_WIN);

	/*
	 * Find the visual information associated with the default
	 * visual, since we will be testing using the root window.
	 */
	do
		nextvinf(&vp);	
	while(vp->visual != DefaultVisual(display, DefaultScreen(display)));

	font = fontinfo -> fid;
	tile = makepixm(display, vp);
	stipple = XCreatePixmap(display, DRW(display), 1, 1, 1);
	vals.function = GXxor;
	vals.plane_mask = 42;
	vals.foreground = 1;
	vals.background = 0;
	vals.line_width = 10;
	vals.line_style = LineOnOffDash;
	vals.cap_style = CapProjecting;
	vals.join_style = JoinBevel;
	vals.fill_style = FillStippled;
	vals.fill_rule =  WindingRule;
	vals.arc_mode = ArcChord;
	vals.tile = tile;
	vals.stipple = stipple;
	vals.ts_x_origin = 2000;
	vals.ts_y_origin = -13;
	vals.font = font;
	vals.subwindow_mode = ClipByChildren;
	vals.graphics_exposures = False;
	vals.clip_x_origin = 2003;
	vals.clip_y_origin = 78435;
	vals.dash_offset = 14;

	valuemask =
		GCFunction | GCPlaneMask | GCForeground |
		GCBackground | GCLineWidth | GCLineStyle  |
		GCCapStyle | GCJoinStyle | GCFillStyle |
		GCFillRule | GCTile | GCStipple |
		GCTileStipXOrigin | GCTileStipYOrigin | GCFont |
		GCSubwindowMode | GCGraphicsExposures | GCClipXOrigin |
		GCClipYOrigin	| GCDashOffset	| GCArcMode ;

	gc = XCreateGC(display, DRW(display), valuemask, &vals);
	
	startcall(display);
	if (isdeleted())
		return;
	status = XGetGCValues(display, gc, valuemask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == 0) {
		delete("XGetGCValues() unexpectedly returned zero");
		return;
	} else
		CHECK;

	if( vals.function  == rvals.function  ) {
		CHECK;
	} else {
		report("Expected GCValue function differs from that observed");
		FAIL;
	}
	if( vals.plane_mask  == rvals.plane_mask  ) {
		CHECK;
	} else {
		report("Expected GCValue plane_mask differs from that observed");
		FAIL;
	}
	if( vals.foreground  == rvals.foreground  ) {
		CHECK;
	} else {
		report("Expected GCValue foreground differs from that observed");
		FAIL;
	}
	if( vals.background  == rvals.background  ) {
		CHECK;
	} else {
		report("Expected GCValue background differs from that observed");
		FAIL;
	}
	if( vals.line_width  == rvals.line_width  ) {
		CHECK;
	} else {
		report("Expected GCValue line_width differs from that observed");
		FAIL;
	}
	if( vals.line_style  == rvals.line_style  ) {
		CHECK;
	} else {
		report("Expected GCValue line_style differs from that observed");
		FAIL;
	}
	if( vals.cap_style  == rvals.cap_style  ) {
		CHECK;
	} else {
		report("Expected GCValue cap_style differs from that observed");
		FAIL;
	}
	if( vals.join_style  == rvals.join_style  ) {
		CHECK;
	} else {
		report("Expected GCValue join_style differs from that observed");
		FAIL;
	}
	if( vals.fill_style  == rvals.fill_style  ) {
		CHECK;
	} else {
		report("Expected GCValue fill_style differs from that observed");
		FAIL;
	}
	if( vals.fill_rule  == rvals.fill_rule  ) {
		CHECK;
	} else {
		report("Expected GCValue fill_rule differs from that observed");
		FAIL;
	}
	if( vals.arc_mode  == rvals.arc_mode  ) {
		CHECK;
	} else {
		report("Expected GCValue arc_mode differs from that observed");
		FAIL;
	}
	if( vals.tile  == rvals.tile  ) {
		CHECK;
	} else {
		report("Expected GCValue tile differs from that observed");
		FAIL;
	}
	if( vals.stipple  == rvals.stipple  ) {
		CHECK;
	} else {
		report("Expected GCValue stipple differs from that observed");
		FAIL;
	}
	if( vals.ts_x_origin  == rvals.ts_x_origin  ) {
		CHECK;
	} else {
		report("Expected GCValue ts_x_origin differs from that observed");
		FAIL;
	}
	if( vals.ts_y_origin  == rvals.ts_y_origin  ) {
		CHECK;
	} else {
		report("Expected GCValue ts_y_origin differs from that observed");
		FAIL;
	}
	if( vals.font  == rvals.font  ) {
		CHECK;
	} else {
		report("Expected GCValue font differs from that observed");
		FAIL;
	}
	if( vals.subwindow_mode  == rvals.subwindow_mode  ) {
		CHECK;
	} else {
		report("Expected GCValue subwindow_mode differs from that observed");
		FAIL;
	}
	if( vals.graphics_exposures  == rvals.graphics_exposures  ) {
		CHECK;
	} else {
		report("Expected GCValue graphics_exposures differs from that observed");
		FAIL;
	}
	if( vals.clip_x_origin  == rvals.clip_x_origin  ) {
		CHECK;
	} else {
		report("Expected GCValue clip_x_origin differs from that observed");
		FAIL;
	}
	if( vals.clip_y_origin  == rvals.clip_y_origin  ) {
		CHECK;
	} else {
		report("Expected GCValue clip_y_origin differs from that observed");
		FAIL;
	}
	if( vals.dash_offset  == rvals.dash_offset  ) {
		CHECK;
	} else {
		report("Expected GCValue dash_offset differs from that observed");
		FAIL;
	}

	CHECKPASS(23);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo	*vp;
XGCValues	vals;
Pixmap		tile, stipple;
Status		status;
Font 		font;
XFontStruct	*fontinfo;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetGCValues-2.(A)");
	report_assertion("When the valuemask argument is a bitwise OR of any of");
	report_assertion("GCFunction, GCPlaneMask, GCForeground, GCBackground,");
	report_assertion("GCLineWidth, GCLineStyle, GCCapStyle, GCJoinStyle,");
	report_assertion("GCFillStyle, GCFillRule, GCTile, GCStipple,");
	report_assertion("GCTileStipXOrigin, GCTileStipYOrigin, GCFont,");
	report_assertion("GCSubwindowMode, GCGraphicsExposures, GCClipXOrigin,");
	report_assertion("GCCLipYOrigin, GCDashOffset, or GCArcMode, then a call to");
	report_assertion("XGetGCValues returns a non-zero value.");

	report_strategy("Call XGetGCValues with a valuemask of");
	report_strategy("	GCFunction | GCPlaneMask | GCForeground |");
	report_strategy("	GCBackground | GCLineWidth | GCLineStyle  |");
	report_strategy("	GCCapStyle | GCJoinStyle | GCFillStyle |");
	report_strategy("	GCFillRule | GCTile | GCStipple |");
	report_strategy("	GCTileStipXOrigin | GCTileStipYOrigin | GCFont |");
	report_strategy("	GCSubwindowMode | GCGraphicsExposures | GCClipXOrigin |");
	report_strategy("	GCClipYOrigin	| GCDashOffset	| GCArcMode .");
	report_strategy("Verify that XGetGCValues returns non-zero.");

	tpstartup();
	setargs();
	if( (fontinfo = XLoadQueryFont(display, FONTNAME)) == (XFontStruct *) 0) {
		delete("Could not load font %s",FONTNAME);
		return;
	} else
		CHECK;

	/*
	 * Find the visual information associated with the default
	 * visual, since we will be testing using the root window.
	 */
	resetvinf(VI_WIN);
	do
		nextvinf(&vp);	
	while(vp->visual != DefaultVisual(display, DefaultScreen(display)));

	font = fontinfo -> fid;
	tile = makepixm(display, vp);
	stipple = XCreatePixmap(display, DRW(display), 1, 1, 1);
	vals.function = GXxor;
	vals.plane_mask = 42;
	vals.foreground = 1;
	vals.background = 0;
	vals.line_width = 10;
	vals.line_style = LineOnOffDash;
	vals.cap_style = CapProjecting;
	vals.join_style = JoinBevel;
	vals.fill_style = FillStippled;
	vals.fill_rule =  WindingRule;
	vals.arc_mode = ArcChord;
	vals.tile = tile;
	vals.stipple = stipple;
	vals.ts_x_origin = 2000;
	vals.ts_y_origin = -13;
	vals.font = font;
	vals.subwindow_mode = ClipByChildren;
	vals.graphics_exposures = False;
	vals.clip_x_origin = 2003;
	vals.clip_y_origin = 78435;
	vals.dash_offset = 14;

	valuemask =
		GCFunction | GCPlaneMask | GCForeground |
		GCBackground | GCLineWidth | GCLineStyle  |
		GCCapStyle | GCJoinStyle | GCFillStyle |
		GCFillRule | GCTile | GCStipple |
		GCTileStipXOrigin | GCTileStipYOrigin | GCFont |
		GCSubwindowMode | GCGraphicsExposures | GCClipXOrigin |
		GCClipYOrigin	| GCDashOffset	| GCArcMode ;

	gc = XCreateGC(display, DRW(display), valuemask, &vals);
	
	startcall(display);
	if (isdeleted())
		return;
	status = XGetGCValues(display, gc, valuemask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == 0) {
		report("XGetGCValues() did not return non-zero.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XGCValues vals;
Status status;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetGCValues-3.(A)");
	report_assertion("When the valuemask argument is other than a bitwise OR of");
	report_assertion("any of GCFunction, GCPlaneMask, GCForeground,");
	report_assertion("GCBackground, GCLineWidth, GCLineStyle, GCCapStyle,");
	report_assertion("GCJoinStyle, GCFillStyle, GCFillRule, GCTile, GCStipple,");
	report_assertion("GCTileStipXOrigin, GCTileStipYOrigin, GCFont,");
	report_assertion("GCSubwindowMode, GCGraphicsExposures, GCClipXOrigin,");
	report_assertion("GCCLipYOrigin, GCDashOffset, or GCArcMode, then a call to");
	report_assertion("XGetGCValues returns zero.");

	report_strategy("Call XGetGCValues with a valuemask of  GCClipmask | GCForeground.");
	report_strategy("Verify that XGetGCValues returns zero.");
	report_strategy("Call XGetGCValues with a valuemask of  GCDashList | GCForeground.");
	report_strategy("Verify that XGetGCValues returns zero.");

	tpstartup();
	setargs();
	vals.foreground = 1;
	vals.clip_mask = None;
	vals.dashes = 1;
	valuemask = GCClipMask | GCDashList | GCForeground;
	gc = XCreateGC(display,DRW(display), valuemask, &vals);
	
	startcall(display);
	if (isdeleted())
		return;
	status = XGetGCValues(display, gc, valuemask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != 0) {
		report("XGetGCValues() did not return zero with GCClipMask in valuemask.");
		FAIL;
	} else
		CHECK;

	valuemask = GCDashList | GCForeground;
	
	startcall(display);
	if (isdeleted())
		return;
	status = XGetGCValues(display, gc, valuemask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != 0) {
		report("XGetGCValues() did not return zero with GCDashList in valuemask.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
