/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XFreeColors(display, colormap, pixels, npixels, planes)
 *   Display *display;
 *   Colormap colormap;
 *   unsigned long *pixels;
 *   int npixels;
 *   unsigned long planes;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XFreeColors	1
char    *TestName = "XFreeColors";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XFreeColors function
 */
static Display *display;
static Colormap colormap;
static unsigned long *pixels;
static int npixels;
static unsigned long planes;


unsigned long dummypix;

#define ENOUGH_TIME	100

static
Bool munch(size_in_out, pixels, npix)
	int	*size_in_out;
	unsigned long *pixels;
	int	npix;
{
	int i;
	int sz = 0;
	unsigned long junk;
	int max_sz = (*size_in_out) * ENOUGH_TIME;

	for(i=0; i < npix; i++, pixels++) {
		if(XAllocColorCells(display, colormap, False, 0L, 0, pixels, 1) == False) {
			delete("Could not allocate %d pixels with AllocColorCells (colormap size >= %d, done %d)", npix, *size_in_out, i);
			return False;
		}
	}

	sz = i;

	for(i=0; XAllocColorCells(display, colormap, False, 0L, 0, &junk, 1); i++) {
		if (i > max_sz) {
			delete("Still allocating after %d cells allocated in a colormap of size %d cells.",
				sz + i, *size_in_out);
			return False;
		}
	}

	trace("Rest of colormap allocated (%d + %d = %d cells. Notional size = %d cells).",
		sz, i, sz + i, *size_in_out);
	sz += i;
	*size_in_out = sz;
	return True;
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	pixels = &dummypix;
	npixels = 1;
	planes = 0L;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo 	*vp;
XColor		color1, exactcol;
char		*goodname;
int		size;
unsigned long	pixel;
unsigned long	*pixels;
unsigned long	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XFreeColors-1.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: A call to XFreeColors function frees");
	report_assertion("the colourmap entries obtained by ORing the npixels pixel");
	report_assertion("values specified in the pixels argument with zero or more of");
	report_assertion("the planes specified in the planes argument that have been");
	report_assertion("allocated by the client using XAllocColor, XAllocNamedColor,");
	report_assertion("XAllocColorCells or XAllocColorPlanes.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Allocate 1 colormap cell with XAllocNamedColor.");
	report_strategy("  Allocate the remaining colourmap cells with XAllocColorCells.");
	report_strategy("  Free the cell allocated by XAllocNamedColor with XFreeColors.");
	report_strategy("  Allocate 1 colourmap cell with XAllocColorCells.");
	report_strategy("  Verify that the call did not return False.");
	report_strategy("");
	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Allocate 1 colormap cell with XAllocColor.");
	report_strategy("  Allocate the remaining colourmap cells with XAllocColorCells.");
	report_strategy("  Free the cell allocated by XAllocColor with XFreeColors.");
	report_strategy("  Allocate 1 colourmap cell with XAllocColorCells.");
	report_strategy("  Verify that the call did not return False.");
	report_strategy("");
	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Allocate the entire colourmap with XAllocColorCells.");
	report_strategy("  Free a cell allocated by XAllocColorCells with XFreeColors.");
	report_strategy("  Allocate 1 colourmap cell with XAllocColorCells.");
	report_strategy("  Verify that the call did not return False.");
	report_strategy("");

	tpstartup();
	setargs();

	if((vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	if((goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0L) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp);) {

		trace("XAllocNamedColor().");
		colormap = makecolmap(display, vp->visual, AllocNone);

		if(XAllocNamedColor(display, colormap, goodname,  &color1, &exactcol) == False) {
			delete("XAllocNamedColor() failed.");
			return;
		}

		size = maxsize(vp);

		if (!munch(&size, &pixel, 1)) {
			return; /* delete() already called in munch */
		} else
			CHECK;

		pixels = &color1.pixel;
		npixels = 1;
		planes = 0L;

		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(geterr() == Success)
			CHECK;

		if(XAllocColorCells(display, colormap, False, 0L, 0, &pixel, 1) == False) {
			report("XFreeColors() did not free a cell allocated by XAllocNamedColor().");
			FAIL;
		} else
			CHECK;

		freereg();
	}	



	for(resetsupvis(vmask); nextsupvis(&vp);) {

		trace("XAllocColor().");
		colormap = makecolmap(display, vp->visual, AllocNone);

		if(XAllocColor(display, colormap, &color1) == False) {
			delete("XAllocColor() failed.");
			return;
		}

		size = maxsize(vp);

		if (!munch(&size, &pixel, 1)) {
			return; /* delete() already called in munch */
		} else
			CHECK;

		pixels = &color1.pixel;
		npixels = 1;
		planes = 0L;

		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(geterr() == Success)
			CHECK;

		if(XAllocColorCells(display, colormap, False, 0L, 0, &pixel, 1) == False) {
			report("XFreeColors() did not free a cell allocated by XAllocColor().");
			FAIL;
		} else
			CHECK;

		freereg();
	}	


	for(resetsupvis(vmask); nextsupvis(&vp);) {
		trace("XAllocColorCells().");
		colormap = makecolmap(display, vp->visual, AllocNone);

		size = maxsize(vp);

		if (!munch(&size, &pixel, 1)) {
			return; /* delete() already called in munch */
		} else
			CHECK;

		pixels = &pixel;
		npixels = 1;
		planes = 0L;

		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(geterr() == Success)
			CHECK;

		if(XAllocColorCells(display, colormap, False, 0L, 0, &pixel, 1) == False) {
			report("XFreeColors() did not free a cell allocated by XAllocColorCells().");
			FAIL;
		} else
			CHECK;

		freereg();
	}	



	CHECKPASS(nsupvis() * 3 * 3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display		*disp2;
XVisualInfo 	*vp;
XColor		color1;
int		size;
unsigned long	pixel;
unsigned long	*pixels;
unsigned long	vmask = (1<<PseudoColor)|(1<<GrayScale)|(1<<DirectColor);
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XFreeColors-2.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: When a read-only colourmap entry has");
	report_assertion("been allocated by another client, then the colourmap entry");
	report_assertion("is not freed on a call to XFreeColors.");

	report_strategy("For each of the visual classes DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Create a second client with XOpenDisplay().");
	report_strategy("  Allocate a r/o cell with XAllocColor for the first client.");
	report_strategy("  Allocate a r/o cell using the returned rgb values with XAllocColor for the second client.");
	report_strategy("  Allocate the rest of the colormap with XAllocColorCells.");
	report_strategy("  Free the cell for the first client with XFreeColors.");
	report_strategy("  Verify that the colormap is full with XAllocColorCell.");
	report_strategy("  Free the cell for the second client with XFreeColors.");
	report_strategy("  Verify that the cell was freed with XAllocColorCell.");

	tpstartup();
	setargs();

	if((vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp);) {

		colormap = makecolmap(display, vp->visual, AllocNone);

		if((disp2 = opendisplay()) == (Display *) 0) {
			delete("Could not open the display.");
			return;
		}

		if(XAllocColor(Dsp, colormap, &color1) == False) {
			delete("XAllocColor() failed for second client.");
			return;
		}

		if(XAllocColor(disp2, colormap, &color1) == False) {
			delete("XAllocColor() failed for first client.");
			return;
		}

		size = maxsize(vp);

		if (!munch(&size, &pixel, 1)) {
			return; /* delete() already called in munch */
		} else
			CHECK;

		display = Dsp;
		pixels = &color1.pixel;
		npixels = 1;
		planes = 0L;

		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(geterr() == Success)
			CHECK;

		if(XAllocColorCells(Dsp, colormap, False, 0L, 0, &pixel, 1) != False) {
			report("Shared cell was freed while allocted to another client.");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(3*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo 	*vp;
XColor		color1;
int		size, i, refs;
unsigned long	pixel;
unsigned long	*pixels;
unsigned long	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XFreeColors-3.(A)");
	report_assertion("If the visual class DirectColor, PseudoColor or GrayScale");
	report_assertion("is supported: When a read-only colourmap entry has been");
	report_assertion("allocated more than once by the client, and XFreeColors has");
	report_assertion("been called one less time than the colormap entry was");
	report_assertion("allocated, then a call to XFreeColors frees the colormap");
	report_assertion("entry.");

	report_strategy("For each of the visual classes DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Allocate a cell maxsize(vp) times with XAllocColor.");
	report_strategy("  Allocate the rest of the colourmap with XAllocColorCells.");
	report_strategy("  Repeat maxsize(vp)-1 times:");
	report_strategy("    Deallocate the colourcell with XFreeColours.");
	report_strategy("    Verify that the cell is not deallocated with XAllocColorCells.");
	report_strategy("  Deallocate the colourcell with XFreeColours.");
	report_strategy("  Verify that the colourcell was deallocated with XAllocColors.");

	tpstartup();
	setargs();

	if((vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp);) {

		colormap = makecolmap(display, vp->visual, AllocNone);

		size = maxsize(vp);

		refs = size-1;
		color1.red = color1.green = color1.blue = 0;
		for(i=0; i < refs; i++)
			if(XAllocColor(display, colormap, &color1) == False) {
				delete("XAllocColor() failed (Iteration %d).", i);
				return;
			}

		if (!munch(&size, &pixel, 1)) {
			return; /* delete() already called in munch */
		} else
			CHECK;

		for(i=0; i < refs-1; i++) {
			pixels = &color1.pixel;
			npixels = 1;
			planes = 0L;
			startcall(display);
			if (isdeleted())
				return;
			XFreeColors(display, colormap, pixels, npixels, planes);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
		}

		if(XAllocColorCells(display, colormap, False, 0L, 0, &pixel, 1) != False) {
			delete("XAllocColorCells() did not fail with a full colourmap.");
			return;
		} else
			CHECK;

		pixels = &color1.pixel;
		npixels = 1;
		planes = 0L;
		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(XAllocColorCells(display, colormap, False, 0L, 0, &pixel, 1) == False) {
			report("XFreeColors() did not free a cell allocated by XAllocColor().");
			FAIL;
		} else
			CHECK;

		freereg();
	}	

	CHECKPASS(3*nsupvis());
  
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display		*disp2;
XVisualInfo 	*vp;
XColor		color;
int		size;
unsigned long	pixel;
unsigned long	*pixels, *cptr, *ptr;
unsigned long	vmask = (1<<DirectColor)|(1<<PseudoColor)|(1<<GrayScale);
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XFreeColors-4.(A)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor or");
	report_assertion("GrayScale is supported: When one or more pixels cannot be");
	report_assertion("freed, and one or more pixels can be freed, then the pixels");
	report_assertion("that are allocated by the client in the colourmap that can");
	report_assertion("be freed are freed.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Create a new client with XOpenDisplay.");
	report_strategy("  Allocate a r/o cell for the new client with XAllocColor.");
	report_strategy("  Allocate the rest of the colormap for the first client with XAllocColorCells.");
	report_strategy("  Free the entire colormap with the second client with XFreeColors.");
	report_strategy("  Verify that only one cell was freed with XAllocColorCells.");

	tpstartup();
	setargs();

	if((vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp);) {

		disp2 = opendisplay();
		colormap = makecolmap(disp2, vp->visual, AllocNone);

		size = maxsize(vp);

		if((cptr = (unsigned long *) malloc(size * sizeof(unsigned long))) == (unsigned long *)0) {
			delete("malloc(%u) failed.", size * sizeof(unsigned long));
			return;
		}

		ptr = cptr;
		color.red = color.green = color.blue = 0;
		if(XAllocColor(disp2, colormap, &color) == False) {
			delete("XAllocColor() failed for client 2");
			return;
		}

		*ptr++ = color.pixel;
		
		if (!munch(&size, ptr, size-1)) {
			return; /* delete() already called in munch */
		} else
			CHECK;

		pixels = cptr;
		npixels = size + 1;
		planes = 0L;

		startcall(disp2);
		XFreeColors(disp2, colormap, pixels, npixels, planes);
		endcall(disp2);
		/* should be BadAccess! Often not on R4 */
		if (geterr() != BadAccess) {
			report("Got %s, expecting BadAccess", errorname(geterr()));
			FAIL;
		} else
			CHECK;

		if(XAllocColorCells(display, colormap, False, 0L, 0, &pixel, 1) == False) {
			report("XFreeColors() did not free a cell allocated by XAllocColor().");
			FAIL;
		} else
			CHECK;

		if(XAllocColorCells(display, colormap, False, 0L, 0, &pixel, 1) != False) {
			report("Colormap was not completely allocated.");
			FAIL;
		}
		
		free(cptr);
		freereg();
	}

	CHECKPASS(3*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XVisualInfo	*vp;
int		nreds, ngreens, nblues;
int		reds, greens, blues;
unsigned long	pr[2], rr, gr, br;
unsigned long	tpr[2], trr, tgr, tbr;
unsigned long	vmask = (1<<DirectColor);
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XFreeColors-5.(A)");
	report_assertion("If the visual class DirectColor is supported: When all");
	report_assertion("related colormap entries are already freed, then a call to");
	report_assertion("XFreeColors with a particular pixel value allows that pixel");
	report_assertion("value to be allocated by a subsequent call to");
	report_assertion("XAllocColorPlanes.");

	report_strategy("For the visual class DirectColor:");
	report_strategy("  Create a colourmap with XCreateColormap.");
	report_strategy("  Allocate the entire colormap with 2 pixels and red_mask-1, green_mask-1");
	report_strategy("    and blue_mask-1 red, green and blue planes with XAllocColorPlanes.");
	report_strategy("  Verify that further allocation does not succeed with XAllocColorPlanes.");
	report_strategy("  Free pixel2 and red|green|blue planes.");
	report_strategy("  Allocate 1 pixel with red_mask-1, green_mask-1 and blue_mask-1 planes.");
	report_strategy("  Verify that the call did not return False.");

	tpstartup();
	setargs();
	if((vmask = visualsupported(display, vmask)) == 0L) {
		UNSUPPORTED;
		return;
	}
	resetsupvis(vmask);
	nextsupvis(&vp);

	nreds = bitcount(vp->red_mask);
	ngreens = bitcount(vp->green_mask);
	nblues = bitcount(vp->blue_mask);

	reds = nreds - 1;
	greens = ngreens - 1;
	blues = nblues - 1;

	colormap = makecolmap(display, vp->visual, AllocNone);

	if((XAllocColorPlanes(display, colormap, False, pr, 2, reds, greens, blues, &rr, &gr, &br)) == False) {
		delete("XAllocColorPlanes failed.");
		return;
	} else
		CHECK;

	if((XAllocColorPlanes(display, colormap, False, tpr, 1, 0, 0, 0, &trr, &tgr, &tbr)) != False) {
		delete("Allocated colormap was not completely filled");
		return;
	} else
		CHECK;

	pixels = pr+1;
	npixels = 1;
	planes = rr | gr | br;
	startcall(display);
	if (isdeleted())
		return;
	XFreeColors(display, colormap, pixels, npixels, planes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if((XAllocColorPlanes(display, colormap, False, pr, 1, reds, greens, blues, &rr, &gr, &br)) == False) {
		trace("Freed colormap cells could not be re-allocated.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XVisualInfo	*vp;
XColor		color;
unsigned long	pixel[2];
unsigned long	vmask = 0L;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XFreeColors-6.(A)");
	report_assertion("When a specified pixel is not a valid entry in the colormap");
	report_assertion("argument, then a BadValue error occurs.");

	report_strategy("For all supported visual types:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Free a pixel with pixel value of 2power(longbits)-1 with XFreeColors.");
	report_strategy("  Verify that a BadValue error occurred.");
	report_strategy("");
	report_strategy("  Create a colormap using XCreateColormap with alloc set to AllocNone.");
	report_strategy("  Allocate one readonly cell in the colormap with XAllocColor.");
	report_strategy("  Construct an array with the same pixel in both elements.");
	report_strategy("  Deallocate the colormap cells indicated by the array with XFreeColors.");
	report_strategy("  Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	if((vmask = visualsupported(display, vmask)) == 0L) {
		delete("No visuals reported as supported");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		pixel[0] = ~0L;
		pixels = pixel;
		npixels = 1;
		planes = 0L;
		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadValue)
			CHECK;

		colormap = makecolmap(display, vp->visual, AllocNone);
		if(XAllocColor(display, colormap, &color) == False) {
			delete("XAllocColor Failed.");
			return;
		}

		pixel[0] = color.pixel;
		pixel[1] = ~0L;
		pixels = pixel;
		npixels = 2;
		planes = 0L;
		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadValue)
			CHECK;

	}	

	CHECKPASS(2*nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAcc2.mc */
/* End of included file error/EAcc2.mc */

static void t007(){

XVisualInfo	*vp;
unsigned long	pixel[1];
unsigned long	vmask = 0L;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XFreeColors-7.(A)");
	report_assertion("When an attempt to free a colormap entry not allocated by");
	report_assertion("the client is made, then a BadAccess error occurs.");

	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Free a pixel with pixel value = 0 with XFreeColors.");
	report_strategy("  Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	if((vmask = visualsupported(display, vmask)) == 0L) {
		delete("No visuals reported as supported");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		pixel[0] = 0;
		pixels = pixel;
		npixels = 1;
		planes = 0L;
		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != BadAccess) {
			report("Got %s, Expecting BadAccess", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadAccess)
			CHECK;
	}	

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XFreeColors-8.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	XFreeColors(display, colormap, pixels, npixels, planes);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

static void t009(){

XVisualInfo	*vp;
XColor		color;
int		errval;
unsigned long	pixel[3];
unsigned long	vmask = 0L;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XFreeColors-9.(A)");
	report_assertion("When more than one pixel value is not a valid entry in the");
	report_assertion("colormap argument, then a BadValue error occurs which will");
	report_assertion("report any one of the invalid pixel values.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colormap using XCreateColormap with alloc set to AllocNone.");
	report_strategy("  Allocate one readonly cell in the colormap with XAllocColor.");
	report_strategy("  Construct an array with two invalid pixel values and one valid pixel value.");
	report_strategy("  Deallocate the colormap cells indicated by the array with XFreeColors.");
	report_strategy("  Verify that a BadValue error occurred.");
	report_strategy("  Verify that the bad value reported was one of the invalid pixel array elements.");

	tpstartup();
	setargs();
	if((vmask = visualsupported(display, vmask)) == 0L) {
		delete("No visuals reported as supported");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {

		colormap = makecolmap(display, vp->visual, AllocNone);
		if(XAllocColor(display, colormap, &color) == False) {
			delete("XAllocColor Failed.");
			return;
		}
		pixel[0] = ~0L;
		pixel[1] = color.pixel;
		pixel[2] = ~0L;
		pixels = pixel;
		npixels = 3;
		planes = 0L;
		startcall(display);
		if (isdeleted())
			return;
		XFreeColors(display, colormap, pixels, npixels, planes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadValue) {
			errval = getbadvalue();
			if( (errval != -1) && (errval != -2) ) {
				report("Erroneous value was reported as %d, instead of -1 or -2", errval);
				FAIL;
			} else
				CHECK;
		}

	}
	CHECKPASS(nsupvis());


	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
