/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   char *
 *   XrmQuarkToString(quark)
 *   XrmQuark quark;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmQuarkToString	1
char    *TestName = "XrmQuarkToString";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmQuarkToString function
 */
static XrmQuark quark;


#define NITER	100

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	quark = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *s="qts_one";
char *ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmQuarkToString-1.(A)");
	report_assertion("A call to XrmQuarkToString returns a pointer to the string");
	report_assertion("that corresponds to the quark.");

	report_strategy("Call XrmStringToQuark to allocate a quark for a string.");
	report_strategy("Call XrmQuarkToString to obtain the representation for the quark.");

	tpstartup();
	setargs();
/* Call XrmStringToQuark to allocate a quark for a string. */
	quark = XrmStringToQuark( s );

/* Call xname to obtain the representation for the quark. */
	startcall(Dsp);
	if (isdeleted())
		return;
	ret = XrmQuarkToString(quark);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret==(char *)NULL || strcmp(s,ret)) {
		FAIL;
		report("%s did not return the representation for the quark.",
			TestName);
		report("Expected representation: %s", s);
		report("Returned representation: %s",
			(ret==(char *)NULL?"NULL pointer":ret));
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

char *ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmQuarkToString-2.(A)");
	report_assertion("When no string exists for a quark, then a call to");
	report_assertion("XrmQuarkToString returns NULL.");

	report_strategy("Create a unique quark which has no string representation.");
	report_strategy("Call XrmQuarkToString to obtain the representation for the quark.");
	report_strategy("Verify that a NULL pointer was returned.");

	tpstartup();
	setargs();
/* Create a unique quark which has no string representation. */
	quark = XrmUniqueQuark();

/* Call xname to obtain the representation for the quark. */
	startcall(Dsp);
	if (isdeleted())
		return;
	ret = XrmQuarkToString(quark);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a NULL pointer was returned. */
	if (ret != (char *)NULL) {
		FAIL;
		report("%s returned unexpected value with a quark with",
			TestName);
		report("no string representation.");
		report("Expected value: NULL pointer");
		report("Returned value: '%s'", ret);
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int	i;
char	*ret, *save_addr;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmQuarkToString-3.(A)");
	report_assertion("When a call to XrmQuarkToString returns a non-NULL value");
	report_assertion("for string future calls to the function with the same value");
	report_assertion("for quark shall return pointer to the same string.");


	tpstartup();
	setargs();
	
	/* Create a unique quark which has no string representation. */
	tet_infoline("PREP: Create a unique quark.");
	quark = XrmUniqueQuark();

	/* Call xname to obtain the representation for the quark. */
	tet_infoline("PREP: Save address of the value returned on first call.");
	startcall(Dsp);
	if (isdeleted())
		return;
	save_addr = XrmQuarkToString(quark);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Call xname to obtain another quark. */
	tet_infoline("TEST: Identical pointers are returned by XrmQuarkToString");
	for (i = 0; i < NITER; i++)
	{
		startcall(Dsp);
		if (isdeleted())
			return;
		ret = XrmQuarkToString(quark);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (ret != save_addr)
		{
			FAIL;
			report("%s returned non-identical addresses.",
				TestName);
			report("Expected: 0x%x", (int)save_addr);
			report("Got     : 0x%x", (int)ret);
		}
	}
	tet_result(TET_PASS);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
