/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y)
 *   Display	*display;
 *   Window	src_w;
 *   Window	dest_w;
 *   int 	src_x;
 *   int 	src_y;
 *   unsigned int 	src_width;
 *   unsigned int 	src_height;
 *   int 	dest_x;
 *   int 	dest_y;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XWarpPointer	1
char    *TestName = "XWarpPointer";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW src_w
#define A_DRAWABLE src_w
#define A_WINDOW2 dest_w
#define A_DRAWABLE2 dest_w


/*
 * Arguments to the XWarpPointer function
 */
static Display	*display;
static Window	src_w;
static Window	dest_w;
static int 	src_x;
static int 	src_y;
static unsigned int 	src_width;
static unsigned int 	src_height;
static int 	dest_x;
static int 	dest_y;



#define	SRC_X	7
#define	SRC_Y	10
#define	SRC_WIDTH	20
#define	SRC_HEIGHT	31
#define	DEST_X	11
#define	DEST_Y	13

#define	POS_ABS	1
#define	POS_REL	2

struct	coord {
	int 	x;
	int 	y;
};

/*
 * Get the current position of the pointer.  If type is POS_REL this
 * is relative to the given window.  For a type POS_ABS the coordinates
 * are absolute.
 */
static void
getpos(w, co, type)
Window	w;
struct	coord	*co;
int 	type;
{
Window	root, child;
unsigned int 	mask;
int 	xroot, yroot;
int 	status;

	if (w == None)
		w = DRW(Dsp);

	status = XQueryPointer(Dsp, w, &root, &child, &xroot, &yroot, &co->x, &co->y, &mask);
	if (status == False) {
		delete("Could not get pointer position");
		return;
	}

	if (type == POS_ABS) {
		co->x = xroot;
		co->y = yroot;
	}
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	src_w = 0;
	dest_w = 0;
	src_x = SRC_X;
	src_y = SRC_Y;
	src_width = SRC_WIDTH;
	src_height = SRC_HEIGHT;
	dest_x = DEST_X;
	dest_y = DEST_Y;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	src_w = ErrdefWindow;
	dest_w = ErrdefWindow;
}

static void t001(){

struct	coord	old;
struct	coord	new;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XWarpPointer-1.(A)");
	report_assertion("When dest_w is None, then a call to XWarpPointer moves the");
	report_assertion("pointer by the offsets dest_x, dest_y relative to the");
	report_assertion("current position of the pointer.");

	report_strategy("Get current position of pointer.");
	report_strategy("Set dest_w to None.");
	report_strategy("Call XWarpPointer.");
	report_strategy("Verify that new position is offset from old by dest_x, dest_y.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 100, 100);

	dest_w = None;
	src_w = None;

	getpos(None, &old, POS_ABS);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	getpos(None, &new, POS_ABS);

	if (dest_x == 0 || dest_y == 0)
		delete("Setup error of destination coordinates");

	if (new.x == old.x + dest_x)
		CHECK;
	else {
		report("X position of pointer incorrect - was %d, expecting %d",
			new.x, old.x + dest_x);
		FAIL;
	}

	if (new.y == old.y + dest_y)
		CHECK;
	else {
		report("Y position of pointer incorrect - was %d, expecting %d",
			new.y, old.y + dest_y);
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

struct	coord	pos;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XWarpPointer-2.(A)");
	report_assertion("When dest_w is a window and src_w is None, then a call to");
	report_assertion("XWarpPointer moves the pointer to the offsets dest_x,");
	report_assertion("dest_y relative to the origin of dest_w.");

	report_strategy("Create window for dest_w.");
	report_strategy("Set src_w to None.");
	report_strategy("Call XWarpPointer.");
	report_strategy("Verify that pointer is at (dest_x,dest_y) from origin of dest_w.");

	tpstartup();
	setargs();
	warppointer(display, DRW(display), 0, 0);

	dest_w = defwin(display);
	src_w = None;

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	getpos(dest_w, &pos, POS_REL);

	if (dest_x == pos.x && dest_y == pos.y)
		CHECK;
	else {
		report("Position relative to destination window was incorrect");
		report("  position was (%d, %d), expecting (%d, %d)",
			pos.x, pos.y, dest_x, dest_y);
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

struct	coord	pos;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XWarpPointer-3.(A)");
	report_assertion("When dest_w and src_w are windows and the pointer is within");
	report_assertion("the specified rectangle of src_w, then a call to");
	report_assertion("XWarpPointer moves the pointer to the offsets dest_x,");
	report_assertion("dest_y relative to the origin of dest_w.");

	report_strategy("Create window dest_w.");
	report_strategy("Create window src_w.");
	report_strategy("Move pointer to within the specified rectange of src_w.");
	report_strategy("Call XWarpPointer.");
	report_strategy("Verify that pointer moves to offset (dest_x, dest_y) from origin of dest_w.");

	tpstartup();
	setargs();
	dest_w = defwin(display);
	src_w = defwin(display);

	warppointer(display, src_w, src_x, src_y);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	getpos(dest_w, &pos, POS_REL);

	if (pos.x == dest_x && pos.y == dest_y)
		CHECK;
	else {
		report("Pointer not positioned correctly when pointer in source rectangle");
		report("  position was (%d, %d), expecting (%d, %d)",
			pos.x, pos.y, dest_x, dest_y);
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

PointerPlace	*pplace;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XWarpPointer-4.(A)");
	report_assertion("When dest_w and src_w are windows and the pointer is not");
	report_assertion("within the specified rectangle of src_w, then a call to");
	report_assertion("XWarpPointer does not move the pointer.");

	report_strategy("Create window dest_w.");
	report_strategy("Create window src_w.");
	report_strategy("Move pointer outside the specified rectange of src_w.");
	report_strategy("Call XWarpPointer.");
	report_strategy("Verify that the pointer is not moved.");

	tpstartup();
	setargs();
	dest_w = defwin(display);
	src_w = defwin(display);

	pplace = warppointer(display, src_w, (int)(src_x+src_width+2), src_y);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (pointermoved(display, pplace)) {
		report("Pointer was moved when outside the source rectangle");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

unsigned int 	width, height;
struct	coord	pos;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XWarpPointer-5.(A)");
	report_assertion("When src_height is zero, then it is replaced with the");
	report_assertion("current height of src_w minus src_y.");

	report_strategy("Create window src_w.");
	report_strategy("Create window dest_w.");
	report_strategy("Set src_height to 0.");
	report_strategy("Position pointer in src_w such that it is inside source rectangle.");
	report_strategy("Call XWarpPointer.");
	report_strategy("Verify that pointer is moved.");

	tpstartup();
	setargs();
	src_w = defwin(display);
	dest_w = defwin(display);
	src_height = 0;

	getsize(display, src_w, &width, &height);

	warppointer(display, src_w, src_x+3, (int)height-3);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	getpos(dest_w, &pos, POS_REL);
	if (pos.x == dest_x && pos.y == dest_y)
		CHECK;
	else {
		report("Pointer not moved correctly when pointer in source rectangle");
		report("  and src_height 0 - position was (%d, %d), expecting (%d, %d)",
			pos.x, pos.y, dest_x, dest_y);
		FAIL;
	}

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

unsigned int 	width, height;
struct	coord	pos;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XWarpPointer-6.(A)");
	report_assertion("When src_width is zero, then it is replaced with the");
	report_assertion("current width of src_w minus src_x.");

	report_strategy("Create window src_w.");
	report_strategy("Create window dest_w.");
	report_strategy("Set src_width to 0.");
	report_strategy("Position pointer in src_w such that it is inside source rectangle.");
	report_strategy("Call XWarpPointer.");
	report_strategy("Verify that pointer is moved.");

	tpstartup();
	setargs();
	src_w = defwin(display);
	dest_w = defwin(display);
	src_width = 0;

	getsize(display, src_w, &width, &height);

	warppointer(display, src_w, (int)width-3, src_y+3);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	getpos(dest_w, &pos, POS_REL);
	if (pos.x == dest_x && pos.y == dest_y)
		CHECK;
	else {
		report("Pointer not moved correctly when pointer in source rectangle");
		report("  and src_width 0 - position was (%d, %d), expecting (%d, %d)",
			pos.x, pos.y, dest_x, dest_y);
		FAIL;
	}

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XEvent	ev;
XMotionEvent	good;
struct	coord	pos;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XWarpPointer-7.(A)");
	report_assertion("A call to XWarpPointer generates events as though the");
	report_assertion("pointer position had been instantaneously moved by the user.");

	report_strategy("Create dest_w.");
	report_strategy("Position pointer at 0,0 in dest_w.");
	report_strategy("Enable events.");
	report_strategy("Call XWarpPointer to move pointer within window.");
	report_strategy("Verify that only one motion event is generated.");

	tpstartup();
	setargs();
	dest_w = defwin(display);
	src_w = None;

	warppointer(display, dest_w, 0, 0);

	XSelectInput(display, dest_w, PointerMotionMask);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(good, display, MotionNotify);
	good.window = dest_w;
	good.root = DRW(display);
	good.subwindow = None;
	good.time = 0;
	good.x = dest_x;
	good.y = dest_y;
	good.state = 0;
	good.is_hint = False;
	good.same_screen = True;

	getpos(None, &pos, POS_ABS);
	good.x_root = pos.x;
	good.y_root = pos.y;

	n = getevent(display, &ev);
	if (n > 1) {
		report("More than one event generated");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&good, &ev))
		FAIL;
	else
		CHECK;
	
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Window	confine;
Window	grabwin;
struct	coord	pos;
unsigned int 	width, height;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XWarpPointer-8.(A)");
	report_assertion("When an active pointer grab is in progress and the pointer");
	report_assertion("is within the confine_to window, then a call to XWarpPointer");
	report_assertion("will only move the pointer as far as the closest edge of the");
	report_assertion("confine_to window.");

	report_strategy("Create confine_to window.");
	report_strategy("Create dest_w window.");
	report_strategy("Call XGrabPointer to actively grab the pointer with confine_to set.");
	report_strategy("Attempt to move pointer into dest_w window with XWarpPointer.");
	report_strategy("Verify that pointer is still within the confine_to window.");

	tpstartup();
	setargs();
	confine = defwin(display);
	dest_w = defwin(display);
	grabwin = defwin(display);
	src_w = None;

	/* Set border to zero so that containment size is just width and height */
	XSetWindowBorderWidth(display, confine, 0);
	getsize(display, confine, &width, &height);

	/* May as well put the pointer there to begin with */
	warppointer(display, confine, 1, 1);

	XGrabPointer(display, grabwin, False, 0, GrabModeAsync, GrabModeAsync,
		confine, None, CurrentTime);

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XUngrabPointer(display, CurrentTime);
	getpos(confine, &pos, POS_REL);
	if (pos.x > 0 && pos.x < width && pos.y > 0 && pos.y < height)
		CHECK;
	else {
		report("Pointer did not remain within the confine_to window");
		FAIL;
	}

	/*
	 * We can also check that the pointer is on a edge.  (The windows
	 * do not overlap).
	 */
	if (pos.x == 0 || pos.y == 0 || pos.x == width-1 || pos.y == height-1)
		CHECK;
	else {
		report("Pointer was not on edge of confine_to window");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XWarpPointer-9.(A)");
	report_assertion("When a window argument does not name a valid Window or None,");
	report_assertion("then a BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	seterrdef();
	A_WINDOW2 = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
