/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_VisibilityNotify	1
char    *TestName = "VisibilityNotify";



#define	EVENT		VisibilityNotify
#define	MASK		VisibilityChangeMask

int 	tet_thistest;

static void t001(){

Display	*display = Dsp;
Window	w;
int	count;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion VisibilityNotify-1.(A)");
	report_assertion("The server does not generate VisibilityNotify events on");
	report_assertion("windows whose class is specified as InputOnly.");

	report_strategy("Create class InputOnly window.");
	report_strategy("Select for VisibilityNotify events.");
	report_strategy("Attempt to generate VisibilityNotify event on this window.");
	report_strategy("Verify that no events were delivered.");

	tpstartup();
/* Create class InputOnly window. */
	w = iponlywin(display);
/* Select for VisibilityNotify events. */
	XSelectInput(display, w, MASK);
/* Attempt to generate VisibilityNotify event on this window. */
	XSync(display, True);
	XMapWindow(display, w);
	XSync(display, False);
/* Verify that no events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d", count, 0);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*display;
Winh	*eventw;
XEvent	event;
Winhg	winhg;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion VisibilityNotify-2.(A)");
	report_assertion("When a VisibilityNotify event is generated by a hierarchy");
	report_assertion("change, then the VisibilityNotify event is delivered after");
	report_assertion("any hierarchy event.");

	report_strategy("Create client.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Create window large enough to be obscure each top-level");
	report_strategy("window in a \"standard\" window hierarchy.");
	report_strategy("Select for VisibilityNotify events on all hierarchy windows.");
	report_strategy("Select for UnmapNotify events on event window.");
	report_strategy("Generate VisibilityNotify and UnmapNotify events.");
	report_strategy("Initialize for expected events.");
	report_strategy("Harvest events from event queue.");
	report_strategy("Verify that expected events were delivered.");
	report_strategy("Verify that all VisibilityNotify events are delivered after all");
	report_strategy("UnmapNotify events.");

	tpstartup();
#ifdef	OTHERMASK
#undef	OTHERMASK
#endif
#define	OTHERMASK	StructureNotifyMask
#ifdef	OTHEREVENT
#undef	OTHEREVENT
#endif
#define	OTHEREVENT	UnmapNotify

/* Create client. */
	/*
	 * Can not use Dsp because we are selecting on root window.
	 * We could instead de-select on root window prior to returning,
	 * but this is actually easier.
	 */
	display = opendisplay();
	if (display == (Display *) NULL) {
		delete("Could not open display.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	if (winh(display, 2, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Create window large enough to obscure each top-level */
/* window in a "standard" window hierarchy. */
	winhg.area.x = 0;
	winhg.area.y = 0;
	winhg.area.width = DisplayWidth(display, DefaultScreen(display));
	winhg.area.height = DisplayHeight(display, DefaultScreen(display));
	winhg.border_width = 0;
	eventw = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (eventw == (Winh *) NULL) {
		report("Could not create event window");
		return;
	}
	else
		CHECK;
	if (winh_create(display, eventw, WINH_MAP))
		return;
	else
		CHECK;
/* Select for VisibilityNotify events on all hierarchy windows. */
	if (winh_selectinput(display, (Winh *)NULL, MASK))
		return;
	else
		CHECK;
/* Select for UnmapNotify events on event window. */
	if (winh_selectinput(display, eventw, OTHERMASK))
		return;
	else
		CHECK;
/* Select for no events on root windows. */
	if (winh_selectinput(display, guardian, NoEventMask))
		return;
	else
		CHECK;
	if (guardian->nextsibling &&
	    winh_selectinput(display, guardian->nextsibling, NoEventMask))
		return;
	else
		CHECK;
/* Generate VisibilityNotify and UnmapNotify events. */
	XSync(display, True);
	XUnmapWindow(display, eventw->window);
	XSync(display, False);
/* Initialize for expected events. */
	event.xany.type = OTHEREVENT;
	event.xany.window = eventw->window;
	if (winh_plant(eventw, &event, OTHERMASK, WINH_NOMASK))
		return;
	else
		CHECK;
	event.xany.type = EVENT;
	event.xany.window = WINH_BAD;
	if (winh_plant((Winh *)NULL, &event, MASK, WINH_NOMASK))
		return;
	else
		CHECK;
/* Harvest events from event queue. */
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that expected events were delivered. */
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else
		CHECK;
/* Verify that all VisibilityNotify events are delivered after all */
/* UnmapNotify events. */
	status = winh_ordercheck(OTHEREVENT, EVENT);
	if (status == -1)
		return;
	else if (status)
		FAIL;
	else
		CHECK;

	CHECKPASS(13);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*display;
Winh	*eventw;
XEvent	event;
int	status;
Winhe	*winhe, *winhe2;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion VisibilityNotify-3.(A)");
	report_assertion("When a VisibilityNotify event is generated, then the");
	report_assertion("VisibilityNotify event is delivered before any Expose events");
	report_assertion("on that window.");

	report_strategy("Create client.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Select for VisibilityNotify and Expose events on all windows.");
	report_strategy("Generate VisibilityNotify and Expose events.");
	report_strategy("Initialize for expected events.");
	report_strategy("Harvest events from event queue.");
	report_strategy("Ignore Expose events.");
	report_strategy("Verify that expected events were delivered.");
	report_strategy("Verify that VisibilityNotify events are delivered before");
	report_strategy("Expose events.");

	tpstartup();
#ifdef	OTHERMASK
#undef	OTHERMASK
#endif
#define	OTHERMASK	ExposureMask
#ifdef	OTHEREVENT
#undef	OTHEREVENT
#endif
#define	OTHEREVENT	Expose

/* Create client. */
	/*
	 * Can not use Dsp because we are selecting on root window.
	 * We could instead de-select on root window prior to returning,
	 * but this is actually easier.
	 */
	display = opendisplay();
	if (display == (Display *) NULL) {
		delete("Could not open display.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	if (winh(display, 2, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Select for VisibilityNotify and Expose events on all windows. */
	if (winh_selectinput(display, (Winh *)NULL, MASK|OTHERMASK))
		return;
	else
		CHECK;
/* Select for no events on root windows. */
	if (winh_selectinput(display, guardian, NoEventMask))
		return;
	else
		CHECK;
	if (guardian->nextsibling &&
	    winh_selectinput(display, guardian->nextsibling, NoEventMask))
		return;
	else
		CHECK;
/* Generate VisibilityNotify and Expose events. */
	for (eventw = guardian->firstchild; eventw; eventw = eventw->nextsibling)
		XUnmapWindow(display, eventw->window);
	XSync(display, True);
	for (eventw = guardian->firstchild; eventw; eventw = eventw->nextsibling)
		XMapWindow(display, eventw->window);
	XSync(display, False);
/* Initialize for expected events. */
	event.xany.type = EVENT;
	event.xany.window = WINH_BAD;
	if (winh_plant((Winh *)NULL, &event, MASK, WINH_NOMASK))
		return;
	else
		CHECK;
/* Harvest events from event queue. */
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Ignore Expose events. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		report("Could not mark %s events to be ignored",
			eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
/* Verify that expected events were delivered. */
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else
		CHECK;
/* Verify that VisibilityNotify events are delivered before */
/* Expose events. */
	status = 0;
	for (winhe = winh_qdel; winhe; winhe = winhe->next) {
		if (winhe->event->type == VisibilityNotify) {
			for (winhe2 = winh_qdel; winhe2 != winhe; winhe2 = winhe2->next) {
				if (winhe2->event->type == Expose &&
				    winhe2->event->xexpose.window ==
				    winhe->event->xvisibility.window) {
					report("Expose event delivered before Visibility event on window 0x%x", winhe->event->xvisibility.window);
					FAIL;
				}
			}
			if (!status) {
				CHECK;
				status = 1;
			}
			for (winhe2 = winhe->next; winhe2; winhe2 = winhe2->next) {
				if (winhe2->event->type == Expose &&
				    winhe2->event->xexpose.window ==
				    winhe->event->xvisibility.window)
					break;
			}
			if (!winhe2) {
				report("Expose event not delivered on window 0x%x", winhe->event->xvisibility.window);
				FAIL;
			}
		}
	}
	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display	*display = Dsp;
Display	*client2;
Display	*client3;
Window	w;
int	count;
XEvent	event_return;
XVisibilityEvent good;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion VisibilityNotify-4.(A)");
	report_assertion("When a VisibilityNotify event is generated, then all");
	report_assertion("clients having set VisibilityChangeMask event mask bits on");
	report_assertion("the event window are delivered a VisibilityNotify event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Create window.");
	report_strategy("Select for VisibilityNotify events using VisibilityChangeMask.");
	report_strategy("Select for VisibilityNotify events using VisibilityChangeMask with client2.");
	report_strategy("Select for no events with client3.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that a VisibilityNotify event was delivered to client2.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select for VisibilityNotify events using VisibilityChangeMask. */
	XSelectInput(display, w, MASK);
/* Select for VisibilityNotify events using VisibilityChangeMask with client2. */
	XSelectInput(client2, w, MASK);
/* Select for no events with client3. */
	XSelectInput(client3, w, NoEventMask);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XMapWindow(display, w);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.window = w;
	good.state = VisibilityUnobscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event");
		FAIL;
	}
	else
		CHECK;
/* Verify that a VisibilityNotify event was delivered to client2. */
	if (!XCheckTypedWindowEvent(client2, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.window = w;
	good.state = VisibilityUnobscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event for client2");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;
	
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){


 	report_purpose(5);

	report_assertion("Assertion VisibilityNotify-5.(-)");
	report_assertion("When a VisibilityNotify event is generated, then clients");
	report_assertion("not having set VisibilityChangeMask event mask bits on the");
	report_assertion("event window are not delivered a VisibilityNotify event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t006(){


 	report_purpose(6);

	report_assertion("Assertion VisibilityNotify-6.(-)");
	report_assertion("When a VisibilityNotify event is delivered, then window is");
	report_assertion("set to the window whose visibility state changes.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t007(){

Display	*display = Dsp;
Window	w, w2;
struct area	area;
XEvent	event_return;
XVisibilityEvent	good;
int	count;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion VisibilityNotify-7.(A)");
	report_assertion("When a VisibilityNotify event is delivered and window");
	report_assertion("changes state from partially obscured, fully obscured, or");
	report_assertion("not viewable to viewable and completely unobscured, then");
	report_assertion("state is set to VisibilityUnobscured.");

	report_strategy("Create window.");
	report_strategy("Select for VisibilityNotify events on window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");
	report_strategy("Fully obscure window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");
	report_strategy("Partially obscure window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");

	tpstartup();
	/*
	 * test ordering:
	 *
	 *	not viewable		-> viewable and completely unobscured
	 *	fully obscured		-> viewable and completely unobscured
	 *	partially obscured	-> viewable and completely unobscured
	 */
/* Create window. */
	area.x = 1;
	area.y = 1;
	area.width = W_STDWIDTH;
	area.height = W_STDHEIGHT;
	w = mkwin(display, (XVisualInfo *) NULL, &area, False);
/* Select for VisibilityNotify events on window. */
	XSelectInput(display, w, MASK);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XMapWindow(display, w);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (not viewable test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityUnobscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (not viewable test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (not viewable test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
/* Fully obscure window. */
	w2 = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XUnmapWindow(display, w2);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (fully obscured test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityUnobscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (fully obscured test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (fully obscured test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
/* Partially obscure window. */
	area.x = 1;
	area.y = 1;
	area.width = W_STDWIDTH/2;
	area.height = W_STDHEIGHT/2;
	w2 = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XUnmapWindow(display, w2);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (partially obscured test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityUnobscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (partially obscured test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (partially obscured test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
	
	CHECKPASS(9);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Display	*display = Dsp;
Window	w, wpo;
struct area	area;
XEvent	event_return;
XVisibilityEvent	good;
int	count;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion VisibilityNotify-8.(A)");
	report_assertion("When a VisibilityNotify event is delivered and window");
	report_assertion("changes state from viewable and completely unobscured or not");
	report_assertion("viewable to viewable and partially obscured, then state is");
	report_assertion("set to VisibilityPartiallyObscured.");

	report_strategy("Create window.");
	report_strategy("Create partially obscuring window.");
	report_strategy("Select for VisibilityNotify events on window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");
	report_strategy("Unobscure window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");

	tpstartup();
	/*
	 * test ordering:
	 *
	 *	not viewable
	 *		-> viewable and partially obscured
	 *	viewable & completely unobscured
	 *		-> viewable & partially unobscured
	 */
/* Create window. */
	area.x = 1;
	area.y = 1;
	area.width = W_STDWIDTH;
	area.height = W_STDHEIGHT;
	w = mkwin(display, (XVisualInfo *) NULL, &area, False);
/* Create partially obscuring window. */
	area.x += W_STDWIDTH/2;
	area.y += W_STDHEIGHT/2;
	wpo = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Select for VisibilityNotify events on window. */
	XSelectInput(display, w, MASK);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XMapWindow(display, w);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (not viewable test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityPartiallyObscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (not viewable test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (not viewable test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
/* Unobscure window. */
	XUnmapWindow(display, wpo);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XMapWindow(display, wpo);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (viewable & completely unobscured test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityPartiallyObscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (viewable & completely unobscured test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (viewable & completely unobscured test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
	
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Display	*display = Dsp;
Window	w, wfo, wpo;
struct area	area;
XEvent	event_return;
XVisibilityEvent	good;
int	count;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion VisibilityNotify-9.(A)");
	report_assertion("When a VisibilityNotify event is delivered and window");
	report_assertion("changes state from viewable and completely unobscured,");
	report_assertion("viewable and partially obscured, or not viewable to viewable");
	report_assertion("and fully obscured, then state is set to");
	report_assertion("VisibilityFullyObscured.");

	report_strategy("Create window.");
	report_strategy("Create completely obscuring window.");
	report_strategy("Create partially obscuring window.");
	report_strategy("Select for VisibilityNotify events on window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");
	report_strategy("Unobscure window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");
	report_strategy("Partially obscure window.");
	report_strategy("Generate VisibilityNotify event.");
	report_strategy("Verify that a VisibilityNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no other events were delivered.");

	tpstartup();
	/*
	 * test ordering:
	 *
	 *	not viewable ->
	 *		-> viewable and fully obscured
	 *	viewable and completely unobscured
	 *		-> viewable and fully obscured
	 *	viewable and partially obscured
	 *		-> viewable and fully obscured
	 */
/* Create window. */
	area.x = 1;
	area.y = 1;
	area.width = W_STDWIDTH;
	area.height = W_STDHEIGHT;
	w = mkwin(display, (XVisualInfo *) NULL, &area, False);
/* Create completely obscuring window. */
	wfo = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Create partially obscuring window. */
	area.x += W_STDWIDTH/2;
	area.y += W_STDHEIGHT/2;
	wpo = mkwin(display, (XVisualInfo *) NULL, &area, False);
/* Select for VisibilityNotify events on window. */
	XSelectInput(display, w, MASK);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XMapWindow(display, w);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (not viewable test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityFullyObscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (not viewable test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (not viewable test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
/* Unobscure window. */
	XUnmapWindow(display, wfo);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XMapWindow(display, wfo);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (viewable and completely unobscured test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityFullyObscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (viewable and completely unobscured test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (viewable and completely unobscured test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
/* Partially obscure window. */
	XUnmapWindow(display, wfo);
	XMapWindow(display, wpo);
/* Generate VisibilityNotify event. */
	XSync(display, True);
	XMapWindow(display, wfo);
	XSync(display, False);
/* Verify that a VisibilityNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none (viewable and partially obscured test)", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xvisibility;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.state = VisibilityFullyObscured;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event (viewable and partially obscured test)");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were delivered. */
	count = XPending(display);
	if (count > 0) {
		report("Received %d events, expected %d (viewable and partially obscured test)", count+1, 1);
		FAIL;
	}
	else
		CHECK;
	
	CHECKPASS(9);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
