/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XtSetKeyboardFocus()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/RectObj.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void KP1a(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	avs_set_event(2,1);
	exit(0);
}

void KP1b(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	tet_infoline("ERROR: KeyPress was sent to subtree not descendant");
	tet_result(TET_FAIL);
	exit(0);
}

void KP2a(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	avs_set_event(2,1);
	exit(0);
}
void KP2b(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	tet_infoline("ERROR: KeyPress was sent to descendant not subtree");
	tet_result(TET_FAIL);
	exit(0);
}
void KP3a(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	avs_set_event(1,1);
	exit(0);
}
void KP3b(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	tet_infoline("ERROR: KeyPress was sent to subtree not descendant");
	tet_result(TET_FAIL);
	exit(0);
}
static void
analyse_events4(w, w1)
Widget w, w1;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	Widget widget;
	int ret_value;
	int gflag = 0;
	Window window;
	widget = XtParent(w);
	app_context = XtWidgetToApplicationContext(w);
	display = XtDisplay(w);
	window = XtWindow(w);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 if (loop_event.type == Expose && loop_event.xexpose.window == window){
		if (gflag == 0) {
		tet_infoline("TEST: Actively grab keyboard");
		ret_value = XtGrabKeyboard(w, True, GrabModeAsync, GrabModeAsync, CurrentTime);
		if (ret_value != GrabSuccess) {
			sprintf(ebuf, "ERROR: XtGrabKeyboard Call Failed, return value = %d", ret_value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		}
		gflag = 1;
		}
	 }
	 XSync(display, False);
	 XtDispatchEvent(&loop_event);
	} /* end for */
}
void KP4(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	if (event->type == FocusIn) {
		avs_set_event(1,1);
		exit(0);
	}
}
static void
analyse_events5(w, w1)
Widget w, w1;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	Widget widget;
	int ret_value;
	int gflag = 0;
	Window window;
	widget = XtParent(w);
	app_context = XtWidgetToApplicationContext(w);
	display = XtDisplay(w);
	window = XtWindow(w);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 if (loop_event.type == Expose && loop_event.xexpose.window == window){
		if (gflag == 0) {
		tet_infoline("TEST: Actively grab keyboard");
		ret_value = XtGrabPointer(w, True, FocusChangeMask, GrabModeAsync, GrabModeAsync, window, None, CurrentTime);
		if (ret_value != GrabSuccess) {
			sprintf(ebuf, "ERROR: XtGrabPointer Call Failed, return value = %d", ret_value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		}
		gflag = 1;
		}
	 }
	 XSync(display, False);
	 XtDispatchEvent(&loop_event);
	} /* end for */
}
void KP5(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	if (event->type == FocusIn) {
		avs_set_event(1,1);
		exit(0);
	}
}
static void
analyse_events6(w, w1)
Widget w, w1;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	Widget widget;
	int ret_value;
	int gflag = 0;
	Window window;
	widget = XtParent(w);
	app_context = XtWidgetToApplicationContext(w);
	display = XtDisplay(w);
	window = XtWindow(w);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 if (loop_event.type == Expose && loop_event.xexpose.window == window){
		if (gflag == 0) {
		tet_infoline("TEST: Actively grab the keyboard");
		ret_value = XtGrabKeyboard(w, True, GrabModeAsync, GrabModeAsync, CurrentTime);
		if (ret_value != GrabSuccess) {
			sprintf(ebuf, "ERROR: XtGrabKeyboard Call Failed, return value = %d", ret_value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		}
		tet_infoline("TEST: Ungrab the keyboard");
		XtUngrabKeyboard(w, CurrentTime);
		gflag = 1;
		}
	 }
	 XSync(display, False);
	 XtDispatchEvent(&loop_event);
	} /* end for */
}
void KP6(w, client_data, event, cont)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *cont;
{
	if (event->type == FocusOut) {
		avs_set_event(1,1);
		exit(0);
	}
}


#define T_XtSetKeyboardFocus	1
char    *TestName = "XtSetKeyboardFocus";



static int 	ValueReturn;

int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int status;
int ret_value;
Display *display;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSetKeyboardFocus-1.(A)");
	report_assertion("When descendant is not None a successful call to void");
	report_assertion("XtSetKeyboardFocus(subtree, descendant) shall cause keyboard");
	report_assertion("events that occur in any widget of the widget subtree");
	report_assertion("specified by subtree to be redirected to the widget");
	report_assertion("descendant.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstkbfocs1", "XtSetKeyboardFocus");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	display = XtDisplay(rowcolw);
	tet_infoline("PREP: Add keypress event handler to rowcolw and panedw");
	XtAddEventHandler(rowcolw,
		KeyPressMask,
		False,
		&KP1a,
		NULL);
	XSelectInput(display, XtWindow(rowcolw), FocusChangeMask|KeyPressMask);
	XtAddEventHandler(panedw,
		KeyPressMask,
		False,
		&KP1b,
		NULL);
	XSelectInput(display, XtWindow(panedw), FocusChangeMask|KeyPressMask);
	tet_infoline("TEST: Set Keyboard focus to panedw subtree with rowcolw as descendant");
	XtSetKeyboardFocus(panedw, rowcolw);
	tet_infoline("TEST: Send a KeyPress to subtree");
	send_event(panedw, KeyPress, KeyPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: KeyPress event was received by descendant");
	status = avs_get_event(2);
	check_dec(1, status, "KeyPress event count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11422 */
/* End of included file Mdefcode.tmc.11422 */

static void t002(){

pid_t pid2;
int status;
int ret_value;
Display *display;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSetKeyboardFocus-2.(A)");
	report_assertion("A call to void XtSetKeyboardFocus(subtree, descendant) when");
	report_assertion("descendant is None and no input focus was previously set in");
	report_assertion("subtree shall cause keyboard events that occur in the");
	report_assertion("specified subtree to be dispatched normally.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstkbfocs2", "XtSetKeyboardFocus");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	display = XtDisplay(rowcolw);
	tet_infoline("PREP: Add keypress event handler to rowcolw and panedw");
	XtAddEventHandler(rowcolw,
		KeyPressMask,
		False,
		&KP2b,
		NULL);
	XSelectInput(display, XtWindow(rowcolw), FocusChangeMask|KeyPressMask);
	XtAddEventHandler(panedw,
		KeyPressMask,
		False,
		&KP2a,
		NULL);
	XSelectInput(display, XtWindow(panedw), FocusChangeMask|KeyPressMask);
	tet_infoline("PREP: Set Keyboard focus to panedw subtree with NULL as descendant");
	XtSetKeyboardFocus(panedw, NULL);
	tet_infoline("PREP: Send a KeyPress to subtree");
	send_event(panedw, KeyPress, KeyPressMask, TRUE);
	tet_infoline("TEST: Check KeyPress event was received by subtree");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(2);
	check_dec(1, status, "KeyPress event count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11422 */
/* End of included file Mdefcode.tmc.11422 */

static void t003(){

pid_t pid2;
int status;
int ret_value;
Display *display;
Widget test_widget, test_widget2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtSetKeyboardFocus-3.(A)");
	report_assertion("A call to void XtSetKeyboardFocus(subtree, descendant) when");
	report_assertion("the class of descendant is not a subclass of Core shall");
	report_assertion("cause keyboard events that occur in the specified widget");
	report_assertion("subtree to be redirected to the closest windowed ancestor of");
	report_assertion("descendant.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstkbfocs3", "XtSetKeyboardFocus");
	tet_infoline("PREP: Create Core widget as child of rowcolw widget");
	test_widget = XtVaCreateManagedWidget("core", coreWidgetClass, rowcolw, NULL);
	ConfigureDimension(topLevel, test_widget);
	tet_infoline("PREP: Create rectObj widget as child of core widget");
	test_widget2 = XtVaCreateWidget("rect", rectObjClass, test_widget, NULL);
	ConfigureDimension(topLevel, test_widget2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Add keypress event handler to rowcolw");
	XtAddEventHandler(rowcolw,
		KeyPressMask,
		False,
		KP3b,
		NULL);
	XSelectInput(display, XtWindow(rowcolw), FocusChangeMask|KeyPressMask);
	tet_infoline("PREP: Add keypress event handler to core widget");
	XtAddEventHandler(test_widget,
		KeyPressMask,
		False,
		KP3a,
		NULL);
	XSelectInput(display, XtWindow(test_widget), FocusChangeMask|KeyPressMask);
	tet_infoline("PREP: Set Keyboard focus to rowcolw subtree with rectObj widget as descendant");
	XtSetKeyboardFocus(rowcolw, test_widget2);
	tet_infoline("PREP: Send a KeyPress to subtree");
	send_event(rowcolw, KeyPress, KeyPressMask, TRUE);
	tet_infoline("TEST: KeyPress event was received by core ancestor of rectObj widget");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(1, status, "count of events to rowcolw");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11422 */
/* End of included file Mdefcode.tmc.11422 */

static void t004(){

pid_t pid2;
int status;
int ret_value;
Display *display;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtSetKeyboardFocus-4.(A)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when the FocusChange event has been selected by");
	report_assertion("the widget descendant and subtree or one of its descendants");
	report_assertion("acquires the X Input focus a FocusIn event shall be");
	report_assertion("generated for descendant.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstkbfocs4", "XtSetKeyboardFocus");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	display = XtDisplay(panedw);
	tet_infoline("PREP: Add focus change event handler to rowcolw");
	XtAddEventHandler(rowcolw,
		FocusChangeMask,
		False,
		&KP4,
		NULL);
	XSelectInput(display, XtWindow(rowcolw), FocusChangeMask);
	tet_infoline("PREP: Set Keyboard focus to panedw subtree with rowcolw as descendant");
	XtSetKeyboardFocus(panedw, rowcolw);
	tet_infoline("TEST: Check FocusIn event was received");
	analyse_events4(panedw, rowcolw);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(1, status, "FocusIn event count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11422 */
/* End of included file Mdefcode.tmc.11422 */

static void t005(){

pid_t pid2;
int status;
int ret_value;
Display *display;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtSetKeyboardFocus-5.(A)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when the FocusChange event has been selected by");
	report_assertion("the widget descendant and the pointer moves into the");
	report_assertion("specified subtree a FocusIn event shall be generated for");
	report_assertion("descendant.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstkbfocs5", "XtSetKeyboardFocus");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	display = XtDisplay(panedw);
	tet_infoline("PREP: Add focus change event handler to rowcolw");
	XtAddEventHandler(rowcolw,
		FocusChangeMask,
		False,
		&KP5,
		NULL);
	XSelectInput(display, XtWindow(rowcolw), FocusChangeMask);
	tet_infoline("PREP: Set Keyboard focus to panedw subtree with rowcolw as descendant");
	XtSetKeyboardFocus(panedw, rowcolw);
	tet_infoline("TEST: Check FocusIn event was received");
	analyse_events5(panedw, rowcolw);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(1, status, "FocusIn event count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11422 */
/* End of included file Mdefcode.tmc.11422 */

static void t006(){

pid_t pid2;
int status;
int ret_value;
Display *display;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtSetKeyboardFocus-6.(A)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when FocusChange events have been selected by");
	report_assertion("the widget descendant and the subtree or one of its");
	report_assertion("descendants loses the X Input focus a FocusOut event shall");
	report_assertion("be generated for descendant.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstkbfocs6", "XtSetKeyboardFocus");
	tet_infoline("PREP: Set height and width of boxw2 widget");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	display = XtDisplay(panedw);
	tet_infoline("PREP: Add focus change event handler to rowcolw");
	XtAddEventHandler(rowcolw,
		FocusChangeMask,
		False,
		&KP6,
		NULL);
	XSelectInput(display, XtWindow(rowcolw), FocusChangeMask);
	tet_infoline("PREP: Set Keyboard focus to panedw subtree with rowcolw as descendant");
	XtSetKeyboardFocus(panedw, rowcolw);
	tet_infoline("TEST: Check FocusIn event was received");
	analyse_events6(panedw, rowcolw);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(1, status, "FocusIn event count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11422 */
/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtSetKeyboardFocus-7.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when FocusChange events have been selected by");
	report_assertion("the widget descendant and an ancestor of subtree loses the");
	report_assertion("keyboard focus a FocusOut event shall be generated for");
	report_assertion("descendant.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtSetKeyboardFocus-8.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when no modal cascade exists, the widget");
	report_assertion("descendant has redirected its keyboard focus to another");
	report_assertion("widget, and a keyboard event occurs in a widget in subtree");
	report_assertion("that is either the final widget in the focus chain or its");
	report_assertion("descendant the event shall be dispatched to the widget in");
	report_assertion("which the event occurred.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtSetKeyboardFocus-9.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when no modal cascade exists, a keyboard event");
	report_assertion("occurs in a widget in subtree that is neither an ancestor");
	report_assertion("nor a descendant of descendant, and the event has activated");
	report_assertion("a keyboard grab for this widget the grab shall be canceled.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtSetKeyboardFocus-10.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when no modal cascade exists and a keyboard");
	report_assertion("event occurs in a widget in subtree that is an ancestor of");
	report_assertion("the final widget in the focus chain and has established a");
	report_assertion("passive grab with owner_events set to False the event shall");
	report_assertion("be dispatched to the widget in which the event occurred.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtSetKeyboardFocus-11.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when no modal cascade exists, a keyboard event");
	report_assertion("occurs in a widget in subtree that is an ancestor of the");
	report_assertion("final widget in the focus chain and has established a");
	report_assertion("passive grab with owner_events set to True, and the");
	report_assertion("coordinates of the event are outside the rectangle specified");
	report_assertion("by this widget the event shall be dispatched to the widget");
	report_assertion("in which the event occurred.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtSetKeyboardFocus-12.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when no modal cascade exists, a keyboard event");
	report_assertion("occurs in a widget in subtree that is not the final widget");
	report_assertion("in the focus chain or its descendant, nor is the event");
	report_assertion("widget an ancestor of the final widget in the focus chain");
	report_assertion("that has established a passive keyboard grab with");
	report_assertion("owner_events set to False or an ancestor that has");
	report_assertion("established a passive keyboard grab with owner_events set to");
	report_assertion("True and the coordinates of the event are outside the");
	report_assertion("rectangle specified by the widget, and there is a widget in");
	report_assertion("the subtree that has an active keyboard grab the event shall");
	report_assertion("be dispatched to the final widget in the focus chain.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtSetKeyboardFocus-13.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when no modal cascade exists, a keyboard event");
	report_assertion("occurs in a widget in subtree that is not the final widget");
	report_assertion("in the focus chain or its descendant, nor is the event");
	report_assertion("widget an ancestor of the final widget in the focus chain");
	report_assertion("that has established a passive keyboard grab with");
	report_assertion("owner_events set to False or an ancestor that has");
	report_assertion("established a passive keyboard grab with owner_events set to");
	report_assertion("True and the coordinates of the event are outside the");
	report_assertion("rectangle specified by the widget, and there is no widget");
	report_assertion("between the final widget in the focus chain and its closest");
	report_assertion("common ancestor with the event widget that has grabbed the");
	report_assertion("specified key and modifier combination with any value of");
	report_assertion("owner_events the event shall be dispatched to the final");
	report_assertion("widget in the focus chain.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtSetKeyboardFocus-14.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when no modal cascade exists, a keyboard event");
	report_assertion("occurs in a widget in subtree that is not the final widget");
	report_assertion("in the focus chain or its descendant, nor is the event");
	report_assertion("widget an ancestor of the final widget in the focus chain");
	report_assertion("that has established a passive keyboard grab with");
	report_assertion("owner_events set to False or an ancestor that has");
	report_assertion("established a passive keyboard grab with owner_events set to");
	report_assertion("True and the coordinates of the event are outside the");
	report_assertion("rectangle specified by the widget, and neither is there a");
	report_assertion("widget in the subtree that has an active keyboard grab nor");
	report_assertion("is there a widget between the final widget in the focus");
	report_assertion("chain and its closest common ancestor with the event widget");
	report_assertion("that has grabbed the key and modifier combination with any");
	report_assertion("value of owner_events the event shall be dispatched to the");
	report_assertion("ancestor of the final widget in the focus chain closest to");
	report_assertion("its common ancestor with the event widget that has grabbed");
	report_assertion("the specified key and modifier combination.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtSetKeyboardFocus-15.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when a modal cascade exists, a keyboard event");
	report_assertion("occurs, and the widget that would have been the final event");
	report_assertion("dispatch destination had there been no modal cascade is in");
	report_assertion("the active subset of the modal cascade the event shall be");
	report_assertion("dispatched to that widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t016(){

pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtSetKeyboardFocus-16.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when a modal cascade exists, a keyboard event");
	report_assertion("occurs, the widget that would have been the final event");
	report_assertion("dispatch destination had there been no modal cascade is not");
	report_assertion("in the active subset of the modal cascade, and there is a");
	report_assertion("spring-loaded widget in the active subset of the modal");
	report_assertion("cascade the event shall be dispatched to the spring-loaded");
	report_assertion("widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* Including from file Mdefcode.tmc.11422 */
static void t017(){

pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtSetKeyboardFocus-17.(B)");
	report_assertion("After a successful call to void XtSetKeyboardFocus(subtree,");
	report_assertion("descendant) when a modal cascade exists, a keyboard event");
	report_assertion("occurs, the widget that would have been the final event");
	report_assertion("dispatch destination had there been no modal cascade is not");
	report_assertion("in the active subset of the modal cascade, and there is no");
	report_assertion("spring-loaded widget in the active subset of the modal");
	report_assertion("cascade the event shall be discarded.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11422 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
