/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* 
* SCCS:  @(#)  strtkysym.m Rel 1.8	    (11/28/91)
* 
* 	UniSoft Ltd., London, England
* 
* (C) Copyright 1991 X/Open Company Limited
* 
* All rights reserved.  No part of this source code may be reproduced,
* stored in a retrieval system, or transmitted, in any form or by any
* means, electronic, mechanical, photocopying, recording or otherwise,
* except as stated in the end-user licence agreement, without the prior
* permission of the copyright owners.
* 
* X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
* the UK and other countries.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XStringToKeysym	1
char    *TestName = "XStringToKeysym";



int 	tet_thistest;

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XStringToKeysym-1.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code 1:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsym1();

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XStringToKeysym-2.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code 2:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsym2();

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XStringToKeysym-3.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code 3:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsym3();

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XStringToKeysym-4.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code 4:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsym4();

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XStringToKeysym-5.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code A:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymA();

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XStringToKeysym-6.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code C:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymC();

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XStringToKeysym-7.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code G:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymG();

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XStringToKeysym-8.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code H:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymH();

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XStringToKeysym-9.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code K:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymK();

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XStringToKeysym-10.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code L:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymL();

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XStringToKeysym-11.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code M:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymM();

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XStringToKeysym-12.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code P:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymP();

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XStringToKeysym-13.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code S:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymS();

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XStringToKeysym-14.(A)");
	report_assertion("When the string argument is the name of a KeySym in the");
	report_assertion("table with the prefix XK_ removed, then a call to");
	report_assertion("XStringToKeysym returns that KeySym.");

	report_strategy("For each KeySym name in table with code T:");
	report_strategy("	Call XStringToKeysym to obtain the KeySym defined for that string.");
	report_strategy("	Verify that XStringToKeysym did not return NoSymbol.");
	report_strategy("	Verify that the returned string is correct.");

	tpstartup();
	strtsymT();

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
