/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XFreePixmap(display, pixmap)
 *   Display *display;
 *   Pixmap  pixmap;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XFreePixmap	1
char    *TestName = "XFreePixmap";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_PIXMAP pixmap
#define A_DRAWABLE pixmap


/*
 * Arguments to the XFreePixmap function
 */
static Display *display;
static Pixmap  pixmap;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	pixmap = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	pixmap = ErrdefPixmap;
}

static void t001(){

XVisualInfo	*vp;
GC		gc;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XFreePixmap-1.(A)");
	report_assertion("A call to XFreePixmap removes the association between the");
	report_assertion("pixmap ID pixmap and the specified pixmap.");

	report_strategy("For all supported depths of pixmap:");
	report_strategy("   Create a pixmap.");
	report_strategy("   Create a gc using the pixmap as the drawable.");
	report_strategy("   Free the pixmap with XFreePixmap.");
	report_strategy("   Plot (0,0) in the pixmap.");
	report_strategy("   Verify that a BadDrawable error occurred.");

	tpstartup();
	setargs();
	for(resetvinf(VI_PIX); nextvinf(&vp); ) {
		pixmap = XCreatePixmap(display, DRW(display), 1, 1, vp->depth);
		gc = makegc(display, pixmap);
		startcall(display);
		if (isdeleted())
			return;
		XFreePixmap(display, pixmap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		
		startcall(Dsp);
		XDrawPoint(display, pixmap, gc, 0, 0);
		endcall(Dsp);
		if(geterr() != BadDrawable) {
			report("Got %s instead of BadDrawable when drawing on a freed pixmap. ", errorname(geterr()));
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window		win;
XVisualInfo	*vp;
XGCValues	gcv;
GC		gc;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XFreePixmap-2.(A)");
	report_assertion("The storage allocated to the pixmap is not recovered until");
	report_assertion("all references to it have been removed.");

	report_strategy("Create a window.");
	report_strategy("Create a pixmap of the same dimensions as the window.");
	report_strategy("Pattern the pixmap.");
	report_strategy("Create a gc with the pixmap as the tile and the fill_mode set to FillTiled.");
	report_strategy("Free the pixmap with XFreePixmap.");
	report_strategy("Tile the entire window with XFillRectangle.");
	report_strategy("Verify that the tiled pattern matches the pixmap.");

	tpstartup();
	setargs();
	for(resetvinf(VI_WIN); nextvinf(&vp);) {
		win = makewin(display, vp);	
		pixmap = XCreatePixmap(display, DRW(display), W_STDWIDTH, W_STDHEIGHT, vp->depth);
		dset(display, pixmap, W_BG);
		pattern(display, pixmap);
	
		gcv.fill_style = FillTiled;
		gcv.tile = pixmap;
		gcv.foreground = W_FG;
		gcv.background = W_BG;

                /*
                 * Create the GC with the window of the same depth because
                 * the root window could be of a different depth.
                 */
		gc = XCreateGC(display, win, GCFillStyle|GCTile|GCForeground|GCBackground, &gcv);
		startcall(display);
		if (isdeleted())
			return;
		XFreePixmap(display, pixmap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	
		XFillRectangle(display, win, gc, 0, 0, W_STDWIDTH+1, W_STDHEIGHT+1);		
		
		if( checkpattern(display, win, (struct area *) 0 ) != True) {
			report("Tiled pattern on window was not correct after");
			report("tile component in GC was freed by XFreePixmap");
			FAIL;
		} else
			CHECK;
	
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EPix.mc */
/* End of included file error/EPix.mc */

/* Including from file error/EPix.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XFreePixmap-3.(A)");
	report_assertion("When a pixmap argument does not name a valid Pixmap, then a");
	report_assertion("BadPixmap error occurs.");

	report_strategy("Create a bad pixmap by creating and freeing a pixmap.");
	report_strategy("Call test function using bad pixmap as the pixmap argument.");
	report_strategy("Verify that a BadPixmap error occurs.");

	tpstartup();
	setargs();

	seterrdef();

	A_PIXMAP = (Pixmap) badpixm(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XFreePixmap(display, pixmap);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadPixmap)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EPix.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
