/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangeProperty(display, w, property, type, format, mode, data, nelements)
 *   Display *display;
 *   Window w;
 *   Atom property;
 *   Atom type;
 *   int format;
 *   int mode;
 *   unsigned char *data;
 *   int nelements;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeProperty	1
char    *TestName = "XChangeProperty";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w
#define A_ATOM property


/*
 * Arguments to the XChangeProperty function
 */
static Display *display;
static Window w;
static Atom property;
static Atom type;
static int format;
static int mode;
static unsigned char *data;
static int nelements;


#include "X11/Xatom.h"

static Atom xcp_list[] = {
	XA_COPYRIGHT, XA_INTEGER };

static int xcp_num_list = NELEM(xcp_list);

static void
xcp_add_property(prop, data)
Atom prop;
unsigned long data;
{
	XChangeProperty(display, w, prop, XA_INTEGER, 32,
		PropModeReplace, (unsigned char *)&data, 1);
	XSync(display, True);
}

static int
xcp_get_property(prop, length, ret)
Atom prop;
int length;
unsigned char **ret;
{
Atom type;
int format;
unsigned long nitems;
unsigned long after;

	XGetWindowProperty(display, w, prop, 0, (long)length, False,
			XA_INTEGER, &type, &format, &nitems, &after, ret);

	if ( type != XA_INTEGER || format != 32 ) {
		delete("XGetWindowProperty returned unexpected values");
		report("type is %s (expected XA_INTEGER)", atomname(type));
		report("format is %d (expected 32)",format);
		return(0);
	} else {
		if (nitems != length) {
			report("%s did not change the", TestName);
			report("window property as expected");
			report("Expected %d items", length);
			report("Returned %d items", nitems);
			return(0);
		} else {
			if (after != 0) {
				report("%s did not change the", TestName);
				report("window property as expected");
				report("Expected after: 0");
				report("Returned after: %d", after);
				return(0);
			}
		}
	}
	return(1);
}



/* Value list for use in test t012 */
static int 	formatvallist[] = {
	8,
	16,
	32,
};



/* Value list for use in test t013 */
static int 	modevallist[] = {
	PropModeReplace,
	PropModePrepend,
	PropModeAppend,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = defwin(display);
	property = xcp_list[0];
	type = XA_INTEGER;
	format = 32;
	mode = PropModeReplace;
	data = (unsigned char *)NULL;
	nelements = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

unsigned long newdata;
unsigned long retdata;
unsigned char *retptr;
int num_ev;
XEvent ev, good;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeProperty-1.(A)");
	report_assertion("A call to XChangeProperty alters the property for the");
	report_assertion("specified window w and generates a PropertyNotify event on");
	report_assertion("that window.");

	report_strategy("Create a window without properties and with PropertyChangeMask events selected.");
	report_strategy("Call XChangeProperty to replace a property value.");
	report_strategy("Verify that a PropertyNotify event occurred.");
	report_strategy("Verify that the property was updated as expected.");

	tpstartup();
	setargs();
/* Create a window without properties and with PropertyChangeMask events selected. */
	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to replace a property value. */
	mode = PropModeReplace;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev == 0) {
		FAIL;
		report("A call to %s caused no events", TestName);
	} else {
		if(num_ev != 1) {
			FAIL;
			report("A call to %s caused %d events, expecting 1",
				TestName, num_ev);
			do {
				report("Event %s", eventname(ev.type));
			} while(getevent(display, &ev));
		} else {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = property;
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		}
	}

/* Verify that the property was updated as expected. */
	if(!xcp_get_property(property, 1, &retptr)) {
		FAIL;
	} else {
		retdata = *(unsigned long *)retptr;
		if(retdata != newdata) {
			FAIL;
			report("%s did not assign the property value",TestName);
			report("as expected");
			report("Expected value: %u", newdata);
			report("Returned value: %u", retdata);
		} else
			CHECK;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int loop;
unsigned long newdata;
unsigned long retdata;
unsigned char *retptr;
int num_ev;
XEvent ev, good;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeProperty-2.(A)");
	report_assertion("When mode is PropModeReplace, then a call to");
	report_assertion("XChangeProperty discards the previous value of property and");
	report_assertion("stores the new data, in the specified format and type, and");
	report_assertion("a PropertyNotify event is generated.");

	report_strategy("Create a window with properties and PropertyChangeMask events selected.");
	report_strategy("Call XChangeProperty to replace a property value.");
	report_strategy("Verify that a PropertyNotify event occurred.");
	report_strategy("Verify that the property was updated as expected.");

	tpstartup();
	setargs();
/* Create a window with properties and PropertyChangeMask events selected. */
	for(loop=0; loop < xcp_num_list; loop++)
		xcp_add_property(xcp_list[loop], (unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to replace a property value. */
	mode = PropModeReplace;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev == 0) {
		FAIL;
		report("A call to %s caused no events", TestName);
	} else {
		if(num_ev != 1) {
			FAIL;
			report("A call to %s caused %d events, expecting 1",
				TestName, num_ev);
			do {
				report("Event %s", eventname(ev.type));
			} while(getevent(display, &ev));
		} else {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = property;
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		}
	}

/* Verify that the property was updated as expected. */
	if(!xcp_get_property(property, 1, &retptr)) {
		FAIL;
	} else {
		retdata = *(unsigned long *)retptr;
		if(retdata != newdata) {
			FAIL;
			report("%s did not change the property value",TestName);
			report("as expected");
			report("Expected value: %u", newdata);
			report("Returned value: %u", retdata);
		} else
			CHECK;
	}
	
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int loop;
unsigned long newdata;
unsigned long *retdata;
unsigned char *retptr;
int num_ev;
XEvent ev, good;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeProperty-3.(A)");
	report_assertion("When mode is PropModePrepend, then a call to");
	report_assertion("XChangeProperty inserts the specified data before the");
	report_assertion("beginning of the existing data for property, and a");
	report_assertion("PropertyNotify event is generated.");

	report_strategy("Create a window with properties and PropertyChangeMask events selected.");
	report_strategy("Call XChangeProperty to replace a property value.");
	report_strategy("Verify that a PropertyNotify event occurred.");
	report_strategy("Verify that the property was updated as expected.");

	tpstartup();
	setargs();
/* Create a window with properties and PropertyChangeMask events selected. */
	for(loop=0; loop < xcp_num_list; loop++)
		xcp_add_property(xcp_list[loop], (unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to replace a property value. */
	mode = PropModePrepend;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev == 0) {
		FAIL;
		report("A call to %s caused no events", TestName);
	} else {
		if(num_ev != 1) {
			FAIL;
			report("A call to %s caused %d events, expecting 1",
				TestName, num_ev);
			do {
				report("Event %s", eventname(ev.type));
			} while(getevent(display, &ev));
		} else {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = property;
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		}
	}

/* Verify that the property was updated as expected. */
	if(!xcp_get_property(property, 2, &retptr)) {
		FAIL;
	} else {
		retdata = (unsigned long *)retptr;
		if(retdata[0] != newdata || retdata[1] != 0) {
			FAIL;
			report("%s did not change the property value",TestName);
			report("as expected");
			report("Expected value: %u,%u", newdata, 0);
			report("Returned value: %u,%u", retdata[0], retdata[1]);
		} else
			CHECK;
	}
	
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int loop;
unsigned long newdata;
unsigned long *retdata;
unsigned char *retptr;
int num_ev;
XEvent ev, good;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeProperty-4.(A)");
	report_assertion("When mode is PropModeAppend, then a call to");
	report_assertion("XChangeProperty inserts the specified data onto the end of");
	report_assertion("the existing data for property, and a PropertyNotify event");
	report_assertion("is generated.");

	report_strategy("Create a window with properties and PropertyChangeMask events selected.");
	report_strategy("Call XChangeProperty to replace a property value.");
	report_strategy("Verify that a PropertyNotify event occurred.");
	report_strategy("Verify that the property was updated as expected.");

	tpstartup();
	setargs();
/* Create a window with properties and PropertyChangeMask events selected. */
	for(loop=0; loop < xcp_num_list; loop++)
		xcp_add_property(xcp_list[loop], (unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to replace a property value. */
	mode = PropModeAppend;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev == 0) {
		FAIL;
		report("A call to %s caused no events", TestName);
	} else {
		if(num_ev != 1) {
			FAIL;
			report("A call to %s caused %d events, expecting 1",
				TestName, num_ev);
			do {
				report("Event %s", eventname(ev.type));
			} while(getevent(display, &ev));
		} else {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = property;
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		}
	}

/* Verify that the property was updated as expected. */
	if(!xcp_get_property(property, 2, &retptr)) {
		FAIL;
	} else {
		retdata = (unsigned long *)retptr;
		if(retdata[0] != 0 || retdata[1] != newdata) {
			FAIL;
			report("%s did not change the property value",TestName);
			report("as expected");
			report("Expected values: %u,%u", 0, newdata);
			report("Returned values: %u,%u", retdata[0], retdata[1]);
		} else
			CHECK;
	}
	
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

unsigned long newdata;
unsigned long retdata;
unsigned char *retptr;
int num_ev;
XEvent ev, good;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeProperty-5.(A)");
	report_assertion("When mode is PropModeAppend or PropModePrepend and the");
	report_assertion("property is undefined for window w, then on a call to");
	report_assertion("XChangeProperty the property is treated as if it were");
	report_assertion("defined with the correct type and format and had zero length");
	report_assertion("data.");

	report_strategy("Create a window without properties and with PropertyChangeMask events selected.");
	report_strategy("Call XChangeProperty to prepend to a non-existant property value.");
	report_strategy("Verify that a PropertyNotify event occurred.");
	report_strategy("Verify that the property was updated as expected.");
	report_strategy("Call XChangeProperty to append to a non-existant property value.");
	report_strategy("Verify that a PropertyNotify event occurred.");
	report_strategy("Verify that the property was updated as expected.");

	tpstartup();
	setargs();
/* Create a window without properties and with PropertyChangeMask events selected. */
	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to prepend to a non-existant property value. */
	mode = PropModePrepend;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev == 0) {
		FAIL;
		report("A call to %s caused no events", TestName);
	} else {
		if(num_ev != 1) {
			FAIL;
			report("A call to %s caused %d events, expecting 1",
				TestName, num_ev);
			do {
				report("Event %s", eventname(ev.type));
			} while(getevent(display, &ev));
		} else {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = property;
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		}
	}

/* Verify that the property was updated as expected. */
	if(!xcp_get_property(property, 1, &retptr)) {
		FAIL;
	} else {
		retdata = *(unsigned long *)retptr;
		if(retdata != newdata) {
			FAIL;
			report("%s did not assign the property value",TestName);
			report("as expected");
			report("Expected value: %u", newdata);
			report("Returned value: %u", retdata);
		} else
			CHECK;
	}

/* Call xname to append to a non-existant property value. */
	property = xcp_list[1];
	mode = PropModeAppend;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev == 0) {
		FAIL;
		report("A call to %s caused no events", TestName);
	} else {
		if(num_ev != 1) {
			FAIL;
			report("A call to %s caused %d events, expecting 1",
				TestName, num_ev);
			do {
				report("Event %s", eventname(ev.type));
			} while(getevent(display, &ev));
		} else {
			good.type = PropertyNotify;
			good.xproperty.type = PropertyNotify;
			good.xproperty.atom = property;
			good.xproperty.display = display;
			good.xproperty.window = w;
			good.xproperty.state = PropertyNewValue;
			if (checkevent(&good, &ev)) {
				FAIL;
			} else
				CHECK;
		}
	}

/* Verify that the property was updated as expected. */
	if(!xcp_get_property(property, 1, &retptr)) {
		FAIL;
	} else {
		retdata = *(unsigned long *)retptr;
		if(retdata != newdata) {
			FAIL;
			report("%s did not assign the property value",TestName);
			report("as expected");
			report("Expected value: %u", newdata);
			report("Returned value: %u", retdata);
		} else
			CHECK;
	}
	
	CHECKPASS(4);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display *client2;
unsigned long newdata;
unsigned long retdata;
unsigned char *retptr;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangeProperty-6.(A)");
	report_assertion("When the storing client closes its connection to the server");
	report_assertion("and the window w is not destroyed, then the format, data");
	report_assertion("and type of the property remain associated with the window.");

	report_strategy("Create a new client.");
	report_strategy("Call XChangeProperty to add a property to the window on the new client.");
	report_strategy("Close client2.");
	report_strategy("Allow time for the client to close.");
	report_strategy("Verify that the property is still defined.");

	tpstartup();
	setargs();
/* Create a new client. */
	client2 = XOpenDisplay(config.display);
	if(client2 == (Display *)NULL) {
		delete("could not create new client");
		return;
	} else
		CHECK;

/* Call xname to add a property to the window on the new client. */
	display = client2;
	mode = PropModeReplace;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Close client2. */
	XCloseDisplay(client2);

/* Allow time for the client to close. */
	reset_delay();

/* Verify that the property is still defined. */
	display = Dsp;
	if(!xcp_get_property(property, 1, &retptr)) {
		FAIL;
	} else {
		retdata = *(unsigned long *)retptr;
		if(retdata != newdata) {
			FAIL;
			report("The property value was not",TestName);
			report("as expected");
			report("Expected value: %u", newdata);
			report("Returned value: %u", retdata);
		} else
			CHECK;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Display *display2;
unsigned long newdata;
Atom atm;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangeProperty-7.(A)");
	report_assertion("When the storing client closes its connection to the server");
	report_assertion("and the server does not reset, then the atom property");
	report_assertion("remains.");

	report_strategy("Create a new client.");
	report_strategy("Call XChangeProperty to change a property on a window on the new client.");
	report_strategy("Close new client.");
	report_strategy("Allow time for the client to close.");
	report_strategy("Verify that atom property remains defined.");

	tpstartup();
	setargs();
/* Create a new client. */
	if (config.display == (char *)NULL) {
		delete("config.display not set");
		return;
	} else
		CHECK;

	display2 = XOpenDisplay(config.display);
	if (display2 == (Display *)NULL) {
		delete("Could not open display for display2");
		return;
	} else
		CHECK;

/* Call xname to change a property on a window on the new client. */
	display = display2;
	newdata = 255;
	data = (unsigned char *)&newdata;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Close new client. */
	XCloseDisplay(display2);

/* Allow time for the client to close. */
	reset_delay();

/* Verify that atom property remains defined. */
	atm = XInternAtom(Dsp, "INTEGER", True);

	if (atm != XA_INTEGER) {
		FAIL;
		report("%s caused INTEGER atom to become undefined.",
			TestName);
		report("Expected atom %u", (unsigned long)XA_INTEGER);
		report("Returned atom %u", (unsigned long)atm);
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int loop;
unsigned long newdata;
unsigned long retdata;
unsigned char *retptr;
int num_ev;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangeProperty-8.(A)");
	report_assertion("When mode is PropModePrepend or PropModeAppend and the type");
	report_assertion("or format do not match the existing property value, then on");
	report_assertion("a call to XChangeProperty a BadMatch error occurs.");

	report_strategy("Create a window with properties and PropertyChangeMask events selected.");
	report_strategy("Call XChangeProperty to append a property value, with incorrect type information.");
	report_strategy("Verify that no PropertyNotify event occurred.");
	report_strategy("Verify that the property was unchanged.");
	report_strategy("Call XChangeProperty to prepend a property value, with incorrect format information.");
	report_strategy("Verify that no PropertyNotify event occurred.");
	report_strategy("Verify that the property was unchanged.");

	tpstartup();
	setargs();
/* Create a window with properties and PropertyChangeMask events selected. */
	for(loop=0; loop < xcp_num_list; loop++)
		xcp_add_property(xcp_list[loop], (unsigned long)loop);

	XSelectInput(display, w, PropertyChangeMask);

/* Call xname to append a property value, with incorrect type information. */
	format = 32;
	type = XA_BITMAP;
	mode = PropModeAppend;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	
	if(geterr()!= BadMatch) {
		FAIL;
	} else
		CHECK;

/* Verify that no PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev != 0) {
		FAIL;
		report("A call to %s caused %d events, expecting 0",
			TestName, num_ev);
		do {
			report("Event %s", eventname(ev.type));
		} while(getevent(display, &ev));
	} else 
		CHECK;

/* Verify that the property was unchanged. */
	if(!xcp_get_property(property, 1, &retptr)) {
		FAIL;
	} else {
		retdata = *(unsigned long *)retptr;
		if(retdata != 0) {
			FAIL;
			report("%s changed the property value",TestName);
			report("unexpectedly");
			report("Expected value: %u", 0);
			report("Returned value: %u", retdata);
		} else
			CHECK;
	}

/* Call xname to prepend a property value, with incorrect format information. */
	format = 16;
	type = XA_INTEGER;
	mode = PropModePrepend;
	newdata = xcp_num_list;
	data =  (unsigned char *)&newdata;
	nelements = 1;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	
	if(geterr()!= BadMatch) {
		FAIL;
	} else
		CHECK;

/* Verify that no PropertyNotify event occurred. */
	num_ev = getevent(display, &ev);
	if(num_ev != 0) {
		FAIL;
		report("A call to %s caused %d events, expecting 0",
			TestName, num_ev);
		do {
			report("Event %s", eventname(ev.type));
		} while(getevent(display, &ev));
	} else 
		CHECK;

/* Verify that the property was unchanged. */
	if(!xcp_get_property(property, 1, &retptr)) {
		FAIL;
	} else {
		retdata = *(unsigned long *)retptr;
		if(retdata != 0) {
			FAIL;
			report("%s changed the property value",TestName);
			report("unexpectedly");
			report("Expected value: %u", 0);
			report("Returned value: %u", retdata);
		} else
			CHECK;
	}
	
	CHECKPASS(6);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangeProperty-9.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EAto.mc */
/* End of included file error/EAto.mc */

/* Including from file error/EAto.mc */
static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangeProperty-10.(A)");
	report_assertion("When an atom argument does not name a valid Atom, then a");
	report_assertion("BadAtom error occurs.");

	report_strategy("Call test function using a value with the top bits set as the atom argument.");
	report_strategy("Verify that a BadAtom error occurs.");

	tpstartup();
	setargs();
	A_ATOM = ~0L;
	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != BadAtom) {
		report("Got %s, Expecting BadAtom", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadAtom)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAto.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XChangeProperty-11.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XChangeProperty(display, w, property, type, format, mode, data, nelements);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* Including from file Mval.tmc.26319 */
/* End of included file Mval.tmc.26319 */

/* Including from file error/EVal.mc */
static void t012(){

#undef	VALUE_ARG
#define	VALUE_ARG format
#undef	VALUE_LIST
#define	VALUE_LIST formatvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XChangeProperty-12.(A)");
	report_assertion("When the value of format is other than 8, 16 or 32, then");
	report_assertion("a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeProperty(display, w, property, type, format, mode, data, nelements);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file Mval.tmc.26319 */
/* End of included file Mval.tmc.26319 */

/* Including from file error/EVal.mc */
static void t013(){

#undef	VALUE_ARG
#define	VALUE_ARG mode
#undef	VALUE_LIST
#define	VALUE_LIST modevallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XChangeProperty-13.(A)");
	report_assertion("When the value of mode is other than PropModeReplace,");
	report_assertion("PropModePrepend or PropModeAppend, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeProperty(display, w, property, type, format, mode, data, nelements);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
