/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetCloseDownMode(display, close_mode)
 *   Display	*display;
 *   int 	close_mode;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetCloseDownMode	1
char    *TestName = "XSetCloseDownMode";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetCloseDownMode function
 */
static Display	*display;
static int 	close_mode;



/* Value list for use in test t007 */
static int 	close_modevallist[] = {
	DestroyAll,
	RetainPermanent,
	RetainTemporary,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	close_mode = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display	*client1;
Window	win;
Font	font;
Pixmap	pix;
Colormap	colmap;
Cursor	cursor;
GC  	gc;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetCloseDownMode-1.(A)");
	report_assertion("When close_mode is set to DestroyAll and the client is");
	report_assertion("subsequently closed down, then all Window, Font, Pixmap,");
	report_assertion("Colormap, Cursor and GContext resources allocated by the");
	report_assertion("client are destroyed.");

	report_strategy("Create a new connection client1.");
	report_strategy("Create resources for client1.");
	report_strategy("Call XSetCloseDownMode on client1 with close_mode of DestroyAll.");
	report_strategy("Close client1.");
	report_strategy("Verify that the resources are destroyed.");

	tpstartup();
	setargs();
	regdisable();
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}

	win = defwin(client1);
	font = XLoadFont(client1, "xtfont0");
	pix = maketile(client1, win);
	colmap = makecolmap(client1, DefaultVisual(client1, DefaultScreen(client1)),
		AllocNone);
	cursor = makecur(client1);
	gc = makegc(client1, win);
	regenable();

	XSync(client1, False);
	if (isdeleted())
		return;

	display = client1;
	close_mode = DestroyAll;
#ifdef TESTBED
	close_mode = RetainTemporary;
#endif
	startcall(display);
	if (isdeleted())
		return;
	XSetCloseDownMode(display, close_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XCloseDisplay(client1);

	/*
	 * Attempt to destroy all the resources.  Since they should have already
	 * been destroyed, then we expect the appropriate Bad<Resource> error
	 * for each one.
	 */
	CATCH_ERROR(Dsp);
	XDestroyWindow(Dsp, win);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadWindow)
		CHECK;
	else {
		report("Window resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XUnloadFont(Dsp, font);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadFont)
		CHECK;
	else {
		report("Font resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreePixmap(Dsp, pix);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadPixmap)
		CHECK;
	else {
		report("Pixmap resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeColormap(Dsp, colmap);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadColor)
		CHECK;
	else {
		report("Colormap resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeCursor(Dsp, cursor);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadCursor)
		CHECK;
	else {
		report("Cursor resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeGC(Dsp, gc);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadGC)
		CHECK;
	else {
		report("GC resource was not destroyed");
		FAIL;
	}

	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*client1;
Window	base;
Window	win;
Window	inf;
struct	area	area;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetCloseDownMode-2.(A)");
	report_assertion("When close_mode is set to DestroyAll and the client is");
	report_assertion("subsequently closed down, then all the windows in the");
	report_assertion("client's save-set that are inferiors of a window created by");
	report_assertion("the client are reparented, with no change in position");
	report_assertion("relative to the root window, to the closest ancestor that is");
	report_assertion("not an inferior of the client's window.");

	report_strategy("Create new connection client1.");
	report_strategy("Create window with client1.");
	report_strategy("Create inferior of window with Dsp.");
	report_strategy("Add this window to client1's save-set.");
	report_strategy("Call XSetCloseDownMode on client1 with close_mode of DestroyAll.");
	report_strategy("Close client1.");
	report_strategy("Verify that save-set window is reparented with no change in position.");

	tpstartup();
	setargs();
	base = defwin(Dsp);

	if ((client1 = XOpenDisplay(config.display)) == 0) {
		report("Could not open display");
		FAIL;
	}

	win = crechild(client1, base, (struct area *)0);
	XSync(client1, False);

	setarea(&area, 3, 4, 4, 4);
	inf = crechild(Dsp, win, &area);
	if (isdeleted())
		return;

	XAddToSaveSet(client1, inf);

	display = client1;
	close_mode = DestroyAll;
	startcall(display);
	if (isdeleted())
		return;
	XSetCloseDownMode(display, close_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XCloseDisplay(client1);

	CATCH_ERROR(Dsp);
	if (XGetWindowAttributes(Dsp, inf, &atts) == False) {
		report("save-set window was destroyed");
		FAIL;
	} else
		CHECK;
	RESTORE_ERROR(Dsp);

	/*
	 * Compare coord relative to base window.
	 */
	if (atts.x != area.x || atts.y != area.y) {
		report("Absolute co-ordinates relative to root changed");
		report("  (relative to base was (%d, %d) expecting (%d, %d))",
			atts.x, atts.y,
			area.x, area.y);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*client1;
Window	base;
Window	win;
Window	inf;
struct	area	area;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetCloseDownMode-3.(A)");
	report_assertion("When close_mode is set to DestroyAll and the client is");
	report_assertion("subsequently closed down, then all windows in the client's");
	report_assertion("save set that were not mapped are mapped.");

	report_strategy("Create new connection client1.");
	report_strategy("Create window with client1.");
	report_strategy("Create unmapped inferior of window with Dsp.");
	report_strategy("Add this window to client1's save-set.");
	report_strategy("Call XSetCloseDownMode on client1 with close_mode of DestroyAll.");
	report_strategy("Verify that save-set window is mapped.");

	tpstartup();
	setargs();
	base = defwin(Dsp);

	if ((client1 = XOpenDisplay(config.display)) == 0) {
		report("Could not open display");
		FAIL;
	}

	win = crechild(client1, base, (struct area *)0);
	XSync(client1, False);

	setarea(&area, 3, 4, 4, 4);
	inf = creunmapchild(Dsp, win, &area);
	if (isdeleted())
		return;

	XAddToSaveSet(client1, inf);

	display = client1;
	close_mode = DestroyAll;
#ifdef TESTBED
	close_mode = RetainPermanent;
#endif
	startcall(display);
	if (isdeleted())
		return;
	XSetCloseDownMode(display, close_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XCloseDisplay(client1);

	CATCH_ERROR(Dsp);
	if (XGetWindowAttributes(Dsp, inf, &atts) == False) {
		report("save-set window was destroyed");
		FAIL;
	} else
		CHECK;
	RESTORE_ERROR(Dsp);

	if (atts.map_state == IsUnmapped) {
		report("save-set window was not mapped after save-set processing");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display	*client1;
Window	win;
Font	font;
Pixmap	pix;
Colormap	colmap;
Cursor	cursor;
GC  	gc;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetCloseDownMode-4.(A)");
	report_assertion("When close_mode is RetainPermanent and the client is");
	report_assertion("subsequently closed down, then the resources allocated by");
	report_assertion("the client are not destroyed and are marked as permanent.");

	report_strategy("Create client1.");
	report_strategy("Create resource for client1.");
	report_strategy("Call XSetCloseDownMode for client1 with close_mode of RetainPermanent.");
	report_strategy("Close client1.");
	report_strategy("Verify that client1 resource still exists.");
	report_strategy("Call XKillClient with AllTemporary.");
	report_strategy("Verify that client1 resource still exists.");

	tpstartup();
	setargs();
	regdisable();
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}

	win = defwin(client1);
	font = XLoadFont(client1, "xtfont0");
	pix = maketile(client1, win);
	colmap = makecolmap(client1, DefaultVisual(client1, DefaultScreen(client1)),
		AllocNone);
	cursor = makecur(client1);
	gc = makegc(client1, win);
	regenable();

	XSync(client1, False);
	if (isdeleted())
		return;

	display = client1;
	close_mode = RetainPermanent;
#ifdef TESTBED
	close_mode = RetainTemporary;
#endif
	startcall(display);
	if (isdeleted())
		return;
	XSetCloseDownMode(display, close_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XCloseDisplay(client1);

	CATCH_ERROR(Dsp);
	if (XGetWindowAttributes(Dsp, win, &atts) == False) {
		report("Client1 resources destroyed with RetainPermanent");
		FAIL;
		return;
	} else
		CHECK;

	XKillClient(Dsp, AllTemporary);

	/*
	 * Attempt to destroy all the resources.  Each resource should
	 * still exist and so all the destroy operations should be
	 * Successful.
	 */
	CATCH_ERROR(Dsp);
	XDestroyWindow(Dsp, win);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == Success)
		CHECK;
	else {
		report("Window resource was destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XUnloadFont(Dsp, font);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == Success)
		CHECK;
	else {
		report("Font resource was destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreePixmap(Dsp, pix);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == Success)
		CHECK;
	else {
		report("Pixmap resource was destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeColormap(Dsp, colmap);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == Success)
		CHECK;
	else {
		report("Colormap resource was destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeCursor(Dsp, cursor);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == Success)
		CHECK;
	else {
		report("Cursor resource was destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeGC(Dsp, gc);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == Success)
		CHECK;
	else {
		report("GC resource was destroyed");
		FAIL;
	}

	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Display	*client1;
Window	win;
Font	font;
Pixmap	pix;
Colormap	colmap;
Cursor	cursor;
GC  	gc;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetCloseDownMode-5.(A)");
	report_assertion("When close_mode is RetainTemporary and the client is");
	report_assertion("subsequently closed down, then all resources allocated by");
	report_assertion("the client are not destroyed and are marked as temporary.");

	report_strategy("Create client1.");
	report_strategy("Create resource for client1.");
	report_strategy("Call XSetCloseDownMode for client1 with close_mode of RetainTemporary.");
	report_strategy("Close client1.");
	report_strategy("Verify that client1 resource still exists.");
	report_strategy("Call XKillClient with AllTemporary.");
	report_strategy("Verify that client1 resource no longer exists.");

	tpstartup();
	setargs();
	regdisable();
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}

	win = defwin(client1);
	font = XLoadFont(client1, "xtfont0");
	pix = maketile(client1, win);
	colmap = makecolmap(client1, DefaultVisual(client1, DefaultScreen(client1)),
		AllocNone);
	cursor = makecur(client1);
	gc = makegc(client1, win);
	regenable();

	XSync(client1, False);
	if (isdeleted())
		return;

	display = client1;
	close_mode = RetainTemporary;
#ifdef TESTBED
	close_mode = DestroyAll;
#endif
	startcall(display);
	if (isdeleted())
		return;
	XSetCloseDownMode(display, close_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XCloseDisplay(client1);

	CATCH_ERROR(Dsp);
	if (XGetWindowAttributes(Dsp, win, &atts) == False) {
		report("Window was destroyed after close-down in RetainTemporary mode");
		FAIL;
	} else
		CHECK;
	RESTORE_ERROR(Dsp);

	/* No point of continuing if failed so far */
	if (fail)
		return;

	XKillClient(Dsp, AllTemporary);

	/*
	 * Attempt to destroy all the resources.  Since they should have already
	 * been destroyed, then we expect the appropriate Bad<Resource> error
	 * for each one.
	 */
	CATCH_ERROR(Dsp);
	XDestroyWindow(Dsp, win);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadWindow)
		CHECK;
	else {
		report("Window resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XUnloadFont(Dsp, font);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadFont)
		CHECK;
	else {
		report("Font resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreePixmap(Dsp, pix);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadPixmap)
		CHECK;
	else {
		report("Pixmap resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeColormap(Dsp, colmap);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadColor)
		CHECK;
	else {
		report("Colormap resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeCursor(Dsp, cursor);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadCursor)
		CHECK;
	else {
		report("Cursor resource was not destroyed");
		FAIL;
	}

	CATCH_ERROR(Dsp);
	XFreeGC(Dsp, gc);
	RESTORE_ERROR(Dsp);
	if (GET_ERROR(Dsp) == BadGC)
		CHECK;
	else {
		report("GC resource was not destroyed");
		FAIL;
	}

	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display	*client1;
Window	base;
Window	win;
Window	inf;
struct	area	area;
XWindowAttributes	atts;
int 	i;
static	int 	modes[] = {
	RetainPermanent, RetainTemporary
#ifdef TESTBED
	,DestroyAll
#endif
	};
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetCloseDownMode-6.(A)");
	report_assertion("When close_mode is RetainPermanent or RetainTemporary and");
	report_assertion("the client is subsequently closed down, then all windows in");
	report_assertion("the client's save-set are unaffected.");

	report_strategy("Create new connection client1.");
	report_strategy("Create window with client1.");
	report_strategy("Create unmapped inferior of window with Dsp.");
	report_strategy("Add this window to client1's save-set.");
	report_strategy("Call XSetCloseDownMode on client1 with close_mode of RetainPermanent.");
	report_strategy("Close client1 connection.");
	report_strategy("Verify that save-set window is not mapped.");

	tpstartup();
	setargs();
	base = defwin(Dsp);

	for (i = 0; i < NELEM(modes); i++) {
		if ((client1 = XOpenDisplay(config.display)) == 0) {
			report("Could not open display");
			FAIL;
		}

		win = crechild(client1, base, (struct area *)0);
		XSync(client1, False);

		setarea(&area, 3, 4, 4, 4);
		inf = creunmapchild(Dsp, win, &area);
		if (isdeleted())
			return;

		XAddToSaveSet(client1, inf);

		display = client1;
		close_mode = modes[i];
		startcall(display);
		if (isdeleted())
			return;
		XSetCloseDownMode(display, close_mode);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XCloseDisplay(client1);

		CATCH_ERROR(Dsp);
		if (XGetWindowAttributes(Dsp, inf, &atts) == False) {
			report("save-set window was destroyed");
			FAIL;
		} else
			CHECK;
		RESTORE_ERROR(Dsp);

		if (atts.map_state == IsUnmapped)
			CHECK;
		else {
			report("For close-down mode %d", modes[i]);
			report("save-set window was affected");
			FAIL;
		}
	}

	CHECKPASS(2*NELEM(modes));
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.25889 */
/* End of included file Mval.tmc.25889 */

/* Including from file error/EVal.mc */
static void t007(){

#undef	VALUE_ARG
#define	VALUE_ARG close_mode
#undef	VALUE_LIST
#define	VALUE_LIST close_modevallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetCloseDownMode-7.(A)");
	report_assertion("When the value of close_mode is other than DestroyAll,");
	report_assertion("RetainPermanent or RetainTemporary, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XSetCloseDownMode(display, close_mode);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
