/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XMatchVisualInfo(display, screen, depth, class, vinfo)
 *   Display	*display;
 *   int 	screen;
 *   int 	depth;
 *   int 	class;
 *   XVisualInfo	*vinfo;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XMatchVisualInfo	1
char    *TestName = "XMatchVisualInfo";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XMatchVisualInfo function
 */
static Display	*display;
static int 	screen;
static int 	depth;
static int 	class;
static XVisualInfo	*vinfo;


static int 	StatusReturn;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	screen = DefaultScreen(Dsp);
	depth = 0;
	class = 0;
	vinfo = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status	s;
XVisualInfo	vi;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XMatchVisualInfo-1.(A)");
	report_assertion("When a visual exists on screen screen of depth depth and of");
	report_assertion("class class, then a call to XMatchVisualInfo returns the");
	report_assertion("associated XVisualInfo structure in the vinfo_return");
	report_assertion("argument, and returns non-zero.");

	report_strategy("Initialise the list of class/depth pairs from parameter XT_VISUAL_CLASSES.");
	report_strategy("For each class/depth pair:");
	report_strategy("  Call XMatchVisualInfo.");
	report_strategy("  Verify that XMatchVisualInfo does not return zero.");
	report_strategy("  Verify that class and depth of returned structure are correct.");

	tpstartup();
	setargs();
/* Initialise the list of class/depth pairs from parameter XT_VISUAL_CLASSES. */
	if(initvclass() < 0) {
		delete("The list of expected visual classes could not be initialised.");
		return;
	}
	vinfo = &vi;
/* For each class/depth pair: */
	for (resetvclass(); nextvclass(&class, &depth); ) {

/*   Call xname. */
		startcall(display);
		if (isdeleted())
			return;
		s = XMatchVisualInfo(display, screen, depth, class, vinfo);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		trace("Matching depth=%d, class=%s", depth, displayclassname(class));

/*   Verify that xname does not return zero. */
		if (s == 0) {
			report("%s returned 0 with depth=%d, class=%s", 
				TestName, depth, displayclassname(class));
			FAIL;
/*   Verify that class and depth of returned structure are correct. */
		} else if (vi.class != class || vi.depth != depth) {
			/*
			 * Since the actual visual returned is not defined then
			 * all we can do is check that class and depth are OK
			 * and output all the other fields for regression test purposes.
			 */
			report(" Incorrect class or depth found");
			report(" Got %s, depth %d", displayclassname(vi.class), vi.depth);
			report(" Expecting %s, depth", displayclassname(class),
				depth);
			FAIL;
		} else {
			trace(" visualid=0x%x, screen=%d, depth=%u, class=%s",
				vi.visualid, vi.screen, vi.depth,
				displayclassname(vi.class));
			trace(" red_mask=0x%x, green_mask=0x%x, blue_mask=0x%x",
				vi.red_mask,
				vi.green_mask,
				vi.blue_mask);
			trace(" colormap_size=%d, bits_per_rgb=%d",
				vi.colormap_size,
				vi.bits_per_rgb);

			CHECK;
		}
	}

	CHECKPASS(nvclass());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status	s;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XMatchVisualInfo-2.(A)");
	report_assertion("When a visual does not exist on screen screen of depth");
	report_assertion("depth and of class class, then a call to XMatchVisualInfo");
	report_assertion("returns zero.");

	report_strategy("Call XMatchVisualInfo with depth zero.");
	report_strategy("Verify that XMatchVisualInfo returns zero.");

	tpstartup();
	setargs();
	/*
	 * Try with a depth of 0 which is always invalid.
	 */
	depth = 0;
	class = StaticColor;

	startcall(display);
	if (isdeleted())
		return;
	s = XMatchVisualInfo(display, screen, depth, class, vinfo);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (s == 0)
		CHECK;
	else {
		report("Return value was %d", s);
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
