# Checks whether the gtest library is available on the system
# Allows for adjusting the include and library path.
# Sets have_gtest=yes if the library is present and
# reports the compiler and linker flags in 
# GTEST_CXXFLAGS AND GTEST_LDFLAGS, respectively.
AC_DEFUN([AC_CHECK_GTEST],
[
  AC_ARG_WITH([gtest-include-path],
  [AS_HELP_STRING([--with-gtest-include-path],
    [location of the Google test headers, defaults to /usr/include])],
  [GTEST_CPPFLAGS="-I$withval"])

  AC_ARG_WITH([gtest-lib-path],
  [AS_HELP_STRING([--with-gtest-lib-path], [location of the Google test libraries])],
  [GTEST_LDFLAGS="-L$withval -lpthread"],
  [GTEST_LDFLAGS='-lpthread'])

  AC_LANG_PUSH(C++)

  AC_CHECK_LIB([gtest], [main], [:], [:], [$GTEST_LDFLAGS])

  AC_LANG_POP
]) # AC_CHECK_GTEST

