.\" Copyright (C) 1989-95 GROUPE BULL
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
.\" GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
.\" AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of GROUPE BULL shall not be
.\" used in advertising or otherwise to promote the sale, use or other dealings
.\" in this Software without prior written authorization from GROUPE BULL.
.\"
.hw XImage
.TH  XpmCreatePixmap __libmansuffix__ __xorgversion__ "libXpm functions"
.SH NAME
XpmCreatePixmap \- create a pixmap
.SH SYNOPSIS
.HP
int XpmCreatePixmapFromData(Display *display, Drawable d, char **data, Pixmap *pixmap_return, Pixmap *shapemask_return, XpmAttributes *attributes);
.HP
int XpmCreatePixmapFromBuffer(Display *display, Drawable d, char *buffer, Pixmap *pixmap_return, Pixmap *shapemask_return, XpmAttributes *attributes);
.HP
int XpmCreatePixmapFromXpmImage(Display *display, Drawable d, XpmImage *image, Pixmap *pixmap_return, Pixmap *shapemask_return, XpmAttributes *attributes);

.SH ARGUMENTS

.IP \fIdisplay\fP li
Specifies the connection to the X server.
.IP \fId\fP li
Specifies which screen the pixmap is created on.
.IP \fIbuffer\fP li
Specifies the location of the buffer.
.IP \fIpixmap_return\fP li
Returns the pixmap which is created if the color None.
.IP \fIshapemask_return\fP li
Returns the shape mask pixmap which is created if the color None is used.
.IP \fIattributes\fP li
Specifies the location of a structure to get and store information.
.IP \fIimage\fP li
Specifies the XpmImage.

.SH DESCRIPTION
.SS XpmCreatePixmapFromData
To create a Pixmap from an XPM data, use XpmCreatePixmapFromData.
The XpmCreatePixmapFromData function creates X images using XpmCreateImageFromData() and
thus returns the same errors. In addition on success it then creates the related pixmaps, using XPutImage,
which are returned to pixmap_return and shapemask_return if not NULL, and finally destroys the created images using XDestroyImage.
Do not forget to free the returned pixmaps, the colors, and possibly the data returned into the XpmAttributes structure when done.

.SS XpmCreatePixmapFromBuffer
To create a Pixmap from an XPM buffer, use XpmCreatePixmapFromBuffer.
The XpmCreatePixmapFromBuffer function works the same way as XpmReadFileToPixmap (),
it just calls XpmCreateImageFromBuffer instead of XpmReadFileToImage.

.SS XpmCreatePixmapFromXpmImage
XpmCreatePixmapFromXpmImage creates X images calling XpmCreateImageFromXpmImage () with
the given XpmImage and XpmAttributes, then it creates the related pixmaps which are returned topixmap_return
and shapemask_return using XPutImage.
Finally it destroys the X images with XDestroyImage.
When finished the caller must free the pixmaps using XFreePixmap, the colors using XFreeColors or the application
equivalent function when the standard Xlib functions are not used, and possibly the data returned into the
XpmAttributes using XpmFreeAttributes.

.SH "SEE ALSO"
.BR XpmCreatePixmapFromBuffer(__libmansuffix__) ,
.BR XpmCreatePixmapFromData(__libmansuffix__) ,
.BR XpmCreatePixmapFromXpmImage(__libmansuffix__)
