'\" t
.\"     Title: xsetdevicebuttonmapping
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.74.3 <http://docbook.sf.net/>
.\"      Date: 06/19/2009
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XSETDEVICEBUTTONMAPP" "libmansuffix" "06/19/2009" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XSetDeviceButtonMapping, XGetDeviceButtonMapping \- query or change device button mappings
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
int XSetDeviceButtonMapping( Display *display,
                             XDevice *device,
                             unsigned char map[],
                             int nmap);
.fi
.sp
.nf
int XGetDeviceButtonMapping( Display *display,
                             XDevice *device,
                             unsigned char map_return[],
                             int nmap);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device whose button mapping is to be
       queried or changed\&.
.fi
.sp
.nf
map
       Specifies the mapping list\&.
.fi
.sp
.nf
map_return
       Returns the mapping list\&.
.fi
.sp
.nf
nmap
       Specifies the number of items in the mapping list\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The XSetDeviceButtonMapping request sets the mapping of the
specified device\&. If it succeeds, the X server generates a
DeviceMappingNotify event, and XSetDeviceButtonMapping returns
MappingSuccess\&. Element map[i] defines the logical button
number for the physical button i+1\&. The length of the list must
be the same as XGetDeviceButtonMapping would return, or a
BadValue error results\&. A zero element disables a button, and
elements are not restricted in value by the number of physical
buttons\&. However, no two elements can have the same nonzero
value, or a BadValue error results\&. If any of the buttons to be
altered are logically in the down state,
XSetDeviceButtonMapping returns MappingBusy, and the mapping is
not changed\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XSetDeviceButtonMapping can generate BadDevice, BadMatch, and
BadValue errors\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XGetDeviceButtonMapping request returns the current mapping
of the specified device\&. Buttons are numbered starting from
one\&.XGetDeviceButtonMapping returns the number of physical
buttons actually on the device\&. The nominal mapping for a
device is map[i]=i+1\&. The nmap argument specifies the length of
the array where the device mapping is returned, and only the
first nmap elements are returned in map_return\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XGetDeviceButtonMapping can generate BadDevice or BadMatch
errors\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The specified device
       does not exist or has not been opened by this client via
       XOpenInputDevice\&. This error may also occur if the
       specified device is the X keyboard or X pointer device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       This error may occur if an XGetDeviceButtonMapping or
       XSetDeviceButtonMapping request was made specifying a
       device that has no buttons\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       Some numeric value falls outside the range of values
       accepted by the request\&. Unless a specific range is
       specified for an argument, the full range defined by the
       argument\'s type is accepted\&. Any argument defined as a
       set of alternatives can generate this error\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
.if n \{\
.RS 4
.\}
.nf
XChangeDeviceKeyboardControl(libmansuffix), XChangeDeviceKeyMapping(libmansuffix),
XChangeDeviceModifierMapping(libmansuffix)
.fi
.if n \{\
.RE
.\}
