.\"
.\" $XdotOrg: lib/Xevie/man/Xevie.man,v 1.2 2005/04/04 02:41:49 alanc Exp $
.\"
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XEVIE __libmansuffix__ __vendorversion__

.SH NAME
Xevie \- X Event Interception Extension (XEvIE)
.SH SYNTAX
\&#include <X11/extensions/Xevie.h>
.nf    
.sp
Status XevieQueryVersion \^(\^Display *\fIdpy\fP,
	int *\fImajor_versionp\fP,
	int *\fIminor_versionp\fP\^);
.sp
Status XevieStart     \^(\^Display *\fIdpy\fp\^);
.sp
Status XevieSelectInput     \^(\^Display *\fIdpy\fP,
	long \fIevent_mask\fP\^);
.sp
Status XevieSendEvent \^(\^
    \^(\^Display *\fIdpy\fP,
    XEvent *\fIevent\fP,
    char   *fIdataType\fP\^);
.sp
Status XevieEnd     \^(\^Display *\fIdpy\fp\^);
.sp

.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIevent_mask\fP 1i
Specifies the mask of events to redirect.
.IP \fIdatatype\fP 1i

XEVIE_MODIFIED or XEVIE_UNMODIFIED - whether the Xevie client
has changed or synthesised this event.

.SH DATATYPES


.SH DESCRIPTION
.B X Event Interception Extension (XEvIE) 
is designed for users who need to intercept all the Keyboard and Mouse events.
Programs can determine which events should be forwarded to other clients and
modify the events if necessary.
.PP

.SH FUNCTIONS

.B XevieQueryVersion
The XevieQueryVersion function returns the major and minor protocol version 
numbers supported by the server.
XevieQueryVersion returns True if success, otherwise, it returns False.

.B XevieStart
The XevieStart function requests that the X server enable the XEvIE extension.
Once XEvIE is successfully enabled, all the XevieSelectInput specified events 
will be sent to the client which has enabled XEvIE.
If XKB or AccessX is enabled, the events that are sent to the XEvIE clients
are XKB/AccessX processed (filtered) ones.

.B XevieSendEvent
Events are sent back to the X server through XevieSendEvent.

.B XevieEnd
The XevieEnd function requests that the X server disables the XEvIE extension.
Once XEvIE is disabled successfully, the X server stops sending events to the
XEvIE client.

.B XevieSelectInput
The XevieSelectInput function requests that the X server reports the keyboard 
and pointer events associated with the specified event mask.
By default, X will report KeyPress, KeyRelease, ButtonPress, ButtonRelease
and MotionNotify events.

.SH RESTRICTIONS
.B Xevie
will remain upward compatible after the current 1.0 release.
.SH AUTHORS
Derek Wang and Stuart Kreitman, Sun Microsystems, Inc.

