'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetNames __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetNames \- Obtain symbolic names from the server
.SH SYNOPSIS
.HP
.B Status XkbGetNames
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "XkbDescPtr " "Xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to the X server
.TP
.I \- which
mask of names or map components to be updated
.TP
.I \- Xkb
keyboard description to be updated
.SH DESCRIPTION
.LP
.I XkbGetNames 
retrieves symbolic names for the components of the keyboard extension from the X server. The 
.I which 
parameter specifies the name components to be updated in the 
.I xkb 
parameter, and is the bitwise inclusive OR of the valid names mask bits defined in Table 1.


.TS
c s s s
l l l l.
Table 1 Symbolic Names Masks
_
Mask Bit	Value	Keyboard	Field
		Component
_
XkbKeycodesNameMask	(1<<0)	Xkb->names	keycodes
XkbGeometryNameMask	(1<<1)	Xkb->names	geometry
XkbSymbolsNameMask	(1<<2)	Xkb->names	symbols
XkbPhysSymbolsNameMask	(1<<3)	Xkb->names	phys_symbols
XkbTypesNameMask	(1<<4)	Xkb->names	type
XkbCompatNameMask	(1<<5)	Xkb->names	compat
XkbKeyTypeNamesMask	(1<<6)	Xkb->map	type[*].name
XkbKTLevelNamesMask	(1<<7)	Xkb->map	type[*].lvl_names[*]
XkbIndicatorNamesMask	(1<<8)	Xkb->names	indicators[*]
XkbKeyNamesMask	(1<<9)	Xkb->names	keys[*], num_keys
XkbKeyAliasesMask	(1<<10)	Xkb->names	key_aliases[*], num_key_aliases
XkbVirtualModNamesMask	(1<<11)	Xkb->names	vmods[*]
XkbGroupNamesMask	(1<<12)	Xkb->names	groups[*]
XkbRGNamesMask	(1<<13)	Xkb->names	radio_groups[*], num_rg
XkbComponentNamesMask	(0x3f)	Xkb->names	keycodes,
			geometry,
			symbols,
			physical symbols,
			types, and
			compatibility map
XkbAllNamesMask	(0x3fff)	Xkb->names	all name components
.TE

If the 
.I names 
field of the keyboard description 
.I xkb 
is NULL, 
.I XkbGetNames 
allocates and initializes the 
.I names 
component of the keyboard description before obtaining the values specified by
.I which. 
If the 
.I names field of 
.I xkb 
is not NULL, 
.I XkbGetNames 
obtains the values specified by 
.I which 
and copies them into the keyboard description 
.I Xkb.

If the 
.I map 
component of the 
.I xkb 
parameter is NULL, 
.I XkbGetNames 
does not retrieve type or shift level names, even if XkbKeyTypeNamesMask or XkbKTLevelNamesMask are set in 
.I which.

.I XkbGetNames 
can return Success, or BadAlloc, BadLength, BadMatch, and BadImplementation errors.

To free symbolic names, use 
.I XkbFreeNames.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadImplementation
Invalid reply from server
.TP 15
.B BadLength
The length of a request is shorter or longer than that required to minimally contain the arguments
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has correct type and range, but 
is otherwise invalid
.SH "SEE ALSO"
.BR XkbFreeNames (__libmansuffix__)

