.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbGetAccessXTimeout __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetAccessXTimeout \- Queries the current AccessXTimeout options for a 
keyboard device
.SH SYNOPSIS
.HP
.B Bool XkbGetAccessXTimeout
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned short *" "timeout_rtrn" "\^,"
.BI "unsigned int *" "ctrls_mask_rtrn" "\^,"
.BI "unsigned int *" "ctrls_values_rtrn" "\^,"
.BI "unsigned short *" "options_mask_rtrn" "\^,"
.BI "unsigned short *" "options_values_rtrn" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
unsigned short
.TP
.I \- device_spec
device to query, or XkbUseCoreKbd 
.TP
.I \- timeout_rtrn
delay until AccessXTimeout, seconds
.TP
.I \- ctrls_mask_rtrn
backfilled with controls to modify
.TP
.I \- ctrls_values_rtrn
backfilled with on/off status for controls
.TP
.I \- options_mask_rtrn
backfilled with ax_options to modify
.TP
.I \- options_values_rtrn
backfilled with values for ax_options
.SH DESCRIPTION
.LP
In environments where computers are shared, features such as SlowKeys present a 
problem: if 
SlowKeys is on, the keyboard can appear to be unresponsive because keys are not 
accepted 
until they are held for a certain period of time. To help solve this problem, 
Xkb provides 
an AccessXTimeout control to automatically change the enabled/disabled state of 
any boolean 
controls and to change the value of the AccessXKeys and AccessXFeedback control 
attributes 
if the keyboard is idle for a specified period of time.

When a timeout as specified by AccessXTimeout occurs and a control is 
consequently modified, 
Xkb generates an XkbControlsNotify event.

.I XkbGetAccessXTimeout 
sends a request to the X server to obtain the current values for the 
AccessXTimeout attributes, waits for a reply, and backfills the values into the 
appropriate arguments. The parameters 
.I options_mask_rtrn 
and 
.I options_values_rtrn 
are backfilled with the options to modify and the values for 
.I ax_options, 
which is a field in the XkbControlsRec structure.
.I XkbGetAccessXTimeout 
returns True if successful; if a compatible version of the Xkb extension is not 
available in the server, 
.I XkbGetAccessXTimeout 
returns False.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbGetAccessXTimeout 
returns True when it successfully sends a request to the X server to obtain the 
current values for the AccessXTimeout attributes, waits for a reply, and 
backfills the values into the appropriate arguments.
.TP 15
False
The 
.I XkbGetAccessXTimeout 
funtion returns False if a compatible version of the Xkb extension is not 
available in the 
server.
.SH STRUCTURES
.LP
.nf
The XkbControlsRec structure is defined as follows:

\&#define XkbMaxLegalKeyCode     255
\&#define XkbPerKeyBitArraySize  ((XkbMaxLegalKeyCode+1)/8)
    
typedef struct {
    unsigned char   mk_dflt_btn;      /\(** default button for keyboard driven mouse */
    unsigned char   num_groups;       /\(** number of keyboard groups */
    unsigned char   groups_wrap;      /\(** how to wrap out-of-bounds groups */
    XkbModsRec      internal;         /\(** defines server internal modifiers */
    XkbModsRec      ignore_lock;      /\(** modifiers to ignore when checking for grab */
    unsigned int    enabled_ctrls;    /\(** 1 bit => corresponding boolean control enabled */
    unsigned short  repeat_delay;     /\(** ms delay until first repeat */
    unsigned short  repeat_interval;  /\(** ms delay between repeats */
    unsigned short  slow_keys_delay;  /\(** ms minimum time key must be down to be ok */
    unsigned short  debounce_delay;   /\(** ms delay before key reactivated */
    unsigned short  mk_delay;         /\(** ms delay to second mouse motion event */
    unsigned short  mk_interval;      /\(** ms delay between repeat mouse events */
    unsigned short  mk_time_to_max;   /\(** # intervals until constant mouse move */
    unsigned short  mk_max_speed;     /\(** multiplier for maximum mouse speed */
    short           mk_curve;         /\(** determines mouse move curve type */
    unsigned short  ax_options;       /\(** 1 bit => Access X option enabled */
    unsigned short  ax_timeout;       /\(** seconds until Access X disabled */
    unsigned short  axt_opts_mask;    /\(** 1 bit => options to reset on Access X timeout */
    unsigned short  axt_opts_values;  /\(** 1 bit => turn option on, 0=> off */
    unsigned int    axt_ctrls_mask;   /\(** which bits in enabled_ctrls to modify */
    unsigned int    axt_ctrls_values; /\(** values for new bits in enabled_ctrls */
    unsigned char   per_key_repeat[XkbPerKeyBitArraySize];  /\(** per key auto repeat */
} XkbControlsRec, *XkbControlsPtr;
.fi
