'\" e
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XGetRes.man,v 1.3 2001/02/09 03:47:45 tsi Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" e
.TH XrmGetResource __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XrmGetResource, XrmQGetResource, XrmQGetSearchList, XrmQGetSearchResource \- retrieve database resources and search lists
.SH SYNTAX
.HP
Bool XrmGetResource\^(\^XrmDatabase \fIdatabase\fP\^, char *\fIstr_name\fP\^,
char *\fIstr_class\fP\^, char **\fIstr_type_return\fP\^, XrmValue
*\fIvalue_return\fP\^); 
.HP
Bool XrmQGetResource\^(\^XrmDatabase \fIdatabase\fP\^, XrmNameList
\fIquark_name\fP\^, XrmClassList \fIquark_class\fP\^, XrmRepresentation
*\fIquark_type_return\fP\^, XrmValue *\fIvalue_return\fP\^); 
.HP
typedef XrmHashTable *XrmSearchList;
.sp
Bool XrmQGetSearchList\^(\^XrmDatabase \fIdatabase\fP\^, XrmNameList
\fInames\fP\^, XrmClassList \fIclasses\fP\^, XrmSearchList
\fIlist_return\fP\^, int \fIlist_length\fP\^); 
.HP
Bool XrmQGetSearchResource\^(\^XrmSearchList \fIlist\fP\^, XrmName
\fIname\fP\^, XrmClass \fIclass\fP\^, XrmRepresentation *\fItype_return\fP\^, 
XrmValue *\fIvalue_return\fP\^); 
.SH ARGUMENTS
.IP \fIclass\fP 1i
Specifies the resource class.
.IP \fIclasses\fP 1i
Specifies a list of resource classes.
.IP \fIdatabase\fP 1i
Specifies the database that is to be used.
.IP \fIlist\fP 1i
Specifies the search list returned by
.ZN XrmQGetSearchList .
.IP \fIlist_length\fP 1i
Specifies the number of entries (not the byte size) allocated for list_return.
.IP \fIlist_return\fP 1i
Returns a search list for further use.
.IP \fIname\fP 1i
Specifies the resource name.
.IP \fInames\fP 1i
Specifies a list of resource names.
.IP \fIquark_class\fP 1i
Specifies the fully qualified class of the value being retrieved (as a quark).
.IP \fIquark_name\fP 1i
Specifies the fully qualified name of the value being retrieved (as a quark).
.IP \fIquark_type_return\fP 1i
Returns the representation type of the destination (as a quark).
.IP \fIstr_class\fP 1i
Specifies the fully qualified class of the value being retrieved (as a string).
.IP \fIstr_name\fP 1i
Specifies the fully qualified name of the value being retrieved (as a string).
.IP \fIstr_type_return\fP 1i
Returns the representation type of the destination (as a string).
.IP \fItype_return\fP 1i
Returns data representation type.
.IP \fIvalue_return\fP 1i
Returns the value in the database.
.SH DESCRIPTION
The 
.ZN XrmGetResource 
and 
.ZN XrmQGetResource 
functions retrieve a resource from the specified database.
Both take a fully qualified name/class pair, a destination
resource representation, and the address of a value
(size/address pair).  
The value and returned type point into database memory;
therefore, you must not modify the data.
.LP
The database only frees or overwrites entries on
.ZN XrmPutResource , 
.ZN XrmQPutResource ,
or 
.ZN XrmMergeDatabases .
A client that is not storing new values into the database or
is not merging the database should be safe using the address passed 
back at any time until it exits.
If a resource was found, both
.ZN XrmGetResource 
and
.ZN XrmQGetResource 
return 
.ZN True ;
otherwise, they return 
.ZN False .
.LP
The
.ZN XrmQGetSearchList
function takes a list of names and classes
and returns a list of database levels where a match might occur.
The returned list is in best-to-worst order and
uses the same algorithm as 
.ZN XrmGetResource 
for determining precedence.
If list_return was large enough for the search list,
.ZN XrmQGetSearchList
returns 
.ZN True ;
otherwise, it returns
.ZN False .
.LP
The size of the search list that the caller must allocate is
dependent upon the number of levels and wildcards in the resource specifiers 
that are stored in the database.
The worst case length is %3 sup n%,
where \fIn\fP is the number of name or class components in names or classes.
.LP
When using 
.ZN XrmQGetSearchList 
followed by multiple probes for resources with a common name and class prefix,
only the common prefix should be specified in the name and class list to 
.ZN XrmQGetSearchList .
.LP
The
.ZN XrmQGetSearchResource
function searches the specified database levels for the resource 
that is fully identified by the specified name and class.
The search stops with the first match.
.ZN XrmQGetSearchResource
returns 
.ZN True 
if the resource was found;
otherwise, it returns
.ZN False .
.LP
A call to 
.ZN XrmQGetSearchList 
with a name and class list containing all but the last component 
of a resource name followed by a call to 
.ZN XrmQGetSearchResource 
with the last component name and class returns the same database entry as 
.ZN XrmGetResource 
and 
.ZN XrmQGetResource 
with the fully qualified name and class.
.SH "MATCHING RULES"
The algorithm for determining which resource database entry
matches a given query is the heart of the resource manager.
All queries must fully specify the name and class of the desired resource
(use of the characters ``*'' and ``?'' are not permitted).
The library supports up to 100 components in a full name or class.
Resources are stored in the database with only partially specified
names and classes, using pattern matching constructs.
An asterisk (*) is a loose binding and is used to represent any number
of intervening components, including none.
A period (.) is a tight binding and is used to separate immediately
adjacent components.
A question mark (?) is used to match any single component name or class.
A database entry cannot end in a loose binding;
the final component (which cannot be the character ``?'') must be specified.
The lookup algorithm searches the database for the entry that most
closely matches (is most specific for) the full name and class being queried.
When more than one database entry matches the full name and class,
precedence rules are used to select just one.
.LP
The full name and class are scanned from left to right (from highest
level in the hierarchy to lowest), one component at a time.
At each level, the corresponding component and/or binding of each
matching entry is determined, and these matching components and
bindings are compared according to precedence rules.
Each of the rules is applied at each level before moving to the next level,
until a rule selects a single entry over all others.
The rules, in order of precedence, are:
.IP 1. 5
An entry that contains a matching component (whether name, class,
or the character ``?'')
takes precedence over entries that elide the level (that is, entries
that match the level in a loose binding).
.IP 2. 5
An entry with a matching name takes precedence over both
entries with a matching class and entries that match using the character ``?''.
An entry with a matching class takes precedence over
entries that match using the character ``?''.
.IP 3. 5
An entry preceded by a tight binding takes precedence over entries
preceded by a loose binding.
.SH "SEE ALSO"
XrmInitialize(__libmansuffix__),
XrmMergeDatabases(__libmansuffix__),
XrmPutResource(__libmansuffix__),
XrmUniqueQuark(__libmansuffix__)
.br
\fI\*(xL\fP
