'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAllocServerMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocServerMap \- Allocate and initialize an empty server map description record
.SH SYNOPSIS
.HP
.B Status XkbAllocServerMap
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "unsigned int " "count_acts" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description in which to allocate server map
.TP
.I \- which
mask selecting map components to allocate
.TP
.I \- count_acts
value of num_acts field in map to be allocated
.SH DESCRIPTION
.LP
.I XkbAllocServerMap 
allocates and initializes an empty server map in the 
.I server 
field of the keyboard description specified by 
.I xkb. 
The 
.I which 
parameter specifies the particular components of the server map structure to allocate, as specified in Table 1. 

.TS
c s
l l
l lw(4i).
Table 1 XkbAllocServerMap Masks
_
Mask	Effect
_
XkbExplicitComponentsMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to
allocate the explicit field of the server map.
T}
.sp
XkbKeyActionsMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to allocate the key_acts field of the server map. The count_acts parameter is used to allocate the acts field of the server map.
T}
.sp
XkbKeyBehaviorsMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to allocate the behaviors field of the server map.
T}
.sp
XkbVirtualModMapMask	T{
The min_key_code and max_key_code fields of the xkb parameter are used to allocate the vmodmap field of the server map.
T}

.TE

If the server map of the keyboard description is not NULL and any fields are already allocated in the server map, 
.I XkbAllocServerMap 
does not overwrite the existing values. The only exception is with the 
.I acts 
array. If the 
.I count_acts 
parameter is greater than the current 
.I num_acts 
field of the server map, 
.I XkbAllocServerMap 
resizes the 
.I acts 
array and resets the 
.I num_acts 
field accordingly.

If 
.I XkbAllocServerMap 
is successful, it returns Success. Otherwise, it can return either BadMatch or BadAlloc errors.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has correct type and range, but is otherwise invalid
.TP 15
.B BadValue
An argument is out of range
.SH NOTES
.LP
The 
.I min_key_code 
and 
.I max_key_code 
fields of the 
.I xkb 
parameter must be legal values. If they are not valid, 
.I XkbAllocServerMap 
returns BadValue. 
