.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XGetWProp.man,v 1.2 2001/01/27 18:19:59 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XGetWindowProperty __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGetWindowProperty, XListProperties, XChangeProperty, XRotateWindowProperties, XDeleteProperty \- obtain and change window properties
.SH SYNTAX
.HP
int XGetWindowProperty\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, Atom
\fIproperty\fP\^, long \fIlong_offset\fP\^, long \fIlong_length\fP\^, Bool
\fIdelete\fP\^, Atom \fIreq_type\fP\^, Atom *\fIactual_type_return\fP\^, int
*\fIactual_format_return\fP\^, unsigned long *\fInitems_return\fP\^, unsigned
long *\fIbytes_after_return\fP\^, unsigned char **\fIprop_return\fP\^); 
.HP
Atom *XListProperties\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, int
*\fInum_prop_return\fP\^); 
.HP
int XChangeProperty\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, Atom
\fIproperty\fP\^, Atom \fItype\fP\^, int \fIformat\fP\^, int \fImode\fP\^,
unsigned char *\fIdata\fP\^, int \fInelements\fP\^); 
.HP
int XRotateWindowProperties\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
Atom \fIproperties\fP\^[]\^, int \fInum_prop\fP\^, int \fInpositions\fP\^); 
.HP
int XDeleteProperty\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, Atom
\fIproperty\fP\^); 
.SH ARGUMENTS
.IP \fIactual_format_return\fP 1i
Returns the actual format of the property.
.IP \fIactual_type_return\fP 1i
Returns the atom identifier  that defines the actual type of the property.
.IP \fIbytes_after_return\fP 1i
Returns the number of bytes remaining to be read in the property if 
a partial read was performed.
.IP \fIdata\fP 1i
Specifies the property data.
.IP \fIdelete\fP 1i
Specifies a Boolean value that determines whether the property is deleted.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIformat\fP 1i
Specifies whether the data should be viewed as a list
of 8-bit, 16-bit, or 32-bit quantities.
Possible values are 8, 16, and 32.
This information allows the X server to correctly perform
byte-swap operations as necessary.
If the format is 16-bit or 32-bit,
you must explicitly cast your data pointer to an (unsigned char *) in the call
to 
.ZN XChangeProperty .
.IP \fIlong_length\fP 1i
Specifies the length in 32-bit multiples of the data to be retrieved.
.IP \fIlong_offset\fP 1i
Specifies the offset in the specified property (in 32-bit quantities) 
where the data is to be retrieved.
.\" Changed name of this file to prop_mode.a on 1/13/87
.IP \fImode\fP 1i
Specifies the mode of the operation.
You can pass
.ZN PropModeReplace ,
.ZN PropModePrepend ,
or
.ZN PropModeAppend .
.IP \fInelements\fP 1i
Specifies the number of elements of the specified data format.
.IP \fInitems_return\fP 1i
Returns the actual number of 8-bit, 16-bit, or 32-bit items 
stored in the prop_return data.
.IP \fInum_prop\fP 1i
Specifies the length of the properties array.
.IP \fInum_prop_return\fP 1i
Returns the length of the properties array.
.IP \fInpositions\fP 1i
Specifies the rotation amount.
.IP \fIprop_return\fP 1i
Returns the data in the specified format.
If the returned format is 8, the returned data is represented as a
char array. If the returned format is 16, the returned data is
represented as a array of short int type and should be cast to that
type to obtain the elements. If the returned format is 32, the
property data will be stored as an array of longs (which in a 64-bit
application will be 64-bit values that are padded in the upper 4 bytes).
.IP \fIproperty\fP 1i
Specifies the property name.
.IP \fIproperties\fP 1i
Specifies the array of properties that are to be rotated.
.IP \fIreq_type\fP 1i
Specifies the atom identifier associated with the property type or
.ZN AnyPropertyType .
.IP \fItype\fP 1i
Specifies the type of the property.
The X server does not interpret the type but simply
passes it back to an application that later calls 
.ZN XGetWindowProperty .
.ds Wi whose property you want to obtain, change, rotate or delete
.IP \fIw\fP 1i
Specifies the window \*(Wi.
.SH DESCRIPTION
The
.ZN XGetWindowProperty
function returns the actual type of the property; the actual format of the property;
the number of 8-bit, 16-bit, or 32-bit items transferred; the number of bytes remaining
to be read in the property; and a pointer to the data actually returned.
.ZN XGetWindowProperty
sets the return arguments as follows:
.IP \(bu 5
If the specified property does not exist for the specified window,
.ZN XGetWindowProperty 
returns 
.ZN None
to actual_type_return and the value zero to 
actual_format_return and bytes_after_return.
The nitems_return argument is empty.
In this case, the delete argument is ignored.
.IP \(bu 5
If the specified property exists 
but its type does not match the specified type,
.ZN XGetWindowProperty 
returns the actual property type to actual_type_return, 
the actual property format (never zero) to actual_format_return, 
and the property length in bytes
(even if the actual_format_return is 16 or 32) 
to bytes_after_return.
It also ignores the delete argument.
The nitems_return argument is empty.
.IP \(bu 5
If the specified property exists and either you assign 
.ZN AnyPropertyType 
to the req_type argument or the specified type matches the actual property type,
.ZN XGetWindowProperty 
returns the actual property type to actual_type_return and the actual
property format (never zero) to actual_format_return. 
It also returns a value to bytes_after_return and nitems_return, by 
defining the following
values:
.IP
.nf
	N = actual length of the stored property in bytes
	     (even if the format is 16 or 32)
	I = 4 * long_offset
	T = N - I
	L = MINIMUM(T, 4 * long_length)
	A = N - (I + L)
.fi
.IP
The returned value starts at byte index I in the property (indexing
from zero), and its length in bytes is L.
If the value for long_offset causes L to be negative,
a
.ZN BadValue
error results. 
The value of bytes_after_return is A, 
giving the number of trailing unread bytes in the stored property.
.LP
If the returned format is 8, the returned data is represented as a
.ZN char
array.
If the returned format is 16, the returned data is represented as a
.ZN short
array and should be cast to that type to obtain the elements.
If the returned format is 32, the returned data is represented as a
.ZN long
array and should be cast to that type to obtain the elements.
.LP
.ZN XGetWindowProperty
always allocates one extra byte in prop_return 
(even if the property is zero length) 
and sets it to zero so that simple properties consisting of characters
do not have to be copied into yet another string before use.
.LP
If delete is 
.ZN True 
and bytes_after_return is zero, 
.ZN XGetWindowProperty
deletes the property 
from the window and generates a 
.ZN PropertyNotify 
event on the window.
.LP
The function returns
.ZN Success
if it executes successfully.
To free the resulting data,
use
.ZN XFree .
.LP
.ZN XGetWindowProperty
can generate
.ZN BadAtom ,
.ZN BadValue ,
and
.ZN BadWindow 
errors.
.LP
The
.ZN XListProperties
function returns a pointer to an array of atom properties that are defined for 
the specified window or returns NULL if no properties were found.
To free the memory allocated by this function, use
.ZN XFree .
.LP
.ZN XListProperties
can generate a
.ZN BadWindow 
error.
.LP
The
.ZN XChangeProperty
function alters the property for the specified window and
causes the X server to generate a
.ZN PropertyNotify
event on that window.
.ZN XChangeProperty
performs the following:
.IP \(bu 5
If mode is
.ZN PropModeReplace ,
.ZN XChangeProperty
discards the previous property value and stores the new data.
.IP \(bu 5
If mode is
.ZN PropModePrepend
or
.ZN PropModeAppend ,
.ZN XChangeProperty
inserts the specified data before the beginning of the existing data
or onto the end of the existing data, respectively.
The type and format must match the existing property value,
or a
.ZN BadMatch
error results.
If the property is undefined, 
it is treated as defined with the correct type and
format with zero-length data.
.LP
If the specified format is 8, the property data must be a
.ZN char
array.
If the specified format is 16, the property data must be a
.ZN short
array.
If the specified format is 32, the property data must be a
.ZN long
array.
.LP
The lifetime of a property is not tied to the storing client.
Properties remain until explicitly deleted, until the window is destroyed,
or until the server resets.
For a discussion of what happens when the connection to the X server is closed,
see section 2.6. 
The maximum size of a property is server dependent and can vary dynamically
depending on the amount of memory the server has available.
(If there is insufficient space, a
.ZN BadAlloc
error results.)
.LP
.ZN XChangeProperty
can generate
.ZN BadAlloc ,
.ZN BadAtom ,
.ZN BadMatch ,
.ZN BadValue ,
and
.ZN BadWindow 
errors.
.LP
The
.ZN XRotateWindowProperties
function allows you to rotate properties on a window and causes
the X server to generate
.ZN PropertyNotify
events.
If the property names in the properties array are viewed as being numbered 
starting from zero and if there are num_prop property names in the list,
then the value associated with property name I becomes the value associated 
with property name (I + npositions) mod N for all I from zero to N \- 1.
The effect is to rotate the states by npositions places around the virtual ring
of property names (right for positive npositions, 
left for negative npositions).
If npositions mod N is nonzero,
the X server generates a
.ZN PropertyNotify
event for each property in the order that they are listed in the array.
If an atom occurs more than once in the list or no property with that 
name is defined for the window,
a 
.ZN BadMatch 
error results.
If a 
.ZN BadAtom 
or 
.ZN BadMatch 
error results,
no properties are changed.
.LP
.ZN XRotateWindowProperties
can generate
.ZN BadAtom ,
.ZN BadMatch ,
and
.ZN BadWindow 
errors.
.LP
The
.ZN XDeleteProperty
function deletes the specified property only if the
property was defined on the specified window
and causes the X server to generate a
.ZN PropertyNotify
event on the window unless the property does not exist.
.LP
.ZN XDeleteProperty
can generate
.ZN BadAtom
and
.ZN BadWindow 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XFree(__libmansuffix__),
XInternAtom(__libmansuffix__)
.br
\fI\*(xL\fP
