.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbAddGeomKeyAlias __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAddGeomKeyAlias \- Add one key alias to an existing keyboard geometry 
description
.SH SYNOPSIS
.B XkbKeyAliasPtr XkbAddGeomKeyAlias
(
.I geom,
.I alias,
.I real
)
.br
      XkbGeometryPtr \fIgeom\fP\^;
.br
      char * \fIalias\fP\^;
.br
      char * \fIreal\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- geom
geometry to be updated
.TP
.I \- alias
alias to be added
.TP
.I \- real
real name to be bound to the new alias
.SH DESCRIPTION
.LP
Xkb provides functions to add a single new element to the top-level keyboard 
geometry. In each case the 
.I num_ * 
fields of the corresponding structure is incremented by 1. These functions do 
not change 
.I sz_* 
unless there is no more room in the array. Some of these functions fill in the 
values of the element's structure from the arguments. For other functions, you 
must explicitly write code to fill the structure's elements.

The top-level geometry description includes a list of 
.I geometry properties. 
A geometry property associates an arbitrary string with an equally arbitrary 
name. Programs that display images of keyboards can use geometry properties as 
hints, but they are not interpreted by Xkb. No other geometry structures refer 
to geometry properties.

.I XkbAddGeomKeyAlias 
adds one key alias with the value 
.I alias 
to the geometry 
.I geom, 
and associates it with the key whose real name is 
.I real. XkbAddGeomKeyAlias 
returns NULL if any of the parameters is empty or if it was not able to allocate 
space for the alias. To allocate space for an arbitrary number of aliases, use 
the 
.I XkbAllocGeomKeyAliases 
function.
.SH STRUCTURES
.LP
.nf

    typedef struct {
        char            real[XkbKeyNameLength];   /\(** this key name must be in the keys array */
        char            alias[XkbKeyNameLength];  /\(** symbolic key name as alias for the key */
    } XkbKeyAliasRec,*XkbKeyAliasPtr;
.fi
.SH "SEE ALSO"
.BR XkbAllocGeomKeyAliases (__libmansuffix__)
