'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbKeyTypesForCoreSymbols __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbKeyTypesForCoreSymbols \- Determine the Xkb key types appropriate for the 
symbols bound to a key in a core keyboard mapping
.SH SYNOPSIS
.B int XkbKeyTypesForCoreSymbols
(
.I xkb,
.I map_width,
.I core_syms,
.I protected,
.I types_inout,
.I xkb_syms_rtrn
)
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      int \fImap_width\fP\^;
.br
      KeySym * \fIcore_syms\fP\^;
.br
      unsigned int \fIprotected\fP\^;
.br
      int * \fItypes_inout\fP\^;
.br
      KeySym * \fIxkb_syms_rtrn\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
keyboard description in which to place symbols
.TP
.I \- map_width
width of core protocol keymap in xkb_syms_rtrn
.TP
.I \- core_syms
core protocol format array of KeySyms
.TP
.I \- protected
explicit key types
.TP
.I \- types_inout
backfilled with the canonical types bound to groups one and two for the key
.TP
.I \- xkb_syms_rtrn
backfilled with symbols bound to the key in the Xkb mapping
.SH DESCRIPTION
.LP
.I XkbKeyTypesForCoreSymbols 
expands the symbols in 
.I core_syms 
and types in 
.I types_inout,
then chooses canonical key types (canonical key types are 
defined The Canonical Key Types) for groups 1 and 2 using the rules specified by 
the Xkb protocol and places them in xkb_syms_rtrn, which will be non-NULL.

.B The Canonical Key Types

Xkb allows up to XkbMaxKeyTypes (255) key types to be defined, but requires at 
least XkbNumRequiredTypes (4) predefined types to be in a key map. These 
predefined key types are referred to as the canonical key types and describe the 
types of keys available on most keyboards. The definitions for the canonical key 
types are held in the first XkbNumRequiredTypes entries of the 
.I types 
field of the client map and are indexed using the following constants:
.nf

    XkbOneLevelIndex
    XkbTwoLevelIndex
    XkbAlphabeticIndex
    XkbKeypadIndex
    
.fi
    
ONE_LEVEL

The ONE_LEVEL key type describes groups that have only one symbol. The default 
ONE_LEVEL key type has no map entries and does not pay attention to any 
modifiers. A symbolic representation of this key type could look like the 
following:
.nf

    type "ONE_LEVEL" {
         modifiers = None;
         map[None]= Level1;
         level_name[Level1]= "Any";
    };
    
.fi    
The description of the ONE_LEVEL key type is stored in the 
types[XkbOneLevelIndex] entry of the client key map.

TWO_LEVEL

The TWO_LEVEL key type describes groups that consist of two symbols but are 
neither alphabetic nor numeric keypad keys. The default TWO_LEVEL type uses only 
the Shift modifier. It returns shift level two if Shift is set, and level one if 
it is not. A symbolic representation of this key type could look like the 
following:
.nf

    type "TWO_LEVEL" {
        modifiers = Shift;
        map[Shift]= Level2;
        level_name[Level1]= "Base";
        level_name[Level2]= "Shift";
    };
    
.fi
    
The description of the TWO_LEVEL key type is stored in the 
types[XkbTwoLevelIndex] entry of the client key map.

ALPHABETIC

The ALPHABETIC key type describes groups consisting of two symbols: the 
lowercase form of a symbol followed by the uppercase form of the same symbol. 
The default ALPHABETIC type implements locale-sensitive "Shift cancels CapsLock" 
behavior using both the Shift and Lock modifiers as follows:

.IP \(bu 5
If Shift and Lock are both set, the default ALPHABETIC type yields level one.
.IP \(bu 5
If Shift alone is set, it yields level two.
.IP \(bu 5
If Lock alone is set, it yields level one, but preserves the Lock modifier so 
Xlib notices and applies the appropriate capitalization rules. The Xlib 
functions are locale-sensitive and apply different capitalization rules for 
different locales.
.IP \(bu 5
If neither Shift nor Lock is set, it yields level one.

A symbolic representation of this key type could look like the following:
.nf

    type "ALPHABETIC" {
        modifiers = Shift+Lock;
        map[Shift]= Level2;
        preserve[Lock]= Lock;
        level_name[Level1]= "Base";
        level_name[Level2]= "Caps";
    };
    
.fi    
The description of the ALPHABETIC key type is stored in the 
types[XkbAlphabeticIndex] entry of the client key map.

KEYPAD

The KEYPAD key type describes groups that consist of two symbols, at least one 
of which is a numeric keypad symbol. The numeric keypad symbol is assumed to 
reside at level two. The default KEYPAD key type implements "Shift cancels 
NumLock" behavior using the Shift modifier and the real modifier bound to the 
virtual modifier named "NumLock," known as the NumLock modifier, as follows:

.IP \(bu 5
If Shift and NumLock are both set, the default KEYPAD type yields level one.
.IP \(bu 5
If Shift alone is set, it yields level two.
.IP \(bu 5
If NumLock alone is set, it yields level two.
.IP \(bu 5
If neither Shift nor NumLock is set, it yields level one.

A symbolic representation of this key type could look like the following:
.nf

    type "KEYPAD" {
        modifiers = Shift+NumLock;
        map[None]= Level1;
        map[Shift]= Level2;
        map[NumLock]= Level2;
        map[Shift+NumLock]= Level1;
        level_name[Level1]= "Base";
        level_name[Level2]= "Caps";
    };
    
.fi    
The description of the KEYPAD key type is stored in the types[XkbKeypadIndex] 
entry of the client key map.

A core keymap is a two-dimensional array of keysyms. It has 
.I map_width 
columns and 
.I max_key_code 
rows. 
.I XkbKeyTypesForCoreSymbols 
takes a single row from a core keymap, determines the number of groups 
associated with it, the type of each group, and the symbols bound to each group. 
The return value is the number of groups, 
.I types_inout 
has the types for each group, and 
.I xkb_syms_rtrn 
has the symbols in Xkb order (that is, groups are contiguous, regardless of 
size).

.I protected 
contains the explicitly protected key types. There is one  explicit override 
control associated with each of the four possible groups for each Xkb key, 
ExplicitKeyType1 through ExplicitKeyType4; 
.I protected 
is an inclusive OR of these controls. 
.I map_width 
is the width of the core keymap and is not dependent on any Xkb definitions.
.I types_inout 
is an array of four type indices. On input, 
.I types_inout 
contains the indices of any types already assigned to the key, in case they are 
explicitly protected from change.

Upon return, 
.I types_inout 
contains any automatically selected (that is, canonical) types plus any 
protected types. Canonical types are assigned to all four groups if there are 
enough symbols to do so. The four entries in 
.I types_inout 
correspond to the four groups for the key in question. 
