.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbGetDetectableAutorepeat __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetDetectableAutorepeat \- Determines whether or not the server supports 
DetectableAutorepeat
.SH SYNOPSIS
.B Bool XkbGetDetectableAutorepeat
(
.I display,
.I supported_rtrn
)
.br
      Display * \fIdisplay\fP\^;
.br
      Bool * \fIsupported_rtrn\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.TP
.I \- supported_rtrn
backfilled True if DetectableAutorepeat supported
.SH DESCRIPTION
.LP
Auto-repeat is the generation of multiple key events by a keyboard when the user 
presses a key and holds it down. Keyboard hardware and device-dependent X server 
software often implement auto-repeat by generating multiple KeyPress events with no 
intervening KeyRelease event. The standard behavior of the X server is to generate 
a KeyRelease event for every KeyPress event. If the keyboard hardware and 
device-dependent software of the X server implement auto-repeat by generating 
multiple KeyPress events, the device-independent part of the X server by default 
synthetically generates a KeyRelease event after each KeyPress event. This provides 
predictable behavior for X clients, but does not allow those clients to detect the 
fact that a key is auto-repeating.

Xkb allows clients to request 
.I detectable auto-repeat. 
If a client requests and the server supports DetectableAutorepeat, Xkb generates 
KeyRelease events only when the key is physically released. If DetectableAutorepeat 
is not supported or has not been requested, the server synthesizes a KeyRelease 
event for each repeating KeyPress event it generates.

DetectableAutorepeat, unlike other controls, is not contained in the XkbControlsRec 
structure, nor can it be enabled or disabled via the EnabledControls control. 
Instead, query and set DetectableAutorepeat using 
.I XkbGetDetectableAutorepeat 
and 
.I XkbSetDetectableAutorepeat.

DetectableAutorepeat is a condition that applies to all keyboard devices for a 
client's connection to a given X server; it cannot be selectively set for some 
devices and not for others. For this reason, none of the Xkb library functions 
involving DetectableAutorepeat involve a device specifier.

.I XkbGetDetectableAutorepeat 
queries the server for the current state of DetectableAutorepeat and waits for a 
reply. If 
.I supported_rtrn 
is not NULL, it backfills 
.I supported_rtrn 
with True if the server supports DetectableAutorepeat, and False otherwise.
.I XkbGetDetectableAutorepeat 
returns the current state of DetectableAutorepeat for the requesting client: 
True if DetectableAutorepeat is set, and False otherwise.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbGetDetectableAutorepeat 
function returns True if the server supports DetectableAutorepeat.
.TP 15
False
The 
.I XkbGetDetectableAutorepeat 
function returns False if the server does not support DetectableAutorepeat.
