.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH LIBINPUT __drivermansuffix__ __vendorversion__
.SH NAME
libinput \- libinput-based X.Org input driver
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" devname \*q
.B  "  Driver \*qlibinput\*q"
.BI "  Option \*qDevice\*q   \*q" devpath \*q
\ \ ...
.B EndSection
.fi
.SH NOTE
This is the man page for the X input driver. If you are looking for the
library documentation, go to 
.BI http://wayland.freedesktop.org/libinput/doc/

.SH DESCRIPTION
.B libinput 
is an __xservername__ input driver based on libinput.  It
therefore supports all input devices that libinput can handle, including
most mice, keyboards, tablets and touchscreens.
.PP
It is recommended that
.B libinput
devices are configured through the
.B InputClass
directive (refer to __xconfigfile__(__filemansuffix__)) instead of manual
per-device configuration. Devices configured in the
__xconfigfile__(__filemansuffix__) are not hot-plug capable.
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
The following driver 
.B Options
are supported:
.TP 7
.BI "Option \*qDevice\*q \*q" string \*q
Specifies the device through which the device can be accessed.  This will 
generally be of the form \*q/dev/input/eventX\*q, where X is some integer.
The mapping from device node to hardware is system-dependent. Property:
"Device Node" (read-only).
.TP 7
.BI "Option \*qAccelSpeed\*q \*q" float \*q
Sets the pointer acceleration speed within the range [-1, 1]
.TP 7
.BI "Option \*qCalibrationMatrix\*q \*q" string \*q
A string of 9 space-separated floating point numbers.
Sets the calibration matrix to the 3x3 matrix where the first row is (abc),
the second row is (def) and the third row is (ghi).
.TP 7
.BI "Option \*qLeftHanded\*q \*q" bool \*q
Enables left-handed button orientation, i.e. swapping left and right buttons.
.TP 7
.BI "Option \*qNaturalScrolling\*q \*q" bool \*q
Enables or disables natural scrolling behavior.
.TP 7
.BI "Option \*qScrollButton\*q \*q" int \*q
Designates a button as scroll button. If the
.BI ScrollMethod
is
.BI button
and the button is logically held down, x/y axis movement is converted into
scroll events.
.TP 7
.BI "Option \*qScrollMethod\*q \*q" string \*q
Enables a scroll method. Permitted values are
.BI none,
.BI twofinger,
.BI edge,
.BI button.
Not all devices support all options, if an option is unsupported, the
default scroll option for this device is used.
.TP 7
.BI "Option \*qSendEventsMode\*q \*q" (disabled|enabled|disabled-on-external-mouse) \*q
Sets the send events mode to disabled, enabled, or "disable when an external
mouse is connected".
.TP 7
.BI "Option \*qTapping\*q \*q" bool \*q
Enables or disables tap-to-click behavior.
.PP
For all options, the options are only parsed if the device supports that
configuration option. For all options, the default value is the one used by
libinput. On configuration failure, the default value is applied.

.SH SUPPORTED PROPERTIES
The following properties are provided by the
.B libinput
driver.
.TP 7
.BI "libinput Tapping Enabled"
1 boolean value (8 bit, 0 or 1). 1 enables tapping
.TP 7
.BI "libinput Calibration Matrix"
9 32-bit float values, representing a 3x3 calibration matrix, order is row
1, row 2, row 3
.TP 7
.BI "libinput Accel Speed"
1 32-bit float value, defines the pointer speed. Value range -1, 1
.TP 7
.BI "libinput Natural Scrolling Enabled"
1 boolean value (8 bit, 0 or 1). 1 enables natural scrolling
.TP 7
.BI "libinput Send Events Mode"
1 32-bit value, defines the sendevent mode. See the libinput documentation
for the allowed values.

.SH AUTHORS
Peter Hutterer
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
