#!/bin/sh
#
# Copyright © 2014 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

#
# Check that command line handling works consistently across all tests
#

if [ -z "$top_builddir" ]; then
	top_builddir="$(dirname $0)"
fi

# allow to run this script from top directory
TESTLIST=`cat $top_builddir/test-list.txt`
if [ $? -ne 0 ]; then
	# distcheck requires this hack
	TESTLIST=$(cat test-list.txt)
	if [ $? -ne 0 ]; then
		echo "Error: Could not read test lists"
		exit 99
	fi
fi

fail () {
	echo "FAIL: $1"
	exit 1
}

for test in $TESTLIST; do
	if [ "$test" = "TESTLIST" -o "$test" = "END" ]; then
		continue
	fi

	# top_builddir is empty for distcheck
	test=$top_builddir/$test

	# distcheck requires this hack
	if [ ! -x "$test" ]; then
		continue
	fi

	echo "$test:"

	# check invalid option handling
	echo "  Checking invalid option handling..."
	./$test --invalid-option 2> /dev/null && fail $test

	# check valid options succeed
	echo "  Checking valid option handling..."
	./$test --help > /dev/null || fail $test

	# check --list-subtests works correctly
	echo "  Checking subtest enumeration..."
	LIST=`./$test --list-subtests`
	RET=$?
	if [ $RET -ne 0 -a $RET -ne 79 ]; then
		fail $test
	fi

	if [ $RET -eq 79 -a -n "$LIST" ]; then
		fail $test
	fi

	if [ $RET -eq 0 -a -z "$LIST" ]; then
		fail $test
	fi

	# check invalid subtest handling
	echo "  Checking invalid subtest handling..."
	./$test --run-subtest invalid-subtest > /dev/null 2>&1 && fail $test
done
