.TH XvPutVideo __libmansuffix__  __vendorversion__
.\" $XFree86: xc/doc/man/Xv/XvPutVideo.man,v 1.4 1999/03/02 11:49:15 dawes Exp $
.SH Name
XvPutVideo \- write video into a drawable
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.sp 1l
\fBXvPutVideo(\fIdpy, port, d, gc, vx, vy, vw, vh, dx, dy, dw, dh\fR)
.sp 1l
.B Display 
.I *dpy;
.br
.B XvPortID 
.I port;
.br
.B Drawable 
.I d;
.br
.B GC 
.I gc;
.br
.B int 
.I vx, 
.I vy, 
.I dx, 
.I dy;
.br
.B unsigned int 
.I vw, 
.I vh;
.br
.B unsigned int 
.I dw, 
.I dh;
.sp 1l
.\"
.SH Arguments
.\"
.IP \fIdpy\fR 15
Specifies the display screen on which the
Xv Server is to accept requests from Xv clients.  If the
display option is not specified, Xv uses the display screen
specified by your DISPLAY environment variable.  The display
option has the format hostname:number.  Using two colons
(::) instead of one (:) indicates that DECnet is to be used
for transport.
.IP \fIport\fR 15
Defines the port from which to get video.
.IP \fId\fR 15
Defines the drawable (window) into which video is to be written.
.IP \fIgc\fR 15
Defines the graphical context.  
GC components are: 
.I subwindow-mode, 
.I clip-x-origin, 
.I clip-y-origin,
and 
.I clip-mask.  
.IP \fIvx,vy,vw,vh\fR 15
Define the size and location of the source (video) region 
to be written.  \fIvx\fP and \fIvy\fP define the 
upper-left pixel of the region. \fIvw\fP and \fIvh\fP
define the width and height, in pixels, of the region.
.IP \fIdx,dy,dw,dh\fR 15
Define the location and size of the destination (drawable) region 
into which the video image is written.  
.I dx 
and
.I dy 
define the upper-left pixel of the region.
.I dw 
and 
.I dh 
define the width and height, in pixels, of the region.
.\"
.SH Description
.\"
XvPutVideo writes video into a drawable.
The position and size of the source (video) 
rectangle is specified by \fIvx, vy, vw\fR, and \fIvh\fR.  
The position and size of the destination (drawable) 
rectangle is specified by \fIdx, dy, dw\fR, and \fIdh\fR.
.PP
Video data is clipped to the bounds of the video encoding, scaled to the
requested drawable region size (or the closest size supported) and
clipped to the bounds of the drawable.
.PP
If video is successfully initiated, an XvVideoNotify event with detail
XvStarted is generated for the drawable.  If the port is already in
use, its video is preempted, and if the new drawable is different than
the old, an XvVideoNotify event with detail XvPreempted is generated
for the old drawable.  If the port is grabbed by another client, this
request is ignored, and an XvVideoNotify event with detail XvBusy is
generated for the drawable. If the port is not receiving a valid video
signal or if the video signal is interrupted while video is active a
VideoNotify event with detail XvHardError is generated for the drawable.
.\"
.SH Returned Values
.IP [Success] 8
Returned if XvPutVideo(__libmansuffix__) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if there were insufficient resources to process the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.IP [BadGC] 8
Generated if the requested graphics context does not exist.
.IP [BadAlloc] 8
Generated if there were insufficient resources to process the request.
.\"
.SH See Also
.\"
XvPutStill(__libmansuffix__), XvGetVideo(__libmansuffix__), XvVideoNotify(__libmansuffix__)
.br
