'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/file.n,v 1.1 93/05/03 17:09:38 ouster Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS file tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
file \- Manipulate file names and attributes
.SH SYNOPSIS
\fBfile \fIoption\fR \fIname\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command provides several operations on a file's name or attributes.
\fIName\fR is the name of a file;
if it starts with a tilde, then tilde substitution is done before
executing the command (see the manual entry for \fBTcl_TildeSubst\fR
for details).
\fIOption\fR indicates what to do with the file name.  Any unique
abbreviation for \fIoption\fR is acceptable.  The valid options are:
.TP
\fBfile \fBatime \fIname\fR
Returns a decimal string giving the time at which file \fIname\fR
was last accessed.  The time is measured in the standard POSIX
fashion as seconds from a fixed starting time (often January 1, 1970).
If the file doesn't exist or its access time cannot be queried then an
error is generated.
.TP
\fBfile \fBdirname \fIname\fR
Returns all of the characters in \fIname\fR up to but not including
the last slash character.  If there are no slashes in \fIname\fR
then returns ``.''.  If the last slash in \fIname\fR is its first
character, then return ``/''.
.TP
\fBfile \fBexecutable \fIname\fR
Returns \fB1\fR if file \fIname\fR is executable by
the current user, \fB0\fR otherwise.
.TP
\fBfile \fBexists \fIname\fR
Returns \fB1\fR if file \fIname\fR exists and the current user has
search privileges for the directories leading to it, \fB0\fR otherwise.
.TP
\fBfile \fBextension \fIname\fR
Returns all of the characters in \fIname\fR after and including the
last dot in \fIname\fR.  If there is no dot in \fIname\fR then returns
the empty string.
.TP
\fBfile \fBisdirectory \fIname\fR
Returns \fB1\fR if file \fIname\fR is a directory,
\fB0\fR otherwise.
.TP
\fBfile \fBisfile \fIname\fR
Returns \fB1\fR if file \fIname\fR is a regular file,
\fB0\fR otherwise.
.TP
\fBfile lstat \fIname varName\fR
Same as \fBstat\fR option (see below) except uses the \fIlstat\fR
kernel call instead of \fIstat\fR.  This means that if \fIname\fR
refers to a symbolic link the information returned in \fIvarName\fR
is for the link rather than the file it refers to.  On systems that
don't support symbolic links this option behaves exactly the same
as the \fBstat\fR option.
.TP
\fBfile \fBmtime \fIname\fR
Returns a decimal string giving the time at which file \fIname\fR
was last modified.  The time is measured in the standard POSIX
fashion as seconds from a fixed starting time (often January 1, 1970).
If the file doesn't exist or its modified time cannot be queried then an
error is generated.
.TP
\fBfile \fBowned \fIname\fR
Returns \fB1\fR if file \fIname\fR is owned by the current user,
\fB0\fR otherwise.
.TP
\fBfile \fBreadable \fIname\fR
Returns \fB1\fR if file \fIname\fR is readable by
the current user, \fB0\fR otherwise.
.TP
\fBfile readlink \fIname\fR
Returns the value of the symbolic link given by \fIname\fR (i.e. the
name of the file it points to).  If
\fIname\fR isn't a symbolic link or its value cannot be read, then
an error is returned.  On systems that don't support symbolic links
this option is undefined.
.TP
\fBfile \fBrootname \fIname\fR
Returns all of the characters in \fIname\fR up to but not including
the last ``.'' character in the name.  If \fIname\fR doesn't contain
a dot, then returns \fIname\fR.
.TP
\fBfile \fBsize \fIname\fR
Returns a decimal string giving the size of file \fIname\fR in bytes.
If the file doesn't exist or its size cannot be queried then an
error is generated.
.TP
\fBfile \fBstat  \fIname varName\fR
Invokes the \fBstat\fR kernel call on \fIname\fR, and uses the
variable given by \fIvarName\fR to hold information returned from
the kernel call.
\fIVarName\fR is treated as an array variable,
and the following elements of that variable are set: \fBatime\fR,
\fBctime\fR, \fBdev\fR, \fBgid\fR, \fBino\fR, \fBmode\fR, \fBmtime\fR,
\fBnlink\fR, \fBsize\fR, \fBtype\fR, \fBuid\fR.
Each element except \fBtype\fR is a decimal string with the value of
the corresponding field from the \fBstat\fR return structure; see the
manual entry for \fBstat\fR for details on the meanings of the values.
The \fBtype\fR element gives the type of the file in the same form
returned by the command \fBfile type\fR.
This command returns an empty string.
.TP
\fBfile \fBtail \fIname\fR
Returns all of the characters in \fIname\fR after the last slash.
If \fIname\fR contains no slashes then returns \fIname\fR.
.TP
\fBfile \fBtype \fIname\fR
Returns a string giving the type of file \fIname\fR, which will be
one of \fBfile\fR, \fBdirectory\fR, \fBcharacterSpecial\fR,
\fBblockSpecial\fR, \fBfifo\fR, \fBlink\fR, or \fBsocket\fR.
.TP
\fBfile \fBwritable \fIname\fR
Returns \fB1\fR if file \fIname\fR is writable by
the current user, \fB0\fR otherwise.

.SH KEYWORDS
attributes, directory, file, name, stat
