.TH WTOC 1
.SH "NAME"
wtoc \- Convert a Wnn text-form dictionary (or dictionaries) into
Canna text-form dictionaries
.SH "SYNOPSIS"
.B "wtoc [\-f \fIhinshidata\fP] [\fIwnnjisho\fP] [\fIcannajisho\fP]"
.SH "DESCRIPTION"
.PP
wtoc converts a Wnn text-form dictionary file into Canna text-form
dictionary file.  If all dictionary files
are omitted, the Wnn dictionary data is input through the standard
input.  In this case, the dictionary of the Japanes Input System is
output from the standard output.  If one dictionary file is specified,
it will be regarded as a Wnn dictionary.  At this time, Canna
dictionary output to the standard output.
.SH "OPTIONS"
.IP "\-f \fIhinshidata\fP" 12
The user can add new information about word-type correspondence
between Wnn and Canna.  The following word-type correspondence
information must be described in the \fIhinshidata\fP file.  Within 
one line, describe the Wnn word type name and the Canna word type 
while delimiting by a space(s) or tab.
.sp
.nf
  Wnn word type       Canna word type
.br
  Adverb              #F04
.fi
.SH "EXAMPLE"
.nf
% wtoc -f tsuikahinshi kihon.u kihon.t
.fi
.sp
Inputs word-type correspondence information from tsuikahinshi,
then converts Wnn text-form dictionary kihon.u into the Canna
text-form dictionary before output.
.sp
.nf
% wtoc special.u | lpr
.fi
.sp
Converts Wnn text-form dictionary special.u into Canna text-form
dictionary, then outputs the result to the line printer.
.SH "SEE ALSO"
.IP "ctow(1)" 12

.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: wtoc.man,v 1.4 1994/01/27 09:59:50 kon Exp $
