.\" $Xorg: xieperf.man,v 1.4 2001/02/09 02:05:49 xorgcvs Exp $
.\" Copyright 1993, 1994, 1998  The Open Group
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\" 
.\" 
.\" 				NOTICE
.\"                               
.\" This software is being provided by AGE Logic, Inc. under the
.\" following license.  By obtaining, using and/or copying this software,
.\" you agree that you have read, understood, and will comply with these
.\" terms and conditions:
.\" 
.\"      Permission to use, copy, modify, distribute and sell this
.\"      software and its documentation for any purpose and without
.\"      fee or royalty and to grant others any or all rights granted
.\"      herein is hereby granted, provided that you agree to comply
.\"      with the following copyright notice and statements, including
.\"      the disclaimer, and that the same appears on all copies and
.\"      derivative works of the software and documentation you make.
.\"      
.\"      "Copyright 1993, 1994 by AGE Logic, Inc."
.\"      
.\"      THIS SOFTWARE IS PROVIDED "AS IS".  AGE LOGIC MAKES NO
.\"      REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.  By way of
.\"      example, but not limitation, AGE LOGIC MAKE NO
.\"      REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS
.\"      FOR ANY PARTICULAR PURPOSE OR THAT THE SOFTWARE DOES NOT
.\"      INFRINGE THIRD-PARTY PROPRIETARY RIGHTS.  AGE LOGIC 
.\"      SHALL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE.  IN NO
.\"      EVENT SHALL EITHER PARTY BE LIABLE FOR ANY INDIRECT,
.\"      INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS
.\"      OF PROFITS, REVENUE, DATA OR USE, INCURRED BY EITHER PARTY OR
.\"      ANY THIRD PARTY, WHETHER IN AN ACTION IN CONTRACT OR TORT OR
.\"      BASED ON A WARRANTY, EVEN IF AGE LOGIC LICENSEES
.\"      HEREUNDER HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
.\"      DAMAGES.
.\"     
.\"      The name of AGE Logic, Inc. may not be used in
.\"      advertising or publicity pertaining to this software without
.\"      specific, written prior permission from AGE Logic.
.\" 
.\"      Title to this software shall at all times remain with AGE
.\"      Logic, Inc.
.TH xieperf 1 "Release 6.4" "X Version 11"
.SH NAME
xieperf - XIE server extension test and demo program
.SH SYNTAX
.B xieperf
[-option ...]
.SH DESCRIPTION
The
.I xieperf
program is based upon R5 
.I x11perf(1)
, and while not entirely comprehensive in its coverage of the XIE 
protocol (see BUGS, below), it is intended to be useful in the evaluation of 
XIE implementations in the areas of protocol adherance and performance. 
The
.I xieperf 
program includes tests which execute each of the protocol requests and photoflo 
elements specified by revision 5.0 of the XIE protocol. In addition, 
.I xieperf 
provides a set of tests which can be used to validate the detection and 
transmission of XIE protocol request errors, such as FloMatch, FloValue, and 
so forth. Finally, 
.I xieperf
provides a customizable demonstration program for XIE.
.PP
A test is made up of three components executed in sequence - an 
initialization function, a test function, and an end function. The 
initialization function is responsible for allocating and populating test 
resources, such as photomaps and LUTs, and for creating a stored photoflo 
which will be executed by the test function. The test function, in most cases, 
simply executes the stored photoflo for a specified number of repetitions. 
The end function, which is called following the test function, is used 
primarily to destroy any non-cachable server resources used by the test, and 
to free any memory which was dynamically allocated by the client. Some tests, 
such as -modify1, -await, -abort, and -redefine, perform additional steps 
within the test function inner loop, as required by the element being tested, 
or in an attempt to make the test more visually appealing. 
.PP
Evaluating the performance of individual XIE elements is not
as simple as measuring Core X drawing times. The XIE
protocol requires elements to be embedded within photoflos
in order to be exercised,  and the minimum possible photoflo
size is two.  This implies that it is impossible to measure
performance of a single element in isolation - the time it
takes to run the flo depends on what other elements exist in 
the flo.  Extrapolating performance of a single elment 
(or technique) in a flo must be done carefully, on a case-by-case 
basis,  since in general measured element performance depends on 
input image size, data type, and other factors,  all of which can 
be influenced by upstream flo elements.  Note further that the
number and type of elements in a flo can be influenced by the 
visuals available on the display,  so even flo-flo comparisons 
on machines with different visuals must be done with caution.
.PP 
Many test labels contain an abbreviated pipeline description. For
instance. IP/IL/P/ED indicates ImportPhotomap, ImportLUT, Point, and
ExportDrawable. Pipelines ending in ED (ExportDrawable) often include
hidden elements such as BandExtract, ConvertToIndex, Dither, or Point
to match the flo output to the screen visual.  Pipelines ending in EP
(ExportPhotomap) will result in a blank window.
.PP
.I xieperf
is compatible with 
.I x11perfcomp(1), 
which is used to compare the outputs of different 
.I xieperf
and
.I x11perf
runs in a nice, tabular format. In
.I xieperf
you will need to use the -labels option (see OPTIONS, below), and provide
the resulting labels file to 
.I x11perfcomp(1)
to obtain correct output. See the
.I x11perfcomp(1)
man pages for more details on this. 
.SH OPTIONS
.I xieperf 
accepts the options listed below:
.TP 14
.B \-display host:dpy
Specifies which display to use.
.TP 14
.B \-images \fI<path>\fP
Normally,
.I xieperf
references image files located in the directory ``images'', which 
.I xieperf
assumes is located in your current directory. If the ``images'' directory is 
not in your current directory, or the file has been renamed, use this option 
to specify its location.
.TP 14
.B \-timeout \fI<s>\fP
Some tests require the reception of an event such as FloNotify to continue, and
may cause 
.I xieperf 
to hang should these events not be received. This option allows the user to 
specify a timeout value which, if exceeded, will cause
.I xieperf
to give up waiting for an event, and continue on with the next test in sequence.
Should an event timeout, a warning message will be printed to stderr. The 
default timeout value is 60 seconds. 
.TP 14
.B \-sync
Runs the tests in synchronous mode.
.TP 14
.B \-script \fI<file>\fP
Using this option gives the user the ability to run a subset of the available
tests and control the number of times the tests are executed on an individual
basis. This is thought to be especially useful for those running
.I xieperf
for demonstration purposes. Using this option causes 
.I xieperf
to read commands specified in a script file, or from stdin if \fI<file>\fP is 
``-''. Tests are specified by newline-terminated input lines of the form 
"command [-reps n ] [ -repeat m ]".  Characters following and including "#" 
are treated as comments. See the -mkscript option.
.TP 14
.B \-repeat \fI<n>\fP
Repeats each test 
.I n
times (by default each test is run 2 times). This option may be used in
script files also, in which case the script file -repeat overrides the
command line option. 
.TP 14
.B \-time \fI<s>\fP
Specifies how long in seconds each test should be run (default 5 seconds).
.TP 14
.B \-depth <depth>
Use a visual with <depth> planes per pixel (default is the default
visual).
.TP 14
.B \-GrayScale
Use a GrayScale visual (default is the default visual). 
.TP 14
.B \-PseudoColor
Use a PseudoColor visual (default is the default visual). 
.TP 14
.B \-StaticGray
Use a StaticGray visual (default is the default visual). 
.TP 14
.B \-StaticColor
Use a StaticColor visual (default is the default visual). 
.TP 14
.B \-TrueColor
Use a TrueColor visual (default is the default visual). 
.TP 14
.B \-DirectColor
Use a DirectColor visual (default is the default visual). 
.TP 14
.B \-WMSafe
If
.I xieperf
must be run in a window manager environment, use this flag to make 
.I xieperf 
aware of this. If specified,
.I xieperf
will create a window, identical to the size of the root window, and all
further windows created by
.I xieperf
will be transient popup children of this window. If this flag is omitted,
.I xieperf
will set the override_redirect attribute of all windows to ``True'' 
and will also do evil things such as calling XInstallColormap. 
Using this option will cause the window 
manager to (hopefully) obey window geometry hints specified by 
.I xieperf
.TP 14
.B \-showtechs
Display a comprehensive list of techniques, by category, indicating which of
the techniques are supported by the XIE server.
.TP 14
.B \-showlabels
Print test label to screen prior to calling any of the test code. This allows
the user to know which test is executing in case the test hangs for some reason.
.TP 14
.B \-showevents
Be verbose when running event and error tests. Also, can be used to catch and
display information on any signals received during execution of
.I xieperf
. Note that this flag is best used in a debugging situation, or to validate
that the error events received by 
.I xieperf
are valid the first time the tests are executed on a new platform.
.TP 14
.B \-events
Run tests which test for event generation.
.TP 14
.B \-errors
Run tests which test for error event generation.
.TP 14
.B \-loCal
Skip test calibration. This may be used when running 
.I xieperf 
in situations where execution timing is not important. Execution times will
not be reported by 
.I xieperf
when this option is enabled. The inner loop repeat count, additionally, is 
set to a value of 5 (but can be overridden by the -reps option).
.TP 14
.B \-all
Runs all tests. This may take a while, depending on the speed of your machine,
and its floating point capabilities. This option is ignored if a script file
is used.
.TP 14
.B \-tests
Generate a list of the available tests for the
.I xieperf
program. In
.I x11perf
, this list is normally displayed in the usage statement. It was yanked from 
the usage of
.I xieperf
because it was too lengthy. 
.TP 14
.B \-mkscript
Generate a script file suitable for use with the script option. If -repeat
or -reps are also specified, they will be automatically placed at the end
of each command in the script. The script is generated to stderr. See the
-script command, above.
.TP 14
.B \-cache \fI<n>\fP
Most test flos utilize a photomap resource for a source.  A photomap cache
of up to n entries is controlled by 
.I xieperf
to avoid having to constantly reload these images during test initialization.
The default cache size is 4. If a value less than the default is specified, the cache size will be set to the default.
.TP 14
.B \-labels
Generates just the descriptive labels for each test specified. Use -all or
-range to specify which tests are included. See
.I x11perfcomp(1)
for more details.
.TP 14
.B \-DIS
Pretend we are running 
.I xieperf
while connected to a DIS-only capable implementation of XIE. This will cause
.I xieperf
to execute those tests which only use protocol requests found in the DIS subset of 
XIE, and bypass those which are not DIS compatible. If 
.I xieperf
detects a DIS server, it will do this automatically, and this option is ignored.
Use -all or -range to specify the initial range of tests.
.TP 14
.B \-range \fI<test1>\fP[,\fI<test2>\fP]
Runs all the tests starting from the specified name \fItest1\fP until
the name \fItest2\fP, including both the specified tests. Some tests, 
like the event and error tests, also require the -errors or -events
options to specified. This option is ignored if a script it used.
.TP 14
.B \-reps \fI<n>\fP
Fix the inner loop repetitions to n. This indicates how many time the photoflo
will be executed each time the test is run. This option is overridden on a 
per-test basis if specified in a script. Typically, 
.I xieperf 
determines the ideal number of reps during each test's calibration period. 
.TP 14
.B \-ImportObscuredEvent through \-ExportAvailable
Test generation of events. Requires -events flag.
.TP 14
.B \-BadValue through \-FloValueError           
Test generation of errors. Requires -errors flag. 
.B \-ColorList
Create and destroy ColorList resource test.         
.TP 14
.B \-LUT                
Create and destroy LUT resource test.         
.TP 14
.B \-Photomap         
Create and destroy Photomap resource test.         
.TP 14
.B \-ROI              
Create and destroy ROI resource test.         
.TP 14
.B \-Photospace       
Create and destroy Photospace test.         
.TP 14
.B \-Photoflo         
Create and destroy Photoflo test.         
.TP 14
.B \-QueryPhotomap    
Query Photomap resource test.
.TP 14
.B \-QueryColorList   
Query ColorList resource test.
.TP 14
.B \-QueryTechniquesDefault through \-QueryTechniquesWhiteAdjust
Query techniques as specified by test name.
.TP 14
.B \-QueryPhotoflo        
Query photoflo test.
.TP 14
.B \-PurgeColorList       
PurgeColorList test.
.TP 14
.B \-Abort 
This tests creates a photoflo which is started and blocks for data provided by 
PutClientData(). Instead of sending the data, the test uses XieAbort() to
stop the photoflo, and then waits for PhotofloDone event to be send by the
server. If the test times out waiting for the event, a error message is sent
to stderr. 
.TP 14
.B \-Await                
This test creates a flo of the form ImportClientLUT -> ExportLUT, and starts
the flo executing. 
.I xieperf
then forks, and the child process streams the LUT data to the flo using 
PutClientData, while the parent blocks in XieAwait. If the flo successfully
finishes, XieAwait will return and the flo state, after query, will indicate
that it has completed. If XieAwait does not complete naturally, or after return 
from XieAwait the flo is still active, an error is reported to stderr. Note, on
a really slow machine, it is possible that XieAwait will return before the
flo has a chance to finish. In this case, use the -timeout option to increase
the timeout for this test.
.TP 14
.B \-importclientlut1     
ImportClientLUT -> ExportLUT test.
.TP 14
.B \-importclientphoto1 through \-importclientphoto9 
Flos of the form ImportClientPhoto -> ExportPhotomap using various
decode techniques, e.g. G32D, TIFF2, UncompressedTriple, and so forth. 
.TP 14
.B \-importclientroi1    
ImportClientROI with 10 rectangles.
.TP 14
.B \-importclientroi2    
ImportClientROI with 100 rectangles.
.TP 14
.B \-encodephoto1 through \-encodephoto14
Flos of the form ImportPhotomap -> ExportPhotomap using various
encode techniques, e.g. G32D, TIFF2, UncompressedTriple, and so forth.
Original encoding is shown in left window, image after encoding is 
shown in right window. 
.TP 14
.B \-encodeclientphoto1 through \-encodeclientphoto11  
Two flos, one of the form ImportPhotomap -> ExportClientPhoto, and the
other of the form ImportClientPhoto -> ExportPhotomap, where ExportClientPhoto
in the first flo uses various encode techniques, e.g. G32D, TIFF2, 
UncompressedTriple, and so forth. The image before encoding is displayed in
the left window, while the right window shows the image which was encoded
in the first flo and read back in the second flo.
.TP 14
.B \-exportclientlut1    
ExportClientLUT test. LUT is displayed in a histogram window. 
.TP 14
.B \-exportclientroi1         
ExportClientROI test, 10 ROIs. The ROIs which are sent to the server are 
represented by the filled rectangles. The ROIs which are received back from
the server by the client are drawn as white bordered non-filled rectangles.
The resulting output illustrates how the server combined the rectangles sent 
to it.
.TP 14
.B \-exportclientroi2         
Same as exportclientroi1, except using 100 rectangles.
.TP 14
.B \-exportclienthistogram1 through \-exportclienthistogram4
ExportClientHistogram tests using various images. The histogram is displayed
in a window which overlaps the image.   
.TP 14
.B \-exportclienthistogramroi1 through \-exportclienthistogramroi4
Same as the ExportClientHistogram test, but using a ROI to identify the area
of interest.
.TP 14
.B \-exportclienthistogramcplane1 through \-exportclienthistogramcplane4
Same as the ExportClientHistogram test, but using a Control Plane to identify the area of interest.
.TP 14
.B \-importlut1
Test ImportLUT element, LUT size is 256.
.TP 14
.B \-importphoto1
ImportPhotomap -> ExportPhotomap, with source and destination equal.
.TP 14
.B \-importphoto2
ImportPhotomap -> ExportDrawable, window destination.        
.TP 14
.B \-importroi1            
ImportROI -> ExportROI, 10 rectangles, source and destination ROIs equal.
.TP 14
.B \-importroi2            
ImportROI -> ExportROI, 100 rectangles, source and destination ROIs equal.
.TP 14
.B \-importdrawable1
ImportDrawable -> ExportDrawable, Source is pixmap, destination is window. 
.TP 14
.B \-importdrawable2      
ImportDrawable -> ExportDrawable, Source and destination is window. 
.TP 14
.B \-importdrawable3      
ImportDrawable -> ExportDrawable, Destination window obscured by source window. 
.TP 14
.B \-importdrawable4      
ImportDrawable -> ExportDrawable, Source window obscured by destination window. 
.TP 14
.B \-importdrawable5      
ImportDrawablePlane -> ExportDrawablePlane, pixmap, source = destination.
.TP 14
.B \-importdrawable6      
ImportDrawablePlane -> ExportDrawablePlane, window, source = destination.
.TP 14
.B \-importdrawable7      
ImportDrawablePlane -> ExportDrawablePlane, window, source obscures destination.
.TP 14
.B \-importdrawable8      
ImportDrawablePlane -> ExportDrawablePlane, window, destination obscures source.
.TP 14
.B \-constrain1
Constrain HardClip technique test, drawable destination.          
.TP 14
.B \-constrain2           
Constrain ClipScale technique test, drawable destination.
.TP 14
.B \-constrainphoto1      
Constrain HardClip technique test, photomap destination.
.TP 14
.B \-constrainphoto2      
Constrain ClipScale technique test, photomap destination.
.TP 14
.B \-convolve1            
Boxcar 3x3 convolution test. Smoothing or lowpass filter.
.TP 14
.B \-convolve2            
Boxcar 5x5 convolution test. Smoothing or lowpass filter.
.TP 14
.B \-convolve3
LaPlacian 3x3 convolution test. Edge or highpass filter. 
.TP 14
.B \-convolve4            
LaPlacian 5x5 convolution test. Edge or highpass filter.
.TP 14
.B \-convolveroi1         
LaPlacian 3x3 convolution test, with ROI.
.TP 14
.B \-convolveroi2         
LaPlacian 5x5 convolution test, with ROI.
.TP 14
.B \-convolvecplane1         
LaPlacian 3x3 convolution test, with Control Plane.
.TP 14
.B \-convolvecplane2         
LaPlacian 5x5 convolution test, with Control Plane.
.TP 14
.B \-math1 through \-mathcplane7
Various tests which exercise the Math element, some tests using ROIs and control planes. 
.TP 14
.B \-arithmeticdyadic1 through \-arithmeticdyadic5
Arithmetic element tests, using photomaps as the operands.    
.TP 14
.B \-arithmeticmonadic1 through \-arithmeticmonadic9
Arithmetic element tests, photomap and constant operands. 
.TP 14
.B \-arithmeticdyadicroi1 through \-arithmeticdyadicroi5   
Arithmetic element tests, using photomaps as the operands, with ROIs.
.TP 14
.B \-arithmeticmonadicroi1 through \-arithmeticmonadicroi9 
Arithmetic element tests, photomap and constant operands, with ROIs. 
.TP 14
.B \-arithmeticdyadiccplane1 through \-arithmeticdyadiccplane5   
Arithmetic element tests, using photomaps as the operands, with Control Planes.
.TP 14
.B \-arithmeticmonadiccplane1 through \-arithmeticmonadiccplane9 
Arithmetic element tests, photomap and constant operands, with Control Planes. 
.TP 14
.B \-arithmeticfloatdyadic1 though \-arithmeticfloatdyadic5 
Arithmetic element tests, using photomaps as the operands, unconstrained.
.TP 14
.B \-arithmeticfloatmonadic1 though \-arithmeticfloatmonadic9
Arithmetic element tests, photomap and constant operands, unconstrained.
.TP 14
.B \-arithmeticroifloatdyadic1 to \-arithmeticroifloatdyadic5 
Arithmetic element tests, photomaps as the operands, ROIs, unconstrained.
.TP 14
.B \-arithmeticroifloatmonadic1 to -\arithmeticroifloatmonadic9
Arithmetic element tests, photomap and constant operands, ROIs, unconstrained.
.TP 14
.B \-band1
BandSelect element test. Image input is triple band. If visual of 
.I xieperf
window is a color visual, then three BandSelect elements are used to extract
the indivudual bands, they are combined once again using BandCombine, and
displayed using ConvertToIndex. If the visual is not color, e.g. GrayScale or
StaticGray, then the flo simply uses one BandSelect element to extract a single
band for display.
.TP 14
.B \-band2                    
BandCombine test. Input bands are made of of three separate single band 
photomaps. These are combined using a BandCombine element, which is 
followed by a BandExtract and ExportDrawable. CCIR 601-1 coefficients.
.TP 14
.B \-band3
BandExtract test. Input is a triple band photomap. CCIR 601-1 coefficients.
Destination window colormap is gray ramp.
.TP 14
.B \-band4
BandExtract test. Input is a triple band photomap. CCIR 601-1 coefficients.
Destination window colormap is RGB_BEST_MAP standard colormap.
.TP 14
.B \-band5                 
BandExtract test. Input is a triple band photomap. CCIR 601-1 coefficients.
Destination window colormap is RGB_DEFAULT_MAP standard colormap.
.TP 14
.B \-comparedyadic1 through \-comparedyadic6        
Test various Compare operators with dyadic photomap operands.
.TP 14
.B \-comparemonadic1 through \-comparemonadic6      
Test various compare operators with photomap, constant operands.
.TP 14
.B \-compareroidyadic1 through \-compareroidyadic6   
Test various Compare operators with dyadic photomap operands, using ROIs.
.TP 14
.B \-compareroimonadic1 through \-compareroimonadic6  
Test various compare operators with photomap, constant operands, using ROIs.
.TP 14
.B \-comparecplanedyadic1 through \-comparecplanedyadic6   
Test various Compare operators with dyadic photomap operands, Control Planes.
.TP 14
.B \-comparecplanemonadic1 through \-comparecplanemonadic6  
Test various compare operators with photomap, constant operands, Control Planes.
.TP 14
.B \-matchhistogram1 through \-matchhistogram18     
MatchHistogram element tests, using various images and histogram matching techniques.
.TP 14
.B \-matchhistogramroi1 through \-matchhistogramroi6 
A selection of MatchHistogram element tests, with ROIs.
.TP 14
.B \-matchhistogramcplane1 through \-matchhistogramcplane6 
A selection of MatchHistogram element tests, with Control Planes.
.TP 14
.B \-unconstrain1
ImportPhotomap, Unconstrain, Constrain(ClipScale), ExportDrawable test.
.TP 14
.B \-pasteup1 through \-pasteup2            
PasteUp element tests.
.TP 14
.B \-geometry1 through \-geometry14           
Geometry element tests, including rotations, scales, and mirroring. 
NearestNeighbor technique.
.TP 14 
.B \-geometry15 through \-geometry28         
Geometry element tests, including rotations, scales, and mirroring. 
AntiAlias technique.
.TP 14
.B \-geometry29 through \-geometry42       
Geometry element tests, including rotations, scales, and mirroring. 
BilinearInterpolation technique.
.TP 14
.B \-geomg31dscale1 through \-geometryfaxradio1     
Tests to exercise the various FAX decoders and the Geometry element.
.TP 14
.B \-dither1            
Dither test, ErrorDiffusion dither technique, ExportDrawable.
.TP 14
.B \-dither2            
Dither test, ErrorDiffusion dither technique, ExportDrawablePlane.
.TP 14
.B \-dither3            
Dither test, Ordered(4) dither technique, ExportDrawable.
.TP 14
.B \-dither4
Dither test, Ordered(4) dither technique, ExportDrawablePlane.
.TP 14
.B \-dither5
Dither test, Ordered(8) dither technique, ExportDrawable.
.TP 14
.B \-dither6            
Dither test, Ordered(8) dither technique, ExportDrawablePlane.
.TP 14
.B \-dither7
Dither test, Default dither technique, ExportDrawable.
.TP 14
.B \-dither8             
Dither test, Default dither technique, ExportDrawablePlane.
.TP 14
.B \-logicalmonadic1 through \-logicalmonadic16     
Logical element, photomap and a constant of 0 as operands, various operators.
.TP 14
.B \-logicaldyadic1 through \-logicaldyadic16      
Logical element tests, dyadic photomaps as operands, various operators.
.TP 14
.B \-logicalmonadicroi1 through \-logicalmonadicroi16     
Logical element, photomap and constant of 0 operands, various operators, ROIs.
.TP 14
.B \-logicaldyadicroi1 through \-logicaldyadicroi16      
Logical element, dyadic photomaps as operands, various operators, ROIs.
.TP 14
.B \-logicalmonadiccplane1 through \-logicalmonadiccplane16     
Logical element, photomap and constant of 0 operands, various operators, Control Planes. 
.TP 14
.B \-logicaldyadiccplane1 through \-logicaldyadiccplane16      
Logical element, dyadic photomaps as operands, various operators, Control Planes. 
.TP 14
.B \-blend1                  
Blend element test. Monadic source, 0.1 source constant. Alpha constant of 0.5.
.TP 14
.B \-blend2                 
Blend element test. Dyadic sources. Alpha constant of 0.5.
.TP 14
.B \-blendroi1             
Blend test. Monadic source, 0.1 source constant. Alpha constant of 0.5. ROIs.
.TP 14
.B \-blendroi2            
Blend element test. Dyadic sources. Alpha constant of 0.5. Uses ROIs.
.TP 14
.B \-blendcplane1             
Blend test. Monadic source, 0.1 source constant. Alpha constant of 0.5. Control Plane.
.TP 14
.B \-blendcplane2            
Blend element test. Dyadic sources. Alpha constant of 0.5. Control Plane. 
.TP 14
.B \-blendalpha1
Blend test. Monadic source, 220 source constant. Alpha plane is a photomap.
.TP 14
.B \-blendalpha2        
Blend test. Dyadic sources. Alpha plane is a constant 220.      
.TP 14
.B \-blendalpharoi1    
Blend test. Monadic source, 220 source constant. Alpha plane photomap. ROIs.
.TP 14
.B \-blendalpharoi2   
Blend test. Dyadic sources. Alpha plane is a constant 220. ROIs.     
.TP 14
.B \-triplepoint1 through \-triplepoint2
Illustrate use of point and Standard colormaps for rendering triple band images.
.TP 14
.B \-funnyencode1 through \-funnyencode8
These tests are design to perform limited exercising of XIE's capability of
dealing with various encodings of flo source data. The test init function
obtains a photomap using ICP -> EP. A series of independent permanent flo pairs,
one of the form IP -> EP, and the other of the basic form IP -> ED, are 
constructed. The encoding parameters for the ExportPhotomap (EP) element
in the first flo are derived from test configuration. The number of flo
pairs created is also dependent upon test configuration. The tests can
be configured so that the test init function will constrain the input
photomap to a specified number of levels, on a per-band basis, so that
word-sized and quad-sized pixels are passed through the flos. Some tests
below take advantage of this. See tests.c for test configuration, and
hints on how to add similar tests. 
.TP 14
.B \-point1 through \-point3        
Simple Point element tests. Drawable destination.
.B \-pointroi1   
Simple Point element test which uses ROIs. Drawable destination.
.TP 14
.B \-pointcplane1   
Simple Point element test which uses a Control Plane. Drawable destination.
.TP 14
.B \-pointphoto1             
Simple Point element test. Photomap destination.
.TP 14
.B \-pointroiphoto1         
Simple Point element test which uses a ROIs. Photomap destination.
.TP 14
.B \-pointcplanephoto1         
Simple Point element test which uses a Control Plane. Photomap destination.
.TP 14
.B \-redefine
Two flographs are created which are the same in structure, expect for the
x and y offsets specified for the ExportDrawable flo elements. The test
init function creates a photoflo based upon one of the two flographs.
The inner loop of the test function uses XieRedefinePhotoflo() to alternate 
between each of the flographs. Make sure that your ineer loop reps are
2 or greater in order to exercise this test fully (see -reps).
.TP 14
.B \-modify1
Test XieModifyPhotoflo() by adjust ROI offsets and size.  
.TP 14
.B \-modify2             
Test XieModifyPhotoflo() by changing the LUT input to a Point element. 
.TP 14
.B \-modify3            
Test XieModifyPhotoflo() by changing ExportDrawable x and y offsets. 
.TP 14
.B \-modify4
This test creates a rather long flo of arithmetic elements, each which does 
nothing more than add 1 to a small image. The test init function 
scales the input photomap. The ExportDrawable x and y offset is modified
randomly during each iteration of the test function inner loop.
.TP 14
.B \-modify5          
This test creates a rather long flo of arithmetic elements, each which does 
nothing more than add 1 to a large image.  Each rep, the Geometry 
and ExportDrawable elements at the end of the flo are modifed to
crop a small piece of the
input into its appropriate place in the larger image.
.TP 14
.B \-rgb1 through \-rgb16
These tests all basically take an UncompressedTriple image as input, send it
to ConvertFromRGB which converts the image to some configured colorspace, 
and then send the converted image on to ConvertToRGB prior to display. The
original image is displayed in the lefthand window, and the image which has
passed through the flo is shown in the righthand window. The goal of these
test is to show that ConvertFromRGB -> ConvertToRGB is lossless. 
.TP 14
.B \-converttoindexpixel
ConvertToIndex test, TripleBand BandByPixel.
.TP 14
.B \-converttoindexplane
ConvertToIndex test, TripleBand BandByPlane.
.TP 14
.B \-convertfromindex 
The test init function uses a flo containing ConvertToIndex to display an
image in the left window. The test function uses this drawable as input
to a flo which does ConvertFromIndex -> ConvertToIndex and sends the
resulting image to the right window. The result should be lossless.
.TP 14
.B \-complex 
A somewhat large flo which uses control planes, LUTs, Point, PasteUp, Logical, Constrain, Dither, Geometry, MatchHistogram, BandCombine, and BandSelect elements. See the Postscript file ''complex.ps'' for a rendition of the photoflo which is executed.
.SH X DEFAULTS
There are no X defaults used by this program.
.SH "SEE ALSO"
X(1), x11perf(1), x11perfcomp(1)
.SH BUGS
There should be a IMAGES environment variable to augment the -images option.
.PP
Many tests only scratch the surface of possible test cases. 
Some of the options available for certain flo elements are either inadequately 
tested, or ignored altogether. 
There are insufficent tests for bitonal, large pixel, or triple band tests.
.PP 
Some of the test names are inconsistently cased, e.g. -Abort and -dither1.
.PP
Some tests are hopelessly slow when run against machines with slow FPUs.
.PP 
Bitonal images are for the most part displayed using the ExportDrawable flo 
element, however, ExportDrawablePlane would be a better choice.
.SH AUTHOR
Syd Logan, AGE Logic, Inc.
