.\" Record Extension Library, v1.13
.\" Use -ms and macros.t
.\" $XConsortium: recordlib.ms /main/17 1996/02/06 17:16:51 gildea $
.\" -----------------------------------------------
.de Ip
.IP \(bu 3
..
.de sC			\" start change (gildea).  arg is issue number
.mc \s+5\(br\s0\"	\" make tall enough to span paragraph skip
.if !^\\$1^^ \{\
'sp -1
.lt +\w'000'u+\w'\s-2\&\\$1\s0'u
.tl !!!\v'\n(.vu'\s-2\&\\$1\s0!
.lt -\w'000'u+\w'\s-2\&\\$1\s0'u
.\}
..
.de eC			\" end change
.if \\n(.u .mc \s+5\(br\s0\" ensure it appears on the last line
.mc
..
.\"
.hw XRecord-Register-Clients XRecord-Unregister-Clients
.hw XRecord-Intercept-Data XRecord-Query-Version XRecord-Process-Replies
.hw XRecord-EndOfData
.hw XButton-Released-Event XMotion-Event
.hw XRecord-Context
.EH ''''
.OH ''''
.EF ''''
.OF ''''
.fi
.ps 11
.nr PS 11
\&
.sp 8
.ce 50
\s+3\fBRecord Extension Library Specification\fP\s0
.sp
\fBVersion 1.13\fP
.sp
\fBX Consortium Standard\fP
.sp
\fBX Version 11, Release 6.1\fP
.sp 6
Martha Zimet
Network Computing Devices, Inc.
.sp 6
edited by
Stephen Gildea
X Consortium
.ce 0
.bp
.br
\&
.sp 13
.ps 9
.nr PS 9
.fi
.LP
Copyright \(co 1994 Network Computing Devices, Inc.
.LP
Permission to use, copy, modify, distribute, and sell this
documentation for any purpose is hereby granted without fee,
provided that the above copyright notice and this permission
notice appear in all copies.  Network Computing Devices, Inc.
makes no representations about the suitability for any purpose
of the information in this document.  This documentation is
provided \*Qas is\*U without express or implied warranty.
.LP
Copyright \(co 1995  X Consortium
.LP
Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
\*QSoftware\*U), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:
.LP
The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.
.LP
THE SOFTWARE IS PROVIDED \*QAS IS\*U, WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
.LP
Except as contained in this notice, the name of the X Consortium and
shall not be used in advertising or otherwise to promote the sale, use
or other dealings in this Software without prior written authorization
from the X Consortium.
.ps 11
.nr PS 11
.P1
.nr LL 6.5i
.nr LT 6.5i
.nr FL 6.5i
.ll 6.5i
.EH '\fBRecord Extension Library, Version 1.13\fP''\fBX11, Release 6.1\fP'
.OH '\fBX11, Release 6.1\fP''\fBRecord Extension Library, Version 1.13\fP'
.bp 1
.EF ''\fB\\\\n(PN\fP''
.OF ''\fB\\\\n(PN\fP''
.hy 14

.NH 1
Record Extension Overview
.XS
\*(SN Record Extension Overview
.XE
.LP
The purpose
of this extension is to support the recording and reporting of all
core X protocol and arbitrary X extension protocol.  This first section
gives an overview of the Record extension.  The following sections
describe how to use the Record extension library.
.NH 2
Synchronous Playback
.XS
\*(SN Synchronous Playback
.XE
.LP
Environment information is generally provided to an X-based playback
mechanism, which might use the XTest extension to synthesize input events.
This \fIsynchronization information\fP defines the X state prior to
event synthesis (e.g., location of the cursor, window locations and
sizes, installed colormap, window manager running, etc.) and the
consequences that occur after the playback mechanism synthesizes
the event.  If the user moves the mouse into the icon window and
presses and releases a mouse button, the device events
.PN MotionNotify ,
.PN ButtonPress
and
.PN ButtonRelease
are generated by the X server.
Because
X follows an event-driven model, there are \fIconsequences\fP that
follow from
the user actions, or device events, which are in the form of X protocol.
As a result of the previous user actions, the client could
generate requests such as
.PN ImageText8
and
.PN PolyLine
to the X server,
or the X server could send non-device events such as
.PN Expose
and
.PN MapNotify
to the client window.  Both the requests and non-device events that
result from user actions are known as \fIconsequences\fP, which
can be used as a synchronization, or control point, during playback.
That is, the playback mechanism does not generate a specific synthesized
event until its matching synchronization condition occurs (e.g.,
the window is mapped or unmapped, the cursor changes, a text string
displays, etc.)
.LP
Because
it cannot be predicted what synchronization information is
required during playback, the Record extension makes no assumptions
about the intended use of the recorded data.  Facilities exist to
record any core X protocol or X extension protocol.
Therefore, Record does not enforce a specific synchronization
methodology.
.NH 2
Design Approach
.XS
\*(SN Design Approach
.XE
.LP
The design approach of the extension is to record core X protocol
and arbitrary X extension protocol entirely within the X server
itself.  When the extension has been requested to record specific
protocol by one or more recording clients, the protocol data is formatted
and returned to the recording clients.  The extension provides a mechanism
for capturing all events, including input device events that go to no
clients.
.NH 2
Record Clients
.XS
\*(SN Record Clients
.XE
.LP
The recommended
communication model for a Record application is to open two
connections to the server\*-one connection for recording control
and one connection for reading recorded protocol data.
.LP
Information about recording (for example, what clients to record,
what protocol to record for each client, and so on) is stored in
resources called \fIrecord contexts\fP\^
(type
.PN XRecordContext ).
Most Record extension functions take a record context as an argument.
Although in theory it is possible
to share record contexts between applications,
it is expected that
applications will use their own context when performing recording
operations.
.LP
A client that wishes to record X protocol does so through the library
functions defined in
section 3 \*QLibrary Extension Requests.\*U  A typical sequence
of requests that a client would make is as follows:
.Ip
.PN XRecordQueryVersion
\- query the extension protocol version.
.Ip
.PN XRecordCreateContext
\- request that the server create a record context
for access by this client, and express interest in clients and protocol
to be recorded.  This request returns an
.PN XRecordContext ,
which is an XID that is used
by most other extension requests to identify the specified context.
.Ip
.PN XRecordEnableContext
\- begin the recording and reporting of protocol
data.
.Ip
.PN XRecordDisableContext
\- end the recording and reporting of protocol data.
.Ip
.PN XRecordFreeContext
\- free the record context.
.LP
The header for this library is
.Pn < X11/extensions/record.h >.
All identifiers defined in the interface are supplied by this header
and are prefixed with \*QXRecord\*U.  The
.PN Xtst
library contains the
.PN XRecord
functions.
.NH 1
Common Arguments
.XS
\*(SN What Is Recorded
.XE
.LP
The Record extension functions
.PN XRecordCreateContext
and
.PN XRecordRegisterClients
allow applications to specify
.RS
.Ip
individual clients or sets of clients to record, and
.Ip
ranges of core X protocol and X extension protocol to record for
each client.
.RE
.LP
Protocol in the ranges specified by the recording client
will be recorded by the server.  The \fIdevice_events\fP
protocol type can be specified by a recording
client although it may not be sent to a recorded client.
The \fIdevice_events\fP type differs from \fIdelivered_events,\fP
which also can be specified by a recording client;
\fIdelivered_events\fP are actually delivered to one or more clients.
These event types are discussed in section 2.3 \*QProtocol Ranges.\*U
.LP
The Record extension functions
.PN XRecordCreateContext
and
.PN XRecordRegisterClients
have the common arguments
\fIdatum_flags\fP,
\fIclients\fP and \fIranges\fP, which specify
whether server time and/or client
sequence number should precede protocol elements,
the clients or client set to
record, and the protocol ranges to record, respectively.
These are discussed in the following sections.
.NH 2
Datum Flags
.LP
The \fIdatum_flags\fP argument is a set of flags ORed together to
specify options for the record context.  Specify 0 to disable all
the options.
.LP
The
.PN XRecordFromServerTime
flag specifies that
.PN XRecordInterceptData
structures with a category of
.PN XRecordFromServer
will have a server_time field specific to each
protocol element.
.LP
The
.PN XRecordFromClientTime
flag specifies that
.PN XRecordInterceptData
structures with a category of
.PN XRecordFromClient
will have a server_time field specific to each protocol element.
.LP
The
.PN XRecordFromClientSequence
flag specifies that
.PN XRecordInterceptData
structures with a category of
.PN XRecordFromClient
or
.PN XRecordClientDied
will have a valid client_seq field.
.NH 2
Selecting Clients
.LP
The \fIclients\fP argument is a pointer to an array of
.PN XRecordClientSpec .
.PN XRecordClientSpec
is an integral type that holds a resource ID,
a client resource ID base, or one
of the \fIclient set\fP constants defined below.
.LP
Duplicate
elements in the array are ignored by the functions, and if any element
in the array is not valid a
.PN "BadMatch"
error results.
A resource ID references the client that created that resource.
The client set may be one of the following constants:
.PN XRecordCurrentClients ,
.PN XRecordFutureClients ,
or
.PN XRecordAllClients .
.LP
If the element in the array identifies a particular client, protocol
specified by the \fIranges\fP argument will be recorded by the server.
The recorded protocol data will not be returned to the recording client
until the record context has been \fIenabled\fP.  This is described in section
3.4 \*QData Transfer.\*U
.LP
If the element is
.PN XRecordCurrentClients ,
the protocol ranges specified by the
\fIranges\fP argument, except for \fIdevice_events\fP, are associated with
each current client connection.  If the element is
.PN XRecordFutureClients ,
the protocol ranges specified by the ranges argument are associated
with each new client connection.  If the element is
.PN XRecordAllClients ,
the protocol ranges specified by the ranges argument are associated
with each current client connection and with each new client connection.
.LP
When the context is enabled, the data connection is unregistered if it
was registered.
If the context is enabled,
.PN XRecordCurrentClients
and
.PN XRecordAllClients
silently exclude the recording data connection.
It is an error to explicitly register the data connection.
.NH 2
Protocol Ranges
.LP
The functions
.PN XRecordCreateContext
and
.PN XRecordRegisterClients
have another common argument, \fIranges,\fP
which is an array of pointers to
.PN XRecordRange
structures.  Each structure contains ranges of numeric values for each
of the protocol types that can be specified and recorded individually
by the Record extension.
An
.PN XRecordRange
structure must be allocated
by the Record library using the
.PN XRecordAllocRange
function.
.LP
.KS
The
.PN XRecordRange
typedef is a structure with the following members:
.DS
.TA .25i 1.75i 3.0i
.ta .25i 1.75i 3.0i
XRecordRange:
	XRecordRange8	core_requests	/* core X requests */
	XRecordRange8	core_replies	/* core X replies */
	XRecordExtRange	ext_requests	/* extension requests */
	XRecordExtRange	ext_replies	/* extension replies */
	XRecordRange8	delivered_events	/* delivered core and ext events */
	XRecordRange8	device_events	/* all core and ext device events */
	XRecordRange8	errors	/* core X and X ext errors */
	Bool	client_started	/* connection setup reply from server */
	Bool	client_died	/* notification of client disconnect */
.DE
.KE
.KS
The types used in
.PN XRecordRange
members are defined as follows.
The
.PN XRecordRange8
typedef is a structure with the following members:
.DS
.TA .25i 1.75i
.ta .25i 1.75i
XRecordRange8:
	unsigned char	first
	unsigned char	last
.DE
.KE
.KS
The
.PN XRecordRange16
typedef is a structure with the following members:
.DS
.TA .25i 1.75i
.ta .25i 1.75i
XRecordRange16:
	unsigned short	first
	unsigned short	last
.DE
.KE
.KS
The
.PN XRecordExtRange
typedef is a structure with the following members:
.DS
.TA .25i 1.75i
.ta .25i 1.75i
XRecordExtRange:
	XRecordRange8	ext_major
	XRecordRange16	ext_minor
.DE
.KE
.LP
If any of the values specified in
.PN XRecordRange
is invalid, a
.PN "BadValue"
error results.
.LP
The \fIcore_requests\fP member specifies the range of core X protocol
requests to record.  Core X protocol requests with a major opcode
that is between \fIfirst\fP and \fIlast\fP, inclusive, will be
recorded.  A
.PN "BadValue"
error results
if the value of \fIfirst\fP is greater than the value of \fIlast\fP.
If the values of both \fIfirst\fP and \fIlast\fP are 0 (zero) no core
X protocol requests will be recorded.
.LP
The \fIcore_replies\fP member specifies the range of replies resulting
from core X protocol requests to record.  Replies that result from
core X protocol requests with a major opcode that between \fIfirst\fP
and \fIlast\fP inclusive, will be recorded.  A
.PN "BadValue"
error results
if the value of \fIfirst\fP is greater than the value of \fIlast\fP.
If the values of both \fIfirst\fP and \fIlast\fP are 0 (zero)
no core X protocol replies will be recorded.
.LP
The \fIext_requests\fP member specifies the range of X extension
requests to record.  X extension requests with a major opcode
between \fIext_major.first\fP and \fIext_major.last\fP, and with a
minor opcode
between \fIext_minor.first\fP and \fIext_minor.last\fP, inclusive, will be
recorded.  A
.PN "BadValue"
error results
if the value of \fIext_major.first\fP is greater than the value of
\fIext_major.last\fP, or if the value of \fIext_minor.first\fP is
greater than the value of \fIext_minor.last\fP.  If the values of both
\fIext_major.first\fP
and \fIext_major.last\fP are 0 (zero)
no X extension requests will be recorded.
.LP
The \fIext_replies\fP member specifies the range of replies resulting
from X extension requests to record.  Replies that result from an X
extension request with a major opcode between
\fIext_major.first\fP and
\fIext_major.last\fP, and a minor opcode that is between
\fIext_minor.first\fP and \fIext_minor.last\fP will be recorded.  A
.PN "BadValue"
error results
if the value of \fIext_major.first\fP is greater than the value of
\fIext_major.last\fP, or if the value of \fIext_minor.first\fP is greater than
the value of \fIext_minor.last\fP.  If the values of both
\fIext_major.first\fP and \fIext_major.last\fP
are 0 (zero) no X extension
replies will be recorded.
.LP
The \fIdelivered_events\fP member specifies the range of both core
X events and X extension events to record.  These events are
delivered to at least one client.  Core X events and X extension events
with a code value between \fIfirst\fP and
\fIlast\fP inclusive will be recorded.  A
.PN "BadValue"
error results
if the value of \fIfirst\fP
is greater than the value of \fIlast\fP.  If the values of \fIfirst\fP
and \fIlast\fP are 0 (zero) no events will be recorded.
.LP
The \fIdevice_events\fP member specifies the range of
both core X device events and X extension device events
to record.  These events may or may not be delivered to a client.
Core X device events and X extension device events with a code value
between \fIfirst\fP and \fIlast\fP inclusive that are not delivered to any
clients will be recorded.  A
.PN "BadValue"
error results
if the value of \fIfirst\fP
is greater than the value of \fIlast\fP.  A
.PN "BadValue"
error results
if \fIfirst\fP
is less than two or \fIlast\fP is less than two, except that if
\fIfirst\fP and \fIlast\fP are 0 (zero) no events will be
recorded.
.LP
The \fIerrors\fP member specifies the range of both core X errors and X
extension errors to record.  Core X errors and X extension errors with
a code value between \fIfirst\fP and \fIlast\fP inclusive will be
recorded.  A
.PN "BadValue"
error results
if the value of \fIfirst\fP
is greater than the value of \fIlast\fP.  If the values of \fIfirst\fP and
\fIlast\fP are 0 (zero) no errors will be recorded.
.LP
A value of
.PN True
for the \fIclient_started\fP member specifies the
connection setup reply from the server to new clients.
If
.PN False ,
the connection setup reply is
not specified by this
.PN XRecordRange .
.LP
A value of
.PN True
for the \fIclient_died\fP member specifies
notification when a client disconnects.
If
.PN False ,
notification when a client disconnects is
not specified by this
.PN XRecordRange .
.NH 1
Library Extension Requests
.XS
\*(SN Library Extension Requests
.XE
.LP
Recording operations are accessed by programs through the use of
new protocol requests.  The following functions are provided as extensions
to Xlib.  An Xlib error results if
an extension request is made to an X server that does not support the
Record extension.  Note that any of the extension protocol requests may generate
.PN BadAlloc
or
.PN BadLength
errors.
.NH 2
Query Extension Version
.XS
\*(SN Query Extension Version
.XE
.LP
An application uses the
.PN XRecordQueryVersion
function to determine
the version of the Record extension protocol supported by an X server.
.LP
.KS
.DS
.TA .25i 1.5i
.ta .25i 1.5i
Status
XRecordQueryVersion (Display *\fIdisplay\fP,
	int *\fIcmajor_return\fP,
	int *\fIcminor_return\fP)
.DE
.KE
.RS
.IP \fIdisplay\fP 10
Specifies the connection to the X server.
.IP "\fIcmajor_return\fP"
Returns the extension protocol major version in use.
.IP "\fIcminor_return\fP"
Returns the extension protocol minor version in use.
.RE
.LP
The
.PN XRecordQueryVersion
function returns the major and minor
protocol version numbers supported by the server.
.PN XRecordQueryVersion
returns nonzero (success) only if the returned version numbers are
common to both the library and the
server; otherwise it returns zero.

.NH 2
Create and Modify Context
.XS
\*(SN Create and Modify Context
.XE
.LP
An application uses the
.PN XRecordCreateContext
function to create a
record context.  At the time the record context is
created by the recording client, the clients to be recorded and the
protocol to record for each client may be specified.
.LP
.KS
.DS
.TA .25i 1.5i
.ta .25i 1.5i
XRecordContext
XRecordCreateContext (Display *\fIdisplay\fP, int \fIdatum_flags\fP,
	XRecordClientSpec *\fIclients\fP, int \fInclients\fP,
	XRecordRange **\fIranges\fP, int \fInranges\fP)
.DE
.KE
.RS
.IP "\fIdisplay\fP " 10
Specifies the connection to the X server.
.IP \fIdatum_flags\fP
Specifies whether detailed time or sequence info should be sent
.IP "\fIclients\fP"
Specifies the clients to record.
.IP "\fInclients\fP"
Specifies the number of clients.
.IP "\fIranges\fP"
Specifies the protocol ranges to record.
.IP "\fInranges\fP"
Specifies the number of protocol ranges.
.RE
.LP
The
.PN XRecordCreateContext
function creates a record context and returns an
.PN XRecordContext ,
which is then used
in the other Record library calls.  This request is typically
executed by the recording client over its control connection to
the X server.
The \fIdatum_flags\fP specifies whether server time and/or client
sequence number should precede protocol elements recorded by \fIcontext\fP.
See section 2.1.
When a \fIclients\fP element identifies
a particular client, the client is added to the context and
the protocol to record for that client is set to the union of
all \fIranges\fP.  When a \fIclients\fP element is
.PN XRecordCurrentClients ,
.PN XRecordFutureClients
or
.PN XRecordAllClients ,
the actions described in section 2.2 \*QSelecting Clients\*U
are performed.
.LP
.PN XRecordCreateContext
returns zero if the request failed.
.PN XRecordCreateContext
can generate
.PN BadIDChoice ,
.PN BadMatch
and
.PN BadValue
errors.
.LP
The \fIranges\fP argument is an
.PN XRecordRange *
array, that is, an array
of pointers.  The structures the elements point to shall be allocated
by calling
.PN XRecordAllocRange .
.LP
.DS
.TA .25i 1.5i
.ta .25i 1.5i
XRecordRange *
XRecordAllocRange(void)
.DE
The
.PN XRecordAllocRange
function
allocates and returns an
.PN XRecordRange
structure.
The structure is initialized to specify no protocol.
The function returns NULL if the structure allocation fails.
The application can free the structure by calling
.PN XFree .

.SH
Additions
.LP
An application uses the
.PN XRecordRegisterClients
function to modify a previously created
record context, by adding clients or modifying the recorded protocol,
typically over its control connection to the X server.
.DS
.TA .25i 1.5i
.ta .25i 1.5i
Status
XRecordRegisterClients (Display *\fIdisplay\fP, XRecordContext \fIcontext\fP,
	int \fIdatum_flags\fP, XRecordClientSpec *\fIclients\fP,
	int \fInclients\fP, XRecordRange **\fIranges\fP, int \fInranges\fP)
.DE
.RS
.IP "\fIdisplay\fP " 10
Specifies the connection to the X server.
.IP "\fIcontext\fP"
Specifies the record context to modify.
.IP \fIdatum_flags\fP
Specifies whether detailed time or sequence info should be sent
.IP "\fIclients\fP"
Specifies the clients to record.
.IP "\fInclients\fP"
Specifies the number of clients.
.IP "\fIranges\fP"
Specifies the protocol ranges to record.
.IP "\fInranges\fP"
Specifies the number of protocol ranges.
.RE
.LP
The \fIdatum_flags\fP specifies whether server time and/or client
sequence number should precede protocol elements
for all clients
recorded by \fIcontext\fP.
See section 2.1.
When a \fIclients\fP element identifies a particular client and the
client is not yet
targeted for recording in the given \fIcontext\fP,
the client is added to the set of clients to record, and the protocol
to record for that client is set to the union of all \fIranges\fP.
When the client is
already targeted for recording, the protocol to record for that client
is set to the union of all \fIranges\fP.  When the element is
.PN XRecordCurrentClients ,
.PN XRecordFutureClients ,
or
.PN XRecordAllClients ,
the actions described
in section 2.2 \*QSelecting Clients\*U
are performed.
.LP
.PN XRecordRegisterClients
returns zero if the request failed; otherwise it
returns nonzero.
.PN XRecordRegisterClients
can generate
.PN XRecordBadContext ,
.PN BadMatch
and
.PN BadValue
errors.

.SH
Deletions
.LP
An application uses
the
.PN XRecordUnregisterClients
function to delete clients from a
previously created
record context, typically over its control connection to the X server.
.LP
.DS
.TA .25i 1.5i
.ta .25i 1.5i
Status
XRecordUnregisterClients (Display *\fIdisplay\fP, XRecordContext \fIcontext\fP,
	XRecordClientSpec *\fIclients\fP, int \fInclients\fP)
.DE
.RS
.IP "\fIdisplay\fP " 10
Specifies the connection to the X server.
.IP "\fIcontext\fP"
Specifies the record context to modify.
.IP "\fIclients\fP"
Specifies the clients to stop recording.
.IP "\fInclients\fP"
Specifies the number of clients.
.RE
.LP
When an element in \fIclients\fP identifies a particular client, and the
specified client is already targeted for recording in the given
\fIcontext\fP, the client and the set of protocol to record for that
client are deleted from the \fIcontext\fP.  If the specified client is not
targeted for recording then no action is performed.
.LP
When the element is
.PN XRecordCurrentClients ,
all clients currently targeted
for recording in \fIcontext\fP and their corresponding sets of
protocol to record are deleted from \fIcontext\fP.
.LP
When the item is
.PN XRecordFutureClients ,
any future client connections will
not automatically be targeted for recording in \fIcontext\fP.
.LP
When the element is
.PN XRecordAllClients ,
all clients currently targeted
for recording in \fIcontext\fP and their corresponding sets of
protocol to record are deleted from \fIcontext\fP.  Any future
client connections will not automatically be targeted for recording
in \fIcontext\fP.
.LP
.PN XRecordUnregisterClients
returns zero if the request failed; otherwise
it returns nonzero.
.PN XRecordUnregisterClients
can generate
.PN XRecordBadContext ,
.PN BadMatch ,
and
.PN BadValue
errors.

.NH 2
Query Context State
.XS
\*(SN Query Context State
.XE
.LP
An application uses the
.PN XRecordGetContext
function to query the
current state of a record context, typically over its control connection
to the X server.
.LP
.KS
.DS
.TA .25i 1.5i
.ta .25i 1.5i
Status
XRecordGetContext (Display *\fIdisplay\fP, XRecordContext \fIcontext\fP,
	XRecordState **\fIstate_return\fP)
.DE
.KE
.RS
.IP \fIdisplay\fP 10
Specifies the connection to the X server.
.IP "\fIcontext\fP"
Specifies the record context to query.
.IP "\fIstate_return\fP"
Specifies the address of a variable into which the function stores a
pointer to the current state of the record context.
.RE
.LP
The
.PN XRecordState
typedef returned by
.PN XRecordGetContext
is a structure
with the following members:
.LP
.KS
.DS
.TA .25i 1.5i
.ta .25i 1.5i
XRecordState:
	Bool	enabled
	int	datum_flags
	unsigned long	nclients
	XRecordClientInfo	**client_info
.DE
.KE
.LP
The \fIenabled\fP member is set to the state of data transfer, and is
.PN True
when the recording client has asked that recorded data be sent;
otherwise it is
.PN False .
The \fIdatum_flags\fP member is set to the value of these flags for
this context.
The \fInclients\fP member is set to the
number of
.PN XRecordClientInfo
structures returned.  The \fIclient_info\fP member
is an array of pointers to
.PN XRecordClientInfo
structures, which contain
the protocol
to record for each targeted client.
The
.PN XRecordClientInfo
typedef is a structure with the following members:
.LP
.KS
.DS
.TA .25i 1.5i
.ta .25i 1.5i
XRecordClientInfo:
	XRecordClientSpec	client
	unsigned long	nranges
	XRecordRange	**ranges
.DE
.KE
.LP
The \fIclient\fP member either identifies a client targeted for recording,
or is set to
.PN XRecordFutureClients
to describe how future clients
will be automatically targeted for recording.
The \fInranges\fP member is set to the number of protocol
ranges to be recorded for the specified client.  The \fIranges\fP member
is an array of pointers to
.PN XRecordRange
structures, which specify the
protocol ranges to record.
.LP
.PN XRecordGetContext
returns zero if the request failed; otherwise it
returns nonzero.
The \fIcontext\fP argument must specify a valid
.PN XRecordContext
or a
.PN XRecordBadContext
error results.
.LP
Recording clients should use the
.PN XRecordFreeState
function to free the state data returned by
.PN XRecordGetContext .
.LP
.KS
.DS
.TA .25i 1.5i
.ta .25i 1.5i
void
XRecordFreeState (XRecordState *\fIstate\fP)
.DE
.KE
.RS
.IP "\fIstate\fP"
Specifies the structure that is to be freed.
.RE
.LP
.PN XRecordFreeState
frees the data pointed to by \fIstate.\fP
If the argument does not match an
.PN XRecordState
pointer
returned from a successful call to
.PN XRecordGetContext ,
or if
.PN XRecordFreeState
has already been
called with it, the behavior is undefined.
.NH 2
Data Transfer
.XS
\*(SN Data Transfer
.XE
.LP
An application uses the
.PN XRecordEnableContext
and
.PN XRecordDisableContext
functions to change the state of data transfer
between the X server and the recording client.  These functions allow
the application to start recording and reporting of protocol data,
and to stop recording and reporting of protocol data, respectively.

.SH
Enable Context
.XS
\*(SN Enable Context
.XE
.LP
To direct the X server to record and report protocol, a program
uses
.PN XRecordEnableContext ,
typically over its data connection to the X
server.  The reporting of recorded protocol back to the recording client
is handled by the following data structures and procedure definitions.
Each recorded protocol element is reported
to the recording client through an
.PN XRecordInterceptData
typedef,
a structure with the following members:
.KS
.DS
.TA .25i 1.5i
.ta .25i 1.5i
XRecordInterceptData:
	XID	id_base
	Time	server_time
	unsigned long	client_seq
	int	category
	Bool	client_swapped
	unsigned char	*data
	unsigned long	data_len
.DE
.KE
.LP
The \fIid_base\fP member is set to the resource identifier base sent to the
client in the connection setup reply and therefore identifies the client
being recorded, except when the recorded protocol data is a device
event that may have not been delivered to a client.  In this case,
\fIid_base\fP is set to 0 (zero).  The \fIserver_time\fP member
is set to the time of the server when the protocol was recorded.
It is the time that was attached to this protocol element in the reply,
if so specified by \fIdatum_flags\fP,
or else the time from the header of the reply that contained
this protocol element.
The \fIclient_seq\fP member is the sequence number of the recorded
client's most recent request processed by the server at the time this
protocol element was recorded, if this information were included in the
recorded data; otherwise \fIclient_seq\fP is 0.
The \fIcategory\fP member is set to one of the following values:
.PN XRecordStartOfData ,
.PN XRecordFromServer ,
.PN XRecordFromClient ,
.PN XRecordClientStarted ,
.PN XRecordClientDied
or
.PN XRecordEndOfData .
.PN XRecordStartOfData
is immediately sent as the first reply to confirm
that the context is enabled.
.PN XRecordFromClient
indicates the protocol
data is from the recorded client to the server (requests).
.PN XRecordFromServer
indicates the protocol data is from the server to the recorded client
(replies, errors, events, or device events).
.PN XRecordClientStarted
indicates that the protocol data is the
connection setup reply from the server.
.PN XRecordClientDied
indicates that the recorded
client has closed its connection
to the X server; there is no protocol data.
.PN XRecordEndOfData
indicates that the context has been disabled and that
this is the last datum.  It does not correspond to any protocol or
state change in a recorded client.  There is no protocol data.
.LP
The \fIclient_swapped\fP member is set to
.PN True
if the byte order of the client being recorded is swapped relative to
the recording client; otherwise, it is set to
.PN False .
All
recorded protocol data is returned in the byte-order of the recorded
client.  Therefore, recording clients are responsible for all byte swapping,
if required.
Device events are in the byte order of the
recording client.
For replies of category
.PN XRecordStartOfData
and
.PN XRecordEndOfData ,
\fIclient_swapped\fP is set
according
to the byte order of the server relative to the recording client.
.LP
The \fIdata\fP member contains the actual recorded
protocol data.
When \fIcategory\fP is set to
.PN XRecordStartOfData ,
.PN XRecordClientDied
or
.PN XRecordEndOfData ,
no protocol
data are contained in \fIdata\fP.
.\"
.LP
.\" copied exactly from the protocol document
For the core X events
.PN KeyPress ,
.PN KeyRelease ,
.PN ButtonPress ,
and
.PN ButtonRelease ,
the fields of a device event that contain
valid information are \fItime\fP and \fIdetail\fP.
For the core X event
.PN MotionNotify ,
the fields of a device event that contain
valid information are \fItime\fP, \fIroot\fP,
\fIroot-x\fP and \fIroot-y\fP.
The \fItime\fP field refers to the time the event was generated by the
device.
.LP
For the extension input device events
.PN DeviceKeyPress ,
.PN DeviceKeyRelease ,
.PN DeviceButtonPress ,
and
.PN DeviceButtonRelease ,
the fields of a device event that contain valid information are
\fIdevice\fP, \fItime\fP and \fIdetail\fP.
For
.PN DeviceMotionNotify ,
the valid device event fields are
\fIdevice\fP and \fItime\fP.
For the extension input device events
.PN ProximityIn
and
.PN ProximityOut ,
the fields of a device event that contain valid
information are \fIdevice\fP and \fItime\fP.
For the extension input device event
.PN DeviceValuator ,
the fields of a device event that contain valid information are
\fIdevice\fP,
\fInum_valuators\fP, \fIfirst_valuator\fP, and \fIvaluators\fP.
The \fItime\fP field refers to the time the event was generated by the
device.
.\"
.LP
The \fIdata_len\fP member is set to the
length of the actual recorded protocol data in 4-byte units.
.LP
When the context has been enabled, protocol data the recording client has
previously expressed interest in is recorded and returned to the
recording client via multiple replies.
Because
the X server batches
the recorded data, more than one protocol element may be contained
in the same reply packet.
When a reply is received, a procedure of type
.PN XRecordInterceptProc
is
called for each protocol
element in the reply.
.KS
.DS
.TA .25i 1.75i
.ta .25i 1.75i
typedef void (*XRecordInterceptProc)
	(XPointer \fIclosure\fP, 
	XRecordInterceptData *\fIrecorded_data\fP)
.DE
.KE
.RS
.IP "\fIclosure\fP"
Pointer that was passed in when the context was enabled.
.br
.IP "\fIrecorded_data\fP"
A protocol element recorded by the server extension.
.RE
.KS
.LP
This callback
may use the control display connection (or any display connection
other than the data connection).
.LP
Recording clients should use the
.PN XRecordFreeData
function
to free the
.PN XRecordInterceptData
structure.
.DS
.TA .25i 1.75i
.ta .25i 1.75i
Status
XRecordEnableContext (Display *\fIdisplay\fP, XRecordContext \fIcontext\fP,
	XRecordInterceptProc \fIcallback\fP, XPointer \fIclosure\fP)
.DE
.KE
.RS
.IP "\fIdisplay\fP" 10
Specifies the connection to the X server.
.IP "\fIcontext\fP"
Specifies the record context to enable.
.IP "\fIcallback\fP"
Specifies the function to be called for each protocol element received.
.IP "\fIclosure\fP"
Specifies data passed to \fIcallback.\fP
.RE
.LP
.PN XRecordEnableContext
enables data transfer between the recording client and
the X server.  All core and extension protocol received from or sent to
targeted clients that the recording client has expressed
interest in will be recorded and reported to the recording client.
.LP
.PN XRecordEnableContext
returns zero if the request failed; otherwise it
returns nonzero.  The context argument must specify a valid
.PN XRecordContext
or a
.PN XRecordBadContext
error results.  The error
.PN BadMatch
results when data transfer is already enabled
on the given context.
.SH
Enable Context Asynchronously
.XS
\*(SN Enable Context Asynchronously
.XE
.LP
Because
.PN XRecordEnableContext
does not return until
.PN XRecordDisableContext
is executed on the control connection, a non-blocking interface in
addition to
.PN XRecordEnableContext
is provided.  This interface also
enables data transfer; however, it does not block.
.LP
This interface is defined as follows:
.KS
.DS
.TA .25i 1.75i
.ta .25i 1.75i
Status
XRecordEnableContextAsync (Display *\fIdisplay\fP, XRecordContext \fIcontext\fP,
	XRecordInterceptProc \fIcallback\fP, XPointer \fIclosure\fP)
.DE
.KE
.RS
.IP \fIdisplay\fP 10
Specifies the connection to the X server.
.IP \fIcontext\fP
Specifies the record context to enable.
.IP \fIcallback\fP
Specifies the function to be called for each protocol element received.
.IP \fIclosure\fP
Data passed to \fIcallback\fP.
.RE
.LP
.PN XRecordEnableContextAsync
enables data transfer between the recording
client and the X server just as
.PN XRecordEnableContext
does.
Unlike
.PN XRecordEnableContext ,
it does not wait for the context to be disabled
before returning;
.PN XRecordEnableContextAsync
returns as soon as the
.PN XRecordStartOfData
reply has been received and processed.
.LP
.PN XRecordEnableContextAsync
returns zero if it could not allocate the
necessary memory, and nonzero if it sent the request successfully to
the server.  The context argument must specify a valid
.PN XRecordContext
or a
.PN XRecordBadContext
error results.  The error
.PN BadMatch
results when data transfer is already enabled.
.LP
Each time it reads data from the server connection, Xlib will check
for incoming replies and call \fIcallback\fP as necessary.  The
application may direct Xlib explicitly to check for Record data with
the
.PN XRecordProcessReplies
function.
.KS
.DS
.TA .25i 1.75i
.ta .25i 1.75i
void
XRecordProcessReplies(Display *\fIdisplay\fP)
.DE
.KE
.RS
.IP \fIdisplay\fP 10
Specifies the connection to the X server.
.RE
.LP
.PN XRecordProcessReplies
will check for any replies that have not yet
been processed by the application.  The asynchronous callback will be called
as appropriate.
.PN XRecordProcessReplies
returns when all immediately
available replies have been processed.  It does not block.
.LP
To free the data passed to the
.PN XRecordInterceptProc
callback,
use
.PN XRecordFreeData .
.KS
.DS
.TA .25i 1.75i
.ta .25i 1.75i
void
XRecordFreeData(XRecordInterceptData *\fIdata\fP)
.DE
.KE
.RS
.IP "\fIdata\fP"
Specifies the structure that is to be freed.
.RE
.LP
.PN XRecordFreeData
frees the data pointed to by \fIdata.\fP
If the argument does not match an
.PN XRecordInterceptData
pointer earlier
passed to an
.PN XRecordInterceptProc
callback, or if
.PN XRecordFreeData
has
already been called with it, the behavior is undefined.
.SH
Disable Context
.XS
\*(SN Disable Context
.XE
.LP
To direct the X server to halt the reporting of recorded protocol, the
program executes
.PN XRecordDisableContext ,
typically over its
control connection to the X server.
.KS
.DS
.TA .25i 1.75i
.ta .25i 1.75i
Status
XRecordDisableContext (Display *\fIdisplay\fP, XRecordContext \fIcontext\fP)
.DE
.KE
.RS
.IP "\fIdisplay\fP" 10
Specifies the connection to the X server.
.IP "\fIcontext\fP"
Specifies the record context to disable.
.RE
.LP
The
.PN XRecordDisableContext
function disables \fIcontext\fP, stopping
all recording over its data connection.
Any complete protocol elements for \fIcontext\fP
that were buffered in the server will be sent to the
recording client rather than being discarded.
If a program attempts to disable an
.PN XRecordContext
that has not been enabled, no action will take place.
.LP
.PN XRecordDisableContext
returns zero if the request failed; otherwise it
returns nonzero.  The \fIcontext\fP argument must specify a valid
.PN XRecordContext
or an
.PN XRecordBadContext
error results.

.NH 2
ID Base Mask
.XS
\*(SN ID Base Mask
.XE
.LP
To determine the mask the server uses for the client ID base, use
.PN XRecordIdBaseMask .
.KS
.DS
.TA .25i 1.75i
.ta .25i 1.75i
XID
XRecordIdBaseMask (Display *\fIdisplay\fP)
.DE
.RS
.IP "\fIdisplay\fP" 10
Specifies the connection to the X server.
.RE
.KE
.LP
This function returns the resource id mask passed to the client by the
server at connection setup.

.NH 2
Free Context
.XS
\*(SN Free Context
.XE
.LP
Before terminating, the program should request that the server
free the record context.  This is done with the
.PN XRecordFreeContext
function, typically over the record client's control connection
to the X server.
.KS
.DS
.TA .25i 1.75i
.ta .25i 1.75i
Status
XRecordFreeContext (Display *\fIdisplay\fP, XRecordContext \fIcontext\fP)
.DE
.KE
.RS
.IP "\fIdisplay\fP" 10
Specifies the connection to the X server.
.IP "\fIcontext\fP"
Specifies the record context to free.
.RE
.LP
The
.PN XRecordFreeContext
function frees the given \fIcontext\fP for the
requesting client.  Freeing a record context releases the clients
targeted for recording and their respective protocol ranges to
record.  If protocol data is being reported to the recording client,
generally over the data connection to the X server, the reporting
ceases as if
.PN XRecordDisableContext
had been called on the given \fIcontext\fP.
When a program terminates without freeing
its record context, the X server will automatically free that context
on behalf of the client.
.LP
.PN XRecordFreeContext
returns zero if the request failed; otherwise it
returns nonzero.  The \fIcontext\fP argument must specify a valid
.PN XRecordContext
or a
.PN XRecordBadContext
error results.
.\"
.\" Local Variables:
.\" time-stamp-start: "^\\.ds Ts "
.\" time-stamp-end: "\\\\\""
.\" time-stamp-format: "%d %3b %y (%H:%02M)"
.\" End:
