//
// Copyright 2012 Francisco Jerez
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#ifndef __CORE_COMPILER_HPP__
#define __CORE_COMPILER_HPP__

#include "core/compat.hpp"
#include "core/module.hpp"
#include "pipe/p_defines.h"

namespace clover {
   class build_error {
   public:
      build_error(const compat::string &log) : log(log) {
      }

      virtual ~build_error() {
      }

      compat::string what() {
         return log;
      }

   private:
      compat::vector<char> log;
   };

   class invalid_option_error {
   public:
      invalid_option_error() {
      }

      virtual ~invalid_option_error() {
      }
   };

   module compile_program_llvm(const compat::string &source,
                               enum pipe_shader_ir ir,
                               const compat::string &target,
                               const compat::string &opts);

   module compile_program_tgsi(const compat::string &source);
}

#endif
