
/***
 ***  NOTE!!!  DO NOT EDIT THIS FILE!!!  IT IS GENERATED BY get_gen.py
 ***/

#include "main/glheader.h"
#include "main/context.h"
#include "main/enable.h"
#include "main/extensions.h"
#include "main/fbobject.h"
#include "main/get.h"
#include "main/macros.h"
#include "main/mtypes.h"
#include "main/state.h"
#include "main/texcompress.h"


/* ES1 tokens that should be in gl.h but aren't */
#define GL_MAX_ELEMENTS_INDICES             0x80E9
#define GL_MAX_ELEMENTS_VERTICES            0x80E8


/* ES2 special tokens */
#define GL_MAX_FRAGMENT_UNIFORM_VECTORS     0x8DFD
#define GL_MAX_VARYING_VECTORS              0x8DFC
#define GL_MAX_VARYING_VECTORS              0x8DFC
#define GL_MAX_VERTEX_UNIFORM_VECTORS       0x8DFB
#define GL_SHADER_COMPILER                  0x8DFA
#define GL_PLATFORM_BINARY                  0x8D63
#define GL_SHADER_BINARY_FORMATS            0x8DF8
#define GL_NUM_SHADER_BINARY_FORMATS        0x8DF9


#ifndef GL_OES_matrix_get
#define GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES               0x898D
#define GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES              0x898E
#define GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES                 0x898F
#endif

#ifndef GL_OES_compressed_paletted_texture
#define GL_PALETTE4_RGB8_OES                                    0x8B90
#define GL_PALETTE4_RGBA8_OES                                   0x8B91
#define GL_PALETTE4_R5_G6_B5_OES                                0x8B92
#define GL_PALETTE4_RGBA4_OES                                   0x8B93
#define GL_PALETTE4_RGB5_A1_OES                                 0x8B94
#define GL_PALETTE8_RGB8_OES                                    0x8B95
#define GL_PALETTE8_RGBA8_OES                                   0x8B96
#define GL_PALETTE8_R5_G6_B5_OES                                0x8B97
#define GL_PALETTE8_RGBA4_OES                                   0x8B98
#define GL_PALETTE8_RGB5_A1_OES                                 0x8B99
#endif


#define FLOAT_TO_BOOLEAN(X)   ( (X) ? GL_TRUE : GL_FALSE )

#define INT_TO_BOOLEAN(I)     ( (I) ? GL_TRUE : GL_FALSE )

#define BOOLEAN_TO_INT(B)     ( (GLint) (B) )
#define BOOLEAN_TO_FLOAT(B)   ( (B) ? 1.0F : 0.0F )


/*
 * Check if named extension is enabled, if not generate error and return.
 */
#define CHECK_EXT1(EXT1, FUNC)                                         \
   if (!ctx->Extensions.EXT1) {                                        \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }

/*
 * Check if either of two extensions is enabled.
 */
#define CHECK_EXT2(EXT1, EXT2, FUNC)                                   \
   if (!ctx->Extensions.EXT1 && !ctx->Extensions.EXT2) {               \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }

/*
 * Check if either of three extensions is enabled.
 */
#define CHECK_EXT3(EXT1, EXT2, EXT3, FUNC)                             \
   if (!ctx->Extensions.EXT1 && !ctx->Extensions.EXT2 &&               \
       !ctx->Extensions.EXT3) {                                        \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }

/*
 * Check if either of four extensions is enabled.
 */
#define CHECK_EXT4(EXT1, EXT2, EXT3, EXT4, FUNC)                       \
   if (!ctx->Extensions.EXT1 && !ctx->Extensions.EXT2 &&               \
       !ctx->Extensions.EXT3 && !ctx->Extensions.EXT4) {               \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }



/**
 * List of compressed texture formats supported by ES.
 */
static GLenum compressed_formats[] = {
   GL_PALETTE4_RGB8_OES,
   GL_PALETTE4_RGBA8_OES,
   GL_PALETTE4_R5_G6_B5_OES,
   GL_PALETTE4_RGBA4_OES,
   GL_PALETTE4_RGB5_A1_OES,
   GL_PALETTE8_RGB8_OES,
   GL_PALETTE8_RGBA8_OES,
   GL_PALETTE8_R5_G6_B5_OES,
   GL_PALETTE8_RGBA4_OES,
   GL_PALETTE8_RGB5_A1_OES
};

#define ARRAY_SIZE(A)  (sizeof(A) / sizeof(A[0]))


void GLAPIENTRY
_mesa_GetBooleanv( GLenum pname, GLboolean *params )
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END(ctx);

   if (!params)
      return;

   if (ctx->NewState)
      _mesa_update_state(ctx);

   switch (pname) {
      case GL_ALPHA_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.alphaBits);
         break;
      case GL_BLEND:
         params[0] = ctx->Color.BlendEnabled;
         break;
      case GL_BLEND_SRC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLUE_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.blueBits);
         break;
      case GL_COLOR_CLEAR_VALUE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[2]);
         params[3] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[3]);
         break;
      case GL_COLOR_WRITEMASK:
         params[0] = INT_TO_BOOLEAN(ctx->Color.ColorMask[RCOMP] ? 1 : 0);
         params[1] = INT_TO_BOOLEAN(ctx->Color.ColorMask[GCOMP] ? 1 : 0);
         params[2] = INT_TO_BOOLEAN(ctx->Color.ColorMask[BCOMP] ? 1 : 0);
         params[3] = INT_TO_BOOLEAN(ctx->Color.ColorMask[ACOMP] ? 1 : 0);
         break;
      case GL_CULL_FACE:
         params[0] = ctx->Polygon.CullFlag;
         break;
      case GL_CULL_FACE_MODE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Polygon.CullFaceMode);
         break;
      case GL_DEPTH_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.depthBits);
         break;
      case GL_DEPTH_CLEAR_VALUE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Depth.Clear);
         break;
      case GL_DEPTH_FUNC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Depth.Func);
         break;
      case GL_DEPTH_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Viewport.Near);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Viewport.Far);
         break;
      case GL_DEPTH_TEST:
         params[0] = ctx->Depth.Test;
         break;
      case GL_DEPTH_WRITEMASK:
         params[0] = ctx->Depth.Mask;
         break;
      case GL_DITHER:
         params[0] = ctx->Color.DitherFlag;
         break;
      case GL_FRONT_FACE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Polygon.FrontFace);
         break;
      case GL_GREEN_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.greenBits);
         break;
      case GL_LINE_WIDTH:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Line.Width);
         break;
      case GL_ALIASED_LINE_WIDTH_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Const.MinLineWidth);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Const.MaxLineWidth);
         break;
      case GL_MAX_ELEMENTS_INDICES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_ELEMENTS_VERTICES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_TEXTURE_SIZE:
         params[0] = INT_TO_BOOLEAN(1 << (ctx->Const.MaxTextureLevels - 1));
         break;
      case GL_MAX_VIEWPORT_DIMS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxViewportWidth);
         params[1] = INT_TO_BOOLEAN(ctx->Const.MaxViewportHeight);
         break;
      case GL_PACK_ALIGNMENT:
         params[0] = INT_TO_BOOLEAN(ctx->Pack.Alignment);
         break;
      case GL_ALIASED_POINT_SIZE_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Const.MinPointSize);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Const.MaxPointSize);
         break;
      case GL_POLYGON_OFFSET_FACTOR:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Polygon.OffsetFactor );
         break;
      case GL_POLYGON_OFFSET_UNITS:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Polygon.OffsetUnits );
         break;
      case GL_RED_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.redBits);
         break;
      case GL_SCISSOR_BOX:
         params[0] = INT_TO_BOOLEAN(ctx->Scissor.X);
         params[1] = INT_TO_BOOLEAN(ctx->Scissor.Y);
         params[2] = INT_TO_BOOLEAN(ctx->Scissor.Width);
         params[3] = INT_TO_BOOLEAN(ctx->Scissor.Height);
         break;
      case GL_SCISSOR_TEST:
         params[0] = ctx->Scissor.Enabled;
         break;
      case GL_STENCIL_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.stencilBits);
         break;
      case GL_STENCIL_CLEAR_VALUE:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.Clear);
         break;
      case GL_STENCIL_FAIL:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.FailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_FUNC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.Function[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.ZFailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.ZPassFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_REF:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.Ref[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_TEST:
         params[0] = ctx->Stencil.Enabled;
         break;
      case GL_STENCIL_VALUE_MASK:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.ValueMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_WRITEMASK:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.WriteMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_SUBPIXEL_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.SubPixelBits);
         break;
      case GL_TEXTURE_BINDING_2D:
         params[0] = INT_TO_BOOLEAN(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_2D_INDEX]->Name);
         break;
      case GL_UNPACK_ALIGNMENT:
         params[0] = INT_TO_BOOLEAN(ctx->Unpack.Alignment);
         break;
      case GL_VIEWPORT:
         params[0] = INT_TO_BOOLEAN(ctx->Viewport.X);
         params[1] = INT_TO_BOOLEAN(ctx->Viewport.Y);
         params[2] = INT_TO_BOOLEAN(ctx->Viewport.Width);
         params[3] = INT_TO_BOOLEAN(ctx->Viewport.Height);
         break;
      case GL_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(GL_TEXTURE0_ARB + ctx->Texture.CurrentUnit);
         break;
      case GL_TEXTURE_BINDING_CUBE_MAP_ARB:
         params[0] = INT_TO_BOOLEAN(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_CUBE_INDEX]->Name);
         break;
      case GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB:
         params[0] = INT_TO_BOOLEAN((1 << (ctx->Const.MaxCubeTextureLevels - 1)));
         break;
      case GL_BLEND_SRC_RGB_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLEND_DST_RGB_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendDstRGB);
         break;
      case GL_BLEND_SRC_ALPHA_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendSrcA);
         break;
      case GL_BLEND_DST_ALPHA_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendDstA);
         break;
      case GL_BLEND_EQUATION:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendEquationRGB );
         break;
      case GL_BLEND_EQUATION_ALPHA_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendEquationA );
         break;
      case GL_SAMPLE_ALPHA_TO_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.SampleAlphaToCoverage;
         break;
      case GL_SAMPLE_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.SampleCoverage;
         break;
      case GL_SAMPLE_COVERAGE_VALUE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = FLOAT_TO_BOOLEAN(ctx->Multisample.SampleCoverageValue);
         break;
      case GL_SAMPLE_COVERAGE_INVERT_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.SampleCoverageInvert;
         break;
      case GL_SAMPLE_BUFFERS_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.sampleBuffers);
         break;
      case GL_SAMPLES_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.samples);
         break;
      case GL_GENERATE_MIPMAP_HINT_SGIS:
         CHECK_EXT1(SGIS_generate_mipmap, "_mesa_GetBooleanv");
         params[0] = ENUM_TO_BOOLEAN(ctx->Hint.GenerateMipmap);
         break;
      case GL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayBufferObj->Name);
         break;
      case GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ElementArrayBufferObj->Name);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.ColorReadType);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.ColorReadFormat);
         break;
      case GL_FRAMEBUFFER_BINDING_EXT:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Name);
         break;
      case GL_RENDERBUFFER_BINDING_EXT:
         params[0] = INT_TO_BOOLEAN(ctx->CurrentRenderbuffer ? ctx->CurrentRenderbuffer->Name : 0);
         break;
      case GL_MAX_RENDERBUFFER_SIZE_EXT:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxRenderbufferSize);
         break;
      case GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB:
         params[0] = INT_TO_BOOLEAN(ARRAY_SIZE(compressed_formats));
         break;
      case GL_COMPRESSED_TEXTURE_FORMATS_ARB:
         {
         
     int i;
     for (i = 0; i < ARRAY_SIZE(compressed_formats); i++) {
        params[i] = compressed_formats[i];
     }
         }
         break;
      case GL_POLYGON_OFFSET_FILL:
         params[0] = ctx->Polygon.OffsetFill;
         break;
      case GL_MAX_LIGHTS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxLights);
         break;
      case GL_MAX_CLIP_PLANES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxClipPlanes);
         break;
      case GL_MAX_TEXTURE_COORDS_ARB:
         CHECK_EXT2(ARB_fragment_program, NV_fragment_program, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxTextureCoordUnits);
         break;
      case GL_MAX_DRAW_BUFFERS_ARB:
         CHECK_EXT1(ARB_draw_buffers, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxDrawBuffers);
         break;
      case GL_BLEND_COLOR_EXT:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Color.BlendColor[0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Color.BlendColor[1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Color.BlendColor[2]);
         params[3] = FLOAT_TO_BOOLEAN(ctx->Color.BlendColor[3]);
         break;
      case GL_MAX_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT2(ARB_fragment_program, NV_fragment_program, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxTextureImageUnits);
         break;
      case GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxVertexTextureImageUnits);
         break;
      case GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(MAX_COMBINED_TEXTURE_IMAGE_UNITS);
         break;
      case GL_CURRENT_PROGRAM:
         CHECK_EXT1(ARB_shader_objects, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Shader.CurrentProgram ? ctx->Shader.CurrentProgram->Name : 0);
         break;
      case GL_STENCIL_BACK_FUNC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.Function[1]);
         break;
      case GL_STENCIL_BACK_VALUE_MASK:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.ValueMask[1]);
         break;
      case GL_STENCIL_BACK_WRITEMASK:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.WriteMask[1]);
         break;
      case GL_STENCIL_BACK_REF:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.Ref[1]);
         break;
      case GL_STENCIL_BACK_FAIL:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.FailFunc[1]);
         break;
      case GL_STENCIL_BACK_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.ZFailFunc[1]);
         break;
      case GL_STENCIL_BACK_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.ZPassFunc[1]);
         break;
      case GL_MAX_VERTEX_ATTRIBS_ARB:
         CHECK_EXT1(ARB_vertex_program, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.VertexProgram.MaxAttribs);
         break;
      case GL_TEXTURE_BINDING_3D:
         params[0] = INT_TO_BOOLEAN(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_3D_INDEX]->Name);
         break;
      case GL_MAX_3D_TEXTURE_SIZE:
         params[0] = INT_TO_BOOLEAN(1 << (ctx->Const.Max3DTextureLevels - 1));
         break;
      case GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB:
         CHECK_EXT1(ARB_fragment_shader, "_mesa_GetBooleanv");
         params[0] = ENUM_TO_BOOLEAN(ctx->Hint.FragmentShaderDerivative);
         break;
      case GL_MAX_FRAGMENT_UNIFORM_VECTORS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.FragmentProgram.MaxUniformComponents / 4);
         break;
      case GL_MAX_VARYING_VECTORS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxVarying);
         break;
      case GL_MAX_VERTEX_UNIFORM_VECTORS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.VertexProgram.MaxUniformComponents / 4);
         break;
      case GL_SHADER_COMPILER:
         params[0] = INT_TO_BOOLEAN(1);
         break;
      case GL_NUM_SHADER_BINARY_FORMATS:
         params[0] = INT_TO_BOOLEAN(0);
         break;
      case GL_SHADER_BINARY_FORMATS:
         break;
      default:
         _mesa_error(ctx, GL_INVALID_ENUM, "gl_mesa_GetBooleanv(pname=0x%x)", pname);
   }
}

void GLAPIENTRY
_mesa_GetFloatv( GLenum pname, GLfloat *params )
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END(ctx);

   if (!params)
      return;

   if (ctx->NewState)
      _mesa_update_state(ctx);

   switch (pname) {
      case GL_ALPHA_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.alphaBits);
         break;
      case GL_BLEND:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Color.BlendEnabled);
         break;
      case GL_BLEND_SRC:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLUE_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.blueBits);
         break;
      case GL_COLOR_CLEAR_VALUE:
         params[0] = ctx->Color.ClearColor[0];
         params[1] = ctx->Color.ClearColor[1];
         params[2] = ctx->Color.ClearColor[2];
         params[3] = ctx->Color.ClearColor[3];
         break;
      case GL_COLOR_WRITEMASK:
         params[0] = (GLfloat)(ctx->Color.ColorMask[RCOMP] ? 1 : 0);
         params[1] = (GLfloat)(ctx->Color.ColorMask[GCOMP] ? 1 : 0);
         params[2] = (GLfloat)(ctx->Color.ColorMask[BCOMP] ? 1 : 0);
         params[3] = (GLfloat)(ctx->Color.ColorMask[ACOMP] ? 1 : 0);
         break;
      case GL_CULL_FACE:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Polygon.CullFlag);
         break;
      case GL_CULL_FACE_MODE:
         params[0] = ENUM_TO_FLOAT(ctx->Polygon.CullFaceMode);
         break;
      case GL_DEPTH_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.depthBits);
         break;
      case GL_DEPTH_CLEAR_VALUE:
         params[0] = ctx->Depth.Clear;
         break;
      case GL_DEPTH_FUNC:
         params[0] = ENUM_TO_FLOAT(ctx->Depth.Func);
         break;
      case GL_DEPTH_RANGE:
         params[0] = ctx->Viewport.Near;
         params[1] = ctx->Viewport.Far;
         break;
      case GL_DEPTH_TEST:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Depth.Test);
         break;
      case GL_DEPTH_WRITEMASK:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Depth.Mask);
         break;
      case GL_DITHER:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Color.DitherFlag);
         break;
      case GL_FRONT_FACE:
         params[0] = ENUM_TO_FLOAT(ctx->Polygon.FrontFace);
         break;
      case GL_GREEN_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.greenBits);
         break;
      case GL_LINE_WIDTH:
         params[0] = ctx->Line.Width;
         break;
      case GL_ALIASED_LINE_WIDTH_RANGE:
         params[0] = ctx->Const.MinLineWidth;
         params[1] = ctx->Const.MaxLineWidth;
         break;
      case GL_MAX_ELEMENTS_INDICES:
         params[0] = (GLfloat)(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_ELEMENTS_VERTICES:
         params[0] = (GLfloat)(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_TEXTURE_SIZE:
         params[0] = (GLfloat)(1 << (ctx->Const.MaxTextureLevels - 1));
         break;
      case GL_MAX_VIEWPORT_DIMS:
         params[0] = (GLfloat)(ctx->Const.MaxViewportWidth);
         params[1] = (GLfloat)(ctx->Const.MaxViewportHeight);
         break;
      case GL_PACK_ALIGNMENT:
         params[0] = (GLfloat)(ctx->Pack.Alignment);
         break;
      case GL_ALIASED_POINT_SIZE_RANGE:
         params[0] = ctx->Const.MinPointSize;
         params[1] = ctx->Const.MaxPointSize;
         break;
      case GL_POLYGON_OFFSET_FACTOR:
         params[0] = ctx->Polygon.OffsetFactor ;
         break;
      case GL_POLYGON_OFFSET_UNITS:
         params[0] = ctx->Polygon.OffsetUnits ;
         break;
      case GL_RED_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.redBits);
         break;
      case GL_SCISSOR_BOX:
         params[0] = (GLfloat)(ctx->Scissor.X);
         params[1] = (GLfloat)(ctx->Scissor.Y);
         params[2] = (GLfloat)(ctx->Scissor.Width);
         params[3] = (GLfloat)(ctx->Scissor.Height);
         break;
      case GL_SCISSOR_TEST:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Scissor.Enabled);
         break;
      case GL_STENCIL_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.stencilBits);
         break;
      case GL_STENCIL_CLEAR_VALUE:
         params[0] = (GLfloat)(ctx->Stencil.Clear);
         break;
      case GL_STENCIL_FAIL:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.FailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_FUNC:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.Function[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.ZFailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.ZPassFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_REF:
         params[0] = (GLfloat)(ctx->Stencil.Ref[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_TEST:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Stencil.Enabled);
         break;
      case GL_STENCIL_VALUE_MASK:
         params[0] = (GLfloat)(ctx->Stencil.ValueMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_WRITEMASK:
         params[0] = (GLfloat)(ctx->Stencil.WriteMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_SUBPIXEL_BITS:
         params[0] = (GLfloat)(ctx->Const.SubPixelBits);
         break;
      case GL_TEXTURE_BINDING_2D:
         params[0] = (GLfloat)(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_2D_INDEX]->Name);
         break;
      case GL_UNPACK_ALIGNMENT:
         params[0] = (GLfloat)(ctx->Unpack.Alignment);
         break;
      case GL_VIEWPORT:
         params[0] = (GLfloat)(ctx->Viewport.X);
         params[1] = (GLfloat)(ctx->Viewport.Y);
         params[2] = (GLfloat)(ctx->Viewport.Width);
         params[3] = (GLfloat)(ctx->Viewport.Height);
         break;
      case GL_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetFloatv");
         params[0] = (GLfloat)(GL_TEXTURE0_ARB + ctx->Texture.CurrentUnit);
         break;
      case GL_TEXTURE_BINDING_CUBE_MAP_ARB:
         params[0] = (GLfloat)(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_CUBE_INDEX]->Name);
         break;
      case GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB:
         params[0] = (GLfloat)((1 << (ctx->Const.MaxCubeTextureLevels - 1)));
         break;
      case GL_BLEND_SRC_RGB_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLEND_DST_RGB_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendDstRGB);
         break;
      case GL_BLEND_SRC_ALPHA_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendSrcA);
         break;
      case GL_BLEND_DST_ALPHA_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendDstA);
         break;
      case GL_BLEND_EQUATION:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendEquationRGB );
         break;
      case GL_BLEND_EQUATION_ALPHA_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendEquationA );
         break;
      case GL_SAMPLE_ALPHA_TO_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.SampleAlphaToCoverage);
         break;
      case GL_SAMPLE_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.SampleCoverage);
         break;
      case GL_SAMPLE_COVERAGE_VALUE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = ctx->Multisample.SampleCoverageValue;
         break;
      case GL_SAMPLE_COVERAGE_INVERT_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.SampleCoverageInvert);
         break;
      case GL_SAMPLE_BUFFERS_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.sampleBuffers);
         break;
      case GL_SAMPLES_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.samples);
         break;
      case GL_GENERATE_MIPMAP_HINT_SGIS:
         CHECK_EXT1(SGIS_generate_mipmap, "_mesa_GetFloatv");
         params[0] = ENUM_TO_FLOAT(ctx->Hint.GenerateMipmap);
         break;
      case GL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ArrayBufferObj->Name);
         break;
      case GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ElementArrayBufferObj->Name);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
         params[0] = (GLfloat)(ctx->Const.ColorReadType);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
         params[0] = (GLfloat)(ctx->Const.ColorReadFormat);
         break;
      case GL_FRAMEBUFFER_BINDING_EXT:
         params[0] = (GLfloat)(ctx->DrawBuffer->Name);
         break;
      case GL_RENDERBUFFER_BINDING_EXT:
         params[0] = (GLfloat)(ctx->CurrentRenderbuffer ? ctx->CurrentRenderbuffer->Name : 0);
         break;
      case GL_MAX_RENDERBUFFER_SIZE_EXT:
         params[0] = (GLfloat)(ctx->Const.MaxRenderbufferSize);
         break;
      case GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB:
         params[0] = (GLfloat)(ARRAY_SIZE(compressed_formats));
         break;
      case GL_COMPRESSED_TEXTURE_FORMATS_ARB:
         {
         
     int i;
     for (i = 0; i < ARRAY_SIZE(compressed_formats); i++) {
        params[i] = compressed_formats[i];
     }
         }
         break;
      case GL_POLYGON_OFFSET_FILL:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Polygon.OffsetFill);
         break;
      case GL_MAX_LIGHTS:
         params[0] = (GLfloat)(ctx->Const.MaxLights);
         break;
      case GL_MAX_CLIP_PLANES:
         params[0] = (GLfloat)(ctx->Const.MaxClipPlanes);
         break;
      case GL_MAX_TEXTURE_COORDS_ARB:
         CHECK_EXT2(ARB_fragment_program, NV_fragment_program, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.MaxTextureCoordUnits);
         break;
      case GL_MAX_DRAW_BUFFERS_ARB:
         CHECK_EXT1(ARB_draw_buffers, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.MaxDrawBuffers);
         break;
      case GL_BLEND_COLOR_EXT:
         params[0] = ctx->Color.BlendColor[0];
         params[1] = ctx->Color.BlendColor[1];
         params[2] = ctx->Color.BlendColor[2];
         params[3] = ctx->Color.BlendColor[3];
         break;
      case GL_MAX_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT2(ARB_fragment_program, NV_fragment_program, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.MaxTextureImageUnits);
         break;
      case GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.MaxVertexTextureImageUnits);
         break;
      case GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetFloatv");
         params[0] = (GLfloat)(MAX_COMBINED_TEXTURE_IMAGE_UNITS);
         break;
      case GL_CURRENT_PROGRAM:
         CHECK_EXT1(ARB_shader_objects, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Shader.CurrentProgram ? ctx->Shader.CurrentProgram->Name : 0);
         break;
      case GL_STENCIL_BACK_FUNC:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.Function[1]);
         break;
      case GL_STENCIL_BACK_VALUE_MASK:
         params[0] = (GLfloat)(ctx->Stencil.ValueMask[1]);
         break;
      case GL_STENCIL_BACK_WRITEMASK:
         params[0] = (GLfloat)(ctx->Stencil.WriteMask[1]);
         break;
      case GL_STENCIL_BACK_REF:
         params[0] = (GLfloat)(ctx->Stencil.Ref[1]);
         break;
      case GL_STENCIL_BACK_FAIL:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.FailFunc[1]);
         break;
      case GL_STENCIL_BACK_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.ZFailFunc[1]);
         break;
      case GL_STENCIL_BACK_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.ZPassFunc[1]);
         break;
      case GL_MAX_VERTEX_ATTRIBS_ARB:
         CHECK_EXT1(ARB_vertex_program, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.VertexProgram.MaxAttribs);
         break;
      case GL_TEXTURE_BINDING_3D:
         params[0] = (GLfloat)(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_3D_INDEX]->Name);
         break;
      case GL_MAX_3D_TEXTURE_SIZE:
         params[0] = (GLfloat)(1 << (ctx->Const.Max3DTextureLevels - 1));
         break;
      case GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB:
         CHECK_EXT1(ARB_fragment_shader, "_mesa_GetFloatv");
         params[0] = ENUM_TO_FLOAT(ctx->Hint.FragmentShaderDerivative);
         break;
      case GL_MAX_FRAGMENT_UNIFORM_VECTORS:
         params[0] = (GLfloat)(ctx->Const.FragmentProgram.MaxUniformComponents / 4);
         break;
      case GL_MAX_VARYING_VECTORS:
         params[0] = (GLfloat)(ctx->Const.MaxVarying);
         break;
      case GL_MAX_VERTEX_UNIFORM_VECTORS:
         params[0] = (GLfloat)(ctx->Const.VertexProgram.MaxUniformComponents / 4);
         break;
      case GL_SHADER_COMPILER:
         params[0] = (GLfloat)(1);
         break;
      case GL_NUM_SHADER_BINARY_FORMATS:
         params[0] = (GLfloat)(0);
         break;
      case GL_SHADER_BINARY_FORMATS:
         break;
      default:
         _mesa_error(ctx, GL_INVALID_ENUM, "gl_mesa_GetFloatv(pname=0x%x)", pname);
   }
}

void GLAPIENTRY
_mesa_GetIntegerv( GLenum pname, GLint *params )
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END(ctx);

   if (!params)
      return;

   if (ctx->NewState)
      _mesa_update_state(ctx);

   switch (pname) {
      case GL_ALPHA_BITS:
         params[0] = ctx->DrawBuffer->Visual.alphaBits;
         break;
      case GL_BLEND:
         params[0] = BOOLEAN_TO_INT(ctx->Color.BlendEnabled);
         break;
      case GL_BLEND_SRC:
         params[0] = ENUM_TO_INT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLUE_BITS:
         params[0] = ctx->DrawBuffer->Visual.blueBits;
         break;
      case GL_COLOR_CLEAR_VALUE:
         params[0] = FLOAT_TO_INT(ctx->Color.ClearColor[0]);
         params[1] = FLOAT_TO_INT(ctx->Color.ClearColor[1]);
         params[2] = FLOAT_TO_INT(ctx->Color.ClearColor[2]);
         params[3] = FLOAT_TO_INT(ctx->Color.ClearColor[3]);
         break;
      case GL_COLOR_WRITEMASK:
         params[0] = ctx->Color.ColorMask[RCOMP] ? 1 : 0;
         params[1] = ctx->Color.ColorMask[GCOMP] ? 1 : 0;
         params[2] = ctx->Color.ColorMask[BCOMP] ? 1 : 0;
         params[3] = ctx->Color.ColorMask[ACOMP] ? 1 : 0;
         break;
      case GL_CULL_FACE:
         params[0] = BOOLEAN_TO_INT(ctx->Polygon.CullFlag);
         break;
      case GL_CULL_FACE_MODE:
         params[0] = ENUM_TO_INT(ctx->Polygon.CullFaceMode);
         break;
      case GL_DEPTH_BITS:
         params[0] = ctx->DrawBuffer->Visual.depthBits;
         break;
      case GL_DEPTH_CLEAR_VALUE:
         params[0] = FLOAT_TO_INT(ctx->Depth.Clear);
         break;
      case GL_DEPTH_FUNC:
         params[0] = ENUM_TO_INT(ctx->Depth.Func);
         break;
      case GL_DEPTH_RANGE:
         params[0] = FLOAT_TO_INT(ctx->Viewport.Near);
         params[1] = FLOAT_TO_INT(ctx->Viewport.Far);
         break;
      case GL_DEPTH_TEST:
         params[0] = BOOLEAN_TO_INT(ctx->Depth.Test);
         break;
      case GL_DEPTH_WRITEMASK:
         params[0] = BOOLEAN_TO_INT(ctx->Depth.Mask);
         break;
      case GL_DITHER:
         params[0] = BOOLEAN_TO_INT(ctx->Color.DitherFlag);
         break;
      case GL_FRONT_FACE:
         params[0] = ENUM_TO_INT(ctx->Polygon.FrontFace);
         break;
      case GL_GREEN_BITS:
         params[0] = ctx->DrawBuffer->Visual.greenBits;
         break;
      case GL_LINE_WIDTH:
         params[0] = IROUND(ctx->Line.Width);
         break;
      case GL_ALIASED_LINE_WIDTH_RANGE:
         params[0] = IROUND(ctx->Const.MinLineWidth);
         params[1] = IROUND(ctx->Const.MaxLineWidth);
         break;
      case GL_MAX_ELEMENTS_INDICES:
         params[0] = ctx->Const.MaxArrayLockSize;
         break;
      case GL_MAX_ELEMENTS_VERTICES:
         params[0] = ctx->Const.MaxArrayLockSize;
         break;
      case GL_MAX_TEXTURE_SIZE:
         params[0] = 1 << (ctx->Const.MaxTextureLevels - 1);
         break;
      case GL_MAX_VIEWPORT_DIMS:
         params[0] = ctx->Const.MaxViewportWidth;
         params[1] = ctx->Const.MaxViewportHeight;
         break;
      case GL_PACK_ALIGNMENT:
         params[0] = ctx->Pack.Alignment;
         break;
      case GL_ALIASED_POINT_SIZE_RANGE:
         params[0] = IROUND(ctx->Const.MinPointSize);
         params[1] = IROUND(ctx->Const.MaxPointSize);
         break;
      case GL_POLYGON_OFFSET_FACTOR:
         params[0] = IROUND(ctx->Polygon.OffsetFactor );
         break;
      case GL_POLYGON_OFFSET_UNITS:
         params[0] = IROUND(ctx->Polygon.OffsetUnits );
         break;
      case GL_RED_BITS:
         params[0] = ctx->DrawBuffer->Visual.redBits;
         break;
      case GL_SCISSOR_BOX:
         params[0] = ctx->Scissor.X;
         params[1] = ctx->Scissor.Y;
         params[2] = ctx->Scissor.Width;
         params[3] = ctx->Scissor.Height;
         break;
      case GL_SCISSOR_TEST:
         params[0] = BOOLEAN_TO_INT(ctx->Scissor.Enabled);
         break;
      case GL_STENCIL_BITS:
         params[0] = ctx->DrawBuffer->Visual.stencilBits;
         break;
      case GL_STENCIL_CLEAR_VALUE:
         params[0] = ctx->Stencil.Clear;
         break;
      case GL_STENCIL_FAIL:
         params[0] = ENUM_TO_INT(ctx->Stencil.FailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_FUNC:
         params[0] = ENUM_TO_INT(ctx->Stencil.Function[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_INT(ctx->Stencil.ZFailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_INT(ctx->Stencil.ZPassFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_REF:
         params[0] = ctx->Stencil.Ref[ctx->Stencil.ActiveFace];
         break;
      case GL_STENCIL_TEST:
         params[0] = BOOLEAN_TO_INT(ctx->Stencil.Enabled);
         break;
      case GL_STENCIL_VALUE_MASK:
         params[0] = ctx->Stencil.ValueMask[ctx->Stencil.ActiveFace];
         break;
      case GL_STENCIL_WRITEMASK:
         params[0] = ctx->Stencil.WriteMask[ctx->Stencil.ActiveFace];
         break;
      case GL_SUBPIXEL_BITS:
         params[0] = ctx->Const.SubPixelBits;
         break;
      case GL_TEXTURE_BINDING_2D:
         params[0] = ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_2D_INDEX]->Name;
         break;
      case GL_UNPACK_ALIGNMENT:
         params[0] = ctx->Unpack.Alignment;
         break;
      case GL_VIEWPORT:
         params[0] = ctx->Viewport.X;
         params[1] = ctx->Viewport.Y;
         params[2] = ctx->Viewport.Width;
         params[3] = ctx->Viewport.Height;
         break;
      case GL_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetIntegerv");
         params[0] = GL_TEXTURE0_ARB + ctx->Texture.CurrentUnit;
         break;
      case GL_TEXTURE_BINDING_CUBE_MAP_ARB:
         params[0] = ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_CUBE_INDEX]->Name;
         break;
      case GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB:
         params[0] = (1 << (ctx->Const.MaxCubeTextureLevels - 1));
         break;
      case GL_BLEND_SRC_RGB_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLEND_DST_RGB_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendDstRGB);
         break;
      case GL_BLEND_SRC_ALPHA_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendSrcA);
         break;
      case GL_BLEND_DST_ALPHA_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendDstA);
         break;
      case GL_BLEND_EQUATION:
         params[0] = ENUM_TO_INT(ctx->Color.BlendEquationRGB );
         break;
      case GL_BLEND_EQUATION_ALPHA_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendEquationA );
         break;
      case GL_SAMPLE_ALPHA_TO_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.SampleAlphaToCoverage);
         break;
      case GL_SAMPLE_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.SampleCoverage);
         break;
      case GL_SAMPLE_COVERAGE_VALUE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = IROUND(ctx->Multisample.SampleCoverageValue);
         break;
      case GL_SAMPLE_COVERAGE_INVERT_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.SampleCoverageInvert);
         break;
      case GL_SAMPLE_BUFFERS_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = ctx->DrawBuffer->Visual.sampleBuffers;
         break;
      case GL_SAMPLES_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = ctx->DrawBuffer->Visual.samples;
         break;
      case GL_GENERATE_MIPMAP_HINT_SGIS:
         CHECK_EXT1(SGIS_generate_mipmap, "_mesa_GetIntegerv");
         params[0] = ENUM_TO_INT(ctx->Hint.GenerateMipmap);
         break;
      case GL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ArrayBufferObj->Name;
         break;
      case GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ElementArrayBufferObj->Name;
         break;
      case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
         params[0] = ctx->Const.ColorReadType;
         break;
      case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
         params[0] = ctx->Const.ColorReadFormat;
         break;
      case GL_FRAMEBUFFER_BINDING_EXT:
         params[0] = ctx->DrawBuffer->Name;
         break;
      case GL_RENDERBUFFER_BINDING_EXT:
         params[0] = ctx->CurrentRenderbuffer ? ctx->CurrentRenderbuffer->Name : 0;
         break;
      case GL_MAX_RENDERBUFFER_SIZE_EXT:
         params[0] = ctx->Const.MaxRenderbufferSize;
         break;
      case GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB:
         params[0] = ARRAY_SIZE(compressed_formats);
         break;
      case GL_COMPRESSED_TEXTURE_FORMATS_ARB:
         {
         
     int i;
     for (i = 0; i < ARRAY_SIZE(compressed_formats); i++) {
        params[i] = compressed_formats[i];
     }
         }
         break;
      case GL_POLYGON_OFFSET_FILL:
         params[0] = BOOLEAN_TO_INT(ctx->Polygon.OffsetFill);
         break;
      case GL_MAX_LIGHTS:
         params[0] = ctx->Const.MaxLights;
         break;
      case GL_MAX_CLIP_PLANES:
         params[0] = ctx->Const.MaxClipPlanes;
         break;
      case GL_MAX_TEXTURE_COORDS_ARB:
         CHECK_EXT2(ARB_fragment_program, NV_fragment_program, "_mesa_GetIntegerv");
         params[0] = ctx->Const.MaxTextureCoordUnits;
         break;
      case GL_MAX_DRAW_BUFFERS_ARB:
         CHECK_EXT1(ARB_draw_buffers, "_mesa_GetIntegerv");
         params[0] = ctx->Const.MaxDrawBuffers;
         break;
      case GL_BLEND_COLOR_EXT:
         params[0] = FLOAT_TO_INT(ctx->Color.BlendColor[0]);
         params[1] = FLOAT_TO_INT(ctx->Color.BlendColor[1]);
         params[2] = FLOAT_TO_INT(ctx->Color.BlendColor[2]);
         params[3] = FLOAT_TO_INT(ctx->Color.BlendColor[3]);
         break;
      case GL_MAX_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT2(ARB_fragment_program, NV_fragment_program, "_mesa_GetIntegerv");
         params[0] = ctx->Const.MaxTextureImageUnits;
         break;
      case GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetIntegerv");
         params[0] = ctx->Const.MaxVertexTextureImageUnits;
         break;
      case GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetIntegerv");
         params[0] = MAX_COMBINED_TEXTURE_IMAGE_UNITS;
         break;
      case GL_CURRENT_PROGRAM:
         CHECK_EXT1(ARB_shader_objects, "_mesa_GetIntegerv");
         params[0] = ctx->Shader.CurrentProgram ? ctx->Shader.CurrentProgram->Name : 0;
         break;
      case GL_STENCIL_BACK_FUNC:
         params[0] = ENUM_TO_INT(ctx->Stencil.Function[1]);
         break;
      case GL_STENCIL_BACK_VALUE_MASK:
         params[0] = ctx->Stencil.ValueMask[1];
         break;
      case GL_STENCIL_BACK_WRITEMASK:
         params[0] = ctx->Stencil.WriteMask[1];
         break;
      case GL_STENCIL_BACK_REF:
         params[0] = ctx->Stencil.Ref[1];
         break;
      case GL_STENCIL_BACK_FAIL:
         params[0] = ENUM_TO_INT(ctx->Stencil.FailFunc[1]);
         break;
      case GL_STENCIL_BACK_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_INT(ctx->Stencil.ZFailFunc[1]);
         break;
      case GL_STENCIL_BACK_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_INT(ctx->Stencil.ZPassFunc[1]);
         break;
      case GL_MAX_VERTEX_ATTRIBS_ARB:
         CHECK_EXT1(ARB_vertex_program, "_mesa_GetIntegerv");
         params[0] = ctx->Const.VertexProgram.MaxAttribs;
         break;
      case GL_TEXTURE_BINDING_3D:
         params[0] = ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_3D_INDEX]->Name;
         break;
      case GL_MAX_3D_TEXTURE_SIZE:
         params[0] = 1 << (ctx->Const.Max3DTextureLevels - 1);
         break;
      case GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB:
         CHECK_EXT1(ARB_fragment_shader, "_mesa_GetIntegerv");
         params[0] = ENUM_TO_INT(ctx->Hint.FragmentShaderDerivative);
         break;
      case GL_MAX_FRAGMENT_UNIFORM_VECTORS:
         params[0] = ctx->Const.FragmentProgram.MaxUniformComponents / 4;
         break;
      case GL_MAX_VARYING_VECTORS:
         params[0] = ctx->Const.MaxVarying;
         break;
      case GL_MAX_VERTEX_UNIFORM_VECTORS:
         params[0] = ctx->Const.VertexProgram.MaxUniformComponents / 4;
         break;
      case GL_SHADER_COMPILER:
         params[0] = 1;
         break;
      case GL_NUM_SHADER_BINARY_FORMATS:
         params[0] = 0;
         break;
      case GL_SHADER_BINARY_FORMATS:
         break;
      default:
         _mesa_error(ctx, GL_INVALID_ENUM, "gl_mesa_GetIntegerv(pname=0x%x)", pname);
   }
}

