/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_SET_CONFIG_REG},
	{631, PKT3_SET_CONTEXT_REG},
	{647, PKT3_SET_SH_REG},
	{658, PKT3_SET_SH_REG_OFFSET},
	{676, PKT3_SET_UCONFIG_REG},
	{692, PKT3_SET_UCONFIG_REG_INDEX},
	{714, PKT3_LOAD_CONST_RAM},
	{729, PKT3_WRITE_CONST_RAM},
	{745, PKT3_DUMP_CONST_RAM},
	{760, PKT3_INCREMENT_CE_COUNTER},
	{781, PKT3_INCREMENT_DE_COUNTER},
	{802, PKT3_WAIT_ON_CE_COUNTER},
	{821, PKT3_LOAD_CONTEXT_REG},
	{838, PKT3_IT_OPCODE_C},
	{850, PKT3_CP_DMA},
	{857, PKT3_DMA_DATA},
};

static const struct si_reg sid_reg_table[] = {
	{866, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{881, R_371_DST_ADDR_LO},
	{893, R_372_DST_ADDR_HI},
	{905, R_3F0_IB_BASE_LO},
	{916, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{927, R_410_CP_DMA_WORD0, 1, 9},
	{940, R_411_CP_DMA_WORD1, 5, 10},
	{953, R_412_CP_DMA_WORD2, 1, 15},
	{966, R_413_CP_DMA_WORD3, 1, 16},
	{979, R_414_COMMAND, 11, 17},
	{987, R_500_DMA_DATA_WORD0, 6, 28},
	{1002, R_501_SRC_ADDR_LO},
	{1014, R_502_SRC_ADDR_HI},
	{881, R_503_DST_ADDR_LO},
	{893, R_504_DST_ADDR_HI},
	{1026, R_000E4C_SRBM_STATUS2, 21, 34},
	{1039, R_000E50_SRBM_STATUS, 20, 55},
	{1051, R_000E54_SRBM_STATUS3, 16, 75},
	{1064, R_00D034_SDMA0_STATUS_REG, 29, 91},
	{1081, R_00D834_SDMA1_STATUS_REG, 29, 91},
	{1098, R_008008_GRBM_STATUS2, 18, 120},
	{1111, R_008010_GRBM_STATUS, 24, 138},
	{1123, R_00802C_GRBM_GFX_INDEX, 6, 162},
	{1138, R_0084FC_CP_STRMOUT_CNTL, 1, 168},
	{1154, R_0085F0_CP_COHER_CNTL, 19, 169},
	{1168, R_0085F4_CP_COHER_SIZE},
	{1182, R_0085F8_CP_COHER_BASE},
	{1196, R_008014_GRBM_STATUS_SE0, 11, 188},
	{1212, R_008018_GRBM_STATUS_SE1, 11, 199},
	{1228, R_008038_GRBM_STATUS_SE2, 11, 210},
	{1244, R_00803C_GRBM_STATUS_SE3, 11, 221},
	{1138, R_0300FC_CP_STRMOUT_CNTL, 1, 232},
	{1260, R_0301E4_CP_COHER_BASE_HI, 1, 233},
	{1277, R_0301EC_CP_COHER_START_DELAY, 1, 234},
	{1154, R_0301F0_CP_COHER_CNTL, 27, 235},
	{1168, R_0301F4_CP_COHER_SIZE},
	{1182, R_0301F8_CP_COHER_BASE},
	{1298, R_0301FC_CP_COHER_STATUS, 4, 262},
	{1314, R_008210_CP_CPC_STATUS, 15, 266},
	{1328, R_008214_CP_CPC_BUSY_STAT, 28, 281},
	{1345, R_008218_CP_CPC_STALLED_STAT1, 14, 309},
	{1366, R_00821C_CP_CPF_STATUS, 21, 323},
	{1380, R_008220_CP_CPF_BUSY_STAT, 31, 344},
	{1397, R_008224_CP_CPF_STALLED_STAT1, 9, 375},
	{1418, R_030230_CP_COHER_SIZE_HI, 1, 384},
	{1435, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 385},
	{1458, R_0088C4_VGT_CACHE_INVALIDATION, 3, 386},
	{1481, R_0088C8_VGT_ESGS_RING_SIZE},
	{1500, R_0088CC_VGT_GSVS_RING_SIZE},
	{1519, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 389},
	{1539, R_008958_VGT_PRIMITIVE_TYPE, 1, 390},
	{1558, R_00895C_VGT_INDEX_TYPE, 1, 391},
	{1573, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1606, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1639, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1672, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1705, R_008970_VGT_NUM_INDICES},
	{1721, R_008974_VGT_NUM_INSTANCES},
	{1739, R_008988_VGT_TF_RING_SIZE, 1, 392},
	{1756, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 393},
	{1777, R_0089B8_VGT_TF_MEMORY_BASE},
	{1796, R_008A14_PA_CL_ENHANCE, 4, 394},
	{1810, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 398},
	{1835, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 399},
	{1860, R_008670_CP_STALLED_STAT3, 19, 401},
	{1877, R_008674_CP_STALLED_STAT1, 16, 420},
	{1894, R_008678_CP_STALLED_STAT2, 29, 436},
	{1911, R_008680_CP_STAT, 23, 465},
	{1123, R_030800_GRBM_GFX_INDEX, 6, 488},
	{1481, R_030900_VGT_ESGS_RING_SIZE},
	{1500, R_030904_VGT_GSVS_RING_SIZE},
	{1539, R_030908_VGT_PRIMITIVE_TYPE, 1, 494},
	{1558, R_03090C_VGT_INDEX_TYPE, 1, 495},
	{1573, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1606, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1639, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1672, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1705, R_030930_VGT_NUM_INDICES},
	{1721, R_030934_VGT_NUM_INSTANCES},
	{1739, R_030938_VGT_TF_RING_SIZE, 1, 496},
	{1756, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 497},
	{1777, R_030940_VGT_TF_MEMORY_BASE},
	{1810, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 499},
	{1835, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 500},
	{1919, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 502},
	{1945, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 504},
	{1971, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 506},
	{1997, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 508},
	{2023, R_008BF0_PA_SC_ENHANCE, 9, 510},
	{2037, R_008C08_SQC_CACHES, 2, 519},
	{2037, R_030D20_SQC_CACHES, 3, 521},
	{2048, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 524},
	{2067, R_008DFC_SQ_EXP_0, 6, 527},
	{2076, R_030E00_TA_CS_BC_BASE_ADDR},
	{2095, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 533},
	{2117, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{2141, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 534},
	{2164, R_008F00_SQ_BUF_RSRC_WORD0},
	{2182, R_008F04_SQ_BUF_RSRC_WORD1, 4, 535},
	{2200, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{2224, R_008F08_SQ_BUF_RSRC_WORD2},
	{2242, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 539},
	{2265, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 540},
	{2283, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{2307, R_008F10_SQ_IMG_RSRC_WORD0},
	{2325, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 554},
	{2348, R_008F14_SQ_IMG_RSRC_WORD1, 5, 555},
	{2366, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{2390, R_008F18_SQ_IMG_RSRC_WORD2, 4, 560},
	{2408, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 564},
	{2431, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 565},
	{2449, R_008F20_SQ_IMG_RSRC_WORD4, 2, 576},
	{2467, R_008F24_SQ_IMG_RSRC_WORD5, 2, 578},
	{2485, R_008F28_SQ_IMG_RSRC_WORD6, 8, 580},
	{2503, R_008F2C_SQ_IMG_RSRC_WORD7},
	{2521, R_008F30_SQ_IMG_SAMP_WORD0, 14, 588},
	{2539, R_008F34_SQ_IMG_SAMP_WORD1, 4, 602},
	{2557, R_008F38_SQ_IMG_SAMP_WORD2, 10, 606},
	{2575, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 616},
	{2593, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 619},
	{2613, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 624},
	{2638, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 626},
	{2663, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 628},
	{2688, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 629},
	{2688, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 630},
	{2707, R_0090F0_SPI_ARB_PRIORITY, 3, 631},
	{2707, R_00C700_SPI_ARB_PRIORITY, 8, 634},
	{2724, R_0090F4_SPI_ARB_CYCLES_0, 2, 642},
	{2741, R_0090F8_SPI_ARB_CYCLES_1, 1, 644},
	{2758, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 645},
	{2780, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 646},
	{2802, R_030FF8_DB_ZPASS_COUNT_LOW},
	{2821, R_030FFC_DB_ZPASS_COUNT_HI, 1, 647},
	{2839, R_009100_SPI_CONFIG_CNTL, 5, 648},
	{2855, R_00913C_SPI_CONFIG_CNTL_1, 5, 653},
	{2873, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 658},
	{2076, R_00950C_TA_CS_BC_BASE_ADDR},
	{2902, R_009858_DB_SUBTILE_CONTROL, 10, 670},
	{2921, R_0098F8_GB_ADDR_CONFIG, 9, 680},
	{2936, R_009910_GB_TILE_MODE0, 10, 689},
	{2950, R_009914_GB_TILE_MODE1, 10, 689},
	{2964, R_009918_GB_TILE_MODE2, 10, 689},
	{2978, R_00991C_GB_TILE_MODE3, 10, 689},
	{2992, R_009920_GB_TILE_MODE4, 10, 689},
	{3006, R_009924_GB_TILE_MODE5, 10, 689},
	{3020, R_009928_GB_TILE_MODE6, 10, 689},
	{3034, R_00992C_GB_TILE_MODE7, 10, 689},
	{3048, R_009930_GB_TILE_MODE8, 10, 689},
	{3062, R_009934_GB_TILE_MODE9, 10, 689},
	{3076, R_009938_GB_TILE_MODE10, 10, 689},
	{3091, R_00993C_GB_TILE_MODE11, 10, 689},
	{3106, R_009940_GB_TILE_MODE12, 10, 689},
	{3121, R_009944_GB_TILE_MODE13, 10, 689},
	{3136, R_009948_GB_TILE_MODE14, 10, 689},
	{3151, R_00994C_GB_TILE_MODE15, 10, 689},
	{3166, R_009950_GB_TILE_MODE16, 10, 689},
	{3181, R_009954_GB_TILE_MODE17, 10, 689},
	{3196, R_009958_GB_TILE_MODE18, 10, 689},
	{3211, R_00995C_GB_TILE_MODE19, 10, 689},
	{3226, R_009960_GB_TILE_MODE20, 10, 689},
	{3241, R_009964_GB_TILE_MODE21, 10, 689},
	{3256, R_009968_GB_TILE_MODE22, 10, 689},
	{3271, R_00996C_GB_TILE_MODE23, 10, 689},
	{3286, R_009970_GB_TILE_MODE24, 10, 689},
	{3301, R_009974_GB_TILE_MODE25, 10, 689},
	{3316, R_009978_GB_TILE_MODE26, 10, 689},
	{3331, R_00997C_GB_TILE_MODE27, 10, 689},
	{3346, R_009980_GB_TILE_MODE28, 10, 689},
	{3361, R_009984_GB_TILE_MODE29, 10, 689},
	{3376, R_009988_GB_TILE_MODE30, 10, 689},
	{3391, R_00998C_GB_TILE_MODE31, 10, 689},
	{3406, R_009990_GB_MACROTILE_MODE0, 4, 699},
	{3425, R_009994_GB_MACROTILE_MODE1, 4, 699},
	{3444, R_009998_GB_MACROTILE_MODE2, 4, 699},
	{3463, R_00999C_GB_MACROTILE_MODE3, 4, 699},
	{3482, R_0099A0_GB_MACROTILE_MODE4, 4, 699},
	{3501, R_0099A4_GB_MACROTILE_MODE5, 4, 699},
	{3520, R_0099A8_GB_MACROTILE_MODE6, 4, 699},
	{3539, R_0099AC_GB_MACROTILE_MODE7, 4, 699},
	{3558, R_0099B0_GB_MACROTILE_MODE8, 4, 699},
	{3577, R_0099B4_GB_MACROTILE_MODE9, 4, 699},
	{3596, R_0099B8_GB_MACROTILE_MODE10, 4, 699},
	{3616, R_0099BC_GB_MACROTILE_MODE11, 4, 699},
	{3636, R_0099C0_GB_MACROTILE_MODE12, 4, 699},
	{3656, R_0099C4_GB_MACROTILE_MODE13, 4, 699},
	{3676, R_0099C8_GB_MACROTILE_MODE14, 4, 699},
	{3696, R_0099CC_GB_MACROTILE_MODE15, 4, 699},
	{3716, R_00B000_SPI_SHADER_TBA_LO_PS},
	{3737, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 703},
	{3758, R_00B008_SPI_SHADER_TMA_LO_PS},
	{3779, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 704},
	{3800, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 705},
	{3824, R_00B020_SPI_SHADER_PGM_LO_PS},
	{3845, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 708},
	{3866, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 709},
	{3890, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 720},
	{3914, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{3940, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{3966, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{3992, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{4018, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{4044, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{4070, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{4096, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{4122, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{4148, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{4174, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{4201, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{4228, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{4255, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{4282, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{4309, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{4336, R_00B100_SPI_SHADER_TBA_LO_VS},
	{4357, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 727},
	{4378, R_00B108_SPI_SHADER_TMA_LO_VS},
	{4399, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 728},
	{4420, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 729},
	{4444, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 732},
	{4469, R_00B120_SPI_SHADER_PGM_LO_VS},
	{4490, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 733},
	{4511, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 734},
	{4535, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 746},
	{4559, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{4585, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{4611, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{4637, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{4663, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{4689, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{4715, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{4741, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{4767, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{4793, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{4819, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{4846, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{4873, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{4900, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{4927, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{4954, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{4981, R_00B200_SPI_SHADER_TBA_LO_GS},
	{5002, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 758},
	{5023, R_00B208_SPI_SHADER_TMA_LO_GS},
	{5044, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 759},
	{5065, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 760},
	{5089, R_00B220_SPI_SHADER_PGM_LO_GS},
	{5110, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 764},
	{5131, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 765},
	{5155, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 776},
	{5179, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{5205, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{5231, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{5257, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{5283, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{5309, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{5335, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{5361, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{5387, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{5413, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{5439, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{5466, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{5493, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{5520, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{5547, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{5574, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{5601, R_00B300_SPI_SHADER_TBA_LO_ES},
	{5622, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 781},
	{5643, R_00B308_SPI_SHADER_TMA_LO_ES},
	{5664, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 782},
	{5685, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 783},
	{5709, R_00B320_SPI_SHADER_PGM_LO_ES},
	{5730, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 787},
	{5751, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 788},
	{5775, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 800},
	{5799, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{5825, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{5851, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{5877, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{5903, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{5929, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{5955, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{5981, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{6007, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{6033, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{6059, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{6086, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{6113, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{6140, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{6167, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{6194, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{6221, R_00B400_SPI_SHADER_TBA_LO_HS},
	{6242, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 807},
	{6263, R_00B408_SPI_SHADER_TMA_LO_HS},
	{6284, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 808},
	{6305, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 809},
	{6329, R_00B420_SPI_SHADER_PGM_LO_HS},
	{6350, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 812},
	{6371, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 813},
	{6395, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 823},
	{6419, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{6445, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{6471, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{6497, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{6523, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{6549, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{6575, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{6601, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{6627, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{6653, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{6679, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{6706, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{6733, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{6760, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{6787, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{6814, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{6841, R_00B500_SPI_SHADER_TBA_LO_LS},
	{6862, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 830},
	{6883, R_00B508_SPI_SHADER_TMA_LO_LS},
	{6904, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 831},
	{6925, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 832},
	{6949, R_00B520_SPI_SHADER_PGM_LO_LS},
	{6970, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 836},
	{6991, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 837},
	{7015, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 848},
	{7039, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{7065, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{7091, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{7117, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{7143, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{7169, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{7195, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{7221, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{7247, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{7273, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{7299, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{7326, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{7353, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{7380, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{7407, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{7434, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{7461, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 854},
	{7488, R_00B804_COMPUTE_DIM_X},
	{7502, R_00B808_COMPUTE_DIM_Y},
	{7516, R_00B80C_COMPUTE_DIM_Z},
	{7530, R_00B810_COMPUTE_START_X},
	{7546, R_00B814_COMPUTE_START_Y},
	{7562, R_00B818_COMPUTE_START_Z},
	{7578, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 866},
	{7599, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 868},
	{7620, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 870},
	{7641, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 872},
	{7661, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 873},
	{7689, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 874},
	{7714, R_00B830_COMPUTE_PGM_LO},
	{7729, R_00B834_COMPUTE_PGM_HI, 2, 875},
	{7744, R_00B838_COMPUTE_TBA_LO},
	{7759, R_00B83C_COMPUTE_TBA_HI, 1, 877},
	{7774, R_00B840_COMPUTE_TMA_LO},
	{7789, R_00B844_COMPUTE_TMA_HI, 1, 878},
	{7804, R_00B848_COMPUTE_PGM_RSRC1, 10, 879},
	{7822, R_00B84C_COMPUTE_PGM_RSRC2, 11, 889},
	{7840, R_00B850_COMPUTE_VMID, 1, 900},
	{7853, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 901},
	{7877, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 908},
	{7908, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 910},
	{7939, R_00B860_COMPUTE_TMPRING_SIZE, 2, 912},
	{7960, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 914},
	{7991, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 916},
	{8022, R_00B86C_COMPUTE_RESTART_X},
	{8040, R_00B870_COMPUTE_RESTART_Y},
	{8058, R_00B874_COMPUTE_RESTART_Z},
	{8076, R_00B87C_COMPUTE_MISC_RESERVED, 5, 918},
	{8098, R_00B880_COMPUTE_DISPATCH_ID},
	{8118, R_00B884_COMPUTE_THREADGROUP_ID},
	{8141, R_00B888_COMPUTE_RELAUNCH, 3, 923},
	{8158, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{8187, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 926},
	{8216, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 927},
	{8245, R_00B900_COMPUTE_USER_DATA_0},
	{8265, R_00B904_COMPUTE_USER_DATA_1},
	{8285, R_00B908_COMPUTE_USER_DATA_2},
	{8305, R_00B90C_COMPUTE_USER_DATA_3},
	{8325, R_00B910_COMPUTE_USER_DATA_4},
	{8345, R_00B914_COMPUTE_USER_DATA_5},
	{8365, R_00B918_COMPUTE_USER_DATA_6},
	{8385, R_00B91C_COMPUTE_USER_DATA_7},
	{8405, R_00B920_COMPUTE_USER_DATA_8},
	{8425, R_00B924_COMPUTE_USER_DATA_9},
	{8445, R_00B928_COMPUTE_USER_DATA_10},
	{8466, R_00B92C_COMPUTE_USER_DATA_11},
	{8487, R_00B930_COMPUTE_USER_DATA_12},
	{8508, R_00B934_COMPUTE_USER_DATA_13},
	{8529, R_00B938_COMPUTE_USER_DATA_14},
	{8550, R_00B93C_COMPUTE_USER_DATA_15},
	{8571, R_00B9FC_COMPUTE_NOWHERE},
	{8587, R_034000_CPG_PERFCOUNTER1_LO},
	{8607, R_034004_CPG_PERFCOUNTER1_HI},
	{8627, R_034008_CPG_PERFCOUNTER0_LO},
	{8647, R_03400C_CPG_PERFCOUNTER0_HI},
	{8667, R_034010_CPC_PERFCOUNTER1_LO},
	{8687, R_034014_CPC_PERFCOUNTER1_HI},
	{8707, R_034018_CPC_PERFCOUNTER0_LO},
	{8727, R_03401C_CPC_PERFCOUNTER0_HI},
	{8747, R_034020_CPF_PERFCOUNTER1_LO},
	{8767, R_034024_CPF_PERFCOUNTER1_HI},
	{8787, R_034028_CPF_PERFCOUNTER0_LO},
	{8807, R_03402C_CPF_PERFCOUNTER0_HI},
	{8827, R_034100_GRBM_PERFCOUNTER0_LO},
	{8848, R_034104_GRBM_PERFCOUNTER0_HI},
	{8869, R_03410C_GRBM_PERFCOUNTER1_LO},
	{8890, R_034110_GRBM_PERFCOUNTER1_HI},
	{8911, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{8935, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{8959, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{8983, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{9007, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{9031, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{9055, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{9079, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{9103, R_034200_WD_PERFCOUNTER0_LO},
	{9122, R_034204_WD_PERFCOUNTER0_HI},
	{9141, R_034208_WD_PERFCOUNTER1_LO},
	{9160, R_03420C_WD_PERFCOUNTER1_HI},
	{9179, R_034210_WD_PERFCOUNTER2_LO},
	{9198, R_034214_WD_PERFCOUNTER2_HI},
	{9217, R_034218_WD_PERFCOUNTER3_LO},
	{9236, R_03421C_WD_PERFCOUNTER3_HI},
	{9255, R_034220_IA_PERFCOUNTER0_LO},
	{9274, R_034224_IA_PERFCOUNTER0_HI},
	{9293, R_034228_IA_PERFCOUNTER1_LO},
	{9312, R_03422C_IA_PERFCOUNTER1_HI},
	{9331, R_034230_IA_PERFCOUNTER2_LO},
	{9350, R_034234_IA_PERFCOUNTER2_HI},
	{9369, R_034238_IA_PERFCOUNTER3_LO},
	{9388, R_03423C_IA_PERFCOUNTER3_HI},
	{9407, R_034240_VGT_PERFCOUNTER0_LO},
	{9427, R_034244_VGT_PERFCOUNTER0_HI},
	{9447, R_034248_VGT_PERFCOUNTER1_LO},
	{9467, R_03424C_VGT_PERFCOUNTER1_HI},
	{9487, R_034250_VGT_PERFCOUNTER2_LO},
	{9507, R_034254_VGT_PERFCOUNTER2_HI},
	{9527, R_034258_VGT_PERFCOUNTER3_LO},
	{9547, R_03425C_VGT_PERFCOUNTER3_HI},
	{9567, R_034400_PA_SU_PERFCOUNTER0_LO},
	{9589, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 929},
	{9611, R_034408_PA_SU_PERFCOUNTER1_LO},
	{9633, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 929},
	{9655, R_034410_PA_SU_PERFCOUNTER2_LO},
	{9677, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 929},
	{9699, R_034418_PA_SU_PERFCOUNTER3_LO},
	{9721, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 929},
	{9743, R_034500_PA_SC_PERFCOUNTER0_LO},
	{9765, R_034504_PA_SC_PERFCOUNTER0_HI},
	{9787, R_034508_PA_SC_PERFCOUNTER1_LO},
	{9809, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{9831, R_034510_PA_SC_PERFCOUNTER2_LO},
	{9853, R_034514_PA_SC_PERFCOUNTER2_HI},
	{9875, R_034518_PA_SC_PERFCOUNTER3_LO},
	{9897, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{9919, R_034520_PA_SC_PERFCOUNTER4_LO},
	{9941, R_034524_PA_SC_PERFCOUNTER4_HI},
	{9963, R_034528_PA_SC_PERFCOUNTER5_LO},
	{9985, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{10007, R_034530_PA_SC_PERFCOUNTER6_LO},
	{10029, R_034534_PA_SC_PERFCOUNTER6_HI},
	{10051, R_034538_PA_SC_PERFCOUNTER7_LO},
	{10073, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{10095, R_034600_SPI_PERFCOUNTER0_HI},
	{10115, R_034604_SPI_PERFCOUNTER0_LO},
	{10135, R_034608_SPI_PERFCOUNTER1_HI},
	{10155, R_03460C_SPI_PERFCOUNTER1_LO},
	{10175, R_034610_SPI_PERFCOUNTER2_HI},
	{10195, R_034614_SPI_PERFCOUNTER2_LO},
	{10215, R_034618_SPI_PERFCOUNTER3_HI},
	{10235, R_03461C_SPI_PERFCOUNTER3_LO},
	{10255, R_034620_SPI_PERFCOUNTER4_HI},
	{10275, R_034624_SPI_PERFCOUNTER4_LO},
	{10295, R_034628_SPI_PERFCOUNTER5_HI},
	{10315, R_03462C_SPI_PERFCOUNTER5_LO},
	{10335, R_034700_SQ_PERFCOUNTER0_LO},
	{10354, R_034704_SQ_PERFCOUNTER0_HI},
	{10373, R_034708_SQ_PERFCOUNTER1_LO},
	{10392, R_03470C_SQ_PERFCOUNTER1_HI},
	{10411, R_034710_SQ_PERFCOUNTER2_LO},
	{10430, R_034714_SQ_PERFCOUNTER2_HI},
	{10449, R_034718_SQ_PERFCOUNTER3_LO},
	{10468, R_03471C_SQ_PERFCOUNTER3_HI},
	{10487, R_034720_SQ_PERFCOUNTER4_LO},
	{10506, R_034724_SQ_PERFCOUNTER4_HI},
	{10525, R_034728_SQ_PERFCOUNTER5_LO},
	{10544, R_03472C_SQ_PERFCOUNTER5_HI},
	{10563, R_034730_SQ_PERFCOUNTER6_LO},
	{10582, R_034734_SQ_PERFCOUNTER6_HI},
	{10601, R_034738_SQ_PERFCOUNTER7_LO},
	{10620, R_03473C_SQ_PERFCOUNTER7_HI},
	{10639, R_034740_SQ_PERFCOUNTER8_LO},
	{10658, R_034744_SQ_PERFCOUNTER8_HI},
	{10677, R_034748_SQ_PERFCOUNTER9_LO},
	{10696, R_03474C_SQ_PERFCOUNTER9_HI},
	{10715, R_034750_SQ_PERFCOUNTER10_LO},
	{10735, R_034754_SQ_PERFCOUNTER10_HI},
	{10755, R_034758_SQ_PERFCOUNTER11_LO},
	{10775, R_03475C_SQ_PERFCOUNTER11_HI},
	{10795, R_034760_SQ_PERFCOUNTER12_LO},
	{10815, R_034764_SQ_PERFCOUNTER12_HI},
	{10835, R_034768_SQ_PERFCOUNTER13_LO},
	{10855, R_03476C_SQ_PERFCOUNTER13_HI},
	{10875, R_034770_SQ_PERFCOUNTER14_LO},
	{10895, R_034774_SQ_PERFCOUNTER14_HI},
	{10915, R_034778_SQ_PERFCOUNTER15_LO},
	{10935, R_03477C_SQ_PERFCOUNTER15_HI},
	{10955, R_034900_SX_PERFCOUNTER0_LO},
	{10974, R_034904_SX_PERFCOUNTER0_HI},
	{10993, R_034908_SX_PERFCOUNTER1_LO},
	{11012, R_03490C_SX_PERFCOUNTER1_HI},
	{11031, R_034910_SX_PERFCOUNTER2_LO},
	{11050, R_034914_SX_PERFCOUNTER2_HI},
	{11069, R_034918_SX_PERFCOUNTER3_LO},
	{11088, R_03491C_SX_PERFCOUNTER3_HI},
	{11107, R_034A00_GDS_PERFCOUNTER0_LO},
	{11127, R_034A04_GDS_PERFCOUNTER0_HI},
	{11147, R_034A08_GDS_PERFCOUNTER1_LO},
	{11167, R_034A0C_GDS_PERFCOUNTER1_HI},
	{11187, R_034A10_GDS_PERFCOUNTER2_LO},
	{11207, R_034A14_GDS_PERFCOUNTER2_HI},
	{11227, R_034A18_GDS_PERFCOUNTER3_LO},
	{11247, R_034A1C_GDS_PERFCOUNTER3_HI},
	{11267, R_034B00_TA_PERFCOUNTER0_LO},
	{11286, R_034B04_TA_PERFCOUNTER0_HI},
	{11305, R_034B08_TA_PERFCOUNTER1_LO},
	{11324, R_034B0C_TA_PERFCOUNTER1_HI},
	{11343, R_034C00_TD_PERFCOUNTER0_LO},
	{11362, R_034C04_TD_PERFCOUNTER0_HI},
	{11381, R_034C08_TD_PERFCOUNTER1_LO},
	{11400, R_034C0C_TD_PERFCOUNTER1_HI},
	{11419, R_034D00_TCP_PERFCOUNTER0_LO},
	{11439, R_034D04_TCP_PERFCOUNTER0_HI},
	{11459, R_034D08_TCP_PERFCOUNTER1_LO},
	{11479, R_034D0C_TCP_PERFCOUNTER1_HI},
	{11499, R_034D10_TCP_PERFCOUNTER2_LO},
	{11519, R_034D14_TCP_PERFCOUNTER2_HI},
	{11539, R_034D18_TCP_PERFCOUNTER3_LO},
	{11559, R_034D1C_TCP_PERFCOUNTER3_HI},
	{11579, R_034E00_TCC_PERFCOUNTER0_LO},
	{11599, R_034E04_TCC_PERFCOUNTER0_HI},
	{11619, R_034E08_TCC_PERFCOUNTER1_LO},
	{11639, R_034E0C_TCC_PERFCOUNTER1_HI},
	{11659, R_034E10_TCC_PERFCOUNTER2_LO},
	{11679, R_034E14_TCC_PERFCOUNTER2_HI},
	{11699, R_034E18_TCC_PERFCOUNTER3_LO},
	{11719, R_034E1C_TCC_PERFCOUNTER3_HI},
	{11739, R_034E40_TCA_PERFCOUNTER0_LO},
	{11759, R_034E44_TCA_PERFCOUNTER0_HI},
	{11779, R_034E48_TCA_PERFCOUNTER1_LO},
	{11799, R_034E4C_TCA_PERFCOUNTER1_HI},
	{11819, R_034E50_TCA_PERFCOUNTER2_LO},
	{11839, R_034E54_TCA_PERFCOUNTER2_HI},
	{11859, R_034E58_TCA_PERFCOUNTER3_LO},
	{11879, R_034E5C_TCA_PERFCOUNTER3_HI},
	{11899, R_035018_CB_PERFCOUNTER0_LO},
	{11918, R_03501C_CB_PERFCOUNTER0_HI},
	{11937, R_035020_CB_PERFCOUNTER1_LO},
	{11956, R_035024_CB_PERFCOUNTER1_HI},
	{11975, R_035028_CB_PERFCOUNTER2_LO},
	{11994, R_03502C_CB_PERFCOUNTER2_HI},
	{12013, R_035030_CB_PERFCOUNTER3_LO},
	{12032, R_035034_CB_PERFCOUNTER3_HI},
	{12051, R_035100_DB_PERFCOUNTER0_LO},
	{12070, R_035104_DB_PERFCOUNTER0_HI},
	{12089, R_035108_DB_PERFCOUNTER1_LO},
	{12108, R_03510C_DB_PERFCOUNTER1_HI},
	{12127, R_035110_DB_PERFCOUNTER2_LO},
	{12146, R_035114_DB_PERFCOUNTER2_HI},
	{12165, R_035118_DB_PERFCOUNTER3_LO},
	{12184, R_03511C_DB_PERFCOUNTER3_HI},
	{12203, R_035200_RLC_PERFCOUNTER0_LO},
	{12223, R_035204_RLC_PERFCOUNTER0_HI},
	{12243, R_035208_RLC_PERFCOUNTER1_LO},
	{12263, R_03520C_RLC_PERFCOUNTER1_HI},
	{12283, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 930},
	{12307, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 933},
	{12332, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 930},
	{12356, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 935},
	{12380, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 938},
	{12405, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 940},
	{12429, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 943},
	{12454, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 940},
	{12478, R_036020_CP_PERFMON_CNTL, 4, 945},
	{12494, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 935},
	{12518, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 949},
	{12543, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 949},
	{12568, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 968},
	{12596, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 980},
	{12624, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 992},
	{12652, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 1004},
	{12680, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1016},
	{12703, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1016},
	{12726, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1016},
	{12749, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1016},
	{12772, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1018},
	{12795, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1018},
	{12818, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1018},
	{12841, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1018},
	{12864, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1023},
	{12888, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1027},
	{12912, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1027},
	{12936, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1027},
	{12960, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1027},
	{12984, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1032},
	{13009, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{13034, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1036},
	{13060, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1037},
	{13086, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1040},
	{13113, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1037},
	{13139, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{13166, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1037},
	{13192, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1037},
	{13218, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1042},
	{13244, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1045},
	{13271, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1042},
	{13297, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1042},
	{13323, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1042},
	{13349, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1042},
	{13375, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1042},
	{13401, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1042},
	{13427, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1042},
	{13453, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1047},
	{13477, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1047},
	{13501, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1047},
	{13525, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1047},
	{13549, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1050},
	{13574, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{13599, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{13624, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{13649, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1047},
	{13673, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1047},
	{13697, R_036628_SPI_PERFCOUNTER_BINS, 8, 1052},
	{13718, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1060},
	{13741, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1060},
	{13764, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1060},
	{13787, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1060},
	{13810, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1060},
	{13833, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1060},
	{13856, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1060},
	{13879, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1060},
	{13902, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1060},
	{13925, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1060},
	{13948, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1060},
	{13972, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1060},
	{13996, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1060},
	{14020, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1060},
	{14044, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1060},
	{14068, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1060},
	{14092, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1066},
	{14112, R_036784_SQ_PERFCOUNTER_MASK, 2, 1075},
	{14132, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1077},
	{14153, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1078},
	{14176, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1078},
	{14199, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1078},
	{14222, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1078},
	{14245, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1081},
	{14269, R_036914_SX_PERFCOUNTER1_SELECT1},
	{14293, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1083},
	{14317, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1083},
	{14341, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1083},
	{14365, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1083},
	{14389, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1086},
	{14414, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1088},
	{14437, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1093},
	{14461, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1088},
	{14484, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1097},
	{14507, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1102},
	{14531, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1097},
	{14554, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1106},
	{14578, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1111},
	{14603, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1106},
	{14627, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{14652, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1106},
	{14676, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1106},
	{14700, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1115},
	{14724, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1120},
	{14749, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1115},
	{14773, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{14798, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1115},
	{14822, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1115},
	{14846, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1124},
	{14870, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1129},
	{14895, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1124},
	{14919, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{14944, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1124},
	{14968, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1124},
	{14992, R_037000_CB_PERFCOUNTER_FILTER, 12, 1133},
	{15014, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1145},
	{15037, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1150},
	{15061, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1145},
	{15084, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1145},
	{15107, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1145},
	{15130, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1154},
	{15153, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1159},
	{15177, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1154},
	{15200, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{15224, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1154},
	{15247, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1154},
	{15270, R_028000_DB_RENDER_CONTROL, 10, 1163},
	{15288, R_028004_DB_COUNT_CONTROL, 9, 1173},
	{15305, R_028008_DB_DEPTH_VIEW, 4, 1182},
	{15319, R_02800C_DB_RENDER_OVERRIDE, 23, 1186},
	{15338, R_028010_DB_RENDER_OVERRIDE2, 15, 1209},
	{15358, R_028014_DB_HTILE_DATA_BASE},
	{15377, R_028020_DB_DEPTH_BOUNDS_MIN},
	{15397, R_028024_DB_DEPTH_BOUNDS_MAX},
	{15417, R_028028_DB_STENCIL_CLEAR, 1, 1224},
	{15434, R_02802C_DB_DEPTH_CLEAR},
	{15449, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1225},
	{15473, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1227},
	{15497, R_02803C_DB_DEPTH_INFO, 7, 1229},
	{15511, R_028040_DB_Z_INFO, 10, 1236},
	{15521, R_028044_DB_STENCIL_INFO, 6, 1246},
	{15537, R_028048_DB_Z_READ_BASE},
	{15552, R_02804C_DB_STENCIL_READ_BASE},
	{15573, R_028050_DB_Z_WRITE_BASE},
	{15589, R_028054_DB_STENCIL_WRITE_BASE},
	{15611, R_028058_DB_DEPTH_SIZE, 2, 1252},
	{15625, R_02805C_DB_DEPTH_SLICE, 1, 1254},
	{15640, R_028080_TA_BC_BASE_ADDR},
	{15656, R_028084_TA_BC_BASE_ADDR_HI, 1, 1255},
	{15675, R_0281E8_COHER_DEST_BASE_HI_0},
	{15696, R_0281EC_COHER_DEST_BASE_HI_1},
	{15717, R_0281F0_COHER_DEST_BASE_HI_2},
	{15738, R_0281F4_COHER_DEST_BASE_HI_3},
	{15759, R_0281F8_COHER_DEST_BASE_2},
	{15777, R_0281FC_COHER_DEST_BASE_3},
	{15795, R_028200_PA_SC_WINDOW_OFFSET, 2, 1256},
	{15815, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1258},
	{15839, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1261},
	{15863, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1263},
	{15883, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1264},
	{15903, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1266},
	{15923, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1264},
	{15943, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1266},
	{15963, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1264},
	{15983, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1266},
	{16003, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1264},
	{16023, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1266},
	{16043, R_028230_PA_SC_EDGERULE, 7, 1268},
	{16058, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1275},
	{16087, R_028238_CB_TARGET_MASK, 8, 1277},
	{16102, R_02823C_CB_SHADER_MASK, 8, 1285},
	{16117, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1293},
	{16142, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1296},
	{16167, R_028248_COHER_DEST_BASE_0},
	{16185, R_02824C_COHER_DEST_BASE_1},
	{16203, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1298},
	{16228, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1301},
	{16253, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1298},
	{16278, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1301},
	{16303, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1298},
	{16328, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1301},
	{16353, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1298},
	{16378, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1301},
	{16403, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1298},
	{16428, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1301},
	{16453, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1298},
	{16478, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1301},
	{16503, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1298},
	{16528, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1301},
	{16553, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1298},
	{16578, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1301},
	{16603, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1298},
	{16628, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1301},
	{16653, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1298},
	{16678, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1301},
	{16703, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1298},
	{16729, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1301},
	{16755, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1298},
	{16781, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1301},
	{16807, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1298},
	{16833, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1301},
	{16859, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1298},
	{16885, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1301},
	{16911, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1298},
	{16937, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1301},
	{16963, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1298},
	{16989, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1301},
	{17015, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{17034, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{17053, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{17072, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{17091, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{17110, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{17129, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{17148, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{17167, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{17186, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{17205, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{17224, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{17243, R_028300_PA_SC_VPORT_ZMIN_6},
	{17262, R_028304_PA_SC_VPORT_ZMAX_6},
	{17281, R_028308_PA_SC_VPORT_ZMIN_7},
	{17300, R_02830C_PA_SC_VPORT_ZMAX_7},
	{17319, R_028310_PA_SC_VPORT_ZMIN_8},
	{17338, R_028314_PA_SC_VPORT_ZMAX_8},
	{17357, R_028318_PA_SC_VPORT_ZMIN_9},
	{17376, R_02831C_PA_SC_VPORT_ZMAX_9},
	{17395, R_028320_PA_SC_VPORT_ZMIN_10},
	{17415, R_028324_PA_SC_VPORT_ZMAX_10},
	{17435, R_028328_PA_SC_VPORT_ZMIN_11},
	{17455, R_02832C_PA_SC_VPORT_ZMAX_11},
	{17475, R_028330_PA_SC_VPORT_ZMIN_12},
	{17495, R_028334_PA_SC_VPORT_ZMAX_12},
	{17515, R_028338_PA_SC_VPORT_ZMIN_13},
	{17535, R_02833C_PA_SC_VPORT_ZMAX_13},
	{17555, R_028340_PA_SC_VPORT_ZMIN_14},
	{17575, R_028344_PA_SC_VPORT_ZMAX_14},
	{17595, R_028348_PA_SC_VPORT_ZMIN_15},
	{17615, R_02834C_PA_SC_VPORT_ZMAX_15},
	{17635, R_028350_PA_SC_RASTER_CONFIG, 15, 1303},
	{17655, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1318},
	{17677, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1321},
	{17705, R_028400_VGT_MAX_VTX_INDX},
	{17722, R_028404_VGT_MIN_VTX_INDX},
	{17739, R_028408_VGT_INDX_OFFSET},
	{17755, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{17784, R_028414_CB_BLEND_RED},
	{17797, R_028418_CB_BLEND_GREEN},
	{17812, R_02841C_CB_BLEND_BLUE},
	{17826, R_028420_CB_BLEND_ALPHA},
	{17841, R_028424_CB_DCC_CONTROL, 3, 1323},
	{17856, R_02842C_DB_STENCIL_CONTROL, 6, 1326},
	{17875, R_028430_DB_STENCILREFMASK, 4, 1332},
	{17893, R_028434_DB_STENCILREFMASK_BF, 4, 1336},
	{17914, R_02843C_PA_CL_VPORT_XSCALE},
	{17933, R_028440_PA_CL_VPORT_XOFFSET},
	{17953, R_028444_PA_CL_VPORT_YSCALE},
	{17972, R_028448_PA_CL_VPORT_YOFFSET},
	{17992, R_02844C_PA_CL_VPORT_ZSCALE},
	{18011, R_028450_PA_CL_VPORT_ZOFFSET},
	{18031, R_028454_PA_CL_VPORT_XSCALE_1},
	{18052, R_028458_PA_CL_VPORT_XOFFSET_1},
	{18074, R_02845C_PA_CL_VPORT_YSCALE_1},
	{18095, R_028460_PA_CL_VPORT_YOFFSET_1},
	{18117, R_028464_PA_CL_VPORT_ZSCALE_1},
	{18138, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{18160, R_02846C_PA_CL_VPORT_XSCALE_2},
	{18181, R_028470_PA_CL_VPORT_XOFFSET_2},
	{18203, R_028474_PA_CL_VPORT_YSCALE_2},
	{18224, R_028478_PA_CL_VPORT_YOFFSET_2},
	{18246, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{18267, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{18289, R_028484_PA_CL_VPORT_XSCALE_3},
	{18310, R_028488_PA_CL_VPORT_XOFFSET_3},
	{18332, R_02848C_PA_CL_VPORT_YSCALE_3},
	{18353, R_028490_PA_CL_VPORT_YOFFSET_3},
	{18375, R_028494_PA_CL_VPORT_ZSCALE_3},
	{18396, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{18418, R_02849C_PA_CL_VPORT_XSCALE_4},
	{18439, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{18461, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{18482, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{18504, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{18525, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{18547, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{18568, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{18590, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{18611, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{18633, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{18654, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{18676, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{18697, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{18719, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{18740, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{18762, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{18783, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{18805, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{18826, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{18848, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{18869, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{18891, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{18912, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{18934, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{18955, R_028500_PA_CL_VPORT_XOFFSET_8},
	{18977, R_028504_PA_CL_VPORT_YSCALE_8},
	{18998, R_028508_PA_CL_VPORT_YOFFSET_8},
	{19020, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{19041, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{19063, R_028514_PA_CL_VPORT_XSCALE_9},
	{19084, R_028518_PA_CL_VPORT_XOFFSET_9},
	{19106, R_02851C_PA_CL_VPORT_YSCALE_9},
	{19127, R_028520_PA_CL_VPORT_YOFFSET_9},
	{19149, R_028524_PA_CL_VPORT_ZSCALE_9},
	{19170, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{19192, R_02852C_PA_CL_VPORT_XSCALE_10},
	{19214, R_028530_PA_CL_VPORT_XOFFSET_10},
	{19237, R_028534_PA_CL_VPORT_YSCALE_10},
	{19259, R_028538_PA_CL_VPORT_YOFFSET_10},
	{19282, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{19304, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{19327, R_028544_PA_CL_VPORT_XSCALE_11},
	{19349, R_028548_PA_CL_VPORT_XOFFSET_11},
	{19372, R_02854C_PA_CL_VPORT_YSCALE_11},
	{19394, R_028550_PA_CL_VPORT_YOFFSET_11},
	{19417, R_028554_PA_CL_VPORT_ZSCALE_11},
	{19439, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{19462, R_02855C_PA_CL_VPORT_XSCALE_12},
	{19484, R_028560_PA_CL_VPORT_XOFFSET_12},
	{19507, R_028564_PA_CL_VPORT_YSCALE_12},
	{19529, R_028568_PA_CL_VPORT_YOFFSET_12},
	{19552, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{19574, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{19597, R_028574_PA_CL_VPORT_XSCALE_13},
	{19619, R_028578_PA_CL_VPORT_XOFFSET_13},
	{19642, R_02857C_PA_CL_VPORT_YSCALE_13},
	{19664, R_028580_PA_CL_VPORT_YOFFSET_13},
	{19687, R_028584_PA_CL_VPORT_ZSCALE_13},
	{19709, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{19732, R_02858C_PA_CL_VPORT_XSCALE_14},
	{19754, R_028590_PA_CL_VPORT_XOFFSET_14},
	{19777, R_028594_PA_CL_VPORT_YSCALE_14},
	{19799, R_028598_PA_CL_VPORT_YOFFSET_14},
	{19822, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{19844, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{19867, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{19889, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{19912, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{19934, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{19957, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{19979, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{20002, R_0285BC_PA_CL_UCP_0_X},
	{20016, R_0285C0_PA_CL_UCP_0_Y},
	{20030, R_0285C4_PA_CL_UCP_0_Z},
	{20044, R_0285C8_PA_CL_UCP_0_W},
	{20058, R_0285CC_PA_CL_UCP_1_X},
	{20072, R_0285D0_PA_CL_UCP_1_Y},
	{20086, R_0285D4_PA_CL_UCP_1_Z},
	{20100, R_0285D8_PA_CL_UCP_1_W},
	{20114, R_0285DC_PA_CL_UCP_2_X},
	{20128, R_0285E0_PA_CL_UCP_2_Y},
	{20142, R_0285E4_PA_CL_UCP_2_Z},
	{20156, R_0285E8_PA_CL_UCP_2_W},
	{20170, R_0285EC_PA_CL_UCP_3_X},
	{20184, R_0285F0_PA_CL_UCP_3_Y},
	{20198, R_0285F4_PA_CL_UCP_3_Z},
	{20212, R_0285F8_PA_CL_UCP_3_W},
	{20226, R_0285FC_PA_CL_UCP_4_X},
	{20240, R_028600_PA_CL_UCP_4_Y},
	{20254, R_028604_PA_CL_UCP_4_Z},
	{20268, R_028608_PA_CL_UCP_4_W},
	{20282, R_02860C_PA_CL_UCP_5_X},
	{20296, R_028610_PA_CL_UCP_5_Y},
	{20310, R_028614_PA_CL_UCP_5_Z},
	{20324, R_028618_PA_CL_UCP_5_W},
	{20338, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1340},
	{20358, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1340},
	{20378, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1340},
	{20398, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1340},
	{20418, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1340},
	{20438, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1340},
	{20458, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1340},
	{20478, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1340},
	{20498, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1340},
	{20518, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1340},
	{20538, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1340},
	{20559, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1340},
	{20580, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1340},
	{20601, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1340},
	{20622, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1340},
	{20643, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1340},
	{20664, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1340},
	{20685, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1340},
	{20706, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1340},
	{20727, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1340},
	{20748, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1340},
	{20769, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1340},
	{20790, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1340},
	{20811, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1340},
	{20832, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1340},
	{20853, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1340},
	{20874, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1340},
	{20895, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1340},
	{20916, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1340},
	{20937, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1340},
	{20958, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1340},
	{20979, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1340},
	{21000, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1352},
	{21018, R_0286CC_SPI_PS_INPUT_ENA, 16, 1356},
	{21035, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1372},
	{21053, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1388},
	{21074, R_0286D8_SPI_PS_IN_CONTROL, 5, 1395},
	{21092, R_0286E0_SPI_BARYC_CNTL, 7, 1400},
	{21107, R_0286E8_SPI_TMPRING_SIZE, 2, 1407},
	{21124, R_028704_SPI_WAVE_MGMT_1, 5, 1409},
	{21140, R_028708_SPI_WAVE_MGMT_2, 1, 1414},
	{21156, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1415},
	{21178, R_028710_SPI_SHADER_Z_FORMAT, 1, 1419},
	{21198, R_028714_SPI_SHADER_COL_FORMAT, 8, 1420},
	{21220, R_028754_SX_PS_DOWNCONVERT, 8, 1428},
	{21238, R_028758_SX_BLEND_OPT_EPSILON, 8, 1436},
	{21259, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1444},
	{21280, R_028760_SX_MRT0_BLEND_OPT, 6, 1461},
	{21298, R_028764_SX_MRT1_BLEND_OPT, 6, 1467},
	{21316, R_028768_SX_MRT2_BLEND_OPT, 6, 1473},
	{21334, R_02876C_SX_MRT3_BLEND_OPT, 6, 1479},
	{21352, R_028770_SX_MRT4_BLEND_OPT, 6, 1485},
	{21370, R_028774_SX_MRT5_BLEND_OPT, 6, 1491},
	{21388, R_028778_SX_MRT6_BLEND_OPT, 6, 1497},
	{21406, R_02877C_SX_MRT7_BLEND_OPT, 6, 1503},
	{21424, R_028780_CB_BLEND0_CONTROL, 9, 1509},
	{21442, R_028784_CB_BLEND1_CONTROL, 9, 1509},
	{21460, R_028788_CB_BLEND2_CONTROL, 9, 1509},
	{21478, R_02878C_CB_BLEND3_CONTROL, 9, 1509},
	{21496, R_028790_CB_BLEND4_CONTROL, 9, 1509},
	{21514, R_028794_CB_BLEND5_CONTROL, 9, 1509},
	{21532, R_028798_CB_BLEND6_CONTROL, 9, 1509},
	{21550, R_02879C_CB_BLEND7_CONTROL, 9, 1509},
	{21568, R_0287CC_CS_COPY_STATE, 1, 1518},
	{21582, R_0287D4_PA_CL_POINT_X_RAD},
	{21600, R_0287D8_PA_CL_POINT_Y_RAD},
	{21618, R_0287DC_PA_CL_POINT_SIZE},
	{21635, R_0287E0_PA_CL_POINT_CULL_RAD},
	{21656, R_0287E4_VGT_DMA_BASE_HI, 1, 1519},
	{21672, R_0287E8_VGT_DMA_BASE},
	{21685, R_0287F0_VGT_DRAW_INITIATOR, 4, 1520},
	{21704, R_0287F4_VGT_IMMED_DATA},
	{21719, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1524},
	{21741, R_028800_DB_DEPTH_CONTROL, 10, 1525},
	{21758, R_028804_DB_EQAA, 12, 1535},
	{21766, R_028808_CB_COLOR_CONTROL, 4, 1547},
	{21783, R_02880C_DB_SHADER_CONTROL, 13, 1551},
	{21801, R_028810_PA_CL_CLIP_CNTL, 19, 1564},
	{21817, R_028814_PA_SU_SC_MODE_CNTL, 13, 1583},
	{21836, R_028818_PA_CL_VTE_CNTL, 9, 1596},
	{21851, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1605},
	{21869, R_028820_PA_CL_NANINF_CNTL, 16, 1632},
	{21887, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1648},
	{21911, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{21936, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1652},
	{21959, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1663},
	{21988, R_028A00_PA_SU_POINT_SIZE, 2, 1668},
	{22005, R_028A04_PA_SU_POINT_MINMAX, 2, 1670},
	{22024, R_028A08_PA_SU_LINE_CNTL, 1, 1672},
	{22040, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1673},
	{22059, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1677},
	{22080, R_028A14_VGT_HOS_CNTL, 1, 1678},
	{22093, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{22116, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{22139, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1679},
	{22159, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1680},
	{22179, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1684},
	{22200, R_028A2C_VGT_GROUP_DECR, 1, 1685},
	{22215, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1686},
	{22237, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1692},
	{22259, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1698},
	{22285, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1706},
	{22311, R_028A40_VGT_GS_MODE, 15, 1714},
	{22323, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1729},
	{22342, R_028A48_PA_SC_MODE_CNTL_0, 4, 1731},
	{22360, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1735},
	{22378, R_028A50_VGT_ENHANCE},
	{22390, R_028A54_VGT_GS_PER_ES, 1, 1759},
	{22404, R_028A58_VGT_ES_PER_GS, 1, 1760},
	{22418, R_028A5C_VGT_GS_PER_VS, 1, 1761},
	{22432, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1762},
	{22455, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1763},
	{22478, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1764},
	{22501, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1765},
	{22522, R_028A70_IA_ENHANCE},
	{22533, R_028A74_VGT_DMA_SIZE},
	{22546, R_028A78_VGT_DMA_MAX_SIZE},
	{22563, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1770},
	{22582, R_028A80_WD_ENHANCE},
	{22593, R_028A84_VGT_PRIMITIVEID_EN, 2, 1779},
	{22612, R_028A88_VGT_DMA_NUM_INSTANCES},
	{22634, R_028A8C_VGT_PRIMITIVEID_RESET},
	{22656, R_028A90_VGT_EVENT_INITIATOR, 3, 1781},
	{22676, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1784},
	{22703, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{22728, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{22753, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1785},
	{22772, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1792},
	{22795, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1793},
	{22818, R_028AB4_VGT_REUSE_OFF, 1, 1794},
	{22832, R_028AB8_VGT_VTX_CNT_EN, 1, 1795},
	{22847, R_028ABC_DB_HTILE_SURFACE, 8, 1796},
	{22864, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1804},
	{22891, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1808},
	{22918, R_028AC8_DB_PRELOAD_CONTROL, 4, 1812},
	{22937, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{22963, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1816},
	{22988, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{23016, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{23042, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1817},
	{23067, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{23095, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{23121, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1818},
	{23146, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{23174, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{23200, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1819},
	{23225, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{23253, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{23284, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{23327, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1820},
	{23365, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1821},
	{23385, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1822},
	{23407, R_028B54_VGT_SHADER_STAGES_EN, 10, 1827},
	{23428, R_028B58_VGT_LS_HS_CONFIG, 3, 1837},
	{23445, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1840},
	{23466, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1841},
	{23489, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1842},
	{23512, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1843},
	{23535, R_028B6C_VGT_TF_PARAM, 11, 1844},
	{23548, R_028B70_DB_ALPHA_TO_MASK, 6, 1855},
	{23565, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{23589, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1861},
	{23619, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{23643, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{23673, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{23704, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{23733, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{23763, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1863},
	{23783, R_028B94_VGT_STRMOUT_CONFIG, 7, 1865},
	{23802, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1872},
	{23828, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1876},
	{23854, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1884},
	{23880, R_028BDC_PA_SC_LINE_CNTL, 4, 1892},
	{23896, R_028BE0_PA_SC_AA_CONFIG, 5, 1896},
	{23912, R_028BE4_PA_SU_VTX_CNTL, 3, 1901},
	{23927, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{23950, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{23973, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{23996, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{24019, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1904},
	{24053, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1912},
	{24087, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1920},
	{24121, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1928},
	{24155, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1936},
	{24189, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1944},
	{24223, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1952},
	{24257, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1960},
	{24291, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1968},
	{24325, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1976},
	{24359, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1984},
	{24393, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1992},
	{24427, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 2000},
	{24461, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2008},
	{24495, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2016},
	{24529, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2024},
	{24563, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2032},
	{24587, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2034},
	{24611, R_028C40_PA_SC_SHADER_CONTROL, 1, 2036},
	{24632, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2037},
	{24660, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2038},
	{24681, R_028C60_CB_COLOR0_BASE},
	{24696, R_028C64_CB_COLOR0_PITCH, 2, 2039},
	{24712, R_028C68_CB_COLOR0_SLICE, 1, 2041},
	{24728, R_028C6C_CB_COLOR0_VIEW, 2, 2042},
	{24743, R_028C70_CB_COLOR0_INFO, 18, 2044},
	{24758, R_028C74_CB_COLOR0_ATTRIB, 6, 2062},
	{24775, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2068},
	{24797, R_028C7C_CB_COLOR0_CMASK},
	{24813, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2077},
	{24835, R_028C84_CB_COLOR0_FMASK},
	{24851, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2078},
	{24873, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{24895, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{24917, R_028C94_CB_COLOR0_DCC_BASE},
	{24936, R_028C9C_CB_COLOR1_BASE},
	{24951, R_028CA0_CB_COLOR1_PITCH, 2, 2039},
	{24967, R_028CA4_CB_COLOR1_SLICE, 1, 2041},
	{24983, R_028CA8_CB_COLOR1_VIEW, 2, 2042},
	{24998, R_028CAC_CB_COLOR1_INFO, 18, 2044},
	{25013, R_028CB0_CB_COLOR1_ATTRIB, 6, 2062},
	{25030, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2068},
	{25052, R_028CB8_CB_COLOR1_CMASK},
	{25068, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2077},
	{25090, R_028CC0_CB_COLOR1_FMASK},
	{25106, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2078},
	{25128, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{25150, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{25172, R_028CD0_CB_COLOR1_DCC_BASE},
	{25191, R_028CD8_CB_COLOR2_BASE},
	{25206, R_028CDC_CB_COLOR2_PITCH, 2, 2039},
	{25222, R_028CE0_CB_COLOR2_SLICE, 1, 2041},
	{25238, R_028CE4_CB_COLOR2_VIEW, 2, 2042},
	{25253, R_028CE8_CB_COLOR2_INFO, 18, 2044},
	{25268, R_028CEC_CB_COLOR2_ATTRIB, 6, 2062},
	{25285, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2068},
	{25307, R_028CF4_CB_COLOR2_CMASK},
	{25323, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2077},
	{25345, R_028CFC_CB_COLOR2_FMASK},
	{25361, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2078},
	{25383, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{25405, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{25427, R_028D0C_CB_COLOR2_DCC_BASE},
	{25446, R_028D14_CB_COLOR3_BASE},
	{25461, R_028D18_CB_COLOR3_PITCH, 2, 2039},
	{25477, R_028D1C_CB_COLOR3_SLICE, 1, 2041},
	{25493, R_028D20_CB_COLOR3_VIEW, 2, 2042},
	{25508, R_028D24_CB_COLOR3_INFO, 18, 2044},
	{25523, R_028D28_CB_COLOR3_ATTRIB, 6, 2062},
	{25540, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2068},
	{25562, R_028D30_CB_COLOR3_CMASK},
	{25578, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2077},
	{25600, R_028D38_CB_COLOR3_FMASK},
	{25616, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2078},
	{25638, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{25660, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{25682, R_028D48_CB_COLOR3_DCC_BASE},
	{25701, R_028D50_CB_COLOR4_BASE},
	{25716, R_028D54_CB_COLOR4_PITCH, 2, 2039},
	{25732, R_028D58_CB_COLOR4_SLICE, 1, 2041},
	{25748, R_028D5C_CB_COLOR4_VIEW, 2, 2042},
	{25763, R_028D60_CB_COLOR4_INFO, 18, 2044},
	{25778, R_028D64_CB_COLOR4_ATTRIB, 6, 2062},
	{25795, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2068},
	{25817, R_028D6C_CB_COLOR4_CMASK},
	{25833, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2077},
	{25855, R_028D74_CB_COLOR4_FMASK},
	{25871, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2078},
	{25893, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{25915, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{25937, R_028D84_CB_COLOR4_DCC_BASE},
	{25956, R_028D8C_CB_COLOR5_BASE},
	{25971, R_028D90_CB_COLOR5_PITCH, 2, 2039},
	{25987, R_028D94_CB_COLOR5_SLICE, 1, 2041},
	{26003, R_028D98_CB_COLOR5_VIEW, 2, 2042},
	{26018, R_028D9C_CB_COLOR5_INFO, 18, 2044},
	{26033, R_028DA0_CB_COLOR5_ATTRIB, 6, 2062},
	{26050, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2068},
	{26072, R_028DA8_CB_COLOR5_CMASK},
	{26088, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2077},
	{26110, R_028DB0_CB_COLOR5_FMASK},
	{26126, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2078},
	{26148, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{26170, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{26192, R_028DC0_CB_COLOR5_DCC_BASE},
	{26211, R_028DC8_CB_COLOR6_BASE},
	{26226, R_028DCC_CB_COLOR6_PITCH, 2, 2039},
	{26242, R_028DD0_CB_COLOR6_SLICE, 1, 2041},
	{26258, R_028DD4_CB_COLOR6_VIEW, 2, 2042},
	{26273, R_028DD8_CB_COLOR6_INFO, 18, 2044},
	{26288, R_028DDC_CB_COLOR6_ATTRIB, 6, 2062},
	{26305, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2068},
	{26327, R_028DE4_CB_COLOR6_CMASK},
	{26343, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2077},
	{26365, R_028DEC_CB_COLOR6_FMASK},
	{26381, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2078},
	{26403, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{26425, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{26447, R_028DFC_CB_COLOR6_DCC_BASE},
	{26466, R_028E04_CB_COLOR7_BASE},
	{26481, R_028E08_CB_COLOR7_PITCH, 2, 2039},
	{26497, R_028E0C_CB_COLOR7_SLICE, 1, 2041},
	{26513, R_028E10_CB_COLOR7_VIEW, 2, 2042},
	{26528, R_028E14_CB_COLOR7_INFO, 18, 2044},
	{26543, R_028E18_CB_COLOR7_ATTRIB, 6, 2062},
	{26560, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2068},
	{26582, R_028E20_CB_COLOR7_CMASK},
	{26598, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2077},
	{26620, R_028E28_CB_COLOR7_FMASK},
	{26636, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2078},
	{26658, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{26680, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{26702, R_028E38_CB_COLOR7_DCC_BASE},
};

static const struct si_reg gfx9d_reg_table[] = {
	{1098, R_008008_GRBM_STATUS2, 25, 2079},
	{1111, R_008010_GRBM_STATUS, 24, 2104},
	{1196, R_008014_GRBM_STATUS_SE0, 12, 2128},
	{1212, R_008018_GRBM_STATUS_SE1, 12, 2140},
	{1228, R_008038_GRBM_STATUS_SE2, 12, 2152},
	{1244, R_00803C_GRBM_STATUS_SE3, 12, 2164},
	{1154, R_0301F0_CP_COHER_CNTL, 13, 2176},
	{1298, R_0301FC_CP_COHER_STATUS, 2, 2189},
	{1314, R_008210_CP_CPC_STATUS, 16, 2191},
	{1345, R_008218_CP_CPC_STALLED_STAT1, 14, 2207},
	{1366, R_00821C_CP_CPF_STATUS, 21, 2221},
	{1397, R_008224_CP_CPF_STALLED_STAT1, 11, 2242},
	{1860, R_008670_CP_STALLED_STAT3, 19, 2253},
	{1911, R_008680_CP_STAT, 22, 2272},
	{1539, R_030908_VGT_PRIMITIVE_TYPE, 1, 2294},
	{1558, R_03090C_VGT_INDEX_TYPE, 2, 2295},
	{17705, R_030920_VGT_MAX_VTX_INDX},
	{17722, R_030924_VGT_MIN_VTX_INDX},
	{17739, R_030928_VGT_INDX_OFFSET},
	{22676, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2297},
	{1756, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 2299},
	{26721, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2301},
	{26743, R_030948_WD_POS_BUF_BASE},
	{26759, R_03094C_WD_POS_BUF_BASE_HI, 1, 2302},
	{26778, R_030950_WD_CNTL_SB_BUF_BASE},
	{26798, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2303},
	{26821, R_030958_WD_INDEX_BUF_BASE},
	{26839, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2304},
	{22753, R_030960_IA_MULTI_VGT_PARAM, 9, 2305},
	{26860, R_030968_VGT_INSTANCE_BASE_ID},
	{2037, R_030D20_SQC_CACHES, 6, 2314},
	{26881, R_030D24_SQC_WRITEBACK, 2, 2320},
	{2265, R_008F0C_SQ_BUF_RSRC_WORD3, 12, 2322},
	{2348, R_008F14_SQ_IMG_RSRC_WORD1, 9, 2334},
	{2390, R_008F18_SQ_IMG_RSRC_WORD2, 3, 560},
	{2431, R_008F1C_SQ_IMG_RSRC_WORD3, 8, 2343},
	{2449, R_008F20_SQ_IMG_RSRC_WORD4, 3, 2351},
	{2467, R_008F24_SQ_IMG_RSRC_WORD5, 7, 2354},
	{2557, R_008F38_SQ_IMG_SAMP_WORD2, 10, 2361},
	{2575, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 2371},
	{2839, R_031100_SPI_CONFIG_CNTL, 9, 2374},
	{2855, R_031104_SPI_CONFIG_CNTL_1, 11, 2383},
	{26895, R_031108_SPI_CONFIG_CNTL_2, 2, 2394},
	{2921, R_0098F8_GB_ADDR_CONFIG, 13, 2396},
	{2936, R_009910_GB_TILE_MODE0, 5, 2409},
	{2950, R_009914_GB_TILE_MODE1, 5, 2409},
	{2964, R_009918_GB_TILE_MODE2, 5, 2409},
	{2978, R_00991C_GB_TILE_MODE3, 5, 2409},
	{2992, R_009920_GB_TILE_MODE4, 5, 2409},
	{3006, R_009924_GB_TILE_MODE5, 5, 2409},
	{3020, R_009928_GB_TILE_MODE6, 5, 2409},
	{3034, R_00992C_GB_TILE_MODE7, 5, 2409},
	{3048, R_009930_GB_TILE_MODE8, 5, 2409},
	{3062, R_009934_GB_TILE_MODE9, 5, 2409},
	{3076, R_009938_GB_TILE_MODE10, 5, 2409},
	{3091, R_00993C_GB_TILE_MODE11, 5, 2409},
	{3106, R_009940_GB_TILE_MODE12, 5, 2409},
	{3121, R_009944_GB_TILE_MODE13, 5, 2409},
	{3136, R_009948_GB_TILE_MODE14, 5, 2409},
	{3151, R_00994C_GB_TILE_MODE15, 5, 2409},
	{3166, R_009950_GB_TILE_MODE16, 5, 2409},
	{3181, R_009954_GB_TILE_MODE17, 5, 2409},
	{3196, R_009958_GB_TILE_MODE18, 5, 2409},
	{3211, R_00995C_GB_TILE_MODE19, 5, 2409},
	{3226, R_009960_GB_TILE_MODE20, 5, 2409},
	{3241, R_009964_GB_TILE_MODE21, 5, 2409},
	{3256, R_009968_GB_TILE_MODE22, 5, 2409},
	{3271, R_00996C_GB_TILE_MODE23, 5, 2409},
	{3286, R_009970_GB_TILE_MODE24, 5, 2409},
	{3301, R_009974_GB_TILE_MODE25, 5, 2409},
	{3316, R_009978_GB_TILE_MODE26, 5, 2409},
	{3331, R_00997C_GB_TILE_MODE27, 5, 2409},
	{3346, R_009980_GB_TILE_MODE28, 5, 2409},
	{3361, R_009984_GB_TILE_MODE29, 5, 2409},
	{3376, R_009988_GB_TILE_MODE30, 5, 2409},
	{3391, R_00998C_GB_TILE_MODE31, 5, 2409},
	{3800, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 2414},
	{3866, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 2418},
	{3890, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 10, 2429},
	{26913, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{26940, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{26967, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{26994, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{27021, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{27048, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{27075, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{27102, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{27129, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{27156, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{27183, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{27210, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{27237, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{27264, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{27291, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{27318, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{4420, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 2439},
	{4511, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 2443},
	{4535, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 14, 2455},
	{27345, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{27372, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{27399, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{27426, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{27453, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{27480, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{27507, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{27534, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{27561, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{27588, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{27615, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{27642, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{27669, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{27696, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{27723, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{27750, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{27777, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2469},
	{27804, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2478},
	{27828, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{27860, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{5709, R_00B210_SPI_SHADER_PGM_LO_ES},
	{5730, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2480},
	{5065, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 2481},
	{5131, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 12, 2485},
	{5155, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 9, 2497},
	{27892, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{27919, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{27946, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{27973, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{28000, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{28027, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{28054, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{28081, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{28108, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{28135, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{28162, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{28189, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{28216, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{28243, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{28270, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{28297, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{28324, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2506},
	{28348, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{28380, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{6949, R_00B410_SPI_SHADER_PGM_LO_LS},
	{6970, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2507},
	{6305, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 4, 2508},
	{6371, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 11, 2512},
	{6395, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 2523},
	{7039, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{7065, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{7091, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{7117, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{7143, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{7169, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{7195, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{7221, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{7247, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{7273, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{7299, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{7326, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{7353, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{7380, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{7407, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{7434, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{28412, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{28439, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{28466, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{28493, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{28520, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{28547, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{28574, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{28601, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{28628, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{28655, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{28682, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{28709, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{28736, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{28763, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{28790, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{28817, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{28844, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{28874, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{28904, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{28934, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{28964, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{28994, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{29024, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{29054, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{29084, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{29114, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{29144, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{29175, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{29206, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{29237, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{29268, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{29299, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{29330, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{29361, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{29392, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{29423, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{29454, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{29485, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{29516, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{29547, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{29578, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{29609, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{29640, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{29671, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{29702, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{29733, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{29764, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{29795, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{7461, R_00B800_COMPUTE_DISPATCH_INITIATOR, 11, 2530},
	{7729, R_00B834_COMPUTE_PGM_HI, 1, 875},
	{29826, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{29855, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 877},
	{29884, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{29917, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 878},
	{7804, R_00B848_COMPUTE_PGM_RSRC1, 11, 2541},
	{7822, R_00B84C_COMPUTE_PGM_RSRC2, 12, 2552},
	{7853, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 2564},
	{29950, R_034030_CPF_LATENCY_STATS_DATA},
	{29973, R_034034_CPG_LATENCY_STATS_DATA},
	{29996, R_034038_CPC_LATENCY_STATS_DATA},
	{12283, R_036000_CPG_PERFCOUNTER1_SELECT, 5, 2571},
	{12307, R_036004_CPG_PERFCOUNTER0_SELECT1, 4, 2576},
	{12332, R_036008_CPG_PERFCOUNTER0_SELECT, 5, 2571},
	{12356, R_03600C_CPC_PERFCOUNTER1_SELECT, 5, 2580},
	{12380, R_036010_CPC_PERFCOUNTER0_SELECT1, 4, 2585},
	{12405, R_036014_CPF_PERFCOUNTER1_SELECT, 5, 2589},
	{12429, R_036018_CPF_PERFCOUNTER0_SELECT1, 4, 2594},
	{12454, R_03601C_CPF_PERFCOUNTER0_SELECT, 5, 2589},
	{12494, R_036024_CPC_PERFCOUNTER0_SELECT, 5, 2580},
	{30019, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2598},
	{30053, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2601},
	{30087, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2604},
	{30112, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2607},
	{30137, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2610},
	{12518, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 2613},
	{12543, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 2613},
	{12568, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 2635},
	{12596, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 2648},
	{12624, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 2661},
	{12652, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 2674},
	{13453, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 2687},
	{13477, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 2687},
	{13501, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 2687},
	{13525, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 2687},
	{13549, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 2692},
	{13649, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 2687},
	{13673, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 2687},
	{15305, R_028008_DB_DEPTH_VIEW, 5, 2696},
	{15338, R_028010_DB_RENDER_OVERRIDE2, 16, 2701},
	{30162, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2717},
	{15611, R_02801C_DB_DEPTH_SIZE, 2, 2718},
	{15511, R_028038_DB_Z_INFO, 13, 2720},
	{15521, R_02803C_DB_STENCIL_INFO, 8, 2733},
	{15537, R_028040_DB_Z_READ_BASE},
	{30184, R_028044_DB_Z_READ_BASE_HI, 1, 2741},
	{15552, R_028048_DB_STENCIL_READ_BASE},
	{30202, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2742},
	{30226, R_028054_DB_Z_WRITE_BASE_HI, 1, 2743},
	{15589, R_028058_DB_STENCIL_WRITE_BASE},
	{30245, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2744},
	{30270, R_028060_DB_DFSM_CONTROL, 3, 2745},
	{30286, R_028068_DB_Z_INFO2, 1, 2748},
	{30297, R_02806C_DB_STENCIL_INFO2, 1, 2749},
	{15675, R_0281E8_COHER_DEST_BASE_HI_0, 1, 2750},
	{15696, R_0281EC_COHER_DEST_BASE_HI_1, 1, 2751},
	{15717, R_0281F0_COHER_DEST_BASE_HI_2, 1, 2752},
	{15738, R_0281F4_COHER_DEST_BASE_HI_3, 1, 2753},
	{17635, R_028350_PA_SC_RASTER_CONFIG, 15, 2754},
	{17655, R_028354_PA_SC_RASTER_CONFIG_1, 3, 2769},
	{30314, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 3, 2772},
	{30343, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2775},
	{30364, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2776},
	{30386, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2780},
	{30407, R_0283A8_PA_SC_HORIZ_GRID, 4, 2784},
	{17841, R_028424_CB_DCC_CONTROL, 4, 2788},
	{21000, R_0286C4_SPI_VS_OUT_CONFIG, 2, 1352},
	{21074, R_0286D8_SPI_PS_IN_CONTROL, 5, 2792},
	{30424, R_0287A0_CB_MRT0_EPITCH, 1, 2797},
	{30439, R_0287A4_CB_MRT1_EPITCH, 1, 2798},
	{30454, R_0287A8_CB_MRT2_EPITCH, 1, 2799},
	{30469, R_0287AC_CB_MRT3_EPITCH, 1, 2800},
	{30484, R_0287B0_CB_MRT4_EPITCH, 1, 2801},
	{30499, R_0287B4_CB_MRT5_EPITCH, 1, 2802},
	{30514, R_0287B8_CB_MRT6_EPITCH, 1, 2803},
	{30529, R_0287BC_CB_MRT7_EPITCH, 1, 2804},
	{21656, R_0287E4_VGT_DMA_BASE_HI, 1, 2805},
	{21685, R_0287F0_VGT_DRAW_INITIATOR, 8, 2806},
	{21783, R_02880C_DB_SHADER_CONTROL, 16, 2814},
	{21817, R_028814_PA_SU_SC_MODE_CNTL, 15, 2830},
	{21836, R_028818_PA_CL_VTE_CNTL, 10, 2845},
	{21851, R_02881C_PA_CL_VS_OUT_CNTL, 28, 2855},
	{30544, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2883},
	{30566, R_028838_PA_CL_NGG_CNTL, 2, 2886},
	{30581, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2888},
	{30611, R_028840_PA_STEREO_CNTL},
	{22311, R_028A40_VGT_GS_MODE, 15, 2893},
	{22323, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 2908},
	{22342, R_028A48_PA_SC_MODE_CNTL_0, 7, 2911},
	{22563, R_028A7C_VGT_DMA_INDEX_TYPE, 7, 2918},
	{22593, R_028A84_VGT_PRIMITIVEID_EN, 3, 2925},
	{22656, R_028A90_VGT_EVENT_INITIATOR, 3, 2928},
	{30626, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2931},
	{30656, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2932},
	{22847, R_028ABC_DB_HTILE_SURFACE, 8, 2936},
	{23407, R_028B54_VGT_SHADER_STAGES_EN, 13, 2944},
	{23535, R_028B6C_VGT_TF_PARAM, 8, 2957},
	{23783, R_028B94_VGT_STRMOUT_CONFIG, 8, 2965},
	{30678, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2973},
	{23896, R_028BE0_PA_SC_AA_CONFIG, 6, 2976},
	{24611, R_028C40_PA_SC_SHADER_CONTROL, 3, 2982},
	{30702, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2985},
	{30722, R_028C48_PA_SC_BINNER_CNTL_1, 2, 2995},
	{30742, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 2997},
	{30780, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 3015},
	{30800, R_028C64_CB_COLOR0_BASE_EXT, 1, 3016},
	{30819, R_028C68_CB_COLOR0_ATTRIB2, 3, 3017},
	{24728, R_028C6C_CB_COLOR0_VIEW, 3, 3020},
	{24743, R_028C70_CB_COLOR0_INFO, 16, 3023},
	{24758, R_028C74_CB_COLOR0_ATTRIB, 10, 3039},
	{30837, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 3049},
	{30862, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 3050},
	{30887, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 3051},
	{30910, R_028CA0_CB_COLOR1_BASE_EXT, 1, 3016},
	{30929, R_028CA4_CB_COLOR1_ATTRIB2},
	{24983, R_028CA8_CB_COLOR1_VIEW, 3, 3020},
	{24998, R_028CAC_CB_COLOR1_INFO, 16, 3023},
	{25013, R_028CB0_CB_COLOR1_ATTRIB, 10, 3039},
	{30947, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 3049},
	{30972, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 3050},
	{30997, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 3051},
	{31020, R_028CDC_CB_COLOR2_BASE_EXT, 1, 3016},
	{31039, R_028CE0_CB_COLOR2_ATTRIB2},
	{25238, R_028CE4_CB_COLOR2_VIEW, 3, 3020},
	{25253, R_028CE8_CB_COLOR2_INFO, 16, 3023},
	{25268, R_028CEC_CB_COLOR2_ATTRIB, 10, 3039},
	{31057, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 3049},
	{31082, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 3050},
	{31107, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 3051},
	{31130, R_028D18_CB_COLOR3_BASE_EXT, 1, 3016},
	{31149, R_028D1C_CB_COLOR3_ATTRIB2},
	{25493, R_028D20_CB_COLOR3_VIEW, 3, 3020},
	{25508, R_028D24_CB_COLOR3_INFO, 16, 3023},
	{25523, R_028D28_CB_COLOR3_ATTRIB, 10, 3039},
	{31167, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 3049},
	{31192, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 3050},
	{31217, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 3051},
	{31240, R_028D54_CB_COLOR4_BASE_EXT, 1, 3016},
	{31259, R_028D58_CB_COLOR4_ATTRIB2},
	{25748, R_028D5C_CB_COLOR4_VIEW, 3, 3020},
	{25763, R_028D60_CB_COLOR4_INFO, 16, 3023},
	{25778, R_028D64_CB_COLOR4_ATTRIB, 10, 3039},
	{31277, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 3049},
	{31302, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 3050},
	{31327, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 3051},
	{31350, R_028D90_CB_COLOR5_BASE_EXT, 1, 3016},
	{31369, R_028D94_CB_COLOR5_ATTRIB2},
	{26003, R_028D98_CB_COLOR5_VIEW, 3, 3020},
	{26018, R_028D9C_CB_COLOR5_INFO, 16, 3023},
	{26033, R_028DA0_CB_COLOR5_ATTRIB, 10, 3039},
	{31387, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 3049},
	{31412, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 3050},
	{31437, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 3051},
	{31460, R_028DCC_CB_COLOR6_BASE_EXT, 1, 3016},
	{31479, R_028DD0_CB_COLOR6_ATTRIB2},
	{26258, R_028DD4_CB_COLOR6_VIEW, 3, 3020},
	{26273, R_028DD8_CB_COLOR6_INFO, 16, 3023},
	{26288, R_028DDC_CB_COLOR6_ATTRIB, 10, 3039},
	{31497, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 3049},
	{31522, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 3050},
	{31547, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 3051},
	{31570, R_028E08_CB_COLOR7_BASE_EXT, 1, 3016},
	{31589, R_028E0C_CB_COLOR7_ATTRIB2},
	{26513, R_028E10_CB_COLOR7_VIEW, 3, 3020},
	{26528, R_028E14_CB_COLOR7_INFO, 16, 3023},
	{26543, R_028E18_CB_COLOR7_ATTRIB, 10, 3039},
	{31607, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 3049},
	{31632, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 3050},
	{31657, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 3051},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{31680, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{31702, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{31724, S_370_ENGINE_SEL(~0u), 4, 0},
	{31735, S_370_WR_CONFIRM(~0u)},
	{31746, S_370_WR_ONE_ADDR(~0u)},
	{31797, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{31805, S_3F2_IB_SIZE(~0u)},
	{31813, S_3F2_CHAIN(~0u)},
	{31819, S_3F2_VALID(~0u)},
	/* 9 */
	{1002, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{31825, S_411_CP_SYNC(~0u)},
	{31857, S_411_SRC_SEL(~0u), 4, 10},
	{31865, S_411_ENGINE(~0u), 2, 0},
	{31797, S_411_DST_SEL(~0u), 4, 14},
	{1014, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{881, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{893, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{31896, S_414_BYTE_COUNT_GFX6(~0u)},
	{31912, S_414_BYTE_COUNT_GFX9(~0u)},
	{31928, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{31981, S_414_SRC_SWAP(~0u), 4, 18},
	{31990, S_414_DST_SWAP(~0u), 4, 18},
	{32006, S_414_SAS(~0u), 2, 22},
	{32010, S_414_DAS(~0u), 2, 22},
	{32037, S_414_SAIC(~0u), 2, 24},
	{32042, S_414_DAIC(~0u), 2, 24},
	{32047, S_414_RAW_WAIT(~0u)},
	{32056, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{31825, S_500_CP_SYNC(~0u)},
	{31857, S_500_SRC_SEL(~0u), 4, 10},
	{32080, S_500_DST_CACHE_POLICY(~0u)},
	{31797, S_500_DST_SEL(~0u), 4, 14},
	{32097, S_500_SRC_CACHE_POLICY(~0u)},
	{31865, S_500_ENGINE(~0u), 2, 0},
	/* 34 */
	{32114, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{32130, S_000E4C_TST_RQ_PENDING(~0u)},
	{32145, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{32162, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{32178, S_000E4C_VP8_BUSY(~0u)},
	{32187, S_000E4C_SDMA_BUSY(~0u)},
	{32197, S_000E4C_SDMA1_BUSY(~0u)},
	{32208, S_000E4C_VCE0_BUSY(~0u)},
	{32218, S_000E4C_XDMA_BUSY(~0u)},
	{32228, S_000E4C_CHUB_BUSY(~0u)},
	{32238, S_000E4C_SDMA2_BUSY(~0u)},
	{32249, S_000E4C_SDMA3_BUSY(~0u)},
	{32260, S_000E4C_SAMSCP_BUSY(~0u)},
	{32272, S_000E4C_ISP_BUSY(~0u)},
	{32281, S_000E4C_VCE1_BUSY(~0u)},
	{32291, S_000E4C_ODE_BUSY(~0u)},
	{32300, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{32317, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{32334, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{32352, S_000E4C_ISP_RQ_PENDING(~0u)},
	{32367, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 55 */
	{32383, S_000E50_UVD_RQ_PENDING(~0u)},
	{32398, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{32416, S_000E50_ACP_RQ_PENDING(~0u)},
	{32431, S_000E50_SMU_RQ_PENDING(~0u)},
	{32446, S_000E50_GRBM_RQ_PENDING(~0u)},
	{32462, S_000E50_HI_RQ_PENDING(~0u)},
	{32476, S_000E50_VMC_BUSY(~0u)},
	{32485, S_000E50_MCB_BUSY(~0u)},
	{32494, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{32515, S_000E50_MCC_BUSY(~0u)},
	{32524, S_000E50_MCD_BUSY(~0u)},
	{32533, S_000E50_VMC1_BUSY(~0u)},
	{32543, S_000E50_SEM_BUSY(~0u)},
	{32552, S_000E50_ACP_BUSY(~0u)},
	{32561, S_000E50_IH_BUSY(~0u)},
	{32569, S_000E50_UVD_BUSY(~0u)},
	{32578, S_000E50_SAMMSP_BUSY(~0u)},
	{32590, S_000E50_GCATCL2_BUSY(~0u)},
	{32603, S_000E50_OSATCL2_BUSY(~0u)},
	{32616, S_000E50_BIF_BUSY(~0u)},
	/* 75 */
	{32625, S_000E54_MCC0_BUSY(~0u)},
	{32635, S_000E54_MCC1_BUSY(~0u)},
	{32645, S_000E54_MCC2_BUSY(~0u)},
	{32655, S_000E54_MCC3_BUSY(~0u)},
	{32665, S_000E54_MCC4_BUSY(~0u)},
	{32675, S_000E54_MCC5_BUSY(~0u)},
	{32685, S_000E54_MCC6_BUSY(~0u)},
	{32695, S_000E54_MCC7_BUSY(~0u)},
	{32705, S_000E54_MCD0_BUSY(~0u)},
	{32715, S_000E54_MCD1_BUSY(~0u)},
	{32725, S_000E54_MCD2_BUSY(~0u)},
	{32735, S_000E54_MCD3_BUSY(~0u)},
	{32745, S_000E54_MCD4_BUSY(~0u)},
	{32755, S_000E54_MCD5_BUSY(~0u)},
	{32765, S_000E54_MCD6_BUSY(~0u)},
	{32775, S_000E54_MCD7_BUSY(~0u)},
	/* 91 */
	{32785, S_00D034_IDLE(~0u)},
	{32790, S_00D034_REG_IDLE(~0u)},
	{32799, S_00D034_RB_EMPTY(~0u)},
	{32808, S_00D034_RB_FULL(~0u)},
	{32816, S_00D034_RB_CMD_IDLE(~0u)},
	{32828, S_00D034_RB_CMD_FULL(~0u)},
	{32840, S_00D034_IB_CMD_IDLE(~0u)},
	{32852, S_00D034_IB_CMD_FULL(~0u)},
	{32864, S_00D034_BLOCK_IDLE(~0u)},
	{32875, S_00D034_INSIDE_IB(~0u)},
	{32885, S_00D034_EX_IDLE(~0u)},
	{32893, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{32919, S_00D034_PACKET_READY(~0u)},
	{32932, S_00D034_MC_WR_IDLE(~0u)},
	{32943, S_00D034_SRBM_IDLE(~0u)},
	{32953, S_00D034_CONTEXT_EMPTY(~0u)},
	{32967, S_00D034_DELTA_RPTR_FULL(~0u)},
	{32983, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{32999, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{33015, S_00D034_MC_RD_IDLE(~0u)},
	{33026, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{33043, S_00D034_MC_RD_RET_STALL(~0u)},
	{33059, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{33078, S_00D034_PREV_CMD_IDLE(~0u)},
	{33092, S_00D034_SEM_IDLE(~0u)},
	{33101, S_00D034_SEM_REQ_STALL(~0u)},
	{33115, S_00D034_SEM_RESP_STATE(~0u)},
	{33130, S_00D034_INT_IDLE(~0u)},
	{33139, S_00D034_INT_REQ_STALL(~0u)},
	/* 120 */
	{33153, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33176, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33199, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33222, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33242, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33262, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33282, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33302, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33322, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33342, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33362, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33382, S_008008_RLC_RQ_PENDING(~0u)},
	{33397, S_008008_RLC_BUSY(~0u)},
	{33406, S_008008_TC_BUSY(~0u)},
	{33414, S_008008_TCC_CC_RESIDENT(~0u)},
	{33430, S_008008_CPF_BUSY(~0u)},
	{33439, S_008008_CPC_BUSY(~0u)},
	{33448, S_008008_CPG_BUSY(~0u)},
	/* 138 */
	{33457, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{33480, S_008010_SRBM_RQ_PENDING(~0u)},
	{33496, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33519, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33542, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33561, S_008010_DB_CLEAN(~0u)},
	{33570, S_008010_CB_CLEAN(~0u)},
	{33579, S_008010_TA_BUSY(~0u)},
	{33587, S_008010_GDS_BUSY(~0u)},
	{33596, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33611, S_008010_VGT_BUSY(~0u)},
	{33620, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33635, S_008010_IA_BUSY(~0u)},
	{33643, S_008010_SX_BUSY(~0u)},
	{33651, S_008010_WD_BUSY(~0u)},
	{33659, S_008010_SPI_BUSY(~0u)},
	{33668, S_008010_BCI_BUSY(~0u)},
	{33677, S_008010_SC_BUSY(~0u)},
	{33685, S_008010_PA_BUSY(~0u)},
	{33693, S_008010_DB_BUSY(~0u)},
	{33701, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32264, S_008010_CP_BUSY(~0u)},
	{32486, S_008010_CB_BUSY(~0u)},
	{33719, S_008010_GUI_ACTIVE(~0u)},
	/* 162 */
	{33730, S_00802C_INSTANCE_INDEX(~0u)},
	{33745, S_00802C_SH_INDEX(~0u)},
	{33754, S_00802C_SE_INDEX(~0u)},
	{33763, S_00802C_SH_BROADCAST_WRITES(~0u)},
	{33783, S_00802C_INSTANCE_BROADCAST_WRITES(~0u)},
	{33809, S_00802C_SE_BROADCAST_WRITES(~0u)},
	/* 168 */
	{33829, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 169 */
	{33848, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{33864, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{33880, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{33898, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{33916, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{33934, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{33952, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{33970, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{33988, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{34006, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{34024, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{34041, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{34057, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{34073, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{34089, S_0085F0_TC_ACTION_ENA(~0u)},
	{34103, S_0085F0_CB_ACTION_ENA(~0u)},
	{34117, S_0085F0_DB_ACTION_ENA(~0u)},
	{34131, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34152, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 188 */
	{33561, S_008014_DB_CLEAN(~0u)},
	{33570, S_008014_CB_CLEAN(~0u)},
	{33668, S_008014_BCI_BUSY(~0u)},
	{33611, S_008014_VGT_BUSY(~0u)},
	{33685, S_008014_PA_BUSY(~0u)},
	{33579, S_008014_TA_BUSY(~0u)},
	{33643, S_008014_SX_BUSY(~0u)},
	{33659, S_008014_SPI_BUSY(~0u)},
	{33677, S_008014_SC_BUSY(~0u)},
	{33693, S_008014_DB_BUSY(~0u)},
	{32486, S_008014_CB_BUSY(~0u)},
	/* 199 */
	{33561, S_008018_DB_CLEAN(~0u)},
	{33570, S_008018_CB_CLEAN(~0u)},
	{33668, S_008018_BCI_BUSY(~0u)},
	{33611, S_008018_VGT_BUSY(~0u)},
	{33685, S_008018_PA_BUSY(~0u)},
	{33579, S_008018_TA_BUSY(~0u)},
	{33643, S_008018_SX_BUSY(~0u)},
	{33659, S_008018_SPI_BUSY(~0u)},
	{33677, S_008018_SC_BUSY(~0u)},
	{33693, S_008018_DB_BUSY(~0u)},
	{32486, S_008018_CB_BUSY(~0u)},
	/* 210 */
	{33561, S_008038_DB_CLEAN(~0u)},
	{33570, S_008038_CB_CLEAN(~0u)},
	{33668, S_008038_BCI_BUSY(~0u)},
	{33611, S_008038_VGT_BUSY(~0u)},
	{33685, S_008038_PA_BUSY(~0u)},
	{33579, S_008038_TA_BUSY(~0u)},
	{33643, S_008038_SX_BUSY(~0u)},
	{33659, S_008038_SPI_BUSY(~0u)},
	{33677, S_008038_SC_BUSY(~0u)},
	{33693, S_008038_DB_BUSY(~0u)},
	{32486, S_008038_CB_BUSY(~0u)},
	/* 221 */
	{33561, S_00803C_DB_CLEAN(~0u)},
	{33570, S_00803C_CB_CLEAN(~0u)},
	{33668, S_00803C_BCI_BUSY(~0u)},
	{33611, S_00803C_VGT_BUSY(~0u)},
	{33685, S_00803C_PA_BUSY(~0u)},
	{33579, S_00803C_TA_BUSY(~0u)},
	{33643, S_00803C_SX_BUSY(~0u)},
	{33659, S_00803C_SPI_BUSY(~0u)},
	{33677, S_00803C_SC_BUSY(~0u)},
	{33693, S_00803C_DB_BUSY(~0u)},
	{32486, S_00803C_CB_BUSY(~0u)},
	/* 232 */
	{33829, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 233 */
	{34173, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 234 */
	{34192, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 235 */
	{33848, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{33864, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{34210, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{34227, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{33880, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{33898, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{33916, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{33934, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{33952, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{33970, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{33988, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{34006, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{34024, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{34244, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34264, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{34282, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34041, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{34057, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{34073, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34089, S_0301F0_TC_ACTION_ENA(~0u)},
	{34103, S_0301F0_CB_ACTION_ENA(~0u)},
	{34117, S_0301F0_DB_ACTION_ENA(~0u)},
	{34131, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34299, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34152, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34324, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{34348, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 262 */
	{34365, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{34383, S_0301FC_MEID(~0u)},
	{34388, S_0301FC_PHASE1_STATUS(~0u)},
	{1044, S_0301FC_STATUS(~0u)},
	/* 266 */
	{34402, S_008210_MEC1_BUSY(~0u)},
	{34412, S_008210_MEC2_BUSY(~0u)},
	{34422, S_008210_DC0_BUSY(~0u)},
	{34431, S_008210_DC1_BUSY(~0u)},
	{34440, S_008210_RCIU1_BUSY(~0u)},
	{34451, S_008210_RCIU2_BUSY(~0u)},
	{34462, S_008210_ROQ1_BUSY(~0u)},
	{34472, S_008210_ROQ2_BUSY(~0u)},
	{34482, S_008210_TCIU_BUSY(~0u)},
	{34492, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34509, S_008210_QU_BUSY(~0u)},
	{34517, S_008210_ATCL2IU_BUSY(~0u)},
	{34530, S_008210_CPG_CPC_BUSY(~0u)},
	{34543, S_008210_CPF_CPC_BUSY(~0u)},
	{33439, S_008210_CPC_BUSY(~0u)},
	/* 281 */
	{34556, S_008214_MEC1_LOAD_BUSY(~0u)},
	{34571, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{34591, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{34607, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{34625, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{34645, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{34664, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{34683, S_008214_MEC1_TC_BUSY(~0u)},
	{34696, S_008214_MEC1_DMA_BUSY(~0u)},
	{34710, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{34734, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{34750, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{34766, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{34782, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{34798, S_008214_MEC2_LOAD_BUSY(~0u)},
	{34813, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{34833, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{34849, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{34867, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{34887, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{34906, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{34925, S_008214_MEC2_TC_BUSY(~0u)},
	{34938, S_008214_MEC2_DMA_BUSY(~0u)},
	{34952, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{34976, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{34992, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{35008, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{35024, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 309 */
	{35040, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35059, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35079, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35098, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35119, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35137, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35160, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35182, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35203, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35221, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35244, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{35266, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35290, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35314, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 323 */
	{35337, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35356, S_00821C_CSF_BUSY(~0u)},
	{35365, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35380, S_00821C_ROQ_RING_BUSY(~0u)},
	{35394, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35413, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35432, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35447, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35464, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35486, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35508, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35523, S_00821C_INTERRUPT_BUSY(~0u)},
	{34482, S_00821C_TCIU_BUSY(~0u)},
	{35538, S_00821C_HQD_BUSY(~0u)},
	{35547, S_00821C_PRT_BUSY(~0u)},
	{34517, S_00821C_ATCL2IU_BUSY(~0u)},
	{35556, S_00821C_CPF_GFX_BUSY(~0u)},
	{35569, S_00821C_CPF_CMP_BUSY(~0u)},
	{35582, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35601, S_00821C_CPC_CPF_BUSY(~0u)},
	{33430, S_00821C_CPF_BUSY(~0u)},
	/* 344 */
	{35614, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{35632, S_008220_CSF_RING_BUSY(~0u)},
	{35646, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{35665, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{35684, S_008220_CSF_STATE_BUSY(~0u)},
	{35699, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{35717, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{35735, S_008220_CSF_ARBITER_BUSY(~0u)},
	{35752, S_008220_CSF_INPUT_BUSY(~0u)},
	{35767, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{35789, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{35813, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{35831, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{35849, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{35870, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{35894, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{35920, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{35937, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{35957, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{35977, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{35997, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{36018, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{36041, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{36062, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{36081, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{36098, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{36114, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{36130, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{36146, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{36165, S_008220_HQD_PQ_BUSY(~0u)},
	{36177, S_008220_HQD_IB_BUSY(~0u)},
	/* 375 */
	{36189, S_008224_RING_FETCHING_DATA(~0u)},
	{36208, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36228, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36248, S_008224_STATE_FETCHING_DATA(~0u)},
	{36268, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36289, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{35266, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35290, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35314, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 384 */
	{36310, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 385 */
	{36329, S_0088B0_PRIM_COUNT(~0u)},
	/* 386 */
	{36340, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{36359, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{36380, S_0088C4_ES_LIMIT(~0u)},
	/* 389 */
	{36389, S_0088D4_VERT_REUSE(~0u)},
	/* 390 */
	{22169, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 391 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 392 */
	{38, S_008988_SIZE(~0u)},
	/* 393 */
	{36958, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 394 */
	{36976, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{36997, S_008A14_NUM_CLIP_SEQ(~0u)},
	{37010, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{37033, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 398 */
	{1816, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 399 */
	{37053, S_008B10_CURRENT_PTR(~0u)},
	{37065, S_008B10_CURRENT_COUNT(~0u)},
	/* 401 */
	{37079, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37104, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37142, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37183, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37206, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37229, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37253, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37283, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37312, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37338, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37367, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37392, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36268, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36289, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37427, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37455, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{35266, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35290, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35314, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 420 */
	{37485, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{37512, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{37539, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{37568, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{37597, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{37626, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37654, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{37684, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{37711, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{37739, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{37764, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{37790, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{37815, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{37839, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{37864, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{37892, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 436 */
	{37921, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37947, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{37973, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38000, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{38026, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{38048, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{38075, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{38097, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{38121, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{38146, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38169, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{38196, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{38221, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{38249, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38274, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38299, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{38324, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{38353, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{38384, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{38412, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{38439, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{38469, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{38496, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{38523, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{38550, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{38576, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{38600, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{38632, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{38659, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 465 */
	{35380, S_008680_ROQ_RING_BUSY(~0u)},
	{35394, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35413, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35432, S_008680_ROQ_STATE_BUSY(~0u)},
	{38685, S_008680_DC_BUSY(~0u)},
	{34517, S_008680_ATCL2IU_BUSY(~0u)},
	{38693, S_008680_PFP_BUSY(~0u)},
	{38702, S_008680_MEQ_BUSY(~0u)},
	{38711, S_008680_ME_BUSY(~0u)},
	{38719, S_008680_QUERY_BUSY(~0u)},
	{35508, S_008680_SEMAPHORE_BUSY(~0u)},
	{35523, S_008680_INTERRUPT_BUSY(~0u)},
	{38730, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32188, S_008680_DMA_BUSY(~0u)},
	{38748, S_008680_RCIU_BUSY(~0u)},
	{34492, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38758, S_008680_CPC_CPG_BUSY(~0u)},
	{38771, S_008680_CE_BUSY(~0u)},
	{34482, S_008680_TCIU_BUSY(~0u)},
	{35447, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35464, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35486, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32264, S_008680_CP_BUSY(~0u)},
	/* 488 */
	{33730, S_030800_INSTANCE_INDEX(~0u)},
	{33745, S_030800_SH_INDEX(~0u)},
	{33754, S_030800_SE_INDEX(~0u)},
	{33763, S_030800_SH_BROADCAST_WRITES(~0u)},
	{33783, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{33809, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 494 */
	{22169, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 495 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 496 */
	{38, S_030938_SIZE(~0u)},
	/* 497 */
	{36958, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38827, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 499 */
	{1816, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 500 */
	{37053, S_030A04_CURRENT_PTR(~0u)},
	{37065, S_030A04_CURRENT_COUNT(~0u)},
	/* 502 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 504 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 506 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 508 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 510 */
	{38847, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{38873, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{38896, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{38921, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{38952, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{38986, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{39006, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{39033, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{39061, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 519 */
	{39096, S_008C08_INST_INVALIDATE(~0u)},
	{39112, S_008C08_DATA_INVALIDATE(~0u)},
	/* 521 */
	{39096, S_030D20_INST_INVALIDATE(~0u)},
	{39112, S_030D20_DATA_INVALIDATE(~0u)},
	{39128, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 524 */
	{39148, S_008C0C_RET(~0u)},
	{39152, S_008C0C_RUI(~0u)},
	{39156, S_008C0C_RNG(~0u)},
	/* 527 */
	{2610, S_008DFC_EN(~0u)},
	{39219, S_008DFC_TGT(~0u), 33, 90},
	{39223, S_008DFC_COMPR(~0u)},
	{33843, S_008DFC_DONE(~0u)},
	{39229, S_008DFC_VM(~0u)},
	{39249, S_008DFC_ENCODING(~0u), 63, 123},
	/* 533 */
	{39258, S_030E04_ADDRESS(~0u)},
	/* 534 */
	{2830, S_030F04_COUNT_HI(~0u)},
	/* 535 */
	{39266, S_008F04_BASE_ADDRESS_HI(~0u)},
	{23358, S_008F04_STRIDE(~0u)},
	{39282, S_008F04_CACHE_SWIZZLE(~0u)},
	{39296, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 539 */
	{2830, S_030F0C_COUNT_HI(~0u)},
	/* 540 */
	{39401, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39411, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39421, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39431, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39615, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{40007, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{40019, S_008F0C_ELEMENT_SIZE(~0u)},
	{40032, S_008F0C_INDEX_STRIDE(~0u)},
	{40045, S_008F0C_ADD_TID_ENABLE(~0u)},
	{40060, S_008F0C_ATC(~0u)},
	{40064, S_008F0C_HASH_ENABLE(~0u)},
	{40076, S_008F0C_HEAP(~0u)},
	{40081, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 554 */
	{2830, S_030F14_COUNT_HI(~0u)},
	/* 555 */
	{39266, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40156, S_008F14_MIN_LOD(~0u)},
	{41789, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 222},
	{42173, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 286},
	{40081, S_008F14_MTYPE(~0u)},
	/* 560 */
	{42189, S_008F18_WIDTH(~0u)},
	{42195, S_008F18_HEIGHT(~0u)},
	{42202, S_008F18_PERF_MOD(~0u)},
	{42211, S_008F18_INTERLACED(~0u)},
	/* 564 */
	{2830, S_030F1C_COUNT_HI(~0u)},
	/* 565 */
	{39401, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39411, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39421, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39431, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42222, S_008F1C_BASE_LEVEL(~0u)},
	{42233, S_008F1C_LAST_LEVEL(~0u)},
	{42244, S_008F1C_TILING_INDEX(~0u)},
	{42257, S_008F1C_POW2_PAD(~0u)},
	{40081, S_008F1C_MTYPE(~0u)},
	{40060, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 576 */
	{22153, S_008F20_DEPTH(~0u)},
	{42568, S_008F20_PITCH_GFX6(~0u)},
	/* 578 */
	{42579, S_008F24_BASE_ARRAY(~0u)},
	{42590, S_008F24_LAST_ARRAY(~0u)},
	/* 580 */
	{42601, S_008F28_MIN_LOD_WARN(~0u)},
	{42614, S_008F28_COUNTER_BANK_ID(~0u)},
	{42630, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{42645, S_008F28_COMPRESSION_EN(~0u)},
	{42660, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{42676, S_008F28_COLOR_TRANSFORM(~0u)},
	{42692, S_008F28_LOST_ALPHA_BITS(~0u)},
	{42708, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 588 */
	{42906, S_008F30_CLAMP_X(~0u), 8, 318},
	{42914, S_008F30_CLAMP_Y(~0u), 8, 318},
	{42922, S_008F30_CLAMP_Z(~0u), 8, 318},
	{42930, S_008F30_MAX_ANISO_RATIO(~0u)},
	{43178, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{43197, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{43216, S_008F30_ANISO_THRESHOLD(~0u)},
	{43232, S_008F30_MC_COORD_TRUNC(~0u)},
	{43247, S_008F30_FORCE_DEGAMMA(~0u)},
	{43261, S_008F30_ANISO_BIAS(~0u)},
	{43272, S_008F30_TRUNC_COORD(~0u)},
	{43284, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{43373, S_008F30_FILTER_MODE(~0u), 3, 334},
	{43385, S_008F30_COMPAT_MODE(~0u)},
	/* 602 */
	{40156, S_008F34_MIN_LOD(~0u)},
	{43397, S_008F34_MAX_LOD(~0u)},
	{43405, S_008F34_PERF_MIP(~0u)},
	{43414, S_008F34_PERF_Z(~0u)},
	/* 606 */
	{43421, S_008F38_LOD_BIAS(~0u)},
	{43430, S_008F38_LOD_BIAS_SEC(~0u)},
	{43492, S_008F38_XY_MAG_FILTER(~0u), 2, 337},
	{43567, S_008F38_XY_MIN_FILTER(~0u), 4, 339},
	{43647, S_008F38_Z_FILTER(~0u), 3, 343},
	{43656, S_008F38_MIP_FILTER(~0u), 3, 343},
	{43667, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{43686, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{43703, S_008F38_FILTER_PREC_FIX(~0u)},
	{43719, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 616 */
	{43734, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{43751, S_008F3C_UPGRADED_DEPTH(~0u)},
	{43893, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 346},
	/* 619 */
	{43911, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{43928, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{43945, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{43962, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{43979, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 624 */
	{43996, S_0090E0_PS_CU_EN(~0u)},
	{44005, S_0090E0_VS_CU_EN(~0u)},
	/* 626 */
	{44014, S_0090E4_GS_CU_EN(~0u)},
	{44023, S_0090E4_ES_CU_EN(~0u)},
	/* 628 */
	{44032, S_0090E8_LSHS_CU_EN(~0u)},
	/* 629 */
	{2695, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 630 */
	{2695, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 631 */
	{44048, S_0090F0_RING_ORDER_TS0(~0u), 1, 350},
	{44063, S_0090F0_RING_ORDER_TS1(~0u)},
	{44078, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 634 */
	{44093, S_00C700_PIPE_ORDER_TS0(~0u)},
	{44108, S_00C700_PIPE_ORDER_TS1(~0u)},
	{44123, S_00C700_PIPE_ORDER_TS2(~0u)},
	{44138, S_00C700_PIPE_ORDER_TS3(~0u)},
	{44153, S_00C700_TS0_DUR_MULT(~0u)},
	{44166, S_00C700_TS1_DUR_MULT(~0u)},
	{44179, S_00C700_TS2_DUR_MULT(~0u)},
	{44192, S_00C700_TS3_DUR_MULT(~0u)},
	/* 642 */
	{44205, S_0090F4_TS0_DURATION(~0u)},
	{44218, S_0090F4_TS1_DURATION(~0u)},
	/* 644 */
	{44231, S_0090F8_TS2_DURATION(~0u)},
	/* 645 */
	{38, S_008F40_SIZE(~0u)},
	/* 646 */
	{669, S_008F44_OFFSET(~0u)},
	/* 647 */
	{2830, S_030FFC_COUNT_HI(~0u)},
	/* 648 */
	{44244, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{44263, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{44282, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44304, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44326, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 653 */
	{44595, S_00913C_VTX_DONE_DELAY(~0u), 16, 351},
	{44610, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{44634, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{44650, S_00913C_PC_LIMIT_STRICT(~0u)},
	{44666, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 658 */
	{44680, S_00936C_TYPE_A(~0u)},
	{44687, S_00936C_VGPR_A(~0u)},
	{44694, S_00936C_SGPR_A(~0u)},
	{44701, S_00936C_LDS_A(~0u)},
	{44707, S_00936C_WAVES_A(~0u)},
	{44715, S_00936C_EN_A(~0u)},
	{44720, S_00936C_TYPE_B(~0u)},
	{44727, S_00936C_VGPR_B(~0u)},
	{44734, S_00936C_SGPR_B(~0u)},
	{44741, S_00936C_LDS_B(~0u)},
	{44747, S_00936C_WAVES_B(~0u)},
	{44755, S_00936C_EN_B(~0u)},
	/* 670 */
	{44760, S_009858_MSAA1_X(~0u)},
	{44768, S_009858_MSAA1_Y(~0u)},
	{44776, S_009858_MSAA2_X(~0u)},
	{44784, S_009858_MSAA2_Y(~0u)},
	{44792, S_009858_MSAA4_X(~0u)},
	{44800, S_009858_MSAA4_Y(~0u)},
	{44808, S_009858_MSAA8_X(~0u)},
	{44816, S_009858_MSAA8_Y(~0u)},
	{44824, S_009858_MSAA16_X(~0u)},
	{44833, S_009858_MSAA16_Y(~0u)},
	/* 680 */
	{44842, S_0098F8_NUM_PIPES(~0u)},
	{44852, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{44878, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{44899, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{44923, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{44947, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{44961, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{44981, S_0098F8_ROW_SIZE(~0u)},
	{44990, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 689 */
	{45123, S_009910_MICRO_TILE_MODE(~0u), 4, 367},
	{45368, S_009910_ARRAY_MODE(~0u), 16, 371},
	{45730, S_009910_PIPE_CONFIG(~0u), 15, 387},
	{45920, S_009910_TILE_SPLIT(~0u), 7, 402},
	{46023, S_009910_BANK_WIDTH(~0u), 4, 409},
	{46130, S_009910_BANK_HEIGHT(~0u), 4, 413},
	{46242, S_009910_MACRO_TILE_ASPECT(~0u), 4, 417},
	{46329, S_009910_NUM_BANKS(~0u), 4, 421},
	{46370, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 425},
	{46390, S_009910_SAMPLE_SPLIT(~0u)},
	/* 699 */
	{46023, S_009990_BANK_WIDTH(~0u)},
	{46130, S_009990_BANK_HEIGHT(~0u)},
	{46242, S_009990_MACRO_TILE_ASPECT(~0u)},
	{46329, S_009990_NUM_BANKS(~0u)},
	/* 703 */
	{46403, S_00B004_MEM_BASE(~0u)},
	/* 704 */
	{46403, S_00B00C_MEM_BASE(~0u)},
	/* 705 */
	{43999, S_00B01C_CU_EN(~0u)},
	{46412, S_00B01C_WAVE_LIMIT(~0u)},
	{46423, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 708 */
	{46403, S_00B024_MEM_BASE(~0u)},
	/* 709 */
	{46442, S_00B028_VGPRS(~0u)},
	{46448, S_00B028_SGPRS(~0u)},
	{2715, S_00B028_PRIORITY(~0u)},
	{46497, S_00B028_FLOAT_MODE(~0u), 241, 429},
	{46508, S_00B028_PRIV(~0u)},
	{46513, S_00B028_DX10_CLAMP(~0u)},
	{46524, S_00B028_DEBUG_MODE(~0u)},
	{46535, S_00B028_IEEE_MODE(~0u)},
	{46545, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46562, S_00B028_CACHE_CTL(~0u)},
	{46572, S_00B028_CDBG_USER(~0u)},
	/* 720 */
	{46582, S_00B02C_SCRATCH_EN(~0u)},
	{46593, S_00B02C_USER_SGPR(~0u)},
	{46603, S_00B02C_TRAP_PRESENT(~0u)},
	{46616, S_00B02C_WAVE_CNT_EN(~0u)},
	{46628, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46643, S_00B02C_EXCP_EN_SI(~0u)},
	{46654, S_00B02C_EXCP_EN(~0u)},
	/* 727 */
	{46403, S_00B104_MEM_BASE(~0u)},
	/* 728 */
	{46403, S_00B10C_MEM_BASE(~0u)},
	/* 729 */
	{43999, S_00B118_CU_EN(~0u)},
	{46412, S_00B118_WAVE_LIMIT(~0u)},
	{46423, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 732 */
	{36383, S_00B11C_LIMIT(~0u)},
	/* 733 */
	{46403, S_00B124_MEM_BASE(~0u)},
	/* 734 */
	{46442, S_00B128_VGPRS(~0u)},
	{46448, S_00B128_SGPRS(~0u)},
	{2715, S_00B128_PRIORITY(~0u)},
	{46497, S_00B128_FLOAT_MODE(~0u)},
	{46508, S_00B128_PRIV(~0u)},
	{46513, S_00B128_DX10_CLAMP(~0u)},
	{46524, S_00B128_DEBUG_MODE(~0u)},
	{46535, S_00B128_IEEE_MODE(~0u)},
	{46662, S_00B128_VGPR_COMP_CNT(~0u)},
	{46676, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46562, S_00B128_CACHE_CTL(~0u)},
	{46572, S_00B128_CDBG_USER(~0u)},
	/* 746 */
	{46582, S_00B12C_SCRATCH_EN(~0u)},
	{46593, S_00B12C_USER_SGPR(~0u)},
	{46603, S_00B12C_TRAP_PRESENT(~0u)},
	{46692, S_00B12C_OC_LDS_EN(~0u)},
	{46702, S_00B12C_SO_BASE0_EN(~0u)},
	{46714, S_00B12C_SO_BASE1_EN(~0u)},
	{46726, S_00B12C_SO_BASE2_EN(~0u)},
	{46738, S_00B12C_SO_BASE3_EN(~0u)},
	{46750, S_00B12C_SO_EN(~0u)},
	{46643, S_00B12C_EXCP_EN_SI(~0u)},
	{46654, S_00B12C_EXCP_EN(~0u)},
	{46756, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 758 */
	{46403, S_00B204_MEM_BASE(~0u)},
	/* 759 */
	{46403, S_00B20C_MEM_BASE(~0u)},
	/* 760 */
	{43999, S_00B21C_CU_EN(~0u)},
	{46412, S_00B21C_WAVE_LIMIT(~0u)},
	{46423, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{46773, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 764 */
	{46403, S_00B224_MEM_BASE(~0u)},
	/* 765 */
	{46442, S_00B228_VGPRS(~0u)},
	{46448, S_00B228_SGPRS(~0u)},
	{2715, S_00B228_PRIORITY(~0u)},
	{46497, S_00B228_FLOAT_MODE(~0u)},
	{46508, S_00B228_PRIV(~0u)},
	{46513, S_00B228_DX10_CLAMP(~0u)},
	{46524, S_00B228_DEBUG_MODE(~0u)},
	{46535, S_00B228_IEEE_MODE(~0u)},
	{46676, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46562, S_00B228_CACHE_CTL(~0u)},
	{46572, S_00B228_CDBG_USER(~0u)},
	/* 776 */
	{46582, S_00B22C_SCRATCH_EN(~0u)},
	{46593, S_00B22C_USER_SGPR(~0u)},
	{46603, S_00B22C_TRAP_PRESENT(~0u)},
	{46643, S_00B22C_EXCP_EN_SI(~0u)},
	{46654, S_00B22C_EXCP_EN(~0u)},
	/* 781 */
	{46403, S_00B304_MEM_BASE(~0u)},
	/* 782 */
	{46403, S_00B30C_MEM_BASE(~0u)},
	/* 783 */
	{43999, S_00B31C_CU_EN(~0u)},
	{46412, S_00B31C_WAVE_LIMIT(~0u)},
	{46423, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{46773, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 787 */
	{46403, S_00B324_MEM_BASE(~0u)},
	/* 788 */
	{46442, S_00B328_VGPRS(~0u)},
	{46448, S_00B328_SGPRS(~0u)},
	{2715, S_00B328_PRIORITY(~0u)},
	{46497, S_00B328_FLOAT_MODE(~0u)},
	{46508, S_00B328_PRIV(~0u)},
	{46513, S_00B328_DX10_CLAMP(~0u)},
	{46524, S_00B328_DEBUG_MODE(~0u)},
	{46535, S_00B328_IEEE_MODE(~0u)},
	{46662, S_00B328_VGPR_COMP_CNT(~0u)},
	{46676, S_00B328_CU_GROUP_ENABLE(~0u)},
	{46562, S_00B328_CACHE_CTL(~0u)},
	{46572, S_00B328_CDBG_USER(~0u)},
	/* 800 */
	{46582, S_00B32C_SCRATCH_EN(~0u)},
	{46593, S_00B32C_USER_SGPR(~0u)},
	{46603, S_00B32C_TRAP_PRESENT(~0u)},
	{46692, S_00B32C_OC_LDS_EN(~0u)},
	{46643, S_00B32C_EXCP_EN_SI(~0u)},
	{46654, S_00B32C_EXCP_EN(~0u)},
	{46634, S_00B32C_LDS_SIZE(~0u)},
	/* 807 */
	{46403, S_00B404_MEM_BASE(~0u)},
	/* 808 */
	{46403, S_00B40C_MEM_BASE(~0u)},
	/* 809 */
	{46412, S_00B41C_WAVE_LIMIT(~0u)},
	{46423, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{46773, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 812 */
	{46403, S_00B424_MEM_BASE(~0u)},
	/* 813 */
	{46442, S_00B428_VGPRS(~0u)},
	{46448, S_00B428_SGPRS(~0u)},
	{2715, S_00B428_PRIORITY(~0u)},
	{46497, S_00B428_FLOAT_MODE(~0u)},
	{46508, S_00B428_PRIV(~0u)},
	{46513, S_00B428_DX10_CLAMP(~0u)},
	{46524, S_00B428_DEBUG_MODE(~0u)},
	{46535, S_00B428_IEEE_MODE(~0u)},
	{46562, S_00B428_CACHE_CTL(~0u)},
	{46572, S_00B428_CDBG_USER(~0u)},
	/* 823 */
	{46582, S_00B42C_SCRATCH_EN(~0u)},
	{46593, S_00B42C_USER_SGPR(~0u)},
	{46603, S_00B42C_TRAP_PRESENT(~0u)},
	{46692, S_00B42C_OC_LDS_EN(~0u)},
	{46790, S_00B42C_TG_SIZE_EN(~0u)},
	{46643, S_00B42C_EXCP_EN_SI(~0u)},
	{46801, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	/* 830 */
	{46403, S_00B504_MEM_BASE(~0u)},
	/* 831 */
	{46403, S_00B50C_MEM_BASE(~0u)},
	/* 832 */
	{43999, S_00B51C_CU_EN(~0u)},
	{46412, S_00B51C_WAVE_LIMIT(~0u)},
	{46423, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{46773, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 836 */
	{46403, S_00B524_MEM_BASE(~0u)},
	/* 837 */
	{46442, S_00B528_VGPRS(~0u)},
	{46448, S_00B528_SGPRS(~0u)},
	{2715, S_00B528_PRIORITY(~0u)},
	{46497, S_00B528_FLOAT_MODE(~0u)},
	{46508, S_00B528_PRIV(~0u)},
	{46513, S_00B528_DX10_CLAMP(~0u)},
	{46524, S_00B528_DEBUG_MODE(~0u)},
	{46535, S_00B528_IEEE_MODE(~0u)},
	{46662, S_00B528_VGPR_COMP_CNT(~0u)},
	{46562, S_00B528_CACHE_CTL(~0u)},
	{46572, S_00B528_CDBG_USER(~0u)},
	/* 848 */
	{46582, S_00B52C_SCRATCH_EN(~0u)},
	{46593, S_00B52C_USER_SGPR(~0u)},
	{46603, S_00B52C_TRAP_PRESENT(~0u)},
	{46634, S_00B52C_LDS_SIZE(~0u)},
	{46643, S_00B52C_EXCP_EN_SI(~0u)},
	{46654, S_00B52C_EXCP_EN(~0u)},
	/* 854 */
	{46816, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46834, S_00B800_PARTIAL_TG_EN(~0u)},
	{46848, S_00B800_FORCE_START_AT_000(~0u)},
	{46867, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46887, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46907, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46929, S_00B800_ORDER_MODE(~0u)},
	{46940, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{46960, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46978, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{46996, S_00B800_DATA_ATC(~0u)},
	{47005, S_00B800_RESTORE(~0u)},
	/* 866 */
	{47013, S_00B81C_NUM_THREAD_FULL(~0u)},
	{47029, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 868 */
	{47013, S_00B820_NUM_THREAD_FULL(~0u)},
	{47029, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 870 */
	{47013, S_00B824_NUM_THREAD_FULL(~0u)},
	{47029, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 872 */
	{2695, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 873 */
	{7669, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 874 */
	{7697, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 875 */
	{391, S_00B834_DATA(~0u)},
	{47048, S_00B834_INST_ATC(~0u)},
	/* 877 */
	{391, S_00B83C_DATA(~0u)},
	/* 878 */
	{391, S_00B844_DATA(~0u)},
	/* 879 */
	{46442, S_00B848_VGPRS(~0u)},
	{46448, S_00B848_SGPRS(~0u)},
	{2715, S_00B848_PRIORITY(~0u)},
	{46497, S_00B848_FLOAT_MODE(~0u)},
	{46508, S_00B848_PRIV(~0u)},
	{46513, S_00B848_DX10_CLAMP(~0u)},
	{46524, S_00B848_DEBUG_MODE(~0u)},
	{46535, S_00B848_IEEE_MODE(~0u)},
	{47057, S_00B848_BULKY(~0u)},
	{46572, S_00B848_CDBG_USER(~0u)},
	/* 889 */
	{46582, S_00B84C_SCRATCH_EN(~0u)},
	{46593, S_00B84C_USER_SGPR(~0u)},
	{46603, S_00B84C_TRAP_PRESENT(~0u)},
	{47063, S_00B84C_TGID_X_EN(~0u)},
	{47073, S_00B84C_TGID_Y_EN(~0u)},
	{47083, S_00B84C_TGID_Z_EN(~0u)},
	{46790, S_00B84C_TG_SIZE_EN(~0u)},
	{47093, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47108, S_00B84C_EXCP_EN_MSB(~0u)},
	{46634, S_00B84C_LDS_SIZE(~0u)},
	{46654, S_00B84C_EXCP_EN(~0u)},
	/* 900 */
	{391, S_00B850_DATA(~0u)},
	/* 901 */
	{47120, S_00B854_WAVES_PER_SH_SI(~0u)},
	{47136, S_00B854_WAVES_PER_SH(~0u)},
	{47149, S_00B854_TG_PER_CU(~0u)},
	{47159, S_00B854_LOCK_THRESHOLD(~0u)},
	{47174, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47189, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47205, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 908 */
	{47220, S_00B858_SH0_CU_EN(~0u)},
	{47230, S_00B858_SH1_CU_EN(~0u)},
	/* 910 */
	{47220, S_00B85C_SH0_CU_EN(~0u)},
	{47230, S_00B85C_SH1_CU_EN(~0u)},
	/* 912 */
	{47240, S_00B860_WAVES(~0u)},
	{47246, S_00B860_WAVESIZE(~0u)},
	/* 914 */
	{47220, S_00B864_SH0_CU_EN(~0u)},
	{47230, S_00B864_SH1_CU_EN(~0u)},
	/* 916 */
	{47220, S_00B868_SH0_CU_EN(~0u)},
	{47230, S_00B868_SH1_CU_EN(~0u)},
	/* 918 */
	{47255, S_00B87C_SEND_SEID(~0u)},
	{45451, S_00B87C_RESERVED2(~0u)},
	{47265, S_00B87C_RESERVED3(~0u)},
	{47275, S_00B87C_RESERVED4(~0u)},
	{47285, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 923 */
	{47298, S_00B888_PAYLOAD(~0u)},
	{47306, S_00B888_IS_EVENT(~0u)},
	{47315, S_00B888_IS_STATE(~0u)},
	/* 926 */
	{2090, S_00B890_ADDR(~0u)},
	/* 927 */
	{40060, S_00B894_ATC(~0u)},
	{40081, S_00B894_MTYPE(~0u)},
	/* 929 */
	{8944, S_034404_PERFCOUNTER_HI(~0u)},
	/* 930 */
	{47324, S_036008_PERF_SEL(~0u)},
	{47333, S_036008_PERF_SEL1(~0u)},
	{47343, S_036008_CNTR_MODE(~0u)},
	/* 933 */
	{47353, S_036004_PERF_SEL2(~0u)},
	{47363, S_036004_PERF_SEL3(~0u)},
	/* 935 */
	{47324, S_036024_PERF_SEL(~0u)},
	{47333, S_036024_PERF_SEL1(~0u)},
	{47343, S_036024_CNTR_MODE(~0u)},
	/* 938 */
	{47353, S_036010_PERF_SEL2(~0u)},
	{47363, S_036010_PERF_SEL3(~0u)},
	/* 940 */
	{47324, S_03601C_PERF_SEL(~0u)},
	{47333, S_03601C_PERF_SEL1(~0u)},
	{47343, S_03601C_CNTR_MODE(~0u)},
	/* 943 */
	{47353, S_036018_PERF_SEL2(~0u)},
	{47363, S_036018_PERF_SEL3(~0u)},
	/* 945 */
	{47420, S_036020_PERFMON_STATE(~0u), 3, 670},
	{47434, S_036020_SPM_PERFMON_STATE(~0u)},
	{47452, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{47472, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 949 */
	{47324, S_036100_PERF_SEL(~0u)},
	{47494, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47548, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47575, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47706, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47786, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47812, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47838, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47892, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47919, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47945, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 968 */
	{47324, S_036108_PERF_SEL(~0u)},
	{47494, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 980 */
	{47324, S_03610C_PERF_SEL(~0u)},
	{47494, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 992 */
	{47324, S_036110_PERF_SEL(~0u)},
	{47494, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1004 */
	{47324, S_036114_PERF_SEL(~0u)},
	{47494, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1016 */
	{47324, S_036200_PERF_SEL(~0u)},
	{47971, S_036200_PERF_MODE(~0u)},
	/* 1018 */
	{47324, S_036210_PERF_SEL(~0u)},
	{47333, S_036210_PERF_SEL1(~0u)},
	{47343, S_036210_CNTR_MODE(~0u)},
	{47981, S_036210_PERF_MODE1(~0u)},
	{47971, S_036210_PERF_MODE(~0u)},
	/* 1023 */
	{47353, S_036220_PERF_SEL2(~0u)},
	{47363, S_036220_PERF_SEL3(~0u)},
	{47992, S_036220_PERF_MODE3(~0u)},
	{48003, S_036220_PERF_MODE2(~0u)},
	/* 1027 */
	{47324, S_036230_PERF_SEL(~0u)},
	{47333, S_036230_PERF_SEL1(~0u)},
	{47343, S_036230_CNTR_MODE(~0u)},
	{47981, S_036230_PERF_MODE1(~0u)},
	{47971, S_036230_PERF_MODE(~0u)},
	/* 1032 */
	{47353, S_036240_PERF_SEL2(~0u)},
	{47363, S_036240_PERF_SEL3(~0u)},
	{47992, S_036240_PERF_MODE3(~0u)},
	{48003, S_036240_PERF_MODE2(~0u)},
	/* 1036 */
	{48014, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1037 */
	{47324, S_036400_PERF_SEL(~0u)},
	{47333, S_036400_PERF_SEL1(~0u)},
	{47343, S_036400_CNTR_MODE(~0u)},
	/* 1040 */
	{47353, S_036404_PERF_SEL2(~0u)},
	{47363, S_036404_PERF_SEL3(~0u)},
	/* 1042 */
	{47324, S_036500_PERF_SEL(~0u)},
	{47333, S_036500_PERF_SEL1(~0u)},
	{47343, S_036500_CNTR_MODE(~0u)},
	/* 1045 */
	{47353, S_036504_PERF_SEL2(~0u)},
	{47363, S_036504_PERF_SEL3(~0u)},
	/* 1047 */
	{47324, S_036600_PERF_SEL(~0u)},
	{47333, S_036600_PERF_SEL1(~0u)},
	{47343, S_036600_CNTR_MODE(~0u)},
	/* 1050 */
	{47353, S_036610_PERF_SEL2(~0u)},
	{47363, S_036610_PERF_SEL3(~0u)},
	/* 1052 */
	{48036, S_036628_BIN0_MIN(~0u)},
	{48045, S_036628_BIN0_MAX(~0u)},
	{48054, S_036628_BIN1_MIN(~0u)},
	{48063, S_036628_BIN1_MAX(~0u)},
	{48072, S_036628_BIN2_MIN(~0u)},
	{48081, S_036628_BIN2_MAX(~0u)},
	{48090, S_036628_BIN3_MIN(~0u)},
	{48099, S_036628_BIN3_MAX(~0u)},
	/* 1060 */
	{47324, S_036700_PERF_SEL(~0u)},
	{48108, S_036700_SQC_BANK_MASK(~0u)},
	{48122, S_036700_SQC_CLIENT_MASK(~0u)},
	{48138, S_036700_SPM_MODE(~0u)},
	{48147, S_036700_SIMD_MASK(~0u)},
	{47971, S_036700_PERF_MODE(~0u)},
	/* 1066 */
	{48157, S_036780_PS_EN(~0u)},
	{48163, S_036780_VS_EN(~0u)},
	{48169, S_036780_GS_EN(~0u)},
	{23422, S_036780_ES_EN(~0u)},
	{48175, S_036780_HS_EN(~0u)},
	{48181, S_036780_LS_EN(~0u)},
	{48187, S_036780_CS_EN(~0u)},
	{48193, S_036780_CNTR_RATE(~0u)},
	{48203, S_036780_DISABLE_FLUSH(~0u)},
	/* 1075 */
	{48217, S_036784_SH0_MASK(~0u)},
	{48226, S_036784_SH1_MASK(~0u)},
	/* 1077 */
	{48235, S_036788_FORCE_EN(~0u)},
	/* 1078 */
	{12577, S_036900_PERFCOUNTER_SELECT(~0u)},
	{48244, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{47343, S_036900_CNTR_MODE(~0u)},
	/* 1081 */
	{48264, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{48284, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1083 */
	{12577, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{48244, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{47343, S_036A00_CNTR_MODE(~0u)},
	/* 1086 */
	{48264, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{48284, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1088 */
	{47324, S_036B00_PERF_SEL(~0u)},
	{47333, S_036B00_PERF_SEL1(~0u)},
	{47343, S_036B00_CNTR_MODE(~0u)},
	{47981, S_036B00_PERF_MODE1(~0u)},
	{47971, S_036B00_PERF_MODE(~0u)},
	/* 1093 */
	{47353, S_036B04_PERF_SEL2(~0u)},
	{47363, S_036B04_PERF_SEL3(~0u)},
	{47992, S_036B04_PERF_MODE3(~0u)},
	{48003, S_036B04_PERF_MODE2(~0u)},
	/* 1097 */
	{47324, S_036C00_PERF_SEL(~0u)},
	{47333, S_036C00_PERF_SEL1(~0u)},
	{47343, S_036C00_CNTR_MODE(~0u)},
	{47981, S_036C00_PERF_MODE1(~0u)},
	{47971, S_036C00_PERF_MODE(~0u)},
	/* 1102 */
	{47353, S_036C04_PERF_SEL2(~0u)},
	{47363, S_036C04_PERF_SEL3(~0u)},
	{47992, S_036C04_PERF_MODE3(~0u)},
	{48003, S_036C04_PERF_MODE2(~0u)},
	/* 1106 */
	{47324, S_036D00_PERF_SEL(~0u)},
	{47333, S_036D00_PERF_SEL1(~0u)},
	{47343, S_036D00_CNTR_MODE(~0u)},
	{47981, S_036D00_PERF_MODE1(~0u)},
	{47971, S_036D00_PERF_MODE(~0u)},
	/* 1111 */
	{47353, S_036D04_PERF_SEL2(~0u)},
	{47363, S_036D04_PERF_SEL3(~0u)},
	{47992, S_036D04_PERF_MODE3(~0u)},
	{48003, S_036D04_PERF_MODE2(~0u)},
	/* 1115 */
	{47324, S_036E00_PERF_SEL(~0u)},
	{47333, S_036E00_PERF_SEL1(~0u)},
	{47343, S_036E00_CNTR_MODE(~0u)},
	{47981, S_036E00_PERF_MODE1(~0u)},
	{47971, S_036E00_PERF_MODE(~0u)},
	/* 1120 */
	{47353, S_036E04_PERF_SEL2(~0u)},
	{47363, S_036E04_PERF_SEL3(~0u)},
	{48003, S_036E04_PERF_MODE2(~0u)},
	{47992, S_036E04_PERF_MODE3(~0u)},
	/* 1124 */
	{47324, S_036E40_PERF_SEL(~0u)},
	{47333, S_036E40_PERF_SEL1(~0u)},
	{47343, S_036E40_CNTR_MODE(~0u)},
	{47981, S_036E40_PERF_MODE1(~0u)},
	{47971, S_036E40_PERF_MODE(~0u)},
	/* 1129 */
	{47353, S_036E44_PERF_SEL2(~0u)},
	{47363, S_036E44_PERF_SEL3(~0u)},
	{48003, S_036E44_PERF_MODE2(~0u)},
	{47992, S_036E44_PERF_MODE3(~0u)},
	/* 1133 */
	{48304, S_037000_OP_FILTER_ENABLE(~0u)},
	{48321, S_037000_OP_FILTER_SEL(~0u)},
	{48335, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{48356, S_037000_FORMAT_FILTER_SEL(~0u)},
	{48374, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{48394, S_037000_CLEAR_FILTER_SEL(~0u)},
	{48411, S_037000_MRT_FILTER_ENABLE(~0u)},
	{48429, S_037000_MRT_FILTER_SEL(~0u)},
	{48444, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{48470, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{48493, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{48521, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1145 */
	{47324, S_037004_PERF_SEL(~0u)},
	{47333, S_037004_PERF_SEL1(~0u)},
	{47343, S_037004_CNTR_MODE(~0u)},
	{47981, S_037004_PERF_MODE1(~0u)},
	{47971, S_037004_PERF_MODE(~0u)},
	/* 1150 */
	{47353, S_037008_PERF_SEL2(~0u)},
	{47363, S_037008_PERF_SEL3(~0u)},
	{47992, S_037008_PERF_MODE3(~0u)},
	{48003, S_037008_PERF_MODE2(~0u)},
	/* 1154 */
	{47324, S_037100_PERF_SEL(~0u)},
	{47333, S_037100_PERF_SEL1(~0u)},
	{47343, S_037100_CNTR_MODE(~0u)},
	{47981, S_037100_PERF_MODE1(~0u)},
	{47971, S_037100_PERF_MODE(~0u)},
	/* 1159 */
	{47353, S_037104_PERF_SEL2(~0u)},
	{47363, S_037104_PERF_SEL3(~0u)},
	{47992, S_037104_PERF_MODE3(~0u)},
	{48003, S_037104_PERF_MODE2(~0u)},
	/* 1163 */
	{48546, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{48565, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{48586, S_028000_DEPTH_COPY(~0u)},
	{48597, S_028000_STENCIL_COPY(~0u)},
	{48610, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{48629, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{48654, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{48677, S_028000_COPY_CENTROID(~0u)},
	{48691, S_028000_COPY_SAMPLE(~0u)},
	{48703, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1173 */
	{48721, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{48745, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{48766, S_028004_SAMPLE_RATE(~0u)},
	{48778, S_028004_ZPASS_ENABLE(~0u)},
	{48791, S_028004_ZFAIL_ENABLE(~0u)},
	{48804, S_028004_SFAIL_ENABLE(~0u)},
	{48817, S_028004_DBFAIL_ENABLE(~0u)},
	{48831, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{48849, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1182 */
	{48866, S_028008_SLICE_START(~0u)},
	{48878, S_028008_SLICE_MAX(~0u)},
	{48888, S_028008_Z_READ_ONLY(~0u)},
	{48900, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1186 */
	{48970, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 673},
	{48987, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 673},
	{49005, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 673},
	{49023, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{49044, S_02800C_FAST_Z_DISABLE(~0u)},
	{49059, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{49080, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{49098, S_02800C_FORCE_COLOR_KILL(~0u)},
	{49115, S_02800C_FORCE_Z_READ(~0u)},
	{49128, S_02800C_FORCE_STENCIL_READ(~0u)},
	{49147, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 673},
	{49166, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{49190, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{49213, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{49230, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{49315, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 677},
	{49334, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{49351, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{49375, S_02800C_FORCE_Z_DIRTY(~0u)},
	{49389, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{49409, S_02800C_FORCE_Z_VALID(~0u)},
	{49423, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{49443, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1209 */
	{49517, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 681},
	{49546, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49577, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49613, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49648, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49676, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49698, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49716, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49748, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49774, S_028010_HIZ_ZFUNC(~0u)},
	{49784, S_028010_HIS_SFUNC_FF(~0u)},
	{49797, S_028010_HIS_SFUNC_BF(~0u)},
	{49810, S_028010_PRESERVE_ZRANGE(~0u)},
	{49826, S_028010_PRESERVE_SRESULTS(~0u)},
	{49844, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1224 */
	{15428, S_028028_CLEAR(~0u)},
	/* 1225 */
	{49862, S_028030_TL_X(~0u)},
	{49867, S_028030_TL_Y(~0u)},
	/* 1227 */
	{49872, S_028034_BR_X(~0u)},
	{49877, S_028034_BR_Y(~0u)},
	/* 1229 */
	{49882, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{45368, S_02803C_ARRAY_MODE(~0u), 7, 685},
	{45730, S_02803C_PIPE_CONFIG(~0u), 18, 692},
	{46023, S_02803C_BANK_WIDTH(~0u), 4, 409},
	{46130, S_02803C_BANK_HEIGHT(~0u), 4, 413},
	{46242, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 417},
	{46329, S_02803C_NUM_BANKS(~0u), 4, 421},
	/* 1236 */
	{21171, S_028040_FORMAT(~0u), 4, 710},
	{50034, S_028040_NUM_SAMPLES(~0u)},
	{45920, S_028040_TILE_SPLIT(~0u), 7, 402},
	{50046, S_028040_TILE_MODE_INDEX(~0u)},
	{50062, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{50086, S_028040_ALLOW_EXPCLEAR(~0u)},
	{50101, S_028040_READ_SIZE(~0u)},
	{50111, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{50131, S_028040_CLEAR_DISALLOWED(~0u)},
	{50148, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1246 */
	{21171, S_028044_FORMAT(~0u), 2, 714},
	{45920, S_028044_TILE_SPLIT(~0u), 7, 402},
	{50046, S_028044_TILE_MODE_INDEX(~0u)},
	{50086, S_028044_ALLOW_EXPCLEAR(~0u)},
	{50191, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{50131, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1252 */
	{50212, S_028058_PITCH_TILE_MAX(~0u)},
	{50227, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1254 */
	{50243, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1255 */
	{39258, S_028084_ADDRESS(~0u)},
	/* 1256 */
	{50258, S_028200_WINDOW_X_OFFSET(~0u)},
	{50274, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1258 */
	{49862, S_028204_TL_X(~0u)},
	{49867, S_028204_TL_Y(~0u)},
	{50290, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1261 */
	{49872, S_028208_BR_X(~0u)},
	{49877, S_028208_BR_Y(~0u)},
	/* 1263 */
	{50372, S_02820C_CLIP_RULE(~0u), 32769, 716},
	/* 1264 */
	{49862, S_028210_TL_X(~0u)},
	{49867, S_028210_TL_Y(~0u)},
	/* 1266 */
	{49872, S_028214_BR_X(~0u)},
	{49877, S_028214_BR_Y(~0u)},
	/* 1268 */
	{50382, S_028230_ER_TRI(~0u)},
	{43457, S_028230_ER_POINT(~0u)},
	{50389, S_028230_ER_RECT(~0u)},
	{50397, S_028230_ER_LINE_LR(~0u)},
	{50408, S_028230_ER_LINE_RL(~0u)},
	{50419, S_028230_ER_LINE_TB(~0u)},
	{50430, S_028230_ER_LINE_BT(~0u)},
	/* 1275 */
	{50441, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{50460, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1277 */
	{50479, S_028238_TARGET0_ENABLE(~0u)},
	{50494, S_028238_TARGET1_ENABLE(~0u)},
	{50509, S_028238_TARGET2_ENABLE(~0u)},
	{50524, S_028238_TARGET3_ENABLE(~0u)},
	{50539, S_028238_TARGET4_ENABLE(~0u)},
	{50554, S_028238_TARGET5_ENABLE(~0u)},
	{50569, S_028238_TARGET6_ENABLE(~0u)},
	{50584, S_028238_TARGET7_ENABLE(~0u)},
	/* 1285 */
	{50599, S_02823C_OUTPUT0_ENABLE(~0u)},
	{50614, S_02823C_OUTPUT1_ENABLE(~0u)},
	{50629, S_02823C_OUTPUT2_ENABLE(~0u)},
	{50644, S_02823C_OUTPUT3_ENABLE(~0u)},
	{50659, S_02823C_OUTPUT4_ENABLE(~0u)},
	{50674, S_02823C_OUTPUT5_ENABLE(~0u)},
	{50689, S_02823C_OUTPUT6_ENABLE(~0u)},
	{50704, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1293 */
	{49862, S_028240_TL_X(~0u)},
	{49867, S_028240_TL_Y(~0u)},
	{50290, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1296 */
	{49872, S_028244_BR_X(~0u)},
	{49877, S_028244_BR_Y(~0u)},
	/* 1298 */
	{49862, S_028250_TL_X(~0u)},
	{49867, S_028250_TL_Y(~0u)},
	{50290, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1301 */
	{49872, S_028254_BR_X(~0u)},
	{49877, S_028254_BR_Y(~0u)},
	/* 1303 */
	{50811, S_028350_RB_MAP_PKR0(~0u), 4, 33485},
	{50823, S_028350_RB_MAP_PKR1(~0u), 4, 33485},
	{50935, S_028350_RB_XSEL2(~0u), 4, 33489},
	{50944, S_028350_RB_XSEL(~0u)},
	{50952, S_028350_RB_YSEL(~0u)},
	{51056, S_028350_PKR_MAP(~0u), 4, 33493},
	{51164, S_028350_PKR_XSEL(~0u), 4, 33497},
	{51273, S_028350_PKR_YSEL(~0u), 4, 33501},
	{51386, S_028350_PKR_XSEL2(~0u), 4, 33505},
	{51488, S_028350_SC_MAP(~0u), 4, 33509},
	{51634, S_028350_SC_XSEL(~0u), 4, 33513},
	{51781, S_028350_SC_YSEL(~0u), 4, 33517},
	{51881, S_028350_SE_MAP(~0u), 4, 33521},
	{52027, S_028350_SE_XSEL_GFX6(~0u), 4, 33525},
	{52179, S_028350_SE_YSEL_GFX6(~0u), 4, 33529},
	/* 1318 */
	{52304, S_028354_SE_PAIR_MAP(~0u), 4, 33533},
	{52475, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 33537},
	{52652, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 33541},
	/* 1321 */
	{48831, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{48849, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1323 */
	{52670, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52697, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52736, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1326 */
	{53002, S_02842C_STENCILFAIL(~0u), 16, 33545},
	{53014, S_02842C_STENCILZPASS(~0u), 16, 33545},
	{53027, S_02842C_STENCILZFAIL(~0u), 16, 33545},
	{53040, S_02842C_STENCILFAIL_BF(~0u), 16, 33545},
	{53055, S_02842C_STENCILZPASS_BF(~0u), 16, 33545},
	{53071, S_02842C_STENCILZFAIL_BF(~0u), 16, 33545},
	/* 1332 */
	{53087, S_028430_STENCILTESTVAL(~0u)},
	{53102, S_028430_STENCILMASK(~0u)},
	{53114, S_028430_STENCILWRITEMASK(~0u)},
	{53131, S_028430_STENCILOPVAL(~0u)},
	/* 1336 */
	{53144, S_028434_STENCILTESTVAL_BF(~0u)},
	{53162, S_028434_STENCILMASK_BF(~0u)},
	{53177, S_028434_STENCILWRITEMASK_BF(~0u)},
	{53197, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1340 */
	{669, S_028644_OFFSET(~0u)},
	{53220, S_028644_DEFAULT_VAL(~0u), 1, 33561},
	{53232, S_028644_FLAT_SHADE(~0u)},
	{53243, S_028644_CYL_WRAP(~0u)},
	{53252, S_028644_PT_SPRITE_TEX(~0u)},
	{53266, S_028644_DUP(~0u)},
	{53270, S_028644_FP16_INTERP_MODE(~0u)},
	{53287, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{53305, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{53323, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{53343, S_028644_ATTR0_VALID(~0u)},
	{53355, S_028644_ATTR1_VALID(~0u)},
	/* 1352 */
	{53367, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{53383, S_0286C4_VS_HALF_PACK(~0u)},
	{53396, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{53411, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1356 */
	{53431, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{53448, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{53465, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{53484, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{53505, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{53523, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{53541, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{53561, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{53582, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{53598, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{53614, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{53630, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{53646, S_0286CC_FRONT_FACE_ENA(~0u)},
	{53661, S_0286CC_ANCILLARY_ENA(~0u)},
	{53675, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{53695, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1372 */
	{53431, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{53448, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{53465, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{53484, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{53505, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{53523, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{53541, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{53561, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{53582, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{53598, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{53614, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{53630, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{53646, S_0286D0_FRONT_FACE_ENA(~0u)},
	{53661, S_0286D0_ANCILLARY_ENA(~0u)},
	{53675, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{53695, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1388 */
	{53712, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{53727, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{53850, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 33562},
	{53868, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 33562},
	{53886, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 33562},
	{53904, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 33562},
	{53922, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1395 */
	{53939, S_0286D8_NUM_INTERP(~0u)},
	{53950, S_0286D8_PARAM_GEN(~0u)},
	{53960, S_0286D8_FOG_ADDR(~0u)},
	{53969, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{53989, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1400 */
	{54009, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{54027, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{54047, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{54066, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{54136, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 33567},
	{54155, S_0286E0_POS_FLOAT_ULC(~0u)},
	{54169, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1407 */
	{47240, S_0286E8_WAVES(~0u)},
	{47246, S_0286E8_WAVESIZE(~0u)},
	/* 1409 */
	{54189, S_028704_NUM_PS_WAVES(~0u)},
	{54202, S_028704_NUM_VS_WAVES(~0u)},
	{54215, S_028704_NUM_GS_WAVES(~0u)},
	{54228, S_028704_NUM_ES_WAVES(~0u)},
	{54241, S_028704_NUM_HS_WAVES(~0u)},
	/* 1414 */
	{54254, S_028708_NUM_LS_WAVES(~0u)},
	/* 1415 */
	{54355, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 33568},
	{54374, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 33568},
	{54393, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 33568},
	{54412, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 33568},
	/* 1419 */
	{54631, S_028710_Z_EXPORT_FORMAT(~0u), 10, 33573},
	/* 1420 */
	{54647, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 33573},
	{54666, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 33573},
	{54685, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 33573},
	{54704, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 33573},
	{54723, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 33573},
	{54742, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 33573},
	{54761, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 33573},
	{54780, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 33573},
	/* 1428 */
	{55034, S_028754_MRT0(~0u), 11, 33583},
	{55039, S_028754_MRT1(~0u)},
	{55044, S_028754_MRT2(~0u)},
	{55049, S_028754_MRT3(~0u)},
	{55054, S_028754_MRT4(~0u)},
	{55059, S_028754_MRT5(~0u)},
	{55064, S_028754_MRT6(~0u)},
	{55069, S_028754_MRT7(~0u)},
	/* 1436 */
	{55154, S_028758_MRT0_EPSILON(~0u), 16, 33594},
	{55167, S_028758_MRT1_EPSILON(~0u)},
	{55180, S_028758_MRT2_EPSILON(~0u)},
	{55193, S_028758_MRT3_EPSILON(~0u)},
	{55206, S_028758_MRT4_EPSILON(~0u)},
	{55219, S_028758_MRT5_EPSILON(~0u)},
	{55232, S_028758_MRT6_EPSILON(~0u)},
	{55245, S_028758_MRT7_EPSILON(~0u)},
	/* 1444 */
	{55258, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{55281, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{55304, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{55327, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{55350, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{55373, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{55396, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{55419, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{55442, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{55465, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{55488, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{55511, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{55534, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{55557, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{55580, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{55603, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{55626, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1461 */
	{55917, S_028760_COLOR_SRC_OPT(~0u), 8, 33610},
	{55931, S_028760_COLOR_DST_OPT(~0u)},
	{56079, S_028760_COLOR_COMB_FCN(~0u), 8, 33618},
	{56094, S_028760_ALPHA_SRC_OPT(~0u)},
	{56108, S_028760_ALPHA_DST_OPT(~0u)},
	{56122, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1467 */
	{55917, S_028764_COLOR_SRC_OPT(~0u)},
	{55931, S_028764_COLOR_DST_OPT(~0u)},
	{56079, S_028764_COLOR_COMB_FCN(~0u)},
	{56094, S_028764_ALPHA_SRC_OPT(~0u)},
	{56108, S_028764_ALPHA_DST_OPT(~0u)},
	{56122, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1473 */
	{55917, S_028768_COLOR_SRC_OPT(~0u)},
	{55931, S_028768_COLOR_DST_OPT(~0u)},
	{56079, S_028768_COLOR_COMB_FCN(~0u)},
	{56094, S_028768_ALPHA_SRC_OPT(~0u)},
	{56108, S_028768_ALPHA_DST_OPT(~0u)},
	{56122, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1479 */
	{55917, S_02876C_COLOR_SRC_OPT(~0u)},
	{55931, S_02876C_COLOR_DST_OPT(~0u)},
	{56079, S_02876C_COLOR_COMB_FCN(~0u)},
	{56094, S_02876C_ALPHA_SRC_OPT(~0u)},
	{56108, S_02876C_ALPHA_DST_OPT(~0u)},
	{56122, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1485 */
	{55917, S_028770_COLOR_SRC_OPT(~0u)},
	{55931, S_028770_COLOR_DST_OPT(~0u)},
	{56079, S_028770_COLOR_COMB_FCN(~0u)},
	{56094, S_028770_ALPHA_SRC_OPT(~0u)},
	{56108, S_028770_ALPHA_DST_OPT(~0u)},
	{56122, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1491 */
	{55917, S_028774_COLOR_SRC_OPT(~0u)},
	{55931, S_028774_COLOR_DST_OPT(~0u)},
	{56079, S_028774_COLOR_COMB_FCN(~0u)},
	{56094, S_028774_ALPHA_SRC_OPT(~0u)},
	{56108, S_028774_ALPHA_DST_OPT(~0u)},
	{56122, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1497 */
	{55917, S_028778_COLOR_SRC_OPT(~0u)},
	{55931, S_028778_COLOR_DST_OPT(~0u)},
	{56079, S_028778_COLOR_COMB_FCN(~0u)},
	{56094, S_028778_ALPHA_SRC_OPT(~0u)},
	{56108, S_028778_ALPHA_DST_OPT(~0u)},
	{56122, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1503 */
	{55917, S_02877C_COLOR_SRC_OPT(~0u)},
	{55931, S_02877C_COLOR_DST_OPT(~0u)},
	{56079, S_02877C_COLOR_COMB_FCN(~0u)},
	{56094, S_02877C_ALPHA_SRC_OPT(~0u)},
	{56108, S_02877C_ALPHA_DST_OPT(~0u)},
	{56122, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1509 */
	{56531, S_028780_COLOR_SRCBLEND(~0u), 21, 33626},
	{56079, S_028780_COLOR_COMB_FCN(~0u), 5, 33647},
	{56636, S_028780_COLOR_DESTBLEND(~0u), 21, 33626},
	{56652, S_028780_ALPHA_SRCBLEND(~0u), 21, 33626},
	{56122, S_028780_ALPHA_COMB_FCN(~0u), 5, 33647},
	{56667, S_028780_ALPHA_DESTBLEND(~0u), 21, 33626},
	{56683, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{7682, S_028780_ENABLE(~0u)},
	{56704, S_028780_DISABLE_ROP3(~0u)},
	/* 1518 */
	{56717, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1519 */
	{56730, S_0287E4_BASE_ADDR_GFX6(~0u)},
	/* 1520 */
	{56823, S_0287F0_SOURCE_SELECT(~0u), 4, 33652},
	{56869, S_0287F0_MAJOR_MODE(~0u), 2, 33656},
	{56880, S_0287F0_NOT_EOP(~0u)},
	{56888, S_0287F0_USE_OPAQUE(~0u)},
	/* 1524 */
	{56899, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1525 */
	{56911, S_028800_STENCIL_ENABLE(~0u)},
	{48978, S_028800_Z_ENABLE(~0u)},
	{56926, S_028800_Z_WRITE_ENABLE(~0u)},
	{56941, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{49778, S_028800_ZFUNC(~0u), 8, 33658},
	{57056, S_028800_BACKFACE_ENABLE(~0u)},
	{57159, S_028800_STENCILFUNC(~0u), 8, 33666},
	{57171, S_028800_STENCILFUNC_BF(~0u), 8, 33666},
	{57186, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{57220, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1535 */
	{57255, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{57274, S_028804_PS_ITER_SAMPLES(~0u)},
	{57290, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{57314, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{57340, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{57367, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{57389, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{57408, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{57426, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{57453, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{57480, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{57505, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1547 */
	{57536, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{57554, S_028808_DEGAMMA_ENABLE(~0u)},
	{22318, S_028808_MODE(~0u), 7, 33674},
	{56712, S_028808_ROP3(~0u), 256, 33681},
	/* 1551 */
	{57864, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57880, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57911, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{49036, S_02880C_Z_ORDER(~0u), 4, 33937},
	{57990, S_02880C_KILL_ENABLE(~0u)},
	{58002, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{58026, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{58045, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{58063, S_02880C_EXEC_ON_NOOP(~0u)},
	{58076, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58098, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58188, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 33941},
	{58210, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1564 */
	{58228, S_028810_UCP_ENA_0(~0u)},
	{58238, S_028810_UCP_ENA_1(~0u)},
	{58248, S_028810_UCP_ENA_2(~0u)},
	{58258, S_028810_UCP_ENA_3(~0u)},
	{58268, S_028810_UCP_ENA_4(~0u)},
	{58278, S_028810_UCP_ENA_5(~0u)},
	{58288, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{58307, S_028810_PS_UCP_MODE(~0u)},
	{58319, S_028810_CLIP_DISABLE(~0u)},
	{58332, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{58350, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{58373, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{58391, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{58411, S_028810_VTX_KILL_OR(~0u)},
	{58423, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{58445, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{58469, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{58495, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{58514, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1583 */
	{58532, S_028814_CULL_FRONT(~0u)},
	{58543, S_028814_CULL_BACK(~0u)},
	{22859, S_028814_FACE(~0u)},
	{58563, S_028814_POLY_MODE(~0u), 2, 33945},
	{58629, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 33947},
	{58650, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 33947},
	{58670, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58695, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58719, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58743, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58768, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58787, S_028814_PERSP_CORR_DIS(~0u)},
	{58802, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1596 */
	{58820, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58838, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58857, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58875, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58894, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58912, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58931, S_028818_VTX_XY_FMT(~0u)},
	{58942, S_028818_VTX_Z_FMT(~0u)},
	{58952, S_028818_VTX_W0_FMT(~0u)},
	/* 1605 */
	{58963, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58979, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58995, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{59011, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{59027, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{59043, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{59059, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{59075, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{59091, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59107, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59123, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59139, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59155, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59171, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59187, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59203, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59219, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59238, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59256, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59283, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59305, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59323, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59343, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59366, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59389, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59414, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59434, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1632 */
	{59453, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{59472, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{59490, S_028820_VTE_W_INF_DISCARD(~0u)},
	{59508, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{59526, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{59544, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{59561, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{59578, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{59599, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{59616, S_028820_VS_XY_INF_RETAIN(~0u)},
	{59633, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{59649, S_028820_VS_Z_INF_RETAIN(~0u)},
	{59665, S_028820_VS_W_NAN_TO_INF(~0u)},
	{59681, S_028820_VS_W_INF_RETAIN(~0u)},
	{59697, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{59722, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1648 */
	{59742, S_028824_LINE_STIPPLE_RESET(~0u)},
	{59761, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{59780, S_028824_FRACTIONAL_ACCUM(~0u)},
	{59797, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1652 */
	{59812, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{59836, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{59856, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{59877, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{59902, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{59922, S_02882C_LINE_EXPAND_ENA(~0u)},
	{59938, S_02882C_POINT_EXPAND_ENA(~0u)},
	{59955, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{59976, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{59997, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{60018, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1663 */
	{60040, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{59812, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{59836, S_028830_LINE_FILTER_DISABLE(~0u)},
	{59856, S_028830_POINT_FILTER_DISABLE(~0u)},
	{59877, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1668 */
	{42195, S_028A00_HEIGHT(~0u)},
	{42189, S_028A00_WIDTH(~0u)},
	/* 1670 */
	{60065, S_028A04_MIN_SIZE(~0u)},
	{22554, S_028A04_MAX_SIZE(~0u)},
	/* 1672 */
	{42189, S_028A08_WIDTH(~0u)},
	/* 1673 */
	{60074, S_028A0C_LINE_PATTERN(~0u)},
	{60087, S_028A0C_REPEAT_COUNT(~0u)},
	{60100, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{60118, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1677 */
	{60239, S_028A10_PATH_SELECT(~0u), 5, 33950},
	/* 1678 */
	{60251, S_028A14_TESS_MODE(~0u)},
	/* 1679 */
	{22147, S_028A20_REUSE_DEPTH(~0u)},
	/* 1680 */
	{22169, S_028A24_PRIM_TYPE(~0u), 18, 33955},
	{60616, S_028A24_RETAIN_ORDER(~0u)},
	{60629, S_028A24_RETAIN_QUADS(~0u)},
	{60710, S_028A24_PRIM_ORDER(~0u), 5, 33973},
	/* 1684 */
	{22189, S_028A28_FIRST_DECR(~0u)},
	/* 1685 */
	{22195, S_028A2C_DECR(~0u)},
	/* 1686 */
	{60721, S_028A30_COMP_X_EN(~0u)},
	{60731, S_028A30_COMP_Y_EN(~0u)},
	{60741, S_028A30_COMP_Z_EN(~0u)},
	{60751, S_028A30_COMP_W_EN(~0u)},
	{23358, S_028A30_STRIDE(~0u)},
	{60761, S_028A30_SHIFT(~0u)},
	/* 1692 */
	{60721, S_028A34_COMP_X_EN(~0u)},
	{60731, S_028A34_COMP_Y_EN(~0u)},
	{60741, S_028A34_COMP_Z_EN(~0u)},
	{60751, S_028A34_COMP_W_EN(~0u)},
	{23358, S_028A34_STRIDE(~0u)},
	{60761, S_028A34_SHIFT(~0u)},
	/* 1698 */
	{60926, S_028A38_X_CONV(~0u), 9, 33978},
	{17746, S_028A38_X_OFFSET(~0u)},
	{60933, S_028A38_Y_CONV(~0u), 9, 33978},
	{50281, S_028A38_Y_OFFSET(~0u)},
	{60940, S_028A38_Z_CONV(~0u), 9, 33978},
	{60947, S_028A38_Z_OFFSET(~0u)},
	{60956, S_028A38_W_CONV(~0u), 9, 33978},
	{15806, S_028A38_W_OFFSET(~0u)},
	/* 1706 */
	{60926, S_028A3C_X_CONV(~0u), 9, 33978},
	{17746, S_028A3C_X_OFFSET(~0u)},
	{60933, S_028A3C_Y_CONV(~0u), 9, 33978},
	{50281, S_028A3C_Y_OFFSET(~0u)},
	{60940, S_028A3C_Z_CONV(~0u), 9, 33978},
	{60947, S_028A3C_Z_OFFSET(~0u)},
	{60956, S_028A3C_W_CONV(~0u), 9, 33978},
	{15806, S_028A3C_W_OFFSET(~0u)},
	/* 1714 */
	{22318, S_028A40_MODE(~0u), 6, 33987},
	{39336, S_028A40_RESERVED_0(~0u)},
	{61081, S_028A40_CUT_MODE(~0u), 4, 33993},
	{39354, S_028A40_RESERVED_1(~0u)},
	{61090, S_028A40_GS_C_PACK_EN(~0u)},
	{61103, S_028A40_RESERVED_2(~0u)},
	{61114, S_028A40_ES_PASSTHRU(~0u)},
	{61126, S_028A40_COMPUTE_MODE(~0u)},
	{61139, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{61157, S_028A40_ELEMENT_INFO_EN(~0u)},
	{61173, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61192, S_028A40_SUPPRESS_CUTS(~0u)},
	{61206, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61224, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61275, S_028A40_ONCHIP(~0u), 4, 33997},
	/* 1729 */
	{61282, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61302, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1731 */
	{61322, S_028A48_MSAA_ENABLE(~0u)},
	{61334, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61355, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61375, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1735 */
	{61400, S_028A4C_WALK_SIZE(~0u)},
	{61410, S_028A4C_WALK_ALIGNMENT(~0u)},
	{61425, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{61450, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{61468, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{61484, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{61489, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{61512, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{61531, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{61553, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{61569, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{61585, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{61601, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{61620, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{61646, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{61661, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{61701, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{61728, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{61751, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{61767, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{61797, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{61821, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{61842, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{61872, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1759 */
	{22394, S_028A54_GS_PER_ES(~0u)},
	/* 1760 */
	{22408, S_028A58_ES_PER_GS(~0u)},
	/* 1761 */
	{22422, S_028A5C_GS_PER_VS(~0u)},
	/* 1762 */
	{669, S_028A60_OFFSET(~0u)},
	/* 1763 */
	{669, S_028A64_OFFSET(~0u)},
	/* 1764 */
	{669, S_028A68_OFFSET(~0u)},
	/* 1765 */
	{61964, S_028A6C_OUTPRIM_TYPE(~0u), 3, 34001},
	{61977, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{61992, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{62007, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{62022, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1770 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 34004},
	{62159, S_028A7C_SWAP_MODE(~0u), 4, 34007},
	{62220, S_028A7C_BUF_TYPE(~0u), 3, 34011},
	{62262, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 34014},
	{62279, S_028A7C_RDREQ_POLICY(~0u)},
	{40060, S_028A7C_ATC(~0u)},
	{56880, S_028A7C_NOT_EOP(~0u)},
	{62292, S_028A7C_REQ_PATH(~0u)},
	{40081, S_028A7C_MTYPE(~0u)},
	/* 1779 */
	{22597, S_028A84_PRIMITIVEID_EN(~0u)},
	{62301, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1781 */
	{63257, S_028A90_EVENT_TYPE(~0u), 59, 34016},
	{63268, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{63284, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1784 */
	{22694, S_028A94_RESET_EN(~0u)},
	/* 1785 */
	{63299, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{63314, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{63333, S_028AA8_SWITCH_ON_EOP(~0u)},
	{63347, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{63366, S_028AA8_SWITCH_ON_EOI(~0u)},
	{63380, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{63397, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1792 */
	{22786, S_028AAC_ITEMSIZE(~0u)},
	/* 1793 */
	{22786, S_028AB0_ITEMSIZE(~0u)},
	/* 1794 */
	{22822, S_028AB4_REUSE_OFF(~0u)},
	/* 1795 */
	{22836, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1796 */
	{43485, S_028ABC_LINEAR(~0u)},
	{63417, S_028ABC_FULL_CACHE(~0u)},
	{63428, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63451, S_028ABC_PRELOAD(~0u)},
	{63459, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63474, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63490, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{63514, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1804 */
	{63528, S_028AC0_COMPAREFUNC0(~0u), 8, 33666},
	{63541, S_028AC0_COMPAREVALUE0(~0u)},
	{63555, S_028AC0_COMPAREMASK0(~0u)},
	{48997, S_028AC0_ENABLE0(~0u)},
	/* 1808 */
	{63568, S_028AC4_COMPAREFUNC1(~0u), 8, 33666},
	{63581, S_028AC4_COMPAREVALUE1(~0u)},
	{63595, S_028AC4_COMPAREMASK1(~0u)},
	{49015, S_028AC4_ENABLE1(~0u)},
	/* 1812 */
	{7538, S_028AC8_START_X(~0u)},
	{7554, S_028AC8_START_Y(~0u)},
	{63608, S_028AC8_MAX_X(~0u)},
	{63614, S_028AC8_MAX_Y(~0u)},
	/* 1816 */
	{23358, S_028AD4_STRIDE(~0u)},
	/* 1817 */
	{23358, S_028AE4_STRIDE(~0u)},
	/* 1818 */
	{23358, S_028AF4_STRIDE(~0u)},
	/* 1819 */
	{23358, S_028B04_STRIDE(~0u)},
	/* 1820 */
	{23351, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1821 */
	{23372, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1822 */
	{63620, S_028B50_ACCUM_ISOLINE(~0u)},
	{63634, S_028B50_ACCUM_TRI(~0u)},
	{63644, S_028B50_ACCUM_QUAD(~0u)},
	{63655, S_028B50_DONUT_SPLIT(~0u)},
	{63667, S_028B50_TRAP_SPLIT(~0u)},
	/* 1827 */
	{48181, S_028B54_LS_EN(~0u), 3, 34075},
	{48175, S_028B54_HS_EN(~0u)},
	{23422, S_028B54_ES_EN(~0u), 3, 34078},
	{48169, S_028B54_GS_EN(~0u)},
	{48163, S_028B54_VS_EN(~0u), 3, 34081},
	{63801, S_028B54_DYNAMIC_HS(~0u)},
	{46756, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63812, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63832, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63852, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1837 */
	{63866, S_028B58_NUM_PATCHES(~0u)},
	{63878, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{63894, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1840 */
	{22786, S_028B5C_ITEMSIZE(~0u)},
	/* 1841 */
	{22786, S_028B60_ITEMSIZE(~0u)},
	/* 1842 */
	{22786, S_028B64_ITEMSIZE(~0u)},
	/* 1843 */
	{22786, S_028B68_ITEMSIZE(~0u)},
	/* 1844 */
	{209, S_028B6C_TYPE(~0u), 3, 34084},
	{64000, S_028B6C_PARTITIONING(~0u), 4, 34087},
	{64077, S_028B6C_TOPOLOGY(~0u), 4, 34091},
	{64086, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64106, S_028B6C_DEPRECATED(~0u)},
	{64117, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{64139, S_028B6C_DISABLE_DONUTS(~0u)},
	{62262, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 34095},
	{62279, S_028B6C_RDREQ_POLICY(~0u)},
	{64278, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 34098},
	{40081, S_028B6C_MTYPE(~0u)},
	/* 1855 */
	{64296, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{64317, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{64339, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{64361, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{64383, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{64405, S_028B70_OFFSET_ROUND(~0u)},
	/* 1861 */
	{64418, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{64446, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1863 */
	{7682, S_028B90_ENABLE(~0u)},
	{23779, S_028B90_CNT(~0u)},
	/* 1865 */
	{64474, S_028B94_STREAMOUT_0_EN(~0u)},
	{64489, S_028B94_STREAMOUT_1_EN(~0u)},
	{64504, S_028B94_STREAMOUT_2_EN(~0u)},
	{64519, S_028B94_STREAMOUT_3_EN(~0u)},
	{64534, S_028B94_RAST_STREAM(~0u)},
	{64546, S_028B94_RAST_STREAM_MASK(~0u)},
	{64563, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1872 */
	{64584, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{64603, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{64622, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{64641, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1876 */
	{64660, S_028BD4_DISTANCE_0(~0u)},
	{64671, S_028BD4_DISTANCE_1(~0u)},
	{64682, S_028BD4_DISTANCE_2(~0u)},
	{64693, S_028BD4_DISTANCE_3(~0u)},
	{64704, S_028BD4_DISTANCE_4(~0u)},
	{64715, S_028BD4_DISTANCE_5(~0u)},
	{64726, S_028BD4_DISTANCE_6(~0u)},
	{64737, S_028BD4_DISTANCE_7(~0u)},
	/* 1884 */
	{64748, S_028BD8_DISTANCE_8(~0u)},
	{64759, S_028BD8_DISTANCE_9(~0u)},
	{64770, S_028BD8_DISTANCE_10(~0u)},
	{64782, S_028BD8_DISTANCE_11(~0u)},
	{64794, S_028BD8_DISTANCE_12(~0u)},
	{64806, S_028BD8_DISTANCE_13(~0u)},
	{64818, S_028BD8_DISTANCE_14(~0u)},
	{64830, S_028BD8_DISTANCE_15(~0u)},
	/* 1892 */
	{64842, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{64860, S_028BDC_LAST_PIXEL(~0u)},
	{64871, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{64896, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1896 */
	{64918, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64935, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64957, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64973, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64994, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1901 */
	{65017, S_028BE4_PIX_CENTER(~0u)},
	{65078, S_028BE4_ROUND_MODE(~0u), 4, 34102},
	{65294, S_028BE4_QUANT_MODE(~0u), 8, 34106},
	/* 1904 */
	{65305, S_028BF8_S0_X(~0u)},
	{65310, S_028BF8_S0_Y(~0u)},
	{65315, S_028BF8_S1_X(~0u)},
	{65320, S_028BF8_S1_Y(~0u)},
	{65325, S_028BF8_S2_X(~0u)},
	{65330, S_028BF8_S2_Y(~0u)},
	{65335, S_028BF8_S3_X(~0u)},
	{65340, S_028BF8_S3_Y(~0u)},
	/* 1912 */
	{65345, S_028BFC_S4_X(~0u)},
	{65350, S_028BFC_S4_Y(~0u)},
	{65355, S_028BFC_S5_X(~0u)},
	{65360, S_028BFC_S5_Y(~0u)},
	{65365, S_028BFC_S6_X(~0u)},
	{65370, S_028BFC_S6_Y(~0u)},
	{65375, S_028BFC_S7_X(~0u)},
	{65380, S_028BFC_S7_Y(~0u)},
	/* 1920 */
	{65385, S_028C00_S8_X(~0u)},
	{65390, S_028C00_S8_Y(~0u)},
	{65395, S_028C00_S9_X(~0u)},
	{65400, S_028C00_S9_Y(~0u)},
	{65405, S_028C00_S10_X(~0u)},
	{65411, S_028C00_S10_Y(~0u)},
	{65417, S_028C00_S11_X(~0u)},
	{65423, S_028C00_S11_Y(~0u)},
	/* 1928 */
	{65429, S_028C04_S12_X(~0u)},
	{65435, S_028C04_S12_Y(~0u)},
	{65441, S_028C04_S13_X(~0u)},
	{65447, S_028C04_S13_Y(~0u)},
	{65453, S_028C04_S14_X(~0u)},
	{65459, S_028C04_S14_Y(~0u)},
	{65465, S_028C04_S15_X(~0u)},
	{65471, S_028C04_S15_Y(~0u)},
	/* 1936 */
	{65305, S_028C08_S0_X(~0u)},
	{65310, S_028C08_S0_Y(~0u)},
	{65315, S_028C08_S1_X(~0u)},
	{65320, S_028C08_S1_Y(~0u)},
	{65325, S_028C08_S2_X(~0u)},
	{65330, S_028C08_S2_Y(~0u)},
	{65335, S_028C08_S3_X(~0u)},
	{65340, S_028C08_S3_Y(~0u)},
	/* 1944 */
	{65345, S_028C0C_S4_X(~0u)},
	{65350, S_028C0C_S4_Y(~0u)},
	{65355, S_028C0C_S5_X(~0u)},
	{65360, S_028C0C_S5_Y(~0u)},
	{65365, S_028C0C_S6_X(~0u)},
	{65370, S_028C0C_S6_Y(~0u)},
	{65375, S_028C0C_S7_X(~0u)},
	{65380, S_028C0C_S7_Y(~0u)},
	/* 1952 */
	{65385, S_028C10_S8_X(~0u)},
	{65390, S_028C10_S8_Y(~0u)},
	{65395, S_028C10_S9_X(~0u)},
	{65400, S_028C10_S9_Y(~0u)},
	{65405, S_028C10_S10_X(~0u)},
	{65411, S_028C10_S10_Y(~0u)},
	{65417, S_028C10_S11_X(~0u)},
	{65423, S_028C10_S11_Y(~0u)},
	/* 1960 */
	{65429, S_028C14_S12_X(~0u)},
	{65435, S_028C14_S12_Y(~0u)},
	{65441, S_028C14_S13_X(~0u)},
	{65447, S_028C14_S13_Y(~0u)},
	{65453, S_028C14_S14_X(~0u)},
	{65459, S_028C14_S14_Y(~0u)},
	{65465, S_028C14_S15_X(~0u)},
	{65471, S_028C14_S15_Y(~0u)},
	/* 1968 */
	{65305, S_028C18_S0_X(~0u)},
	{65310, S_028C18_S0_Y(~0u)},
	{65315, S_028C18_S1_X(~0u)},
	{65320, S_028C18_S1_Y(~0u)},
	{65325, S_028C18_S2_X(~0u)},
	{65330, S_028C18_S2_Y(~0u)},
	{65335, S_028C18_S3_X(~0u)},
	{65340, S_028C18_S3_Y(~0u)},
	/* 1976 */
	{65345, S_028C1C_S4_X(~0u)},
	{65350, S_028C1C_S4_Y(~0u)},
	{65355, S_028C1C_S5_X(~0u)},
	{65360, S_028C1C_S5_Y(~0u)},
	{65365, S_028C1C_S6_X(~0u)},
	{65370, S_028C1C_S6_Y(~0u)},
	{65375, S_028C1C_S7_X(~0u)},
	{65380, S_028C1C_S7_Y(~0u)},
	/* 1984 */
	{65385, S_028C20_S8_X(~0u)},
	{65390, S_028C20_S8_Y(~0u)},
	{65395, S_028C20_S9_X(~0u)},
	{65400, S_028C20_S9_Y(~0u)},
	{65405, S_028C20_S10_X(~0u)},
	{65411, S_028C20_S10_Y(~0u)},
	{65417, S_028C20_S11_X(~0u)},
	{65423, S_028C20_S11_Y(~0u)},
	/* 1992 */
	{65429, S_028C24_S12_X(~0u)},
	{65435, S_028C24_S12_Y(~0u)},
	{65441, S_028C24_S13_X(~0u)},
	{65447, S_028C24_S13_Y(~0u)},
	{65453, S_028C24_S14_X(~0u)},
	{65459, S_028C24_S14_Y(~0u)},
	{65465, S_028C24_S15_X(~0u)},
	{65471, S_028C24_S15_Y(~0u)},
	/* 2000 */
	{65305, S_028C28_S0_X(~0u)},
	{65310, S_028C28_S0_Y(~0u)},
	{65315, S_028C28_S1_X(~0u)},
	{65320, S_028C28_S1_Y(~0u)},
	{65325, S_028C28_S2_X(~0u)},
	{65330, S_028C28_S2_Y(~0u)},
	{65335, S_028C28_S3_X(~0u)},
	{65340, S_028C28_S3_Y(~0u)},
	/* 2008 */
	{65345, S_028C2C_S4_X(~0u)},
	{65350, S_028C2C_S4_Y(~0u)},
	{65355, S_028C2C_S5_X(~0u)},
	{65360, S_028C2C_S5_Y(~0u)},
	{65365, S_028C2C_S6_X(~0u)},
	{65370, S_028C2C_S6_Y(~0u)},
	{65375, S_028C2C_S7_X(~0u)},
	{65380, S_028C2C_S7_Y(~0u)},
	/* 2016 */
	{65385, S_028C30_S8_X(~0u)},
	{65390, S_028C30_S8_Y(~0u)},
	{65395, S_028C30_S9_X(~0u)},
	{65400, S_028C30_S9_Y(~0u)},
	{65405, S_028C30_S10_X(~0u)},
	{65411, S_028C30_S10_Y(~0u)},
	{65417, S_028C30_S11_X(~0u)},
	{65423, S_028C30_S11_Y(~0u)},
	/* 2024 */
	{65429, S_028C34_S12_X(~0u)},
	{65435, S_028C34_S12_Y(~0u)},
	{65441, S_028C34_S13_X(~0u)},
	{65447, S_028C34_S13_Y(~0u)},
	{65453, S_028C34_S14_X(~0u)},
	{65459, S_028C34_S14_Y(~0u)},
	{65465, S_028C34_S15_X(~0u)},
	{65471, S_028C34_S15_Y(~0u)},
	/* 2032 */
	{65477, S_028C38_AA_MASK_X0Y0(~0u)},
	{65490, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2034 */
	{65503, S_028C3C_AA_MASK_X0Y1(~0u)},
	{65516, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2036 */
	{65529, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2037 */
	{65558, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2038 */
	{65574, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2039 */
	{50218, S_028C64_TILE_MAX(~0u)},
	{65587, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2041 */
	{50218, S_028C68_TILE_MAX(~0u)},
	/* 2042 */
	{48866, S_028C6C_SLICE_START(~0u)},
	{48878, S_028C6C_SLICE_MAX(~0u)},
	/* 2044 */
	{65653, S_028C70_ENDIAN(~0u), 4, 34114},
	{21171, S_028C70_FORMAT(~0u), 23, 34118},
	{45145, S_028C70_LINEAR_GENERAL(~0u)},
	{66020, S_028C70_NUMBER_TYPE(~0u), 8, 34141},
	{66076, S_028C70_COMP_SWAP(~0u), 4, 34149},
	{57603, S_028C70_FAST_CLEAR(~0u)},
	{49452, S_028C70_COMPRESSION(~0u)},
	{66086, S_028C70_BLEND_CLAMP(~0u)},
	{66098, S_028C70_BLEND_BYPASS(~0u)},
	{66111, S_028C70_SIMPLE_FLOAT(~0u)},
	{65078, S_028C70_ROUND_MODE(~0u)},
	{66124, S_028C70_CMASK_IS_LINEAR(~0u)},
	{66351, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 34153},
	{66373, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 34153},
	{66397, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66423, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66449, S_028C70_DCC_ENABLE(~0u)},
	{66460, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2062 */
	{50046, S_028C74_TILE_MODE_INDEX(~0u)},
	{66476, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{66498, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{50034, S_028C74_NUM_SAMPLES(~0u)},
	{66516, S_028C74_NUM_FRAGMENTS(~0u)},
	{66530, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2068 */
	{52670, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{66548, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{66624, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u), 3, 34161},
	{66690, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u), 2, 34164},
	{66716, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{42676, S_028C78_COLOR_TRANSFORM(~0u)},
	{66742, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{66765, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{66785, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2077 */
	{50218, S_028C80_TILE_MAX(~0u)},
	/* 2078 */
	{50218, S_028C88_TILE_MAX(~0u)},
	/* 2079 */
	{33153, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33176, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33199, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33222, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33242, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33262, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33282, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33302, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33322, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33342, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33362, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33382, S_008008_RLC_RQ_PENDING(~0u)},
	{66807, S_008008_UTCL2_BUSY(~0u)},
	{66818, S_008008_EA_BUSY(~0u)},
	{66826, S_008008_RMI_BUSY(~0u)},
	{66835, S_008008_UTCL2_RQ_PENDING(~0u)},
	{66852, S_008008_CPF_RQ_PENDING(~0u)},
	{66867, S_008008_EA_LINK_BUSY(~0u)},
	{33397, S_008008_RLC_BUSY(~0u)},
	{33406, S_008008_TC_BUSY(~0u)},
	{33414, S_008008_TCC_CC_RESIDENT(~0u)},
	{33430, S_008008_CPF_BUSY(~0u)},
	{33439, S_008008_CPC_BUSY(~0u)},
	{33448, S_008008_CPG_BUSY(~0u)},
	{66880, S_008008_CPAXI_BUSY(~0u)},
	/* 2104 */
	{33457, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{66891, S_008010_RSMU_RQ_PENDING(~0u)},
	{33496, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33519, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33542, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33561, S_008010_DB_CLEAN(~0u)},
	{33570, S_008010_CB_CLEAN(~0u)},
	{33579, S_008010_TA_BUSY(~0u)},
	{33587, S_008010_GDS_BUSY(~0u)},
	{33596, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33611, S_008010_VGT_BUSY(~0u)},
	{33620, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33635, S_008010_IA_BUSY(~0u)},
	{33643, S_008010_SX_BUSY(~0u)},
	{33651, S_008010_WD_BUSY(~0u)},
	{33659, S_008010_SPI_BUSY(~0u)},
	{33668, S_008010_BCI_BUSY(~0u)},
	{33677, S_008010_SC_BUSY(~0u)},
	{33685, S_008010_PA_BUSY(~0u)},
	{33693, S_008010_DB_BUSY(~0u)},
	{33701, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32264, S_008010_CP_BUSY(~0u)},
	{32486, S_008010_CB_BUSY(~0u)},
	{33719, S_008010_GUI_ACTIVE(~0u)},
	/* 2128 */
	{33561, S_008014_DB_CLEAN(~0u)},
	{33570, S_008014_CB_CLEAN(~0u)},
	{66826, S_008014_RMI_BUSY(~0u)},
	{33668, S_008014_BCI_BUSY(~0u)},
	{33611, S_008014_VGT_BUSY(~0u)},
	{33685, S_008014_PA_BUSY(~0u)},
	{33579, S_008014_TA_BUSY(~0u)},
	{33643, S_008014_SX_BUSY(~0u)},
	{33659, S_008014_SPI_BUSY(~0u)},
	{33677, S_008014_SC_BUSY(~0u)},
	{33693, S_008014_DB_BUSY(~0u)},
	{32486, S_008014_CB_BUSY(~0u)},
	/* 2140 */
	{33561, S_008018_DB_CLEAN(~0u)},
	{33570, S_008018_CB_CLEAN(~0u)},
	{66826, S_008018_RMI_BUSY(~0u)},
	{33668, S_008018_BCI_BUSY(~0u)},
	{33611, S_008018_VGT_BUSY(~0u)},
	{33685, S_008018_PA_BUSY(~0u)},
	{33579, S_008018_TA_BUSY(~0u)},
	{33643, S_008018_SX_BUSY(~0u)},
	{33659, S_008018_SPI_BUSY(~0u)},
	{33677, S_008018_SC_BUSY(~0u)},
	{33693, S_008018_DB_BUSY(~0u)},
	{32486, S_008018_CB_BUSY(~0u)},
	/* 2152 */
	{33561, S_008038_DB_CLEAN(~0u)},
	{33570, S_008038_CB_CLEAN(~0u)},
	{66826, S_008038_RMI_BUSY(~0u)},
	{33668, S_008038_BCI_BUSY(~0u)},
	{33611, S_008038_VGT_BUSY(~0u)},
	{33685, S_008038_PA_BUSY(~0u)},
	{33579, S_008038_TA_BUSY(~0u)},
	{33643, S_008038_SX_BUSY(~0u)},
	{33659, S_008038_SPI_BUSY(~0u)},
	{33677, S_008038_SC_BUSY(~0u)},
	{33693, S_008038_DB_BUSY(~0u)},
	{32486, S_008038_CB_BUSY(~0u)},
	/* 2164 */
	{33561, S_00803C_DB_CLEAN(~0u)},
	{33570, S_00803C_CB_CLEAN(~0u)},
	{66826, S_00803C_RMI_BUSY(~0u)},
	{33668, S_00803C_BCI_BUSY(~0u)},
	{33611, S_00803C_VGT_BUSY(~0u)},
	{33685, S_00803C_PA_BUSY(~0u)},
	{33579, S_00803C_TA_BUSY(~0u)},
	{33643, S_00803C_SX_BUSY(~0u)},
	{33659, S_00803C_SPI_BUSY(~0u)},
	{33677, S_00803C_SC_BUSY(~0u)},
	{33693, S_00803C_DB_BUSY(~0u)},
	{32486, S_00803C_CB_BUSY(~0u)},
	/* 2176 */
	{34227, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{66907, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{66924, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	{34244, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34282, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34073, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34089, S_0301F0_TC_ACTION_ENA(~0u)},
	{34103, S_0301F0_CB_ACTION_ENA(~0u)},
	{34117, S_0301F0_DB_ACTION_ENA(~0u)},
	{34131, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34299, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34152, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34324, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	/* 2189 */
	{34383, S_0301FC_MEID(~0u)},
	{1044, S_0301FC_STATUS(~0u)},
	/* 2191 */
	{34402, S_008210_MEC1_BUSY(~0u)},
	{34412, S_008210_MEC2_BUSY(~0u)},
	{34422, S_008210_DC0_BUSY(~0u)},
	{34431, S_008210_DC1_BUSY(~0u)},
	{34440, S_008210_RCIU1_BUSY(~0u)},
	{34451, S_008210_RCIU2_BUSY(~0u)},
	{34462, S_008210_ROQ1_BUSY(~0u)},
	{34472, S_008210_ROQ2_BUSY(~0u)},
	{34482, S_008210_TCIU_BUSY(~0u)},
	{34492, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34509, S_008210_QU_BUSY(~0u)},
	{66951, S_008210_UTCL2IU_BUSY(~0u)},
	{66964, S_008210_SAVE_RESTORE_BUSY(~0u)},
	{34530, S_008210_CPG_CPC_BUSY(~0u)},
	{34543, S_008210_CPF_CPC_BUSY(~0u)},
	{33439, S_008210_CPC_BUSY(~0u)},
	/* 2207 */
	{35040, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35059, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35079, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35098, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35119, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35137, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35160, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35182, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35203, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35221, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35244, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{66982, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{67006, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{67030, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2221 */
	{35337, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35356, S_00821C_CSF_BUSY(~0u)},
	{35365, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35380, S_00821C_ROQ_RING_BUSY(~0u)},
	{35394, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35413, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35432, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35447, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35464, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35486, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35508, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35523, S_00821C_INTERRUPT_BUSY(~0u)},
	{34482, S_00821C_TCIU_BUSY(~0u)},
	{35538, S_00821C_HQD_BUSY(~0u)},
	{35547, S_00821C_PRT_BUSY(~0u)},
	{66951, S_00821C_UTCL2IU_BUSY(~0u)},
	{35556, S_00821C_CPF_GFX_BUSY(~0u)},
	{35569, S_00821C_CPF_CMP_BUSY(~0u)},
	{35582, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35601, S_00821C_CPC_CPF_BUSY(~0u)},
	{33430, S_00821C_CPF_BUSY(~0u)},
	/* 2242 */
	{36189, S_008224_RING_FETCHING_DATA(~0u)},
	{36208, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36228, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36248, S_008224_STATE_FETCHING_DATA(~0u)},
	{36268, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36289, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{66982, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{67006, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{67053, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{67080, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{67107, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 2253 */
	{37079, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37104, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37142, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37183, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37206, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37229, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37253, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37283, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37312, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37338, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37367, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37392, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36268, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36289, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37427, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37455, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{66982, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{67006, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{67030, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2272 */
	{35380, S_008680_ROQ_RING_BUSY(~0u)},
	{35394, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35413, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35432, S_008680_ROQ_STATE_BUSY(~0u)},
	{38685, S_008680_DC_BUSY(~0u)},
	{66951, S_008680_UTCL2IU_BUSY(~0u)},
	{38693, S_008680_PFP_BUSY(~0u)},
	{38702, S_008680_MEQ_BUSY(~0u)},
	{38711, S_008680_ME_BUSY(~0u)},
	{38719, S_008680_QUERY_BUSY(~0u)},
	{35508, S_008680_SEMAPHORE_BUSY(~0u)},
	{35523, S_008680_INTERRUPT_BUSY(~0u)},
	{38730, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32188, S_008680_DMA_BUSY(~0u)},
	{38748, S_008680_RCIU_BUSY(~0u)},
	{34492, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38771, S_008680_CE_BUSY(~0u)},
	{34482, S_008680_TCIU_BUSY(~0u)},
	{35447, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35464, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35486, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32264, S_008680_CP_BUSY(~0u)},
	/* 2294 */
	{22169, S_030908_PRIM_TYPE(~0u), 29, 26},
	/* 2295 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	{67128, S_03090C_PRIMGEN_EN(~0u)},
	/* 2297 */
	{22694, S_03092C_RESET_EN(~0u)},
	{67139, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2299 */
	{36958, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38827, S_03093C_OFFCHIP_GRANULARITY(~0u)},
	/* 2301 */
	{919, S_030944_BASE_HI(~0u)},
	/* 2302 */
	{919, S_03094C_BASE_HI(~0u)},
	/* 2303 */
	{919, S_030954_BASE_HI(~0u)},
	/* 2304 */
	{919, S_03095C_BASE_HI(~0u)},
	/* 2305 */
	{63299, S_030960_PRIMGROUP_SIZE(~0u)},
	{63314, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{63333, S_030960_SWITCH_ON_EOP(~0u)},
	{63347, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{63366, S_030960_SWITCH_ON_EOI(~0u)},
	{63380, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{67154, S_030960_EN_INST_OPT_BASIC(~0u)},
	{67172, S_030960_EN_INST_OPT_ADV(~0u)},
	{67188, S_030960_HW_USE_ONLY(~0u)},
	/* 2314 */
	{67200, S_030D20_TARGET_INST(~0u)},
	{67212, S_030D20_TARGET_DATA(~0u)},
	{39101, S_030D20_INVALIDATE(~0u)},
	{26885, S_030D20_WRITEBACK(~0u)},
	{46974, S_030D20_VOL(~0u)},
	{67224, S_030D20_COMPLETE(~0u)},
	/* 2320 */
	{67233, S_030D24_DWB(~0u)},
	{49383, S_030D24_DIRTY(~0u)},
	/* 2322 */
	{39401, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39411, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39421, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39431, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39615, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{40007, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{67237, S_008F0C_USER_VM_ENABLE(~0u)},
	{67252, S_008F0C_USER_VM_MODE(~0u)},
	{40032, S_008F0C_INDEX_STRIDE(~0u)},
	{40045, S_008F0C_ADD_TID_ENABLE(~0u)},
	{60930, S_008F0C_NV(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 2334 */
	{39266, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40156, S_008F14_MIN_LOD(~0u)},
	{67837, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 34166},
	{67930, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 34230},
	{68165, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 34241},
	{68415, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 34254},
	{68614, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 34268},
	{60930, S_008F14_NV(~0u)},
	{68633, S_008F14_META_DIRECT(~0u)},
	/* 2343 */
	{39401, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39411, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39421, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39431, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42222, S_008F1C_BASE_LEVEL(~0u)},
	{42233, S_008F1C_LAST_LEVEL(~0u)},
	{68645, S_008F1C_SW_MODE(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 2351 */
	{22153, S_008F20_DEPTH(~0u)},
	{68653, S_008F20_PITCH_GFX9(~0u)},
	{68760, S_008F20_BC_SWIZZLE(~0u), 6, 34278},
	/* 2354 */
	{42579, S_008F24_BASE_ARRAY(~0u)},
	{68771, S_008F24_ARRAY_PITCH(~0u)},
	{68783, S_008F24_META_DATA_ADDRESS(~0u)},
	{68801, S_008F24_META_LINEAR(~0u)},
	{68813, S_008F24_META_PIPE_ALIGNED(~0u)},
	{68831, S_008F24_META_RB_ALIGNED(~0u)},
	{68847, S_008F24_MAX_MIP(~0u)},
	/* 2361 */
	{43421, S_008F38_LOD_BIAS(~0u)},
	{43430, S_008F38_LOD_BIAS_SEC(~0u)},
	{43492, S_008F38_XY_MAG_FILTER(~0u), 2, 337},
	{43567, S_008F38_XY_MIN_FILTER(~0u), 4, 339},
	{43647, S_008F38_Z_FILTER(~0u), 3, 343},
	{43656, S_008F38_MIP_FILTER(~0u), 3, 343},
	{43667, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{68855, S_008F38_BLEND_ZERO_PRT(~0u)},
	{43703, S_008F38_FILTER_PREC_FIX(~0u)},
	{43719, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 2371 */
	{43734, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{68870, S_008F3C_SKIP_DEGAMMA(~0u)},
	{43893, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 346},
	/* 2374 */
	{44244, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{44263, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{44282, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44304, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44326, S_031100_RSRC_MGMT_RESET(~0u)},
	{68883, S_031100_TTRACE_STALL_ALL(~0u)},
	{68900, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{68918, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{68934, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2383 */
	{44595, S_031104_VTX_DONE_DELAY(~0u), 16, 351},
	{44610, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{68955, S_031104_BATON_RESET_DISABLE(~0u)},
	{44634, S_031104_PC_LIMIT_ENABLE(~0u)},
	{44650, S_031104_PC_LIMIT_STRICT(~0u)},
	{68975, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{69001, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{69018, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{69034, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{69055, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{44666, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2394 */
	{69076, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{69117, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2396 */
	{44842, S_0098F8_NUM_PIPES(~0u)},
	{69156, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{69182, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{44878, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{46329, S_0098F8_NUM_BANKS(~0u)},
	{44923, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{69203, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{69227, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{44961, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{69241, S_0098F8_NUM_RB_PER_SE(~0u)},
	{44981, S_0098F8_ROW_SIZE(~0u)},
	{44990, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{69255, S_0098F8_SE_ENABLE(~0u)},
	/* 2409 */
	{45368, S_009910_ARRAY_MODE(~0u), 16, 371},
	{45730, S_009910_PIPE_CONFIG(~0u), 15, 387},
	{45920, S_009910_TILE_SPLIT(~0u), 7, 402},
	{46370, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 425},
	{46390, S_009910_SAMPLE_SPLIT(~0u)},
	/* 2414 */
	{43999, S_00B01C_CU_EN(~0u)},
	{46412, S_00B01C_WAVE_LIMIT(~0u)},
	{46423, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{69265, S_00B01C_SIMD_DISABLE(~0u)},
	/* 2418 */
	{46442, S_00B028_VGPRS(~0u)},
	{46448, S_00B028_SGPRS(~0u)},
	{2715, S_00B028_PRIORITY(~0u)},
	{46497, S_00B028_FLOAT_MODE(~0u), 241, 429},
	{46508, S_00B028_PRIV(~0u)},
	{46513, S_00B028_DX10_CLAMP(~0u)},
	{46524, S_00B028_DEBUG_MODE(~0u)},
	{46535, S_00B028_IEEE_MODE(~0u)},
	{46545, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46572, S_00B028_CDBG_USER(~0u)},
	{69278, S_00B028_FP16_OVFL(~0u)},
	/* 2429 */
	{46582, S_00B02C_SCRATCH_EN(~0u)},
	{46593, S_00B02C_USER_SGPR(~0u)},
	{46603, S_00B02C_TRAP_PRESENT(~0u)},
	{46616, S_00B02C_WAVE_CNT_EN(~0u)},
	{46628, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46654, S_00B02C_EXCP_EN(~0u)},
	{69288, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{69310, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{69335, S_00B02C_SKIP_USGPR0(~0u)},
	{69347, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 2439 */
	{43999, S_00B118_CU_EN(~0u)},
	{46412, S_00B118_WAVE_LIMIT(~0u)},
	{46423, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{69265, S_00B118_SIMD_DISABLE(~0u)},
	/* 2443 */
	{46442, S_00B128_VGPRS(~0u)},
	{46448, S_00B128_SGPRS(~0u)},
	{2715, S_00B128_PRIORITY(~0u)},
	{46497, S_00B128_FLOAT_MODE(~0u)},
	{46508, S_00B128_PRIV(~0u)},
	{46513, S_00B128_DX10_CLAMP(~0u)},
	{46524, S_00B128_DEBUG_MODE(~0u)},
	{46535, S_00B128_IEEE_MODE(~0u)},
	{46662, S_00B128_VGPR_COMP_CNT(~0u)},
	{46676, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46572, S_00B128_CDBG_USER(~0u)},
	{69278, S_00B128_FP16_OVFL(~0u)},
	/* 2455 */
	{46582, S_00B12C_SCRATCH_EN(~0u)},
	{46593, S_00B12C_USER_SGPR(~0u)},
	{46603, S_00B12C_TRAP_PRESENT(~0u)},
	{46692, S_00B12C_OC_LDS_EN(~0u)},
	{46702, S_00B12C_SO_BASE0_EN(~0u)},
	{46714, S_00B12C_SO_BASE1_EN(~0u)},
	{46726, S_00B12C_SO_BASE2_EN(~0u)},
	{46738, S_00B12C_SO_BASE3_EN(~0u)},
	{46750, S_00B12C_SO_EN(~0u)},
	{46654, S_00B12C_EXCP_EN(~0u)},
	{69361, S_00B12C_PC_BASE_EN(~0u)},
	{46756, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{69335, S_00B12C_SKIP_USGPR0(~0u)},
	{69347, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 2469 */
	{46582, S_00B1F0_SCRATCH_EN(~0u)},
	{46593, S_00B1F0_USER_SGPR(~0u)},
	{46603, S_00B1F0_TRAP_PRESENT(~0u)},
	{46654, S_00B1F0_EXCP_EN(~0u)},
	{46662, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{46692, S_00B1F0_OC_LDS_EN(~0u)},
	{46634, S_00B1F0_LDS_SIZE(~0u)},
	{69335, S_00B1F0_SKIP_USGPR0(~0u)},
	{69347, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2478 */
	{46773, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{69372, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2480 */
	{46403, S_00B214_MEM_BASE(~0u)},
	/* 2481 */
	{43999, S_00B21C_CU_EN(~0u)},
	{46412, S_00B21C_WAVE_LIMIT(~0u)},
	{46423, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{69265, S_00B21C_SIMD_DISABLE(~0u)},
	/* 2485 */
	{46442, S_00B228_VGPRS(~0u)},
	{46448, S_00B228_SGPRS(~0u)},
	{2715, S_00B228_PRIORITY(~0u)},
	{46497, S_00B228_FLOAT_MODE(~0u)},
	{46508, S_00B228_PRIV(~0u)},
	{46513, S_00B228_DX10_CLAMP(~0u)},
	{46524, S_00B228_DEBUG_MODE(~0u)},
	{46535, S_00B228_IEEE_MODE(~0u)},
	{46676, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46572, S_00B228_CDBG_USER(~0u)},
	{69397, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{69278, S_00B228_FP16_OVFL(~0u)},
	/* 2497 */
	{46582, S_00B22C_SCRATCH_EN(~0u)},
	{46593, S_00B22C_USER_SGPR(~0u)},
	{46603, S_00B22C_TRAP_PRESENT(~0u)},
	{46654, S_00B22C_EXCP_EN(~0u)},
	{69414, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{46692, S_00B22C_OC_LDS_EN(~0u)},
	{46634, S_00B22C_LDS_SIZE(~0u)},
	{69335, S_00B22C_SKIP_USGPR0(~0u)},
	{69347, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 2506 */
	{46773, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2507 */
	{46403, S_00B414_MEM_BASE(~0u)},
	/* 2508 */
	{46412, S_00B41C_WAVE_LIMIT(~0u)},
	{46423, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{69265, S_00B41C_SIMD_DISABLE(~0u)},
	{43999, S_00B41C_CU_EN(~0u)},
	/* 2512 */
	{46442, S_00B428_VGPRS(~0u)},
	{46448, S_00B428_SGPRS(~0u)},
	{2715, S_00B428_PRIORITY(~0u)},
	{46497, S_00B428_FLOAT_MODE(~0u)},
	{46508, S_00B428_PRIV(~0u)},
	{46513, S_00B428_DX10_CLAMP(~0u)},
	{46524, S_00B428_DEBUG_MODE(~0u)},
	{46535, S_00B428_IEEE_MODE(~0u)},
	{46572, S_00B428_CDBG_USER(~0u)},
	{69431, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{69278, S_00B428_FP16_OVFL(~0u)},
	/* 2523 */
	{46582, S_00B42C_SCRATCH_EN(~0u)},
	{46593, S_00B42C_USER_SGPR(~0u)},
	{46603, S_00B42C_TRAP_PRESENT(~0u)},
	{46654, S_00B42C_EXCP_EN(~0u)},
	{46634, S_00B42C_LDS_SIZE(~0u)},
	{69335, S_00B42C_SKIP_USGPR0(~0u)},
	{69347, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 2530 */
	{46816, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46834, S_00B800_PARTIAL_TG_EN(~0u)},
	{46848, S_00B800_FORCE_START_AT_000(~0u)},
	{46867, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46887, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46907, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46929, S_00B800_ORDER_MODE(~0u)},
	{46960, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46978, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{8089, S_00B800_RESERVED(~0u)},
	{47005, S_00B800_RESTORE(~0u)},
	/* 2541 */
	{46442, S_00B848_VGPRS(~0u)},
	{46448, S_00B848_SGPRS(~0u)},
	{2715, S_00B848_PRIORITY(~0u)},
	{46497, S_00B848_FLOAT_MODE(~0u)},
	{46508, S_00B848_PRIV(~0u)},
	{46513, S_00B848_DX10_CLAMP(~0u)},
	{46524, S_00B848_DEBUG_MODE(~0u)},
	{46535, S_00B848_IEEE_MODE(~0u)},
	{47057, S_00B848_BULKY(~0u)},
	{46572, S_00B848_CDBG_USER(~0u)},
	{69278, S_00B848_FP16_OVFL(~0u)},
	/* 2552 */
	{46582, S_00B84C_SCRATCH_EN(~0u)},
	{46593, S_00B84C_USER_SGPR(~0u)},
	{46603, S_00B84C_TRAP_PRESENT(~0u)},
	{47063, S_00B84C_TGID_X_EN(~0u)},
	{47073, S_00B84C_TGID_Y_EN(~0u)},
	{47083, S_00B84C_TGID_Z_EN(~0u)},
	{46790, S_00B84C_TG_SIZE_EN(~0u)},
	{47093, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47108, S_00B84C_EXCP_EN_MSB(~0u)},
	{46634, S_00B84C_LDS_SIZE(~0u)},
	{46654, S_00B84C_EXCP_EN(~0u)},
	{69335, S_00B84C_SKIP_USGPR0(~0u)},
	/* 2564 */
	{47136, S_00B854_WAVES_PER_SH(~0u)},
	{47149, S_00B854_TG_PER_CU(~0u)},
	{47159, S_00B854_LOCK_THRESHOLD(~0u)},
	{47174, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47189, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47205, S_00B854_CU_GROUP_COUNT(~0u)},
	{69265, S_00B854_SIMD_DISABLE(~0u)},
	/* 2571 */
	{69448, S_036008_CNTR_SEL0(~0u)},
	{69458, S_036008_CNTR_SEL1(~0u)},
	{48138, S_036008_SPM_MODE(~0u)},
	{69468, S_036008_CNTR_MODE1(~0u)},
	{69479, S_036008_CNTR_MODE0(~0u)},
	/* 2576 */
	{69490, S_036004_CNTR_SEL2(~0u)},
	{69500, S_036004_CNTR_SEL3(~0u)},
	{69510, S_036004_CNTR_MODE3(~0u)},
	{69521, S_036004_CNTR_MODE2(~0u)},
	/* 2580 */
	{69448, S_036024_CNTR_SEL0(~0u)},
	{69458, S_036024_CNTR_SEL1(~0u)},
	{48138, S_036024_SPM_MODE(~0u)},
	{69468, S_036024_CNTR_MODE1(~0u)},
	{69479, S_036024_CNTR_MODE0(~0u)},
	/* 2585 */
	{69490, S_036010_CNTR_SEL2(~0u)},
	{69500, S_036010_CNTR_SEL3(~0u)},
	{69510, S_036010_CNTR_MODE3(~0u)},
	{69521, S_036010_CNTR_MODE2(~0u)},
	/* 2589 */
	{69448, S_03601C_CNTR_SEL0(~0u)},
	{69458, S_03601C_CNTR_SEL1(~0u)},
	{48138, S_03601C_SPM_MODE(~0u)},
	{69468, S_03601C_CNTR_MODE1(~0u)},
	{69479, S_03601C_CNTR_MODE0(~0u)},
	/* 2594 */
	{69490, S_036018_CNTR_SEL2(~0u)},
	{69500, S_036018_CNTR_SEL3(~0u)},
	{69510, S_036018_CNTR_MODE3(~0u)},
	{69521, S_036018_CNTR_MODE2(~0u)},
	/* 2598 */
	{441, S_036028_INDEX(~0u)},
	{43171, S_036028_ALWAYS(~0u)},
	{7682, S_036028_ENABLE(~0u)},
	/* 2601 */
	{441, S_03602C_INDEX(~0u)},
	{43171, S_03602C_ALWAYS(~0u)},
	{7682, S_03602C_ENABLE(~0u)},
	/* 2604 */
	{441, S_036030_INDEX(~0u)},
	{15428, S_036030_CLEAR(~0u)},
	{7682, S_036030_ENABLE(~0u)},
	/* 2607 */
	{441, S_036034_INDEX(~0u)},
	{15428, S_036034_CLEAR(~0u)},
	{7682, S_036034_ENABLE(~0u)},
	/* 2610 */
	{441, S_036038_INDEX(~0u)},
	{15428, S_036038_CLEAR(~0u)},
	{7682, S_036038_ENABLE(~0u)},
	/* 2613 */
	{47324, S_036100_PERF_SEL(~0u)},
	{47494, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47548, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47575, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47706, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47786, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47812, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47838, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47892, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47919, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47945, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{69532, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{69561, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{69587, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2635 */
	{47324, S_036108_PERF_SEL(~0u)},
	{47494, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69587, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2648 */
	{47324, S_03610C_PERF_SEL(~0u)},
	{47494, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69587, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2661 */
	{47324, S_036110_PERF_SEL(~0u)},
	{47494, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69587, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2674 */
	{47324, S_036114_PERF_SEL(~0u)},
	{47494, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47521, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47575, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47601, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47627, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47654, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47760, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47548, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47680, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47865, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69587, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2687 */
	{47324, S_036600_PERF_SEL(~0u)},
	{47333, S_036600_PERF_SEL1(~0u)},
	{47343, S_036600_CNTR_MODE(~0u)},
	{47981, S_036600_PERF_MODE1(~0u)},
	{47971, S_036600_PERF_MODE(~0u)},
	/* 2692 */
	{47353, S_036610_PERF_SEL2(~0u)},
	{47363, S_036610_PERF_SEL3(~0u)},
	{47992, S_036610_PERF_MODE3(~0u)},
	{48003, S_036610_PERF_MODE2(~0u)},
	/* 2696 */
	{48866, S_028008_SLICE_START(~0u)},
	{48878, S_028008_SLICE_MAX(~0u)},
	{48888, S_028008_Z_READ_ONLY(~0u)},
	{48900, S_028008_STENCIL_READ_ONLY(~0u)},
	{69614, S_028008_MIPID(~0u)},
	/* 2701 */
	{49517, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 681},
	{49546, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49577, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49613, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49648, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49676, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49698, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49716, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49748, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49774, S_028010_HIZ_ZFUNC(~0u)},
	{49784, S_028010_HIS_SFUNC_FF(~0u)},
	{49797, S_028010_HIS_SFUNC_BF(~0u)},
	{49810, S_028010_PRESERVE_ZRANGE(~0u)},
	{49826, S_028010_PRESERVE_SRESULTS(~0u)},
	{49844, S_028010_DISABLE_FAST_PASS(~0u)},
	{69620, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 2717 */
	{919, S_028018_BASE_HI(~0u)},
	/* 2718 */
	{69648, S_02801C_X_MAX(~0u)},
	{69654, S_02801C_Y_MAX(~0u)},
	/* 2720 */
	{21171, S_028038_FORMAT(~0u), 4, 710},
	{50034, S_028038_NUM_SAMPLES(~0u)},
	{68645, S_028038_SW_MODE(~0u)},
	{69660, S_028038_PARTIALLY_RESIDENT(~0u)},
	{69679, S_028038_FAULT_BEHAVIOR(~0u)},
	{69694, S_028038_ITERATE_FLUSH(~0u)},
	{69708, S_028038_MAXMIP(~0u)},
	{50062, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{50086, S_028038_ALLOW_EXPCLEAR(~0u)},
	{50101, S_028038_READ_SIZE(~0u)},
	{50111, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{50131, S_028038_CLEAR_DISALLOWED(~0u)},
	{50148, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2733 */
	{21171, S_02803C_FORMAT(~0u), 2, 714},
	{68645, S_02803C_SW_MODE(~0u)},
	{69660, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{69679, S_02803C_FAULT_BEHAVIOR(~0u)},
	{69694, S_02803C_ITERATE_FLUSH(~0u)},
	{50086, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{50191, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{50131, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2741 */
	{919, S_028044_BASE_HI(~0u)},
	/* 2742 */
	{919, S_02804C_BASE_HI(~0u)},
	/* 2743 */
	{919, S_028054_BASE_HI(~0u)},
	/* 2744 */
	{919, S_02805C_BASE_HI(~0u)},
	/* 2745 */
	{69724, S_028060_PUNCHOUT_MODE(~0u), 4, 34284},
	{69738, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{69763, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2748 */
	{30432, S_028068_EPITCH(~0u)},
	/* 2749 */
	{30432, S_02806C_EPITCH(~0u)},
	/* 2750 */
	{69781, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 2751 */
	{69781, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 2752 */
	{69781, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 2753 */
	{69781, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 2754 */
	{50811, S_028350_RB_MAP_PKR0(~0u), 4, 33485},
	{50823, S_028350_RB_MAP_PKR1(~0u), 4, 33485},
	{50935, S_028350_RB_XSEL2(~0u), 4, 33489},
	{50944, S_028350_RB_XSEL(~0u)},
	{50952, S_028350_RB_YSEL(~0u)},
	{51056, S_028350_PKR_MAP(~0u), 4, 33493},
	{51164, S_028350_PKR_XSEL(~0u), 4, 33497},
	{51273, S_028350_PKR_YSEL(~0u), 4, 33501},
	{51386, S_028350_PKR_XSEL2(~0u), 4, 33505},
	{51488, S_028350_SC_MAP(~0u), 4, 33509},
	{51634, S_028350_SC_XSEL(~0u), 4, 33513},
	{51781, S_028350_SC_YSEL(~0u), 4, 33517},
	{51881, S_028350_SE_MAP(~0u), 4, 33521},
	{69799, S_028350_SE_XSEL_GFX9(~0u)},
	{69812, S_028350_SE_YSEL_GFX9(~0u)},
	/* 2769 */
	{52304, S_028354_SE_PAIR_MAP(~0u), 4, 33533},
	{69825, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{69843, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 2772 */
	{7682, S_02835C_ENABLE(~0u)},
	{69861, S_02835C_NUM_SE(~0u)},
	{69241, S_02835C_NUM_RB_PER_SE(~0u)},
	/* 2775 */
	{69868, S_028360_PERFMON_ENABLE(~0u)},
	/* 2776 */
	{69883, S_0283A0_LEFT_QTR(~0u)},
	{69892, S_0283A0_LEFT_HALF(~0u)},
	{69902, S_0283A0_RIGHT_HALF(~0u)},
	{69913, S_0283A0_RIGHT_QTR(~0u)},
	/* 2780 */
	{69883, S_0283A4_LEFT_QTR(~0u)},
	{69892, S_0283A4_LEFT_HALF(~0u)},
	{69902, S_0283A4_RIGHT_HALF(~0u)},
	{69913, S_0283A4_RIGHT_QTR(~0u)},
	/* 2784 */
	{69923, S_0283A8_TOP_QTR(~0u)},
	{69931, S_0283A8_TOP_HALF(~0u)},
	{69940, S_0283A8_BOT_HALF(~0u)},
	{69949, S_0283A8_BOT_QTR(~0u)},
	/* 2788 */
	{52670, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52697, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52736, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	{69957, S_028424_DISABLE_CONSTANT_ENCODE_REG(~0u)},
	/* 2792 */
	{53939, S_0286D8_NUM_INTERP(~0u)},
	{53950, S_0286D8_PARAM_GEN(~0u)},
	{69985, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{70002, S_0286D8_LATE_PC_DEALLOC(~0u)},
	{53969, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	/* 2797 */
	{30432, S_0287A0_EPITCH(~0u)},
	/* 2798 */
	{30432, S_0287A4_EPITCH(~0u)},
	/* 2799 */
	{30432, S_0287A8_EPITCH(~0u)},
	/* 2800 */
	{30432, S_0287AC_EPITCH(~0u)},
	/* 2801 */
	{30432, S_0287B0_EPITCH(~0u)},
	/* 2802 */
	{30432, S_0287B4_EPITCH(~0u)},
	/* 2803 */
	{30432, S_0287B8_EPITCH(~0u)},
	/* 2804 */
	{30432, S_0287BC_EPITCH(~0u)},
	/* 2805 */
	{70018, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 2806 */
	{56823, S_0287F0_SOURCE_SELECT(~0u), 4, 33652},
	{56869, S_0287F0_MAJOR_MODE(~0u), 2, 33656},
	{70033, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{56880, S_0287F0_NOT_EOP(~0u)},
	{56888, S_0287F0_USE_OPAQUE(~0u)},
	{70048, S_0287F0_UNROLLED_INST(~0u)},
	{70062, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{70079, S_0287F0_REG_RT_INDEX(~0u)},
	/* 2814 */
	{57864, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57880, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57911, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{49036, S_02880C_Z_ORDER(~0u), 4, 33937},
	{57990, S_02880C_KILL_ENABLE(~0u)},
	{58002, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{58026, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{58045, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{58063, S_02880C_EXEC_ON_NOOP(~0u)},
	{58076, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58098, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58188, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 33941},
	{58210, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{70092, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{70123, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{70142, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 2830 */
	{58532, S_028814_CULL_FRONT(~0u)},
	{58543, S_028814_CULL_BACK(~0u)},
	{22859, S_028814_FACE(~0u)},
	{58563, S_028814_POLY_MODE(~0u), 2, 33945},
	{58629, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 33947},
	{58650, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 33947},
	{58670, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58695, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58719, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58743, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58768, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58787, S_028814_PERSP_CORR_DIS(~0u)},
	{58802, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{70167, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{70205, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 2845 */
	{58820, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58838, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58857, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58875, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58894, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58912, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58931, S_028818_VTX_XY_FMT(~0u)},
	{58942, S_028818_VTX_Z_FMT(~0u)},
	{58952, S_028818_VTX_W0_FMT(~0u)},
	{70228, S_028818_PERFCOUNTER_REF(~0u)},
	/* 2855 */
	{58963, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58979, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58995, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{59011, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{59027, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{59043, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{59059, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{59075, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{59091, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59107, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59123, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59139, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59155, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59171, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59187, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59203, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59219, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59238, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59256, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59283, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59305, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59323, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59343, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59366, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59389, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59414, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59434, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{70244, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 2883 */
	{70267, S_028834_OBJ_ID_SEL(~0u)},
	{70278, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{70296, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2886 */
	{70315, S_028838_VERTEX_REUSE_OFF(~0u)},
	{70332, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2888 */
	{70356, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{70381, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{70402, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{70424, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{70450, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2893 */
	{22318, S_028A40_MODE(~0u), 6, 33987},
	{39336, S_028A40_RESERVED_0(~0u)},
	{61081, S_028A40_CUT_MODE(~0u), 4, 33993},
	{39354, S_028A40_RESERVED_1(~0u)},
	{61090, S_028A40_GS_C_PACK_EN(~0u)},
	{61103, S_028A40_RESERVED_2(~0u)},
	{61114, S_028A40_ES_PASSTHRU(~0u)},
	{70467, S_028A40_RESERVED_3(~0u)},
	{70478, S_028A40_RESERVED_4(~0u)},
	{70489, S_028A40_RESERVED_5(~0u)},
	{61173, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61192, S_028A40_SUPPRESS_CUTS(~0u)},
	{61206, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61224, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61275, S_028A40_ONCHIP(~0u), 4, 33997},
	/* 2908 */
	{61282, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61302, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{70500, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 2911 */
	{61322, S_028A48_MSAA_ENABLE(~0u)},
	{61334, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61355, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61375, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{70524, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{70545, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{70568, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 2918 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 34004},
	{62159, S_028A7C_SWAP_MODE(~0u), 4, 34007},
	{62220, S_028A7C_BUF_TYPE(~0u), 3, 34011},
	{62279, S_028A7C_RDREQ_POLICY(~0u)},
	{67128, S_028A7C_PRIMGEN_EN(~0u)},
	{56880, S_028A7C_NOT_EOP(~0u)},
	{62292, S_028A7C_REQ_PATH(~0u)},
	/* 2925 */
	{22597, S_028A84_PRIMITIVEID_EN(~0u)},
	{62301, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{70598, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 2928 */
	{63257, S_028A90_EVENT_TYPE(~0u), 63, 34288},
	{70723, S_028A90_ADDRESS_HI_GFX9(~0u)},
	{63284, S_028A90_EXTENDED_EVENT(~0u)},
	/* 2931 */
	{30633, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2932 */
	{70739, S_028A98_OBJPRIM_ID_EN(~0u)},
	{70753, S_028A98_EN_REG_RT_INDEX(~0u)},
	{70769, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{70788, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2936 */
	{63417, S_028ABC_FULL_CACHE(~0u)},
	{63428, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63451, S_028ABC_PRELOAD(~0u)},
	{63459, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63474, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63490, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{68818, S_028ABC_PIPE_ALIGNED(~0u)},
	{68836, S_028ABC_RB_ALIGNED(~0u)},
	/* 2944 */
	{48181, S_028B54_LS_EN(~0u), 3, 34075},
	{48175, S_028B54_HS_EN(~0u)},
	{23422, S_028B54_ES_EN(~0u), 3, 34078},
	{48169, S_028B54_GS_EN(~0u)},
	{48163, S_028B54_VS_EN(~0u), 3, 34081},
	{46756, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63812, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63832, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63852, S_028B54_VS_WAVE_ID_EN(~0u)},
	{67128, S_028B54_PRIMGEN_EN(~0u)},
	{70806, S_028B54_ORDERED_ID_MODE(~0u)},
	{63397, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{70822, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2957 */
	{209, S_028B6C_TYPE(~0u), 3, 34084},
	{64000, S_028B6C_PARTITIONING(~0u), 4, 34087},
	{64077, S_028B6C_TOPOLOGY(~0u), 4, 34091},
	{64086, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64106, S_028B6C_DEPRECATED(~0u)},
	{64139, S_028B6C_DISABLE_DONUTS(~0u)},
	{62279, S_028B6C_RDREQ_POLICY(~0u)},
	{64278, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 34098},
	/* 2965 */
	{64474, S_028B94_STREAMOUT_0_EN(~0u)},
	{64489, S_028B94_STREAMOUT_1_EN(~0u)},
	{64504, S_028B94_STREAMOUT_2_EN(~0u)},
	{64519, S_028B94_STREAMOUT_3_EN(~0u)},
	{64534, S_028B94_RAST_STREAM(~0u)},
	{70837, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	{64546, S_028B94_RAST_STREAM_MASK(~0u)},
	{64563, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 2973 */
	{63257, S_028B9C_EVENT_TYPE(~0u)},
	{39271, S_028B9C_ADDRESS_HI(~0u)},
	{63284, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2976 */
	{64918, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64935, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64957, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64973, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64994, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{70857, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2982 */
	{65529, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{69288, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{69310, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2985 */
	{70973, S_028C44_BINNING_MODE(~0u), 4, 34351},
	{70986, S_028C44_BIN_SIZE_X(~0u)},
	{70997, S_028C44_BIN_SIZE_Y(~0u)},
	{71008, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{71026, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{71044, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{71067, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{71093, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{71115, S_028C44_FPOVS_PER_BATCH(~0u)},
	{71131, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 2995 */
	{71153, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{71169, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 2997 */
	{71188, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{71205, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{71229, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{71247, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{71272, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{71302, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{71317, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{71332, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{71367, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{71403, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{71447, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{71471, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71507, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71543, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{71569, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{71593, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{71613, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{71634, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 3015 */
	{71659, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 3016 */
	{71680, S_028C64_BASE_256B(~0u)},
	/* 3017 */
	{71690, S_028C68_MIP0_HEIGHT(~0u)},
	{71702, S_028C68_MIP0_WIDTH(~0u)},
	{68847, S_028C68_MAX_MIP(~0u)},
	/* 3020 */
	{48866, S_028C6C_SLICE_START(~0u)},
	{48878, S_028C6C_SLICE_MAX(~0u)},
	{71713, S_028C6C_MIP_LEVEL(~0u)},
	/* 3023 */
	{65653, S_028C70_ENDIAN(~0u), 4, 34114},
	{21171, S_028C70_FORMAT(~0u), 23, 34118},
	{66020, S_028C70_NUMBER_TYPE(~0u), 8, 34141},
	{66076, S_028C70_COMP_SWAP(~0u), 4, 34149},
	{57603, S_028C70_FAST_CLEAR(~0u)},
	{49452, S_028C70_COMPRESSION(~0u)},
	{66086, S_028C70_BLEND_CLAMP(~0u)},
	{66098, S_028C70_BLEND_BYPASS(~0u)},
	{66111, S_028C70_SIMPLE_FLOAT(~0u)},
	{65078, S_028C70_ROUND_MODE(~0u)},
	{66351, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 34153},
	{66373, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 34153},
	{66397, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66423, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66449, S_028C70_DCC_ENABLE(~0u)},
	{66460, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 3039 */
	{71723, S_028C74_MIP0_DEPTH(~0u)},
	{68801, S_028C74_META_LINEAR(~0u)},
	{50034, S_028C74_NUM_SAMPLES(~0u)},
	{66516, S_028C74_NUM_FRAGMENTS(~0u)},
	{66530, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{71734, S_028C74_COLOR_SW_MODE(~0u)},
	{71748, S_028C74_FMASK_SW_MODE(~0u)},
	{71762, S_028C74_RESOURCE_TYPE(~0u), 4, 34355},
	{68836, S_028C74_RB_ALIGNED(~0u)},
	{68818, S_028C74_PIPE_ALIGNED(~0u)},
	/* 3049 */
	{71680, S_028C80_BASE_256B(~0u)},
	/* 3050 */
	{71680, S_028C88_BASE_256B(~0u)},
	/* 3051 */
	{71680, S_028C98_BASE_256B(~0u)},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 77, 91 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 203, 209 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 436, 441, 445 */
	"WAIT_REG_MEM\0" /* 447, 456 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"SET_CONFIG_REG\0" /* 616 */
	"SET_CONTEXT_REG\0" /* 631 */
	"SET_SH_REG\0" /* 647 */
	"SET_SH_REG_OFFSET\0" /* 658, 669 */
	"SET_UCONFIG_REG\0" /* 676 */
	"SET_UCONFIG_REG_INDEX\0" /* 692 */
	"LOAD_CONST_RAM\0" /* 714 */
	"WRITE_CONST_RAM\0" /* 729 */
	"DUMP_CONST_RAM\0" /* 745 */
	"INCREMENT_CE_COUNTER\0" /* 760 */
	"INCREMENT_DE_COUNTER\0" /* 781 */
	"WAIT_ON_CE_COUNTER\0" /* 802 */
	"LOAD_CONTEXT_REG\0" /* 821 */
	"IT_OPCODE_C\0" /* 838 */
	"CP_DMA\0" /* 850 */
	"DMA_DATA\0" /* 857 */
	"DRAW_INDEX_LOC\0" /* 866 */
	"DST_ADDR_LO\0" /* 881 */
	"DST_ADDR_HI\0" /* 893 */
	"IB_BASE_LO\0" /* 905 */
	"IB_BASE_HI\0" /* 916, 919 */
	"CP_DMA_WORD0\0" /* 927 */
	"CP_DMA_WORD1\0" /* 940 */
	"CP_DMA_WORD2\0" /* 953 */
	"CP_DMA_WORD3\0" /* 966 */
	"COMMAND\0" /* 979 */
	"DMA_DATA_WORD0\0" /* 987 */
	"SRC_ADDR_LO\0" /* 1002 */
	"SRC_ADDR_HI\0" /* 1014 */
	"SRBM_STATUS2\0" /* 1026 */
	"SRBM_STATUS\0" /* 1039, 1044 */
	"SRBM_STATUS3\0" /* 1051 */
	"SDMA0_STATUS_REG\0" /* 1064 */
	"SDMA1_STATUS_REG\0" /* 1081 */
	"GRBM_STATUS2\0" /* 1098 */
	"GRBM_STATUS\0" /* 1111 */
	"GRBM_GFX_INDEX\0" /* 1123 */
	"CP_STRMOUT_CNTL\0" /* 1138 */
	"CP_COHER_CNTL\0" /* 1154 */
	"CP_COHER_SIZE\0" /* 1168 */
	"CP_COHER_BASE\0" /* 1182 */
	"GRBM_STATUS_SE0\0" /* 1196 */
	"GRBM_STATUS_SE1\0" /* 1212 */
	"GRBM_STATUS_SE2\0" /* 1228 */
	"GRBM_STATUS_SE3\0" /* 1244 */
	"CP_COHER_BASE_HI\0" /* 1260 */
	"CP_COHER_START_DELAY\0" /* 1277 */
	"CP_COHER_STATUS\0" /* 1298 */
	"CP_CPC_STATUS\0" /* 1314 */
	"CP_CPC_BUSY_STAT\0" /* 1328 */
	"CP_CPC_STALLED_STAT1\0" /* 1345 */
	"CP_CPF_STATUS\0" /* 1366 */
	"CP_CPF_BUSY_STAT\0" /* 1380 */
	"CP_CPF_STALLED_STAT1\0" /* 1397 */
	"CP_COHER_SIZE_HI\0" /* 1418 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 1435 */
	"VGT_CACHE_INVALIDATION\0" /* 1458 */
	"VGT_ESGS_RING_SIZE\0" /* 1481 */
	"VGT_GSVS_RING_SIZE\0" /* 1500 */
	"VGT_GS_VERTEX_REUSE\0" /* 1519 */
	"VGT_PRIMITIVE_TYPE\0" /* 1539 */
	"VGT_INDEX_TYPE\0" /* 1558 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 1573 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 1606 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 1639 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 1672 */
	"VGT_NUM_INDICES\0" /* 1705 */
	"VGT_NUM_INSTANCES\0" /* 1721 */
	"VGT_TF_RING_SIZE\0" /* 1739 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 1756 */
	"VGT_TF_MEMORY_BASE\0" /* 1777 */
	"PA_CL_ENHANCE\0" /* 1796, 1807 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 1810, 1816 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 1835 */
	"CP_STALLED_STAT3\0" /* 1860 */
	"CP_STALLED_STAT1\0" /* 1877 */
	"CP_STALLED_STAT2\0" /* 1894 */
	"CP_STAT\0" /* 1911 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 1919, 1940 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 1945 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 1971, 1992 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 1997 */
	"PA_SC_ENHANCE\0" /* 2023 */
	"SQC_CACHES\0" /* 2037 */
	"SQ_RANDOM_WAVE_PRI\0" /* 2048 */
	"SQ_EXP_0\0" /* 2067 */
	"TA_CS_BC_BASE_ADDR\0" /* 2076, 2090 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 2095 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 2117 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 2141 */
	"SQ_BUF_RSRC_WORD0\0" /* 2164 */
	"SQ_BUF_RSRC_WORD1\0" /* 2182 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 2200 */
	"SQ_BUF_RSRC_WORD2\0" /* 2224 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 2242 */
	"SQ_BUF_RSRC_WORD3\0" /* 2265 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 2283 */
	"SQ_IMG_RSRC_WORD0\0" /* 2307 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 2325 */
	"SQ_IMG_RSRC_WORD1\0" /* 2348 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 2366 */
	"SQ_IMG_RSRC_WORD2\0" /* 2390 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 2408 */
	"SQ_IMG_RSRC_WORD3\0" /* 2431 */
	"SQ_IMG_RSRC_WORD4\0" /* 2449 */
	"SQ_IMG_RSRC_WORD5\0" /* 2467 */
	"SQ_IMG_RSRC_WORD6\0" /* 2485 */
	"SQ_IMG_RSRC_WORD7\0" /* 2503 */
	"SQ_IMG_SAMP_WORD0\0" /* 2521 */
	"SQ_IMG_SAMP_WORD1\0" /* 2539 */
	"SQ_IMG_SAMP_WORD2\0" /* 2557 */
	"SQ_IMG_SAMP_WORD3\0" /* 2575 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 2593, 2610 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 2613 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 2638 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 2663 */
	"SPI_PS_MAX_WAVE_ID\0" /* 2688, 2695 */
	"SPI_ARB_PRIORITY\0" /* 2707, 2715 */
	"SPI_ARB_CYCLES_0\0" /* 2724 */
	"SPI_ARB_CYCLES_1\0" /* 2741 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 2758 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 2780 */
	"DB_ZPASS_COUNT_LOW\0" /* 2802 */
	"DB_ZPASS_COUNT_HI\0" /* 2821, 2830 */
	"SPI_CONFIG_CNTL\0" /* 2839 */
	"SPI_CONFIG_CNTL_1\0" /* 2855 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 2873 */
	"DB_SUBTILE_CONTROL\0" /* 2902 */
	"GB_ADDR_CONFIG\0" /* 2921 */
	"GB_TILE_MODE0\0" /* 2936 */
	"GB_TILE_MODE1\0" /* 2950 */
	"GB_TILE_MODE2\0" /* 2964 */
	"GB_TILE_MODE3\0" /* 2978 */
	"GB_TILE_MODE4\0" /* 2992 */
	"GB_TILE_MODE5\0" /* 3006 */
	"GB_TILE_MODE6\0" /* 3020 */
	"GB_TILE_MODE7\0" /* 3034 */
	"GB_TILE_MODE8\0" /* 3048 */
	"GB_TILE_MODE9\0" /* 3062 */
	"GB_TILE_MODE10\0" /* 3076 */
	"GB_TILE_MODE11\0" /* 3091 */
	"GB_TILE_MODE12\0" /* 3106 */
	"GB_TILE_MODE13\0" /* 3121 */
	"GB_TILE_MODE14\0" /* 3136 */
	"GB_TILE_MODE15\0" /* 3151 */
	"GB_TILE_MODE16\0" /* 3166 */
	"GB_TILE_MODE17\0" /* 3181 */
	"GB_TILE_MODE18\0" /* 3196 */
	"GB_TILE_MODE19\0" /* 3211 */
	"GB_TILE_MODE20\0" /* 3226 */
	"GB_TILE_MODE21\0" /* 3241 */
	"GB_TILE_MODE22\0" /* 3256 */
	"GB_TILE_MODE23\0" /* 3271 */
	"GB_TILE_MODE24\0" /* 3286 */
	"GB_TILE_MODE25\0" /* 3301 */
	"GB_TILE_MODE26\0" /* 3316 */
	"GB_TILE_MODE27\0" /* 3331 */
	"GB_TILE_MODE28\0" /* 3346 */
	"GB_TILE_MODE29\0" /* 3361 */
	"GB_TILE_MODE30\0" /* 3376 */
	"GB_TILE_MODE31\0" /* 3391 */
	"GB_MACROTILE_MODE0\0" /* 3406 */
	"GB_MACROTILE_MODE1\0" /* 3425 */
	"GB_MACROTILE_MODE2\0" /* 3444 */
	"GB_MACROTILE_MODE3\0" /* 3463 */
	"GB_MACROTILE_MODE4\0" /* 3482 */
	"GB_MACROTILE_MODE5\0" /* 3501 */
	"GB_MACROTILE_MODE6\0" /* 3520 */
	"GB_MACROTILE_MODE7\0" /* 3539 */
	"GB_MACROTILE_MODE8\0" /* 3558 */
	"GB_MACROTILE_MODE9\0" /* 3577 */
	"GB_MACROTILE_MODE10\0" /* 3596 */
	"GB_MACROTILE_MODE11\0" /* 3616 */
	"GB_MACROTILE_MODE12\0" /* 3636 */
	"GB_MACROTILE_MODE13\0" /* 3656 */
	"GB_MACROTILE_MODE14\0" /* 3676 */
	"GB_MACROTILE_MODE15\0" /* 3696 */
	"SPI_SHADER_TBA_LO_PS\0" /* 3716 */
	"SPI_SHADER_TBA_HI_PS\0" /* 3737 */
	"SPI_SHADER_TMA_LO_PS\0" /* 3758 */
	"SPI_SHADER_TMA_HI_PS\0" /* 3779 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 3800 */
	"SPI_SHADER_PGM_LO_PS\0" /* 3824 */
	"SPI_SHADER_PGM_HI_PS\0" /* 3845 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 3866 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 3890 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 3914 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 3940 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 3966 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 3992 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 4018 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 4044 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 4070 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 4096 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 4122 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 4148 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 4174 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 4201 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 4228 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 4255 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 4282 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 4309 */
	"SPI_SHADER_TBA_LO_VS\0" /* 4336 */
	"SPI_SHADER_TBA_HI_VS\0" /* 4357 */
	"SPI_SHADER_TMA_LO_VS\0" /* 4378 */
	"SPI_SHADER_TMA_HI_VS\0" /* 4399 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 4420 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 4444 */
	"SPI_SHADER_PGM_LO_VS\0" /* 4469 */
	"SPI_SHADER_PGM_HI_VS\0" /* 4490 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 4511 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 4535 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 4559 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 4585 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 4611 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 4637 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 4663 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 4689 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 4715 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 4741 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 4767 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 4793 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 4819 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 4846 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 4873 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 4900 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 4927 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 4954 */
	"SPI_SHADER_TBA_LO_GS\0" /* 4981 */
	"SPI_SHADER_TBA_HI_GS\0" /* 5002 */
	"SPI_SHADER_TMA_LO_GS\0" /* 5023 */
	"SPI_SHADER_TMA_HI_GS\0" /* 5044 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 5065 */
	"SPI_SHADER_PGM_LO_GS\0" /* 5089 */
	"SPI_SHADER_PGM_HI_GS\0" /* 5110 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 5131 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 5155 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 5179 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 5205 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 5231 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 5257 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 5283 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 5309 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 5335 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 5361 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 5387 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 5413 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 5439 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 5466 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 5493 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 5520 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 5547 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 5574 */
	"SPI_SHADER_TBA_LO_ES\0" /* 5601 */
	"SPI_SHADER_TBA_HI_ES\0" /* 5622 */
	"SPI_SHADER_TMA_LO_ES\0" /* 5643 */
	"SPI_SHADER_TMA_HI_ES\0" /* 5664 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 5685 */
	"SPI_SHADER_PGM_LO_ES\0" /* 5709 */
	"SPI_SHADER_PGM_HI_ES\0" /* 5730 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 5751 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 5775 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 5799 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 5825 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 5851 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 5877 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 5903 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 5929 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 5955 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 5981 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 6007 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 6033 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 6059 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 6086 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 6113 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 6140 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 6167 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 6194 */
	"SPI_SHADER_TBA_LO_HS\0" /* 6221 */
	"SPI_SHADER_TBA_HI_HS\0" /* 6242 */
	"SPI_SHADER_TMA_LO_HS\0" /* 6263 */
	"SPI_SHADER_TMA_HI_HS\0" /* 6284 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 6305 */
	"SPI_SHADER_PGM_LO_HS\0" /* 6329 */
	"SPI_SHADER_PGM_HI_HS\0" /* 6350 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 6371 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 6395 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 6419 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 6445 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 6471 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 6497 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 6523 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 6549 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 6575 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 6601 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 6627 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 6653 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 6679 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 6706 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 6733 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 6760 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 6787 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 6814 */
	"SPI_SHADER_TBA_LO_LS\0" /* 6841 */
	"SPI_SHADER_TBA_HI_LS\0" /* 6862 */
	"SPI_SHADER_TMA_LO_LS\0" /* 6883 */
	"SPI_SHADER_TMA_HI_LS\0" /* 6904 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 6925 */
	"SPI_SHADER_PGM_LO_LS\0" /* 6949 */
	"SPI_SHADER_PGM_HI_LS\0" /* 6970 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 6991 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 7015 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 7039 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 7065 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 7091 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 7117 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 7143 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 7169 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 7195 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 7221 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 7247 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 7273 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 7299 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 7326 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 7353 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 7380 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 7407 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 7434 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 7461 */
	"COMPUTE_DIM_X\0" /* 7488 */
	"COMPUTE_DIM_Y\0" /* 7502 */
	"COMPUTE_DIM_Z\0" /* 7516 */
	"COMPUTE_START_X\0" /* 7530, 7538 */
	"COMPUTE_START_Y\0" /* 7546, 7554 */
	"COMPUTE_START_Z\0" /* 7562 */
	"COMPUTE_NUM_THREAD_X\0" /* 7578 */
	"COMPUTE_NUM_THREAD_Y\0" /* 7599 */
	"COMPUTE_NUM_THREAD_Z\0" /* 7620 */
	"COMPUTE_MAX_WAVE_ID\0" /* 7641 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 7661, 7669, 7682 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 7689, 7697 */
	"COMPUTE_PGM_LO\0" /* 7714 */
	"COMPUTE_PGM_HI\0" /* 7729 */
	"COMPUTE_TBA_LO\0" /* 7744 */
	"COMPUTE_TBA_HI\0" /* 7759 */
	"COMPUTE_TMA_LO\0" /* 7774 */
	"COMPUTE_TMA_HI\0" /* 7789 */
	"COMPUTE_PGM_RSRC1\0" /* 7804 */
	"COMPUTE_PGM_RSRC2\0" /* 7822 */
	"COMPUTE_VMID\0" /* 7840 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 7853 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 7877 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 7908 */
	"COMPUTE_TMPRING_SIZE\0" /* 7939 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 7960 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 7991 */
	"COMPUTE_RESTART_X\0" /* 8022 */
	"COMPUTE_RESTART_Y\0" /* 8040 */
	"COMPUTE_RESTART_Z\0" /* 8058 */
	"COMPUTE_MISC_RESERVED\0" /* 8076, 8089 */
	"COMPUTE_DISPATCH_ID\0" /* 8098 */
	"COMPUTE_THREADGROUP_ID\0" /* 8118 */
	"COMPUTE_RELAUNCH\0" /* 8141 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 8158 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 8187 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 8216 */
	"COMPUTE_USER_DATA_0\0" /* 8245 */
	"COMPUTE_USER_DATA_1\0" /* 8265 */
	"COMPUTE_USER_DATA_2\0" /* 8285 */
	"COMPUTE_USER_DATA_3\0" /* 8305 */
	"COMPUTE_USER_DATA_4\0" /* 8325 */
	"COMPUTE_USER_DATA_5\0" /* 8345 */
	"COMPUTE_USER_DATA_6\0" /* 8365 */
	"COMPUTE_USER_DATA_7\0" /* 8385 */
	"COMPUTE_USER_DATA_8\0" /* 8405 */
	"COMPUTE_USER_DATA_9\0" /* 8425 */
	"COMPUTE_USER_DATA_10\0" /* 8445 */
	"COMPUTE_USER_DATA_11\0" /* 8466 */
	"COMPUTE_USER_DATA_12\0" /* 8487 */
	"COMPUTE_USER_DATA_13\0" /* 8508 */
	"COMPUTE_USER_DATA_14\0" /* 8529 */
	"COMPUTE_USER_DATA_15\0" /* 8550 */
	"COMPUTE_NOWHERE\0" /* 8571, 8579 */
	"CPG_PERFCOUNTER1_LO\0" /* 8587 */
	"CPG_PERFCOUNTER1_HI\0" /* 8607 */
	"CPG_PERFCOUNTER0_LO\0" /* 8627 */
	"CPG_PERFCOUNTER0_HI\0" /* 8647 */
	"CPC_PERFCOUNTER1_LO\0" /* 8667 */
	"CPC_PERFCOUNTER1_HI\0" /* 8687 */
	"CPC_PERFCOUNTER0_LO\0" /* 8707 */
	"CPC_PERFCOUNTER0_HI\0" /* 8727 */
	"CPF_PERFCOUNTER1_LO\0" /* 8747 */
	"CPF_PERFCOUNTER1_HI\0" /* 8767 */
	"CPF_PERFCOUNTER0_LO\0" /* 8787 */
	"CPF_PERFCOUNTER0_HI\0" /* 8807 */
	"GRBM_PERFCOUNTER0_LO\0" /* 8827 */
	"GRBM_PERFCOUNTER0_HI\0" /* 8848 */
	"GRBM_PERFCOUNTER1_LO\0" /* 8869 */
	"GRBM_PERFCOUNTER1_HI\0" /* 8890 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 8911 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 8935, 8944 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 8959 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 8983 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 9007 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 9031 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 9055 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 9079 */
	"WD_PERFCOUNTER0_LO\0" /* 9103 */
	"WD_PERFCOUNTER0_HI\0" /* 9122 */
	"WD_PERFCOUNTER1_LO\0" /* 9141 */
	"WD_PERFCOUNTER1_HI\0" /* 9160 */
	"WD_PERFCOUNTER2_LO\0" /* 9179 */
	"WD_PERFCOUNTER2_HI\0" /* 9198 */
	"WD_PERFCOUNTER3_LO\0" /* 9217 */
	"WD_PERFCOUNTER3_HI\0" /* 9236 */
	"IA_PERFCOUNTER0_LO\0" /* 9255 */
	"IA_PERFCOUNTER0_HI\0" /* 9274 */
	"IA_PERFCOUNTER1_LO\0" /* 9293 */
	"IA_PERFCOUNTER1_HI\0" /* 9312 */
	"IA_PERFCOUNTER2_LO\0" /* 9331 */
	"IA_PERFCOUNTER2_HI\0" /* 9350 */
	"IA_PERFCOUNTER3_LO\0" /* 9369 */
	"IA_PERFCOUNTER3_HI\0" /* 9388 */
	"VGT_PERFCOUNTER0_LO\0" /* 9407 */
	"VGT_PERFCOUNTER0_HI\0" /* 9427 */
	"VGT_PERFCOUNTER1_LO\0" /* 9447 */
	"VGT_PERFCOUNTER1_HI\0" /* 9467 */
	"VGT_PERFCOUNTER2_LO\0" /* 9487 */
	"VGT_PERFCOUNTER2_HI\0" /* 9507 */
	"VGT_PERFCOUNTER3_LO\0" /* 9527 */
	"VGT_PERFCOUNTER3_HI\0" /* 9547 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 9567 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 9589 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 9611 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 9633 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 9655 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 9677 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 9699 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 9721 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 9743 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 9765 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 9787 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 9809 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 9831 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 9853 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 9875 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 9897 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 9919 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 9941 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 9963 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 9985 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 10007 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 10029 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 10051 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 10073 */
	"SPI_PERFCOUNTER0_HI\0" /* 10095 */
	"SPI_PERFCOUNTER0_LO\0" /* 10115 */
	"SPI_PERFCOUNTER1_HI\0" /* 10135 */
	"SPI_PERFCOUNTER1_LO\0" /* 10155 */
	"SPI_PERFCOUNTER2_HI\0" /* 10175 */
	"SPI_PERFCOUNTER2_LO\0" /* 10195 */
	"SPI_PERFCOUNTER3_HI\0" /* 10215 */
	"SPI_PERFCOUNTER3_LO\0" /* 10235 */
	"SPI_PERFCOUNTER4_HI\0" /* 10255 */
	"SPI_PERFCOUNTER4_LO\0" /* 10275 */
	"SPI_PERFCOUNTER5_HI\0" /* 10295 */
	"SPI_PERFCOUNTER5_LO\0" /* 10315 */
	"SQ_PERFCOUNTER0_LO\0" /* 10335 */
	"SQ_PERFCOUNTER0_HI\0" /* 10354 */
	"SQ_PERFCOUNTER1_LO\0" /* 10373 */
	"SQ_PERFCOUNTER1_HI\0" /* 10392 */
	"SQ_PERFCOUNTER2_LO\0" /* 10411 */
	"SQ_PERFCOUNTER2_HI\0" /* 10430 */
	"SQ_PERFCOUNTER3_LO\0" /* 10449 */
	"SQ_PERFCOUNTER3_HI\0" /* 10468 */
	"SQ_PERFCOUNTER4_LO\0" /* 10487 */
	"SQ_PERFCOUNTER4_HI\0" /* 10506 */
	"SQ_PERFCOUNTER5_LO\0" /* 10525 */
	"SQ_PERFCOUNTER5_HI\0" /* 10544 */
	"SQ_PERFCOUNTER6_LO\0" /* 10563 */
	"SQ_PERFCOUNTER6_HI\0" /* 10582 */
	"SQ_PERFCOUNTER7_LO\0" /* 10601 */
	"SQ_PERFCOUNTER7_HI\0" /* 10620 */
	"SQ_PERFCOUNTER8_LO\0" /* 10639 */
	"SQ_PERFCOUNTER8_HI\0" /* 10658 */
	"SQ_PERFCOUNTER9_LO\0" /* 10677 */
	"SQ_PERFCOUNTER9_HI\0" /* 10696 */
	"SQ_PERFCOUNTER10_LO\0" /* 10715 */
	"SQ_PERFCOUNTER10_HI\0" /* 10735 */
	"SQ_PERFCOUNTER11_LO\0" /* 10755 */
	"SQ_PERFCOUNTER11_HI\0" /* 10775 */
	"SQ_PERFCOUNTER12_LO\0" /* 10795 */
	"SQ_PERFCOUNTER12_HI\0" /* 10815 */
	"SQ_PERFCOUNTER13_LO\0" /* 10835 */
	"SQ_PERFCOUNTER13_HI\0" /* 10855 */
	"SQ_PERFCOUNTER14_LO\0" /* 10875 */
	"SQ_PERFCOUNTER14_HI\0" /* 10895 */
	"SQ_PERFCOUNTER15_LO\0" /* 10915 */
	"SQ_PERFCOUNTER15_HI\0" /* 10935 */
	"SX_PERFCOUNTER0_LO\0" /* 10955 */
	"SX_PERFCOUNTER0_HI\0" /* 10974 */
	"SX_PERFCOUNTER1_LO\0" /* 10993 */
	"SX_PERFCOUNTER1_HI\0" /* 11012 */
	"SX_PERFCOUNTER2_LO\0" /* 11031 */
	"SX_PERFCOUNTER2_HI\0" /* 11050 */
	"SX_PERFCOUNTER3_LO\0" /* 11069 */
	"SX_PERFCOUNTER3_HI\0" /* 11088 */
	"GDS_PERFCOUNTER0_LO\0" /* 11107 */
	"GDS_PERFCOUNTER0_HI\0" /* 11127 */
	"GDS_PERFCOUNTER1_LO\0" /* 11147 */
	"GDS_PERFCOUNTER1_HI\0" /* 11167 */
	"GDS_PERFCOUNTER2_LO\0" /* 11187 */
	"GDS_PERFCOUNTER2_HI\0" /* 11207 */
	"GDS_PERFCOUNTER3_LO\0" /* 11227 */
	"GDS_PERFCOUNTER3_HI\0" /* 11247 */
	"TA_PERFCOUNTER0_LO\0" /* 11267 */
	"TA_PERFCOUNTER0_HI\0" /* 11286 */
	"TA_PERFCOUNTER1_LO\0" /* 11305 */
	"TA_PERFCOUNTER1_HI\0" /* 11324 */
	"TD_PERFCOUNTER0_LO\0" /* 11343 */
	"TD_PERFCOUNTER0_HI\0" /* 11362 */
	"TD_PERFCOUNTER1_LO\0" /* 11381 */
	"TD_PERFCOUNTER1_HI\0" /* 11400 */
	"TCP_PERFCOUNTER0_LO\0" /* 11419 */
	"TCP_PERFCOUNTER0_HI\0" /* 11439 */
	"TCP_PERFCOUNTER1_LO\0" /* 11459 */
	"TCP_PERFCOUNTER1_HI\0" /* 11479 */
	"TCP_PERFCOUNTER2_LO\0" /* 11499 */
	"TCP_PERFCOUNTER2_HI\0" /* 11519 */
	"TCP_PERFCOUNTER3_LO\0" /* 11539 */
	"TCP_PERFCOUNTER3_HI\0" /* 11559 */
	"TCC_PERFCOUNTER0_LO\0" /* 11579 */
	"TCC_PERFCOUNTER0_HI\0" /* 11599 */
	"TCC_PERFCOUNTER1_LO\0" /* 11619 */
	"TCC_PERFCOUNTER1_HI\0" /* 11639 */
	"TCC_PERFCOUNTER2_LO\0" /* 11659 */
	"TCC_PERFCOUNTER2_HI\0" /* 11679 */
	"TCC_PERFCOUNTER3_LO\0" /* 11699 */
	"TCC_PERFCOUNTER3_HI\0" /* 11719 */
	"TCA_PERFCOUNTER0_LO\0" /* 11739 */
	"TCA_PERFCOUNTER0_HI\0" /* 11759 */
	"TCA_PERFCOUNTER1_LO\0" /* 11779 */
	"TCA_PERFCOUNTER1_HI\0" /* 11799 */
	"TCA_PERFCOUNTER2_LO\0" /* 11819 */
	"TCA_PERFCOUNTER2_HI\0" /* 11839 */
	"TCA_PERFCOUNTER3_LO\0" /* 11859 */
	"TCA_PERFCOUNTER3_HI\0" /* 11879 */
	"CB_PERFCOUNTER0_LO\0" /* 11899 */
	"CB_PERFCOUNTER0_HI\0" /* 11918 */
	"CB_PERFCOUNTER1_LO\0" /* 11937 */
	"CB_PERFCOUNTER1_HI\0" /* 11956 */
	"CB_PERFCOUNTER2_LO\0" /* 11975 */
	"CB_PERFCOUNTER2_HI\0" /* 11994 */
	"CB_PERFCOUNTER3_LO\0" /* 12013 */
	"CB_PERFCOUNTER3_HI\0" /* 12032 */
	"DB_PERFCOUNTER0_LO\0" /* 12051 */
	"DB_PERFCOUNTER0_HI\0" /* 12070 */
	"DB_PERFCOUNTER1_LO\0" /* 12089 */
	"DB_PERFCOUNTER1_HI\0" /* 12108 */
	"DB_PERFCOUNTER2_LO\0" /* 12127 */
	"DB_PERFCOUNTER2_HI\0" /* 12146 */
	"DB_PERFCOUNTER3_LO\0" /* 12165 */
	"DB_PERFCOUNTER3_HI\0" /* 12184 */
	"RLC_PERFCOUNTER0_LO\0" /* 12203 */
	"RLC_PERFCOUNTER0_HI\0" /* 12223 */
	"RLC_PERFCOUNTER1_LO\0" /* 12243 */
	"RLC_PERFCOUNTER1_HI\0" /* 12263 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 12283 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 12307 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 12332 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 12356 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 12380 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 12405 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 12429 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 12454 */
	"CP_PERFMON_CNTL\0" /* 12478 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 12494 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 12518 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 12543 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 12568, 12577 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 12596 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 12624 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 12652 */
	"WD_PERFCOUNTER0_SELECT\0" /* 12680 */
	"WD_PERFCOUNTER1_SELECT\0" /* 12703 */
	"WD_PERFCOUNTER2_SELECT\0" /* 12726 */
	"WD_PERFCOUNTER3_SELECT\0" /* 12749 */
	"IA_PERFCOUNTER0_SELECT\0" /* 12772 */
	"IA_PERFCOUNTER1_SELECT\0" /* 12795 */
	"IA_PERFCOUNTER2_SELECT\0" /* 12818 */
	"IA_PERFCOUNTER3_SELECT\0" /* 12841 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 12864 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 12888 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 12912 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 12936 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 12960 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 12984 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 13009 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 13034 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 13060 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 13086 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 13113 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 13139 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 13166 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 13192 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 13218 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 13244 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 13271 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 13297 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 13323 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 13349 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 13375 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 13401 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 13427 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 13453 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 13477 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 13501 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 13525 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 13549 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 13574 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 13599 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 13624 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 13649 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 13673 */
	"SPI_PERFCOUNTER_BINS\0" /* 13697 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 13718 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 13741 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 13764 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 13787 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 13810 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 13833 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 13856 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 13879 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 13902 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 13925 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 13948 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 13972 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 13996 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 14020 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 14044 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 14068 */
	"SQ_PERFCOUNTER_CTRL\0" /* 14092 */
	"SQ_PERFCOUNTER_MASK\0" /* 14112 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 14132 */
	"SX_PERFCOUNTER0_SELECT\0" /* 14153 */
	"SX_PERFCOUNTER1_SELECT\0" /* 14176 */
	"SX_PERFCOUNTER2_SELECT\0" /* 14199 */
	"SX_PERFCOUNTER3_SELECT\0" /* 14222 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 14245 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 14269 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 14293 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 14317 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 14341 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 14365 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 14389 */
	"TA_PERFCOUNTER0_SELECT\0" /* 14414 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 14437 */
	"TA_PERFCOUNTER1_SELECT\0" /* 14461 */
	"TD_PERFCOUNTER0_SELECT\0" /* 14484 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 14507 */
	"TD_PERFCOUNTER1_SELECT\0" /* 14531 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 14554 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 14578 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 14603 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 14627 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 14652 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 14676 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 14700 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 14724 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 14749 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 14773 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 14798 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 14822 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 14846 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 14870 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 14895 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 14919 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 14944 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 14968 */
	"CB_PERFCOUNTER_FILTER\0" /* 14992 */
	"CB_PERFCOUNTER0_SELECT\0" /* 15014 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 15037 */
	"CB_PERFCOUNTER1_SELECT\0" /* 15061 */
	"CB_PERFCOUNTER2_SELECT\0" /* 15084 */
	"CB_PERFCOUNTER3_SELECT\0" /* 15107 */
	"DB_PERFCOUNTER0_SELECT\0" /* 15130 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 15153 */
	"DB_PERFCOUNTER1_SELECT\0" /* 15177 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 15200 */
	"DB_PERFCOUNTER2_SELECT\0" /* 15224 */
	"DB_PERFCOUNTER3_SELECT\0" /* 15247 */
	"DB_RENDER_CONTROL\0" /* 15270 */
	"DB_COUNT_CONTROL\0" /* 15288 */
	"DB_DEPTH_VIEW\0" /* 15305 */
	"DB_RENDER_OVERRIDE\0" /* 15319, 15335 */
	"DB_RENDER_OVERRIDE2\0" /* 15338 */
	"DB_HTILE_DATA_BASE\0" /* 15358 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 15377 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 15397 */
	"DB_STENCIL_CLEAR\0" /* 15417, 15428 */
	"DB_DEPTH_CLEAR\0" /* 15434 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 15449 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 15473 */
	"DB_DEPTH_INFO\0" /* 15497 */
	"DB_Z_INFO\0" /* 15511 */
	"DB_STENCIL_INFO\0" /* 15521 */
	"DB_Z_READ_BASE\0" /* 15537 */
	"DB_STENCIL_READ_BASE\0" /* 15552 */
	"DB_Z_WRITE_BASE\0" /* 15573 */
	"DB_STENCIL_WRITE_BASE\0" /* 15589 */
	"DB_DEPTH_SIZE\0" /* 15611 */
	"DB_DEPTH_SLICE\0" /* 15625 */
	"TA_BC_BASE_ADDR\0" /* 15640 */
	"TA_BC_BASE_ADDR_HI\0" /* 15656 */
	"COHER_DEST_BASE_HI_0\0" /* 15675 */
	"COHER_DEST_BASE_HI_1\0" /* 15696 */
	"COHER_DEST_BASE_HI_2\0" /* 15717 */
	"COHER_DEST_BASE_HI_3\0" /* 15738 */
	"COHER_DEST_BASE_2\0" /* 15759 */
	"COHER_DEST_BASE_3\0" /* 15777 */
	"PA_SC_WINDOW_OFFSET\0" /* 15795, 15806 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 15815 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 15839 */
	"PA_SC_CLIPRECT_RULE\0" /* 15863 */
	"PA_SC_CLIPRECT_0_TL\0" /* 15883 */
	"PA_SC_CLIPRECT_0_BR\0" /* 15903 */
	"PA_SC_CLIPRECT_1_TL\0" /* 15923 */
	"PA_SC_CLIPRECT_1_BR\0" /* 15943 */
	"PA_SC_CLIPRECT_2_TL\0" /* 15963 */
	"PA_SC_CLIPRECT_2_BR\0" /* 15983 */
	"PA_SC_CLIPRECT_3_TL\0" /* 16003 */
	"PA_SC_CLIPRECT_3_BR\0" /* 16023 */
	"PA_SC_EDGERULE\0" /* 16043 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 16058 */
	"CB_TARGET_MASK\0" /* 16087 */
	"CB_SHADER_MASK\0" /* 16102 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 16117 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 16142 */
	"COHER_DEST_BASE_0\0" /* 16167 */
	"COHER_DEST_BASE_1\0" /* 16185 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 16203 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 16228 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 16253 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 16278 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 16303 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 16328 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 16353 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 16378 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 16403 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 16428 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 16453 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 16478 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 16503 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 16528 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 16553 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 16578 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 16603 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 16628 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 16653 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 16678 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 16703 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 16729 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 16755 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 16781 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 16807 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 16833 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 16859 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 16885 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 16911 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 16937 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 16963 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 16989 */
	"PA_SC_VPORT_ZMIN_0\0" /* 17015 */
	"PA_SC_VPORT_ZMAX_0\0" /* 17034 */
	"PA_SC_VPORT_ZMIN_1\0" /* 17053 */
	"PA_SC_VPORT_ZMAX_1\0" /* 17072 */
	"PA_SC_VPORT_ZMIN_2\0" /* 17091, 17105 */
	"PA_SC_VPORT_ZMAX_2\0" /* 17110 */
	"PA_SC_VPORT_ZMIN_3\0" /* 17129, 17143 */
	"PA_SC_VPORT_ZMAX_3\0" /* 17148 */
	"PA_SC_VPORT_ZMIN_4\0" /* 17167 */
	"PA_SC_VPORT_ZMAX_4\0" /* 17186 */
	"PA_SC_VPORT_ZMIN_5\0" /* 17205 */
	"PA_SC_VPORT_ZMAX_5\0" /* 17224 */
	"PA_SC_VPORT_ZMIN_6\0" /* 17243 */
	"PA_SC_VPORT_ZMAX_6\0" /* 17262 */
	"PA_SC_VPORT_ZMIN_7\0" /* 17281 */
	"PA_SC_VPORT_ZMAX_7\0" /* 17300 */
	"PA_SC_VPORT_ZMIN_8\0" /* 17319 */
	"PA_SC_VPORT_ZMAX_8\0" /* 17338 */
	"PA_SC_VPORT_ZMIN_9\0" /* 17357 */
	"PA_SC_VPORT_ZMAX_9\0" /* 17376 */
	"PA_SC_VPORT_ZMIN_10\0" /* 17395, 17409 */
	"PA_SC_VPORT_ZMAX_10\0" /* 17415 */
	"PA_SC_VPORT_ZMIN_11\0" /* 17435 */
	"PA_SC_VPORT_ZMAX_11\0" /* 17455 */
	"PA_SC_VPORT_ZMIN_12\0" /* 17475 */
	"PA_SC_VPORT_ZMAX_12\0" /* 17495 */
	"PA_SC_VPORT_ZMIN_13\0" /* 17515 */
	"PA_SC_VPORT_ZMAX_13\0" /* 17535 */
	"PA_SC_VPORT_ZMIN_14\0" /* 17555 */
	"PA_SC_VPORT_ZMAX_14\0" /* 17575 */
	"PA_SC_VPORT_ZMIN_15\0" /* 17595 */
	"PA_SC_VPORT_ZMAX_15\0" /* 17615 */
	"PA_SC_RASTER_CONFIG\0" /* 17635 */
	"PA_SC_RASTER_CONFIG_1\0" /* 17655 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 17677 */
	"VGT_MAX_VTX_INDX\0" /* 17705 */
	"VGT_MIN_VTX_INDX\0" /* 17722 */
	"VGT_INDX_OFFSET\0" /* 17739, 17746 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 17755 */
	"CB_BLEND_RED\0" /* 17784 */
	"CB_BLEND_GREEN\0" /* 17797 */
	"CB_BLEND_BLUE\0" /* 17812 */
	"CB_BLEND_ALPHA\0" /* 17826 */
	"CB_DCC_CONTROL\0" /* 17841 */
	"DB_STENCIL_CONTROL\0" /* 17856 */
	"DB_STENCILREFMASK\0" /* 17875 */
	"DB_STENCILREFMASK_BF\0" /* 17893 */
	"PA_CL_VPORT_XSCALE\0" /* 17914 */
	"PA_CL_VPORT_XOFFSET\0" /* 17933 */
	"PA_CL_VPORT_YSCALE\0" /* 17953 */
	"PA_CL_VPORT_YOFFSET\0" /* 17972 */
	"PA_CL_VPORT_ZSCALE\0" /* 17992 */
	"PA_CL_VPORT_ZOFFSET\0" /* 18011 */
	"PA_CL_VPORT_XSCALE_1\0" /* 18031 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 18052 */
	"PA_CL_VPORT_YSCALE_1\0" /* 18074 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 18095 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 18117 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 18138 */
	"PA_CL_VPORT_XSCALE_2\0" /* 18160 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 18181 */
	"PA_CL_VPORT_YSCALE_2\0" /* 18203 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 18224 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 18246 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 18267 */
	"PA_CL_VPORT_XSCALE_3\0" /* 18289 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 18310 */
	"PA_CL_VPORT_YSCALE_3\0" /* 18332 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 18353 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 18375 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 18396 */
	"PA_CL_VPORT_XSCALE_4\0" /* 18418 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 18439 */
	"PA_CL_VPORT_YSCALE_4\0" /* 18461 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 18482 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 18504 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 18525 */
	"PA_CL_VPORT_XSCALE_5\0" /* 18547 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 18568 */
	"PA_CL_VPORT_YSCALE_5\0" /* 18590 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 18611 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 18633 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 18654 */
	"PA_CL_VPORT_XSCALE_6\0" /* 18676 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 18697 */
	"PA_CL_VPORT_YSCALE_6\0" /* 18719 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 18740 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 18762 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 18783 */
	"PA_CL_VPORT_XSCALE_7\0" /* 18805 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 18826 */
	"PA_CL_VPORT_YSCALE_7\0" /* 18848 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 18869 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 18891 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 18912 */
	"PA_CL_VPORT_XSCALE_8\0" /* 18934 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 18955 */
	"PA_CL_VPORT_YSCALE_8\0" /* 18977 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 18998 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 19020 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 19041 */
	"PA_CL_VPORT_XSCALE_9\0" /* 19063 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 19084 */
	"PA_CL_VPORT_YSCALE_9\0" /* 19106 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 19127 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 19149 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 19170 */
	"PA_CL_VPORT_XSCALE_10\0" /* 19192 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 19214 */
	"PA_CL_VPORT_YSCALE_10\0" /* 19237 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 19259 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 19282 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 19304 */
	"PA_CL_VPORT_XSCALE_11\0" /* 19327 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 19349 */
	"PA_CL_VPORT_YSCALE_11\0" /* 19372 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 19394 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 19417 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 19439 */
	"PA_CL_VPORT_XSCALE_12\0" /* 19462 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 19484 */
	"PA_CL_VPORT_YSCALE_12\0" /* 19507 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 19529 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 19552 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 19574 */
	"PA_CL_VPORT_XSCALE_13\0" /* 19597 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 19619 */
	"PA_CL_VPORT_YSCALE_13\0" /* 19642 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 19664 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 19687 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 19709 */
	"PA_CL_VPORT_XSCALE_14\0" /* 19732 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 19754 */
	"PA_CL_VPORT_YSCALE_14\0" /* 19777 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 19799 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 19822 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 19844 */
	"PA_CL_VPORT_XSCALE_15\0" /* 19867 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 19889 */
	"PA_CL_VPORT_YSCALE_15\0" /* 19912 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 19934 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 19957 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 19979 */
	"PA_CL_UCP_0_X\0" /* 20002 */
	"PA_CL_UCP_0_Y\0" /* 20016 */
	"PA_CL_UCP_0_Z\0" /* 20030 */
	"PA_CL_UCP_0_W\0" /* 20044 */
	"PA_CL_UCP_1_X\0" /* 20058 */
	"PA_CL_UCP_1_Y\0" /* 20072 */
	"PA_CL_UCP_1_Z\0" /* 20086 */
	"PA_CL_UCP_1_W\0" /* 20100 */
	"PA_CL_UCP_2_X\0" /* 20114 */
	"PA_CL_UCP_2_Y\0" /* 20128 */
	"PA_CL_UCP_2_Z\0" /* 20142 */
	"PA_CL_UCP_2_W\0" /* 20156 */
	"PA_CL_UCP_3_X\0" /* 20170 */
	"PA_CL_UCP_3_Y\0" /* 20184 */
	"PA_CL_UCP_3_Z\0" /* 20198 */
	"PA_CL_UCP_3_W\0" /* 20212 */
	"PA_CL_UCP_4_X\0" /* 20226 */
	"PA_CL_UCP_4_Y\0" /* 20240 */
	"PA_CL_UCP_4_Z\0" /* 20254 */
	"PA_CL_UCP_4_W\0" /* 20268 */
	"PA_CL_UCP_5_X\0" /* 20282 */
	"PA_CL_UCP_5_Y\0" /* 20296 */
	"PA_CL_UCP_5_Z\0" /* 20310 */
	"PA_CL_UCP_5_W\0" /* 20324 */
	"SPI_PS_INPUT_CNTL_0\0" /* 20338 */
	"SPI_PS_INPUT_CNTL_1\0" /* 20358 */
	"SPI_PS_INPUT_CNTL_2\0" /* 20378 */
	"SPI_PS_INPUT_CNTL_3\0" /* 20398 */
	"SPI_PS_INPUT_CNTL_4\0" /* 20418 */
	"SPI_PS_INPUT_CNTL_5\0" /* 20438 */
	"SPI_PS_INPUT_CNTL_6\0" /* 20458 */
	"SPI_PS_INPUT_CNTL_7\0" /* 20478 */
	"SPI_PS_INPUT_CNTL_8\0" /* 20498 */
	"SPI_PS_INPUT_CNTL_9\0" /* 20518 */
	"SPI_PS_INPUT_CNTL_10\0" /* 20538 */
	"SPI_PS_INPUT_CNTL_11\0" /* 20559 */
	"SPI_PS_INPUT_CNTL_12\0" /* 20580 */
	"SPI_PS_INPUT_CNTL_13\0" /* 20601 */
	"SPI_PS_INPUT_CNTL_14\0" /* 20622 */
	"SPI_PS_INPUT_CNTL_15\0" /* 20643 */
	"SPI_PS_INPUT_CNTL_16\0" /* 20664 */
	"SPI_PS_INPUT_CNTL_17\0" /* 20685 */
	"SPI_PS_INPUT_CNTL_18\0" /* 20706 */
	"SPI_PS_INPUT_CNTL_19\0" /* 20727 */
	"SPI_PS_INPUT_CNTL_20\0" /* 20748 */
	"SPI_PS_INPUT_CNTL_21\0" /* 20769 */
	"SPI_PS_INPUT_CNTL_22\0" /* 20790 */
	"SPI_PS_INPUT_CNTL_23\0" /* 20811 */
	"SPI_PS_INPUT_CNTL_24\0" /* 20832 */
	"SPI_PS_INPUT_CNTL_25\0" /* 20853 */
	"SPI_PS_INPUT_CNTL_26\0" /* 20874 */
	"SPI_PS_INPUT_CNTL_27\0" /* 20895 */
	"SPI_PS_INPUT_CNTL_28\0" /* 20916 */
	"SPI_PS_INPUT_CNTL_29\0" /* 20937 */
	"SPI_PS_INPUT_CNTL_30\0" /* 20958 */
	"SPI_PS_INPUT_CNTL_31\0" /* 20979 */
	"SPI_VS_OUT_CONFIG\0" /* 21000 */
	"SPI_PS_INPUT_ENA\0" /* 21018 */
	"SPI_PS_INPUT_ADDR\0" /* 21035 */
	"SPI_INTERP_CONTROL_0\0" /* 21053 */
	"SPI_PS_IN_CONTROL\0" /* 21074 */
	"SPI_BARYC_CNTL\0" /* 21092 */
	"SPI_TMPRING_SIZE\0" /* 21107 */
	"SPI_WAVE_MGMT_1\0" /* 21124 */
	"SPI_WAVE_MGMT_2\0" /* 21140 */
	"SPI_SHADER_POS_FORMAT\0" /* 21156, 21171 */
	"SPI_SHADER_Z_FORMAT\0" /* 21178 */
	"SPI_SHADER_COL_FORMAT\0" /* 21198 */
	"SX_PS_DOWNCONVERT\0" /* 21220 */
	"SX_BLEND_OPT_EPSILON\0" /* 21238 */
	"SX_BLEND_OPT_CONTROL\0" /* 21259 */
	"SX_MRT0_BLEND_OPT\0" /* 21280 */
	"SX_MRT1_BLEND_OPT\0" /* 21298 */
	"SX_MRT2_BLEND_OPT\0" /* 21316 */
	"SX_MRT3_BLEND_OPT\0" /* 21334 */
	"SX_MRT4_BLEND_OPT\0" /* 21352 */
	"SX_MRT5_BLEND_OPT\0" /* 21370 */
	"SX_MRT6_BLEND_OPT\0" /* 21388 */
	"SX_MRT7_BLEND_OPT\0" /* 21406 */
	"CB_BLEND0_CONTROL\0" /* 21424 */
	"CB_BLEND1_CONTROL\0" /* 21442 */
	"CB_BLEND2_CONTROL\0" /* 21460 */
	"CB_BLEND3_CONTROL\0" /* 21478 */
	"CB_BLEND4_CONTROL\0" /* 21496 */
	"CB_BLEND5_CONTROL\0" /* 21514 */
	"CB_BLEND6_CONTROL\0" /* 21532 */
	"CB_BLEND7_CONTROL\0" /* 21550 */
	"CS_COPY_STATE\0" /* 21568 */
	"PA_CL_POINT_X_RAD\0" /* 21582 */
	"PA_CL_POINT_Y_RAD\0" /* 21600 */
	"PA_CL_POINT_SIZE\0" /* 21618 */
	"PA_CL_POINT_CULL_RAD\0" /* 21635 */
	"VGT_DMA_BASE_HI\0" /* 21656 */
	"VGT_DMA_BASE\0" /* 21672 */
	"VGT_DRAW_INITIATOR\0" /* 21685 */
	"VGT_IMMED_DATA\0" /* 21704 */
	"VGT_EVENT_ADDRESS_REG\0" /* 21719 */
	"DB_DEPTH_CONTROL\0" /* 21741 */
	"DB_EQAA\0" /* 21758 */
	"CB_COLOR_CONTROL\0" /* 21766 */
	"DB_SHADER_CONTROL\0" /* 21783 */
	"PA_CL_CLIP_CNTL\0" /* 21801 */
	"PA_SU_SC_MODE_CNTL\0" /* 21817 */
	"PA_CL_VTE_CNTL\0" /* 21836 */
	"PA_CL_VS_OUT_CNTL\0" /* 21851 */
	"PA_CL_NANINF_CNTL\0" /* 21869 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 21887 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 21911 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 21936 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 21959 */
	"PA_SU_POINT_SIZE\0" /* 21988 */
	"PA_SU_POINT_MINMAX\0" /* 22005 */
	"PA_SU_LINE_CNTL\0" /* 22024 */
	"PA_SC_LINE_STIPPLE\0" /* 22040 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 22059 */
	"VGT_HOS_CNTL\0" /* 22080 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 22093 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 22116 */
	"VGT_HOS_REUSE_DEPTH\0" /* 22139, 22147, 22153 */
	"VGT_GROUP_PRIM_TYPE\0" /* 22159, 22169 */
	"VGT_GROUP_FIRST_DECR\0" /* 22179, 22189, 22195 */
	"VGT_GROUP_DECR\0" /* 22200 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 22215 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 22237 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 22259 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 22285 */
	"VGT_GS_MODE\0" /* 22311, 22318 */
	"VGT_GS_ONCHIP_CNTL\0" /* 22323 */
	"PA_SC_MODE_CNTL_0\0" /* 22342 */
	"PA_SC_MODE_CNTL_1\0" /* 22360 */
	"VGT_ENHANCE\0" /* 22378 */
	"VGT_GS_PER_ES\0" /* 22390, 22394 */
	"VGT_ES_PER_GS\0" /* 22404, 22408 */
	"VGT_GS_PER_VS\0" /* 22418, 22422 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 22432 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 22455 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 22478 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 22501 */
	"IA_ENHANCE\0" /* 22522 */
	"VGT_DMA_SIZE\0" /* 22533 */
	"VGT_DMA_MAX_SIZE\0" /* 22546, 22554 */
	"VGT_DMA_INDEX_TYPE\0" /* 22563 */
	"WD_ENHANCE\0" /* 22582 */
	"VGT_PRIMITIVEID_EN\0" /* 22593, 22597 */
	"VGT_DMA_NUM_INSTANCES\0" /* 22612 */
	"VGT_PRIMITIVEID_RESET\0" /* 22634 */
	"VGT_EVENT_INITIATOR\0" /* 22656 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 22676, 22694 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 22703 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 22728 */
	"IA_MULTI_VGT_PARAM\0" /* 22753 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 22772, 22786 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 22795 */
	"VGT_REUSE_OFF\0" /* 22818, 22822 */
	"VGT_VTX_CNT_EN\0" /* 22832, 22836 */
	"DB_HTILE_SURFACE\0" /* 22847, 22859 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 22864 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 22891 */
	"DB_PRELOAD_CONTROL\0" /* 22918 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 22937 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 22963 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 22988 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 23016 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 23042 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 23067 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 23095 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 23121 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 23146 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 23174 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 23200 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 23225 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 23253 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 23284 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 23327, 23351, 23358 */
	"VGT_GS_MAX_VERT_OUT\0" /* 23365, 23372, 23381 */
	"VGT_TESS_DISTRIBUTION\0" /* 23385 */
	"VGT_SHADER_STAGES_EN\0" /* 23407, 23422 */
	"VGT_LS_HS_CONFIG\0" /* 23428 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 23445 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 23466 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 23489 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 23512 */
	"VGT_TF_PARAM\0" /* 23535 */
	"DB_ALPHA_TO_MASK\0" /* 23548 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 23565 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 23589 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 23619 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 23643 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 23673 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 23704 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 23733 */
	"VGT_GS_INSTANCE_CNT\0" /* 23763, 23779 */
	"VGT_STRMOUT_CONFIG\0" /* 23783 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 23802 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 23828 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 23854 */
	"PA_SC_LINE_CNTL\0" /* 23880 */
	"PA_SC_AA_CONFIG\0" /* 23896 */
	"PA_SU_VTX_CNTL\0" /* 23912 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 23927 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 23950 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 23973 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 23996 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 24019 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 24053 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 24087 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 24121 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 24155 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 24189 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 24223 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 24257 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 24291 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 24325 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 24359 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 24393 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 24427 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 24461 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 24495 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 24529 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 24563 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 24587 */
	"PA_SC_SHADER_CONTROL\0" /* 24611 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 24632 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 24660 */
	"CB_COLOR0_BASE\0" /* 24681 */
	"CB_COLOR0_PITCH\0" /* 24696 */
	"CB_COLOR0_SLICE\0" /* 24712 */
	"CB_COLOR0_VIEW\0" /* 24728 */
	"CB_COLOR0_INFO\0" /* 24743 */
	"CB_COLOR0_ATTRIB\0" /* 24758 */
	"CB_COLOR0_DCC_CONTROL\0" /* 24775 */
	"CB_COLOR0_CMASK\0" /* 24797 */
	"CB_COLOR0_CMASK_SLICE\0" /* 24813 */
	"CB_COLOR0_FMASK\0" /* 24835 */
	"CB_COLOR0_FMASK_SLICE\0" /* 24851 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 24873 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 24895 */
	"CB_COLOR0_DCC_BASE\0" /* 24917 */
	"CB_COLOR1_BASE\0" /* 24936 */
	"CB_COLOR1_PITCH\0" /* 24951 */
	"CB_COLOR1_SLICE\0" /* 24967 */
	"CB_COLOR1_VIEW\0" /* 24983 */
	"CB_COLOR1_INFO\0" /* 24998 */
	"CB_COLOR1_ATTRIB\0" /* 25013 */
	"CB_COLOR1_DCC_CONTROL\0" /* 25030 */
	"CB_COLOR1_CMASK\0" /* 25052 */
	"CB_COLOR1_CMASK_SLICE\0" /* 25068 */
	"CB_COLOR1_FMASK\0" /* 25090 */
	"CB_COLOR1_FMASK_SLICE\0" /* 25106 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 25128 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 25150 */
	"CB_COLOR1_DCC_BASE\0" /* 25172 */
	"CB_COLOR2_BASE\0" /* 25191 */
	"CB_COLOR2_PITCH\0" /* 25206 */
	"CB_COLOR2_SLICE\0" /* 25222 */
	"CB_COLOR2_VIEW\0" /* 25238 */
	"CB_COLOR2_INFO\0" /* 25253 */
	"CB_COLOR2_ATTRIB\0" /* 25268 */
	"CB_COLOR2_DCC_CONTROL\0" /* 25285 */
	"CB_COLOR2_CMASK\0" /* 25307 */
	"CB_COLOR2_CMASK_SLICE\0" /* 25323 */
	"CB_COLOR2_FMASK\0" /* 25345 */
	"CB_COLOR2_FMASK_SLICE\0" /* 25361 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 25383 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 25405 */
	"CB_COLOR2_DCC_BASE\0" /* 25427 */
	"CB_COLOR3_BASE\0" /* 25446 */
	"CB_COLOR3_PITCH\0" /* 25461 */
	"CB_COLOR3_SLICE\0" /* 25477 */
	"CB_COLOR3_VIEW\0" /* 25493 */
	"CB_COLOR3_INFO\0" /* 25508 */
	"CB_COLOR3_ATTRIB\0" /* 25523 */
	"CB_COLOR3_DCC_CONTROL\0" /* 25540 */
	"CB_COLOR3_CMASK\0" /* 25562 */
	"CB_COLOR3_CMASK_SLICE\0" /* 25578 */
	"CB_COLOR3_FMASK\0" /* 25600 */
	"CB_COLOR3_FMASK_SLICE\0" /* 25616 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 25638 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 25660 */
	"CB_COLOR3_DCC_BASE\0" /* 25682 */
	"CB_COLOR4_BASE\0" /* 25701 */
	"CB_COLOR4_PITCH\0" /* 25716 */
	"CB_COLOR4_SLICE\0" /* 25732 */
	"CB_COLOR4_VIEW\0" /* 25748 */
	"CB_COLOR4_INFO\0" /* 25763 */
	"CB_COLOR4_ATTRIB\0" /* 25778 */
	"CB_COLOR4_DCC_CONTROL\0" /* 25795 */
	"CB_COLOR4_CMASK\0" /* 25817 */
	"CB_COLOR4_CMASK_SLICE\0" /* 25833 */
	"CB_COLOR4_FMASK\0" /* 25855 */
	"CB_COLOR4_FMASK_SLICE\0" /* 25871 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 25893 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 25915 */
	"CB_COLOR4_DCC_BASE\0" /* 25937 */
	"CB_COLOR5_BASE\0" /* 25956 */
	"CB_COLOR5_PITCH\0" /* 25971 */
	"CB_COLOR5_SLICE\0" /* 25987 */
	"CB_COLOR5_VIEW\0" /* 26003 */
	"CB_COLOR5_INFO\0" /* 26018 */
	"CB_COLOR5_ATTRIB\0" /* 26033 */
	"CB_COLOR5_DCC_CONTROL\0" /* 26050 */
	"CB_COLOR5_CMASK\0" /* 26072 */
	"CB_COLOR5_CMASK_SLICE\0" /* 26088 */
	"CB_COLOR5_FMASK\0" /* 26110 */
	"CB_COLOR5_FMASK_SLICE\0" /* 26126 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 26148 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 26170 */
	"CB_COLOR5_DCC_BASE\0" /* 26192 */
	"CB_COLOR6_BASE\0" /* 26211 */
	"CB_COLOR6_PITCH\0" /* 26226 */
	"CB_COLOR6_SLICE\0" /* 26242 */
	"CB_COLOR6_VIEW\0" /* 26258 */
	"CB_COLOR6_INFO\0" /* 26273 */
	"CB_COLOR6_ATTRIB\0" /* 26288 */
	"CB_COLOR6_DCC_CONTROL\0" /* 26305 */
	"CB_COLOR6_CMASK\0" /* 26327 */
	"CB_COLOR6_CMASK_SLICE\0" /* 26343 */
	"CB_COLOR6_FMASK\0" /* 26365 */
	"CB_COLOR6_FMASK_SLICE\0" /* 26381 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 26403 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 26425 */
	"CB_COLOR6_DCC_BASE\0" /* 26447 */
	"CB_COLOR7_BASE\0" /* 26466 */
	"CB_COLOR7_PITCH\0" /* 26481 */
	"CB_COLOR7_SLICE\0" /* 26497 */
	"CB_COLOR7_VIEW\0" /* 26513 */
	"CB_COLOR7_INFO\0" /* 26528 */
	"CB_COLOR7_ATTRIB\0" /* 26543 */
	"CB_COLOR7_DCC_CONTROL\0" /* 26560 */
	"CB_COLOR7_CMASK\0" /* 26582 */
	"CB_COLOR7_CMASK_SLICE\0" /* 26598 */
	"CB_COLOR7_FMASK\0" /* 26620 */
	"CB_COLOR7_FMASK_SLICE\0" /* 26636 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 26658 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 26680 */
	"CB_COLOR7_DCC_BASE\0" /* 26702 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 26721 */
	"WD_POS_BUF_BASE\0" /* 26743 */
	"WD_POS_BUF_BASE_HI\0" /* 26759 */
	"WD_CNTL_SB_BUF_BASE\0" /* 26778 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 26798 */
	"WD_INDEX_BUF_BASE\0" /* 26821 */
	"WD_INDEX_BUF_BASE_HI\0" /* 26839 */
	"VGT_INSTANCE_BASE_ID\0" /* 26860 */
	"SQC_WRITEBACK\0" /* 26881, 26885 */
	"SPI_CONFIG_CNTL_2\0" /* 26895 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 26913 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 26940 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 26967 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 26994 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 27021 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 27048 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 27075 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 27102 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 27129 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 27156 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 27183 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 27210 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 27237 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 27264 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 27291 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 27318 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 27345 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 27372 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 27399 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 27426 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 27453 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 27480 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 27507 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 27534 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 27561 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 27588 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 27615 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 27642 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 27669 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 27696 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 27723 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 27750 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 27777 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 27804 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 27828 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 27860 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 27892 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 27919 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 27946 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 27973 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 28000 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 28027 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 28054 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 28081 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 28108 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 28135 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 28162 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 28189 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 28216 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 28243 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 28270 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 28297 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 28324 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 28348 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 28380 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 28412 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 28439 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 28466 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 28493 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 28520 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 28547 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 28574 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 28601 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 28628 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 28655 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 28682 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 28709 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 28736 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 28763 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 28790 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 28817 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 28844 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 28874 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 28904 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 28934 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 28964 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 28994 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 29024 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 29054 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 29084 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 29114 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 29144 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 29175 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 29206 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 29237 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 29268 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 29299 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 29330 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 29361 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 29392 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 29423 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 29454 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 29485 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 29516 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 29547 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 29578 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 29609 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 29640 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 29671 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 29702 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 29733 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 29764 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 29795 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 29826 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 29855 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 29884 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 29917 */
	"CPF_LATENCY_STATS_DATA\0" /* 29950 */
	"CPG_LATENCY_STATS_DATA\0" /* 29973 */
	"CPC_LATENCY_STATS_DATA\0" /* 29996 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30019 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30053 */
	"CPF_LATENCY_STATS_SELECT\0" /* 30087 */
	"CPG_LATENCY_STATS_SELECT\0" /* 30112 */
	"CPC_LATENCY_STATS_SELECT\0" /* 30137 */
	"DB_HTILE_DATA_BASE_HI\0" /* 30162 */
	"DB_Z_READ_BASE_HI\0" /* 30184 */
	"DB_STENCIL_READ_BASE_HI\0" /* 30202 */
	"DB_Z_WRITE_BASE_HI\0" /* 30226 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 30245 */
	"DB_DFSM_CONTROL\0" /* 30270 */
	"DB_Z_INFO2\0" /* 30286 */
	"DB_STENCIL_INFO2\0" /* 30297 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 30314 */
	"CP_PERFMON_CNTX_CNTL\0" /* 30343 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 30364 */
	"PA_SC_LEFT_VERT_GRID\0" /* 30386 */
	"PA_SC_HORIZ_GRID\0" /* 30407 */
	"CB_MRT0_EPITCH\0" /* 30424, 30432 */
	"CB_MRT1_EPITCH\0" /* 30439 */
	"CB_MRT2_EPITCH\0" /* 30454 */
	"CB_MRT3_EPITCH\0" /* 30469 */
	"CB_MRT4_EPITCH\0" /* 30484 */
	"CB_MRT5_EPITCH\0" /* 30499 */
	"CB_MRT6_EPITCH\0" /* 30514 */
	"CB_MRT7_EPITCH\0" /* 30529 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 30544 */
	"PA_CL_NGG_CNTL\0" /* 30566 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 30581 */
	"PA_STEREO_CNTL\0" /* 30611 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 30626, 30633 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 30656 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 30678 */
	"PA_SC_BINNER_CNTL_0\0" /* 30702 */
	"PA_SC_BINNER_CNTL_1\0" /* 30722 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 30742 */
	"PA_SC_NGG_MODE_CNTL\0" /* 30780 */
	"CB_COLOR0_BASE_EXT\0" /* 30800 */
	"CB_COLOR0_ATTRIB2\0" /* 30819 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 30837 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 30862 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 30887 */
	"CB_COLOR1_BASE_EXT\0" /* 30910 */
	"CB_COLOR1_ATTRIB2\0" /* 30929 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 30947 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 30972 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 30997 */
	"CB_COLOR2_BASE_EXT\0" /* 31020 */
	"CB_COLOR2_ATTRIB2\0" /* 31039 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 31057 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 31082 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 31107 */
	"CB_COLOR3_BASE_EXT\0" /* 31130 */
	"CB_COLOR3_ATTRIB2\0" /* 31149 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 31167 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 31192 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 31217 */
	"CB_COLOR4_BASE_EXT\0" /* 31240 */
	"CB_COLOR4_ATTRIB2\0" /* 31259 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 31277 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 31302 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 31327 */
	"CB_COLOR5_BASE_EXT\0" /* 31350 */
	"CB_COLOR5_ATTRIB2\0" /* 31369 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 31387 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 31412 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 31437 */
	"CB_COLOR6_BASE_EXT\0" /* 31460 */
	"CB_COLOR6_ATTRIB2\0" /* 31479 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 31497 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 31522 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 31547 */
	"CB_COLOR7_BASE_EXT\0" /* 31570 */
	"CB_COLOR7_ATTRIB2\0" /* 31589 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 31607 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 31632 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 31657 */
	"COUNT_INDIRECT_ENABLE\0" /* 31680 */
	"DRAW_INDEX_ENABLE\0" /* 31702 */
	"PFP\0" /* 31720 */
	"ENGINE_SEL\0" /* 31724 */
	"WR_CONFIRM\0" /* 31735 */
	"WR_ONE_ADDR\0" /* 31746 */
	"MEM_MAPPED_REGISTER\0" /* 31758, 31769 */
	"MEM_GRBM\0" /* 31778 */
	"TC_L2\0" /* 31787 */
	"GDS\0" /* 31793 */
	"DST_SEL\0" /* 31797 */
	"IB_SIZE\0" /* 31805 */
	"CHAIN\0" /* 31813 */
	"VALID\0" /* 31819 */
	"CP_SYNC\0" /* 31825 */
	"SRC_ADDR\0" /* 31833 */
	"SRC_ADDR_TC_L2\0" /* 31842 */
	"SRC_SEL\0" /* 31857 */
	"ENGINE\0" /* 31865 */
	"DST_ADDR\0" /* 31872 */
	"DST_ADDR_TC_L2\0" /* 31881 */
	"BYTE_COUNT_GFX6\0" /* 31896 */
	"BYTE_COUNT_GFX9\0" /* 31912 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 31928 */
	"NONE\0" /* 31952 */
	"8_IN_16\0" /* 31957 */
	"8_IN_32\0" /* 31965, 31967 */
	"8_IN_64\0" /* 31973 */
	"SRC_SWAP\0" /* 31981 */
	"DST_SWAP\0" /* 31990 */
	"MEMORY\0" /* 31999 */
	"SAS\0" /* 32006 */
	"DAS\0" /* 32010 */
	"INCREMENT\0" /* 32014 */
	"NO_INCREMENT\0" /* 32024 */
	"SAIC\0" /* 32037 */
	"DAIC\0" /* 32042 */
	"RAW_WAIT\0" /* 32047 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 32056 */
	"DST_CACHE_POLICY\0" /* 32080 */
	"SRC_CACHE_POLICY\0" /* 32097 */
	"SDMA_RQ_PENDING\0" /* 32114 */
	"TST_RQ_PENDING\0" /* 32130 */
	"SDMA1_RQ_PENDING\0" /* 32145 */
	"VCE0_RQ_PENDING\0" /* 32162 */
	"VP8_BUSY\0" /* 32178 */
	"SDMA_BUSY\0" /* 32187, 32188 */
	"SDMA1_BUSY\0" /* 32197 */
	"VCE0_BUSY\0" /* 32208 */
	"XDMA_BUSY\0" /* 32218 */
	"CHUB_BUSY\0" /* 32228 */
	"SDMA2_BUSY\0" /* 32238 */
	"SDMA3_BUSY\0" /* 32249 */
	"SAMSCP_BUSY\0" /* 32260, 32264 */
	"ISP_BUSY\0" /* 32272 */
	"VCE1_BUSY\0" /* 32281 */
	"ODE_BUSY\0" /* 32291 */
	"SDMA2_RQ_PENDING\0" /* 32300 */
	"SDMA3_RQ_PENDING\0" /* 32317 */
	"SAMSCP_RQ_PENDING\0" /* 32334 */
	"ISP_RQ_PENDING\0" /* 32352 */
	"VCE1_RQ_PENDING\0" /* 32367 */
	"UVD_RQ_PENDING\0" /* 32383 */
	"SAMMSP_RQ_PENDING\0" /* 32398 */
	"ACP_RQ_PENDING\0" /* 32416 */
	"SMU_RQ_PENDING\0" /* 32431 */
	"GRBM_RQ_PENDING\0" /* 32446 */
	"HI_RQ_PENDING\0" /* 32462 */
	"VMC_BUSY\0" /* 32476 */
	"MCB_BUSY\0" /* 32485, 32486 */
	"MCB_NON_DISPLAY_BUSY\0" /* 32494 */
	"MCC_BUSY\0" /* 32515 */
	"MCD_BUSY\0" /* 32524 */
	"VMC1_BUSY\0" /* 32533 */
	"SEM_BUSY\0" /* 32543 */
	"ACP_BUSY\0" /* 32552 */
	"IH_BUSY\0" /* 32561 */
	"UVD_BUSY\0" /* 32569 */
	"SAMMSP_BUSY\0" /* 32578 */
	"GCATCL2_BUSY\0" /* 32590 */
	"OSATCL2_BUSY\0" /* 32603 */
	"BIF_BUSY\0" /* 32616 */
	"MCC0_BUSY\0" /* 32625 */
	"MCC1_BUSY\0" /* 32635 */
	"MCC2_BUSY\0" /* 32645 */
	"MCC3_BUSY\0" /* 32655 */
	"MCC4_BUSY\0" /* 32665 */
	"MCC5_BUSY\0" /* 32675 */
	"MCC6_BUSY\0" /* 32685 */
	"MCC7_BUSY\0" /* 32695 */
	"MCD0_BUSY\0" /* 32705 */
	"MCD1_BUSY\0" /* 32715 */
	"MCD2_BUSY\0" /* 32725 */
	"MCD3_BUSY\0" /* 32735 */
	"MCD4_BUSY\0" /* 32745 */
	"MCD5_BUSY\0" /* 32755 */
	"MCD6_BUSY\0" /* 32765 */
	"MCD7_BUSY\0" /* 32775 */
	"IDLE\0" /* 32785 */
	"REG_IDLE\0" /* 32790 */
	"RB_EMPTY\0" /* 32799 */
	"RB_FULL\0" /* 32808 */
	"RB_CMD_IDLE\0" /* 32816 */
	"RB_CMD_FULL\0" /* 32828 */
	"IB_CMD_IDLE\0" /* 32840 */
	"IB_CMD_FULL\0" /* 32852 */
	"BLOCK_IDLE\0" /* 32864 */
	"INSIDE_IB\0" /* 32875 */
	"EX_IDLE\0" /* 32885 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 32893 */
	"PACKET_READY\0" /* 32919 */
	"MC_WR_IDLE\0" /* 32932 */
	"SRBM_IDLE\0" /* 32943 */
	"CONTEXT_EMPTY\0" /* 32953 */
	"DELTA_RPTR_FULL\0" /* 32967 */
	"RB_MC_RREQ_IDLE\0" /* 32983 */
	"IB_MC_RREQ_IDLE\0" /* 32999 */
	"MC_RD_IDLE\0" /* 33015 */
	"DELTA_RPTR_EMPTY\0" /* 33026 */
	"MC_RD_RET_STALL\0" /* 33043 */
	"MC_RD_NO_POLL_IDLE\0" /* 33059 */
	"PREV_CMD_IDLE\0" /* 33078 */
	"SEM_IDLE\0" /* 33092 */
	"SEM_REQ_STALL\0" /* 33101 */
	"SEM_RESP_STATE\0" /* 33115 */
	"INT_IDLE\0" /* 33130 */
	"INT_REQ_STALL\0" /* 33139 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 33153 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 33176 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 33199 */
	"ME1PIPE0_RQ_PENDING\0" /* 33222 */
	"ME1PIPE1_RQ_PENDING\0" /* 33242 */
	"ME1PIPE2_RQ_PENDING\0" /* 33262 */
	"ME1PIPE3_RQ_PENDING\0" /* 33282 */
	"ME2PIPE0_RQ_PENDING\0" /* 33302 */
	"ME2PIPE1_RQ_PENDING\0" /* 33322 */
	"ME2PIPE2_RQ_PENDING\0" /* 33342 */
	"ME2PIPE3_RQ_PENDING\0" /* 33362 */
	"RLC_RQ_PENDING\0" /* 33382 */
	"RLC_BUSY\0" /* 33397 */
	"TC_BUSY\0" /* 33406 */
	"TCC_CC_RESIDENT\0" /* 33414 */
	"CPF_BUSY\0" /* 33430 */
	"CPC_BUSY\0" /* 33439 */
	"CPG_BUSY\0" /* 33448 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 33457 */
	"SRBM_RQ_PENDING\0" /* 33480 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 33496 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 33519 */
	"GDS_DMA_RQ_PENDING\0" /* 33542 */
	"DB_CLEAN\0" /* 33561 */
	"CB_CLEAN\0" /* 33570 */
	"TA_BUSY\0" /* 33579 */
	"GDS_BUSY\0" /* 33587 */
	"WD_BUSY_NO_DMA\0" /* 33596 */
	"VGT_BUSY\0" /* 33611 */
	"IA_BUSY_NO_DMA\0" /* 33620 */
	"IA_BUSY\0" /* 33635 */
	"SX_BUSY\0" /* 33643 */
	"WD_BUSY\0" /* 33651 */
	"SPI_BUSY\0" /* 33659 */
	"BCI_BUSY\0" /* 33668 */
	"SC_BUSY\0" /* 33677 */
	"PA_BUSY\0" /* 33685 */
	"DB_BUSY\0" /* 33693 */
	"CP_COHERENCY_BUSY\0" /* 33701 */
	"GUI_ACTIVE\0" /* 33719 */
	"INSTANCE_INDEX\0" /* 33730 */
	"SH_INDEX\0" /* 33745 */
	"SE_INDEX\0" /* 33754 */
	"SH_BROADCAST_WRITES\0" /* 33763 */
	"INSTANCE_BROADCAST_WRITES\0" /* 33783 */
	"SE_BROADCAST_WRITES\0" /* 33809 */
	"OFFSET_UPDATE_DONE\0" /* 33829, 33843 */
	"DEST_BASE_0_ENA\0" /* 33848 */
	"DEST_BASE_1_ENA\0" /* 33864 */
	"CB0_DEST_BASE_ENA\0" /* 33880 */
	"CB1_DEST_BASE_ENA\0" /* 33898 */
	"CB2_DEST_BASE_ENA\0" /* 33916 */
	"CB3_DEST_BASE_ENA\0" /* 33934 */
	"CB4_DEST_BASE_ENA\0" /* 33952 */
	"CB5_DEST_BASE_ENA\0" /* 33970 */
	"CB6_DEST_BASE_ENA\0" /* 33988 */
	"CB7_DEST_BASE_ENA\0" /* 34006 */
	"DB_DEST_BASE_ENA\0" /* 34024 */
	"DEST_BASE_2_ENA\0" /* 34041 */
	"DEST_BASE_3_ENA\0" /* 34057 */
	"TCL1_ACTION_ENA\0" /* 34073 */
	"TC_ACTION_ENA\0" /* 34089 */
	"CB_ACTION_ENA\0" /* 34103 */
	"DB_ACTION_ENA\0" /* 34117 */
	"SH_KCACHE_ACTION_ENA\0" /* 34131 */
	"SH_ICACHE_ACTION_ENA\0" /* 34152 */
	"COHER_BASE_HI_256B\0" /* 34173 */
	"START_DELAY_COUNT\0" /* 34192 */
	"TC_SD_ACTION_ENA\0" /* 34210 */
	"TC_NC_ACTION_ENA\0" /* 34227 */
	"TCL1_VOL_ACTION_ENA\0" /* 34244 */
	"TC_VOL_ACTION_ENA\0" /* 34264 */
	"TC_WB_ACTION_ENA\0" /* 34282 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 34299 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 34324 */
	"SH_SD_ACTION_ENA\0" /* 34348 */
	"MATCHING_GFX_CNTX\0" /* 34365 */
	"MEID\0" /* 34383 */
	"PHASE1_STATUS\0" /* 34388 */
	"MEC1_BUSY\0" /* 34402 */
	"MEC2_BUSY\0" /* 34412 */
	"DC0_BUSY\0" /* 34422 */
	"DC1_BUSY\0" /* 34431 */
	"RCIU1_BUSY\0" /* 34440 */
	"RCIU2_BUSY\0" /* 34451 */
	"ROQ1_BUSY\0" /* 34462 */
	"ROQ2_BUSY\0" /* 34472 */
	"TCIU_BUSY\0" /* 34482 */
	"SCRATCH_RAM_BUSY\0" /* 34492 */
	"QU_BUSY\0" /* 34509 */
	"ATCL2IU_BUSY\0" /* 34517 */
	"CPG_CPC_BUSY\0" /* 34530 */
	"CPF_CPC_BUSY\0" /* 34543 */
	"MEC1_LOAD_BUSY\0" /* 34556 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 34571 */
	"MEC1_MUTEX_BUSY\0" /* 34591 */
	"MEC1_MESSAGE_BUSY\0" /* 34607 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 34625 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 34645 */
	"MEC1_IB_QUEUE_BUSY\0" /* 34664 */
	"MEC1_TC_BUSY\0" /* 34683 */
	"MEC1_DMA_BUSY\0" /* 34696 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 34710 */
	"MEC1_PIPE0_BUSY\0" /* 34734 */
	"MEC1_PIPE1_BUSY\0" /* 34750 */
	"MEC1_PIPE2_BUSY\0" /* 34766 */
	"MEC1_PIPE3_BUSY\0" /* 34782 */
	"MEC2_LOAD_BUSY\0" /* 34798 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 34813 */
	"MEC2_MUTEX_BUSY\0" /* 34833 */
	"MEC2_MESSAGE_BUSY\0" /* 34849 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 34867 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 34887 */
	"MEC2_IB_QUEUE_BUSY\0" /* 34906 */
	"MEC2_TC_BUSY\0" /* 34925 */
	"MEC2_DMA_BUSY\0" /* 34938 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 34952 */
	"MEC2_PIPE0_BUSY\0" /* 34976 */
	"MEC2_PIPE1_BUSY\0" /* 34992 */
	"MEC2_PIPE2_BUSY\0" /* 35008 */
	"MEC2_PIPE3_BUSY\0" /* 35024 */
	"RCIU_TX_FREE_STALL\0" /* 35040 */
	"RCIU_PRIV_VIOLATION\0" /* 35059 */
	"TCIU_TX_FREE_STALL\0" /* 35079 */
	"MEC1_DECODING_PACKET\0" /* 35098 */
	"MEC1_WAIT_ON_RCIU\0" /* 35119 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 35137 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 35160 */
	"MEC2_DECODING_PACKET\0" /* 35182 */
	"MEC2_WAIT_ON_RCIU\0" /* 35203 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 35221 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 35244 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 35266 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 35290 */
	"ATCL1_WAITING_ON_TRANS\0" /* 35314 */
	"POST_WPTR_GFX_BUSY\0" /* 35337 */
	"CSF_BUSY\0" /* 35356 */
	"ROQ_ALIGN_BUSY\0" /* 35365 */
	"ROQ_RING_BUSY\0" /* 35380 */
	"ROQ_INDIRECT1_BUSY\0" /* 35394 */
	"ROQ_INDIRECT2_BUSY\0" /* 35413 */
	"ROQ_STATE_BUSY\0" /* 35432 */
	"ROQ_CE_RING_BUSY\0" /* 35447 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 35464 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 35486 */
	"SEMAPHORE_BUSY\0" /* 35508 */
	"INTERRUPT_BUSY\0" /* 35523 */
	"HQD_BUSY\0" /* 35538 */
	"PRT_BUSY\0" /* 35547 */
	"CPF_GFX_BUSY\0" /* 35556 */
	"CPF_CMP_BUSY\0" /* 35569 */
	"GRBM_CPF_STAT_BUSY\0" /* 35582 */
	"CPC_CPF_BUSY\0" /* 35601 */
	"REG_BUS_FIFO_BUSY\0" /* 35614 */
	"CSF_RING_BUSY\0" /* 35632 */
	"CSF_INDIRECT1_BUSY\0" /* 35646 */
	"CSF_INDIRECT2_BUSY\0" /* 35665 */
	"CSF_STATE_BUSY\0" /* 35684 */
	"CSF_CE_INDR1_BUSY\0" /* 35699 */
	"CSF_CE_INDR2_BUSY\0" /* 35717 */
	"CSF_ARBITER_BUSY\0" /* 35735 */
	"CSF_INPUT_BUSY\0" /* 35752 */
	"OUTSTANDING_READ_TAGS\0" /* 35767 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 35789 */
	"HQD_DISPATCH_BUSY\0" /* 35813 */
	"HQD_IQ_TIMER_BUSY\0" /* 35831 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 35849 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 35870 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 35894 */
	"HQD_MESSAGE_BUSY\0" /* 35920 */
	"HQD_PQ_FETCHER_BUSY\0" /* 35937 */
	"HQD_IB_FETCHER_BUSY\0" /* 35957 */
	"HQD_IQ_FETCHER_BUSY\0" /* 35977 */
	"HQD_EOP_FETCHER_BUSY\0" /* 35997 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 36018 */
	"HQD_FETCHER_ARB_BUSY\0" /* 36041 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 36062 */
	"HQD_ROQ_EOP_BUSY\0" /* 36081 */
	"HQD_ROQ_IQ_BUSY\0" /* 36098 */
	"HQD_ROQ_PQ_BUSY\0" /* 36114 */
	"HQD_ROQ_IB_BUSY\0" /* 36130 */
	"HQD_WPTR_POLL_BUSY\0" /* 36146 */
	"HQD_PQ_BUSY\0" /* 36165 */
	"HQD_IB_BUSY\0" /* 36177 */
	"RING_FETCHING_DATA\0" /* 36189 */
	"INDR1_FETCHING_DATA\0" /* 36208 */
	"INDR2_FETCHING_DATA\0" /* 36228 */
	"STATE_FETCHING_DATA\0" /* 36248 */
	"TCIU_WAITING_ON_FREE\0" /* 36268 */
	"TCIU_WAITING_ON_TAGS\0" /* 36289 */
	"COHER_SIZE_HI_256B\0" /* 36310 */
	"PRIM_COUNT\0" /* 36329 */
	"VS_NO_EXTRA_BUFFER\0" /* 36340 */
	"STREAMOUT_FULL_FLUSH\0" /* 36359 */
	"ES_LIMIT\0" /* 36380, 36383 */
	"VERT_REUSE\0" /* 36389 */
	"DI_PT_NONE\0" /* 36400 */
	"DI_PT_POINTLIST\0" /* 36411 */
	"DI_PT_LINELIST\0" /* 36427 */
	"DI_PT_LINESTRIP\0" /* 36442 */
	"DI_PT_TRILIST\0" /* 36458 */
	"DI_PT_TRIFAN\0" /* 36472 */
	"DI_PT_TRISTRIP\0" /* 36485 */
	"DI_PT_UNUSED_0\0" /* 36500 */
	"DI_PT_UNUSED_1\0" /* 36515 */
	"DI_PT_PATCH\0" /* 36530 */
	"DI_PT_LINELIST_ADJ\0" /* 36542 */
	"DI_PT_LINESTRIP_ADJ\0" /* 36561 */
	"DI_PT_TRILIST_ADJ\0" /* 36581 */
	"DI_PT_TRISTRIP_ADJ\0" /* 36599 */
	"DI_PT_UNUSED_3\0" /* 36618 */
	"DI_PT_UNUSED_4\0" /* 36633 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 36648 */
	"DI_PT_RECTLIST\0" /* 36670 */
	"DI_PT_LINELOOP\0" /* 36685 */
	"DI_PT_QUADLIST\0" /* 36700 */
	"DI_PT_QUADSTRIP\0" /* 36715 */
	"DI_PT_POLYGON\0" /* 36731 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 36745 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 36772 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 36799 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 36826 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 36853 */
	"DI_PT_2D_LINE_STRIP\0" /* 36877 */
	"DI_PT_2D_TRI_STRIP\0" /* 36897 */
	"DI_INDEX_SIZE_16_BIT\0" /* 36916 */
	"DI_INDEX_SIZE_32_BIT\0" /* 36937 */
	"OFFCHIP_BUFFERING\0" /* 36958 */
	"CLIP_VTX_REORDER_ENA\0" /* 36976 */
	"NUM_CLIP_SEQ\0" /* 36997 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 37010 */
	"VE_NAN_PROC_DISABLE\0" /* 37033 */
	"CURRENT_PTR\0" /* 37053 */
	"CURRENT_COUNT\0" /* 37065 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 37079 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 37104 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 37142 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 37183 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 37206 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 37229 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 37253 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 37283 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 37312 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 37338 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 37367 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 37392 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 37427 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37455 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 37485 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 37512 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 37539 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 37568 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 37597 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 37626 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37654 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 37684 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 37711 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 37739 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 37764 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 37790 */
	"RCIU_STALLED_ON_ME_READ\0" /* 37815 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 37839 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 37864 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 37892 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 37921 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 37947 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 37973 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 38000 */
	"PFP_RCIU_READ_PENDING\0" /* 38026 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 38048 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 38075 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 38097 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 38121 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 38146 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 38169 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 38196 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 38221 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38249 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38274 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 38299 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 38324 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 38353 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 38384 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 38412 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 38439 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 38469 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 38496, 38515 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 38523, 38542 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 38550 */
	"APPEND_ACTIVE_PARTITION\0" /* 38576 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 38600 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 38632 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 38659 */
	"DC_BUSY\0" /* 38685 */
	"PFP_BUSY\0" /* 38693 */
	"MEQ_BUSY\0" /* 38702 */
	"ME_BUSY\0" /* 38711 */
	"QUERY_BUSY\0" /* 38719 */
	"SURFACE_SYNC_BUSY\0" /* 38730 */
	"RCIU_BUSY\0" /* 38748 */
	"CPC_CPG_BUSY\0" /* 38758 */
	"CE_BUSY\0" /* 38771 */
	"X_8K_DWORDS\0" /* 38779 */
	"X_4K_DWORDS\0" /* 38791 */
	"X_2K_DWORDS\0" /* 38803 */
	"X_1K_DWORDS\0" /* 38815 */
	"OFFCHIP_GRANULARITY\0" /* 38827 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 38847 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 38873 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 38896 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 38921 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 38952 */
	"DISABLE_SCISSOR_FIX\0" /* 38986 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 39006 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 39033 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 39061 */
	"INST_INVALIDATE\0" /* 39096, 39101 */
	"DATA_INVALIDATE\0" /* 39112 */
	"INVALIDATE_VOLATILE\0" /* 39128 */
	"RET\0" /* 39148 */
	"RUI\0" /* 39152 */
	"RNG\0" /* 39156 */
	"SQ_EXP_MRT\0" /* 39160 */
	"SQ_EXP_MRTZ\0" /* 39171 */
	"SQ_EXP_NULL\0" /* 39183 */
	"SQ_EXP_POS\0" /* 39195 */
	"SQ_EXP_PARAM\0" /* 39206 */
	"TGT\0" /* 39219 */
	"COMPR\0" /* 39223 */
	"VM\0" /* 39229 */
	"SQ_ENC_EXP_FIELD\0" /* 39232 */
	"ENCODING\0" /* 39249 */
	"ADDRESS\0" /* 39258 */
	"BASE_ADDRESS_HI\0" /* 39266, 39271 */
	"CACHE_SWIZZLE\0" /* 39282 */
	"SWIZZLE_ENABLE\0" /* 39296 */
	"SQ_SEL_0\0" /* 39311 */
	"SQ_SEL_1\0" /* 39320 */
	"SQ_SEL_RESERVED_0\0" /* 39329, 39336 */
	"SQ_SEL_RESERVED_1\0" /* 39347, 39354 */
	"SQ_SEL_X\0" /* 39365 */
	"SQ_SEL_Y\0" /* 39374 */
	"SQ_SEL_Z\0" /* 39383 */
	"SQ_SEL_W\0" /* 39392 */
	"DST_SEL_X\0" /* 39401 */
	"DST_SEL_Y\0" /* 39411 */
	"DST_SEL_Z\0" /* 39421 */
	"DST_SEL_W\0" /* 39431 */
	"BUF_NUM_FORMAT_UNORM\0" /* 39441 */
	"BUF_NUM_FORMAT_SNORM\0" /* 39462 */
	"BUF_NUM_FORMAT_USCALED\0" /* 39483 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 39506 */
	"BUF_NUM_FORMAT_UINT\0" /* 39529 */
	"BUF_NUM_FORMAT_SINT\0" /* 39549 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 39569 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 39594 */
	"NUM_FORMAT\0" /* 39615 */
	"BUF_DATA_FORMAT_INVALID\0" /* 39626 */
	"BUF_DATA_FORMAT_8\0" /* 39650 */
	"BUF_DATA_FORMAT_16\0" /* 39668 */
	"BUF_DATA_FORMAT_8_8\0" /* 39687 */
	"BUF_DATA_FORMAT_32\0" /* 39707 */
	"BUF_DATA_FORMAT_16_16\0" /* 39726 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 39748 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 39773 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 39798 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 39825 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 39852 */
	"BUF_DATA_FORMAT_32_32\0" /* 39876 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 39898 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 39926 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 39951 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 39979 */
	"DATA_FORMAT\0" /* 40007 */
	"ELEMENT_SIZE\0" /* 40019 */
	"INDEX_STRIDE\0" /* 40032 */
	"ADD_TID_ENABLE\0" /* 40045 */
	"ATC\0" /* 40060 */
	"HASH_ENABLE\0" /* 40064 */
	"HEAP\0" /* 40076 */
	"MTYPE\0" /* 40081 */
	"SQ_RSRC_BUF\0" /* 40087 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 40099 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 40118 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 40137 */
	"MIN_LOD\0" /* 40156 */
	"IMG_DATA_FORMAT_INVALID\0" /* 40164 */
	"IMG_DATA_FORMAT_8\0" /* 40188 */
	"IMG_DATA_FORMAT_16\0" /* 40206 */
	"IMG_DATA_FORMAT_8_8\0" /* 40225 */
	"IMG_DATA_FORMAT_32\0" /* 40245 */
	"IMG_DATA_FORMAT_16_16\0" /* 40264 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 40286 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 40311 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 40336 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 40363 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 40390 */
	"IMG_DATA_FORMAT_32_32\0" /* 40414 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 40436 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 40464 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 40489 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 40517 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 40545 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 40567 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 40591 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 40615 */
	"IMG_DATA_FORMAT_8_24\0" /* 40639 */
	"IMG_DATA_FORMAT_24_8\0" /* 40660 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 40681 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 40706 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 40735 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 40760 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 40786 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 40809 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 40833 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 40860 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 40888 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 40916 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 40944 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 40966 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 40988 */
	"IMG_DATA_FORMAT_BC1\0" /* 41012 */
	"IMG_DATA_FORMAT_BC2\0" /* 41032 */
	"IMG_DATA_FORMAT_BC3\0" /* 41052 */
	"IMG_DATA_FORMAT_BC4\0" /* 41072 */
	"IMG_DATA_FORMAT_BC5\0" /* 41092 */
	"IMG_DATA_FORMAT_BC6\0" /* 41112 */
	"IMG_DATA_FORMAT_BC7\0" /* 41132 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 41152 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 41191 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 41230 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 41259 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 41288 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 41317 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 41346 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 41375 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 41404 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 41435 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 41465 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 41496 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 41526 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 41556 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 41587 */
	"IMG_DATA_FORMAT_4_4\0" /* 41618 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 41638 */
	"IMG_DATA_FORMAT_1\0" /* 41660 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 41678 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 41705 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 41729 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 41755 */
	"DATA_FORMAT_GFX6\0" /* 41789 */
	"IMG_NUM_FORMAT_UNORM\0" /* 41806 */
	"IMG_NUM_FORMAT_SNORM\0" /* 41827 */
	"IMG_NUM_FORMAT_USCALED\0" /* 41848 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 41871 */
	"IMG_NUM_FORMAT_UINT\0" /* 41894 */
	"IMG_NUM_FORMAT_SINT\0" /* 41914 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 41934 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 41959 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 41980 */
	"IMG_NUM_FORMAT_SRGB\0" /* 42006 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 42026 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 42048 */
	"IMG_NUM_FORMAT_UBINT\0" /* 42074 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 42095 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 42119 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 42146 */
	"NUM_FORMAT_GFX6\0" /* 42173 */
	"WIDTH\0" /* 42189 */
	"HEIGHT\0" /* 42195 */
	"PERF_MOD\0" /* 42202 */
	"INTERLACED\0" /* 42211 */
	"BASE_LEVEL\0" /* 42222 */
	"LAST_LEVEL\0" /* 42233 */
	"TILING_INDEX\0" /* 42244 */
	"POW2_PAD\0" /* 42257 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 42266 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 42285 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 42304 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 42323 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 42342 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 42361 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 42380 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 42399 */
	"SQ_RSRC_IMG_1D\0" /* 42418, 42430 */
	"SQ_RSRC_IMG_2D\0" /* 42433, 42445 */
	"SQ_RSRC_IMG_3D\0" /* 42448, 42460 */
	"SQ_RSRC_IMG_CUBE\0" /* 42463 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 42480 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 42501 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 42522 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 42542 */
	"PITCH_GFX6\0" /* 42568 */
	"BASE_ARRAY\0" /* 42579 */
	"LAST_ARRAY\0" /* 42590 */
	"MIN_LOD_WARN\0" /* 42601 */
	"COUNTER_BANK_ID\0" /* 42614 */
	"LOD_HDW_CNT_EN\0" /* 42630 */
	"COMPRESSION_EN\0" /* 42645 */
	"ALPHA_IS_ON_MSB\0" /* 42660 */
	"COLOR_TRANSFORM\0" /* 42676 */
	"LOST_ALPHA_BITS\0" /* 42692 */
	"LOST_COLOR_BITS\0" /* 42708 */
	"SQ_TEX_WRAP\0" /* 42724 */
	"SQ_TEX_MIRROR\0" /* 42736 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 42750 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 42774 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 42804 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 42829 */
	"SQ_TEX_CLAMP_BORDER\0" /* 42860 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 42880 */
	"CLAMP_X\0" /* 42906 */
	"CLAMP_Y\0" /* 42914 */
	"CLAMP_Z\0" /* 42922 */
	"MAX_ANISO_RATIO\0" /* 42930 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 42946 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 42973 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 42999 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 43026 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 43057 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 43086 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 43116 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 43150, 43171 */
	"DEPTH_COMPARE_FUNC\0" /* 43178 */
	"FORCE_UNNORMALIZED\0" /* 43197 */
	"ANISO_THRESHOLD\0" /* 43216 */
	"MC_COORD_TRUNC\0" /* 43232 */
	"FORCE_DEGAMMA\0" /* 43247 */
	"ANISO_BIAS\0" /* 43261 */
	"TRUNC_COORD\0" /* 43272 */
	"DISABLE_CUBE_WRAP\0" /* 43284 */
	"SQ_IMG_FILTER_MODE_BLEND\0" /* 43302 */
	"SQ_IMG_FILTER_MODE_MIN\0" /* 43327 */
	"SQ_IMG_FILTER_MODE_MAX\0" /* 43350 */
	"FILTER_MODE\0" /* 43373 */
	"COMPAT_MODE\0" /* 43385 */
	"MAX_LOD\0" /* 43397 */
	"PERF_MIP\0" /* 43405 */
	"PERF_Z\0" /* 43414 */
	"LOD_BIAS\0" /* 43421 */
	"LOD_BIAS_SEC\0" /* 43430 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 43443, 43457 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 43466, 43485 */
	"XY_MAG_FILTER\0" /* 43492 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 43506 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 43535 */
	"XY_MIN_FILTER\0" /* 43567 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 43581 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 43602 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 43624 */
	"Z_FILTER\0" /* 43647 */
	"MIP_FILTER\0" /* 43656 */
	"MIP_POINT_PRECLAMP\0" /* 43667 */
	"DISABLE_LSB_CEIL\0" /* 43686 */
	"FILTER_PREC_FIX\0" /* 43703 */
	"ANISO_OVERRIDE\0" /* 43719 */
	"BORDER_COLOR_PTR\0" /* 43734 */
	"UPGRADED_DEPTH\0" /* 43751 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 43766 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 43798 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 43831 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 43864 */
	"BORDER_COLOR_TYPE\0" /* 43893 */
	"VS_LOW_THRESHOLD\0" /* 43911 */
	"GS_LOW_THRESHOLD\0" /* 43928 */
	"ES_LOW_THRESHOLD\0" /* 43945 */
	"HS_LOW_THRESHOLD\0" /* 43962 */
	"LS_LOW_THRESHOLD\0" /* 43979 */
	"PS_CU_EN\0" /* 43996, 43999 */
	"VS_CU_EN\0" /* 44005 */
	"GS_CU_EN\0" /* 44014 */
	"ES_CU_EN\0" /* 44023 */
	"LSHS_CU_EN\0" /* 44032 */
	"X_R0\0" /* 44043 */
	"RING_ORDER_TS0\0" /* 44048 */
	"RING_ORDER_TS1\0" /* 44063 */
	"RING_ORDER_TS2\0" /* 44078 */
	"PIPE_ORDER_TS0\0" /* 44093 */
	"PIPE_ORDER_TS1\0" /* 44108 */
	"PIPE_ORDER_TS2\0" /* 44123 */
	"PIPE_ORDER_TS3\0" /* 44138 */
	"TS0_DUR_MULT\0" /* 44153 */
	"TS1_DUR_MULT\0" /* 44166 */
	"TS2_DUR_MULT\0" /* 44179 */
	"TS3_DUR_MULT\0" /* 44192 */
	"TS0_DURATION\0" /* 44205 */
	"TS1_DURATION\0" /* 44218 */
	"TS2_DURATION\0" /* 44231 */
	"GPR_WRITE_PRIORITY\0" /* 44244 */
	"EXP_PRIORITY_ORDER\0" /* 44263 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 44282 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 44304 */
	"RSRC_MGMT_RESET\0" /* 44326 */
	"X_DELAY_14_CLKS\0" /* 44342 */
	"X_DELAY_16_CLKS\0" /* 44358 */
	"X_DELAY_18_CLKS\0" /* 44374 */
	"X_DELAY_20_CLKS\0" /* 44390 */
	"X_DELAY_22_CLKS\0" /* 44406 */
	"X_DELAY_24_CLKS\0" /* 44422 */
	"X_DELAY_26_CLKS\0" /* 44438 */
	"X_DELAY_28_CLKS\0" /* 44454 */
	"X_DELAY_30_CLKS\0" /* 44470 */
	"X_DELAY_32_CLKS\0" /* 44486 */
	"X_DELAY_34_CLKS\0" /* 44502 */
	"X_DELAY_4_CLKS\0" /* 44518 */
	"X_DELAY_6_CLKS\0" /* 44533 */
	"X_DELAY_8_CLKS\0" /* 44548 */
	"X_DELAY_10_CLKS\0" /* 44563 */
	"X_DELAY_12_CLKS\0" /* 44579 */
	"VTX_DONE_DELAY\0" /* 44595 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 44610 */
	"PC_LIMIT_ENABLE\0" /* 44634 */
	"PC_LIMIT_STRICT\0" /* 44650 */
	"PC_LIMIT_SIZE\0" /* 44666 */
	"TYPE_A\0" /* 44680 */
	"VGPR_A\0" /* 44687 */
	"SGPR_A\0" /* 44694 */
	"LDS_A\0" /* 44701 */
	"WAVES_A\0" /* 44707 */
	"EN_A\0" /* 44715 */
	"TYPE_B\0" /* 44720 */
	"VGPR_B\0" /* 44727 */
	"SGPR_B\0" /* 44734 */
	"LDS_B\0" /* 44741 */
	"WAVES_B\0" /* 44747 */
	"EN_B\0" /* 44755 */
	"MSAA1_X\0" /* 44760 */
	"MSAA1_Y\0" /* 44768 */
	"MSAA2_X\0" /* 44776 */
	"MSAA2_Y\0" /* 44784 */
	"MSAA4_X\0" /* 44792 */
	"MSAA4_Y\0" /* 44800 */
	"MSAA8_X\0" /* 44808 */
	"MSAA8_Y\0" /* 44816 */
	"MSAA16_X\0" /* 44824 */
	"MSAA16_Y\0" /* 44833 */
	"NUM_PIPES\0" /* 44842 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 44852 */
	"BANK_INTERLEAVE_SIZE\0" /* 44878 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 44899 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 44923 */
	"NUM_GPUS_GFX6\0" /* 44947 */
	"MULTI_GPU_TILE_SIZE\0" /* 44961 */
	"ROW_SIZE\0" /* 44981 */
	"NUM_LOWER_PIPES\0" /* 44990 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 45006 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 45037 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 45065 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 45094 */
	"MICRO_TILE_MODE\0" /* 45123 */
	"ARRAY_LINEAR_GENERAL\0" /* 45139, 45145 */
	"ARRAY_LINEAR_ALIGNED\0" /* 45160 */
	"ARRAY_1D_TILED_THIN1\0" /* 45181 */
	"ARRAY_1D_TILED_THICK\0" /* 45202 */
	"ARRAY_2D_TILED_THIN1\0" /* 45223 */
	"ARRAY_2D_TILED_THICK\0" /* 45244 */
	"ARRAY_2D_TILED_XTHICK\0" /* 45265 */
	"ARRAY_3D_TILED_THIN1\0" /* 45287 */
	"ARRAY_3D_TILED_THICK\0" /* 45308 */
	"ARRAY_3D_TILED_XTHICK\0" /* 45329 */
	"ARRAY_POWER_SAVE\0" /* 45351 */
	"ARRAY_MODE\0" /* 45368 */
	"ADDR_SURF_P2\0" /* 45379 */
	"ADDR_SURF_P2_RESERVED0\0" /* 45392 */
	"ADDR_SURF_P2_RESERVED1\0" /* 45415 */
	"ADDR_SURF_P2_RESERVED2\0" /* 45438, 45451 */
	"X_ADDR_SURF_P4_8X16\0" /* 45461 */
	"X_ADDR_SURF_P4_16X16\0" /* 45481 */
	"X_ADDR_SURF_P4_16X32\0" /* 45502 */
	"X_ADDR_SURF_P4_32X32\0" /* 45523 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 45544 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 45570 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 45596 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 45622 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 45649 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 45676 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 45703 */
	"PIPE_CONFIG\0" /* 45730 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 45742 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 45767 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 45793 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 45819 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 45845 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 45870 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 45895 */
	"TILE_SPLIT\0" /* 45920 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 45931 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 45954 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 45977 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 46000 */
	"BANK_WIDTH\0" /* 46023 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 46034 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 46058 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 46082 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 46106 */
	"BANK_HEIGHT\0" /* 46130 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 46142 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 46167 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 46192 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 46217 */
	"MACRO_TILE_ASPECT\0" /* 46242 */
	"ADDR_SURF_2_BANK\0" /* 46260 */
	"ADDR_SURF_4_BANK\0" /* 46277 */
	"ADDR_SURF_8_BANK\0" /* 46294 */
	"ADDR_SURF_16_BANK\0" /* 46311 */
	"NUM_BANKS\0" /* 46329 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 46339 */
	"MICRO_TILE_MODE_NEW\0" /* 46370 */
	"SAMPLE_SPLIT\0" /* 46390 */
	"MEM_BASE\0" /* 46403 */
	"WAVE_LIMIT\0" /* 46412 */
	"LOCK_LOW_THRESHOLD\0" /* 46423 */
	"VGPRS\0" /* 46442 */
	"SGPRS\0" /* 46448 */
	"FP_32_DENORMS\0" /* 46454 */
	"FP_64_DENORMS\0" /* 46468 */
	"FP_ALL_DENORMS\0" /* 46482 */
	"FLOAT_MODE\0" /* 46497 */
	"PRIV\0" /* 46508 */
	"DX10_CLAMP\0" /* 46513 */
	"DEBUG_MODE\0" /* 46524 */
	"IEEE_MODE\0" /* 46535 */
	"CU_GROUP_DISABLE\0" /* 46545 */
	"CACHE_CTL\0" /* 46562 */
	"CDBG_USER\0" /* 46572 */
	"SCRATCH_EN\0" /* 46582 */
	"USER_SGPR\0" /* 46593 */
	"TRAP_PRESENT\0" /* 46603 */
	"WAVE_CNT_EN\0" /* 46616 */
	"EXTRA_LDS_SIZE\0" /* 46628, 46634 */
	"EXCP_EN_SI\0" /* 46643 */
	"EXCP_EN\0" /* 46654 */
	"VGPR_COMP_CNT\0" /* 46662 */
	"CU_GROUP_ENABLE\0" /* 46676 */
	"OC_LDS_EN\0" /* 46692 */
	"SO_BASE0_EN\0" /* 46702 */
	"SO_BASE1_EN\0" /* 46714 */
	"SO_BASE2_EN\0" /* 46726 */
	"SO_BASE3_EN\0" /* 46738 */
	"SO_EN\0" /* 46750 */
	"DISPATCH_DRAW_EN\0" /* 46756 */
	"GROUP_FIFO_DEPTH\0" /* 46773 */
	"TG_SIZE_EN\0" /* 46790 */
	"EXCP_EN_CIK_VI\0" /* 46801 */
	"COMPUTE_SHADER_EN\0" /* 46816 */
	"PARTIAL_TG_EN\0" /* 46834 */
	"FORCE_START_AT_000\0" /* 46848 */
	"ORDERED_APPEND_ENBL\0" /* 46867 */
	"ORDERED_APPEND_MODE\0" /* 46887 */
	"USE_THREAD_DIMENSIONS\0" /* 46907 */
	"ORDER_MODE\0" /* 46929 */
	"DISPATCH_CACHE_CNTL\0" /* 46940 */
	"SCALAR_L1_INV_VOL\0" /* 46960, 46974 */
	"VECTOR_L1_INV_VOL\0" /* 46978 */
	"DATA_ATC\0" /* 46996 */
	"RESTORE\0" /* 47005 */
	"NUM_THREAD_FULL\0" /* 47013 */
	"NUM_THREAD_PARTIAL\0" /* 47029 */
	"INST_ATC\0" /* 47048 */
	"BULKY\0" /* 47057 */
	"TGID_X_EN\0" /* 47063 */
	"TGID_Y_EN\0" /* 47073 */
	"TGID_Z_EN\0" /* 47083 */
	"TIDIG_COMP_CNT\0" /* 47093 */
	"EXCP_EN_MSB\0" /* 47108 */
	"WAVES_PER_SH_SI\0" /* 47120 */
	"WAVES_PER_SH\0" /* 47136 */
	"TG_PER_CU\0" /* 47149 */
	"LOCK_THRESHOLD\0" /* 47159 */
	"SIMD_DEST_CNTL\0" /* 47174 */
	"FORCE_SIMD_DIST\0" /* 47189 */
	"CU_GROUP_COUNT\0" /* 47205 */
	"SH0_CU_EN\0" /* 47220 */
	"SH1_CU_EN\0" /* 47230 */
	"WAVES\0" /* 47240 */
	"WAVESIZE\0" /* 47246 */
	"SEND_SEID\0" /* 47255 */
	"RESERVED3\0" /* 47265 */
	"RESERVED4\0" /* 47275 */
	"WAVE_ID_BASE\0" /* 47285 */
	"PAYLOAD\0" /* 47298 */
	"IS_EVENT\0" /* 47306 */
	"IS_STATE\0" /* 47315 */
	"PERF_SEL\0" /* 47324 */
	"PERF_SEL1\0" /* 47333 */
	"CNTR_MODE\0" /* 47343 */
	"PERF_SEL2\0" /* 47353 */
	"PERF_SEL3\0" /* 47363 */
	"DISABLE_AND_RESET\0" /* 47373 */
	"START_COUNTING\0" /* 47391 */
	"STOP_COUNTING\0" /* 47406 */
	"PERFMON_STATE\0" /* 47420 */
	"SPM_PERFMON_STATE\0" /* 47434 */
	"PERFMON_ENABLE_MODE\0" /* 47452 */
	"PERFMON_SAMPLE_ENABLE\0" /* 47472 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 47494 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 47521 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 47548 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 47575 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 47601 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 47627 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 47654 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 47680 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 47706 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 47734 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 47760 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 47786 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 47812 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 47838 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 47865 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 47892 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 47919 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 47945 */
	"PERF_MODE\0" /* 47971 */
	"PERF_MODE1\0" /* 47981 */
	"PERF_MODE3\0" /* 47992 */
	"PERF_MODE2\0" /* 48003 */
	"PERF_SEID_IGNORE_MASK\0" /* 48014 */
	"BIN0_MIN\0" /* 48036 */
	"BIN0_MAX\0" /* 48045 */
	"BIN1_MIN\0" /* 48054 */
	"BIN1_MAX\0" /* 48063 */
	"BIN2_MIN\0" /* 48072 */
	"BIN2_MAX\0" /* 48081 */
	"BIN3_MIN\0" /* 48090 */
	"BIN3_MAX\0" /* 48099 */
	"SQC_BANK_MASK\0" /* 48108 */
	"SQC_CLIENT_MASK\0" /* 48122 */
	"SPM_MODE\0" /* 48138 */
	"SIMD_MASK\0" /* 48147 */
	"PS_EN\0" /* 48157 */
	"VS_EN\0" /* 48163 */
	"GS_EN\0" /* 48169 */
	"HS_EN\0" /* 48175 */
	"LS_EN\0" /* 48181 */
	"CS_EN\0" /* 48187 */
	"CNTR_RATE\0" /* 48193 */
	"DISABLE_FLUSH\0" /* 48203 */
	"SH0_MASK\0" /* 48217 */
	"SH1_MASK\0" /* 48226 */
	"FORCE_EN\0" /* 48235 */
	"PERFCOUNTER_SELECT1\0" /* 48244 */
	"PERFCOUNTER_SELECT2\0" /* 48264 */
	"PERFCOUNTER_SELECT3\0" /* 48284 */
	"OP_FILTER_ENABLE\0" /* 48304 */
	"OP_FILTER_SEL\0" /* 48321 */
	"FORMAT_FILTER_ENABLE\0" /* 48335 */
	"FORMAT_FILTER_SEL\0" /* 48356 */
	"CLEAR_FILTER_ENABLE\0" /* 48374 */
	"CLEAR_FILTER_SEL\0" /* 48394 */
	"MRT_FILTER_ENABLE\0" /* 48411 */
	"MRT_FILTER_SEL\0" /* 48429 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 48444 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 48470 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 48493 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 48521 */
	"DEPTH_CLEAR_ENABLE\0" /* 48546 */
	"STENCIL_CLEAR_ENABLE\0" /* 48565 */
	"DEPTH_COPY\0" /* 48586 */
	"STENCIL_COPY\0" /* 48597 */
	"RESUMMARIZE_ENABLE\0" /* 48610 */
	"STENCIL_COMPRESS_DISABLE\0" /* 48629 */
	"DEPTH_COMPRESS_DISABLE\0" /* 48654 */
	"COPY_CENTROID\0" /* 48677 */
	"COPY_SAMPLE\0" /* 48691 */
	"DECOMPRESS_ENABLE\0" /* 48703 */
	"ZPASS_INCREMENT_DISABLE\0" /* 48721 */
	"PERFECT_ZPASS_COUNTS\0" /* 48745 */
	"SAMPLE_RATE\0" /* 48766 */
	"ZPASS_ENABLE\0" /* 48778 */
	"ZFAIL_ENABLE\0" /* 48791 */
	"SFAIL_ENABLE\0" /* 48804 */
	"DBFAIL_ENABLE\0" /* 48817 */
	"SLICE_EVEN_ENABLE\0" /* 48831 */
	"SLICE_ODD_ENABLE\0" /* 48849 */
	"SLICE_START\0" /* 48866 */
	"SLICE_MAX\0" /* 48878 */
	"Z_READ_ONLY\0" /* 48888 */
	"STENCIL_READ_ONLY\0" /* 48900 */
	"FORCE_OFF\0" /* 48918 */
	"FORCE_ENABLE\0" /* 48928 */
	"FORCE_DISABLE\0" /* 48941 */
	"FORCE_RESERVED\0" /* 48955 */
	"FORCE_HIZ_ENABLE\0" /* 48970, 48978 */
	"FORCE_HIS_ENABLE0\0" /* 48987, 48997 */
	"FORCE_HIS_ENABLE1\0" /* 49005, 49015 */
	"FORCE_SHADER_Z_ORDER\0" /* 49023, 49036 */
	"FAST_Z_DISABLE\0" /* 49044 */
	"FAST_STENCIL_DISABLE\0" /* 49059 */
	"NOOP_CULL_DISABLE\0" /* 49080 */
	"FORCE_COLOR_KILL\0" /* 49098 */
	"FORCE_Z_READ\0" /* 49115 */
	"FORCE_STENCIL_READ\0" /* 49128 */
	"FORCE_FULL_Z_RANGE\0" /* 49147 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 49166 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 49190 */
	"IGNORE_SC_ZRANGE\0" /* 49213 */
	"DISABLE_FULLY_COVERED\0" /* 49230 */
	"FORCE_SUMM_OFF\0" /* 49252 */
	"FORCE_SUMM_MINZ\0" /* 49267 */
	"FORCE_SUMM_MAXZ\0" /* 49283 */
	"FORCE_SUMM_BOTH\0" /* 49299 */
	"FORCE_Z_LIMIT_SUMM\0" /* 49315 */
	"MAX_TILES_IN_DTT\0" /* 49334 */
	"DISABLE_TILE_RATE_TILES\0" /* 49351 */
	"FORCE_Z_DIRTY\0" /* 49375, 49383 */
	"FORCE_STENCIL_DIRTY\0" /* 49389 */
	"FORCE_Z_VALID\0" /* 49409 */
	"FORCE_STENCIL_VALID\0" /* 49423 */
	"PRESERVE_COMPRESSION\0" /* 49443, 49452 */
	"PSLC_AUTO\0" /* 49464 */
	"PSLC_ON_HANG_ONLY\0" /* 49474 */
	"PSLC_ASAP\0" /* 49492 */
	"PSLC_COUNTDOWN\0" /* 49502 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 49517 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 49546 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 49577 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 49613 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 49648 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 49676 */
	"DISABLE_REG_SNOOP\0" /* 49698 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 49716 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 49748 */
	"HIZ_ZFUNC\0" /* 49774, 49778 */
	"HIS_SFUNC_FF\0" /* 49784 */
	"HIS_SFUNC_BF\0" /* 49797 */
	"PRESERVE_ZRANGE\0" /* 49810 */
	"PRESERVE_SRESULTS\0" /* 49826 */
	"DISABLE_FAST_PASS\0" /* 49844 */
	"TL_X\0" /* 49862 */
	"TL_Y\0" /* 49867 */
	"BR_X\0" /* 49872 */
	"BR_Y\0" /* 49877 */
	"ADDR5_SWIZZLE_MASK\0" /* 49882 */
	"ARRAY_PRT_TILED_THIN1\0" /* 49901 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 49923 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 49948 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 49975 */
	"Z_INVALID\0" /* 50003 */
	"Z_16\0" /* 50013 */
	"Z_24\0" /* 50018 */
	"Z_32_FLOAT\0" /* 50023 */
	"NUM_SAMPLES\0" /* 50034 */
	"TILE_MODE_INDEX\0" /* 50046 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 50062 */
	"ALLOW_EXPCLEAR\0" /* 50086 */
	"READ_SIZE\0" /* 50101 */
	"TILE_SURFACE_ENABLE\0" /* 50111 */
	"CLEAR_DISALLOWED\0" /* 50131 */
	"ZRANGE_PRECISION\0" /* 50148 */
	"STENCIL_INVALID\0" /* 50165 */
	"STENCIL_8\0" /* 50181 */
	"TILE_STENCIL_DISABLE\0" /* 50191 */
	"PITCH_TILE_MAX\0" /* 50212, 50218 */
	"HEIGHT_TILE_MAX\0" /* 50227 */
	"SLICE_TILE_MAX\0" /* 50243 */
	"WINDOW_X_OFFSET\0" /* 50258 */
	"WINDOW_Y_OFFSET\0" /* 50274, 50281 */
	"WINDOW_OFFSET_DISABLE\0" /* 50290 */
	"IN_20\0" /* 50312 */
	"IN_21\0" /* 50318 */
	"IN_210\0" /* 50324 */
	"IN_30\0" /* 50331 */
	"IN_31\0" /* 50337 */
	"IN_310\0" /* 50343 */
	"IN_320\0" /* 50350 */
	"IN_321\0" /* 50357 */
	"IN_3210\0" /* 50364 */
	"CLIP_RULE\0" /* 50372 */
	"ER_TRI\0" /* 50382 */
	"ER_RECT\0" /* 50389 */
	"ER_LINE_LR\0" /* 50397 */
	"ER_LINE_RL\0" /* 50408 */
	"ER_LINE_TB\0" /* 50419 */
	"ER_LINE_BT\0" /* 50430 */
	"HW_SCREEN_OFFSET_X\0" /* 50441 */
	"HW_SCREEN_OFFSET_Y\0" /* 50460 */
	"TARGET0_ENABLE\0" /* 50479 */
	"TARGET1_ENABLE\0" /* 50494 */
	"TARGET2_ENABLE\0" /* 50509 */
	"TARGET3_ENABLE\0" /* 50524 */
	"TARGET4_ENABLE\0" /* 50539 */
	"TARGET5_ENABLE\0" /* 50554 */
	"TARGET6_ENABLE\0" /* 50569 */
	"TARGET7_ENABLE\0" /* 50584 */
	"OUTPUT0_ENABLE\0" /* 50599 */
	"OUTPUT1_ENABLE\0" /* 50614 */
	"OUTPUT2_ENABLE\0" /* 50629 */
	"OUTPUT3_ENABLE\0" /* 50644 */
	"OUTPUT4_ENABLE\0" /* 50659 */
	"OUTPUT5_ENABLE\0" /* 50674 */
	"OUTPUT6_ENABLE\0" /* 50689 */
	"OUTPUT7_ENABLE\0" /* 50704 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 50719 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 50742 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 50765 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 50788 */
	"RB_MAP_PKR0\0" /* 50811 */
	"RB_MAP_PKR1\0" /* 50823 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 50835 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 50860 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 50885 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 50910 */
	"RB_XSEL2\0" /* 50935 */
	"RB_XSEL\0" /* 50944 */
	"RB_YSEL\0" /* 50952 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 50960 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 50984 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 51008 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 51032 */
	"PKR_MAP\0" /* 51056 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 51064 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 51089 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 51114 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 51139 */
	"PKR_XSEL\0" /* 51164 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 51173 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 51198 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 51223 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 51248 */
	"PKR_YSEL\0" /* 51273 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 51282 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 51308 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 51334 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 51360 */
	"PKR_XSEL2\0" /* 51386 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 51396 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 51419 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 51442 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 51465 */
	"SC_MAP\0" /* 51488 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 51495 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 51529 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 51564 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 51599 */
	"SC_XSEL\0" /* 51634 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 51642 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 51676 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 51711 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 51746 */
	"SC_YSEL\0" /* 51781 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 51789 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 51812 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 51835 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 51858 */
	"SE_MAP\0" /* 51881 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 51888 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 51922 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 51957 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 51992 */
	"SE_XSEL_GFX6\0" /* 52027 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 52040 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 52074 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 52109 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 52144 */
	"SE_YSEL_GFX6\0" /* 52179 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 52192 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 52220 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 52248 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 52276 */
	"SE_PAIR_MAP\0" /* 52304 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 52316 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 52355 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 52395 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 52435 */
	"SE_PAIR_XSEL_GFX6\0" /* 52475 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 52493 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 52532 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 52572 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 52612 */
	"SE_PAIR_YSEL_GFX6\0" /* 52652 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 52670 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 52697 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 52736 */
	"STENCIL_KEEP\0" /* 52765 */
	"STENCIL_ZERO\0" /* 52778 */
	"STENCIL_ONES\0" /* 52791 */
	"STENCIL_REPLACE_TEST\0" /* 52804 */
	"STENCIL_REPLACE_OP\0" /* 52825 */
	"STENCIL_ADD_CLAMP\0" /* 52844 */
	"STENCIL_SUB_CLAMP\0" /* 52862 */
	"STENCIL_INVERT\0" /* 52880 */
	"STENCIL_ADD_WRAP\0" /* 52895 */
	"STENCIL_SUB_WRAP\0" /* 52912 */
	"STENCIL_AND\0" /* 52929 */
	"STENCIL_OR\0" /* 52941 */
	"STENCIL_XOR\0" /* 52952 */
	"STENCIL_NAND\0" /* 52964 */
	"STENCIL_NOR\0" /* 52977 */
	"STENCIL_XNOR\0" /* 52989 */
	"STENCILFAIL\0" /* 53002 */
	"STENCILZPASS\0" /* 53014 */
	"STENCILZFAIL\0" /* 53027 */
	"STENCILFAIL_BF\0" /* 53040 */
	"STENCILZPASS_BF\0" /* 53055 */
	"STENCILZFAIL_BF\0" /* 53071 */
	"STENCILTESTVAL\0" /* 53087 */
	"STENCILMASK\0" /* 53102 */
	"STENCILWRITEMASK\0" /* 53114 */
	"STENCILOPVAL\0" /* 53131 */
	"STENCILTESTVAL_BF\0" /* 53144 */
	"STENCILMASK_BF\0" /* 53162 */
	"STENCILWRITEMASK_BF\0" /* 53177 */
	"STENCILOPVAL_BF\0" /* 53197 */
	"X_0_0F\0" /* 53213 */
	"DEFAULT_VAL\0" /* 53220 */
	"FLAT_SHADE\0" /* 53232 */
	"CYL_WRAP\0" /* 53243 */
	"PT_SPRITE_TEX\0" /* 53252 */
	"DUP\0" /* 53266 */
	"FP16_INTERP_MODE\0" /* 53270 */
	"USE_DEFAULT_ATTR1\0" /* 53287 */
	"DEFAULT_VAL_ATTR1\0" /* 53305 */
	"PT_SPRITE_TEX_ATTR1\0" /* 53323 */
	"ATTR0_VALID\0" /* 53343 */
	"ATTR1_VALID\0" /* 53355 */
	"VS_EXPORT_COUNT\0" /* 53367 */
	"VS_HALF_PACK\0" /* 53383 */
	"VS_EXPORTS_FOG\0" /* 53396 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 53411 */
	"PERSP_SAMPLE_ENA\0" /* 53431 */
	"PERSP_CENTER_ENA\0" /* 53448 */
	"PERSP_CENTROID_ENA\0" /* 53465 */
	"PERSP_PULL_MODEL_ENA\0" /* 53484 */
	"LINEAR_SAMPLE_ENA\0" /* 53505 */
	"LINEAR_CENTER_ENA\0" /* 53523 */
	"LINEAR_CENTROID_ENA\0" /* 53541 */
	"LINE_STIPPLE_TEX_ENA\0" /* 53561 */
	"POS_X_FLOAT_ENA\0" /* 53582 */
	"POS_Y_FLOAT_ENA\0" /* 53598 */
	"POS_Z_FLOAT_ENA\0" /* 53614 */
	"POS_W_FLOAT_ENA\0" /* 53630 */
	"FRONT_FACE_ENA\0" /* 53646 */
	"ANCILLARY_ENA\0" /* 53661 */
	"SAMPLE_COVERAGE_ENA\0" /* 53675 */
	"POS_FIXED_PT_ENA\0" /* 53695 */
	"FLAT_SHADE_ENA\0" /* 53712 */
	"PNT_SPRITE_ENA\0" /* 53727 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 53742 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 53763 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 53784 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 53805 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 53826 */
	"PNT_SPRITE_OVRD_X\0" /* 53850 */
	"PNT_SPRITE_OVRD_Y\0" /* 53868 */
	"PNT_SPRITE_OVRD_Z\0" /* 53886 */
	"PNT_SPRITE_OVRD_W\0" /* 53904 */
	"PNT_SPRITE_TOP_1\0" /* 53922 */
	"NUM_INTERP\0" /* 53939 */
	"PARAM_GEN\0" /* 53950 */
	"FOG_ADDR\0" /* 53960 */
	"BC_OPTIMIZE_DISABLE\0" /* 53969 */
	"PASS_FOG_THROUGH_PS\0" /* 53989 */
	"PERSP_CENTER_CNTL\0" /* 54009 */
	"PERSP_CENTROID_CNTL\0" /* 54027 */
	"LINEAR_CENTER_CNTL\0" /* 54047 */
	"LINEAR_CENTROID_CNTL\0" /* 54066 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 54087 */
	"POS_FLOAT_LOCATION\0" /* 54136 */
	"POS_FLOAT_ULC\0" /* 54155 */
	"FRONT_FACE_ALL_BITS\0" /* 54169 */
	"NUM_PS_WAVES\0" /* 54189 */
	"NUM_VS_WAVES\0" /* 54202 */
	"NUM_GS_WAVES\0" /* 54215 */
	"NUM_ES_WAVES\0" /* 54228 */
	"NUM_HS_WAVES\0" /* 54241 */
	"NUM_LS_WAVES\0" /* 54254 */
	"SPI_SHADER_NONE\0" /* 54267 */
	"SPI_SHADER_1COMP\0" /* 54283 */
	"SPI_SHADER_2COMP\0" /* 54300 */
	"SPI_SHADER_4COMPRESS\0" /* 54317 */
	"SPI_SHADER_4COMP\0" /* 54338 */
	"POS0_EXPORT_FORMAT\0" /* 54355 */
	"POS1_EXPORT_FORMAT\0" /* 54374 */
	"POS2_EXPORT_FORMAT\0" /* 54393 */
	"POS3_EXPORT_FORMAT\0" /* 54412 */
	"SPI_SHADER_ZERO\0" /* 54431 */
	"SPI_SHADER_32_R\0" /* 54447 */
	"SPI_SHADER_32_GR\0" /* 54463 */
	"SPI_SHADER_32_AR\0" /* 54480 */
	"SPI_SHADER_FP16_ABGR\0" /* 54497 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 54518 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 54542 */
	"SPI_SHADER_UINT16_ABGR\0" /* 54566 */
	"SPI_SHADER_SINT16_ABGR\0" /* 54589 */
	"SPI_SHADER_32_ABGR\0" /* 54612 */
	"Z_EXPORT_FORMAT\0" /* 54631 */
	"COL0_EXPORT_FORMAT\0" /* 54647 */
	"COL1_EXPORT_FORMAT\0" /* 54666 */
	"COL2_EXPORT_FORMAT\0" /* 54685 */
	"COL3_EXPORT_FORMAT\0" /* 54704 */
	"COL4_EXPORT_FORMAT\0" /* 54723 */
	"COL5_EXPORT_FORMAT\0" /* 54742 */
	"COL6_EXPORT_FORMAT\0" /* 54761 */
	"COL7_EXPORT_FORMAT\0" /* 54780 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 54799 */
	"SX_RT_EXPORT_32_R\0" /* 54826 */
	"SX_RT_EXPORT_32_A\0" /* 54844 */
	"SX_RT_EXPORT_10_11_11\0" /* 54862 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 54884 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 54908 */
	"SX_RT_EXPORT_5_6_5\0" /* 54929 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 54948 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 54969 */
	"SX_RT_EXPORT_16_16_GR\0" /* 54990 */
	"SX_RT_EXPORT_16_16_AR\0" /* 55012 */
	"MRT0\0" /* 55034 */
	"MRT1\0" /* 55039 */
	"MRT2\0" /* 55044 */
	"MRT3\0" /* 55049 */
	"MRT4\0" /* 55054 */
	"MRT5\0" /* 55059 */
	"MRT6\0" /* 55064 */
	"MRT7\0" /* 55069 */
	"EXACT\0" /* 55074 */
	"11BIT_FORMAT\0" /* 55080 */
	"10BIT_FORMAT\0" /* 55093 */
	"8BIT_FORMAT\0" /* 55106 */
	"6BIT_FORMAT\0" /* 55118 */
	"5BIT_FORMAT\0" /* 55130 */
	"4BIT_FORMAT\0" /* 55142 */
	"MRT0_EPSILON\0" /* 55154 */
	"MRT1_EPSILON\0" /* 55167 */
	"MRT2_EPSILON\0" /* 55180 */
	"MRT3_EPSILON\0" /* 55193 */
	"MRT4_EPSILON\0" /* 55206 */
	"MRT5_EPSILON\0" /* 55219 */
	"MRT6_EPSILON\0" /* 55232 */
	"MRT7_EPSILON\0" /* 55245 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 55258 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 55281 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 55304 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 55327 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 55350 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 55373 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 55396 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 55419 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 55442 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 55465 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 55488 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 55511 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 55534 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 55557 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 55580 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 55603 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 55626 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 55649 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 55684 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 55719 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 55751 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 55783 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 55815 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 55847 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 55881 */
	"COLOR_SRC_OPT\0" /* 55917 */
	"COLOR_DST_OPT\0" /* 55931 */
	"OPT_COMB_NONE\0" /* 55945 */
	"OPT_COMB_ADD\0" /* 55959 */
	"OPT_COMB_SUBTRACT\0" /* 55972 */
	"OPT_COMB_MIN\0" /* 55990 */
	"OPT_COMB_MAX\0" /* 56003 */
	"OPT_COMB_REVSUBTRACT\0" /* 56016 */
	"OPT_COMB_BLEND_DISABLED\0" /* 56037 */
	"OPT_COMB_SAFE_ADD\0" /* 56061 */
	"COLOR_COMB_FCN\0" /* 56079 */
	"ALPHA_SRC_OPT\0" /* 56094 */
	"ALPHA_DST_OPT\0" /* 56108 */
	"ALPHA_COMB_FCN\0" /* 56122 */
	"BLEND_ZERO\0" /* 56137 */
	"BLEND_ONE\0" /* 56148 */
	"BLEND_SRC_COLOR\0" /* 56158 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 56174 */
	"BLEND_SRC_ALPHA\0" /* 56200 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 56216 */
	"BLEND_DST_ALPHA\0" /* 56242 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 56258 */
	"BLEND_DST_COLOR\0" /* 56284 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 56300 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 56326 */
	"BLEND_CONSTANT_COLOR\0" /* 56351 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 56372 */
	"BLEND_SRC1_COLOR\0" /* 56403 */
	"BLEND_INV_SRC1_COLOR\0" /* 56420 */
	"BLEND_SRC1_ALPHA\0" /* 56441 */
	"BLEND_INV_SRC1_ALPHA\0" /* 56458 */
	"BLEND_CONSTANT_ALPHA\0" /* 56479 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 56500 */
	"COLOR_SRCBLEND\0" /* 56531 */
	"COMB_DST_PLUS_SRC\0" /* 56546 */
	"COMB_SRC_MINUS_DST\0" /* 56564 */
	"COMB_MIN_DST_SRC\0" /* 56583 */
	"COMB_MAX_DST_SRC\0" /* 56600 */
	"COMB_DST_MINUS_SRC\0" /* 56617 */
	"COLOR_DESTBLEND\0" /* 56636 */
	"ALPHA_SRCBLEND\0" /* 56652 */
	"ALPHA_DESTBLEND\0" /* 56667 */
	"SEPARATE_ALPHA_BLEND\0" /* 56683 */
	"DISABLE_ROP3\0" /* 56704, 56712 */
	"SRC_STATE_ID\0" /* 56717 */
	"BASE_ADDR_GFX6\0" /* 56730 */
	"DI_SRC_SEL_DMA\0" /* 56745 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 56760 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 56781 */
	"DI_SRC_SEL_RESERVED\0" /* 56803 */
	"SOURCE_SELECT\0" /* 56823 */
	"DI_MAJOR_MODE_0\0" /* 56837 */
	"DI_MAJOR_MODE_1\0" /* 56853 */
	"MAJOR_MODE\0" /* 56869 */
	"NOT_EOP\0" /* 56880 */
	"USE_OPAQUE\0" /* 56888 */
	"ADDRESS_LOW\0" /* 56899 */
	"STENCIL_ENABLE\0" /* 56911 */
	"Z_WRITE_ENABLE\0" /* 56926 */
	"DEPTH_BOUNDS_ENABLE\0" /* 56941 */
	"FRAG_NEVER\0" /* 56961 */
	"FRAG_LESS\0" /* 56972 */
	"FRAG_EQUAL\0" /* 56982 */
	"FRAG_LEQUAL\0" /* 56993 */
	"FRAG_GREATER\0" /* 57005 */
	"FRAG_NOTEQUAL\0" /* 57018 */
	"FRAG_GEQUAL\0" /* 57032 */
	"FRAG_ALWAYS\0" /* 57044 */
	"BACKFACE_ENABLE\0" /* 57056 */
	"REF_NEVER\0" /* 57072 */
	"REF_LESS\0" /* 57082 */
	"REF_EQUAL\0" /* 57091 */
	"REF_LEQUAL\0" /* 57101 */
	"REF_GREATER\0" /* 57112 */
	"REF_NOTEQUAL\0" /* 57124 */
	"REF_GEQUAL\0" /* 57137 */
	"REF_ALWAYS\0" /* 57148 */
	"STENCILFUNC\0" /* 57159 */
	"STENCILFUNC_BF\0" /* 57171 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 57186 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 57220 */
	"MAX_ANCHOR_SAMPLES\0" /* 57255 */
	"PS_ITER_SAMPLES\0" /* 57274 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 57290 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 57314 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 57340 */
	"INCOHERENT_EQAA_READS\0" /* 57367 */
	"INTERPOLATE_COMP_Z\0" /* 57389 */
	"INTERPOLATE_SRC_Z\0" /* 57408 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 57426 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 57453 */
	"OVERRASTERIZATION_AMOUNT\0" /* 57480 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 57505 */
	"DISABLE_DUAL_QUAD\0" /* 57536 */
	"DEGAMMA_ENABLE\0" /* 57554 */
	"CB_DISABLE\0" /* 57569 */
	"CB_NORMAL\0" /* 57580 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 57590, 57603 */
	"CB_RESOLVE\0" /* 57614 */
	"CB_FMASK_DECOMPRESS\0" /* 57625 */
	"CB_DCC_DECOMPRESS\0" /* 57645 */
	"ROP3_CLEAR\0" /* 57663 */
	"ROP3_NOR\0" /* 57674 */
	"ROP3_AND_INVERTED\0" /* 57683 */
	"ROP3_COPY_INVERTED\0" /* 57701 */
	"ROP3_AND_REVERSE\0" /* 57720 */
	"ROP3_INVERT\0" /* 57737 */
	"ROP3_XOR\0" /* 57749 */
	"ROP3_NAND\0" /* 57758 */
	"ROP3_AND\0" /* 57768 */
	"ROP3_EQUIVALENT\0" /* 57777 */
	"ROP3_NO_OP\0" /* 57793 */
	"ROP3_OR_INVERTED\0" /* 57804 */
	"ROP3_COPY\0" /* 57821 */
	"ROP3_OR_REVERSE\0" /* 57831 */
	"ROP3_OR\0" /* 57847 */
	"ROP3_SET\0" /* 57855 */
	"Z_EXPORT_ENABLE\0" /* 57864 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 57880 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 57911 */
	"LATE_Z\0" /* 57940 */
	"EARLY_Z_THEN_LATE_Z\0" /* 57947 */
	"RE_Z\0" /* 57967 */
	"EARLY_Z_THEN_RE_Z\0" /* 57972 */
	"KILL_ENABLE\0" /* 57990 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 58002 */
	"MASK_EXPORT_ENABLE\0" /* 58026 */
	"EXEC_ON_HIER_FAIL\0" /* 58045 */
	"EXEC_ON_NOOP\0" /* 58063 */
	"ALPHA_TO_MASK_DISABLE\0" /* 58076 */
	"DEPTH_BEFORE_SHADER\0" /* 58098 */
	"EXPORT_ANY_Z\0" /* 58118 */
	"EXPORT_LESS_THAN_Z\0" /* 58131 */
	"EXPORT_GREATER_THAN_Z\0" /* 58150 */
	"EXPORT_RESERVED\0" /* 58172 */
	"CONSERVATIVE_Z_EXPORT\0" /* 58188 */
	"DUAL_QUAD_DISABLE\0" /* 58210 */
	"UCP_ENA_0\0" /* 58228 */
	"UCP_ENA_1\0" /* 58238 */
	"UCP_ENA_2\0" /* 58248 */
	"UCP_ENA_3\0" /* 58258 */
	"UCP_ENA_4\0" /* 58268 */
	"UCP_ENA_5\0" /* 58278 */
	"PS_UCP_Y_SCALE_NEG\0" /* 58288 */
	"PS_UCP_MODE\0" /* 58307 */
	"CLIP_DISABLE\0" /* 58319 */
	"UCP_CULL_ONLY_ENA\0" /* 58332 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 58350 */
	"DX_CLIP_SPACE_DEF\0" /* 58373 */
	"DIS_CLIP_ERR_DETECT\0" /* 58391 */
	"VTX_KILL_OR\0" /* 58411 */
	"DX_RASTERIZATION_KILL\0" /* 58423 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 58445 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 58469 */
	"ZCLIP_NEAR_DISABLE\0" /* 58495 */
	"ZCLIP_FAR_DISABLE\0" /* 58514 */
	"CULL_FRONT\0" /* 58532 */
	"CULL_BACK\0" /* 58543 */
	"X_DISABLE_POLY_MODE\0" /* 58553, 58563 */
	"X_DUAL_MODE\0" /* 58573 */
	"X_DRAW_POINTS\0" /* 58585 */
	"X_DRAW_LINES\0" /* 58599 */
	"X_DRAW_TRIANGLES\0" /* 58612 */
	"POLYMODE_FRONT_PTYPE\0" /* 58629 */
	"POLYMODE_BACK_PTYPE\0" /* 58650 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 58670 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 58695 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 58719 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 58743 */
	"PROVOKING_VTX_LAST\0" /* 58768 */
	"PERSP_CORR_DIS\0" /* 58787 */
	"MULTI_PRIM_IB_ENA\0" /* 58802 */
	"VPORT_X_SCALE_ENA\0" /* 58820 */
	"VPORT_X_OFFSET_ENA\0" /* 58838 */
	"VPORT_Y_SCALE_ENA\0" /* 58857 */
	"VPORT_Y_OFFSET_ENA\0" /* 58875 */
	"VPORT_Z_SCALE_ENA\0" /* 58894 */
	"VPORT_Z_OFFSET_ENA\0" /* 58912 */
	"VTX_XY_FMT\0" /* 58931 */
	"VTX_Z_FMT\0" /* 58942 */
	"VTX_W0_FMT\0" /* 58952 */
	"CLIP_DIST_ENA_0\0" /* 58963 */
	"CLIP_DIST_ENA_1\0" /* 58979 */
	"CLIP_DIST_ENA_2\0" /* 58995 */
	"CLIP_DIST_ENA_3\0" /* 59011 */
	"CLIP_DIST_ENA_4\0" /* 59027 */
	"CLIP_DIST_ENA_5\0" /* 59043 */
	"CLIP_DIST_ENA_6\0" /* 59059 */
	"CLIP_DIST_ENA_7\0" /* 59075 */
	"CULL_DIST_ENA_0\0" /* 59091 */
	"CULL_DIST_ENA_1\0" /* 59107 */
	"CULL_DIST_ENA_2\0" /* 59123 */
	"CULL_DIST_ENA_3\0" /* 59139 */
	"CULL_DIST_ENA_4\0" /* 59155 */
	"CULL_DIST_ENA_5\0" /* 59171 */
	"CULL_DIST_ENA_6\0" /* 59187 */
	"CULL_DIST_ENA_7\0" /* 59203 */
	"USE_VTX_POINT_SIZE\0" /* 59219 */
	"USE_VTX_EDGE_FLAG\0" /* 59238 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 59256 */
	"USE_VTX_VIEWPORT_INDX\0" /* 59283 */
	"USE_VTX_KILL_FLAG\0" /* 59305 */
	"VS_OUT_MISC_VEC_ENA\0" /* 59323 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 59343 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 59366 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 59389 */
	"USE_VTX_GS_CUT_FLAG\0" /* 59414 */
	"USE_VTX_LINE_WIDTH\0" /* 59434 */
	"VTE_XY_INF_DISCARD\0" /* 59453 */
	"VTE_Z_INF_DISCARD\0" /* 59472 */
	"VTE_W_INF_DISCARD\0" /* 59490 */
	"VTE_0XNANINF_IS_0\0" /* 59508 */
	"VTE_XY_NAN_RETAIN\0" /* 59526 */
	"VTE_Z_NAN_RETAIN\0" /* 59544 */
	"VTE_W_NAN_RETAIN\0" /* 59561 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 59578 */
	"VS_XY_NAN_TO_INF\0" /* 59599 */
	"VS_XY_INF_RETAIN\0" /* 59616 */
	"VS_Z_NAN_TO_INF\0" /* 59633 */
	"VS_Z_INF_RETAIN\0" /* 59649 */
	"VS_W_NAN_TO_INF\0" /* 59665 */
	"VS_W_INF_RETAIN\0" /* 59681 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 59697 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 59722 */
	"LINE_STIPPLE_RESET\0" /* 59742 */
	"EXPAND_FULL_LENGTH\0" /* 59761 */
	"FRACTIONAL_ACCUM\0" /* 59780 */
	"DIAMOND_ADJUST\0" /* 59797 */
	"TRIANGLE_FILTER_DISABLE\0" /* 59812 */
	"LINE_FILTER_DISABLE\0" /* 59836 */
	"POINT_FILTER_DISABLE\0" /* 59856 */
	"RECTANGLE_FILTER_DISABLE\0" /* 59877 */
	"TRIANGLE_EXPAND_ENA\0" /* 59902 */
	"LINE_EXPAND_ENA\0" /* 59922 */
	"POINT_EXPAND_ENA\0" /* 59938 */
	"RECTANGLE_EXPAND_ENA\0" /* 59955 */
	"PRIM_EXPAND_CONSTANT\0" /* 59976 */
	"XMAX_RIGHT_EXCLUSION\0" /* 59997 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 60018 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 60040 */
	"MIN_SIZE\0" /* 60065 */
	"LINE_PATTERN\0" /* 60074 */
	"REPEAT_COUNT\0" /* 60087 */
	"PATTERN_BIT_ORDER\0" /* 60100 */
	"AUTO_RESET_CNTL\0" /* 60118 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 60134 */
	"VGT_OUTPATH_TESS_EN\0" /* 60156 */
	"VGT_OUTPATH_PASSTHRU\0" /* 60176 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 60197 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 60218 */
	"PATH_SELECT\0" /* 60239 */
	"TESS_MODE\0" /* 60251 */
	"VGT_GRP_3D_POINT\0" /* 60261 */
	"VGT_GRP_3D_LINE\0" /* 60278 */
	"VGT_GRP_3D_TRI\0" /* 60294 */
	"VGT_GRP_3D_RECT\0" /* 60309 */
	"VGT_GRP_3D_QUAD\0" /* 60325 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 60341 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 60365 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 60389 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 60413 */
	"VGT_GRP_2D_FILL_RECT\0" /* 60437 */
	"VGT_GRP_2D_LINE\0" /* 60458 */
	"VGT_GRP_2D_TRI\0" /* 60474 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 60489 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 60513 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 60536 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 60560 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 60580 */
	"VGT_GRP_3D_PATCH\0" /* 60599 */
	"RETAIN_ORDER\0" /* 60616 */
	"RETAIN_QUADS\0" /* 60629 */
	"VGT_GRP_LIST\0" /* 60642 */
	"VGT_GRP_STRIP\0" /* 60655 */
	"VGT_GRP_FAN\0" /* 60669 */
	"VGT_GRP_LOOP\0" /* 60681 */
	"VGT_GRP_POLYGON\0" /* 60694 */
	"PRIM_ORDER\0" /* 60710 */
	"COMP_X_EN\0" /* 60721 */
	"COMP_Y_EN\0" /* 60731 */
	"COMP_Z_EN\0" /* 60741 */
	"COMP_W_EN\0" /* 60751 */
	"SHIFT\0" /* 60761 */
	"VGT_GRP_INDEX_16\0" /* 60767 */
	"VGT_GRP_INDEX_32\0" /* 60784 */
	"VGT_GRP_UINT_16\0" /* 60801 */
	"VGT_GRP_UINT_32\0" /* 60817 */
	"VGT_GRP_SINT_16\0" /* 60833 */
	"VGT_GRP_SINT_32\0" /* 60849 */
	"VGT_GRP_FLOAT_32\0" /* 60865 */
	"VGT_GRP_AUTO_PRIM\0" /* 60882 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 60900 */
	"X_CONV\0" /* 60926, 60930 */
	"Y_CONV\0" /* 60933 */
	"Z_CONV\0" /* 60940 */
	"Z_OFFSET\0" /* 60947 */
	"W_CONV\0" /* 60956 */
	"GS_OFF\0" /* 60963 */
	"GS_SCENARIO_A\0" /* 60970 */
	"GS_SCENARIO_B\0" /* 60984 */
	"GS_SCENARIO_G\0" /* 60998 */
	"GS_SCENARIO_C\0" /* 61012 */
	"SPRITE_EN\0" /* 61026 */
	"GS_CUT_1024\0" /* 61036 */
	"GS_CUT_512\0" /* 61048 */
	"GS_CUT_256\0" /* 61059 */
	"GS_CUT_128\0" /* 61070 */
	"CUT_MODE\0" /* 61081 */
	"GS_C_PACK_EN\0" /* 61090 */
	"RESERVED_2\0" /* 61103 */
	"ES_PASSTHRU\0" /* 61114 */
	"COMPUTE_MODE\0" /* 61126 */
	"FAST_COMPUTE_MODE\0" /* 61139 */
	"ELEMENT_INFO_EN\0" /* 61157 */
	"PARTIAL_THD_AT_EOI\0" /* 61173 */
	"SUPPRESS_CUTS\0" /* 61192 */
	"ES_WRITE_OPTIMIZE\0" /* 61206 */
	"GS_WRITE_OPTIMIZE\0" /* 61224 */
	"X_0_OFFCHIP_GS\0" /* 61242 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 61257, 61275 */
	"ES_VERTS_PER_SUBGRP\0" /* 61282 */
	"GS_PRIMS_PER_SUBGRP\0" /* 61302 */
	"MSAA_ENABLE\0" /* 61322 */
	"VPORT_SCISSOR_ENABLE\0" /* 61334 */
	"LINE_STIPPLE_ENABLE\0" /* 61355 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 61375 */
	"WALK_SIZE\0" /* 61400 */
	"WALK_ALIGNMENT\0" /* 61410 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 61425 */
	"WALK_FENCE_ENABLE\0" /* 61450 */
	"WALK_FENCE_SIZE\0" /* 61468 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 61484, 61489 */
	"TILE_COVER_DISABLE\0" /* 61512 */
	"TILE_COVER_NO_SCISSOR\0" /* 61531 */
	"ZMM_LINE_EXTENT\0" /* 61553 */
	"ZMM_LINE_OFFSET\0" /* 61569 */
	"ZMM_RECT_EXTENT\0" /* 61585 */
	"KILL_PIX_POST_HI_Z\0" /* 61601 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 61620 */
	"PS_ITER_SAMPLE\0" /* 61646 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 61661 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 61701 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 61728 */
	"GPU_ID_OVERRIDE\0" /* 61751 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 61767 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 61797 */
	"FORCE_EOV_REZ_ENABLE\0" /* 61821 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 61842 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 61872 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 61896 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 61919 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 61942 */
	"OUTPRIM_TYPE\0" /* 61964 */
	"OUTPRIM_TYPE_1\0" /* 61977 */
	"OUTPRIM_TYPE_2\0" /* 61992 */
	"OUTPRIM_TYPE_3\0" /* 62007 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 62022 */
	"VGT_INDEX_16\0" /* 62045 */
	"VGT_INDEX_32\0" /* 62058 */
	"VGT_INDEX_8\0" /* 62071 */
	"VGT_DMA_SWAP_NONE\0" /* 62083 */
	"VGT_DMA_SWAP_16_BIT\0" /* 62101 */
	"VGT_DMA_SWAP_32_BIT\0" /* 62121 */
	"VGT_DMA_SWAP_WORD\0" /* 62141 */
	"SWAP_MODE\0" /* 62159 */
	"VGT_DMA_BUF_MEM\0" /* 62169 */
	"VGT_DMA_BUF_RING\0" /* 62185 */
	"VGT_DMA_BUF_SETUP\0" /* 62202 */
	"BUF_TYPE\0" /* 62220 */
	"VGT_POLICY_LRU\0" /* 62229 */
	"VGT_POLICY_STREAM\0" /* 62244 */
	"RDREQ_POLICY_CIK\0" /* 62262 */
	"RDREQ_POLICY\0" /* 62279 */
	"REQ_PATH\0" /* 62292 */
	"DISABLE_RESET_ON_EOI\0" /* 62301 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 62322 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 62345 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 62368 */
	"CACHE_FLUSH_TS\0" /* 62391 */
	"CONTEXT_DONE\0" /* 62406 */
	"CACHE_FLUSH\0" /* 62419 */
	"CS_PARTIAL_FLUSH\0" /* 62431 */
	"VGT_STREAMOUT_SYNC\0" /* 62448 */
	"VGT_STREAMOUT_RESET\0" /* 62467 */
	"END_OF_PIPE_INCR_DE\0" /* 62487 */
	"END_OF_PIPE_IB_END\0" /* 62507 */
	"RST_PIX_CNT\0" /* 62526 */
	"VS_PARTIAL_FLUSH\0" /* 62538 */
	"PS_PARTIAL_FLUSH\0" /* 62555 */
	"FLUSH_HS_OUTPUT\0" /* 62572 */
	"FLUSH_LS_OUTPUT\0" /* 62588 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 62604 */
	"ZPASS_DONE\0" /* 62633 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 62644 */
	"PERFCOUNTER_START\0" /* 62670 */
	"PERFCOUNTER_STOP\0" /* 62688 */
	"PIPELINESTAT_START\0" /* 62705 */
	"PIPELINESTAT_STOP\0" /* 62724 */
	"PERFCOUNTER_SAMPLE\0" /* 62742 */
	"FLUSH_ES_OUTPUT\0" /* 62761 */
	"FLUSH_GS_OUTPUT\0" /* 62777 */
	"SAMPLE_PIPELINESTAT\0" /* 62793 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 62813 */
	"SAMPLE_STREAMOUTSTATS\0" /* 62835 */
	"RESET_VTX_CNT\0" /* 62857 */
	"BLOCK_CONTEXT_DONE\0" /* 62871 */
	"CS_CONTEXT_DONE\0" /* 62890 */
	"VGT_FLUSH\0" /* 62906 */
	"SC_SEND_DB_VPZ\0" /* 62916 */
	"BOTTOM_OF_PIPE_TS\0" /* 62931 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 62949 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 62972 */
	"FLUSH_AND_INV_DB_META\0" /* 62997 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 63019 */
	"FLUSH_AND_INV_CB_META\0" /* 63044 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 63066 */
	"THREAD_TRACE_START\0" /* 63094 */
	"THREAD_TRACE_STOP\0" /* 63113 */
	"THREAD_TRACE_MARKER\0" /* 63131 */
	"THREAD_TRACE_FLUSH\0" /* 63151 */
	"THREAD_TRACE_FINISH\0" /* 63170 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 63190 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 63214 */
	"PIXEL_PIPE_STAT_RESET\0" /* 63235 */
	"EVENT_TYPE\0" /* 63257 */
	"ADDRESS_HI_GFX6\0" /* 63268 */
	"EXTENDED_EVENT\0" /* 63284 */
	"PRIMGROUP_SIZE\0" /* 63299 */
	"PARTIAL_VS_WAVE_ON\0" /* 63314 */
	"SWITCH_ON_EOP\0" /* 63333 */
	"PARTIAL_ES_WAVE_ON\0" /* 63347 */
	"SWITCH_ON_EOI\0" /* 63366 */
	"WD_SWITCH_ON_EOP\0" /* 63380 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 63397 */
	"FULL_CACHE\0" /* 63417 */
	"HTILE_USES_PRELOAD_WIN\0" /* 63428 */
	"PRELOAD\0" /* 63451 */
	"PREFETCH_WIDTH\0" /* 63459 */
	"PREFETCH_HEIGHT\0" /* 63474 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 63490 */
	"TC_COMPATIBLE\0" /* 63514 */
	"COMPAREFUNC0\0" /* 63528 */
	"COMPAREVALUE0\0" /* 63541 */
	"COMPAREMASK0\0" /* 63555 */
	"COMPAREFUNC1\0" /* 63568 */
	"COMPAREVALUE1\0" /* 63581 */
	"COMPAREMASK1\0" /* 63595 */
	"MAX_X\0" /* 63608 */
	"MAX_Y\0" /* 63614 */
	"ACCUM_ISOLINE\0" /* 63620 */
	"ACCUM_TRI\0" /* 63634 */
	"ACCUM_QUAD\0" /* 63644 */
	"DONUT_SPLIT\0" /* 63655 */
	"TRAP_SPLIT\0" /* 63667 */
	"LS_STAGE_OFF\0" /* 63678 */
	"LS_STAGE_ON\0" /* 63691 */
	"CS_STAGE_ON\0" /* 63703 */
	"ES_STAGE_OFF\0" /* 63715 */
	"ES_STAGE_DS\0" /* 63728 */
	"ES_STAGE_REAL\0" /* 63740 */
	"VS_STAGE_REAL\0" /* 63754 */
	"VS_STAGE_DS\0" /* 63768 */
	"VS_STAGE_COPY_SHADER\0" /* 63780 */
	"DYNAMIC_HS\0" /* 63801 */
	"DIS_DEALLOC_ACCUM_0\0" /* 63812 */
	"DIS_DEALLOC_ACCUM_1\0" /* 63832 */
	"VS_WAVE_ID_EN\0" /* 63852 */
	"NUM_PATCHES\0" /* 63866 */
	"HS_NUM_INPUT_CP\0" /* 63878 */
	"HS_NUM_OUTPUT_CP\0" /* 63894 */
	"TESS_ISOLINE\0" /* 63911 */
	"TESS_TRIANGLE\0" /* 63924 */
	"TESS_QUAD\0" /* 63938 */
	"PART_INTEGER\0" /* 63948 */
	"PART_POW2\0" /* 63961 */
	"PART_FRAC_ODD\0" /* 63971 */
	"PART_FRAC_EVEN\0" /* 63985 */
	"PARTITIONING\0" /* 64000 */
	"OUTPUT_POINT\0" /* 64013 */
	"OUTPUT_LINE\0" /* 64026 */
	"OUTPUT_TRIANGLE_CW\0" /* 64038 */
	"OUTPUT_TRIANGLE_CCW\0" /* 64057 */
	"TOPOLOGY\0" /* 64077 */
	"RESERVED_REDUC_AXIS\0" /* 64086 */
	"DEPRECATED\0" /* 64106 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 64117 */
	"DISABLE_DONUTS\0" /* 64139 */
	"VGT_POLICY_BYPASS\0" /* 64154 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 64172 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 64198 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 64224 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 64249 */
	"DISTRIBUTION_MODE\0" /* 64278 */
	"ALPHA_TO_MASK_ENABLE\0" /* 64296 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 64317 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 64339 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 64361 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 64383 */
	"OFFSET_ROUND\0" /* 64405 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 64418 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 64446 */
	"STREAMOUT_0_EN\0" /* 64474 */
	"STREAMOUT_1_EN\0" /* 64489 */
	"STREAMOUT_2_EN\0" /* 64504 */
	"STREAMOUT_3_EN\0" /* 64519 */
	"RAST_STREAM\0" /* 64534 */
	"RAST_STREAM_MASK\0" /* 64546 */
	"USE_RAST_STREAM_MASK\0" /* 64563 */
	"STREAM_0_BUFFER_EN\0" /* 64584 */
	"STREAM_1_BUFFER_EN\0" /* 64603 */
	"STREAM_2_BUFFER_EN\0" /* 64622 */
	"STREAM_3_BUFFER_EN\0" /* 64641 */
	"DISTANCE_0\0" /* 64660 */
	"DISTANCE_1\0" /* 64671 */
	"DISTANCE_2\0" /* 64682 */
	"DISTANCE_3\0" /* 64693 */
	"DISTANCE_4\0" /* 64704 */
	"DISTANCE_5\0" /* 64715 */
	"DISTANCE_6\0" /* 64726 */
	"DISTANCE_7\0" /* 64737 */
	"DISTANCE_8\0" /* 64748 */
	"DISTANCE_9\0" /* 64759 */
	"DISTANCE_10\0" /* 64770 */
	"DISTANCE_11\0" /* 64782 */
	"DISTANCE_12\0" /* 64794 */
	"DISTANCE_13\0" /* 64806 */
	"DISTANCE_14\0" /* 64818 */
	"DISTANCE_15\0" /* 64830 */
	"EXPAND_LINE_WIDTH\0" /* 64842 */
	"LAST_PIXEL\0" /* 64860 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 64871 */
	"DX10_DIAMOND_TEST_ENA\0" /* 64896 */
	"MSAA_NUM_SAMPLES\0" /* 64918 */
	"AA_MASK_CENTROID_DTMN\0" /* 64935 */
	"MAX_SAMPLE_DIST\0" /* 64957 */
	"MSAA_EXPOSED_SAMPLES\0" /* 64973 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 64994 */
	"PIX_CENTER\0" /* 65017 */
	"X_TRUNCATE\0" /* 65028 */
	"X_ROUND\0" /* 65039 */
	"X_ROUND_TO_EVEN\0" /* 65047 */
	"X_ROUND_TO_ODD\0" /* 65063 */
	"ROUND_MODE\0" /* 65078 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 65089 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 65115 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 65140 */
	"X_16_8_FIXED_POINT_1_2\0" /* 65165 */
	"X_16_8_FIXED_POINT_1\0" /* 65188 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 65209 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 65236 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 65265 */
	"QUANT_MODE\0" /* 65294 */
	"S0_X\0" /* 65305 */
	"S0_Y\0" /* 65310 */
	"S1_X\0" /* 65315 */
	"S1_Y\0" /* 65320 */
	"S2_X\0" /* 65325 */
	"S2_Y\0" /* 65330 */
	"S3_X\0" /* 65335 */
	"S3_Y\0" /* 65340 */
	"S4_X\0" /* 65345 */
	"S4_Y\0" /* 65350 */
	"S5_X\0" /* 65355 */
	"S5_Y\0" /* 65360 */
	"S6_X\0" /* 65365 */
	"S6_Y\0" /* 65370 */
	"S7_X\0" /* 65375 */
	"S7_Y\0" /* 65380 */
	"S8_X\0" /* 65385 */
	"S8_Y\0" /* 65390 */
	"S9_X\0" /* 65395 */
	"S9_Y\0" /* 65400 */
	"S10_X\0" /* 65405 */
	"S10_Y\0" /* 65411 */
	"S11_X\0" /* 65417 */
	"S11_Y\0" /* 65423 */
	"S12_X\0" /* 65429 */
	"S12_Y\0" /* 65435 */
	"S13_X\0" /* 65441 */
	"S13_Y\0" /* 65447 */
	"S14_X\0" /* 65453 */
	"S14_Y\0" /* 65459 */
	"S15_X\0" /* 65465 */
	"S15_Y\0" /* 65471 */
	"AA_MASK_X0Y0\0" /* 65477 */
	"AA_MASK_X1Y0\0" /* 65490 */
	"AA_MASK_X0Y1\0" /* 65503 */
	"AA_MASK_X1Y1\0" /* 65516 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 65529 */
	"VTX_REUSE_DEPTH\0" /* 65558 */
	"DEALLOC_DIST\0" /* 65574 */
	"FMASK_TILE_MAX\0" /* 65587 */
	"ENDIAN_NONE\0" /* 65602 */
	"ENDIAN_8IN16\0" /* 65614 */
	"ENDIAN_8IN32\0" /* 65627 */
	"ENDIAN_8IN64\0" /* 65640 */
	"ENDIAN\0" /* 65653 */
	"COLOR_INVALID\0" /* 65660 */
	"COLOR_8\0" /* 65674 */
	"COLOR_16\0" /* 65682 */
	"COLOR_8_8\0" /* 65691 */
	"COLOR_32\0" /* 65701 */
	"COLOR_16_16\0" /* 65710 */
	"COLOR_10_11_11\0" /* 65722 */
	"COLOR_11_11_10\0" /* 65737 */
	"COLOR_10_10_10_2\0" /* 65752 */
	"COLOR_2_10_10_10\0" /* 65769 */
	"COLOR_8_8_8_8\0" /* 65786 */
	"COLOR_32_32\0" /* 65800 */
	"COLOR_16_16_16_16\0" /* 65812 */
	"COLOR_32_32_32_32\0" /* 65830 */
	"COLOR_5_6_5\0" /* 65848 */
	"COLOR_1_5_5_5\0" /* 65860 */
	"COLOR_5_5_5_1\0" /* 65874 */
	"COLOR_4_4_4_4\0" /* 65888 */
	"COLOR_8_24\0" /* 65902 */
	"COLOR_24_8\0" /* 65913 */
	"COLOR_X24_8_32_FLOAT\0" /* 65924 */
	"NUMBER_UNORM\0" /* 65945 */
	"NUMBER_SNORM\0" /* 65958 */
	"NUMBER_UINT\0" /* 65971 */
	"NUMBER_SINT\0" /* 65983 */
	"NUMBER_SRGB\0" /* 65995 */
	"NUMBER_FLOAT\0" /* 66007 */
	"NUMBER_TYPE\0" /* 66020 */
	"SWAP_STD\0" /* 66032 */
	"SWAP_ALT\0" /* 66041 */
	"SWAP_STD_REV\0" /* 66050 */
	"SWAP_ALT_REV\0" /* 66063 */
	"COMP_SWAP\0" /* 66076 */
	"BLEND_CLAMP\0" /* 66086 */
	"BLEND_BYPASS\0" /* 66098 */
	"SIMPLE_FLOAT\0" /* 66111 */
	"CMASK_IS_LINEAR\0" /* 66124 */
	"FORCE_OPT_AUTO\0" /* 66140 */
	"FORCE_OPT_DISABLE\0" /* 66155 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 66173 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 66201 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 66231 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 66262 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 66290 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 66320 */
	"BLEND_OPT_DONT_RD_DST\0" /* 66351 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 66373 */
	"FMASK_COMPRESSION_DISABLE\0" /* 66397 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 66423 */
	"DCC_ENABLE\0" /* 66449 */
	"CMASK_ADDR_TYPE\0" /* 66460 */
	"FMASK_TILE_MODE_INDEX\0" /* 66476 */
	"FMASK_BANK_HEIGHT\0" /* 66498 */
	"NUM_FRAGMENTS\0" /* 66516 */
	"FORCE_DST_ALPHA_1\0" /* 66530 */
	"KEY_CLEAR_ENABLE\0" /* 66548 */
	"MAX_BLOCK_SIZE_64B\0" /* 66565 */
	"MAX_BLOCK_SIZE_128B\0" /* 66584 */
	"MAX_BLOCK_SIZE_256B\0" /* 66604 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 66624 */
	"MIN_BLOCK_SIZE_32B\0" /* 66652 */
	"MIN_BLOCK_SIZE_64B\0" /* 66671 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 66690 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 66716 */
	"INDEPENDENT_64B_BLOCKS\0" /* 66742 */
	"LOSSY_RGB_PRECISION\0" /* 66765 */
	"LOSSY_ALPHA_PRECISION\0" /* 66785 */
	"UTCL2_BUSY\0" /* 66807 */
	"EA_BUSY\0" /* 66818 */
	"RMI_BUSY\0" /* 66826 */
	"UTCL2_RQ_PENDING\0" /* 66835 */
	"CPF_RQ_PENDING\0" /* 66852 */
	"EA_LINK_BUSY\0" /* 66867 */
	"CPAXI_BUSY\0" /* 66880 */
	"RSMU_RQ_PENDING\0" /* 66891 */
	"TC_WC_ACTION_ENA\0" /* 66907 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 66924 */
	"UTCL2IU_BUSY\0" /* 66951 */
	"SAVE_RESTORE_BUSY\0" /* 66964 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 66982 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 67006 */
	"UTCL1_WAITING_ON_TRANS\0" /* 67030 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 67053 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 67080 */
	"RCIU_WAITING_ON_FREE\0" /* 67107 */
	"PRIMGEN_EN\0" /* 67128 */
	"MATCH_ALL_BITS\0" /* 67139 */
	"EN_INST_OPT_BASIC\0" /* 67154 */
	"EN_INST_OPT_ADV\0" /* 67172 */
	"HW_USE_ONLY\0" /* 67188 */
	"TARGET_INST\0" /* 67200 */
	"TARGET_DATA\0" /* 67212 */
	"COMPLETE\0" /* 67224 */
	"DWB\0" /* 67233 */
	"USER_VM_ENABLE\0" /* 67237 */
	"USER_VM_MODE\0" /* 67252 */
	"IMG_DATA_FORMAT_6E4\0" /* 67265 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 67285 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 67313 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 67352 */
	"IMG_DATA_FORMAT_FMASK\0" /* 67391 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 67413 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 67441 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 67469 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 67502 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 67530 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 67558 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 67591 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 67615 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 67642 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 67675 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 67714 */
	"IMG_DATA_FORMAT_S8_16\0" /* 67742 */
	"IMG_DATA_FORMAT_S8_32\0" /* 67764 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 67786 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 67810 */
	"DATA_FORMAT_GFX9\0" /* 67837 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 67854 */
	"IMG_NUM_FORMAT_METADATA\0" /* 67880 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 67904 */
	"NUM_FORMAT_GFX9\0" /* 67930 */
	"IMG_FMASK_8_2_1\0" /* 67946 */
	"IMG_FMASK_8_4_1\0" /* 67962 */
	"IMG_FMASK_8_8_1\0" /* 67978 */
	"IMG_FMASK_8_2_2\0" /* 67994 */
	"IMG_FMASK_8_4_2\0" /* 68010 */
	"IMG_FMASK_8_4_4\0" /* 68026 */
	"IMG_FMASK_16_16_1\0" /* 68042 */
	"IMG_FMASK_16_8_2\0" /* 68060 */
	"IMG_FMASK_32_16_2\0" /* 68077 */
	"IMG_FMASK_32_8_4\0" /* 68095 */
	"IMG_FMASK_32_8_8\0" /* 68112 */
	"IMG_FMASK_64_16_4\0" /* 68129 */
	"IMG_FMASK_64_16_8\0" /* 68147 */
	"NUM_FORMAT_FMASK\0" /* 68165 */
	"IMG_ASTC_2D_4x4\0" /* 68182 */
	"IMG_ASTC_2D_5x4\0" /* 68198 */
	"IMG_ASTC_2D_5x5\0" /* 68214 */
	"IMG_ASTC_2D_6x5\0" /* 68230 */
	"IMG_ASTC_2D_6x6\0" /* 68246 */
	"IMG_ASTC_2D_8x5\0" /* 68262 */
	"IMG_ASTC_2D_8x6\0" /* 68278 */
	"IMG_ASTC_2D_8x8\0" /* 68294 */
	"IMG_ASTC_2D_10x5\0" /* 68310 */
	"IMG_ASTC_2D_10x6\0" /* 68327 */
	"IMG_ASTC_2D_10x8\0" /* 68344 */
	"IMG_ASTC_2D_10x10\0" /* 68361 */
	"IMG_ASTC_2D_12x10\0" /* 68379 */
	"IMG_ASTC_2D_12x12\0" /* 68397 */
	"NUM_FORMAT_ASTC_2D\0" /* 68415 */
	"IMG_ASTC_3D_3x3x3\0" /* 68434 */
	"IMG_ASTC_3D_4x3x3\0" /* 68452 */
	"IMG_ASTC_3D_4x4x3\0" /* 68470 */
	"IMG_ASTC_3D_4x4x4\0" /* 68488 */
	"IMG_ASTC_3D_5x4x4\0" /* 68506 */
	"IMG_ASTC_3D_5x5x4\0" /* 68524 */
	"IMG_ASTC_3D_5x5x5\0" /* 68542 */
	"IMG_ASTC_3D_6x5x5\0" /* 68560 */
	"IMG_ASTC_3D_6x6x5\0" /* 68578 */
	"IMG_ASTC_3D_6x6x6\0" /* 68596 */
	"NUM_FORMAT_ASTC_3D\0" /* 68614 */
	"META_DIRECT\0" /* 68633 */
	"SW_MODE\0" /* 68645 */
	"PITCH_GFX9\0" /* 68653 */
	"BC_SWIZZLE_XYZW\0" /* 68664 */
	"BC_SWIZZLE_XWYZ\0" /* 68680 */
	"BC_SWIZZLE_WZYX\0" /* 68696 */
	"BC_SWIZZLE_WXYZ\0" /* 68712 */
	"BC_SWIZZLE_ZYXW\0" /* 68728 */
	"BC_SWIZZLE_YXWZ\0" /* 68744 */
	"BC_SWIZZLE\0" /* 68760 */
	"ARRAY_PITCH\0" /* 68771 */
	"META_DATA_ADDRESS\0" /* 68783 */
	"META_LINEAR\0" /* 68801 */
	"META_PIPE_ALIGNED\0" /* 68813, 68818 */
	"META_RB_ALIGNED\0" /* 68831, 68836 */
	"MAX_MIP\0" /* 68847 */
	"BLEND_ZERO_PRT\0" /* 68855 */
	"SKIP_DEGAMMA\0" /* 68870 */
	"TTRACE_STALL_ALL\0" /* 68883 */
	"ALLOC_ARB_LRU_ENA\0" /* 68900 */
	"EXP_ARB_LRU_ENA\0" /* 68918 */
	"PS_PKR_PRIORITY_CNTL\0" /* 68934 */
	"BATON_RESET_DISABLE\0" /* 68955 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 68975 */
	"LBPW_CU_CHK_MODE\0" /* 69001 */
	"LBPW_CU_CHK_CNT\0" /* 69018 */
	"CSC_PWR_SAVE_DISABLE\0" /* 69034 */
	"CSG_PWR_SAVE_DISABLE\0" /* 69055 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 69076 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 69117 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 69156 */
	"MAX_COMPRESSED_FRAGS\0" /* 69182 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 69203 */
	"NUM_GPUS_GFX9\0" /* 69227 */
	"NUM_RB_PER_SE\0" /* 69241 */
	"SE_ENABLE\0" /* 69255 */
	"SIMD_DISABLE\0" /* 69265 */
	"FP16_OVFL\0" /* 69278 */
	"LOAD_COLLISION_WAVEID\0" /* 69288 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 69310 */
	"SKIP_USGPR0\0" /* 69335 */
	"USER_SGPR_MSB\0" /* 69347 */
	"PC_BASE_EN\0" /* 69361 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 69372 */
	"GS_VGPR_COMP_CNT\0" /* 69397 */
	"ES_VGPR_COMP_CNT\0" /* 69414 */
	"LS_VGPR_COMP_CNT\0" /* 69431 */
	"CNTR_SEL0\0" /* 69448 */
	"CNTR_SEL1\0" /* 69458 */
	"CNTR_MODE1\0" /* 69468 */
	"CNTR_MODE0\0" /* 69479 */
	"CNTR_SEL2\0" /* 69490 */
	"CNTR_SEL3\0" /* 69500 */
	"CNTR_MODE3\0" /* 69510 */
	"CNTR_MODE2\0" /* 69521 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 69532 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 69561 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 69587 */
	"MIPID\0" /* 69614 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 69620 */
	"X_MAX\0" /* 69648 */
	"Y_MAX\0" /* 69654 */
	"PARTIALLY_RESIDENT\0" /* 69660 */
	"FAULT_BEHAVIOR\0" /* 69679 */
	"ITERATE_FLUSH\0" /* 69694 */
	"MAXMIP\0" /* 69708 */
	"FORCE_ON\0" /* 69715 */
	"PUNCHOUT_MODE\0" /* 69724 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 69738 */
	"DISALLOW_OVERFLOW\0" /* 69763 */
	"DEST_BASE_HI_256B\0" /* 69781 */
	"SE_XSEL_GFX9\0" /* 69799 */
	"SE_YSEL_GFX9\0" /* 69812 */
	"SE_PAIR_XSEL_GFX9\0" /* 69825 */
	"SE_PAIR_YSEL_GFX9\0" /* 69843 */
	"NUM_SE\0" /* 69861 */
	"PERFMON_ENABLE\0" /* 69868 */
	"LEFT_QTR\0" /* 69883 */
	"LEFT_HALF\0" /* 69892 */
	"RIGHT_HALF\0" /* 69902 */
	"RIGHT_QTR\0" /* 69913 */
	"TOP_QTR\0" /* 69923 */
	"TOP_HALF\0" /* 69931 */
	"BOT_HALF\0" /* 69940 */
	"BOT_QTR\0" /* 69949 */
	"DISABLE_CONSTANT_ENCODE_REG\0" /* 69957 */
	"OFFCHIP_PARAM_EN\0" /* 69985 */
	"LATE_PC_DEALLOC\0" /* 70002 */
	"BASE_ADDR_GFX9\0" /* 70018 */
	"SPRITE_EN_R6XX\0" /* 70033 */
	"UNROLLED_INST\0" /* 70048 */
	"GRBM_SKEW_NO_DEC\0" /* 70062 */
	"REG_RT_INDEX\0" /* 70079 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 70092 */
	"EXEC_IF_OVERLAPPED\0" /* 70123 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 70142 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 70167 */
	"NEW_QUAD_DECOMPOSITION\0" /* 70205 */
	"PERFCOUNTER_REF\0" /* 70228 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 70244 */
	"OBJ_ID_SEL\0" /* 70267 */
	"ADD_PIPED_PRIM_ID\0" /* 70278 */
	"EN_32BIT_OBJPRIMID\0" /* 70296 */
	"VERTEX_REUSE_OFF\0" /* 70315 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 70332 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 70356 */
	"DISCARD_0_AREA_LINES\0" /* 70381 */
	"DISCARD_0_AREA_POINTS\0" /* 70402 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 70424 */
	"USE_PROVOKING_ZW\0" /* 70450 */
	"RESERVED_3\0" /* 70467 */
	"RESERVED_4\0" /* 70478 */
	"RESERVED_5\0" /* 70489 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 70500 */
	"SCALE_LINE_WIDTH_PAD\0" /* 70524 */
	"ALTERNATE_RBS_PER_TILE\0" /* 70545 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 70568 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 70598 */
	"BREAK_BATCH\0" /* 70623 */
	"FLUSH_DFSM\0" /* 70635 */
	"RESET_TO_LOWEST_VGT\0" /* 70646 */
	"TGID_ROLLOVER\0" /* 70666 */
	"ENABLE_NGG_PIPELINE\0" /* 70680 */
	"ENABLE_LEGACY_PIPELINE\0" /* 70700 */
	"ADDRESS_HI_GFX9\0" /* 70723 */
	"OBJPRIM_ID_EN\0" /* 70739 */
	"EN_REG_RT_INDEX\0" /* 70753 */
	"EN_PIPELINE_PRIMID\0" /* 70769 */
	"OBJECT_ID_INST_EN\0" /* 70788 */
	"ORDERED_ID_MODE\0" /* 70806 */
	"GS_FAST_LAUNCH\0" /* 70822 */
	"EN_PRIMS_NEEDED_CNT\0" /* 70837 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 70857 */
	"BINNING_ALLOWED\0" /* 70883 */
	"FORCE_BINNING_ON\0" /* 70899 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 70916 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 70943 */
	"BINNING_MODE\0" /* 70973 */
	"BIN_SIZE_X\0" /* 70986 */
	"BIN_SIZE_Y\0" /* 70997 */
	"BIN_SIZE_X_EXTEND\0" /* 71008 */
	"BIN_SIZE_Y_EXTEND\0" /* 71026 */
	"CONTEXT_STATES_PER_BIN\0" /* 71044 */
	"PERSISTENT_STATES_PER_BIN\0" /* 71067 */
	"DISABLE_START_OF_PRIM\0" /* 71093 */
	"FPOVS_PER_BATCH\0" /* 71115 */
	"OPTIMAL_BIN_SELECTION\0" /* 71131 */
	"MAX_ALLOC_COUNT\0" /* 71153 */
	"MAX_PRIM_PER_BATCH\0" /* 71169 */
	"OVER_RAST_ENABLE\0" /* 71188 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 71205 */
	"UNDER_RAST_ENABLE\0" /* 71229 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 71247 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 71272 */
	"ZMM_TRI_EXTENT\0" /* 71302 */
	"ZMM_TRI_OFFSET\0" /* 71317 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 71332 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 71367 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 71403 */
	"UNCERTAINTY_REGION_MODE\0" /* 71447 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71471 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71507 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 71543 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 71569 */
	"PREZ_AA_MASK_ENABLE\0" /* 71593 */
	"POSTZ_AA_MASK_ENABLE\0" /* 71613 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 71634 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 71659 */
	"BASE_256B\0" /* 71680 */
	"MIP0_HEIGHT\0" /* 71690 */
	"MIP0_WIDTH\0" /* 71702 */
	"MIP_LEVEL\0" /* 71713 */
	"MIP0_DEPTH\0" /* 71723 */
	"COLOR_SW_MODE\0" /* 71734 */
	"FMASK_SW_MODE\0" /* 71748 */
	"RESOURCE_TYPE\0" /* 71762 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 31720, 1807, 15335,
	/* 4 */ 31758, 31778, 31787, 31793, 8089, 456,
	/* 10 */ 31833, 31793, 391, 31842,
	/* 14 */ 31872, 31793, 8579, 31881,
	/* 18 */ 31952, 31957, 31965, 31973,
	/* 22 */ 31999, 31769,
	/* 24 */ 32014, 32024,
	/* 26 */ 36400, 36411, 36427, 36442, 36458, 36472, 36485, 36500, 36515, 36530, 36542, 36561, 36581, 36599, 36618, 36633, 36648, 36670, 36685, 36700, 36715, 36731, 36745, 36772, 36799, 36826, 36853, 36877, 36897,
	/* 55 */ 36916, 36937,
	/* 57 */ 36400, 36411, 36427, 36442, 36458, 36472, 36485, -1, -1, 36530, 36542, 36561, 36581, 36599, -1, -1, 36648, 36670, 36685, 36700, 36715, 36731, 36745, 36772, 36799, 36826, 36853, 36877, 36897,
	/* 86 */ 38779, 38791, 38803, 38815,
	/* 90 */ 39160, -1, -1, -1, -1, -1, -1, -1, 39171, 39183, -1, -1, 39195, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39206,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39232,
	/* 186 */ 39311, 39320, 39329, 39347, 39365, 39374, 39383, 39392,
	/* 194 */ 39441, 39462, 39483, 39506, 39529, 39549, 39569, 39594,
	/* 202 */ 39626, 39650, 39668, 39687, 39707, 39726, 39748, 39773, 39798, 39825, 39852, 39876, 39898, 39926, 39951, 39979,
	/* 218 */ 40087, 40099, 40118, 40137,
	/* 222 */ 40164, 40188, 40206, 40225, 40245, 40264, 40286, 40311, 40336, 40363, 40390, 40414, 40436, 40464, 40489, 40517, 40545, 40567, 40591, 40615, 40639, 40660, 40681, 40706, 40735, 40760, 40786, 40809, 40833, 40860, 40888, 40916, 40944, 40966, 40988, 41012, 41032, 41052, 41072, 41092, 41112, 41132, 41152, 41191, 41230, 41259, 41288, 41317, 41346, 41375, 41404, 41435, 41465, 41496, 41526, 41556, 41587, 41618, 41638, 41660, 41678, 41705, 41729, 41755,
	/* 286 */ 41806, 41827, 41848, 41871, 41894, 41914, 41934, 41959, 41980, 42006, 42026, 42048, 42074, 42095, 42119, 42146,
	/* 302 */ 42266, 42285, 42304, 42323, 42342, 42361, 42380, 42399, 42418, 42433, 42448, 42463, 42480, 42501, 42522, 42542,
	/* 318 */ 42724, 42736, 42750, 42774, 42804, 42829, 42860, 42880,
	/* 326 */ 42946, 42973, 42999, 43026, 43057, 43086, 43116, 43150,
	/* 334 */ 43302, 43327, 43350,
	/* 337 */ 43443, 43466,
	/* 339 */ 43443, 43466, 43506, 43535,
	/* 343 */ 43581, 43602, 43624,
	/* 346 */ 43766, 43798, 43831, 43864,
	/* 350 */ 44043,
	/* 351 */ 44342, 44358, 44374, 44390, 44406, 44422, 44438, 44454, 44470, 44486, 44502, 44518, 44533, 44548, 44563, 44579,
	/* 367 */ 45006, 45037, 45065, 45094,
	/* 371 */ 45139, 45160, 45181, 45202, 45223, -1, -1, 45244, 45265, -1, -1, -1, 45287, 45308, 45329, 45351,
	/* 387 */ 45379, 45392, 45415, 45438, 45461, 45481, 45502, 45523, 45544, 45570, 45596, 45622, 45649, 45676, 45703,
	/* 402 */ 45742, 45767, 45793, 45819, 45845, 45870, 45895,
	/* 409 */ 45931, 45954, 45977, 46000,
	/* 413 */ 46034, 46058, 46082, 46106,
	/* 417 */ 46142, 46167, 46192, 46217,
	/* 421 */ 46260, 46277, 46294, 46311,
	/* 425 */ 45006, 45037, 45065, 46339,
	/* 429 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46454, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46468, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46482,
	/* 670 */ 47373, 47391, 47406,
	/* 673 */ 48918, 48928, 48941, 48955,
	/* 677 */ 49252, 49267, 49283, 49299,
	/* 681 */ 49464, 49474, 49492, 49502,
	/* 685 */ 45139, 45160, 45181, -1, 45223, 49901, 49923,
	/* 692 */ 45379, -1, -1, -1, 45461, 45481, 45502, 45523, 45544, 45570, 45596, 45622, 45649, 45676, 45703, -1, 49948, 49975,
	/* 710 */ 50003, 50013, 50018, 50023,
	/* 714 */ 50165, 50181,
	/* 716 */ -1, 23381, 1940, -1, 1992, -1, -1, -1, 17409, -1, -1, -1, -1, -1, -1, -1, 17105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50312, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50318, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50324, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17143, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50331, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50337, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50343, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31967, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50350, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50357, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 50364,
	/* 33485 */ 50719, 50742, 50765, 50788,
	/* 33489 */ 50835, 50860, 50885, 50910,
	/* 33493 */ 50960, 50984, 51008, 51032,
	/* 33497 */ 51064, 51089, 51114, 51139,
	/* 33501 */ 51173, 51198, 51223, 51248,
	/* 33505 */ 51282, 51308, 51334, 51360,
	/* 33509 */ 51396, 51419, 51442, 51465,
	/* 33513 */ 51495, 51529, 51564, 51599,
	/* 33517 */ 51642, 51676, 51711, 51746,
	/* 33521 */ 51789, 51812, 51835, 51858,
	/* 33525 */ 51888, 51922, 51957, 51992,
	/* 33529 */ 52040, 52074, 52109, 52144,
	/* 33533 */ 52192, 52220, 52248, 52276,
	/* 33537 */ 52316, 52355, 52395, 52435,
	/* 33541 */ 52493, 52532, 52572, 52612,
	/* 33545 */ 52765, 52778, 52791, 52804, 52825, 52844, 52862, 52880, 52895, 52912, 52929, 52941, 52952, 52964, 52977, 52989,
	/* 33561 */ 53213,
	/* 33562 */ 53742, 53763, 53784, 53805, 53826,
	/* 33567 */ 54087,
	/* 33568 */ 54267, 54283, 54300, 54317, 54338,
	/* 33573 */ 54431, 54447, 54463, 54480, 54497, 54518, 54542, 54566, 54589, 54612,
	/* 33583 */ 54799, 54826, 54844, 54862, 54884, 54908, 54929, 54948, 54969, 54990, 55012,
	/* 33594 */ 55074, 55080, -1, 55093, -1, -1, -1, 55106, -1, -1, -1, 55118, -1, 55130, -1, 55142,
	/* 33610 */ 55649, 55684, 55719, 55751, 55783, 55815, 55847, 55881,
	/* 33618 */ 55945, 55959, 55972, 55990, 56003, 56016, 56037, 56061,
	/* 33626 */ 56137, 56148, 56158, 56174, 56200, 56216, 56242, 56258, 56284, 56300, 56326, -1, -1, 56351, 56372, 56403, 56420, 56441, 56458, 56479, 56500,
	/* 33647 */ 56546, 56564, 56583, 56600, 56617,
	/* 33652 */ 56745, 56760, 56781, 56803,
	/* 33656 */ 56837, 56853,
	/* 33658 */ 56961, 56972, 56982, 56993, 57005, 57018, 57032, 57044,
	/* 33666 */ 57072, 57082, 57091, 57101, 57112, 57124, 57137, 57148,
	/* 33674 */ 57569, 57580, 57590, 57614, -1, 57625, 57645,
	/* 33681 */ 57663, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57674, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57683, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57701, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57720, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57737, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57749, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57758, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57768, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57777, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57793, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57804, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57821, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57831, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57847, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57855,
	/* 33937 */ 57940, 57947, 57967, 57972,
	/* 33941 */ 58118, 58131, 58150, 58172,
	/* 33945 */ 58553, 58573,
	/* 33947 */ 58585, 58599, 58612,
	/* 33950 */ 60134, 60156, 60176, 60197, 60218,
	/* 33955 */ 60261, 60278, 60294, 60309, 60325, 60341, 60365, 60389, 60413, 60437, 60458, 60474, 60489, 60513, 60536, 60560, 60580, 60599,
	/* 33973 */ 60642, 60655, 60669, 60681, 60694,
	/* 33978 */ 60767, 60784, 60801, 60817, 60833, 60849, 60865, 60882, 60900,
	/* 33987 */ 60963, 60970, 60984, 60998, 61012, 61026,
	/* 33993 */ 61036, 61048, 61059, 61070,
	/* 33997 */ 61242, -1, -1, 61257,
	/* 34001 */ 61896, 61919, 61942,
	/* 34004 */ 62045, 62058, 62071,
	/* 34007 */ 62083, 62101, 62121, 62141,
	/* 34011 */ 62169, 62185, 62202,
	/* 34014 */ 62229, 62244,
	/* 34016 */ -1, 62322, 62345, 62368, 62391, 62406, 62419, 62431, 62448, -1, 62467, 62487, 62507, 62526, -1, 62538, 62555, 62572, 62588, -1, 62604, 62633, 62644, 62670, 62688, 62705, 62724, 62742, 62761, 62777, 62793, 62813, 62835, 62857, 62871, 62890, 62906, -1, -1, 62916, 62931, -1, 62949, 62972, 62997, 63019, 63044, 38515, 38542, 63066, -1, 63094, 63113, 63131, 63151, 63170, 63190, 63214, 63235,
	/* 34075 */ 63678, 63691, 63703,
	/* 34078 */ 63715, 63728, 63740,
	/* 34081 */ 63754, 63768, 63780,
	/* 34084 */ 63911, 63924, 63938,
	/* 34087 */ 63948, 63961, 63971, 63985,
	/* 34091 */ 64013, 64026, 64038, 64057,
	/* 34095 */ 62229, 62244, 64154,
	/* 34098 */ 64172, 64198, 64224, 64249,
	/* 34102 */ 65028, 65039, 65047, 65063,
	/* 34106 */ 65089, 65115, 65140, 65165, 65188, 65209, 65236, 65265,
	/* 34114 */ 65602, 65614, 65627, 65640,
	/* 34118 */ 65660, 65674, 65682, 65691, 65701, 65710, 65722, 65737, 65752, 65769, 65786, 65800, 65812, -1, 65830, -1, 65848, 65860, 65874, 65888, 65902, 65913, 65924,
	/* 34141 */ 65945, 65958, -1, -1, 65971, 65983, 65995, 66007,
	/* 34149 */ 66032, 66041, 66050, 66063,
	/* 34153 */ 66140, 66155, 66173, 66201, 66231, 66262, 66290, 66320,
	/* 34161 */ 66565, 66584, 66604,
	/* 34164 */ 66652, 66671,
	/* 34166 */ 40164, 40188, 40206, 40225, 40245, 40264, 40286, 40311, 40336, 40363, 40390, 40414, 40436, 40464, 40489, 40517, 40545, 40567, 40591, 40615, 40639, 40660, 40681, 40706, 40735, 40760, 40786, 40809, 40833, 40860, 40888, 67265, 40944, 40966, 40988, 41012, 41032, 41052, 41072, 41092, 41112, 41132, 67285, 67313, 67352, 67391, 67413, 67441, 67469, 67502, 67530, 67558, 67591, 67615, 67642, 67675, 67714, 41618, 41638, 67742, 67764, 67786, 67810, 41755,
	/* 34230 */ 41806, 41827, 41848, 41871, 41894, 41914, 67854, 41959, 67880, 42006, 67904,
	/* 34241 */ 67946, 67962, 67978, 67994, 68010, 68026, 68042, 68060, 68077, 68095, 68112, 68129, 68147,
	/* 34254 */ 68182, 68198, 68214, 68230, 68246, 68262, 68278, 68294, 68310, 68327, 68344, 68361, 68379, 68397,
	/* 34268 */ 68434, 68452, 68470, 68488, 68506, 68524, 68542, 68560, 68578, 68596,
	/* 34278 */ 68664, 68680, 68696, 68712, 68728, 68744,
	/* 34284 */ 245, 69715, 48918, 8089,
	/* 34288 */ -1, 62322, 62345, 62368, 62391, 62406, 62419, 62431, 62448, -1, 62467, 62487, 62507, 62526, 70623, 62538, 62555, 62572, 70635, 70646, 62604, 62633, 62644, 62670, 62688, 62705, 62724, 62742, -1, -1, 62793, 62813, 62835, 62857, 62871, 62890, 62906, 70666, -1, 62916, 62931, -1, 62949, 62972, 62997, 63019, 63044, 38515, 38542, 63066, -1, 63094, 63113, 63131, 63151, 63170, 63190, 63214, 63235, -1, -1, 70680, 70700,
	/* 34351 */ 70883, 70899, 70916, 70943,
	/* 34355 */ 42430, 42445, 42460, 8089,
};

#endif
