/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_STRMOUT_BUFFER_UPDATE},
	{343, PKT3_DRAW_INDEX_OFFSET_2},
	{363, PKT3_DRAW_PREAMBLE},
	{377, PKT3_WRITE_DATA},
	{388, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{414, PKT3_MEM_SEMAPHORE},
	{428, PKT3_MPEG_INDEX},
	{439, PKT3_WAIT_REG_MEM},
	{452, PKT3_MEM_WRITE},
	{462, PKT3_INDIRECT_BUFFER_CIK},
	{482, PKT3_COPY_DATA},
	{492, PKT3_PFP_SYNC_ME},
	{504, PKT3_SURFACE_SYNC},
	{517, PKT3_ME_INITIALIZE},
	{531, PKT3_COND_WRITE},
	{542, PKT3_EVENT_WRITE},
	{554, PKT3_EVENT_WRITE_EOP},
	{570, PKT3_EVENT_WRITE_EOS},
	{586, PKT3_ONE_REG_WRITE},
	{600, PKT3_ACQUIRE_MEM},
	{612, PKT3_SET_CONFIG_REG},
	{627, PKT3_SET_CONTEXT_REG},
	{643, PKT3_SET_SH_REG},
	{654, PKT3_SET_SH_REG_OFFSET},
	{672, PKT3_SET_UCONFIG_REG},
	{688, PKT3_LOAD_CONST_RAM},
	{703, PKT3_WRITE_CONST_RAM},
	{719, PKT3_DUMP_CONST_RAM},
	{734, PKT3_INCREMENT_CE_COUNTER},
	{755, PKT3_INCREMENT_DE_COUNTER},
	{776, PKT3_WAIT_ON_CE_COUNTER},
	{795, PKT3_IT_OPCODE_C},
	{807, PKT3_CP_DMA},
	{814, PKT3_DMA_DATA},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{833, S_370_ENGINE_SEL(~0u), 4, 0},
	{844, S_370_WR_CONFIRM(~0u)},
	{855, S_370_WR_ONE_ADDR(~0u)},
	{928, S_370_DST_SEL(~0u), 6, 4},
	/* 4 */
	{936, S_410_SRC_ADDR_LO(~0u)},
	/* 5 */
	{948, S_411_CP_SYNC(~0u)},
	{980, S_411_SRC_SEL(~0u), 4, 10},
	{988, S_411_ENGINE(~0u), 2, 0},
	{1019, S_411_DSL_SEL(~0u), 4, 14},
	{1027, S_411_SRC_ADDR_HI(~0u)},
	/* 10 */
	{1039, S_412_DST_ADDR_LO(~0u)},
	/* 11 */
	{1051, S_413_DST_ADDR_HI(~0u)},
	/* 12 */
	{1063, S_414_BYTE_COUNT(~0u)},
	{1074, S_414_DISABLE_WR_CONFIRM(~0u)},
	{1122, S_414_SRC_SWAP(~0u), 4, 18},
	{1131, S_414_DST_SWAP(~0u), 4, 18},
	{1147, S_414_SAS(~0u), 2, 22},
	{1151, S_414_DAS(~0u), 2, 22},
	{1178, S_414_SAIC(~0u), 2, 24},
	{1183, S_414_DAIC(~0u), 2, 24},
	{1188, S_414_RAW_WAIT(~0u)},
	/* 21 */
	{948, S_500_CP_SYNC(~0u)},
	{980, S_500_SRC_SEL(~0u), 4, 10},
	{1019, S_500_DSL_SEL(~0u), 4, 14},
	{988, S_500_ENGINE(~0u), 2, 0},
	/* 25 */
	{1197, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{1213, S_000E4C_TST_RQ_PENDING(~0u)},
	{1228, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{1245, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{1261, S_000E4C_VP8_BUSY(~0u)},
	{1270, S_000E4C_SDMA_BUSY(~0u)},
	{1280, S_000E4C_SDMA1_BUSY(~0u)},
	{1291, S_000E4C_VCE0_BUSY(~0u)},
	{1301, S_000E4C_XDMA_BUSY(~0u)},
	{1311, S_000E4C_CHUB_BUSY(~0u)},
	{1321, S_000E4C_SDMA2_BUSY(~0u)},
	{1332, S_000E4C_SDMA3_BUSY(~0u)},
	{1343, S_000E4C_SAMSCP_BUSY(~0u)},
	{1355, S_000E4C_ISP_BUSY(~0u)},
	{1364, S_000E4C_VCE1_BUSY(~0u)},
	{1374, S_000E4C_ODE_BUSY(~0u)},
	{1383, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{1400, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{1417, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{1435, S_000E4C_ISP_RQ_PENDING(~0u)},
	{1450, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 46 */
	{1466, S_000E50_UVD_RQ_PENDING(~0u)},
	{1481, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{1499, S_000E50_ACP_RQ_PENDING(~0u)},
	{1514, S_000E50_SMU_RQ_PENDING(~0u)},
	{1529, S_000E50_GRBM_RQ_PENDING(~0u)},
	{1545, S_000E50_HI_RQ_PENDING(~0u)},
	{1559, S_000E50_VMC_BUSY(~0u)},
	{1568, S_000E50_MCB_BUSY(~0u)},
	{1577, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{1598, S_000E50_MCC_BUSY(~0u)},
	{1607, S_000E50_MCD_BUSY(~0u)},
	{1616, S_000E50_VMC1_BUSY(~0u)},
	{1626, S_000E50_SEM_BUSY(~0u)},
	{1635, S_000E50_ACP_BUSY(~0u)},
	{1644, S_000E50_IH_BUSY(~0u)},
	{1652, S_000E50_UVD_BUSY(~0u)},
	{1661, S_000E50_SAMMSP_BUSY(~0u)},
	{1673, S_000E50_GCATCL2_BUSY(~0u)},
	{1686, S_000E50_OSATCL2_BUSY(~0u)},
	{1699, S_000E50_BIF_BUSY(~0u)},
	/* 66 */
	{1708, S_000E54_MCC0_BUSY(~0u)},
	{1718, S_000E54_MCC1_BUSY(~0u)},
	{1728, S_000E54_MCC2_BUSY(~0u)},
	{1738, S_000E54_MCC3_BUSY(~0u)},
	{1748, S_000E54_MCC4_BUSY(~0u)},
	{1758, S_000E54_MCC5_BUSY(~0u)},
	{1768, S_000E54_MCC6_BUSY(~0u)},
	{1778, S_000E54_MCC7_BUSY(~0u)},
	{1788, S_000E54_MCD0_BUSY(~0u)},
	{1798, S_000E54_MCD1_BUSY(~0u)},
	{1808, S_000E54_MCD2_BUSY(~0u)},
	{1818, S_000E54_MCD3_BUSY(~0u)},
	{1828, S_000E54_MCD4_BUSY(~0u)},
	{1838, S_000E54_MCD5_BUSY(~0u)},
	{1848, S_000E54_MCD6_BUSY(~0u)},
	{1858, S_000E54_MCD7_BUSY(~0u)},
	/* 82 */
	{1868, S_00D034_IDLE(~0u)},
	{1873, S_00D034_REG_IDLE(~0u)},
	{1882, S_00D034_RB_EMPTY(~0u)},
	{1891, S_00D034_RB_FULL(~0u)},
	{1899, S_00D034_RB_CMD_IDLE(~0u)},
	{1911, S_00D034_RB_CMD_FULL(~0u)},
	{1923, S_00D034_IB_CMD_IDLE(~0u)},
	{1935, S_00D034_IB_CMD_FULL(~0u)},
	{1947, S_00D034_BLOCK_IDLE(~0u)},
	{1958, S_00D034_INSIDE_IB(~0u)},
	{1968, S_00D034_EX_IDLE(~0u)},
	{1976, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{2002, S_00D034_PACKET_READY(~0u)},
	{2015, S_00D034_MC_WR_IDLE(~0u)},
	{2026, S_00D034_SRBM_IDLE(~0u)},
	{2036, S_00D034_CONTEXT_EMPTY(~0u)},
	{2050, S_00D034_DELTA_RPTR_FULL(~0u)},
	{2066, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{2082, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{2098, S_00D034_MC_RD_IDLE(~0u)},
	{2109, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{2126, S_00D034_MC_RD_RET_STALL(~0u)},
	{2142, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{2161, S_00D034_PREV_CMD_IDLE(~0u)},
	{2175, S_00D034_SEM_IDLE(~0u)},
	{2184, S_00D034_SEM_REQ_STALL(~0u)},
	{2198, S_00D034_SEM_RESP_STATE(~0u)},
	{2213, S_00D034_INT_IDLE(~0u)},
	{2222, S_00D034_INT_REQ_STALL(~0u)},
	/* 111 */
	{2236, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{2259, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{2282, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{2305, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{2325, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{2345, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{2365, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{2385, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{2405, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{2425, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{2445, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{2465, S_008008_RLC_RQ_PENDING(~0u)},
	{2480, S_008008_RLC_BUSY(~0u)},
	{2489, S_008008_TC_BUSY(~0u)},
	{2497, S_008008_TCC_CC_RESIDENT(~0u)},
	{2513, S_008008_CPF_BUSY(~0u)},
	{2522, S_008008_CPC_BUSY(~0u)},
	{2531, S_008008_CPG_BUSY(~0u)},
	/* 129 */
	{2540, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{2563, S_008010_SRBM_RQ_PENDING(~0u)},
	{2579, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{2602, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{2625, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{2644, S_008010_DB_CLEAN(~0u)},
	{2653, S_008010_CB_CLEAN(~0u)},
	{2662, S_008010_TA_BUSY(~0u)},
	{2670, S_008010_GDS_BUSY(~0u)},
	{2679, S_008010_WD_BUSY_NO_DMA(~0u)},
	{2694, S_008010_VGT_BUSY(~0u)},
	{2703, S_008010_IA_BUSY_NO_DMA(~0u)},
	{2718, S_008010_IA_BUSY(~0u)},
	{2726, S_008010_SX_BUSY(~0u)},
	{2734, S_008010_WD_BUSY(~0u)},
	{2742, S_008010_SPI_BUSY(~0u)},
	{2751, S_008010_BCI_BUSY(~0u)},
	{2760, S_008010_SC_BUSY(~0u)},
	{2768, S_008010_PA_BUSY(~0u)},
	{2776, S_008010_DB_BUSY(~0u)},
	{2784, S_008010_CP_COHERENCY_BUSY(~0u)},
	{1347, S_008010_CP_BUSY(~0u)},
	{1569, S_008010_CB_BUSY(~0u)},
	{2802, S_008010_GUI_ACTIVE(~0u)},
	/* 153 */
	{2813, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 154 */
	{2832, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{2848, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{2864, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{2882, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{2900, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{2918, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{2936, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{2954, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{2972, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{2990, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{3008, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{3025, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{3041, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{3057, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{3073, S_0085F0_TC_ACTION_ENA(~0u)},
	{3087, S_0085F0_CB_ACTION_ENA(~0u)},
	{3101, S_0085F0_DB_ACTION_ENA(~0u)},
	{3115, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3136, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 173 */
	{2644, S_008014_DB_CLEAN(~0u)},
	{2653, S_008014_CB_CLEAN(~0u)},
	{2751, S_008014_BCI_BUSY(~0u)},
	{2694, S_008014_VGT_BUSY(~0u)},
	{2768, S_008014_PA_BUSY(~0u)},
	{2662, S_008014_TA_BUSY(~0u)},
	{2726, S_008014_SX_BUSY(~0u)},
	{2742, S_008014_SPI_BUSY(~0u)},
	{2760, S_008014_SC_BUSY(~0u)},
	{2776, S_008014_DB_BUSY(~0u)},
	{1569, S_008014_CB_BUSY(~0u)},
	/* 184 */
	{2644, S_008018_DB_CLEAN(~0u)},
	{2653, S_008018_CB_CLEAN(~0u)},
	{2751, S_008018_BCI_BUSY(~0u)},
	{2694, S_008018_VGT_BUSY(~0u)},
	{2768, S_008018_PA_BUSY(~0u)},
	{2662, S_008018_TA_BUSY(~0u)},
	{2726, S_008018_SX_BUSY(~0u)},
	{2742, S_008018_SPI_BUSY(~0u)},
	{2760, S_008018_SC_BUSY(~0u)},
	{2776, S_008018_DB_BUSY(~0u)},
	{1569, S_008018_CB_BUSY(~0u)},
	/* 195 */
	{2644, S_008038_DB_CLEAN(~0u)},
	{2653, S_008038_CB_CLEAN(~0u)},
	{2751, S_008038_BCI_BUSY(~0u)},
	{2694, S_008038_VGT_BUSY(~0u)},
	{2768, S_008038_PA_BUSY(~0u)},
	{2662, S_008038_TA_BUSY(~0u)},
	{2726, S_008038_SX_BUSY(~0u)},
	{2742, S_008038_SPI_BUSY(~0u)},
	{2760, S_008038_SC_BUSY(~0u)},
	{2776, S_008038_DB_BUSY(~0u)},
	{1569, S_008038_CB_BUSY(~0u)},
	/* 206 */
	{2644, S_00803C_DB_CLEAN(~0u)},
	{2653, S_00803C_CB_CLEAN(~0u)},
	{2751, S_00803C_BCI_BUSY(~0u)},
	{2694, S_00803C_VGT_BUSY(~0u)},
	{2768, S_00803C_PA_BUSY(~0u)},
	{2662, S_00803C_TA_BUSY(~0u)},
	{2726, S_00803C_SX_BUSY(~0u)},
	{2742, S_00803C_SPI_BUSY(~0u)},
	{2760, S_00803C_SC_BUSY(~0u)},
	{2776, S_00803C_DB_BUSY(~0u)},
	{1569, S_00803C_CB_BUSY(~0u)},
	/* 217 */
	{2813, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 218 */
	{3157, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 219 */
	{3176, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 220 */
	{2832, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{2848, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{3194, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{3211, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{2864, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{2882, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{2900, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{2918, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{2936, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{2954, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{2972, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{2990, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{3008, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{3228, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{3248, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{3266, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{3025, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{3041, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{3057, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{3073, S_0301F0_TC_ACTION_ENA(~0u)},
	{3087, S_0301F0_CB_ACTION_ENA(~0u)},
	{3101, S_0301F0_DB_ACTION_ENA(~0u)},
	{3115, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3283, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{3136, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{3308, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{3332, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 247 */
	{3349, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{3367, S_0301FC_MEID(~0u)},
	{3372, S_0301FC_PHASE1_STATUS(~0u)},
	{3379, S_0301FC_STATUS(~0u)},
	/* 251 */
	{3386, S_008210_MEC1_BUSY(~0u)},
	{3396, S_008210_MEC2_BUSY(~0u)},
	{3406, S_008210_DC0_BUSY(~0u)},
	{3415, S_008210_DC1_BUSY(~0u)},
	{3424, S_008210_RCIU1_BUSY(~0u)},
	{3435, S_008210_RCIU2_BUSY(~0u)},
	{3446, S_008210_ROQ1_BUSY(~0u)},
	{3456, S_008210_ROQ2_BUSY(~0u)},
	{3466, S_008210_TCIU_BUSY(~0u)},
	{3476, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{3493, S_008210_QU_BUSY(~0u)},
	{3501, S_008210_ATCL2IU_BUSY(~0u)},
	{3514, S_008210_CPG_CPC_BUSY(~0u)},
	{3527, S_008210_CPF_CPC_BUSY(~0u)},
	{2522, S_008210_CPC_BUSY(~0u)},
	/* 266 */
	{3540, S_008214_MEC1_LOAD_BUSY(~0u)},
	{3555, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{3575, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{3591, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{3609, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{3629, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{3648, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{3667, S_008214_MEC1_TC_BUSY(~0u)},
	{3680, S_008214_MEC1_DMA_BUSY(~0u)},
	{3694, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{3718, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{3734, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{3750, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{3766, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{3782, S_008214_MEC2_LOAD_BUSY(~0u)},
	{3797, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{3817, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{3833, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{3851, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{3871, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{3890, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{3909, S_008214_MEC2_TC_BUSY(~0u)},
	{3922, S_008214_MEC2_DMA_BUSY(~0u)},
	{3936, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{3960, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{3976, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{3992, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{4008, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 294 */
	{4024, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{4043, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{4063, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{4082, S_008218_MEC1_DECODING_PACKET(~0u)},
	{4103, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{4121, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{4144, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{4166, S_008218_MEC2_DECODING_PACKET(~0u)},
	{4187, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{4205, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{4228, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{4250, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4274, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4298, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 308 */
	{4321, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{4340, S_00821C_CSF_BUSY(~0u)},
	{4349, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{4364, S_00821C_ROQ_RING_BUSY(~0u)},
	{4378, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{4397, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{4416, S_00821C_ROQ_STATE_BUSY(~0u)},
	{4431, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{4448, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4470, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{4492, S_00821C_SEMAPHORE_BUSY(~0u)},
	{4507, S_00821C_INTERRUPT_BUSY(~0u)},
	{3466, S_00821C_TCIU_BUSY(~0u)},
	{4522, S_00821C_HQD_BUSY(~0u)},
	{4531, S_00821C_PRT_BUSY(~0u)},
	{3501, S_00821C_ATCL2IU_BUSY(~0u)},
	{4540, S_00821C_CPF_GFX_BUSY(~0u)},
	{4553, S_00821C_CPF_CMP_BUSY(~0u)},
	{4566, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{4585, S_00821C_CPC_CPF_BUSY(~0u)},
	{2513, S_00821C_CPF_BUSY(~0u)},
	/* 329 */
	{4598, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{4616, S_008220_CSF_RING_BUSY(~0u)},
	{4630, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{4649, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{4668, S_008220_CSF_STATE_BUSY(~0u)},
	{4683, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{4701, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{4719, S_008220_CSF_ARBITER_BUSY(~0u)},
	{4736, S_008220_CSF_INPUT_BUSY(~0u)},
	{4751, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{4773, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{4797, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{4815, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{4833, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{4854, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{4878, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{4904, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{4921, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{4941, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{4961, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{4981, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{5002, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{5025, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{5046, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{5065, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{5082, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{5098, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{5114, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{5130, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{5149, S_008220_HQD_PQ_BUSY(~0u)},
	{5161, S_008220_HQD_IB_BUSY(~0u)},
	/* 360 */
	{5173, S_008224_RING_FETCHING_DATA(~0u)},
	{5192, S_008224_INDR1_FETCHING_DATA(~0u)},
	{5212, S_008224_INDR2_FETCHING_DATA(~0u)},
	{5232, S_008224_STATE_FETCHING_DATA(~0u)},
	{5252, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{5273, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{4250, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4274, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4298, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 369 */
	{5294, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 370 */
	{5313, S_0088B0_PRIM_COUNT(~0u)},
	/* 371 */
	{5324, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{5343, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{5364, S_0088C4_ES_LIMIT(~0u)},
	/* 374 */
	{5373, S_0088D4_VERT_REUSE(~0u)},
	/* 375 */
	{5900, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 376 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 377 */
	{38, S_008988_SIZE(~0u)},
	/* 378 */
	{5952, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 379 */
	{5970, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{5991, S_008A14_NUM_CLIP_SEQ(~0u)},
	{6004, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{6027, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 383 */
	{6047, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 384 */
	{6066, S_008B10_CURRENT_PTR(~0u)},
	{6078, S_008B10_CURRENT_COUNT(~0u)},
	/* 386 */
	{6092, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6117, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{6155, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{6196, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{6219, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{6242, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{6266, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6296, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6325, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{6351, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{6380, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{6405, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{5252, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{5273, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{6440, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6468, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{4250, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4274, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4298, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 405 */
	{6498, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{6525, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{6552, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{6581, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{6610, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{6639, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6667, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{6697, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{6724, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{6752, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{6777, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{6803, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{6828, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{6852, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{6877, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{6905, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 421 */
	{6934, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6960, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{6986, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7013, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{7039, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{7061, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{7088, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{7110, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{7134, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{7159, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7182, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{7209, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{7234, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{7262, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7287, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7312, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{7337, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7366, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7397, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{7425, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{7452, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{7482, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{7509, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{7536, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{7563, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{7589, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{7613, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{7645, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{7672, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 450 */
	{4364, S_008680_ROQ_RING_BUSY(~0u)},
	{4378, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{4397, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{4416, S_008680_ROQ_STATE_BUSY(~0u)},
	{7698, S_008680_DC_BUSY(~0u)},
	{3501, S_008680_ATCL2IU_BUSY(~0u)},
	{7706, S_008680_PFP_BUSY(~0u)},
	{7715, S_008680_MEQ_BUSY(~0u)},
	{7724, S_008680_ME_BUSY(~0u)},
	{7732, S_008680_QUERY_BUSY(~0u)},
	{4492, S_008680_SEMAPHORE_BUSY(~0u)},
	{4507, S_008680_INTERRUPT_BUSY(~0u)},
	{7743, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{1271, S_008680_DMA_BUSY(~0u)},
	{7761, S_008680_RCIU_BUSY(~0u)},
	{3476, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{7771, S_008680_CPC_CPG_BUSY(~0u)},
	{7784, S_008680_CE_BUSY(~0u)},
	{3466, S_008680_TCIU_BUSY(~0u)},
	{4431, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{4448, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4470, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{1347, S_008680_CP_BUSY(~0u)},
	/* 473 */
	{7792, S_030800_INSTANCE_INDEX(~0u)},
	{7807, S_030800_SH_INDEX(~0u)},
	{7816, S_030800_SE_INDEX(~0u)},
	{7825, S_030800_SH_BROADCAST_WRITES(~0u)},
	{7845, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{7871, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 479 */
	{5900, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 480 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 481 */
	{38, S_030938_SIZE(~0u)},
	/* 482 */
	{5952, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{7939, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 484 */
	{6047, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 485 */
	{6066, S_030A04_CURRENT_PTR(~0u)},
	{6078, S_030A04_CURRENT_COUNT(~0u)},
	/* 487 */
	{437, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 489 */
	{437, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 491 */
	{437, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 493 */
	{437, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 495 */
	{7959, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{7985, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{8008, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{8033, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{8064, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{8098, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{8118, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{8145, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{8173, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 504 */
	{8208, S_008C08_INST_INVALIDATE(~0u)},
	{8224, S_008C08_DATA_INVALIDATE(~0u)},
	/* 506 */
	{8208, S_030D20_INST_INVALIDATE(~0u)},
	{8224, S_030D20_DATA_INVALIDATE(~0u)},
	{8240, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 509 */
	{8260, S_008C0C_RET(~0u)},
	{8264, S_008C0C_RUI(~0u)},
	{8268, S_008C0C_RNG(~0u)},
	/* 512 */
	{8272, S_008DFC_EN(~0u)},
	{8334, S_008DFC_TGT(~0u), 33, 90},
	{8338, S_008DFC_COMPR(~0u)},
	{2827, S_008DFC_DONE(~0u)},
	{8344, S_008DFC_VM(~0u)},
	{8364, S_008DFC_ENCODING(~0u), 63, 123},
	/* 518 */
	{8373, S_030E04_ADDRESS(~0u)},
	/* 519 */
	{8381, S_030F04_COUNT_HI(~0u)},
	/* 520 */
	{8390, S_008F04_BASE_ADDRESS_HI(~0u)},
	{8406, S_008F04_STRIDE(~0u)},
	{8413, S_008F04_CACHE_SWIZZLE(~0u)},
	{8427, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 524 */
	{8381, S_030F0C_COUNT_HI(~0u)},
	/* 525 */
	{8532, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{8542, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{8552, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{8562, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{8746, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{9138, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{9150, S_008F0C_ELEMENT_SIZE(~0u)},
	{9163, S_008F0C_INDEX_STRIDE(~0u)},
	{9176, S_008F0C_ADD_TID_ENABLE(~0u)},
	{9191, S_008F0C_ATC(~0u)},
	{9195, S_008F0C_HASH_ENABLE(~0u)},
	{9207, S_008F0C_HEAP(~0u)},
	{9212, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 539 */
	{8381, S_030F14_COUNT_HI(~0u)},
	/* 540 */
	{8390, S_008F14_BASE_ADDRESS_HI(~0u)},
	{9287, S_008F14_MIN_LOD(~0u)},
	{9138, S_008F14_DATA_FORMAT(~0u), 64, 222},
	{8746, S_008F14_NUM_FORMAT(~0u), 16, 286},
	{9212, S_008F14_MTYPE(~0u)},
	/* 545 */
	{11277, S_008F18_WIDTH(~0u)},
	{11283, S_008F18_HEIGHT(~0u)},
	{11290, S_008F18_PERF_MOD(~0u)},
	{11299, S_008F18_INTERLACED(~0u)},
	/* 549 */
	{8381, S_030F1C_COUNT_HI(~0u)},
	/* 550 */
	{8532, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{8542, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{8552, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{8562, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{11310, S_008F1C_BASE_LEVEL(~0u)},
	{11321, S_008F1C_LAST_LEVEL(~0u)},
	{11332, S_008F1C_TILING_INDEX(~0u)},
	{11345, S_008F1C_POW2_PAD(~0u)},
	{9212, S_008F1C_MTYPE(~0u)},
	{9191, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 561 */
	{11656, S_008F20_DEPTH(~0u)},
	{11662, S_008F20_PITCH(~0u)},
	/* 563 */
	{11668, S_008F24_BASE_ARRAY(~0u)},
	{11679, S_008F24_LAST_ARRAY(~0u)},
	/* 565 */
	{11690, S_008F28_MIN_LOD_WARN(~0u)},
	{11703, S_008F28_COUNTER_BANK_ID(~0u)},
	{11719, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{11734, S_008F28_COMPRESSION_EN(~0u)},
	{11749, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{11765, S_008F28_COLOR_TRANSFORM(~0u)},
	{11781, S_008F28_LOST_ALPHA_BITS(~0u)},
	{11797, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 573 */
	{11995, S_008F30_CLAMP_X(~0u), 8, 318},
	{12003, S_008F30_CLAMP_Y(~0u), 8, 318},
	{12011, S_008F30_CLAMP_Z(~0u), 8, 318},
	{12019, S_008F30_MAX_ANISO_RATIO(~0u)},
	{12267, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{12286, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{12305, S_008F30_MC_COORD_TRUNC(~0u)},
	{12320, S_008F30_FORCE_DEGAMMA(~0u)},
	{12334, S_008F30_TRUNC_COORD(~0u)},
	{12346, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{12364, S_008F30_FILTER_MODE(~0u)},
	{12376, S_008F30_COMPAT_MODE(~0u)},
	/* 585 */
	{9287, S_008F34_MIN_LOD(~0u)},
	{12388, S_008F34_MAX_LOD(~0u)},
	{12396, S_008F34_PERF_MIP(~0u)},
	{12405, S_008F34_PERF_Z(~0u)},
	/* 589 */
	{12412, S_008F38_LOD_BIAS(~0u)},
	{12421, S_008F38_LOD_BIAS_SEC(~0u)},
	{12483, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{12558, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{12638, S_008F38_Z_FILTER(~0u), 3, 340},
	{12647, S_008F38_MIP_FILTER(~0u), 3, 340},
	{12658, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{12677, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{12694, S_008F38_FILTER_PREC_FIX(~0u)},
	{12710, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 599 */
	{12725, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{12869, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 601 */
	{12887, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{12904, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{12921, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{12938, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{12955, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 606 */
	{12972, S_0090E0_PS_CU_EN(~0u)},
	{12981, S_0090E0_VS_CU_EN(~0u)},
	/* 608 */
	{12990, S_0090E4_GS_CU_EN(~0u)},
	{12999, S_0090E4_ES_CU_EN(~0u)},
	/* 610 */
	{13008, S_0090E8_LSHS_CU_EN(~0u)},
	/* 611 */
	{13019, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 612 */
	{13019, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 613 */
	{13036, S_0090F0_RING_ORDER_TS0(~0u), 1, 347},
	{13051, S_0090F0_RING_ORDER_TS1(~0u)},
	{13066, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 616 */
	{13081, S_00C700_PIPE_ORDER_TS0(~0u)},
	{13096, S_00C700_PIPE_ORDER_TS1(~0u)},
	{13111, S_00C700_PIPE_ORDER_TS2(~0u)},
	{13126, S_00C700_PIPE_ORDER_TS3(~0u)},
	{13141, S_00C700_TS0_DUR_MULT(~0u)},
	{13154, S_00C700_TS1_DUR_MULT(~0u)},
	{13167, S_00C700_TS2_DUR_MULT(~0u)},
	{13180, S_00C700_TS3_DUR_MULT(~0u)},
	/* 624 */
	{13193, S_0090F4_TS0_DURATION(~0u)},
	{13206, S_0090F4_TS1_DURATION(~0u)},
	/* 626 */
	{13219, S_0090F8_TS2_DURATION(~0u)},
	/* 627 */
	{38, S_008F40_SIZE(~0u)},
	/* 628 */
	{665, S_008F44_OFFSET(~0u)},
	/* 629 */
	{8381, S_030FFC_COUNT_HI(~0u)},
	/* 630 */
	{13232, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{13251, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{13270, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{13292, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{13314, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 635 */
	{13583, S_00913C_VTX_DONE_DELAY(~0u), 16, 348},
	{13598, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{13622, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{13638, S_00913C_PC_LIMIT_STRICT(~0u)},
	{13654, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 640 */
	{13668, S_00936C_TYPE_A(~0u)},
	{13675, S_00936C_VGPR_A(~0u)},
	{13682, S_00936C_SGPR_A(~0u)},
	{13689, S_00936C_LDS_A(~0u)},
	{13695, S_00936C_WAVES_A(~0u)},
	{13703, S_00936C_EN_A(~0u)},
	{13708, S_00936C_TYPE_B(~0u)},
	{13715, S_00936C_VGPR_B(~0u)},
	{13722, S_00936C_SGPR_B(~0u)},
	{13729, S_00936C_LDS_B(~0u)},
	{13735, S_00936C_WAVES_B(~0u)},
	{13743, S_00936C_EN_B(~0u)},
	/* 652 */
	{13748, S_009858_MSAA1_X(~0u)},
	{13756, S_009858_MSAA1_Y(~0u)},
	{13764, S_009858_MSAA2_X(~0u)},
	{13772, S_009858_MSAA2_Y(~0u)},
	{13780, S_009858_MSAA4_X(~0u)},
	{13788, S_009858_MSAA4_Y(~0u)},
	{13796, S_009858_MSAA8_X(~0u)},
	{13804, S_009858_MSAA8_Y(~0u)},
	{13812, S_009858_MSAA16_X(~0u)},
	{13821, S_009858_MSAA16_Y(~0u)},
	/* 662 */
	{13830, S_0098F8_NUM_PIPES(~0u)},
	{13840, S_0098F8_PIPE_INTERLEAVE_SIZE(~0u)},
	{13861, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{13882, S_0098F8_NUM_SHADER_ENGINES(~0u)},
	{13901, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{13925, S_0098F8_NUM_GPUS(~0u)},
	{13934, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{13954, S_0098F8_ROW_SIZE(~0u)},
	{13963, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 671 */
	{14096, S_009910_MICRO_TILE_MODE(~0u), 4, 364},
	{14341, S_009910_ARRAY_MODE(~0u), 16, 368},
	{14703, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{14893, S_009910_TILE_SPLIT(~0u), 7, 399},
	{14996, S_009910_BANK_WIDTH(~0u), 4, 406},
	{15103, S_009910_BANK_HEIGHT(~0u), 4, 410},
	{15215, S_009910_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15302, S_009910_NUM_BANKS(~0u), 4, 418},
	{15343, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{15363, S_009910_SAMPLE_SPLIT(~0u)},
	/* 681 */
	{14996, S_009990_BANK_WIDTH(~0u)},
	{15103, S_009990_BANK_HEIGHT(~0u)},
	{15215, S_009990_MACRO_TILE_ASPECT(~0u)},
	{15302, S_009990_NUM_BANKS(~0u)},
	/* 685 */
	{15376, S_00B004_MEM_BASE(~0u)},
	/* 686 */
	{15376, S_00B00C_MEM_BASE(~0u)},
	/* 687 */
	{12975, S_00B01C_CU_EN(~0u)},
	{15385, S_00B01C_WAVE_LIMIT(~0u)},
	{15396, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 690 */
	{15376, S_00B024_MEM_BASE(~0u)},
	/* 691 */
	{15415, S_00B028_VGPRS(~0u)},
	{15421, S_00B028_SGPRS(~0u)},
	{13242, S_00B028_PRIORITY(~0u)},
	{15470, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{15481, S_00B028_PRIV(~0u)},
	{15486, S_00B028_DX10_CLAMP(~0u)},
	{15497, S_00B028_DEBUG_MODE(~0u)},
	{15508, S_00B028_IEEE_MODE(~0u)},
	{15518, S_00B028_CU_GROUP_DISABLE(~0u)},
	{15535, S_00B028_CACHE_CTL(~0u)},
	{15545, S_00B028_CDBG_USER(~0u)},
	/* 702 */
	{15555, S_00B02C_SCRATCH_EN(~0u)},
	{15566, S_00B02C_USER_SGPR(~0u)},
	{15576, S_00B02C_TRAP_PRESENT(~0u)},
	{15589, S_00B02C_WAVE_CNT_EN(~0u)},
	{15601, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{15616, S_00B02C_EXCP_EN(~0u)},
	{15624, S_00B02C_EXCP_EN_CIK(~0u)},
	/* 709 */
	{15376, S_00B104_MEM_BASE(~0u)},
	/* 710 */
	{15376, S_00B10C_MEM_BASE(~0u)},
	/* 711 */
	{12975, S_00B118_CU_EN(~0u)},
	{15385, S_00B118_WAVE_LIMIT(~0u)},
	{15396, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 714 */
	{5367, S_00B11C_LIMIT(~0u)},
	/* 715 */
	{15376, S_00B124_MEM_BASE(~0u)},
	/* 716 */
	{15415, S_00B128_VGPRS(~0u)},
	{15421, S_00B128_SGPRS(~0u)},
	{13242, S_00B128_PRIORITY(~0u)},
	{15470, S_00B128_FLOAT_MODE(~0u)},
	{15481, S_00B128_PRIV(~0u)},
	{15486, S_00B128_DX10_CLAMP(~0u)},
	{15497, S_00B128_DEBUG_MODE(~0u)},
	{15508, S_00B128_IEEE_MODE(~0u)},
	{15636, S_00B128_VGPR_COMP_CNT(~0u)},
	{15650, S_00B128_CU_GROUP_ENABLE(~0u)},
	{15535, S_00B128_CACHE_CTL(~0u)},
	{15545, S_00B128_CDBG_USER(~0u)},
	/* 728 */
	{15555, S_00B12C_SCRATCH_EN(~0u)},
	{15566, S_00B12C_USER_SGPR(~0u)},
	{15576, S_00B12C_TRAP_PRESENT(~0u)},
	{15666, S_00B12C_OC_LDS_EN(~0u)},
	{15676, S_00B12C_SO_BASE0_EN(~0u)},
	{15688, S_00B12C_SO_BASE1_EN(~0u)},
	{15700, S_00B12C_SO_BASE2_EN(~0u)},
	{15712, S_00B12C_SO_BASE3_EN(~0u)},
	{15724, S_00B12C_SO_EN(~0u)},
	{15616, S_00B12C_EXCP_EN(~0u)},
	{15624, S_00B12C_EXCP_EN_CIK(~0u)},
	{15730, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 740 */
	{15376, S_00B204_MEM_BASE(~0u)},
	/* 741 */
	{15376, S_00B20C_MEM_BASE(~0u)},
	/* 742 */
	{12975, S_00B21C_CU_EN(~0u)},
	{15385, S_00B21C_WAVE_LIMIT(~0u)},
	{15396, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 746 */
	{15376, S_00B224_MEM_BASE(~0u)},
	/* 747 */
	{15415, S_00B228_VGPRS(~0u)},
	{15421, S_00B228_SGPRS(~0u)},
	{13242, S_00B228_PRIORITY(~0u)},
	{15470, S_00B228_FLOAT_MODE(~0u)},
	{15481, S_00B228_PRIV(~0u)},
	{15486, S_00B228_DX10_CLAMP(~0u)},
	{15497, S_00B228_DEBUG_MODE(~0u)},
	{15508, S_00B228_IEEE_MODE(~0u)},
	{15650, S_00B228_CU_GROUP_ENABLE(~0u)},
	{15535, S_00B228_CACHE_CTL(~0u)},
	{15545, S_00B228_CDBG_USER(~0u)},
	/* 758 */
	{15555, S_00B22C_SCRATCH_EN(~0u)},
	{15566, S_00B22C_USER_SGPR(~0u)},
	{15576, S_00B22C_TRAP_PRESENT(~0u)},
	{15616, S_00B22C_EXCP_EN(~0u)},
	{15624, S_00B22C_EXCP_EN_CIK(~0u)},
	/* 763 */
	{15376, S_00B304_MEM_BASE(~0u)},
	/* 764 */
	{15376, S_00B30C_MEM_BASE(~0u)},
	/* 765 */
	{12975, S_00B31C_CU_EN(~0u)},
	{15385, S_00B31C_WAVE_LIMIT(~0u)},
	{15396, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 769 */
	{15376, S_00B324_MEM_BASE(~0u)},
	/* 770 */
	{15415, S_00B328_VGPRS(~0u)},
	{15421, S_00B328_SGPRS(~0u)},
	{13242, S_00B328_PRIORITY(~0u)},
	{15470, S_00B328_FLOAT_MODE(~0u)},
	{15481, S_00B328_PRIV(~0u)},
	{15486, S_00B328_DX10_CLAMP(~0u)},
	{15497, S_00B328_DEBUG_MODE(~0u)},
	{15508, S_00B328_IEEE_MODE(~0u)},
	{15636, S_00B328_VGPR_COMP_CNT(~0u)},
	{15650, S_00B328_CU_GROUP_ENABLE(~0u)},
	{15535, S_00B328_CACHE_CTL(~0u)},
	{15545, S_00B328_CDBG_USER(~0u)},
	/* 782 */
	{15555, S_00B32C_SCRATCH_EN(~0u)},
	{15566, S_00B32C_USER_SGPR(~0u)},
	{15576, S_00B32C_TRAP_PRESENT(~0u)},
	{15666, S_00B32C_OC_LDS_EN(~0u)},
	{15616, S_00B32C_EXCP_EN(~0u)},
	{15607, S_00B32C_LDS_SIZE(~0u)},
	/* 788 */
	{15376, S_00B404_MEM_BASE(~0u)},
	/* 789 */
	{15376, S_00B40C_MEM_BASE(~0u)},
	/* 790 */
	{15385, S_00B41C_WAVE_LIMIT(~0u)},
	{15396, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 793 */
	{15376, S_00B424_MEM_BASE(~0u)},
	/* 794 */
	{15415, S_00B428_VGPRS(~0u)},
	{15421, S_00B428_SGPRS(~0u)},
	{13242, S_00B428_PRIORITY(~0u)},
	{15470, S_00B428_FLOAT_MODE(~0u)},
	{15481, S_00B428_PRIV(~0u)},
	{15486, S_00B428_DX10_CLAMP(~0u)},
	{15497, S_00B428_DEBUG_MODE(~0u)},
	{15508, S_00B428_IEEE_MODE(~0u)},
	{15535, S_00B428_CACHE_CTL(~0u)},
	{15545, S_00B428_CDBG_USER(~0u)},
	/* 804 */
	{15555, S_00B42C_SCRATCH_EN(~0u)},
	{15566, S_00B42C_USER_SGPR(~0u)},
	{15576, S_00B42C_TRAP_PRESENT(~0u)},
	{15666, S_00B42C_OC_LDS_EN(~0u)},
	{15764, S_00B42C_TG_SIZE_EN(~0u)},
	{15616, S_00B42C_EXCP_EN(~0u)},
	/* 810 */
	{15376, S_00B504_MEM_BASE(~0u)},
	/* 811 */
	{15376, S_00B50C_MEM_BASE(~0u)},
	/* 812 */
	{12975, S_00B51C_CU_EN(~0u)},
	{15385, S_00B51C_WAVE_LIMIT(~0u)},
	{15396, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 816 */
	{15376, S_00B524_MEM_BASE(~0u)},
	/* 817 */
	{15415, S_00B528_VGPRS(~0u)},
	{15421, S_00B528_SGPRS(~0u)},
	{13242, S_00B528_PRIORITY(~0u)},
	{15470, S_00B528_FLOAT_MODE(~0u)},
	{15481, S_00B528_PRIV(~0u)},
	{15486, S_00B528_DX10_CLAMP(~0u)},
	{15497, S_00B528_DEBUG_MODE(~0u)},
	{15508, S_00B528_IEEE_MODE(~0u)},
	{15636, S_00B528_VGPR_COMP_CNT(~0u)},
	{15535, S_00B528_CACHE_CTL(~0u)},
	{15545, S_00B528_CDBG_USER(~0u)},
	/* 828 */
	{15555, S_00B52C_SCRATCH_EN(~0u)},
	{15566, S_00B52C_USER_SGPR(~0u)},
	{15576, S_00B52C_TRAP_PRESENT(~0u)},
	{15607, S_00B52C_LDS_SIZE(~0u)},
	{15616, S_00B52C_EXCP_EN(~0u)},
	/* 833 */
	{15775, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{15793, S_00B800_PARTIAL_TG_EN(~0u)},
	{15807, S_00B800_FORCE_START_AT_000(~0u)},
	{15826, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{15846, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{15866, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{15888, S_00B800_ORDER_MODE(~0u)},
	{15899, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{15919, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{15937, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{15955, S_00B800_DATA_ATC(~0u)},
	{15964, S_00B800_RESTORE(~0u)},
	/* 845 */
	{15972, S_00B81C_NUM_THREAD_FULL(~0u)},
	{15988, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 847 */
	{15972, S_00B820_NUM_THREAD_FULL(~0u)},
	{15988, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 849 */
	{15972, S_00B824_NUM_THREAD_FULL(~0u)},
	{15988, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 851 */
	{13019, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 852 */
	{16007, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 853 */
	{16027, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 854 */
	{383, S_00B834_DATA(~0u)},
	{16044, S_00B834_INST_ATC(~0u)},
	/* 856 */
	{383, S_00B83C_DATA(~0u)},
	/* 857 */
	{383, S_00B844_DATA(~0u)},
	/* 858 */
	{15415, S_00B848_VGPRS(~0u)},
	{15421, S_00B848_SGPRS(~0u)},
	{13242, S_00B848_PRIORITY(~0u)},
	{15470, S_00B848_FLOAT_MODE(~0u)},
	{15481, S_00B848_PRIV(~0u)},
	{15486, S_00B848_DX10_CLAMP(~0u)},
	{15497, S_00B848_DEBUG_MODE(~0u)},
	{15508, S_00B848_IEEE_MODE(~0u)},
	{16053, S_00B848_BULKY(~0u)},
	{15545, S_00B848_CDBG_USER(~0u)},
	/* 868 */
	{15555, S_00B84C_SCRATCH_EN(~0u)},
	{15566, S_00B84C_USER_SGPR(~0u)},
	{15576, S_00B84C_TRAP_PRESENT(~0u)},
	{16059, S_00B84C_TGID_X_EN(~0u)},
	{16069, S_00B84C_TGID_Y_EN(~0u)},
	{16079, S_00B84C_TGID_Z_EN(~0u)},
	{15764, S_00B84C_TG_SIZE_EN(~0u)},
	{16089, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{16104, S_00B84C_EXCP_EN_MSB(~0u)},
	{15607, S_00B84C_LDS_SIZE(~0u)},
	{15616, S_00B84C_EXCP_EN(~0u)},
	/* 879 */
	{383, S_00B850_DATA(~0u)},
	/* 880 */
	{16116, S_00B854_WAVES_PER_SH(~0u)},
	{16129, S_00B854_WAVES_PER_SH_CIK(~0u)},
	{16146, S_00B854_TG_PER_CU(~0u)},
	{16156, S_00B854_LOCK_THRESHOLD(~0u)},
	{16171, S_00B854_SIMD_DEST_CNTL(~0u)},
	{16186, S_00B854_FORCE_SIMD_DIST(~0u)},
	{16202, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 887 */
	{16217, S_00B858_SH0_CU_EN(~0u)},
	{16227, S_00B858_SH1_CU_EN(~0u)},
	/* 889 */
	{16217, S_00B85C_SH0_CU_EN(~0u)},
	{16227, S_00B85C_SH1_CU_EN(~0u)},
	/* 891 */
	{16237, S_00B860_WAVES(~0u)},
	{16243, S_00B860_WAVESIZE(~0u)},
	/* 893 */
	{16217, S_00B864_SH0_CU_EN(~0u)},
	{16227, S_00B864_SH1_CU_EN(~0u)},
	/* 895 */
	{16217, S_00B868_SH0_CU_EN(~0u)},
	{16227, S_00B868_SH1_CU_EN(~0u)},
	/* 897 */
	{16252, S_00B87C_SEND_SEID(~0u)},
	{14424, S_00B87C_RESERVED2(~0u)},
	{16262, S_00B87C_RESERVED3(~0u)},
	{16272, S_00B87C_RESERVED4(~0u)},
	{16282, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 902 */
	{16295, S_00B888_PAYLOAD(~0u)},
	{16303, S_00B888_IS_EVENT(~0u)},
	{16312, S_00B888_IS_STATE(~0u)},
	/* 905 */
	{862, S_00B890_ADDR(~0u)},
	/* 906 */
	{9191, S_00B894_ATC(~0u)},
	{9212, S_00B894_MTYPE(~0u)},
	/* 908 */
	{16321, S_034404_PERFCOUNTER_HI(~0u)},
	/* 909 */
	{16336, S_036004_PERF_SEL2(~0u)},
	{16346, S_036004_PERF_SEL3(~0u)},
	/* 911 */
	{16356, S_036008_PERF_SEL(~0u)},
	{16365, S_036008_PERF_SEL1(~0u)},
	{16375, S_036008_CNTR_MODE(~0u)},
	/* 914 */
	{16336, S_036010_PERF_SEL2(~0u)},
	{16346, S_036010_PERF_SEL3(~0u)},
	/* 916 */
	{16336, S_036018_PERF_SEL2(~0u)},
	{16346, S_036018_PERF_SEL3(~0u)},
	/* 918 */
	{16356, S_03601C_PERF_SEL(~0u)},
	{16365, S_03601C_PERF_SEL1(~0u)},
	{16375, S_03601C_CNTR_MODE(~0u)},
	/* 921 */
	{16432, S_036020_PERFMON_STATE(~0u), 3, 667},
	{16446, S_036020_SPM_PERFMON_STATE(~0u)},
	{16464, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{16484, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 925 */
	{16356, S_036024_PERF_SEL(~0u)},
	{16365, S_036024_PERF_SEL1(~0u)},
	{16375, S_036024_CNTR_MODE(~0u)},
	/* 928 */
	{16356, S_036100_PERF_SEL(~0u)},
	{16506, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16560, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16587, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16718, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16798, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{16824, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{16850, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{16904, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{16931, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{16957, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 947 */
	{16356, S_036108_PERF_SEL(~0u)},
	{16506, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 959 */
	{16356, S_03610C_PERF_SEL(~0u)},
	{16506, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 971 */
	{16356, S_036110_PERF_SEL(~0u)},
	{16506, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 983 */
	{16356, S_036114_PERF_SEL(~0u)},
	{16506, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 995 */
	{16356, S_036200_PERF_SEL(~0u)},
	{16983, S_036200_PERF_MODE(~0u)},
	/* 997 */
	{16356, S_036210_PERF_SEL(~0u)},
	{16365, S_036210_PERF_SEL1(~0u)},
	{16375, S_036210_CNTR_MODE(~0u)},
	{16993, S_036210_PERF_MODE1(~0u)},
	{16983, S_036210_PERF_MODE(~0u)},
	/* 1002 */
	{16336, S_036220_PERF_SEL2(~0u)},
	{16346, S_036220_PERF_SEL3(~0u)},
	{17004, S_036220_PERF_MODE3(~0u)},
	{17015, S_036220_PERF_MODE2(~0u)},
	/* 1006 */
	{16356, S_036230_PERF_SEL(~0u)},
	{16365, S_036230_PERF_SEL1(~0u)},
	{16375, S_036230_CNTR_MODE(~0u)},
	{16993, S_036230_PERF_MODE1(~0u)},
	{16983, S_036230_PERF_MODE(~0u)},
	/* 1011 */
	{16336, S_036240_PERF_SEL2(~0u)},
	{16346, S_036240_PERF_SEL3(~0u)},
	{17004, S_036240_PERF_MODE3(~0u)},
	{17015, S_036240_PERF_MODE2(~0u)},
	/* 1015 */
	{17026, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1016 */
	{16356, S_036400_PERF_SEL(~0u)},
	{16365, S_036400_PERF_SEL1(~0u)},
	{16375, S_036400_CNTR_MODE(~0u)},
	/* 1019 */
	{16336, S_036404_PERF_SEL2(~0u)},
	{16346, S_036404_PERF_SEL3(~0u)},
	/* 1021 */
	{16356, S_036500_PERF_SEL(~0u)},
	{16365, S_036500_PERF_SEL1(~0u)},
	{16375, S_036500_CNTR_MODE(~0u)},
	/* 1024 */
	{16336, S_036504_PERF_SEL2(~0u)},
	{16346, S_036504_PERF_SEL3(~0u)},
	/* 1026 */
	{16356, S_036600_PERF_SEL(~0u)},
	{16365, S_036600_PERF_SEL1(~0u)},
	{16375, S_036600_CNTR_MODE(~0u)},
	/* 1029 */
	{16336, S_036610_PERF_SEL2(~0u)},
	{16346, S_036610_PERF_SEL3(~0u)},
	/* 1031 */
	{17048, S_036628_BIN0_MIN(~0u)},
	{17057, S_036628_BIN0_MAX(~0u)},
	{17066, S_036628_BIN1_MIN(~0u)},
	{17075, S_036628_BIN1_MAX(~0u)},
	{17084, S_036628_BIN2_MIN(~0u)},
	{17093, S_036628_BIN2_MAX(~0u)},
	{17102, S_036628_BIN3_MIN(~0u)},
	{17111, S_036628_BIN3_MAX(~0u)},
	/* 1039 */
	{16356, S_036700_PERF_SEL(~0u)},
	{17120, S_036700_SQC_BANK_MASK(~0u)},
	{17134, S_036700_SQC_CLIENT_MASK(~0u)},
	{17150, S_036700_SPM_MODE(~0u)},
	{17159, S_036700_SIMD_MASK(~0u)},
	{16983, S_036700_PERF_MODE(~0u)},
	/* 1045 */
	{17169, S_036780_PS_EN(~0u)},
	{17175, S_036780_VS_EN(~0u)},
	{17181, S_036780_GS_EN(~0u)},
	{17187, S_036780_ES_EN(~0u)},
	{17193, S_036780_HS_EN(~0u)},
	{17199, S_036780_LS_EN(~0u)},
	{17205, S_036780_CS_EN(~0u)},
	{17211, S_036780_CNTR_RATE(~0u)},
	{17221, S_036780_DISABLE_FLUSH(~0u)},
	/* 1054 */
	{17235, S_036784_SH0_MASK(~0u)},
	{17244, S_036784_SH1_MASK(~0u)},
	/* 1056 */
	{17253, S_036788_FORCE_EN(~0u)},
	/* 1057 */
	{17262, S_036900_PERFCOUNTER_SELECT(~0u)},
	{17281, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{16375, S_036900_CNTR_MODE(~0u)},
	/* 1060 */
	{17301, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{17321, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1062 */
	{17262, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{17281, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{16375, S_036A00_CNTR_MODE(~0u)},
	/* 1065 */
	{17301, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{17321, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1067 */
	{16356, S_036B00_PERF_SEL(~0u)},
	{16365, S_036B00_PERF_SEL1(~0u)},
	{16375, S_036B00_CNTR_MODE(~0u)},
	{16993, S_036B00_PERF_MODE1(~0u)},
	{16983, S_036B00_PERF_MODE(~0u)},
	/* 1072 */
	{16336, S_036B04_PERF_SEL2(~0u)},
	{16346, S_036B04_PERF_SEL3(~0u)},
	{17004, S_036B04_PERF_MODE3(~0u)},
	{17015, S_036B04_PERF_MODE2(~0u)},
	/* 1076 */
	{16356, S_036C00_PERF_SEL(~0u)},
	{16365, S_036C00_PERF_SEL1(~0u)},
	{16375, S_036C00_CNTR_MODE(~0u)},
	{16993, S_036C00_PERF_MODE1(~0u)},
	{16983, S_036C00_PERF_MODE(~0u)},
	/* 1081 */
	{16336, S_036C04_PERF_SEL2(~0u)},
	{16346, S_036C04_PERF_SEL3(~0u)},
	{17004, S_036C04_PERF_MODE3(~0u)},
	{17015, S_036C04_PERF_MODE2(~0u)},
	/* 1085 */
	{16356, S_036D00_PERF_SEL(~0u)},
	{16365, S_036D00_PERF_SEL1(~0u)},
	{16375, S_036D00_CNTR_MODE(~0u)},
	{16993, S_036D00_PERF_MODE1(~0u)},
	{16983, S_036D00_PERF_MODE(~0u)},
	/* 1090 */
	{16336, S_036D04_PERF_SEL2(~0u)},
	{16346, S_036D04_PERF_SEL3(~0u)},
	{17004, S_036D04_PERF_MODE3(~0u)},
	{17015, S_036D04_PERF_MODE2(~0u)},
	/* 1094 */
	{16356, S_036E00_PERF_SEL(~0u)},
	{16365, S_036E00_PERF_SEL1(~0u)},
	{16375, S_036E00_CNTR_MODE(~0u)},
	{16993, S_036E00_PERF_MODE1(~0u)},
	{16983, S_036E00_PERF_MODE(~0u)},
	/* 1099 */
	{16336, S_036E04_PERF_SEL2(~0u)},
	{16346, S_036E04_PERF_SEL3(~0u)},
	{17015, S_036E04_PERF_MODE2(~0u)},
	{17004, S_036E04_PERF_MODE3(~0u)},
	/* 1103 */
	{16356, S_036E40_PERF_SEL(~0u)},
	{16365, S_036E40_PERF_SEL1(~0u)},
	{16375, S_036E40_CNTR_MODE(~0u)},
	{16993, S_036E40_PERF_MODE1(~0u)},
	{16983, S_036E40_PERF_MODE(~0u)},
	/* 1108 */
	{16336, S_036E44_PERF_SEL2(~0u)},
	{16346, S_036E44_PERF_SEL3(~0u)},
	{17015, S_036E44_PERF_MODE2(~0u)},
	{17004, S_036E44_PERF_MODE3(~0u)},
	/* 1112 */
	{17341, S_037000_OP_FILTER_ENABLE(~0u)},
	{17358, S_037000_OP_FILTER_SEL(~0u)},
	{17372, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{17393, S_037000_FORMAT_FILTER_SEL(~0u)},
	{17411, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{17431, S_037000_CLEAR_FILTER_SEL(~0u)},
	{17448, S_037000_MRT_FILTER_ENABLE(~0u)},
	{17466, S_037000_MRT_FILTER_SEL(~0u)},
	{17481, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{17507, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{17530, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{17558, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1124 */
	{16356, S_037004_PERF_SEL(~0u)},
	{16365, S_037004_PERF_SEL1(~0u)},
	{16375, S_037004_CNTR_MODE(~0u)},
	{16993, S_037004_PERF_MODE1(~0u)},
	{16983, S_037004_PERF_MODE(~0u)},
	/* 1129 */
	{16336, S_037008_PERF_SEL2(~0u)},
	{16346, S_037008_PERF_SEL3(~0u)},
	{17004, S_037008_PERF_MODE3(~0u)},
	{17015, S_037008_PERF_MODE2(~0u)},
	/* 1133 */
	{16356, S_037100_PERF_SEL(~0u)},
	{16365, S_037100_PERF_SEL1(~0u)},
	{16375, S_037100_CNTR_MODE(~0u)},
	{16993, S_037100_PERF_MODE1(~0u)},
	{16983, S_037100_PERF_MODE(~0u)},
	/* 1138 */
	{16336, S_037104_PERF_SEL2(~0u)},
	{16346, S_037104_PERF_SEL3(~0u)},
	{17004, S_037104_PERF_MODE3(~0u)},
	{17015, S_037104_PERF_MODE2(~0u)},
	/* 1142 */
	{17583, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{17602, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{17623, S_028000_DEPTH_COPY(~0u)},
	{17634, S_028000_STENCIL_COPY(~0u)},
	{17647, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{17666, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{17691, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{17714, S_028000_COPY_CENTROID(~0u)},
	{17728, S_028000_COPY_SAMPLE(~0u)},
	{17740, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1152 */
	{17758, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{17782, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{17803, S_028004_SAMPLE_RATE(~0u)},
	{17815, S_028004_ZPASS_ENABLE(~0u)},
	{17828, S_028004_ZFAIL_ENABLE(~0u)},
	{17841, S_028004_SFAIL_ENABLE(~0u)},
	{17854, S_028004_DBFAIL_ENABLE(~0u)},
	{17868, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{17886, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1161 */
	{17903, S_028008_SLICE_START(~0u)},
	{17915, S_028008_SLICE_MAX(~0u)},
	{17925, S_028008_Z_READ_ONLY(~0u)},
	{17937, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1165 */
	{18007, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 670},
	{18024, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 670},
	{18042, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 670},
	{18060, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{18081, S_02800C_FAST_Z_DISABLE(~0u)},
	{18096, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{18117, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{18135, S_02800C_FORCE_COLOR_KILL(~0u)},
	{18152, S_02800C_FORCE_Z_READ(~0u)},
	{18165, S_02800C_FORCE_STENCIL_READ(~0u)},
	{18184, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 670},
	{18203, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{18227, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{18250, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{18267, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{18352, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 674},
	{18371, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{18388, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{18412, S_02800C_FORCE_Z_DIRTY(~0u)},
	{18426, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{18446, S_02800C_FORCE_Z_VALID(~0u)},
	{18460, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{18480, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1188 */
	{18554, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{18583, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{18614, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{18650, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{18685, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{18713, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{18735, S_028010_DISABLE_REG_SNOOP(~0u)},
	{18753, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{18785, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{18811, S_028010_HIZ_ZFUNC(~0u)},
	{18821, S_028010_HIS_SFUNC_FF(~0u)},
	{18834, S_028010_HIS_SFUNC_BF(~0u)},
	{18847, S_028010_PRESERVE_ZRANGE(~0u)},
	{18863, S_028010_PRESERVE_SRESULTS(~0u)},
	{18881, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1203 */
	{18899, S_028028_CLEAR(~0u)},
	/* 1204 */
	{18905, S_028030_TL_X(~0u)},
	{18910, S_028030_TL_Y(~0u)},
	/* 1206 */
	{18915, S_028034_BR_X(~0u)},
	{18920, S_028034_BR_Y(~0u)},
	/* 1208 */
	{18925, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{14341, S_02803C_ARRAY_MODE(~0u), 7, 682},
	{14703, S_02803C_PIPE_CONFIG(~0u), 18, 689},
	{14996, S_02803C_BANK_WIDTH(~0u), 4, 406},
	{15103, S_02803C_BANK_HEIGHT(~0u), 4, 410},
	{15215, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15302, S_02803C_NUM_BANKS(~0u), 4, 418},
	/* 1215 */
	{8750, S_028040_FORMAT(~0u), 4, 707},
	{19077, S_028040_NUM_SAMPLES(~0u)},
	{14893, S_028040_TILE_SPLIT(~0u), 7, 399},
	{19089, S_028040_TILE_MODE_INDEX(~0u)},
	{19105, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{19129, S_028040_ALLOW_EXPCLEAR(~0u)},
	{19144, S_028040_READ_SIZE(~0u)},
	{19154, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{19174, S_028040_CLEAR_DISALLOWED(~0u)},
	{19191, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1225 */
	{8750, S_028044_FORMAT(~0u), 2, 711},
	{14893, S_028044_TILE_SPLIT(~0u), 7, 399},
	{19089, S_028044_TILE_MODE_INDEX(~0u)},
	{19129, S_028044_ALLOW_EXPCLEAR(~0u)},
	{19234, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{19174, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1231 */
	{19255, S_028058_PITCH_TILE_MAX(~0u)},
	{19270, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1233 */
	{19286, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1234 */
	{8373, S_028084_ADDRESS(~0u)},
	/* 1235 */
	{19301, S_028200_WINDOW_X_OFFSET(~0u)},
	{19317, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1237 */
	{18905, S_028204_TL_X(~0u)},
	{18910, S_028204_TL_Y(~0u)},
	{19333, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1240 */
	{18915, S_028208_BR_X(~0u)},
	{18920, S_028208_BR_Y(~0u)},
	/* 1242 */
	{19355, S_02820C_CLIP_RULE(~0u)},
	/* 1243 */
	{18905, S_028210_TL_X(~0u)},
	{18910, S_028210_TL_Y(~0u)},
	/* 1245 */
	{18915, S_028214_BR_X(~0u)},
	{18920, S_028214_BR_Y(~0u)},
	/* 1247 */
	{19365, S_028230_ER_TRI(~0u)},
	{12448, S_028230_ER_POINT(~0u)},
	{19372, S_028230_ER_RECT(~0u)},
	{19380, S_028230_ER_LINE_LR(~0u)},
	{19391, S_028230_ER_LINE_RL(~0u)},
	{19402, S_028230_ER_LINE_TB(~0u)},
	{19413, S_028230_ER_LINE_BT(~0u)},
	/* 1254 */
	{19424, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{19443, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1256 */
	{19462, S_028238_TARGET0_ENABLE(~0u)},
	{19477, S_028238_TARGET1_ENABLE(~0u)},
	{19492, S_028238_TARGET2_ENABLE(~0u)},
	{19507, S_028238_TARGET3_ENABLE(~0u)},
	{19522, S_028238_TARGET4_ENABLE(~0u)},
	{19537, S_028238_TARGET5_ENABLE(~0u)},
	{19552, S_028238_TARGET6_ENABLE(~0u)},
	{19567, S_028238_TARGET7_ENABLE(~0u)},
	/* 1264 */
	{19582, S_02823C_OUTPUT0_ENABLE(~0u)},
	{19597, S_02823C_OUTPUT1_ENABLE(~0u)},
	{19612, S_02823C_OUTPUT2_ENABLE(~0u)},
	{19627, S_02823C_OUTPUT3_ENABLE(~0u)},
	{19642, S_02823C_OUTPUT4_ENABLE(~0u)},
	{19657, S_02823C_OUTPUT5_ENABLE(~0u)},
	{19672, S_02823C_OUTPUT6_ENABLE(~0u)},
	{19687, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1272 */
	{18905, S_028240_TL_X(~0u)},
	{18910, S_028240_TL_Y(~0u)},
	{19333, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1275 */
	{18915, S_028244_BR_X(~0u)},
	{18920, S_028244_BR_Y(~0u)},
	/* 1277 */
	{18905, S_028250_TL_X(~0u)},
	{18910, S_028250_TL_Y(~0u)},
	{19333, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1280 */
	{18915, S_028254_BR_X(~0u)},
	{18920, S_028254_BR_Y(~0u)},
	/* 1282 */
	{19794, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{19806, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{19918, S_028350_RB_XSEL2(~0u), 4, 717},
	{19927, S_028350_RB_XSEL(~0u)},
	{19935, S_028350_RB_YSEL(~0u)},
	{20039, S_028350_PKR_MAP(~0u), 4, 721},
	{20147, S_028350_PKR_XSEL(~0u), 4, 725},
	{20256, S_028350_PKR_YSEL(~0u), 4, 729},
	{20369, S_028350_PKR_XSEL2(~0u), 4, 733},
	{20471, S_028350_SC_MAP(~0u), 4, 737},
	{20617, S_028350_SC_XSEL(~0u), 4, 741},
	{20764, S_028350_SC_YSEL(~0u), 4, 745},
	{20864, S_028350_SE_MAP(~0u), 4, 749},
	{21010, S_028350_SE_XSEL(~0u), 4, 753},
	{21157, S_028350_SE_YSEL(~0u), 4, 757},
	/* 1297 */
	{21277, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{21448, S_028354_SE_PAIR_XSEL(~0u), 4, 765},
	{21620, S_028354_SE_PAIR_YSEL(~0u), 4, 769},
	/* 1300 */
	{17868, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{17886, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1302 */
	{21633, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{21660, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{21699, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1305 */
	{21965, S_02842C_STENCILFAIL(~0u), 16, 773},
	{21977, S_02842C_STENCILZPASS(~0u), 16, 773},
	{21990, S_02842C_STENCILZFAIL(~0u), 16, 773},
	{22003, S_02842C_STENCILFAIL_BF(~0u), 16, 773},
	{22018, S_02842C_STENCILZPASS_BF(~0u), 16, 773},
	{22034, S_02842C_STENCILZFAIL_BF(~0u), 16, 773},
	/* 1311 */
	{22050, S_028430_STENCILTESTVAL(~0u)},
	{22065, S_028430_STENCILMASK(~0u)},
	{22077, S_028430_STENCILWRITEMASK(~0u)},
	{22094, S_028430_STENCILOPVAL(~0u)},
	/* 1315 */
	{22107, S_028434_STENCILTESTVAL_BF(~0u)},
	{22125, S_028434_STENCILMASK_BF(~0u)},
	{22140, S_028434_STENCILWRITEMASK_BF(~0u)},
	{22160, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1319 */
	{665, S_028644_OFFSET(~0u)},
	{22183, S_028644_DEFAULT_VAL(~0u), 1, 789},
	{22195, S_028644_FLAT_SHADE(~0u)},
	{22206, S_028644_CYL_WRAP(~0u)},
	{22215, S_028644_PT_SPRITE_TEX(~0u)},
	{22229, S_028644_DUP(~0u)},
	{22233, S_028644_FP16_INTERP_MODE(~0u)},
	{22250, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{22268, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{22286, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{22306, S_028644_ATTR0_VALID(~0u)},
	{22318, S_028644_ATTR1_VALID(~0u)},
	/* 1331 */
	{22330, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{22346, S_0286C4_VS_HALF_PACK(~0u)},
	{22359, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{22374, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1335 */
	{22394, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{22411, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{22428, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{22447, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{22468, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{22486, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{22504, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{22524, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{22545, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{22561, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{22577, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{22593, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{22609, S_0286CC_FRONT_FACE_ENA(~0u)},
	{22624, S_0286CC_ANCILLARY_ENA(~0u)},
	{22638, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{22658, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1351 */
	{22394, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{22411, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{22428, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{22447, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{22468, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{22486, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{22504, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{22524, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{22545, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{22561, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{22577, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{22593, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{22609, S_0286D0_FRONT_FACE_ENA(~0u)},
	{22624, S_0286D0_ANCILLARY_ENA(~0u)},
	{22638, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{22658, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1367 */
	{22675, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{22690, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{22813, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 790},
	{22831, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 790},
	{22849, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 790},
	{22867, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 790},
	{22885, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1374 */
	{22902, S_0286D8_NUM_INTERP(~0u)},
	{22913, S_0286D8_PARAM_GEN(~0u)},
	{22923, S_0286D8_FOG_ADDR(~0u)},
	{22932, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{22952, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1379 */
	{22972, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{22990, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{23010, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{23029, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{23099, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 795},
	{23118, S_0286E0_POS_FLOAT_ULC(~0u)},
	{23132, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1386 */
	{16237, S_0286E8_WAVES(~0u)},
	{16243, S_0286E8_WAVESIZE(~0u)},
	/* 1388 */
	{23152, S_028704_NUM_PS_WAVES(~0u)},
	{23165, S_028704_NUM_VS_WAVES(~0u)},
	{23178, S_028704_NUM_GS_WAVES(~0u)},
	{23191, S_028704_NUM_ES_WAVES(~0u)},
	{23204, S_028704_NUM_HS_WAVES(~0u)},
	/* 1393 */
	{23217, S_028708_NUM_LS_WAVES(~0u)},
	/* 1394 */
	{23318, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 796},
	{23337, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 796},
	{23356, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 796},
	{23375, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 796},
	/* 1398 */
	{23594, S_028710_Z_EXPORT_FORMAT(~0u), 10, 801},
	/* 1399 */
	{23610, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 801},
	{23629, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 801},
	{23648, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 801},
	{23667, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 801},
	{23686, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 801},
	{23705, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 801},
	{23724, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 801},
	{23743, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 801},
	/* 1407 */
	{23997, S_028754_MRT0(~0u), 11, 811},
	{24002, S_028754_MRT1(~0u)},
	{24007, S_028754_MRT2(~0u)},
	{24012, S_028754_MRT3(~0u)},
	{24017, S_028754_MRT4(~0u)},
	{24022, S_028754_MRT5(~0u)},
	{24027, S_028754_MRT6(~0u)},
	{24032, S_028754_MRT7(~0u)},
	/* 1415 */
	{24117, S_028758_MRT0_EPSILON(~0u), 16, 822},
	{24130, S_028758_MRT1_EPSILON(~0u)},
	{24143, S_028758_MRT2_EPSILON(~0u)},
	{24156, S_028758_MRT3_EPSILON(~0u)},
	{24169, S_028758_MRT4_EPSILON(~0u)},
	{24182, S_028758_MRT5_EPSILON(~0u)},
	{24195, S_028758_MRT6_EPSILON(~0u)},
	{24208, S_028758_MRT7_EPSILON(~0u)},
	/* 1423 */
	{24221, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{24244, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{24267, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{24290, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{24313, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{24336, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{24359, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{24382, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{24405, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{24428, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{24451, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{24474, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{24497, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{24520, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{24543, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{24566, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{24589, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1440 */
	{24880, S_028760_COLOR_SRC_OPT(~0u), 8, 838},
	{24894, S_028760_COLOR_DST_OPT(~0u)},
	{25042, S_028760_COLOR_COMB_FCN(~0u), 8, 846},
	{25057, S_028760_ALPHA_SRC_OPT(~0u)},
	{25071, S_028760_ALPHA_DST_OPT(~0u)},
	{25085, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1446 */
	{24880, S_028764_COLOR_SRC_OPT(~0u)},
	{24894, S_028764_COLOR_DST_OPT(~0u)},
	{25042, S_028764_COLOR_COMB_FCN(~0u)},
	{25057, S_028764_ALPHA_SRC_OPT(~0u)},
	{25071, S_028764_ALPHA_DST_OPT(~0u)},
	{25085, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1452 */
	{24880, S_028768_COLOR_SRC_OPT(~0u)},
	{24894, S_028768_COLOR_DST_OPT(~0u)},
	{25042, S_028768_COLOR_COMB_FCN(~0u)},
	{25057, S_028768_ALPHA_SRC_OPT(~0u)},
	{25071, S_028768_ALPHA_DST_OPT(~0u)},
	{25085, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1458 */
	{24880, S_02876C_COLOR_SRC_OPT(~0u)},
	{24894, S_02876C_COLOR_DST_OPT(~0u)},
	{25042, S_02876C_COLOR_COMB_FCN(~0u)},
	{25057, S_02876C_ALPHA_SRC_OPT(~0u)},
	{25071, S_02876C_ALPHA_DST_OPT(~0u)},
	{25085, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1464 */
	{24880, S_028770_COLOR_SRC_OPT(~0u)},
	{24894, S_028770_COLOR_DST_OPT(~0u)},
	{25042, S_028770_COLOR_COMB_FCN(~0u)},
	{25057, S_028770_ALPHA_SRC_OPT(~0u)},
	{25071, S_028770_ALPHA_DST_OPT(~0u)},
	{25085, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1470 */
	{24880, S_028774_COLOR_SRC_OPT(~0u)},
	{24894, S_028774_COLOR_DST_OPT(~0u)},
	{25042, S_028774_COLOR_COMB_FCN(~0u)},
	{25057, S_028774_ALPHA_SRC_OPT(~0u)},
	{25071, S_028774_ALPHA_DST_OPT(~0u)},
	{25085, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1476 */
	{24880, S_028778_COLOR_SRC_OPT(~0u)},
	{24894, S_028778_COLOR_DST_OPT(~0u)},
	{25042, S_028778_COLOR_COMB_FCN(~0u)},
	{25057, S_028778_ALPHA_SRC_OPT(~0u)},
	{25071, S_028778_ALPHA_DST_OPT(~0u)},
	{25085, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1482 */
	{24880, S_02877C_COLOR_SRC_OPT(~0u)},
	{24894, S_02877C_COLOR_DST_OPT(~0u)},
	{25042, S_02877C_COLOR_COMB_FCN(~0u)},
	{25057, S_02877C_ALPHA_SRC_OPT(~0u)},
	{25071, S_02877C_ALPHA_DST_OPT(~0u)},
	{25085, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1488 */
	{25494, S_028780_COLOR_SRCBLEND(~0u), 21, 854},
	{25042, S_028780_COLOR_COMB_FCN(~0u), 5, 875},
	{25599, S_028780_COLOR_DESTBLEND(~0u), 21, 854},
	{25615, S_028780_ALPHA_SRCBLEND(~0u), 21, 854},
	{25085, S_028780_ALPHA_COMB_FCN(~0u), 5, 875},
	{25630, S_028780_ALPHA_DESTBLEND(~0u), 21, 854},
	{25646, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{8435, S_028780_ENABLE(~0u)},
	{25667, S_028780_DISABLE_ROP3(~0u)},
	/* 1497 */
	{25680, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1498 */
	{25693, S_0287E4_BASE_ADDR(~0u)},
	/* 1499 */
	{25781, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{25827, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{25838, S_0287F0_NOT_EOP(~0u)},
	{25846, S_0287F0_USE_OPAQUE(~0u)},
	/* 1503 */
	{25857, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1504 */
	{25869, S_028800_STENCIL_ENABLE(~0u)},
	{18015, S_028800_Z_ENABLE(~0u)},
	{25884, S_028800_Z_WRITE_ENABLE(~0u)},
	{25899, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{18815, S_028800_ZFUNC(~0u), 8, 886},
	{26014, S_028800_BACKFACE_ENABLE(~0u)},
	{26117, S_028800_STENCILFUNC(~0u), 8, 894},
	{26129, S_028800_STENCILFUNC_BF(~0u), 8, 894},
	{26144, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{26178, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1514 */
	{26213, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{26232, S_028804_PS_ITER_SAMPLES(~0u)},
	{26248, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{26272, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{26298, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{26325, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{26347, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{26366, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{26384, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{26411, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{26438, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{26463, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1526 */
	{26494, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{26512, S_028808_DEGAMMA_ENABLE(~0u)},
	{12371, S_028808_MODE(~0u), 7, 902},
	{25675, S_028808_ROP3(~0u), 256, 909},
	/* 1530 */
	{26817, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{26833, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{26864, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{18073, S_02880C_Z_ORDER(~0u), 4, 1165},
	{26943, S_02880C_KILL_ENABLE(~0u)},
	{26955, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{26979, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{26998, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{27016, S_02880C_EXEC_ON_NOOP(~0u)},
	{27029, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{27051, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{27141, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{27163, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1543 */
	{27181, S_028810_UCP_ENA_0(~0u)},
	{27191, S_028810_UCP_ENA_1(~0u)},
	{27201, S_028810_UCP_ENA_2(~0u)},
	{27211, S_028810_UCP_ENA_3(~0u)},
	{27221, S_028810_UCP_ENA_4(~0u)},
	{27231, S_028810_UCP_ENA_5(~0u)},
	{27241, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{27260, S_028810_PS_UCP_MODE(~0u)},
	{27272, S_028810_CLIP_DISABLE(~0u)},
	{27285, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{27303, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{27326, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{27344, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{27364, S_028810_VTX_KILL_OR(~0u)},
	{27376, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{27398, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{27422, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{27448, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{27467, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1562 */
	{27485, S_028814_CULL_FRONT(~0u)},
	{27496, S_028814_CULL_BACK(~0u)},
	{27506, S_028814_FACE(~0u)},
	{27521, S_028814_POLY_MODE(~0u), 2, 1173},
	{27587, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{27608, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{27628, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{27653, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{27677, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{27701, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{27726, S_028814_PROVOKING_VTX_LAST(~0u)},
	{27745, S_028814_PERSP_CORR_DIS(~0u)},
	{27760, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1575 */
	{27778, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{27796, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{27815, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{27833, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{27852, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{27870, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{27889, S_028818_VTX_XY_FMT(~0u)},
	{27900, S_028818_VTX_Z_FMT(~0u)},
	{27910, S_028818_VTX_W0_FMT(~0u)},
	/* 1584 */
	{27921, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{27937, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{27953, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{27969, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{27985, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{28001, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{28017, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{28033, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{28049, S_02881C_CULL_DIST_ENA_0(~0u)},
	{28065, S_02881C_CULL_DIST_ENA_1(~0u)},
	{28081, S_02881C_CULL_DIST_ENA_2(~0u)},
	{28097, S_02881C_CULL_DIST_ENA_3(~0u)},
	{28113, S_02881C_CULL_DIST_ENA_4(~0u)},
	{28129, S_02881C_CULL_DIST_ENA_5(~0u)},
	{28145, S_02881C_CULL_DIST_ENA_6(~0u)},
	{28161, S_02881C_CULL_DIST_ENA_7(~0u)},
	{28177, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{28196, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{28214, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{28241, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{28263, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{28281, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{28301, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{28324, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{28347, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{28372, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{28392, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1611 */
	{28411, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{28430, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{28448, S_028820_VTE_W_INF_DISCARD(~0u)},
	{28466, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{28484, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{28502, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{28519, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{28536, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{28557, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{28574, S_028820_VS_XY_INF_RETAIN(~0u)},
	{28591, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{28607, S_028820_VS_Z_INF_RETAIN(~0u)},
	{28623, S_028820_VS_W_NAN_TO_INF(~0u)},
	{28639, S_028820_VS_W_INF_RETAIN(~0u)},
	{28655, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{28680, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1627 */
	{28700, S_028824_LINE_STIPPLE_RESET(~0u)},
	{28719, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{28738, S_028824_FRACTIONAL_ACCUM(~0u)},
	{28755, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1631 */
	{28770, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{28794, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{28814, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{28835, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{28860, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{28880, S_02882C_LINE_EXPAND_ENA(~0u)},
	{28896, S_02882C_POINT_EXPAND_ENA(~0u)},
	{28913, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{28934, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{28955, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{28976, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1642 */
	{28998, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{28770, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{28794, S_028830_LINE_FILTER_DISABLE(~0u)},
	{28814, S_028830_POINT_FILTER_DISABLE(~0u)},
	{28835, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1647 */
	{11283, S_028A00_HEIGHT(~0u)},
	{11277, S_028A00_WIDTH(~0u)},
	/* 1649 */
	{29023, S_028A04_MIN_SIZE(~0u)},
	{29032, S_028A04_MAX_SIZE(~0u)},
	/* 1651 */
	{11277, S_028A08_WIDTH(~0u)},
	/* 1652 */
	{29041, S_028A0C_LINE_PATTERN(~0u)},
	{29054, S_028A0C_REPEAT_COUNT(~0u)},
	{29067, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{29085, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1656 */
	{29206, S_028A10_PATH_SELECT(~0u), 5, 1178},
	/* 1657 */
	{29218, S_028A14_TESS_MODE(~0u)},
	/* 1658 */
	{29228, S_028A20_REUSE_DEPTH(~0u)},
	/* 1659 */
	{5900, S_028A24_PRIM_TYPE(~0u), 18, 1183},
	{29595, S_028A24_RETAIN_ORDER(~0u)},
	{29608, S_028A24_RETAIN_QUADS(~0u)},
	{29689, S_028A24_PRIM_ORDER(~0u), 5, 1201},
	/* 1663 */
	{29700, S_028A28_FIRST_DECR(~0u)},
	/* 1664 */
	{29706, S_028A2C_DECR(~0u)},
	/* 1665 */
	{29711, S_028A30_COMP_X_EN(~0u)},
	{29721, S_028A30_COMP_Y_EN(~0u)},
	{29731, S_028A30_COMP_Z_EN(~0u)},
	{29741, S_028A30_COMP_W_EN(~0u)},
	{8406, S_028A30_STRIDE(~0u)},
	{29751, S_028A30_SHIFT(~0u)},
	/* 1671 */
	{29711, S_028A34_COMP_X_EN(~0u)},
	{29721, S_028A34_COMP_Y_EN(~0u)},
	{29731, S_028A34_COMP_Z_EN(~0u)},
	{29741, S_028A34_COMP_W_EN(~0u)},
	{8406, S_028A34_STRIDE(~0u)},
	{29751, S_028A34_SHIFT(~0u)},
	/* 1677 */
	{29916, S_028A38_X_CONV(~0u), 9, 1206},
	{19308, S_028A38_X_OFFSET(~0u)},
	{29923, S_028A38_Y_CONV(~0u), 9, 1206},
	{19324, S_028A38_Y_OFFSET(~0u)},
	{29930, S_028A38_Z_CONV(~0u), 9, 1206},
	{29937, S_028A38_Z_OFFSET(~0u)},
	{29946, S_028A38_W_CONV(~0u), 9, 1206},
	{29953, S_028A38_W_OFFSET(~0u)},
	/* 1685 */
	{29916, S_028A3C_X_CONV(~0u), 9, 1206},
	{19308, S_028A3C_X_OFFSET(~0u)},
	{29923, S_028A3C_Y_CONV(~0u), 9, 1206},
	{19324, S_028A3C_Y_OFFSET(~0u)},
	{29930, S_028A3C_Z_CONV(~0u), 9, 1206},
	{29937, S_028A3C_Z_OFFSET(~0u)},
	{29946, S_028A3C_W_CONV(~0u), 9, 1206},
	{29953, S_028A3C_W_OFFSET(~0u)},
	/* 1693 */
	{12371, S_028A40_MODE(~0u), 6, 1215},
	{8467, S_028A40_RESERVED_0(~0u)},
	{30080, S_028A40_CUT_MODE(~0u), 4, 1221},
	{8485, S_028A40_RESERVED_1(~0u)},
	{30089, S_028A40_GS_C_PACK_EN(~0u)},
	{30102, S_028A40_RESERVED_2(~0u)},
	{30113, S_028A40_ES_PASSTHRU(~0u)},
	{30125, S_028A40_COMPUTE_MODE(~0u)},
	{30138, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{30156, S_028A40_ELEMENT_INFO_EN(~0u)},
	{30172, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{30191, S_028A40_SUPPRESS_CUTS(~0u)},
	{30205, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{30223, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{30274, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 1708 */
	{30281, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{30301, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1710 */
	{30321, S_028A48_MSAA_ENABLE(~0u)},
	{30333, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{30354, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{30374, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1714 */
	{30399, S_028A4C_WALK_SIZE(~0u)},
	{30409, S_028A4C_WALK_ALIGNMENT(~0u)},
	{30424, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{30449, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{30467, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{30483, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{30488, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{30511, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{30530, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{30552, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{30568, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{30584, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{30600, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{30619, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{30645, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{30660, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{30700, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{30727, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{30750, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{30766, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{30796, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{30820, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{30841, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{30871, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1738 */
	{30895, S_028A54_GS_PER_ES(~0u)},
	/* 1739 */
	{30905, S_028A58_ES_PER_GS(~0u)},
	/* 1740 */
	{30915, S_028A5C_GS_PER_VS(~0u)},
	/* 1741 */
	{665, S_028A60_OFFSET(~0u)},
	/* 1742 */
	{665, S_028A64_OFFSET(~0u)},
	/* 1743 */
	{665, S_028A68_OFFSET(~0u)},
	/* 1744 */
	{30993, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1229},
	{31006, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{31021, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{31036, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{31051, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1749 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{31188, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{31249, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{31291, S_028A7C_RDREQ_POLICY(~0u), 2, 1242},
	{31304, S_028A7C_RDREQ_POLICY_VI(~0u)},
	{9191, S_028A7C_ATC(~0u)},
	{25838, S_028A7C_NOT_EOP(~0u)},
	{31320, S_028A7C_REQ_PATH(~0u)},
	{9212, S_028A7C_MTYPE(~0u)},
	/* 1758 */
	{31329, S_028A84_PRIMITIVEID_EN(~0u)},
	{31344, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1760 */
	{32300, S_028A90_EVENT_TYPE(~0u), 65, 1244},
	{8395, S_028A90_ADDRESS_HI(~0u)},
	{32311, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1763 */
	{32326, S_028A94_RESET_EN(~0u)},
	/* 1764 */
	{32335, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{32350, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{32369, S_028AA8_SWITCH_ON_EOP(~0u)},
	{32383, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{32402, S_028AA8_SWITCH_ON_EOI(~0u)},
	{32416, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{32433, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1771 */
	{32453, S_028AAC_ITEMSIZE(~0u)},
	/* 1772 */
	{32453, S_028AB0_ITEMSIZE(~0u)},
	/* 1773 */
	{32462, S_028AB4_REUSE_OFF(~0u)},
	/* 1774 */
	{32472, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1775 */
	{12476, S_028ABC_LINEAR(~0u)},
	{32483, S_028ABC_FULL_CACHE(~0u)},
	{32494, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{32517, S_028ABC_PRELOAD(~0u)},
	{32525, S_028ABC_PREFETCH_WIDTH(~0u)},
	{32540, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{32556, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{32580, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1783 */
	{32594, S_028AC0_COMPAREFUNC0(~0u), 8, 894},
	{32607, S_028AC0_COMPAREVALUE0(~0u)},
	{32621, S_028AC0_COMPAREMASK0(~0u)},
	{18034, S_028AC0_ENABLE0(~0u)},
	/* 1787 */
	{32634, S_028AC4_COMPAREFUNC1(~0u), 8, 894},
	{32647, S_028AC4_COMPAREVALUE1(~0u)},
	{32661, S_028AC4_COMPAREMASK1(~0u)},
	{18052, S_028AC4_ENABLE1(~0u)},
	/* 1791 */
	{32674, S_028AC8_START_X(~0u)},
	{32682, S_028AC8_START_Y(~0u)},
	{32690, S_028AC8_MAX_X(~0u)},
	{32696, S_028AC8_MAX_Y(~0u)},
	/* 1795 */
	{8406, S_028AD4_STRIDE(~0u)},
	/* 1796 */
	{8406, S_028AE4_STRIDE(~0u)},
	/* 1797 */
	{8406, S_028AF4_STRIDE(~0u)},
	/* 1798 */
	{8406, S_028B04_STRIDE(~0u)},
	/* 1799 */
	{32702, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1800 */
	{32716, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1801 */
	{32729, S_028B50_ACCUM_ISOLINE(~0u)},
	{32743, S_028B50_ACCUM_TRI(~0u)},
	{32753, S_028B50_ACCUM_QUAD(~0u)},
	{32764, S_028B50_DONUT_SPLIT(~0u)},
	/* 1805 */
	{17199, S_028B54_LS_EN(~0u), 3, 1309},
	{17193, S_028B54_HS_EN(~0u)},
	{17187, S_028B54_ES_EN(~0u), 3, 1312},
	{17181, S_028B54_GS_EN(~0u)},
	{17175, S_028B54_VS_EN(~0u), 3, 1315},
	{32899, S_028B54_DYNAMIC_HS(~0u)},
	{15730, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{32910, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{32930, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{32950, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1815 */
	{32964, S_028B58_NUM_PATCHES(~0u)},
	{32976, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{32992, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1818 */
	{32453, S_028B5C_ITEMSIZE(~0u)},
	/* 1819 */
	{32453, S_028B60_ITEMSIZE(~0u)},
	/* 1820 */
	{32453, S_028B64_ITEMSIZE(~0u)},
	/* 1821 */
	{32453, S_028B68_ITEMSIZE(~0u)},
	/* 1822 */
	{209, S_028B6C_TYPE(~0u), 3, 1318},
	{33098, S_028B6C_PARTITIONING(~0u), 4, 1321},
	{33175, S_028B6C_TOPOLOGY(~0u), 4, 1325},
	{33184, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{33204, S_028B6C_DEPRECATED(~0u)},
	{33215, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{33237, S_028B6C_DISABLE_DONUTS(~0u)},
	{31291, S_028B6C_RDREQ_POLICY(~0u), 3, 1329},
	{31304, S_028B6C_RDREQ_POLICY_VI(~0u)},
	{33347, S_028B6C_DISTRIBUTION_MODE(~0u), 3, 1332},
	{9212, S_028B6C_MTYPE(~0u)},
	/* 1833 */
	{33365, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{33386, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{33408, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{33430, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{33452, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{33474, S_028B70_OFFSET_ROUND(~0u)},
	/* 1839 */
	{33487, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{33515, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1841 */
	{8435, S_028B90_ENABLE(~0u)},
	{15646, S_028B90_CNT(~0u)},
	/* 1843 */
	{33543, S_028B94_STREAMOUT_0_EN(~0u)},
	{33558, S_028B94_STREAMOUT_1_EN(~0u)},
	{33573, S_028B94_STREAMOUT_2_EN(~0u)},
	{33588, S_028B94_STREAMOUT_3_EN(~0u)},
	{33603, S_028B94_RAST_STREAM(~0u)},
	{33615, S_028B94_RAST_STREAM_MASK(~0u)},
	{33632, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1850 */
	{33653, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{33672, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{33691, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{33710, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1854 */
	{33729, S_028BD4_DISTANCE_0(~0u)},
	{33740, S_028BD4_DISTANCE_1(~0u)},
	{33751, S_028BD4_DISTANCE_2(~0u)},
	{33762, S_028BD4_DISTANCE_3(~0u)},
	{33773, S_028BD4_DISTANCE_4(~0u)},
	{33784, S_028BD4_DISTANCE_5(~0u)},
	{33795, S_028BD4_DISTANCE_6(~0u)},
	{33806, S_028BD4_DISTANCE_7(~0u)},
	/* 1862 */
	{33817, S_028BD8_DISTANCE_8(~0u)},
	{33828, S_028BD8_DISTANCE_9(~0u)},
	{33839, S_028BD8_DISTANCE_10(~0u)},
	{33851, S_028BD8_DISTANCE_11(~0u)},
	{33863, S_028BD8_DISTANCE_12(~0u)},
	{33875, S_028BD8_DISTANCE_13(~0u)},
	{33887, S_028BD8_DISTANCE_14(~0u)},
	{33899, S_028BD8_DISTANCE_15(~0u)},
	/* 1870 */
	{33911, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{33929, S_028BDC_LAST_PIXEL(~0u)},
	{33940, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{33965, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1874 */
	{33987, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{34004, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{34026, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{34042, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{34063, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1879 */
	{34086, S_028BE4_PIX_CENTER(~0u)},
	{34147, S_028BE4_ROUND_MODE(~0u), 4, 1335},
	{34363, S_028BE4_QUANT_MODE(~0u), 8, 1339},
	/* 1882 */
	{34374, S_028BF8_S0_X(~0u)},
	{34379, S_028BF8_S0_Y(~0u)},
	{34384, S_028BF8_S1_X(~0u)},
	{34389, S_028BF8_S1_Y(~0u)},
	{34394, S_028BF8_S2_X(~0u)},
	{34399, S_028BF8_S2_Y(~0u)},
	{34404, S_028BF8_S3_X(~0u)},
	{34409, S_028BF8_S3_Y(~0u)},
	/* 1890 */
	{34414, S_028BFC_S4_X(~0u)},
	{34419, S_028BFC_S4_Y(~0u)},
	{34424, S_028BFC_S5_X(~0u)},
	{34429, S_028BFC_S5_Y(~0u)},
	{34434, S_028BFC_S6_X(~0u)},
	{34439, S_028BFC_S6_Y(~0u)},
	{34444, S_028BFC_S7_X(~0u)},
	{34449, S_028BFC_S7_Y(~0u)},
	/* 1898 */
	{34454, S_028C00_S8_X(~0u)},
	{34459, S_028C00_S8_Y(~0u)},
	{34464, S_028C00_S9_X(~0u)},
	{34469, S_028C00_S9_Y(~0u)},
	{34474, S_028C00_S10_X(~0u)},
	{34480, S_028C00_S10_Y(~0u)},
	{34486, S_028C00_S11_X(~0u)},
	{34492, S_028C00_S11_Y(~0u)},
	/* 1906 */
	{34498, S_028C04_S12_X(~0u)},
	{34504, S_028C04_S12_Y(~0u)},
	{34510, S_028C04_S13_X(~0u)},
	{34516, S_028C04_S13_Y(~0u)},
	{34522, S_028C04_S14_X(~0u)},
	{34528, S_028C04_S14_Y(~0u)},
	{34534, S_028C04_S15_X(~0u)},
	{34540, S_028C04_S15_Y(~0u)},
	/* 1914 */
	{34374, S_028C08_S0_X(~0u)},
	{34379, S_028C08_S0_Y(~0u)},
	{34384, S_028C08_S1_X(~0u)},
	{34389, S_028C08_S1_Y(~0u)},
	{34394, S_028C08_S2_X(~0u)},
	{34399, S_028C08_S2_Y(~0u)},
	{34404, S_028C08_S3_X(~0u)},
	{34409, S_028C08_S3_Y(~0u)},
	/* 1922 */
	{34414, S_028C0C_S4_X(~0u)},
	{34419, S_028C0C_S4_Y(~0u)},
	{34424, S_028C0C_S5_X(~0u)},
	{34429, S_028C0C_S5_Y(~0u)},
	{34434, S_028C0C_S6_X(~0u)},
	{34439, S_028C0C_S6_Y(~0u)},
	{34444, S_028C0C_S7_X(~0u)},
	{34449, S_028C0C_S7_Y(~0u)},
	/* 1930 */
	{34454, S_028C10_S8_X(~0u)},
	{34459, S_028C10_S8_Y(~0u)},
	{34464, S_028C10_S9_X(~0u)},
	{34469, S_028C10_S9_Y(~0u)},
	{34474, S_028C10_S10_X(~0u)},
	{34480, S_028C10_S10_Y(~0u)},
	{34486, S_028C10_S11_X(~0u)},
	{34492, S_028C10_S11_Y(~0u)},
	/* 1938 */
	{34498, S_028C14_S12_X(~0u)},
	{34504, S_028C14_S12_Y(~0u)},
	{34510, S_028C14_S13_X(~0u)},
	{34516, S_028C14_S13_Y(~0u)},
	{34522, S_028C14_S14_X(~0u)},
	{34528, S_028C14_S14_Y(~0u)},
	{34534, S_028C14_S15_X(~0u)},
	{34540, S_028C14_S15_Y(~0u)},
	/* 1946 */
	{34374, S_028C18_S0_X(~0u)},
	{34379, S_028C18_S0_Y(~0u)},
	{34384, S_028C18_S1_X(~0u)},
	{34389, S_028C18_S1_Y(~0u)},
	{34394, S_028C18_S2_X(~0u)},
	{34399, S_028C18_S2_Y(~0u)},
	{34404, S_028C18_S3_X(~0u)},
	{34409, S_028C18_S3_Y(~0u)},
	/* 1954 */
	{34414, S_028C1C_S4_X(~0u)},
	{34419, S_028C1C_S4_Y(~0u)},
	{34424, S_028C1C_S5_X(~0u)},
	{34429, S_028C1C_S5_Y(~0u)},
	{34434, S_028C1C_S6_X(~0u)},
	{34439, S_028C1C_S6_Y(~0u)},
	{34444, S_028C1C_S7_X(~0u)},
	{34449, S_028C1C_S7_Y(~0u)},
	/* 1962 */
	{34454, S_028C20_S8_X(~0u)},
	{34459, S_028C20_S8_Y(~0u)},
	{34464, S_028C20_S9_X(~0u)},
	{34469, S_028C20_S9_Y(~0u)},
	{34474, S_028C20_S10_X(~0u)},
	{34480, S_028C20_S10_Y(~0u)},
	{34486, S_028C20_S11_X(~0u)},
	{34492, S_028C20_S11_Y(~0u)},
	/* 1970 */
	{34498, S_028C24_S12_X(~0u)},
	{34504, S_028C24_S12_Y(~0u)},
	{34510, S_028C24_S13_X(~0u)},
	{34516, S_028C24_S13_Y(~0u)},
	{34522, S_028C24_S14_X(~0u)},
	{34528, S_028C24_S14_Y(~0u)},
	{34534, S_028C24_S15_X(~0u)},
	{34540, S_028C24_S15_Y(~0u)},
	/* 1978 */
	{34374, S_028C28_S0_X(~0u)},
	{34379, S_028C28_S0_Y(~0u)},
	{34384, S_028C28_S1_X(~0u)},
	{34389, S_028C28_S1_Y(~0u)},
	{34394, S_028C28_S2_X(~0u)},
	{34399, S_028C28_S2_Y(~0u)},
	{34404, S_028C28_S3_X(~0u)},
	{34409, S_028C28_S3_Y(~0u)},
	/* 1986 */
	{34414, S_028C2C_S4_X(~0u)},
	{34419, S_028C2C_S4_Y(~0u)},
	{34424, S_028C2C_S5_X(~0u)},
	{34429, S_028C2C_S5_Y(~0u)},
	{34434, S_028C2C_S6_X(~0u)},
	{34439, S_028C2C_S6_Y(~0u)},
	{34444, S_028C2C_S7_X(~0u)},
	{34449, S_028C2C_S7_Y(~0u)},
	/* 1994 */
	{34454, S_028C30_S8_X(~0u)},
	{34459, S_028C30_S8_Y(~0u)},
	{34464, S_028C30_S9_X(~0u)},
	{34469, S_028C30_S9_Y(~0u)},
	{34474, S_028C30_S10_X(~0u)},
	{34480, S_028C30_S10_Y(~0u)},
	{34486, S_028C30_S11_X(~0u)},
	{34492, S_028C30_S11_Y(~0u)},
	/* 2002 */
	{34498, S_028C34_S12_X(~0u)},
	{34504, S_028C34_S12_Y(~0u)},
	{34510, S_028C34_S13_X(~0u)},
	{34516, S_028C34_S13_Y(~0u)},
	{34522, S_028C34_S14_X(~0u)},
	{34528, S_028C34_S14_Y(~0u)},
	{34534, S_028C34_S15_X(~0u)},
	{34540, S_028C34_S15_Y(~0u)},
	/* 2010 */
	{34546, S_028C38_AA_MASK_X0Y0(~0u)},
	{34559, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2012 */
	{34572, S_028C3C_AA_MASK_X0Y1(~0u)},
	{34585, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2014 */
	{34598, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2015 */
	{34627, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2016 */
	{34643, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2017 */
	{19261, S_028C64_TILE_MAX(~0u)},
	{34656, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2019 */
	{19261, S_028C68_TILE_MAX(~0u)},
	/* 2020 */
	{17903, S_028C6C_SLICE_START(~0u)},
	{17915, S_028C6C_SLICE_MAX(~0u)},
	/* 2022 */
	{34722, S_028C70_ENDIAN(~0u), 4, 1347},
	{8750, S_028C70_FORMAT(~0u), 23, 1351},
	{14118, S_028C70_LINEAR_GENERAL(~0u)},
	{35089, S_028C70_NUMBER_TYPE(~0u), 8, 1374},
	{35145, S_028C70_COMP_SWAP(~0u), 4, 1382},
	{26561, S_028C70_FAST_CLEAR(~0u)},
	{18489, S_028C70_COMPRESSION(~0u)},
	{35155, S_028C70_BLEND_CLAMP(~0u)},
	{35167, S_028C70_BLEND_BYPASS(~0u)},
	{35180, S_028C70_SIMPLE_FLOAT(~0u)},
	{34147, S_028C70_ROUND_MODE(~0u)},
	{35193, S_028C70_CMASK_IS_LINEAR(~0u)},
	{35420, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1386},
	{35442, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1386},
	{35466, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{35492, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{35518, S_028C70_DCC_ENABLE(~0u)},
	{35529, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2040 */
	{19089, S_028C74_TILE_MODE_INDEX(~0u)},
	{35545, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{35567, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{19077, S_028C74_NUM_SAMPLES(~0u)},
	{35585, S_028C74_NUM_FRAGMENTS(~0u)},
	{35599, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2046 */
	{21633, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{35617, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{35634, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{35662, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{35688, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{11765, S_028C78_COLOR_TRANSFORM(~0u)},
	{35714, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{35737, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{35757, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2055 */
	{19261, S_028C80_TILE_MAX(~0u)},
	/* 2056 */
	{19261, S_028C88_TILE_MAX(~0u)},
};

static const struct si_reg sid_reg_table[] = {
	{195, R_370_CONTROL, 4, 0},
	{1039, R_371_DST_ADDR_LO},
	{1051, R_372_DST_ADDR_HI},
	{35779, R_410_CP_DMA_WORD0, 1, 4},
	{35792, R_411_CP_DMA_WORD1, 5, 5},
	{35805, R_412_CP_DMA_WORD2, 1, 10},
	{35818, R_413_CP_DMA_WORD3, 1, 11},
	{35831, R_414_COMMAND, 9, 12},
	{35839, R_500_DMA_DATA_WORD0, 4, 21},
	{936, R_501_SRC_ADDR_LO},
	{1027, R_502_SRC_ADDR_HI},
	{1039, R_503_DST_ADDR_LO},
	{1051, R_504_DST_ADDR_HI},
	{35854, R_000E4C_SRBM_STATUS2, 21, 25},
	{35867, R_000E50_SRBM_STATUS, 20, 46},
	{35879, R_000E54_SRBM_STATUS3, 16, 66},
	{35892, R_00D034_SDMA0_STATUS_REG, 29, 82},
	{35909, R_00D834_SDMA1_STATUS_REG, 29, 82},
	{35926, R_008008_GRBM_STATUS2, 18, 111},
	{35939, R_008010_GRBM_STATUS, 24, 129},
	{35951, R_0084FC_CP_STRMOUT_CNTL, 1, 153},
	{35967, R_0085F0_CP_COHER_CNTL, 19, 154},
	{35981, R_0085F4_CP_COHER_SIZE},
	{35995, R_0085F8_CP_COHER_BASE},
	{36009, R_008014_GRBM_STATUS_SE0, 11, 173},
	{36025, R_008018_GRBM_STATUS_SE1, 11, 184},
	{36041, R_008038_GRBM_STATUS_SE2, 11, 195},
	{36057, R_00803C_GRBM_STATUS_SE3, 11, 206},
	{35951, R_0300FC_CP_STRMOUT_CNTL, 1, 217},
	{36073, R_0301E4_CP_COHER_BASE_HI, 1, 218},
	{36090, R_0301EC_CP_COHER_START_DELAY, 1, 219},
	{35967, R_0301F0_CP_COHER_CNTL, 27, 220},
	{35981, R_0301F4_CP_COHER_SIZE},
	{35995, R_0301F8_CP_COHER_BASE},
	{36111, R_0301FC_CP_COHER_STATUS, 4, 247},
	{36127, R_008210_CP_CPC_STATUS, 15, 251},
	{36141, R_008214_CP_CPC_BUSY_STAT, 28, 266},
	{36158, R_008218_CP_CPC_STALLED_STAT1, 14, 294},
	{36179, R_00821C_CP_CPF_STATUS, 21, 308},
	{36193, R_008220_CP_CPF_BUSY_STAT, 31, 329},
	{36210, R_008224_CP_CPF_STALLED_STAT1, 9, 360},
	{36231, R_030230_CP_COHER_SIZE_HI, 1, 369},
	{36248, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 370},
	{36271, R_0088C4_VGT_CACHE_INVALIDATION, 3, 371},
	{36294, R_0088C8_VGT_ESGS_RING_SIZE},
	{36313, R_0088CC_VGT_GSVS_RING_SIZE},
	{36332, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 374},
	{36352, R_008958_VGT_PRIMITIVE_TYPE, 1, 375},
	{36371, R_00895C_VGT_INDEX_TYPE, 1, 376},
	{36386, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36419, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36452, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36485, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36518, R_008970_VGT_NUM_INDICES},
	{36534, R_008974_VGT_NUM_INSTANCES},
	{36552, R_008988_VGT_TF_RING_SIZE, 1, 377},
	{36569, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 378},
	{36590, R_0089B8_VGT_TF_MEMORY_BASE},
	{36609, R_008A14_PA_CL_ENHANCE, 4, 379},
	{36623, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 383},
	{36648, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 384},
	{36673, R_008670_CP_STALLED_STAT3, 19, 386},
	{36690, R_008674_CP_STALLED_STAT1, 16, 405},
	{36707, R_008678_CP_STALLED_STAT2, 29, 421},
	{36724, R_008680_CP_STAT, 23, 450},
	{36732, R_030800_GRBM_GFX_INDEX, 6, 473},
	{36294, R_030900_VGT_ESGS_RING_SIZE},
	{36313, R_030904_VGT_GSVS_RING_SIZE},
	{36352, R_030908_VGT_PRIMITIVE_TYPE, 1, 479},
	{36371, R_03090C_VGT_INDEX_TYPE, 1, 480},
	{36386, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36419, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36452, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36485, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36518, R_030930_VGT_NUM_INDICES},
	{36534, R_030934_VGT_NUM_INSTANCES},
	{36552, R_030938_VGT_TF_RING_SIZE, 1, 481},
	{36569, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 482},
	{36590, R_030940_VGT_TF_MEMORY_BASE},
	{36623, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 484},
	{36648, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 485},
	{36747, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 487},
	{36773, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 489},
	{36799, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 491},
	{36825, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 493},
	{36851, R_008BF0_PA_SC_ENHANCE, 9, 495},
	{36865, R_008C08_SQC_CACHES, 2, 504},
	{36865, R_030D20_SQC_CACHES, 3, 506},
	{36876, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 509},
	{36895, R_008DFC_SQ_EXP_0, 6, 512},
	{36904, R_030E00_TA_CS_BC_BASE_ADDR},
	{36923, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 518},
	{36945, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{36969, R_008F00_SQ_BUF_RSRC_WORD0},
	{36987, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 519},
	{37010, R_008F04_SQ_BUF_RSRC_WORD1, 4, 520},
	{37028, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{37052, R_008F08_SQ_BUF_RSRC_WORD2},
	{37070, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 524},
	{37093, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 525},
	{37111, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{37135, R_008F10_SQ_IMG_RSRC_WORD0},
	{37153, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 539},
	{37176, R_008F14_SQ_IMG_RSRC_WORD1, 5, 540},
	{37194, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{37218, R_008F18_SQ_IMG_RSRC_WORD2, 4, 545},
	{37236, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 549},
	{37259, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 550},
	{37277, R_008F20_SQ_IMG_RSRC_WORD4, 2, 561},
	{37295, R_008F24_SQ_IMG_RSRC_WORD5, 2, 563},
	{37313, R_008F28_SQ_IMG_RSRC_WORD6, 8, 565},
	{37331, R_008F2C_SQ_IMG_RSRC_WORD7},
	{37349, R_008F30_SQ_IMG_SAMP_WORD0, 12, 573},
	{37367, R_008F34_SQ_IMG_SAMP_WORD1, 4, 585},
	{37385, R_008F38_SQ_IMG_SAMP_WORD2, 10, 589},
	{37403, R_008F3C_SQ_IMG_SAMP_WORD3, 2, 599},
	{37421, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 601},
	{37441, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 606},
	{37466, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 608},
	{37491, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 610},
	{37516, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 611},
	{37516, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 612},
	{37535, R_0090F0_SPI_ARB_PRIORITY, 3, 613},
	{37535, R_00C700_SPI_ARB_PRIORITY, 8, 616},
	{37552, R_0090F4_SPI_ARB_CYCLES_0, 2, 624},
	{37569, R_0090F8_SPI_ARB_CYCLES_1, 1, 626},
	{37586, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 627},
	{37608, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 628},
	{37630, R_030FF8_DB_ZPASS_COUNT_LOW},
	{37649, R_030FFC_DB_ZPASS_COUNT_HI, 1, 629},
	{37667, R_009100_SPI_CONFIG_CNTL, 5, 630},
	{37683, R_00913C_SPI_CONFIG_CNTL_1, 5, 635},
	{37701, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 640},
	{36904, R_00950C_TA_CS_BC_BASE_ADDR},
	{37730, R_009858_DB_SUBTILE_CONTROL, 10, 652},
	{37749, R_0098F8_GB_ADDR_CONFIG, 9, 662},
	{37764, R_009910_GB_TILE_MODE0, 10, 671},
	{37778, R_009914_GB_TILE_MODE1, 10, 671},
	{37792, R_009918_GB_TILE_MODE2, 10, 671},
	{37806, R_00991C_GB_TILE_MODE3, 10, 671},
	{37820, R_009920_GB_TILE_MODE4, 10, 671},
	{37834, R_009924_GB_TILE_MODE5, 10, 671},
	{37848, R_009928_GB_TILE_MODE6, 10, 671},
	{37862, R_00992C_GB_TILE_MODE7, 10, 671},
	{37876, R_009930_GB_TILE_MODE8, 10, 671},
	{37890, R_009934_GB_TILE_MODE9, 10, 671},
	{37904, R_009938_GB_TILE_MODE10, 10, 671},
	{37919, R_00993C_GB_TILE_MODE11, 10, 671},
	{37934, R_009940_GB_TILE_MODE12, 10, 671},
	{37949, R_009944_GB_TILE_MODE13, 10, 671},
	{37964, R_009948_GB_TILE_MODE14, 10, 671},
	{37979, R_00994C_GB_TILE_MODE15, 10, 671},
	{37994, R_009950_GB_TILE_MODE16, 10, 671},
	{38009, R_009954_GB_TILE_MODE17, 10, 671},
	{38024, R_009958_GB_TILE_MODE18, 10, 671},
	{38039, R_00995C_GB_TILE_MODE19, 10, 671},
	{38054, R_009960_GB_TILE_MODE20, 10, 671},
	{38069, R_009964_GB_TILE_MODE21, 10, 671},
	{38084, R_009968_GB_TILE_MODE22, 10, 671},
	{38099, R_00996C_GB_TILE_MODE23, 10, 671},
	{38114, R_009970_GB_TILE_MODE24, 10, 671},
	{38129, R_009974_GB_TILE_MODE25, 10, 671},
	{38144, R_009978_GB_TILE_MODE26, 10, 671},
	{38159, R_00997C_GB_TILE_MODE27, 10, 671},
	{38174, R_009980_GB_TILE_MODE28, 10, 671},
	{38189, R_009984_GB_TILE_MODE29, 10, 671},
	{38204, R_009988_GB_TILE_MODE30, 10, 671},
	{38219, R_00998C_GB_TILE_MODE31, 10, 671},
	{38234, R_009990_GB_MACROTILE_MODE0, 4, 681},
	{38253, R_009994_GB_MACROTILE_MODE1, 4, 681},
	{38272, R_009998_GB_MACROTILE_MODE2, 4, 681},
	{38291, R_00999C_GB_MACROTILE_MODE3, 4, 681},
	{38310, R_0099A0_GB_MACROTILE_MODE4, 4, 681},
	{38329, R_0099A4_GB_MACROTILE_MODE5, 4, 681},
	{38348, R_0099A8_GB_MACROTILE_MODE6, 4, 681},
	{38367, R_0099AC_GB_MACROTILE_MODE7, 4, 681},
	{38386, R_0099B0_GB_MACROTILE_MODE8, 4, 681},
	{38405, R_0099B4_GB_MACROTILE_MODE9, 4, 681},
	{38424, R_0099B8_GB_MACROTILE_MODE10, 4, 681},
	{38444, R_0099BC_GB_MACROTILE_MODE11, 4, 681},
	{38464, R_0099C0_GB_MACROTILE_MODE12, 4, 681},
	{38484, R_0099C4_GB_MACROTILE_MODE13, 4, 681},
	{38504, R_0099C8_GB_MACROTILE_MODE14, 4, 681},
	{38524, R_0099CC_GB_MACROTILE_MODE15, 4, 681},
	{38544, R_00B000_SPI_SHADER_TBA_LO_PS},
	{38565, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 685},
	{38586, R_00B008_SPI_SHADER_TMA_LO_PS},
	{38607, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 686},
	{38628, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 687},
	{38652, R_00B020_SPI_SHADER_PGM_LO_PS},
	{38673, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 690},
	{38694, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 691},
	{38718, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 702},
	{38742, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{38768, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{38794, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{38820, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{38846, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{38872, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{38898, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{38924, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{38950, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{38976, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{39002, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{39029, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{39056, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{39083, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{39110, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{39137, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{39164, R_00B100_SPI_SHADER_TBA_LO_VS},
	{39185, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 709},
	{39206, R_00B108_SPI_SHADER_TMA_LO_VS},
	{39227, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 710},
	{39248, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 711},
	{39272, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 714},
	{39297, R_00B120_SPI_SHADER_PGM_LO_VS},
	{39318, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 715},
	{39339, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 716},
	{39363, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 728},
	{39387, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{39413, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{39439, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{39465, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{39491, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{39517, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{39543, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{39569, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{39595, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{39621, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{39647, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{39674, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{39701, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{39728, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{39755, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{39782, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{39809, R_00B200_SPI_SHADER_TBA_LO_GS},
	{39830, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 740},
	{39851, R_00B208_SPI_SHADER_TMA_LO_GS},
	{39872, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 741},
	{39893, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 742},
	{39917, R_00B220_SPI_SHADER_PGM_LO_GS},
	{39938, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 746},
	{39959, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 747},
	{39983, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 758},
	{40007, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{40033, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{40059, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{40085, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{40111, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{40137, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{40163, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{40189, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{40215, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{40241, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{40267, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{40294, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{40321, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{40348, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{40375, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{40402, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{40429, R_00B300_SPI_SHADER_TBA_LO_ES},
	{40450, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 763},
	{40471, R_00B308_SPI_SHADER_TMA_LO_ES},
	{40492, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 764},
	{40513, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 765},
	{40537, R_00B320_SPI_SHADER_PGM_LO_ES},
	{40558, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 769},
	{40579, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 770},
	{40603, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 6, 782},
	{40627, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{40653, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{40679, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{40705, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{40731, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{40757, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{40783, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{40809, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{40835, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{40861, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{40887, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{40914, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{40941, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{40968, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{40995, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{41022, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{41049, R_00B400_SPI_SHADER_TBA_LO_HS},
	{41070, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 788},
	{41091, R_00B408_SPI_SHADER_TMA_LO_HS},
	{41112, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 789},
	{41133, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 790},
	{41157, R_00B420_SPI_SHADER_PGM_LO_HS},
	{41178, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 793},
	{41199, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 794},
	{41223, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 6, 804},
	{41247, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{41273, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{41299, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{41325, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{41351, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{41377, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{41403, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{41429, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{41455, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{41481, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{41507, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{41534, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{41561, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{41588, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{41615, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{41642, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{41669, R_00B500_SPI_SHADER_TBA_LO_LS},
	{41690, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 810},
	{41711, R_00B508_SPI_SHADER_TMA_LO_LS},
	{41732, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 811},
	{41753, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 812},
	{41777, R_00B520_SPI_SHADER_PGM_LO_LS},
	{41798, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 816},
	{41819, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 817},
	{41843, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 5, 828},
	{41867, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{41893, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{41919, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{41945, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{41971, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{41997, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{42023, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{42049, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{42075, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{42101, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{42127, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{42154, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{42181, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{42208, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{42235, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{42262, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{42289, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 833},
	{42316, R_00B804_COMPUTE_DIM_X},
	{42330, R_00B808_COMPUTE_DIM_Y},
	{42344, R_00B80C_COMPUTE_DIM_Z},
	{42358, R_00B810_COMPUTE_START_X},
	{42374, R_00B814_COMPUTE_START_Y},
	{42390, R_00B818_COMPUTE_START_Z},
	{42406, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 845},
	{42427, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 847},
	{42448, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 849},
	{42469, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 851},
	{42489, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 852},
	{42517, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 853},
	{42542, R_00B830_COMPUTE_PGM_LO},
	{42557, R_00B834_COMPUTE_PGM_HI, 2, 854},
	{42572, R_00B838_COMPUTE_TBA_LO},
	{42587, R_00B83C_COMPUTE_TBA_HI, 1, 856},
	{42602, R_00B840_COMPUTE_TMA_LO},
	{42617, R_00B844_COMPUTE_TMA_HI, 1, 857},
	{42632, R_00B848_COMPUTE_PGM_RSRC1, 10, 858},
	{42650, R_00B84C_COMPUTE_PGM_RSRC2, 11, 868},
	{42668, R_00B850_COMPUTE_VMID, 1, 879},
	{42681, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 880},
	{42705, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 887},
	{42736, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 889},
	{42767, R_00B860_COMPUTE_TMPRING_SIZE, 2, 891},
	{42788, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 893},
	{42819, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 895},
	{42850, R_00B86C_COMPUTE_RESTART_X},
	{42868, R_00B870_COMPUTE_RESTART_Y},
	{42886, R_00B874_COMPUTE_RESTART_Z},
	{42904, R_00B87C_COMPUTE_MISC_RESERVED, 5, 897},
	{42926, R_00B880_COMPUTE_DISPATCH_ID},
	{42946, R_00B884_COMPUTE_THREADGROUP_ID},
	{42969, R_00B888_COMPUTE_RELAUNCH, 3, 902},
	{42986, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{43015, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 905},
	{43044, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 906},
	{43073, R_00B900_COMPUTE_USER_DATA_0},
	{43093, R_00B904_COMPUTE_USER_DATA_1},
	{43113, R_00B908_COMPUTE_USER_DATA_2},
	{43133, R_00B90C_COMPUTE_USER_DATA_3},
	{43153, R_00B910_COMPUTE_USER_DATA_4},
	{43173, R_00B914_COMPUTE_USER_DATA_5},
	{43193, R_00B918_COMPUTE_USER_DATA_6},
	{43213, R_00B91C_COMPUTE_USER_DATA_7},
	{43233, R_00B920_COMPUTE_USER_DATA_8},
	{43253, R_00B924_COMPUTE_USER_DATA_9},
	{43273, R_00B928_COMPUTE_USER_DATA_10},
	{43294, R_00B92C_COMPUTE_USER_DATA_11},
	{43315, R_00B930_COMPUTE_USER_DATA_12},
	{43336, R_00B934_COMPUTE_USER_DATA_13},
	{43357, R_00B938_COMPUTE_USER_DATA_14},
	{43378, R_00B93C_COMPUTE_USER_DATA_15},
	{43399, R_00B9FC_COMPUTE_NOWHERE},
	{43415, R_034000_CPG_PERFCOUNTER1_LO},
	{43435, R_034004_CPG_PERFCOUNTER1_HI},
	{43455, R_034008_CPG_PERFCOUNTER0_LO},
	{43475, R_03400C_CPG_PERFCOUNTER0_HI},
	{43495, R_034010_CPC_PERFCOUNTER1_LO},
	{43515, R_034014_CPC_PERFCOUNTER1_HI},
	{43535, R_034018_CPC_PERFCOUNTER0_LO},
	{43555, R_03401C_CPC_PERFCOUNTER0_HI},
	{43575, R_034020_CPF_PERFCOUNTER1_LO},
	{43595, R_034024_CPF_PERFCOUNTER1_HI},
	{43615, R_034028_CPF_PERFCOUNTER0_LO},
	{43635, R_03402C_CPF_PERFCOUNTER0_HI},
	{43655, R_034100_GRBM_PERFCOUNTER0_LO},
	{43676, R_034104_GRBM_PERFCOUNTER0_HI},
	{43697, R_03410C_GRBM_PERFCOUNTER1_LO},
	{43718, R_034110_GRBM_PERFCOUNTER1_HI},
	{43739, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{43763, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{43787, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{43811, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{43835, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{43859, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{43883, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{43907, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{43931, R_034200_WD_PERFCOUNTER0_LO},
	{43950, R_034204_WD_PERFCOUNTER0_HI},
	{43969, R_034208_WD_PERFCOUNTER1_LO},
	{43988, R_03420C_WD_PERFCOUNTER1_HI},
	{44007, R_034210_WD_PERFCOUNTER2_LO},
	{44026, R_034214_WD_PERFCOUNTER2_HI},
	{44045, R_034218_WD_PERFCOUNTER3_LO},
	{44064, R_03421C_WD_PERFCOUNTER3_HI},
	{44083, R_034220_IA_PERFCOUNTER0_LO},
	{44102, R_034224_IA_PERFCOUNTER0_HI},
	{44121, R_034228_IA_PERFCOUNTER1_LO},
	{44140, R_03422C_IA_PERFCOUNTER1_HI},
	{44159, R_034230_IA_PERFCOUNTER2_LO},
	{44178, R_034234_IA_PERFCOUNTER2_HI},
	{44197, R_034238_IA_PERFCOUNTER3_LO},
	{44216, R_03423C_IA_PERFCOUNTER3_HI},
	{44235, R_034240_VGT_PERFCOUNTER0_LO},
	{44255, R_034244_VGT_PERFCOUNTER0_HI},
	{44275, R_034248_VGT_PERFCOUNTER1_LO},
	{44295, R_03424C_VGT_PERFCOUNTER1_HI},
	{44315, R_034250_VGT_PERFCOUNTER2_LO},
	{44335, R_034254_VGT_PERFCOUNTER2_HI},
	{44355, R_034258_VGT_PERFCOUNTER3_LO},
	{44375, R_03425C_VGT_PERFCOUNTER3_HI},
	{44395, R_034400_PA_SU_PERFCOUNTER0_LO},
	{44417, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 908},
	{44439, R_034408_PA_SU_PERFCOUNTER1_LO},
	{44461, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 908},
	{44483, R_034410_PA_SU_PERFCOUNTER2_LO},
	{44505, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 908},
	{44527, R_034418_PA_SU_PERFCOUNTER3_LO},
	{44549, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 908},
	{44571, R_034500_PA_SC_PERFCOUNTER0_LO},
	{44593, R_034504_PA_SC_PERFCOUNTER0_HI},
	{44615, R_034508_PA_SC_PERFCOUNTER1_LO},
	{44637, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{44659, R_034510_PA_SC_PERFCOUNTER2_LO},
	{44681, R_034514_PA_SC_PERFCOUNTER2_HI},
	{44703, R_034518_PA_SC_PERFCOUNTER3_LO},
	{44725, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{44747, R_034520_PA_SC_PERFCOUNTER4_LO},
	{44769, R_034524_PA_SC_PERFCOUNTER4_HI},
	{44791, R_034528_PA_SC_PERFCOUNTER5_LO},
	{44813, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{44835, R_034530_PA_SC_PERFCOUNTER6_LO},
	{44857, R_034534_PA_SC_PERFCOUNTER6_HI},
	{44879, R_034538_PA_SC_PERFCOUNTER7_LO},
	{44901, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{44923, R_034600_SPI_PERFCOUNTER0_HI},
	{44943, R_034604_SPI_PERFCOUNTER0_LO},
	{44963, R_034608_SPI_PERFCOUNTER1_HI},
	{44983, R_03460C_SPI_PERFCOUNTER1_LO},
	{45003, R_034610_SPI_PERFCOUNTER2_HI},
	{45023, R_034614_SPI_PERFCOUNTER2_LO},
	{45043, R_034618_SPI_PERFCOUNTER3_HI},
	{45063, R_03461C_SPI_PERFCOUNTER3_LO},
	{45083, R_034620_SPI_PERFCOUNTER4_HI},
	{45103, R_034624_SPI_PERFCOUNTER4_LO},
	{45123, R_034628_SPI_PERFCOUNTER5_HI},
	{45143, R_03462C_SPI_PERFCOUNTER5_LO},
	{45163, R_034700_SQ_PERFCOUNTER0_LO},
	{45182, R_034704_SQ_PERFCOUNTER0_HI},
	{45201, R_034708_SQ_PERFCOUNTER1_LO},
	{45220, R_03470C_SQ_PERFCOUNTER1_HI},
	{45239, R_034710_SQ_PERFCOUNTER2_LO},
	{45258, R_034714_SQ_PERFCOUNTER2_HI},
	{45277, R_034718_SQ_PERFCOUNTER3_LO},
	{45296, R_03471C_SQ_PERFCOUNTER3_HI},
	{45315, R_034720_SQ_PERFCOUNTER4_LO},
	{45334, R_034724_SQ_PERFCOUNTER4_HI},
	{45353, R_034728_SQ_PERFCOUNTER5_LO},
	{45372, R_03472C_SQ_PERFCOUNTER5_HI},
	{45391, R_034730_SQ_PERFCOUNTER6_LO},
	{45410, R_034734_SQ_PERFCOUNTER6_HI},
	{45429, R_034738_SQ_PERFCOUNTER7_LO},
	{45448, R_03473C_SQ_PERFCOUNTER7_HI},
	{45467, R_034740_SQ_PERFCOUNTER8_LO},
	{45486, R_034744_SQ_PERFCOUNTER8_HI},
	{45505, R_034748_SQ_PERFCOUNTER9_LO},
	{45524, R_03474C_SQ_PERFCOUNTER9_HI},
	{45543, R_034750_SQ_PERFCOUNTER10_LO},
	{45563, R_034754_SQ_PERFCOUNTER10_HI},
	{45583, R_034758_SQ_PERFCOUNTER11_LO},
	{45603, R_03475C_SQ_PERFCOUNTER11_HI},
	{45623, R_034760_SQ_PERFCOUNTER12_LO},
	{45643, R_034764_SQ_PERFCOUNTER12_HI},
	{45663, R_034768_SQ_PERFCOUNTER13_LO},
	{45683, R_03476C_SQ_PERFCOUNTER13_HI},
	{45703, R_034770_SQ_PERFCOUNTER14_LO},
	{45723, R_034774_SQ_PERFCOUNTER14_HI},
	{45743, R_034778_SQ_PERFCOUNTER15_LO},
	{45763, R_03477C_SQ_PERFCOUNTER15_HI},
	{45783, R_034900_SX_PERFCOUNTER0_LO},
	{45802, R_034904_SX_PERFCOUNTER0_HI},
	{45821, R_034908_SX_PERFCOUNTER1_LO},
	{45840, R_03490C_SX_PERFCOUNTER1_HI},
	{45859, R_034910_SX_PERFCOUNTER2_LO},
	{45878, R_034914_SX_PERFCOUNTER2_HI},
	{45897, R_034918_SX_PERFCOUNTER3_LO},
	{45916, R_03491C_SX_PERFCOUNTER3_HI},
	{45935, R_034A00_GDS_PERFCOUNTER0_LO},
	{45955, R_034A04_GDS_PERFCOUNTER0_HI},
	{45975, R_034A08_GDS_PERFCOUNTER1_LO},
	{45995, R_034A0C_GDS_PERFCOUNTER1_HI},
	{46015, R_034A10_GDS_PERFCOUNTER2_LO},
	{46035, R_034A14_GDS_PERFCOUNTER2_HI},
	{46055, R_034A18_GDS_PERFCOUNTER3_LO},
	{46075, R_034A1C_GDS_PERFCOUNTER3_HI},
	{46095, R_034B00_TA_PERFCOUNTER0_LO},
	{46114, R_034B04_TA_PERFCOUNTER0_HI},
	{46133, R_034B08_TA_PERFCOUNTER1_LO},
	{46152, R_034B0C_TA_PERFCOUNTER1_HI},
	{46171, R_034C00_TD_PERFCOUNTER0_LO},
	{46190, R_034C04_TD_PERFCOUNTER0_HI},
	{46209, R_034C08_TD_PERFCOUNTER1_LO},
	{46228, R_034C0C_TD_PERFCOUNTER1_HI},
	{46247, R_034D00_TCP_PERFCOUNTER0_LO},
	{46267, R_034D04_TCP_PERFCOUNTER0_HI},
	{46287, R_034D08_TCP_PERFCOUNTER1_LO},
	{46307, R_034D0C_TCP_PERFCOUNTER1_HI},
	{46327, R_034D10_TCP_PERFCOUNTER2_LO},
	{46347, R_034D14_TCP_PERFCOUNTER2_HI},
	{46367, R_034D18_TCP_PERFCOUNTER3_LO},
	{46387, R_034D1C_TCP_PERFCOUNTER3_HI},
	{46407, R_034E00_TCC_PERFCOUNTER0_LO},
	{46427, R_034E04_TCC_PERFCOUNTER0_HI},
	{46447, R_034E08_TCC_PERFCOUNTER1_LO},
	{46467, R_034E0C_TCC_PERFCOUNTER1_HI},
	{46487, R_034E10_TCC_PERFCOUNTER2_LO},
	{46507, R_034E14_TCC_PERFCOUNTER2_HI},
	{46527, R_034E18_TCC_PERFCOUNTER3_LO},
	{46547, R_034E1C_TCC_PERFCOUNTER3_HI},
	{46567, R_034E40_TCA_PERFCOUNTER0_LO},
	{46587, R_034E44_TCA_PERFCOUNTER0_HI},
	{46607, R_034E48_TCA_PERFCOUNTER1_LO},
	{46627, R_034E4C_TCA_PERFCOUNTER1_HI},
	{46647, R_034E50_TCA_PERFCOUNTER2_LO},
	{46667, R_034E54_TCA_PERFCOUNTER2_HI},
	{46687, R_034E58_TCA_PERFCOUNTER3_LO},
	{46707, R_034E5C_TCA_PERFCOUNTER3_HI},
	{46727, R_035018_CB_PERFCOUNTER0_LO},
	{46746, R_03501C_CB_PERFCOUNTER0_HI},
	{46765, R_035020_CB_PERFCOUNTER1_LO},
	{46784, R_035024_CB_PERFCOUNTER1_HI},
	{46803, R_035028_CB_PERFCOUNTER2_LO},
	{46822, R_03502C_CB_PERFCOUNTER2_HI},
	{46841, R_035030_CB_PERFCOUNTER3_LO},
	{46860, R_035034_CB_PERFCOUNTER3_HI},
	{46879, R_035100_DB_PERFCOUNTER0_LO},
	{46898, R_035104_DB_PERFCOUNTER0_HI},
	{46917, R_035108_DB_PERFCOUNTER1_LO},
	{46936, R_03510C_DB_PERFCOUNTER1_HI},
	{46955, R_035110_DB_PERFCOUNTER2_LO},
	{46974, R_035114_DB_PERFCOUNTER2_HI},
	{46993, R_035118_DB_PERFCOUNTER3_LO},
	{47012, R_03511C_DB_PERFCOUNTER3_HI},
	{47031, R_035200_RLC_PERFCOUNTER0_LO},
	{47051, R_035204_RLC_PERFCOUNTER0_HI},
	{47071, R_035208_RLC_PERFCOUNTER1_LO},
	{47091, R_03520C_RLC_PERFCOUNTER1_HI},
	{47111, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 911},
	{47135, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 909},
	{47160, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 911},
	{47184, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 925},
	{47208, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 914},
	{47233, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 918},
	{47257, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 916},
	{47282, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 918},
	{47306, R_036020_CP_PERFMON_CNTL, 4, 921},
	{47322, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 925},
	{47346, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 928},
	{47371, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 928},
	{47396, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 947},
	{47424, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 959},
	{47452, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 971},
	{47480, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 983},
	{47508, R_036200_WD_PERFCOUNTER0_SELECT, 2, 995},
	{47531, R_036204_WD_PERFCOUNTER1_SELECT, 2, 995},
	{47554, R_036208_WD_PERFCOUNTER2_SELECT, 2, 995},
	{47577, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 995},
	{47600, R_036210_IA_PERFCOUNTER0_SELECT, 5, 997},
	{47623, R_036214_IA_PERFCOUNTER1_SELECT, 5, 997},
	{47646, R_036218_IA_PERFCOUNTER2_SELECT, 5, 997},
	{47669, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 997},
	{47692, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1002},
	{47716, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1006},
	{47740, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1006},
	{47764, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1006},
	{47788, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1006},
	{47812, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1011},
	{47837, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{47862, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1015},
	{47888, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1016},
	{47914, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1019},
	{47941, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1016},
	{47967, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{47994, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1016},
	{48020, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1016},
	{48046, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1021},
	{48072, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1024},
	{48099, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1021},
	{48125, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1021},
	{48151, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1021},
	{48177, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1021},
	{48203, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1021},
	{48229, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1021},
	{48255, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1021},
	{48281, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1026},
	{48305, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1026},
	{48329, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1026},
	{48353, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1026},
	{48377, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1029},
	{48402, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{48427, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{48452, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{48477, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1026},
	{48501, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1026},
	{48525, R_036628_SPI_PERFCOUNTER_BINS, 8, 1031},
	{48546, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1039},
	{48569, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1039},
	{48592, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1039},
	{48615, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1039},
	{48638, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1039},
	{48661, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1039},
	{48684, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1039},
	{48707, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1039},
	{48730, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1039},
	{48753, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1039},
	{48776, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1039},
	{48800, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1039},
	{48824, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1039},
	{48848, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1039},
	{48872, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1039},
	{48896, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1039},
	{48920, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1045},
	{48940, R_036784_SQ_PERFCOUNTER_MASK, 2, 1054},
	{48960, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1056},
	{48981, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1057},
	{49004, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1057},
	{49027, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1057},
	{49050, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1057},
	{49073, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1060},
	{49097, R_036914_SX_PERFCOUNTER1_SELECT1},
	{49121, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1062},
	{49145, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1062},
	{49169, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1062},
	{49193, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1062},
	{49217, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1065},
	{49242, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1067},
	{49265, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1072},
	{49289, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1067},
	{49312, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1076},
	{49335, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1081},
	{49359, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1076},
	{49382, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1085},
	{49406, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1090},
	{49431, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1085},
	{49455, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{49480, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1085},
	{49504, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1085},
	{49528, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1094},
	{49552, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1099},
	{49577, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1094},
	{49601, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{49626, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1094},
	{49650, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1094},
	{49674, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1103},
	{49698, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1108},
	{49723, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1103},
	{49747, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{49772, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1103},
	{49796, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1103},
	{49820, R_037000_CB_PERFCOUNTER_FILTER, 12, 1112},
	{49842, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1124},
	{49865, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1129},
	{49889, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1124},
	{49912, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1124},
	{49935, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1124},
	{49958, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1133},
	{49981, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1138},
	{50005, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1133},
	{50028, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{50052, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1133},
	{50075, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1133},
	{50098, R_028000_DB_RENDER_CONTROL, 10, 1142},
	{50116, R_028004_DB_COUNT_CONTROL, 9, 1152},
	{50133, R_028008_DB_DEPTH_VIEW, 4, 1161},
	{50147, R_02800C_DB_RENDER_OVERRIDE, 23, 1165},
	{50166, R_028010_DB_RENDER_OVERRIDE2, 15, 1188},
	{50186, R_028014_DB_HTILE_DATA_BASE},
	{50205, R_028020_DB_DEPTH_BOUNDS_MIN},
	{50225, R_028024_DB_DEPTH_BOUNDS_MAX},
	{50245, R_028028_DB_STENCIL_CLEAR, 1, 1203},
	{50262, R_02802C_DB_DEPTH_CLEAR},
	{50277, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1204},
	{50301, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1206},
	{50325, R_02803C_DB_DEPTH_INFO, 7, 1208},
	{50339, R_028040_DB_Z_INFO, 10, 1215},
	{50349, R_028044_DB_STENCIL_INFO, 6, 1225},
	{50365, R_028048_DB_Z_READ_BASE},
	{50380, R_02804C_DB_STENCIL_READ_BASE},
	{50401, R_028050_DB_Z_WRITE_BASE},
	{50417, R_028054_DB_STENCIL_WRITE_BASE},
	{50439, R_028058_DB_DEPTH_SIZE, 2, 1231},
	{50453, R_02805C_DB_DEPTH_SLICE, 1, 1233},
	{50468, R_028080_TA_BC_BASE_ADDR},
	{50484, R_028084_TA_BC_BASE_ADDR_HI, 1, 1234},
	{50503, R_0281E8_COHER_DEST_BASE_HI_0},
	{50524, R_0281EC_COHER_DEST_BASE_HI_1},
	{50545, R_0281F0_COHER_DEST_BASE_HI_2},
	{50566, R_0281F4_COHER_DEST_BASE_HI_3},
	{50587, R_0281F8_COHER_DEST_BASE_2},
	{50605, R_0281FC_COHER_DEST_BASE_3},
	{50623, R_028200_PA_SC_WINDOW_OFFSET, 2, 1235},
	{50643, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1237},
	{50667, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1240},
	{50691, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1242},
	{50711, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1243},
	{50731, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1245},
	{50751, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1243},
	{50771, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1245},
	{50791, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1243},
	{50811, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1245},
	{50831, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1243},
	{50851, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1245},
	{50871, R_028230_PA_SC_EDGERULE, 7, 1247},
	{50886, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1254},
	{50915, R_028238_CB_TARGET_MASK, 8, 1256},
	{50930, R_02823C_CB_SHADER_MASK, 8, 1264},
	{50945, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1272},
	{50970, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1275},
	{50995, R_028248_COHER_DEST_BASE_0},
	{51013, R_02824C_COHER_DEST_BASE_1},
	{51031, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1277},
	{51056, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1280},
	{51081, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1277},
	{51106, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1280},
	{51131, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1277},
	{51156, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1280},
	{51181, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1277},
	{51206, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1280},
	{51231, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1277},
	{51256, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1280},
	{51281, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1277},
	{51306, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1280},
	{51331, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1277},
	{51356, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1280},
	{51381, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1277},
	{51406, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1280},
	{51431, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1277},
	{51456, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1280},
	{51481, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1277},
	{51506, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1280},
	{51531, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1277},
	{51557, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1280},
	{51583, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1277},
	{51609, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1280},
	{51635, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1277},
	{51661, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1280},
	{51687, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1277},
	{51713, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1280},
	{51739, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1277},
	{51765, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1280},
	{51791, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1277},
	{51817, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1280},
	{51843, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{51862, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{51881, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{51900, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{51919, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{51938, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{51957, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{51976, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{51995, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{52014, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{52033, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{52052, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{52071, R_028300_PA_SC_VPORT_ZMIN_6},
	{52090, R_028304_PA_SC_VPORT_ZMAX_6},
	{52109, R_028308_PA_SC_VPORT_ZMIN_7},
	{52128, R_02830C_PA_SC_VPORT_ZMAX_7},
	{52147, R_028310_PA_SC_VPORT_ZMIN_8},
	{52166, R_028314_PA_SC_VPORT_ZMAX_8},
	{52185, R_028318_PA_SC_VPORT_ZMIN_9},
	{52204, R_02831C_PA_SC_VPORT_ZMAX_9},
	{52223, R_028320_PA_SC_VPORT_ZMIN_10},
	{52243, R_028324_PA_SC_VPORT_ZMAX_10},
	{52263, R_028328_PA_SC_VPORT_ZMIN_11},
	{52283, R_02832C_PA_SC_VPORT_ZMAX_11},
	{52303, R_028330_PA_SC_VPORT_ZMIN_12},
	{52323, R_028334_PA_SC_VPORT_ZMAX_12},
	{52343, R_028338_PA_SC_VPORT_ZMIN_13},
	{52363, R_02833C_PA_SC_VPORT_ZMAX_13},
	{52383, R_028340_PA_SC_VPORT_ZMIN_14},
	{52403, R_028344_PA_SC_VPORT_ZMAX_14},
	{52423, R_028348_PA_SC_VPORT_ZMIN_15},
	{52443, R_02834C_PA_SC_VPORT_ZMAX_15},
	{52463, R_028350_PA_SC_RASTER_CONFIG, 15, 1282},
	{52483, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1297},
	{52505, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1300},
	{52533, R_028400_VGT_MAX_VTX_INDX},
	{52550, R_028404_VGT_MIN_VTX_INDX},
	{52567, R_028408_VGT_INDX_OFFSET},
	{52583, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{52612, R_028414_CB_BLEND_RED},
	{52625, R_028418_CB_BLEND_GREEN},
	{52640, R_02841C_CB_BLEND_BLUE},
	{52654, R_028420_CB_BLEND_ALPHA},
	{52669, R_028424_CB_DCC_CONTROL, 3, 1302},
	{52684, R_02842C_DB_STENCIL_CONTROL, 6, 1305},
	{52703, R_028430_DB_STENCILREFMASK, 4, 1311},
	{52721, R_028434_DB_STENCILREFMASK_BF, 4, 1315},
	{52742, R_02843C_PA_CL_VPORT_XSCALE},
	{52761, R_028440_PA_CL_VPORT_XOFFSET},
	{52781, R_028444_PA_CL_VPORT_YSCALE},
	{52800, R_028448_PA_CL_VPORT_YOFFSET},
	{52820, R_02844C_PA_CL_VPORT_ZSCALE},
	{52839, R_028450_PA_CL_VPORT_ZOFFSET},
	{52859, R_028454_PA_CL_VPORT_XSCALE_1},
	{52880, R_028458_PA_CL_VPORT_XOFFSET_1},
	{52902, R_02845C_PA_CL_VPORT_YSCALE_1},
	{52923, R_028460_PA_CL_VPORT_YOFFSET_1},
	{52945, R_028464_PA_CL_VPORT_ZSCALE_1},
	{52966, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{52988, R_02846C_PA_CL_VPORT_XSCALE_2},
	{53009, R_028470_PA_CL_VPORT_XOFFSET_2},
	{53031, R_028474_PA_CL_VPORT_YSCALE_2},
	{53052, R_028478_PA_CL_VPORT_YOFFSET_2},
	{53074, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{53095, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{53117, R_028484_PA_CL_VPORT_XSCALE_3},
	{53138, R_028488_PA_CL_VPORT_XOFFSET_3},
	{53160, R_02848C_PA_CL_VPORT_YSCALE_3},
	{53181, R_028490_PA_CL_VPORT_YOFFSET_3},
	{53203, R_028494_PA_CL_VPORT_ZSCALE_3},
	{53224, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{53246, R_02849C_PA_CL_VPORT_XSCALE_4},
	{53267, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{53289, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{53310, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{53332, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{53353, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{53375, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{53396, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{53418, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{53439, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{53461, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{53482, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{53504, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{53525, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{53547, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{53568, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{53590, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{53611, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{53633, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{53654, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{53676, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{53697, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{53719, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{53740, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{53762, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{53783, R_028500_PA_CL_VPORT_XOFFSET_8},
	{53805, R_028504_PA_CL_VPORT_YSCALE_8},
	{53826, R_028508_PA_CL_VPORT_YOFFSET_8},
	{53848, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{53869, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{53891, R_028514_PA_CL_VPORT_XSCALE_9},
	{53912, R_028518_PA_CL_VPORT_XOFFSET_9},
	{53934, R_02851C_PA_CL_VPORT_YSCALE_9},
	{53955, R_028520_PA_CL_VPORT_YOFFSET_9},
	{53977, R_028524_PA_CL_VPORT_ZSCALE_9},
	{53998, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{54020, R_02852C_PA_CL_VPORT_XSCALE_10},
	{54042, R_028530_PA_CL_VPORT_XOFFSET_10},
	{54065, R_028534_PA_CL_VPORT_YSCALE_10},
	{54087, R_028538_PA_CL_VPORT_YOFFSET_10},
	{54110, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{54132, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{54155, R_028544_PA_CL_VPORT_XSCALE_11},
	{54177, R_028548_PA_CL_VPORT_XOFFSET_11},
	{54200, R_02854C_PA_CL_VPORT_YSCALE_11},
	{54222, R_028550_PA_CL_VPORT_YOFFSET_11},
	{54245, R_028554_PA_CL_VPORT_ZSCALE_11},
	{54267, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{54290, R_02855C_PA_CL_VPORT_XSCALE_12},
	{54312, R_028560_PA_CL_VPORT_XOFFSET_12},
	{54335, R_028564_PA_CL_VPORT_YSCALE_12},
	{54357, R_028568_PA_CL_VPORT_YOFFSET_12},
	{54380, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{54402, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{54425, R_028574_PA_CL_VPORT_XSCALE_13},
	{54447, R_028578_PA_CL_VPORT_XOFFSET_13},
	{54470, R_02857C_PA_CL_VPORT_YSCALE_13},
	{54492, R_028580_PA_CL_VPORT_YOFFSET_13},
	{54515, R_028584_PA_CL_VPORT_ZSCALE_13},
	{54537, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{54560, R_02858C_PA_CL_VPORT_XSCALE_14},
	{54582, R_028590_PA_CL_VPORT_XOFFSET_14},
	{54605, R_028594_PA_CL_VPORT_YSCALE_14},
	{54627, R_028598_PA_CL_VPORT_YOFFSET_14},
	{54650, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{54672, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{54695, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{54717, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{54740, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{54762, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{54785, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{54807, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{54830, R_0285BC_PA_CL_UCP_0_X},
	{54844, R_0285C0_PA_CL_UCP_0_Y},
	{54858, R_0285C4_PA_CL_UCP_0_Z},
	{54872, R_0285C8_PA_CL_UCP_0_W},
	{54886, R_0285CC_PA_CL_UCP_1_X},
	{54900, R_0285D0_PA_CL_UCP_1_Y},
	{54914, R_0285D4_PA_CL_UCP_1_Z},
	{54928, R_0285D8_PA_CL_UCP_1_W},
	{54942, R_0285DC_PA_CL_UCP_2_X},
	{54956, R_0285E0_PA_CL_UCP_2_Y},
	{54970, R_0285E4_PA_CL_UCP_2_Z},
	{54984, R_0285E8_PA_CL_UCP_2_W},
	{54998, R_0285EC_PA_CL_UCP_3_X},
	{55012, R_0285F0_PA_CL_UCP_3_Y},
	{55026, R_0285F4_PA_CL_UCP_3_Z},
	{55040, R_0285F8_PA_CL_UCP_3_W},
	{55054, R_0285FC_PA_CL_UCP_4_X},
	{55068, R_028600_PA_CL_UCP_4_Y},
	{55082, R_028604_PA_CL_UCP_4_Z},
	{55096, R_028608_PA_CL_UCP_4_W},
	{55110, R_02860C_PA_CL_UCP_5_X},
	{55124, R_028610_PA_CL_UCP_5_Y},
	{55138, R_028614_PA_CL_UCP_5_Z},
	{55152, R_028618_PA_CL_UCP_5_W},
	{55166, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1319},
	{55186, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1319},
	{55206, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1319},
	{55226, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1319},
	{55246, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1319},
	{55266, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1319},
	{55286, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1319},
	{55306, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1319},
	{55326, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1319},
	{55346, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1319},
	{55366, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1319},
	{55387, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1319},
	{55408, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1319},
	{55429, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1319},
	{55450, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1319},
	{55471, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1319},
	{55492, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1319},
	{55513, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1319},
	{55534, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1319},
	{55555, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1319},
	{55576, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1319},
	{55597, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1319},
	{55618, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1319},
	{55639, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1319},
	{55660, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1319},
	{55681, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1319},
	{55702, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1319},
	{55723, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1319},
	{55744, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1319},
	{55765, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1319},
	{55786, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1319},
	{55807, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1319},
	{55828, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1331},
	{55846, R_0286CC_SPI_PS_INPUT_ENA, 16, 1335},
	{55863, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1351},
	{55881, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1367},
	{55902, R_0286D8_SPI_PS_IN_CONTROL, 5, 1374},
	{55920, R_0286E0_SPI_BARYC_CNTL, 7, 1379},
	{55935, R_0286E8_SPI_TMPRING_SIZE, 2, 1386},
	{55952, R_028704_SPI_WAVE_MGMT_1, 5, 1388},
	{55968, R_028708_SPI_WAVE_MGMT_2, 1, 1393},
	{55984, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1394},
	{56006, R_028710_SPI_SHADER_Z_FORMAT, 1, 1398},
	{56026, R_028714_SPI_SHADER_COL_FORMAT, 8, 1399},
	{56048, R_028754_SX_PS_DOWNCONVERT, 8, 1407},
	{56066, R_028758_SX_BLEND_OPT_EPSILON, 8, 1415},
	{56087, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1423},
	{56108, R_028760_SX_MRT0_BLEND_OPT, 6, 1440},
	{56126, R_028764_SX_MRT1_BLEND_OPT, 6, 1446},
	{56144, R_028768_SX_MRT2_BLEND_OPT, 6, 1452},
	{56162, R_02876C_SX_MRT3_BLEND_OPT, 6, 1458},
	{56180, R_028770_SX_MRT4_BLEND_OPT, 6, 1464},
	{56198, R_028774_SX_MRT5_BLEND_OPT, 6, 1470},
	{56216, R_028778_SX_MRT6_BLEND_OPT, 6, 1476},
	{56234, R_02877C_SX_MRT7_BLEND_OPT, 6, 1482},
	{56252, R_028780_CB_BLEND0_CONTROL, 9, 1488},
	{56270, R_028784_CB_BLEND1_CONTROL, 9, 1488},
	{56288, R_028788_CB_BLEND2_CONTROL, 9, 1488},
	{56306, R_02878C_CB_BLEND3_CONTROL, 9, 1488},
	{56324, R_028790_CB_BLEND4_CONTROL, 9, 1488},
	{56342, R_028794_CB_BLEND5_CONTROL, 9, 1488},
	{56360, R_028798_CB_BLEND6_CONTROL, 9, 1488},
	{56378, R_02879C_CB_BLEND7_CONTROL, 9, 1488},
	{56396, R_0287CC_CS_COPY_STATE, 1, 1497},
	{56410, R_0287D4_PA_CL_POINT_X_RAD},
	{56428, R_0287D8_PA_CL_POINT_Y_RAD},
	{56446, R_0287DC_PA_CL_POINT_SIZE},
	{56463, R_0287E0_PA_CL_POINT_CULL_RAD},
	{56484, R_0287E4_VGT_DMA_BASE_HI, 1, 1498},
	{56500, R_0287E8_VGT_DMA_BASE},
	{56513, R_0287F0_VGT_DRAW_INITIATOR, 4, 1499},
	{56532, R_0287F4_VGT_IMMED_DATA},
	{56547, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1503},
	{56569, R_028800_DB_DEPTH_CONTROL, 10, 1504},
	{56586, R_028804_DB_EQAA, 12, 1514},
	{56594, R_028808_CB_COLOR_CONTROL, 4, 1526},
	{56611, R_02880C_DB_SHADER_CONTROL, 13, 1530},
	{56629, R_028810_PA_CL_CLIP_CNTL, 19, 1543},
	{56645, R_028814_PA_SU_SC_MODE_CNTL, 13, 1562},
	{56664, R_028818_PA_CL_VTE_CNTL, 9, 1575},
	{56679, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1584},
	{56697, R_028820_PA_CL_NANINF_CNTL, 16, 1611},
	{56715, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1627},
	{56739, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{56764, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1631},
	{56787, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1642},
	{56816, R_028A00_PA_SU_POINT_SIZE, 2, 1647},
	{56833, R_028A04_PA_SU_POINT_MINMAX, 2, 1649},
	{56852, R_028A08_PA_SU_LINE_CNTL, 1, 1651},
	{56868, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1652},
	{56887, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1656},
	{56908, R_028A14_VGT_HOS_CNTL, 1, 1657},
	{56921, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{56944, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{56967, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1658},
	{56987, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1659},
	{57007, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1663},
	{57028, R_028A2C_VGT_GROUP_DECR, 1, 1664},
	{57043, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1665},
	{57065, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1671},
	{57087, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1677},
	{57113, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1685},
	{57139, R_028A40_VGT_GS_MODE, 15, 1693},
	{57151, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1708},
	{57170, R_028A48_PA_SC_MODE_CNTL_0, 4, 1710},
	{57188, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1714},
	{57206, R_028A50_VGT_ENHANCE},
	{57218, R_028A54_VGT_GS_PER_ES, 1, 1738},
	{57232, R_028A58_VGT_ES_PER_GS, 1, 1739},
	{57246, R_028A5C_VGT_GS_PER_VS, 1, 1740},
	{57260, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1741},
	{57283, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1742},
	{57306, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1743},
	{57329, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1744},
	{57350, R_028A70_IA_ENHANCE},
	{57361, R_028A74_VGT_DMA_SIZE},
	{57374, R_028A78_VGT_DMA_MAX_SIZE},
	{57391, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1749},
	{57410, R_028A80_WD_ENHANCE},
	{57421, R_028A84_VGT_PRIMITIVEID_EN, 2, 1758},
	{57440, R_028A88_VGT_DMA_NUM_INSTANCES},
	{57462, R_028A8C_VGT_PRIMITIVEID_RESET},
	{57484, R_028A90_VGT_EVENT_INITIATOR, 3, 1760},
	{57504, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1763},
	{57531, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{57556, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{57581, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1764},
	{57600, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1771},
	{57623, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1772},
	{57646, R_028AB4_VGT_REUSE_OFF, 1, 1773},
	{57660, R_028AB8_VGT_VTX_CNT_EN, 1, 1774},
	{57675, R_028ABC_DB_HTILE_SURFACE, 8, 1775},
	{57692, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1783},
	{57719, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1787},
	{57746, R_028AC8_DB_PRELOAD_CONTROL, 4, 1791},
	{57765, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{57791, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1795},
	{57816, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{57844, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{57870, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1796},
	{57895, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{57923, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{57949, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1797},
	{57974, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{58002, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{58028, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1798},
	{58053, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{58081, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{58112, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{58155, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1799},
	{58193, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1800},
	{58213, R_028B50_VGT_TESS_DISTRIBUTION, 4, 1801},
	{58235, R_028B54_VGT_SHADER_STAGES_EN, 10, 1805},
	{58256, R_028B58_VGT_LS_HS_CONFIG, 3, 1815},
	{58273, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1818},
	{58294, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1819},
	{58317, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1820},
	{58340, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1821},
	{58363, R_028B6C_VGT_TF_PARAM, 11, 1822},
	{58376, R_028B70_DB_ALPHA_TO_MASK, 6, 1833},
	{58393, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{58417, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1839},
	{58447, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{58471, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{58501, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{58532, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{58561, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{58591, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1841},
	{58611, R_028B94_VGT_STRMOUT_CONFIG, 7, 1843},
	{58630, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1850},
	{58656, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1854},
	{58682, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1862},
	{58708, R_028BDC_PA_SC_LINE_CNTL, 4, 1870},
	{58724, R_028BE0_PA_SC_AA_CONFIG, 5, 1874},
	{58740, R_028BE4_PA_SU_VTX_CNTL, 3, 1879},
	{58755, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{58778, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{58801, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{58824, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{58847, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1882},
	{58881, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1890},
	{58915, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1898},
	{58949, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1906},
	{58983, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1914},
	{59017, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1922},
	{59051, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1930},
	{59085, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1938},
	{59119, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1946},
	{59153, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1954},
	{59187, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1962},
	{59221, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1970},
	{59255, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 1978},
	{59289, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 1986},
	{59323, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 1994},
	{59357, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2002},
	{59391, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2010},
	{59415, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2012},
	{59439, R_028C40_PA_SC_SHADER_CONTROL, 1, 2014},
	{59460, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2015},
	{59488, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2016},
	{59509, R_028C60_CB_COLOR0_BASE},
	{59524, R_028C64_CB_COLOR0_PITCH, 2, 2017},
	{59540, R_028C68_CB_COLOR0_SLICE, 1, 2019},
	{59556, R_028C6C_CB_COLOR0_VIEW, 2, 2020},
	{59571, R_028C70_CB_COLOR0_INFO, 18, 2022},
	{59586, R_028C74_CB_COLOR0_ATTRIB, 6, 2040},
	{59603, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2046},
	{59625, R_028C7C_CB_COLOR0_CMASK},
	{59641, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2055},
	{59663, R_028C84_CB_COLOR0_FMASK},
	{59679, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2056},
	{59701, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{59723, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{59745, R_028C94_CB_COLOR0_DCC_BASE},
	{59764, R_028C9C_CB_COLOR1_BASE},
	{59779, R_028CA0_CB_COLOR1_PITCH, 2, 2017},
	{59795, R_028CA4_CB_COLOR1_SLICE, 1, 2019},
	{59811, R_028CA8_CB_COLOR1_VIEW, 2, 2020},
	{59826, R_028CAC_CB_COLOR1_INFO, 18, 2022},
	{59841, R_028CB0_CB_COLOR1_ATTRIB, 6, 2040},
	{59858, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2046},
	{59880, R_028CB8_CB_COLOR1_CMASK},
	{59896, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2055},
	{59918, R_028CC0_CB_COLOR1_FMASK},
	{59934, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2056},
	{59956, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{59978, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{60000, R_028CD0_CB_COLOR1_DCC_BASE},
	{60019, R_028CD8_CB_COLOR2_BASE},
	{60034, R_028CDC_CB_COLOR2_PITCH, 2, 2017},
	{60050, R_028CE0_CB_COLOR2_SLICE, 1, 2019},
	{60066, R_028CE4_CB_COLOR2_VIEW, 2, 2020},
	{60081, R_028CE8_CB_COLOR2_INFO, 18, 2022},
	{60096, R_028CEC_CB_COLOR2_ATTRIB, 6, 2040},
	{60113, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2046},
	{60135, R_028CF4_CB_COLOR2_CMASK},
	{60151, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2055},
	{60173, R_028CFC_CB_COLOR2_FMASK},
	{60189, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2056},
	{60211, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{60233, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{60255, R_028D0C_CB_COLOR2_DCC_BASE},
	{60274, R_028D14_CB_COLOR3_BASE},
	{60289, R_028D18_CB_COLOR3_PITCH, 2, 2017},
	{60305, R_028D1C_CB_COLOR3_SLICE, 1, 2019},
	{60321, R_028D20_CB_COLOR3_VIEW, 2, 2020},
	{60336, R_028D24_CB_COLOR3_INFO, 18, 2022},
	{60351, R_028D28_CB_COLOR3_ATTRIB, 6, 2040},
	{60368, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2046},
	{60390, R_028D30_CB_COLOR3_CMASK},
	{60406, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2055},
	{60428, R_028D38_CB_COLOR3_FMASK},
	{60444, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2056},
	{60466, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{60488, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{60510, R_028D48_CB_COLOR3_DCC_BASE},
	{60529, R_028D50_CB_COLOR4_BASE},
	{60544, R_028D54_CB_COLOR4_PITCH, 2, 2017},
	{60560, R_028D58_CB_COLOR4_SLICE, 1, 2019},
	{60576, R_028D5C_CB_COLOR4_VIEW, 2, 2020},
	{60591, R_028D60_CB_COLOR4_INFO, 18, 2022},
	{60606, R_028D64_CB_COLOR4_ATTRIB, 6, 2040},
	{60623, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2046},
	{60645, R_028D6C_CB_COLOR4_CMASK},
	{60661, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2055},
	{60683, R_028D74_CB_COLOR4_FMASK},
	{60699, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2056},
	{60721, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{60743, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{60765, R_028D84_CB_COLOR4_DCC_BASE},
	{60784, R_028D8C_CB_COLOR5_BASE},
	{60799, R_028D90_CB_COLOR5_PITCH, 2, 2017},
	{60815, R_028D94_CB_COLOR5_SLICE, 1, 2019},
	{60831, R_028D98_CB_COLOR5_VIEW, 2, 2020},
	{60846, R_028D9C_CB_COLOR5_INFO, 18, 2022},
	{60861, R_028DA0_CB_COLOR5_ATTRIB, 6, 2040},
	{60878, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2046},
	{60900, R_028DA8_CB_COLOR5_CMASK},
	{60916, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2055},
	{60938, R_028DB0_CB_COLOR5_FMASK},
	{60954, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2056},
	{60976, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{60998, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{61020, R_028DC0_CB_COLOR5_DCC_BASE},
	{61039, R_028DC8_CB_COLOR6_BASE},
	{61054, R_028DCC_CB_COLOR6_PITCH, 2, 2017},
	{61070, R_028DD0_CB_COLOR6_SLICE, 1, 2019},
	{61086, R_028DD4_CB_COLOR6_VIEW, 2, 2020},
	{61101, R_028DD8_CB_COLOR6_INFO, 18, 2022},
	{61116, R_028DDC_CB_COLOR6_ATTRIB, 6, 2040},
	{61133, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2046},
	{61155, R_028DE4_CB_COLOR6_CMASK},
	{61171, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2055},
	{61193, R_028DEC_CB_COLOR6_FMASK},
	{61209, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2056},
	{61231, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{61253, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{61275, R_028DFC_CB_COLOR6_DCC_BASE},
	{61294, R_028E04_CB_COLOR7_BASE},
	{61309, R_028E08_CB_COLOR7_PITCH, 2, 2017},
	{61325, R_028E0C_CB_COLOR7_SLICE, 1, 2019},
	{61341, R_028E10_CB_COLOR7_VIEW, 2, 2020},
	{61356, R_028E14_CB_COLOR7_INFO, 18, 2022},
	{61371, R_028E18_CB_COLOR7_ATTRIB, 6, 2040},
	{61388, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2046},
	{61410, R_028E20_CB_COLOR7_CMASK},
	{61426, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2055},
	{61448, R_028E28_CB_COLOR7_FMASK},
	{61464, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2056},
	{61486, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{61508, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{61530, R_028E38_CB_COLOR7_DCC_BASE},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"STRMOUT_BUFFER_UPDATE\0" /* 321 */
	"DRAW_INDEX_OFFSET_2\0" /* 343 */
	"DRAW_PREAMBLE\0" /* 363 */
	"WRITE_DATA\0" /* 377, 383 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 388 */
	"MEM_SEMAPHORE\0" /* 414 */
	"MPEG_INDEX\0" /* 428, 437 */
	"WAIT_REG_MEM\0" /* 439 */
	"MEM_WRITE\0" /* 452 */
	"INDIRECT_BUFFER_CIK\0" /* 462 */
	"COPY_DATA\0" /* 482 */
	"PFP_SYNC_ME\0" /* 492, 501 */
	"SURFACE_SYNC\0" /* 504 */
	"ME_INITIALIZE\0" /* 517 */
	"COND_WRITE\0" /* 531 */
	"EVENT_WRITE\0" /* 542 */
	"EVENT_WRITE_EOP\0" /* 554 */
	"EVENT_WRITE_EOS\0" /* 570 */
	"ONE_REG_WRITE\0" /* 586 */
	"ACQUIRE_MEM\0" /* 600 */
	"SET_CONFIG_REG\0" /* 612 */
	"SET_CONTEXT_REG\0" /* 627 */
	"SET_SH_REG\0" /* 643 */
	"SET_SH_REG_OFFSET\0" /* 665, 654 */
	"SET_UCONFIG_REG\0" /* 672 */
	"LOAD_CONST_RAM\0" /* 688 */
	"WRITE_CONST_RAM\0" /* 703 */
	"DUMP_CONST_RAM\0" /* 719 */
	"INCREMENT_CE_COUNTER\0" /* 734 */
	"INCREMENT_DE_COUNTER\0" /* 755 */
	"WAIT_ON_CE_COUNTER\0" /* 776 */
	"IT_OPCODE_C\0" /* 795 */
	"CP_DMA\0" /* 807 */
	"DMA_DATA\0" /* 814 */
	"PFP\0" /* 823 */
	"CE\0" /* 827 */
	"DE\0" /* 830 */
	"ENGINE_SEL\0" /* 833 */
	"WR_CONFIRM\0" /* 844 */
	"WR_ONE_ADDR\0" /* 862, 855 */
	"MEM_MAPPED_REGISTER\0" /* 867, 878 */
	"MEMORY_SYNC\0" /* 887 */
	"TC_L2\0" /* 899 */
	"GDS\0" /* 905 */
	"RESERVED\0" /* 909 */
	"MEM_ASYNC\0" /* 918 */
	"DST_SEL\0" /* 928 */
	"SRC_ADDR_LO\0" /* 936 */
	"CP_SYNC\0" /* 948 */
	"SRC_ADDR\0" /* 956 */
	"SRC_ADDR_TC_L2\0" /* 965 */
	"SRC_SEL\0" /* 980 */
	"ENGINE\0" /* 988 */
	"DST_ADDR\0" /* 995 */
	"DST_ADDR_TC_L2\0" /* 1004 */
	"DSL_SEL\0" /* 1019 */
	"SRC_ADDR_HI\0" /* 1027 */
	"DST_ADDR_LO\0" /* 1039 */
	"DST_ADDR_HI\0" /* 1051 */
	"BYTE_COUNT\0" /* 1063 */
	"DISABLE_WR_CONFIRM\0" /* 1074 */
	"NONE\0" /* 1093 */
	"8_IN_16\0" /* 1098 */
	"8_IN_32\0" /* 1106 */
	"8_IN_64\0" /* 1114 */
	"SRC_SWAP\0" /* 1122 */
	"DST_SWAP\0" /* 1131 */
	"MEMORY\0" /* 1140 */
	"SAS\0" /* 1147 */
	"DAS\0" /* 1151 */
	"INCREMENT\0" /* 1155 */
	"NO_INCREMENT\0" /* 1165 */
	"SAIC\0" /* 1178 */
	"DAIC\0" /* 1183 */
	"RAW_WAIT\0" /* 1188 */
	"SDMA_RQ_PENDING\0" /* 1197 */
	"TST_RQ_PENDING\0" /* 1213 */
	"SDMA1_RQ_PENDING\0" /* 1228 */
	"VCE0_RQ_PENDING\0" /* 1245 */
	"VP8_BUSY\0" /* 1261 */
	"SDMA_BUSY\0" /* 1270, 1271 */
	"SDMA1_BUSY\0" /* 1280 */
	"VCE0_BUSY\0" /* 1291 */
	"XDMA_BUSY\0" /* 1301 */
	"CHUB_BUSY\0" /* 1311 */
	"SDMA2_BUSY\0" /* 1321 */
	"SDMA3_BUSY\0" /* 1332 */
	"SAMSCP_BUSY\0" /* 1347, 1343 */
	"ISP_BUSY\0" /* 1355 */
	"VCE1_BUSY\0" /* 1364 */
	"ODE_BUSY\0" /* 1374 */
	"SDMA2_RQ_PENDING\0" /* 1383 */
	"SDMA3_RQ_PENDING\0" /* 1400 */
	"SAMSCP_RQ_PENDING\0" /* 1417 */
	"ISP_RQ_PENDING\0" /* 1435 */
	"VCE1_RQ_PENDING\0" /* 1450 */
	"UVD_RQ_PENDING\0" /* 1466 */
	"SAMMSP_RQ_PENDING\0" /* 1481 */
	"ACP_RQ_PENDING\0" /* 1499 */
	"SMU_RQ_PENDING\0" /* 1514 */
	"GRBM_RQ_PENDING\0" /* 1529 */
	"HI_RQ_PENDING\0" /* 1545 */
	"VMC_BUSY\0" /* 1559 */
	"MCB_BUSY\0" /* 1568, 1569 */
	"MCB_NON_DISPLAY_BUSY\0" /* 1577 */
	"MCC_BUSY\0" /* 1598 */
	"MCD_BUSY\0" /* 1607 */
	"VMC1_BUSY\0" /* 1616 */
	"SEM_BUSY\0" /* 1626 */
	"ACP_BUSY\0" /* 1635 */
	"IH_BUSY\0" /* 1644 */
	"UVD_BUSY\0" /* 1652 */
	"SAMMSP_BUSY\0" /* 1661 */
	"GCATCL2_BUSY\0" /* 1673 */
	"OSATCL2_BUSY\0" /* 1686 */
	"BIF_BUSY\0" /* 1699 */
	"MCC0_BUSY\0" /* 1708 */
	"MCC1_BUSY\0" /* 1718 */
	"MCC2_BUSY\0" /* 1728 */
	"MCC3_BUSY\0" /* 1738 */
	"MCC4_BUSY\0" /* 1748 */
	"MCC5_BUSY\0" /* 1758 */
	"MCC6_BUSY\0" /* 1768 */
	"MCC7_BUSY\0" /* 1778 */
	"MCD0_BUSY\0" /* 1788 */
	"MCD1_BUSY\0" /* 1798 */
	"MCD2_BUSY\0" /* 1808 */
	"MCD3_BUSY\0" /* 1818 */
	"MCD4_BUSY\0" /* 1828 */
	"MCD5_BUSY\0" /* 1838 */
	"MCD6_BUSY\0" /* 1848 */
	"MCD7_BUSY\0" /* 1858 */
	"IDLE\0" /* 1868 */
	"REG_IDLE\0" /* 1873 */
	"RB_EMPTY\0" /* 1882 */
	"RB_FULL\0" /* 1891 */
	"RB_CMD_IDLE\0" /* 1899 */
	"RB_CMD_FULL\0" /* 1911 */
	"IB_CMD_IDLE\0" /* 1923 */
	"IB_CMD_FULL\0" /* 1935 */
	"BLOCK_IDLE\0" /* 1947 */
	"INSIDE_IB\0" /* 1958 */
	"EX_IDLE\0" /* 1968 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 1976 */
	"PACKET_READY\0" /* 2002 */
	"MC_WR_IDLE\0" /* 2015 */
	"SRBM_IDLE\0" /* 2026 */
	"CONTEXT_EMPTY\0" /* 2036 */
	"DELTA_RPTR_FULL\0" /* 2050 */
	"RB_MC_RREQ_IDLE\0" /* 2066 */
	"IB_MC_RREQ_IDLE\0" /* 2082 */
	"MC_RD_IDLE\0" /* 2098 */
	"DELTA_RPTR_EMPTY\0" /* 2109 */
	"MC_RD_RET_STALL\0" /* 2126 */
	"MC_RD_NO_POLL_IDLE\0" /* 2142 */
	"PREV_CMD_IDLE\0" /* 2161 */
	"SEM_IDLE\0" /* 2175 */
	"SEM_REQ_STALL\0" /* 2184 */
	"SEM_RESP_STATE\0" /* 2198 */
	"INT_IDLE\0" /* 2213 */
	"INT_REQ_STALL\0" /* 2222 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 2236 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 2259 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 2282 */
	"ME1PIPE0_RQ_PENDING\0" /* 2305 */
	"ME1PIPE1_RQ_PENDING\0" /* 2325 */
	"ME1PIPE2_RQ_PENDING\0" /* 2345 */
	"ME1PIPE3_RQ_PENDING\0" /* 2365 */
	"ME2PIPE0_RQ_PENDING\0" /* 2385 */
	"ME2PIPE1_RQ_PENDING\0" /* 2405 */
	"ME2PIPE2_RQ_PENDING\0" /* 2425 */
	"ME2PIPE3_RQ_PENDING\0" /* 2445 */
	"RLC_RQ_PENDING\0" /* 2465 */
	"RLC_BUSY\0" /* 2480 */
	"TC_BUSY\0" /* 2489 */
	"TCC_CC_RESIDENT\0" /* 2497 */
	"CPF_BUSY\0" /* 2513 */
	"CPC_BUSY\0" /* 2522 */
	"CPG_BUSY\0" /* 2531 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 2540 */
	"SRBM_RQ_PENDING\0" /* 2563 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 2579 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 2602 */
	"GDS_DMA_RQ_PENDING\0" /* 2625 */
	"DB_CLEAN\0" /* 2644 */
	"CB_CLEAN\0" /* 2653 */
	"TA_BUSY\0" /* 2662 */
	"GDS_BUSY\0" /* 2670 */
	"WD_BUSY_NO_DMA\0" /* 2679 */
	"VGT_BUSY\0" /* 2694 */
	"IA_BUSY_NO_DMA\0" /* 2703 */
	"IA_BUSY\0" /* 2718 */
	"SX_BUSY\0" /* 2726 */
	"WD_BUSY\0" /* 2734 */
	"SPI_BUSY\0" /* 2742 */
	"BCI_BUSY\0" /* 2751 */
	"SC_BUSY\0" /* 2760 */
	"PA_BUSY\0" /* 2768 */
	"DB_BUSY\0" /* 2776 */
	"CP_COHERENCY_BUSY\0" /* 2784 */
	"GUI_ACTIVE\0" /* 2802 */
	"OFFSET_UPDATE_DONE\0" /* 2827, 2813 */
	"DEST_BASE_0_ENA\0" /* 2832 */
	"DEST_BASE_1_ENA\0" /* 2848 */
	"CB0_DEST_BASE_ENA\0" /* 2864 */
	"CB1_DEST_BASE_ENA\0" /* 2882 */
	"CB2_DEST_BASE_ENA\0" /* 2900 */
	"CB3_DEST_BASE_ENA\0" /* 2918 */
	"CB4_DEST_BASE_ENA\0" /* 2936 */
	"CB5_DEST_BASE_ENA\0" /* 2954 */
	"CB6_DEST_BASE_ENA\0" /* 2972 */
	"CB7_DEST_BASE_ENA\0" /* 2990 */
	"DB_DEST_BASE_ENA\0" /* 3008 */
	"DEST_BASE_2_ENA\0" /* 3025 */
	"DEST_BASE_3_ENA\0" /* 3041 */
	"TCL1_ACTION_ENA\0" /* 3057 */
	"TC_ACTION_ENA\0" /* 3073 */
	"CB_ACTION_ENA\0" /* 3087 */
	"DB_ACTION_ENA\0" /* 3101 */
	"SH_KCACHE_ACTION_ENA\0" /* 3115 */
	"SH_ICACHE_ACTION_ENA\0" /* 3136 */
	"COHER_BASE_HI_256B\0" /* 3157 */
	"START_DELAY_COUNT\0" /* 3176 */
	"TC_SD_ACTION_ENA\0" /* 3194 */
	"TC_NC_ACTION_ENA\0" /* 3211 */
	"TCL1_VOL_ACTION_ENA\0" /* 3228 */
	"TC_VOL_ACTION_ENA\0" /* 3248 */
	"TC_WB_ACTION_ENA\0" /* 3266 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 3283 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 3308 */
	"SH_SD_ACTION_ENA\0" /* 3332 */
	"MATCHING_GFX_CNTX\0" /* 3349 */
	"MEID\0" /* 3367 */
	"PHASE1_STATUS\0" /* 3379, 3372 */
	"MEC1_BUSY\0" /* 3386 */
	"MEC2_BUSY\0" /* 3396 */
	"DC0_BUSY\0" /* 3406 */
	"DC1_BUSY\0" /* 3415 */
	"RCIU1_BUSY\0" /* 3424 */
	"RCIU2_BUSY\0" /* 3435 */
	"ROQ1_BUSY\0" /* 3446 */
	"ROQ2_BUSY\0" /* 3456 */
	"TCIU_BUSY\0" /* 3466 */
	"SCRATCH_RAM_BUSY\0" /* 3476 */
	"QU_BUSY\0" /* 3493 */
	"ATCL2IU_BUSY\0" /* 3501 */
	"CPG_CPC_BUSY\0" /* 3514 */
	"CPF_CPC_BUSY\0" /* 3527 */
	"MEC1_LOAD_BUSY\0" /* 3540 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 3555 */
	"MEC1_MUTEX_BUSY\0" /* 3575 */
	"MEC1_MESSAGE_BUSY\0" /* 3591 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 3609 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 3629 */
	"MEC1_IB_QUEUE_BUSY\0" /* 3648 */
	"MEC1_TC_BUSY\0" /* 3667 */
	"MEC1_DMA_BUSY\0" /* 3680 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 3694 */
	"MEC1_PIPE0_BUSY\0" /* 3718 */
	"MEC1_PIPE1_BUSY\0" /* 3734 */
	"MEC1_PIPE2_BUSY\0" /* 3750 */
	"MEC1_PIPE3_BUSY\0" /* 3766 */
	"MEC2_LOAD_BUSY\0" /* 3782 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 3797 */
	"MEC2_MUTEX_BUSY\0" /* 3817 */
	"MEC2_MESSAGE_BUSY\0" /* 3833 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 3851 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 3871 */
	"MEC2_IB_QUEUE_BUSY\0" /* 3890 */
	"MEC2_TC_BUSY\0" /* 3909 */
	"MEC2_DMA_BUSY\0" /* 3922 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 3936 */
	"MEC2_PIPE0_BUSY\0" /* 3960 */
	"MEC2_PIPE1_BUSY\0" /* 3976 */
	"MEC2_PIPE2_BUSY\0" /* 3992 */
	"MEC2_PIPE3_BUSY\0" /* 4008 */
	"RCIU_TX_FREE_STALL\0" /* 4024 */
	"RCIU_PRIV_VIOLATION\0" /* 4043 */
	"TCIU_TX_FREE_STALL\0" /* 4063 */
	"MEC1_DECODING_PACKET\0" /* 4082 */
	"MEC1_WAIT_ON_RCIU\0" /* 4103 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 4121 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 4144 */
	"MEC2_DECODING_PACKET\0" /* 4166 */
	"MEC2_WAIT_ON_RCIU\0" /* 4187 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 4205 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 4228 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 4250 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 4274 */
	"ATCL1_WAITING_ON_TRANS\0" /* 4298 */
	"POST_WPTR_GFX_BUSY\0" /* 4321 */
	"CSF_BUSY\0" /* 4340 */
	"ROQ_ALIGN_BUSY\0" /* 4349 */
	"ROQ_RING_BUSY\0" /* 4364 */
	"ROQ_INDIRECT1_BUSY\0" /* 4378 */
	"ROQ_INDIRECT2_BUSY\0" /* 4397 */
	"ROQ_STATE_BUSY\0" /* 4416 */
	"ROQ_CE_RING_BUSY\0" /* 4431 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 4448 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 4470 */
	"SEMAPHORE_BUSY\0" /* 4492 */
	"INTERRUPT_BUSY\0" /* 4507 */
	"HQD_BUSY\0" /* 4522 */
	"PRT_BUSY\0" /* 4531 */
	"CPF_GFX_BUSY\0" /* 4540 */
	"CPF_CMP_BUSY\0" /* 4553 */
	"GRBM_CPF_STAT_BUSY\0" /* 4566 */
	"CPC_CPF_BUSY\0" /* 4585 */
	"REG_BUS_FIFO_BUSY\0" /* 4598 */
	"CSF_RING_BUSY\0" /* 4616 */
	"CSF_INDIRECT1_BUSY\0" /* 4630 */
	"CSF_INDIRECT2_BUSY\0" /* 4649 */
	"CSF_STATE_BUSY\0" /* 4668 */
	"CSF_CE_INDR1_BUSY\0" /* 4683 */
	"CSF_CE_INDR2_BUSY\0" /* 4701 */
	"CSF_ARBITER_BUSY\0" /* 4719 */
	"CSF_INPUT_BUSY\0" /* 4736 */
	"OUTSTANDING_READ_TAGS\0" /* 4751 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 4773 */
	"HQD_DISPATCH_BUSY\0" /* 4797 */
	"HQD_IQ_TIMER_BUSY\0" /* 4815 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 4833 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 4854 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 4878 */
	"HQD_MESSAGE_BUSY\0" /* 4904 */
	"HQD_PQ_FETCHER_BUSY\0" /* 4921 */
	"HQD_IB_FETCHER_BUSY\0" /* 4941 */
	"HQD_IQ_FETCHER_BUSY\0" /* 4961 */
	"HQD_EOP_FETCHER_BUSY\0" /* 4981 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 5002 */
	"HQD_FETCHER_ARB_BUSY\0" /* 5025 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 5046 */
	"HQD_ROQ_EOP_BUSY\0" /* 5065 */
	"HQD_ROQ_IQ_BUSY\0" /* 5082 */
	"HQD_ROQ_PQ_BUSY\0" /* 5098 */
	"HQD_ROQ_IB_BUSY\0" /* 5114 */
	"HQD_WPTR_POLL_BUSY\0" /* 5130 */
	"HQD_PQ_BUSY\0" /* 5149 */
	"HQD_IB_BUSY\0" /* 5161 */
	"RING_FETCHING_DATA\0" /* 5173 */
	"INDR1_FETCHING_DATA\0" /* 5192 */
	"INDR2_FETCHING_DATA\0" /* 5212 */
	"STATE_FETCHING_DATA\0" /* 5232 */
	"TCIU_WAITING_ON_FREE\0" /* 5252 */
	"TCIU_WAITING_ON_TAGS\0" /* 5273 */
	"COHER_SIZE_HI_256B\0" /* 5294 */
	"PRIM_COUNT\0" /* 5313 */
	"VS_NO_EXTRA_BUFFER\0" /* 5324 */
	"STREAMOUT_FULL_FLUSH\0" /* 5343 */
	"ES_LIMIT\0" /* 5364, 5367 */
	"VERT_REUSE\0" /* 5373 */
	"DI_PT_NONE\0" /* 5384 */
	"DI_PT_POINTLIST\0" /* 5395 */
	"DI_PT_LINELIST\0" /* 5411 */
	"DI_PT_LINESTRIP\0" /* 5426 */
	"DI_PT_TRILIST\0" /* 5442 */
	"DI_PT_TRIFAN\0" /* 5456 */
	"DI_PT_TRISTRIP\0" /* 5469 */
	"DI_PT_UNUSED_0\0" /* 5484 */
	"DI_PT_UNUSED_1\0" /* 5499 */
	"DI_PT_PATCH\0" /* 5514 */
	"DI_PT_LINELIST_ADJ\0" /* 5526 */
	"DI_PT_LINESTRIP_ADJ\0" /* 5545 */
	"DI_PT_TRILIST_ADJ\0" /* 5565 */
	"DI_PT_TRISTRIP_ADJ\0" /* 5583 */
	"DI_PT_UNUSED_3\0" /* 5602 */
	"DI_PT_UNUSED_4\0" /* 5617 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 5632 */
	"DI_PT_RECTLIST\0" /* 5654 */
	"DI_PT_LINELOOP\0" /* 5669 */
	"DI_PT_QUADLIST\0" /* 5684 */
	"DI_PT_QUADSTRIP\0" /* 5699 */
	"DI_PT_POLYGON\0" /* 5715 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 5729 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 5756 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 5783 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 5810 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 5837 */
	"DI_PT_2D_LINE_STRIP\0" /* 5861 */
	"DI_PT_2D_TRI_STRIP\0" /* 5881 */
	"PRIM_TYPE\0" /* 5900 */
	"DI_INDEX_SIZE_16_BIT\0" /* 5910 */
	"DI_INDEX_SIZE_32_BIT\0" /* 5931 */
	"OFFCHIP_BUFFERING\0" /* 5952 */
	"CLIP_VTX_REORDER_ENA\0" /* 5970 */
	"NUM_CLIP_SEQ\0" /* 5991 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 6004 */
	"VE_NAN_PROC_DISABLE\0" /* 6027 */
	"LINE_STIPPLE_VALUE\0" /* 6047 */
	"CURRENT_PTR\0" /* 6066 */
	"CURRENT_COUNT\0" /* 6078 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 6092 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 6117 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 6155 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 6196 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 6219 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 6242 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 6266 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 6296 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 6325 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 6351 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 6380 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 6405 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 6440 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6468 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 6498 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 6525 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 6552 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 6581 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 6610 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 6639 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6667 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 6697 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 6724 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 6752 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 6777 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 6803 */
	"RCIU_STALLED_ON_ME_READ\0" /* 6828 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 6852 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 6877 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 6905 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 6934 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 6960 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 6986 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 7013 */
	"PFP_RCIU_READ_PENDING\0" /* 7039 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 7061 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 7088 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 7110 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 7134 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 7159 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 7182 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 7209 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 7234 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7262 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7287 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 7312 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 7337 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7366 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 7397 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 7425 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 7452 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 7482 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 7528, 7509 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 7536, 7555 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 7563 */
	"APPEND_ACTIVE_PARTITION\0" /* 7589 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 7613 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 7645 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 7672 */
	"DC_BUSY\0" /* 7698 */
	"PFP_BUSY\0" /* 7706 */
	"MEQ_BUSY\0" /* 7715 */
	"ME_BUSY\0" /* 7724 */
	"QUERY_BUSY\0" /* 7732 */
	"SURFACE_SYNC_BUSY\0" /* 7743 */
	"RCIU_BUSY\0" /* 7761 */
	"CPC_CPG_BUSY\0" /* 7771 */
	"CE_BUSY\0" /* 7784 */
	"INSTANCE_INDEX\0" /* 7792 */
	"SH_INDEX\0" /* 7807 */
	"SE_INDEX\0" /* 7816 */
	"SH_BROADCAST_WRITES\0" /* 7825 */
	"INSTANCE_BROADCAST_WRITES\0" /* 7845 */
	"SE_BROADCAST_WRITES\0" /* 7871 */
	"X_8K_DWORDS\0" /* 7891 */
	"X_4K_DWORDS\0" /* 7903 */
	"X_2K_DWORDS\0" /* 7915 */
	"X_1K_DWORDS\0" /* 7927 */
	"OFFCHIP_GRANULARITY\0" /* 7939 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 7959 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 7985 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 8008 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 8033 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 8064 */
	"DISABLE_SCISSOR_FIX\0" /* 8098 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 8118 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 8145 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 8173 */
	"INST_INVALIDATE\0" /* 8208 */
	"DATA_INVALIDATE\0" /* 8224 */
	"INVALIDATE_VOLATILE\0" /* 8240 */
	"RET\0" /* 8260 */
	"RUI\0" /* 8264 */
	"RNG\0" /* 8268 */
	"EN\0" /* 8272 */
	"SQ_EXP_MRT\0" /* 8275 */
	"SQ_EXP_MRTZ\0" /* 8286 */
	"SQ_EXP_NULL\0" /* 8298 */
	"SQ_EXP_POS\0" /* 8310 */
	"SQ_EXP_PARAM\0" /* 8321 */
	"TGT\0" /* 8334 */
	"COMPR\0" /* 8338 */
	"VM\0" /* 8344 */
	"SQ_ENC_EXP_FIELD\0" /* 8347 */
	"ENCODING\0" /* 8364 */
	"ADDRESS\0" /* 8373 */
	"COUNT_HI\0" /* 8381 */
	"BASE_ADDRESS_HI\0" /* 8395, 8390 */
	"STRIDE\0" /* 8406 */
	"CACHE_SWIZZLE\0" /* 8413 */
	"SWIZZLE_ENABLE\0" /* 8427, 8435 */
	"SQ_SEL_0\0" /* 8442 */
	"SQ_SEL_1\0" /* 8451 */
	"SQ_SEL_RESERVED_0\0" /* 8467, 8460 */
	"SQ_SEL_RESERVED_1\0" /* 8485, 8478 */
	"SQ_SEL_X\0" /* 8496 */
	"SQ_SEL_Y\0" /* 8505 */
	"SQ_SEL_Z\0" /* 8514 */
	"SQ_SEL_W\0" /* 8523 */
	"DST_SEL_X\0" /* 8532 */
	"DST_SEL_Y\0" /* 8542 */
	"DST_SEL_Z\0" /* 8552 */
	"DST_SEL_W\0" /* 8562 */
	"BUF_NUM_FORMAT_UNORM\0" /* 8572 */
	"BUF_NUM_FORMAT_SNORM\0" /* 8593 */
	"BUF_NUM_FORMAT_USCALED\0" /* 8614 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 8637 */
	"BUF_NUM_FORMAT_UINT\0" /* 8660 */
	"BUF_NUM_FORMAT_SINT\0" /* 8680 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 8700 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 8725 */
	"NUM_FORMAT\0" /* 8746, 8750 */
	"BUF_DATA_FORMAT_INVALID\0" /* 8757 */
	"BUF_DATA_FORMAT_8\0" /* 8781 */
	"BUF_DATA_FORMAT_16\0" /* 8799 */
	"BUF_DATA_FORMAT_8_8\0" /* 8818 */
	"BUF_DATA_FORMAT_32\0" /* 8838 */
	"BUF_DATA_FORMAT_16_16\0" /* 8857 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 8879 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 8904 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 8929 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 8956 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 8983 */
	"BUF_DATA_FORMAT_32_32\0" /* 9007 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 9029 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 9057 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 9082 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 9110 */
	"DATA_FORMAT\0" /* 9138 */
	"ELEMENT_SIZE\0" /* 9150 */
	"INDEX_STRIDE\0" /* 9163 */
	"ADD_TID_ENABLE\0" /* 9176 */
	"ATC\0" /* 9191 */
	"HASH_ENABLE\0" /* 9195 */
	"HEAP\0" /* 9207 */
	"MTYPE\0" /* 9212 */
	"SQ_RSRC_BUF\0" /* 9218 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 9230 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 9249 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 9268 */
	"MIN_LOD\0" /* 9287 */
	"IMG_DATA_FORMAT_INVALID\0" /* 9295 */
	"IMG_DATA_FORMAT_8\0" /* 9319 */
	"IMG_DATA_FORMAT_16\0" /* 9337 */
	"IMG_DATA_FORMAT_8_8\0" /* 9356 */
	"IMG_DATA_FORMAT_32\0" /* 9376 */
	"IMG_DATA_FORMAT_16_16\0" /* 9395 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 9417 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 9442 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 9467 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 9494 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 9521 */
	"IMG_DATA_FORMAT_32_32\0" /* 9545 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 9567 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 9595 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 9620 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 9648 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 9676 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 9698 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 9722 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 9746 */
	"IMG_DATA_FORMAT_8_24\0" /* 9770 */
	"IMG_DATA_FORMAT_24_8\0" /* 9791 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 9812 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 9837 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 9866 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 9891 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 9917 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 9940 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 9964 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 9991 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 10019 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 10047 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 10075 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 10097 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 10119 */
	"IMG_DATA_FORMAT_BC1\0" /* 10143 */
	"IMG_DATA_FORMAT_BC2\0" /* 10163 */
	"IMG_DATA_FORMAT_BC3\0" /* 10183 */
	"IMG_DATA_FORMAT_BC4\0" /* 10203 */
	"IMG_DATA_FORMAT_BC5\0" /* 10223 */
	"IMG_DATA_FORMAT_BC6\0" /* 10243 */
	"IMG_DATA_FORMAT_BC7\0" /* 10263 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16\0" /* 10283 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32\0" /* 10317 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 10351 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 10380 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 10409 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 10438 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 10467 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 10496 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 10525 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 10556 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 10586 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 10617 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 10647 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 10677 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 10708 */
	"IMG_DATA_FORMAT_4_4\0" /* 10739 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 10759 */
	"IMG_DATA_FORMAT_1\0" /* 10781 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 10799 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 10826 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 10850 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 10876 */
	"IMG_NUM_FORMAT_UNORM\0" /* 10910 */
	"IMG_NUM_FORMAT_SNORM\0" /* 10931 */
	"IMG_NUM_FORMAT_USCALED\0" /* 10952 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 10975 */
	"IMG_NUM_FORMAT_UINT\0" /* 10998 */
	"IMG_NUM_FORMAT_SINT\0" /* 11018 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 11038 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 11063 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 11084 */
	"IMG_NUM_FORMAT_SRGB\0" /* 11110 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 11130 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 11152 */
	"IMG_NUM_FORMAT_UBINT\0" /* 11178 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 11199 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 11223 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 11250 */
	"WIDTH\0" /* 11277 */
	"HEIGHT\0" /* 11283 */
	"PERF_MOD\0" /* 11290 */
	"INTERLACED\0" /* 11299 */
	"BASE_LEVEL\0" /* 11310 */
	"LAST_LEVEL\0" /* 11321 */
	"TILING_INDEX\0" /* 11332 */
	"POW2_PAD\0" /* 11345 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 11354 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 11373 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 11392 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 11411 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 11430 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 11449 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 11468 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 11487 */
	"SQ_RSRC_IMG_1D\0" /* 11506 */
	"SQ_RSRC_IMG_2D\0" /* 11521 */
	"SQ_RSRC_IMG_3D\0" /* 11536 */
	"SQ_RSRC_IMG_CUBE\0" /* 11551 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 11568 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 11589 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 11610 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 11630 */
	"DEPTH\0" /* 11656 */
	"PITCH\0" /* 11662 */
	"BASE_ARRAY\0" /* 11668 */
	"LAST_ARRAY\0" /* 11679 */
	"MIN_LOD_WARN\0" /* 11690 */
	"COUNTER_BANK_ID\0" /* 11703 */
	"LOD_HDW_CNT_EN\0" /* 11719 */
	"COMPRESSION_EN\0" /* 11734 */
	"ALPHA_IS_ON_MSB\0" /* 11749 */
	"COLOR_TRANSFORM\0" /* 11765 */
	"LOST_ALPHA_BITS\0" /* 11781 */
	"LOST_COLOR_BITS\0" /* 11797 */
	"SQ_TEX_WRAP\0" /* 11813 */
	"SQ_TEX_MIRROR\0" /* 11825 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 11839 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 11863 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 11893 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 11918 */
	"SQ_TEX_CLAMP_BORDER\0" /* 11949 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 11969 */
	"CLAMP_X\0" /* 11995 */
	"CLAMP_Y\0" /* 12003 */
	"CLAMP_Z\0" /* 12011 */
	"MAX_ANISO_RATIO\0" /* 12019 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 12035 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 12062 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 12088 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 12115 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 12146 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 12175 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 12205 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 12239 */
	"DEPTH_COMPARE_FUNC\0" /* 12267 */
	"FORCE_UNNORMALIZED\0" /* 12286 */
	"MC_COORD_TRUNC\0" /* 12305 */
	"FORCE_DEGAMMA\0" /* 12320 */
	"TRUNC_COORD\0" /* 12334 */
	"DISABLE_CUBE_WRAP\0" /* 12346 */
	"FILTER_MODE\0" /* 12371, 12364 */
	"COMPAT_MODE\0" /* 12376 */
	"MAX_LOD\0" /* 12388 */
	"PERF_MIP\0" /* 12396 */
	"PERF_Z\0" /* 12405 */
	"LOD_BIAS\0" /* 12412 */
	"LOD_BIAS_SEC\0" /* 12421 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 12448, 12434 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 12457, 12476 */
	"XY_MAG_FILTER\0" /* 12483 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 12497 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 12526 */
	"XY_MIN_FILTER\0" /* 12558 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 12572 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 12593 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 12615 */
	"Z_FILTER\0" /* 12638 */
	"MIP_FILTER\0" /* 12647 */
	"MIP_POINT_PRECLAMP\0" /* 12658 */
	"DISABLE_LSB_CEIL\0" /* 12677 */
	"FILTER_PREC_FIX\0" /* 12694 */
	"ANISO_OVERRIDE\0" /* 12710 */
	"BORDER_COLOR_PTR\0" /* 12725 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 12742 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 12774 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 12807 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 12840 */
	"BORDER_COLOR_TYPE\0" /* 12869 */
	"VS_LOW_THRESHOLD\0" /* 12887 */
	"GS_LOW_THRESHOLD\0" /* 12904 */
	"ES_LOW_THRESHOLD\0" /* 12921 */
	"HS_LOW_THRESHOLD\0" /* 12938 */
	"LS_LOW_THRESHOLD\0" /* 12955 */
	"PS_CU_EN\0" /* 12972, 12975 */
	"VS_CU_EN\0" /* 12981 */
	"GS_CU_EN\0" /* 12990 */
	"ES_CU_EN\0" /* 12999 */
	"LSHS_CU_EN\0" /* 13008 */
	"MAX_WAVE_ID\0" /* 13019 */
	"X_R0\0" /* 13031 */
	"RING_ORDER_TS0\0" /* 13036 */
	"RING_ORDER_TS1\0" /* 13051 */
	"RING_ORDER_TS2\0" /* 13066 */
	"PIPE_ORDER_TS0\0" /* 13081 */
	"PIPE_ORDER_TS1\0" /* 13096 */
	"PIPE_ORDER_TS2\0" /* 13111 */
	"PIPE_ORDER_TS3\0" /* 13126 */
	"TS0_DUR_MULT\0" /* 13141 */
	"TS1_DUR_MULT\0" /* 13154 */
	"TS2_DUR_MULT\0" /* 13167 */
	"TS3_DUR_MULT\0" /* 13180 */
	"TS0_DURATION\0" /* 13193 */
	"TS1_DURATION\0" /* 13206 */
	"TS2_DURATION\0" /* 13219 */
	"GPR_WRITE_PRIORITY\0" /* 13232, 13242 */
	"EXP_PRIORITY_ORDER\0" /* 13251 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 13270 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 13292 */
	"RSRC_MGMT_RESET\0" /* 13314 */
	"X_DELAY_14_CLKS\0" /* 13330 */
	"X_DELAY_16_CLKS\0" /* 13346 */
	"X_DELAY_18_CLKS\0" /* 13362 */
	"X_DELAY_20_CLKS\0" /* 13378 */
	"X_DELAY_22_CLKS\0" /* 13394 */
	"X_DELAY_24_CLKS\0" /* 13410 */
	"X_DELAY_26_CLKS\0" /* 13426 */
	"X_DELAY_28_CLKS\0" /* 13442 */
	"X_DELAY_30_CLKS\0" /* 13458 */
	"X_DELAY_32_CLKS\0" /* 13474 */
	"X_DELAY_34_CLKS\0" /* 13490 */
	"X_DELAY_4_CLKS\0" /* 13506 */
	"X_DELAY_6_CLKS\0" /* 13521 */
	"X_DELAY_8_CLKS\0" /* 13536 */
	"X_DELAY_10_CLKS\0" /* 13551 */
	"X_DELAY_12_CLKS\0" /* 13567 */
	"VTX_DONE_DELAY\0" /* 13583 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 13598 */
	"PC_LIMIT_ENABLE\0" /* 13622 */
	"PC_LIMIT_STRICT\0" /* 13638 */
	"PC_LIMIT_SIZE\0" /* 13654 */
	"TYPE_A\0" /* 13668 */
	"VGPR_A\0" /* 13675 */
	"SGPR_A\0" /* 13682 */
	"LDS_A\0" /* 13689 */
	"WAVES_A\0" /* 13695 */
	"EN_A\0" /* 13703 */
	"TYPE_B\0" /* 13708 */
	"VGPR_B\0" /* 13715 */
	"SGPR_B\0" /* 13722 */
	"LDS_B\0" /* 13729 */
	"WAVES_B\0" /* 13735 */
	"EN_B\0" /* 13743 */
	"MSAA1_X\0" /* 13748 */
	"MSAA1_Y\0" /* 13756 */
	"MSAA2_X\0" /* 13764 */
	"MSAA2_Y\0" /* 13772 */
	"MSAA4_X\0" /* 13780 */
	"MSAA4_Y\0" /* 13788 */
	"MSAA8_X\0" /* 13796 */
	"MSAA8_Y\0" /* 13804 */
	"MSAA16_X\0" /* 13812 */
	"MSAA16_Y\0" /* 13821 */
	"NUM_PIPES\0" /* 13830 */
	"PIPE_INTERLEAVE_SIZE\0" /* 13840 */
	"BANK_INTERLEAVE_SIZE\0" /* 13861 */
	"NUM_SHADER_ENGINES\0" /* 13882 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 13901 */
	"NUM_GPUS\0" /* 13925 */
	"MULTI_GPU_TILE_SIZE\0" /* 13934 */
	"ROW_SIZE\0" /* 13954 */
	"NUM_LOWER_PIPES\0" /* 13963 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 13979 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 14010 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 14038 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 14067 */
	"MICRO_TILE_MODE\0" /* 14096 */
	"ARRAY_LINEAR_GENERAL\0" /* 14112, 14118 */
	"ARRAY_LINEAR_ALIGNED\0" /* 14133 */
	"ARRAY_1D_TILED_THIN1\0" /* 14154 */
	"ARRAY_1D_TILED_THICK\0" /* 14175 */
	"ARRAY_2D_TILED_THIN1\0" /* 14196 */
	"ARRAY_2D_TILED_THICK\0" /* 14217 */
	"ARRAY_2D_TILED_XTHICK\0" /* 14238 */
	"ARRAY_3D_TILED_THIN1\0" /* 14260 */
	"ARRAY_3D_TILED_THICK\0" /* 14281 */
	"ARRAY_3D_TILED_XTHICK\0" /* 14302 */
	"ARRAY_POWER_SAVE\0" /* 14324 */
	"ARRAY_MODE\0" /* 14341 */
	"ADDR_SURF_P2\0" /* 14352 */
	"ADDR_SURF_P2_RESERVED0\0" /* 14365 */
	"ADDR_SURF_P2_RESERVED1\0" /* 14388 */
	"ADDR_SURF_P2_RESERVED2\0" /* 14424, 14411 */
	"X_ADDR_SURF_P4_8X16\0" /* 14434 */
	"X_ADDR_SURF_P4_16X16\0" /* 14454 */
	"X_ADDR_SURF_P4_16X32\0" /* 14475 */
	"X_ADDR_SURF_P4_32X32\0" /* 14496 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 14517 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 14543 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 14569 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 14595 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 14622 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 14649 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 14676 */
	"PIPE_CONFIG\0" /* 14703 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 14715 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 14740 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 14766 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 14792 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 14818 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 14843 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 14868 */
	"TILE_SPLIT\0" /* 14893 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 14904 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 14927 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 14950 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 14973 */
	"BANK_WIDTH\0" /* 14996 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 15007 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 15031 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 15055 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 15079 */
	"BANK_HEIGHT\0" /* 15103 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 15115 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 15140 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 15165 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 15190 */
	"MACRO_TILE_ASPECT\0" /* 15215 */
	"ADDR_SURF_2_BANK\0" /* 15233 */
	"ADDR_SURF_4_BANK\0" /* 15250 */
	"ADDR_SURF_8_BANK\0" /* 15267 */
	"ADDR_SURF_16_BANK\0" /* 15284 */
	"NUM_BANKS\0" /* 15302 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 15312 */
	"MICRO_TILE_MODE_NEW\0" /* 15343 */
	"SAMPLE_SPLIT\0" /* 15363 */
	"MEM_BASE\0" /* 15376 */
	"WAVE_LIMIT\0" /* 15385 */
	"LOCK_LOW_THRESHOLD\0" /* 15396 */
	"VGPRS\0" /* 15415 */
	"SGPRS\0" /* 15421 */
	"FP_32_DENORMS\0" /* 15427 */
	"FP_64_DENORMS\0" /* 15441 */
	"FP_ALL_DENORMS\0" /* 15455 */
	"FLOAT_MODE\0" /* 15470 */
	"PRIV\0" /* 15481 */
	"DX10_CLAMP\0" /* 15486 */
	"DEBUG_MODE\0" /* 15497 */
	"IEEE_MODE\0" /* 15508 */
	"CU_GROUP_DISABLE\0" /* 15518 */
	"CACHE_CTL\0" /* 15535 */
	"CDBG_USER\0" /* 15545 */
	"SCRATCH_EN\0" /* 15555 */
	"USER_SGPR\0" /* 15566 */
	"TRAP_PRESENT\0" /* 15576 */
	"WAVE_CNT_EN\0" /* 15589 */
	"EXTRA_LDS_SIZE\0" /* 15601, 15607 */
	"EXCP_EN\0" /* 15616 */
	"EXCP_EN_CIK\0" /* 15624 */
	"VGPR_COMP_CNT\0" /* 15636, 15646 */
	"CU_GROUP_ENABLE\0" /* 15650 */
	"OC_LDS_EN\0" /* 15666 */
	"SO_BASE0_EN\0" /* 15676 */
	"SO_BASE1_EN\0" /* 15688 */
	"SO_BASE2_EN\0" /* 15700 */
	"SO_BASE3_EN\0" /* 15712 */
	"SO_EN\0" /* 15724 */
	"DISPATCH_DRAW_EN\0" /* 15730 */
	"GROUP_FIFO_DEPTH\0" /* 15747 */
	"TG_SIZE_EN\0" /* 15764 */
	"COMPUTE_SHADER_EN\0" /* 15775 */
	"PARTIAL_TG_EN\0" /* 15793 */
	"FORCE_START_AT_000\0" /* 15807 */
	"ORDERED_APPEND_ENBL\0" /* 15826 */
	"ORDERED_APPEND_MODE\0" /* 15846 */
	"USE_THREAD_DIMENSIONS\0" /* 15866 */
	"ORDER_MODE\0" /* 15888 */
	"DISPATCH_CACHE_CNTL\0" /* 15899 */
	"SCALAR_L1_INV_VOL\0" /* 15919 */
	"VECTOR_L1_INV_VOL\0" /* 15937 */
	"DATA_ATC\0" /* 15955 */
	"RESTORE\0" /* 15964 */
	"NUM_THREAD_FULL\0" /* 15972 */
	"NUM_THREAD_PARTIAL\0" /* 15988 */
	"PIPELINESTAT_ENABLE\0" /* 16007 */
	"PERFCOUNT_ENABLE\0" /* 16027 */
	"INST_ATC\0" /* 16044 */
	"BULKY\0" /* 16053 */
	"TGID_X_EN\0" /* 16059 */
	"TGID_Y_EN\0" /* 16069 */
	"TGID_Z_EN\0" /* 16079 */
	"TIDIG_COMP_CNT\0" /* 16089 */
	"EXCP_EN_MSB\0" /* 16104 */
	"WAVES_PER_SH\0" /* 16116 */
	"WAVES_PER_SH_CIK\0" /* 16129 */
	"TG_PER_CU\0" /* 16146 */
	"LOCK_THRESHOLD\0" /* 16156 */
	"SIMD_DEST_CNTL\0" /* 16171 */
	"FORCE_SIMD_DIST\0" /* 16186 */
	"CU_GROUP_COUNT\0" /* 16202 */
	"SH0_CU_EN\0" /* 16217 */
	"SH1_CU_EN\0" /* 16227 */
	"WAVES\0" /* 16237 */
	"WAVESIZE\0" /* 16243 */
	"SEND_SEID\0" /* 16252 */
	"RESERVED3\0" /* 16262 */
	"RESERVED4\0" /* 16272 */
	"WAVE_ID_BASE\0" /* 16282 */
	"PAYLOAD\0" /* 16295 */
	"IS_EVENT\0" /* 16303 */
	"IS_STATE\0" /* 16312 */
	"PERFCOUNTER_HI\0" /* 16321 */
	"PERF_SEL2\0" /* 16336 */
	"PERF_SEL3\0" /* 16346 */
	"PERF_SEL\0" /* 16356 */
	"PERF_SEL1\0" /* 16365 */
	"CNTR_MODE\0" /* 16375 */
	"DISABLE_AND_RESET\0" /* 16385 */
	"START_COUNTING\0" /* 16403 */
	"STOP_COUNTING\0" /* 16418 */
	"PERFMON_STATE\0" /* 16432 */
	"SPM_PERFMON_STATE\0" /* 16446 */
	"PERFMON_ENABLE_MODE\0" /* 16464 */
	"PERFMON_SAMPLE_ENABLE\0" /* 16484 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 16506 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 16533 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 16560 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 16587 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 16613 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 16639 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 16666 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 16692 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 16718 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 16746 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 16772 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 16798 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 16824 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 16850 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 16877 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 16904 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 16931 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 16957 */
	"PERF_MODE\0" /* 16983 */
	"PERF_MODE1\0" /* 16993 */
	"PERF_MODE3\0" /* 17004 */
	"PERF_MODE2\0" /* 17015 */
	"PERF_SEID_IGNORE_MASK\0" /* 17026 */
	"BIN0_MIN\0" /* 17048 */
	"BIN0_MAX\0" /* 17057 */
	"BIN1_MIN\0" /* 17066 */
	"BIN1_MAX\0" /* 17075 */
	"BIN2_MIN\0" /* 17084 */
	"BIN2_MAX\0" /* 17093 */
	"BIN3_MIN\0" /* 17102 */
	"BIN3_MAX\0" /* 17111 */
	"SQC_BANK_MASK\0" /* 17120 */
	"SQC_CLIENT_MASK\0" /* 17134 */
	"SPM_MODE\0" /* 17150 */
	"SIMD_MASK\0" /* 17159 */
	"PS_EN\0" /* 17169 */
	"VS_EN\0" /* 17175 */
	"GS_EN\0" /* 17181 */
	"ES_EN\0" /* 17187 */
	"HS_EN\0" /* 17193 */
	"LS_EN\0" /* 17199 */
	"CS_EN\0" /* 17205 */
	"CNTR_RATE\0" /* 17211 */
	"DISABLE_FLUSH\0" /* 17221 */
	"SH0_MASK\0" /* 17235 */
	"SH1_MASK\0" /* 17244 */
	"FORCE_EN\0" /* 17253 */
	"PERFCOUNTER_SELECT\0" /* 17262 */
	"PERFCOUNTER_SELECT1\0" /* 17281 */
	"PERFCOUNTER_SELECT2\0" /* 17301 */
	"PERFCOUNTER_SELECT3\0" /* 17321 */
	"OP_FILTER_ENABLE\0" /* 17341 */
	"OP_FILTER_SEL\0" /* 17358 */
	"FORMAT_FILTER_ENABLE\0" /* 17372 */
	"FORMAT_FILTER_SEL\0" /* 17393 */
	"CLEAR_FILTER_ENABLE\0" /* 17411 */
	"CLEAR_FILTER_SEL\0" /* 17431 */
	"MRT_FILTER_ENABLE\0" /* 17448 */
	"MRT_FILTER_SEL\0" /* 17466 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 17481 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 17507 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 17530 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 17558 */
	"DEPTH_CLEAR_ENABLE\0" /* 17583 */
	"STENCIL_CLEAR_ENABLE\0" /* 17602 */
	"DEPTH_COPY\0" /* 17623 */
	"STENCIL_COPY\0" /* 17634 */
	"RESUMMARIZE_ENABLE\0" /* 17647 */
	"STENCIL_COMPRESS_DISABLE\0" /* 17666 */
	"DEPTH_COMPRESS_DISABLE\0" /* 17691 */
	"COPY_CENTROID\0" /* 17714 */
	"COPY_SAMPLE\0" /* 17728 */
	"DECOMPRESS_ENABLE\0" /* 17740 */
	"ZPASS_INCREMENT_DISABLE\0" /* 17758 */
	"PERFECT_ZPASS_COUNTS\0" /* 17782 */
	"SAMPLE_RATE\0" /* 17803 */
	"ZPASS_ENABLE\0" /* 17815 */
	"ZFAIL_ENABLE\0" /* 17828 */
	"SFAIL_ENABLE\0" /* 17841 */
	"DBFAIL_ENABLE\0" /* 17854 */
	"SLICE_EVEN_ENABLE\0" /* 17868 */
	"SLICE_ODD_ENABLE\0" /* 17886 */
	"SLICE_START\0" /* 17903 */
	"SLICE_MAX\0" /* 17915 */
	"Z_READ_ONLY\0" /* 17925 */
	"STENCIL_READ_ONLY\0" /* 17937 */
	"FORCE_OFF\0" /* 17955 */
	"FORCE_ENABLE\0" /* 17965 */
	"FORCE_DISABLE\0" /* 17978 */
	"FORCE_RESERVED\0" /* 17992 */
	"FORCE_HIZ_ENABLE\0" /* 18015, 18007 */
	"FORCE_HIS_ENABLE0\0" /* 18024, 18034 */
	"FORCE_HIS_ENABLE1\0" /* 18042, 18052 */
	"FORCE_SHADER_Z_ORDER\0" /* 18073, 18060 */
	"FAST_Z_DISABLE\0" /* 18081 */
	"FAST_STENCIL_DISABLE\0" /* 18096 */
	"NOOP_CULL_DISABLE\0" /* 18117 */
	"FORCE_COLOR_KILL\0" /* 18135 */
	"FORCE_Z_READ\0" /* 18152 */
	"FORCE_STENCIL_READ\0" /* 18165 */
	"FORCE_FULL_Z_RANGE\0" /* 18184 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 18203 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 18227 */
	"IGNORE_SC_ZRANGE\0" /* 18250 */
	"DISABLE_FULLY_COVERED\0" /* 18267 */
	"FORCE_SUMM_OFF\0" /* 18289 */
	"FORCE_SUMM_MINZ\0" /* 18304 */
	"FORCE_SUMM_MAXZ\0" /* 18320 */
	"FORCE_SUMM_BOTH\0" /* 18336 */
	"FORCE_Z_LIMIT_SUMM\0" /* 18352 */
	"MAX_TILES_IN_DTT\0" /* 18371 */
	"DISABLE_TILE_RATE_TILES\0" /* 18388 */
	"FORCE_Z_DIRTY\0" /* 18412 */
	"FORCE_STENCIL_DIRTY\0" /* 18426 */
	"FORCE_Z_VALID\0" /* 18446 */
	"FORCE_STENCIL_VALID\0" /* 18460 */
	"PRESERVE_COMPRESSION\0" /* 18480, 18489 */
	"PSLC_AUTO\0" /* 18501 */
	"PSLC_ON_HANG_ONLY\0" /* 18511 */
	"PSLC_ASAP\0" /* 18529 */
	"PSLC_COUNTDOWN\0" /* 18539 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 18554 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 18583 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 18614 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 18650 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 18685 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 18713 */
	"DISABLE_REG_SNOOP\0" /* 18735 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 18753 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 18785 */
	"HIZ_ZFUNC\0" /* 18811, 18815 */
	"HIS_SFUNC_FF\0" /* 18821 */
	"HIS_SFUNC_BF\0" /* 18834 */
	"PRESERVE_ZRANGE\0" /* 18847 */
	"PRESERVE_SRESULTS\0" /* 18863 */
	"DISABLE_FAST_PASS\0" /* 18881 */
	"CLEAR\0" /* 18899 */
	"TL_X\0" /* 18905 */
	"TL_Y\0" /* 18910 */
	"BR_X\0" /* 18915 */
	"BR_Y\0" /* 18920 */
	"ADDR5_SWIZZLE_MASK\0" /* 18925 */
	"ARRAY_PRT_TILED_THIN1\0" /* 18944 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 18966 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 18991 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 19018 */
	"Z_INVALID\0" /* 19046 */
	"Z_16\0" /* 19056 */
	"Z_24\0" /* 19061 */
	"Z_32_FLOAT\0" /* 19066 */
	"NUM_SAMPLES\0" /* 19077 */
	"TILE_MODE_INDEX\0" /* 19089 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 19105 */
	"ALLOW_EXPCLEAR\0" /* 19129 */
	"READ_SIZE\0" /* 19144 */
	"TILE_SURFACE_ENABLE\0" /* 19154 */
	"CLEAR_DISALLOWED\0" /* 19174 */
	"ZRANGE_PRECISION\0" /* 19191 */
	"STENCIL_INVALID\0" /* 19208 */
	"STENCIL_8\0" /* 19224 */
	"TILE_STENCIL_DISABLE\0" /* 19234 */
	"PITCH_TILE_MAX\0" /* 19261, 19255 */
	"HEIGHT_TILE_MAX\0" /* 19270 */
	"SLICE_TILE_MAX\0" /* 19286 */
	"WINDOW_X_OFFSET\0" /* 19308, 19301 */
	"WINDOW_Y_OFFSET\0" /* 19324, 19317 */
	"WINDOW_OFFSET_DISABLE\0" /* 19333 */
	"CLIP_RULE\0" /* 19355 */
	"ER_TRI\0" /* 19365 */
	"ER_RECT\0" /* 19372 */
	"ER_LINE_LR\0" /* 19380 */
	"ER_LINE_RL\0" /* 19391 */
	"ER_LINE_TB\0" /* 19402 */
	"ER_LINE_BT\0" /* 19413 */
	"HW_SCREEN_OFFSET_X\0" /* 19424 */
	"HW_SCREEN_OFFSET_Y\0" /* 19443 */
	"TARGET0_ENABLE\0" /* 19462 */
	"TARGET1_ENABLE\0" /* 19477 */
	"TARGET2_ENABLE\0" /* 19492 */
	"TARGET3_ENABLE\0" /* 19507 */
	"TARGET4_ENABLE\0" /* 19522 */
	"TARGET5_ENABLE\0" /* 19537 */
	"TARGET6_ENABLE\0" /* 19552 */
	"TARGET7_ENABLE\0" /* 19567 */
	"OUTPUT0_ENABLE\0" /* 19582 */
	"OUTPUT1_ENABLE\0" /* 19597 */
	"OUTPUT2_ENABLE\0" /* 19612 */
	"OUTPUT3_ENABLE\0" /* 19627 */
	"OUTPUT4_ENABLE\0" /* 19642 */
	"OUTPUT5_ENABLE\0" /* 19657 */
	"OUTPUT6_ENABLE\0" /* 19672 */
	"OUTPUT7_ENABLE\0" /* 19687 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 19702 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 19725 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 19748 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 19771 */
	"RB_MAP_PKR0\0" /* 19794 */
	"RB_MAP_PKR1\0" /* 19806 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 19818 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 19843 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 19868 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 19893 */
	"RB_XSEL2\0" /* 19918 */
	"RB_XSEL\0" /* 19927 */
	"RB_YSEL\0" /* 19935 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 19943 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 19967 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 19991 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 20015 */
	"PKR_MAP\0" /* 20039 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 20047 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 20072 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 20097 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 20122 */
	"PKR_XSEL\0" /* 20147 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 20156 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 20181 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 20206 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 20231 */
	"PKR_YSEL\0" /* 20256 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 20265 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 20291 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 20317 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 20343 */
	"PKR_XSEL2\0" /* 20369 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 20379 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 20402 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 20425 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 20448 */
	"SC_MAP\0" /* 20471 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 20478 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 20512 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 20547 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 20582 */
	"SC_XSEL\0" /* 20617 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 20625 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 20659 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 20694 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 20729 */
	"SC_YSEL\0" /* 20764 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 20772 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 20795 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 20818 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 20841 */
	"SE_MAP\0" /* 20864 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 20871 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 20905 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 20940 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 20975 */
	"SE_XSEL\0" /* 21010 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 21018 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 21052 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 21087 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 21122 */
	"SE_YSEL\0" /* 21157 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 21165 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 21193 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 21221 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 21249 */
	"SE_PAIR_MAP\0" /* 21277 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 21289 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 21328 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 21368 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 21408 */
	"SE_PAIR_XSEL\0" /* 21448 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 21461 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 21500 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 21540 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 21580 */
	"SE_PAIR_YSEL\0" /* 21620 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 21633 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 21660 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 21699 */
	"STENCIL_KEEP\0" /* 21728 */
	"STENCIL_ZERO\0" /* 21741 */
	"STENCIL_ONES\0" /* 21754 */
	"STENCIL_REPLACE_TEST\0" /* 21767 */
	"STENCIL_REPLACE_OP\0" /* 21788 */
	"STENCIL_ADD_CLAMP\0" /* 21807 */
	"STENCIL_SUB_CLAMP\0" /* 21825 */
	"STENCIL_INVERT\0" /* 21843 */
	"STENCIL_ADD_WRAP\0" /* 21858 */
	"STENCIL_SUB_WRAP\0" /* 21875 */
	"STENCIL_AND\0" /* 21892 */
	"STENCIL_OR\0" /* 21904 */
	"STENCIL_XOR\0" /* 21915 */
	"STENCIL_NAND\0" /* 21927 */
	"STENCIL_NOR\0" /* 21940 */
	"STENCIL_XNOR\0" /* 21952 */
	"STENCILFAIL\0" /* 21965 */
	"STENCILZPASS\0" /* 21977 */
	"STENCILZFAIL\0" /* 21990 */
	"STENCILFAIL_BF\0" /* 22003 */
	"STENCILZPASS_BF\0" /* 22018 */
	"STENCILZFAIL_BF\0" /* 22034 */
	"STENCILTESTVAL\0" /* 22050 */
	"STENCILMASK\0" /* 22065 */
	"STENCILWRITEMASK\0" /* 22077 */
	"STENCILOPVAL\0" /* 22094 */
	"STENCILTESTVAL_BF\0" /* 22107 */
	"STENCILMASK_BF\0" /* 22125 */
	"STENCILWRITEMASK_BF\0" /* 22140 */
	"STENCILOPVAL_BF\0" /* 22160 */
	"X_0_0F\0" /* 22176 */
	"DEFAULT_VAL\0" /* 22183 */
	"FLAT_SHADE\0" /* 22195 */
	"CYL_WRAP\0" /* 22206 */
	"PT_SPRITE_TEX\0" /* 22215 */
	"DUP\0" /* 22229 */
	"FP16_INTERP_MODE\0" /* 22233 */
	"USE_DEFAULT_ATTR1\0" /* 22250 */
	"DEFAULT_VAL_ATTR1\0" /* 22268 */
	"PT_SPRITE_TEX_ATTR1\0" /* 22286 */
	"ATTR0_VALID\0" /* 22306 */
	"ATTR1_VALID\0" /* 22318 */
	"VS_EXPORT_COUNT\0" /* 22330 */
	"VS_HALF_PACK\0" /* 22346 */
	"VS_EXPORTS_FOG\0" /* 22359 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 22374 */
	"PERSP_SAMPLE_ENA\0" /* 22394 */
	"PERSP_CENTER_ENA\0" /* 22411 */
	"PERSP_CENTROID_ENA\0" /* 22428 */
	"PERSP_PULL_MODEL_ENA\0" /* 22447 */
	"LINEAR_SAMPLE_ENA\0" /* 22468 */
	"LINEAR_CENTER_ENA\0" /* 22486 */
	"LINEAR_CENTROID_ENA\0" /* 22504 */
	"LINE_STIPPLE_TEX_ENA\0" /* 22524 */
	"POS_X_FLOAT_ENA\0" /* 22545 */
	"POS_Y_FLOAT_ENA\0" /* 22561 */
	"POS_Z_FLOAT_ENA\0" /* 22577 */
	"POS_W_FLOAT_ENA\0" /* 22593 */
	"FRONT_FACE_ENA\0" /* 22609 */
	"ANCILLARY_ENA\0" /* 22624 */
	"SAMPLE_COVERAGE_ENA\0" /* 22638 */
	"POS_FIXED_PT_ENA\0" /* 22658 */
	"FLAT_SHADE_ENA\0" /* 22675 */
	"PNT_SPRITE_ENA\0" /* 22690 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 22705 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 22726 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 22747 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 22768 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 22789 */
	"PNT_SPRITE_OVRD_X\0" /* 22813 */
	"PNT_SPRITE_OVRD_Y\0" /* 22831 */
	"PNT_SPRITE_OVRD_Z\0" /* 22849 */
	"PNT_SPRITE_OVRD_W\0" /* 22867 */
	"PNT_SPRITE_TOP_1\0" /* 22885 */
	"NUM_INTERP\0" /* 22902 */
	"PARAM_GEN\0" /* 22913 */
	"FOG_ADDR\0" /* 22923 */
	"BC_OPTIMIZE_DISABLE\0" /* 22932 */
	"PASS_FOG_THROUGH_PS\0" /* 22952 */
	"PERSP_CENTER_CNTL\0" /* 22972 */
	"PERSP_CENTROID_CNTL\0" /* 22990 */
	"LINEAR_CENTER_CNTL\0" /* 23010 */
	"LINEAR_CENTROID_CNTL\0" /* 23029 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 23050 */
	"POS_FLOAT_LOCATION\0" /* 23099 */
	"POS_FLOAT_ULC\0" /* 23118 */
	"FRONT_FACE_ALL_BITS\0" /* 23132 */
	"NUM_PS_WAVES\0" /* 23152 */
	"NUM_VS_WAVES\0" /* 23165 */
	"NUM_GS_WAVES\0" /* 23178 */
	"NUM_ES_WAVES\0" /* 23191 */
	"NUM_HS_WAVES\0" /* 23204 */
	"NUM_LS_WAVES\0" /* 23217 */
	"SPI_SHADER_NONE\0" /* 23230 */
	"SPI_SHADER_1COMP\0" /* 23246 */
	"SPI_SHADER_2COMP\0" /* 23263 */
	"SPI_SHADER_4COMPRESS\0" /* 23280 */
	"SPI_SHADER_4COMP\0" /* 23301 */
	"POS0_EXPORT_FORMAT\0" /* 23318 */
	"POS1_EXPORT_FORMAT\0" /* 23337 */
	"POS2_EXPORT_FORMAT\0" /* 23356 */
	"POS3_EXPORT_FORMAT\0" /* 23375 */
	"SPI_SHADER_ZERO\0" /* 23394 */
	"SPI_SHADER_32_R\0" /* 23410 */
	"SPI_SHADER_32_GR\0" /* 23426 */
	"SPI_SHADER_32_AR\0" /* 23443 */
	"SPI_SHADER_FP16_ABGR\0" /* 23460 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 23481 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 23505 */
	"SPI_SHADER_UINT16_ABGR\0" /* 23529 */
	"SPI_SHADER_SINT16_ABGR\0" /* 23552 */
	"SPI_SHADER_32_ABGR\0" /* 23575 */
	"Z_EXPORT_FORMAT\0" /* 23594 */
	"COL0_EXPORT_FORMAT\0" /* 23610 */
	"COL1_EXPORT_FORMAT\0" /* 23629 */
	"COL2_EXPORT_FORMAT\0" /* 23648 */
	"COL3_EXPORT_FORMAT\0" /* 23667 */
	"COL4_EXPORT_FORMAT\0" /* 23686 */
	"COL5_EXPORT_FORMAT\0" /* 23705 */
	"COL6_EXPORT_FORMAT\0" /* 23724 */
	"COL7_EXPORT_FORMAT\0" /* 23743 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 23762 */
	"SX_RT_EXPORT_32_R\0" /* 23789 */
	"SX_RT_EXPORT_32_A\0" /* 23807 */
	"SX_RT_EXPORT_10_11_11\0" /* 23825 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 23847 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 23871 */
	"SX_RT_EXPORT_5_6_5\0" /* 23892 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 23911 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 23932 */
	"SX_RT_EXPORT_16_16_GR\0" /* 23953 */
	"SX_RT_EXPORT_16_16_AR\0" /* 23975 */
	"MRT0\0" /* 23997 */
	"MRT1\0" /* 24002 */
	"MRT2\0" /* 24007 */
	"MRT3\0" /* 24012 */
	"MRT4\0" /* 24017 */
	"MRT5\0" /* 24022 */
	"MRT6\0" /* 24027 */
	"MRT7\0" /* 24032 */
	"EXACT\0" /* 24037 */
	"11BIT_FORMAT\0" /* 24043 */
	"10BIT_FORMAT\0" /* 24056 */
	"8BIT_FORMAT\0" /* 24069 */
	"6BIT_FORMAT\0" /* 24081 */
	"5BIT_FORMAT\0" /* 24093 */
	"4BIT_FORMAT\0" /* 24105 */
	"MRT0_EPSILON\0" /* 24117 */
	"MRT1_EPSILON\0" /* 24130 */
	"MRT2_EPSILON\0" /* 24143 */
	"MRT3_EPSILON\0" /* 24156 */
	"MRT4_EPSILON\0" /* 24169 */
	"MRT5_EPSILON\0" /* 24182 */
	"MRT6_EPSILON\0" /* 24195 */
	"MRT7_EPSILON\0" /* 24208 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 24221 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 24244 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 24267 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 24290 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 24313 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 24336 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 24359 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 24382 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 24405 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 24428 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 24451 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 24474 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 24497 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 24520 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 24543 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 24566 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 24589 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 24612 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 24647 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 24682 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 24714 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 24746 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 24778 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 24810 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 24844 */
	"COLOR_SRC_OPT\0" /* 24880 */
	"COLOR_DST_OPT\0" /* 24894 */
	"OPT_COMB_NONE\0" /* 24908 */
	"OPT_COMB_ADD\0" /* 24922 */
	"OPT_COMB_SUBTRACT\0" /* 24935 */
	"OPT_COMB_MIN\0" /* 24953 */
	"OPT_COMB_MAX\0" /* 24966 */
	"OPT_COMB_REVSUBTRACT\0" /* 24979 */
	"OPT_COMB_BLEND_DISABLED\0" /* 25000 */
	"OPT_COMB_SAFE_ADD\0" /* 25024 */
	"COLOR_COMB_FCN\0" /* 25042 */
	"ALPHA_SRC_OPT\0" /* 25057 */
	"ALPHA_DST_OPT\0" /* 25071 */
	"ALPHA_COMB_FCN\0" /* 25085 */
	"BLEND_ZERO\0" /* 25100 */
	"BLEND_ONE\0" /* 25111 */
	"BLEND_SRC_COLOR\0" /* 25121 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 25137 */
	"BLEND_SRC_ALPHA\0" /* 25163 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 25179 */
	"BLEND_DST_ALPHA\0" /* 25205 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 25221 */
	"BLEND_DST_COLOR\0" /* 25247 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 25263 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 25289 */
	"BLEND_CONSTANT_COLOR\0" /* 25314 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 25335 */
	"BLEND_SRC1_COLOR\0" /* 25366 */
	"BLEND_INV_SRC1_COLOR\0" /* 25383 */
	"BLEND_SRC1_ALPHA\0" /* 25404 */
	"BLEND_INV_SRC1_ALPHA\0" /* 25421 */
	"BLEND_CONSTANT_ALPHA\0" /* 25442 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 25463 */
	"COLOR_SRCBLEND\0" /* 25494 */
	"COMB_DST_PLUS_SRC\0" /* 25509 */
	"COMB_SRC_MINUS_DST\0" /* 25527 */
	"COMB_MIN_DST_SRC\0" /* 25546 */
	"COMB_MAX_DST_SRC\0" /* 25563 */
	"COMB_DST_MINUS_SRC\0" /* 25580 */
	"COLOR_DESTBLEND\0" /* 25599 */
	"ALPHA_SRCBLEND\0" /* 25615 */
	"ALPHA_DESTBLEND\0" /* 25630 */
	"SEPARATE_ALPHA_BLEND\0" /* 25646 */
	"DISABLE_ROP3\0" /* 25675, 25667 */
	"SRC_STATE_ID\0" /* 25680 */
	"BASE_ADDR\0" /* 25693 */
	"DI_SRC_SEL_DMA\0" /* 25703 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 25718 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 25739 */
	"DI_SRC_SEL_RESERVED\0" /* 25761 */
	"SOURCE_SELECT\0" /* 25781 */
	"DI_MAJOR_MODE_0\0" /* 25795 */
	"DI_MAJOR_MODE_1\0" /* 25811 */
	"MAJOR_MODE\0" /* 25827 */
	"NOT_EOP\0" /* 25838 */
	"USE_OPAQUE\0" /* 25846 */
	"ADDRESS_LOW\0" /* 25857 */
	"STENCIL_ENABLE\0" /* 25869 */
	"Z_WRITE_ENABLE\0" /* 25884 */
	"DEPTH_BOUNDS_ENABLE\0" /* 25899 */
	"FRAG_NEVER\0" /* 25919 */
	"FRAG_LESS\0" /* 25930 */
	"FRAG_EQUAL\0" /* 25940 */
	"FRAG_LEQUAL\0" /* 25951 */
	"FRAG_GREATER\0" /* 25963 */
	"FRAG_NOTEQUAL\0" /* 25976 */
	"FRAG_GEQUAL\0" /* 25990 */
	"FRAG_ALWAYS\0" /* 26002 */
	"BACKFACE_ENABLE\0" /* 26014 */
	"REF_NEVER\0" /* 26030 */
	"REF_LESS\0" /* 26040 */
	"REF_EQUAL\0" /* 26049 */
	"REF_LEQUAL\0" /* 26059 */
	"REF_GREATER\0" /* 26070 */
	"REF_NOTEQUAL\0" /* 26082 */
	"REF_GEQUAL\0" /* 26095 */
	"REF_ALWAYS\0" /* 26106 */
	"STENCILFUNC\0" /* 26117 */
	"STENCILFUNC_BF\0" /* 26129 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 26144 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 26178 */
	"MAX_ANCHOR_SAMPLES\0" /* 26213 */
	"PS_ITER_SAMPLES\0" /* 26232 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 26248 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 26272 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 26298 */
	"INCOHERENT_EQAA_READS\0" /* 26325 */
	"INTERPOLATE_COMP_Z\0" /* 26347 */
	"INTERPOLATE_SRC_Z\0" /* 26366 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 26384 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 26411 */
	"OVERRASTERIZATION_AMOUNT\0" /* 26438 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 26463 */
	"DISABLE_DUAL_QUAD\0" /* 26494 */
	"DEGAMMA_ENABLE\0" /* 26512 */
	"CB_DISABLE\0" /* 26527 */
	"CB_NORMAL\0" /* 26538 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 26561, 26548 */
	"CB_RESOLVE\0" /* 26572 */
	"CB_FMASK_DECOMPRESS\0" /* 26583 */
	"CB_DCC_DECOMPRESS\0" /* 26603 */
	"X_0X00\0" /* 26621 */
	"X_0X05\0" /* 26628 */
	"X_0X0A\0" /* 26635 */
	"X_0X0F\0" /* 26642 */
	"X_0X11\0" /* 26649 */
	"X_0X22\0" /* 26656 */
	"X_0X33\0" /* 26663 */
	"X_0X44\0" /* 26670 */
	"X_0X50\0" /* 26677 */
	"X_0X55\0" /* 26684 */
	"X_0X5A\0" /* 26691 */
	"X_0X5F\0" /* 26698 */
	"X_0X66\0" /* 26705 */
	"X_0X77\0" /* 26712 */
	"X_0X88\0" /* 26719 */
	"X_0X99\0" /* 26726 */
	"X_0XA0\0" /* 26733 */
	"X_0XA5\0" /* 26740 */
	"X_0XAA\0" /* 26747 */
	"X_0XAF\0" /* 26754 */
	"X_0XBB\0" /* 26761 */
	"X_0XCC\0" /* 26768 */
	"X_0XDD\0" /* 26775 */
	"X_0XEE\0" /* 26782 */
	"X_0XF0\0" /* 26789 */
	"X_0XF5\0" /* 26796 */
	"X_0XFA\0" /* 26803 */
	"X_0XFF\0" /* 26810 */
	"Z_EXPORT_ENABLE\0" /* 26817 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 26833 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 26864 */
	"LATE_Z\0" /* 26893 */
	"EARLY_Z_THEN_LATE_Z\0" /* 26900 */
	"RE_Z\0" /* 26920 */
	"EARLY_Z_THEN_RE_Z\0" /* 26925 */
	"KILL_ENABLE\0" /* 26943 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 26955 */
	"MASK_EXPORT_ENABLE\0" /* 26979 */
	"EXEC_ON_HIER_FAIL\0" /* 26998 */
	"EXEC_ON_NOOP\0" /* 27016 */
	"ALPHA_TO_MASK_DISABLE\0" /* 27029 */
	"DEPTH_BEFORE_SHADER\0" /* 27051 */
	"EXPORT_ANY_Z\0" /* 27071 */
	"EXPORT_LESS_THAN_Z\0" /* 27084 */
	"EXPORT_GREATER_THAN_Z\0" /* 27103 */
	"EXPORT_RESERVED\0" /* 27125 */
	"CONSERVATIVE_Z_EXPORT\0" /* 27141 */
	"DUAL_QUAD_DISABLE\0" /* 27163 */
	"UCP_ENA_0\0" /* 27181 */
	"UCP_ENA_1\0" /* 27191 */
	"UCP_ENA_2\0" /* 27201 */
	"UCP_ENA_3\0" /* 27211 */
	"UCP_ENA_4\0" /* 27221 */
	"UCP_ENA_5\0" /* 27231 */
	"PS_UCP_Y_SCALE_NEG\0" /* 27241 */
	"PS_UCP_MODE\0" /* 27260 */
	"CLIP_DISABLE\0" /* 27272 */
	"UCP_CULL_ONLY_ENA\0" /* 27285 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 27303 */
	"DX_CLIP_SPACE_DEF\0" /* 27326 */
	"DIS_CLIP_ERR_DETECT\0" /* 27344 */
	"VTX_KILL_OR\0" /* 27364 */
	"DX_RASTERIZATION_KILL\0" /* 27376 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 27398 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 27422 */
	"ZCLIP_NEAR_DISABLE\0" /* 27448 */
	"ZCLIP_FAR_DISABLE\0" /* 27467 */
	"CULL_FRONT\0" /* 27485 */
	"CULL_BACK\0" /* 27496 */
	"FACE\0" /* 27506 */
	"X_DISABLE_POLY_MODE\0" /* 27521, 27511 */
	"X_DUAL_MODE\0" /* 27531 */
	"X_DRAW_POINTS\0" /* 27543 */
	"X_DRAW_LINES\0" /* 27557 */
	"X_DRAW_TRIANGLES\0" /* 27570 */
	"POLYMODE_FRONT_PTYPE\0" /* 27587 */
	"POLYMODE_BACK_PTYPE\0" /* 27608 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 27628 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 27653 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 27677 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 27701 */
	"PROVOKING_VTX_LAST\0" /* 27726 */
	"PERSP_CORR_DIS\0" /* 27745 */
	"MULTI_PRIM_IB_ENA\0" /* 27760 */
	"VPORT_X_SCALE_ENA\0" /* 27778 */
	"VPORT_X_OFFSET_ENA\0" /* 27796 */
	"VPORT_Y_SCALE_ENA\0" /* 27815 */
	"VPORT_Y_OFFSET_ENA\0" /* 27833 */
	"VPORT_Z_SCALE_ENA\0" /* 27852 */
	"VPORT_Z_OFFSET_ENA\0" /* 27870 */
	"VTX_XY_FMT\0" /* 27889 */
	"VTX_Z_FMT\0" /* 27900 */
	"VTX_W0_FMT\0" /* 27910 */
	"CLIP_DIST_ENA_0\0" /* 27921 */
	"CLIP_DIST_ENA_1\0" /* 27937 */
	"CLIP_DIST_ENA_2\0" /* 27953 */
	"CLIP_DIST_ENA_3\0" /* 27969 */
	"CLIP_DIST_ENA_4\0" /* 27985 */
	"CLIP_DIST_ENA_5\0" /* 28001 */
	"CLIP_DIST_ENA_6\0" /* 28017 */
	"CLIP_DIST_ENA_7\0" /* 28033 */
	"CULL_DIST_ENA_0\0" /* 28049 */
	"CULL_DIST_ENA_1\0" /* 28065 */
	"CULL_DIST_ENA_2\0" /* 28081 */
	"CULL_DIST_ENA_3\0" /* 28097 */
	"CULL_DIST_ENA_4\0" /* 28113 */
	"CULL_DIST_ENA_5\0" /* 28129 */
	"CULL_DIST_ENA_6\0" /* 28145 */
	"CULL_DIST_ENA_7\0" /* 28161 */
	"USE_VTX_POINT_SIZE\0" /* 28177 */
	"USE_VTX_EDGE_FLAG\0" /* 28196 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 28214 */
	"USE_VTX_VIEWPORT_INDX\0" /* 28241 */
	"USE_VTX_KILL_FLAG\0" /* 28263 */
	"VS_OUT_MISC_VEC_ENA\0" /* 28281 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 28301 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 28324 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 28347 */
	"USE_VTX_GS_CUT_FLAG\0" /* 28372 */
	"USE_VTX_LINE_WIDTH\0" /* 28392 */
	"VTE_XY_INF_DISCARD\0" /* 28411 */
	"VTE_Z_INF_DISCARD\0" /* 28430 */
	"VTE_W_INF_DISCARD\0" /* 28448 */
	"VTE_0XNANINF_IS_0\0" /* 28466 */
	"VTE_XY_NAN_RETAIN\0" /* 28484 */
	"VTE_Z_NAN_RETAIN\0" /* 28502 */
	"VTE_W_NAN_RETAIN\0" /* 28519 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 28536 */
	"VS_XY_NAN_TO_INF\0" /* 28557 */
	"VS_XY_INF_RETAIN\0" /* 28574 */
	"VS_Z_NAN_TO_INF\0" /* 28591 */
	"VS_Z_INF_RETAIN\0" /* 28607 */
	"VS_W_NAN_TO_INF\0" /* 28623 */
	"VS_W_INF_RETAIN\0" /* 28639 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 28655 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 28680 */
	"LINE_STIPPLE_RESET\0" /* 28700 */
	"EXPAND_FULL_LENGTH\0" /* 28719 */
	"FRACTIONAL_ACCUM\0" /* 28738 */
	"DIAMOND_ADJUST\0" /* 28755 */
	"TRIANGLE_FILTER_DISABLE\0" /* 28770 */
	"LINE_FILTER_DISABLE\0" /* 28794 */
	"POINT_FILTER_DISABLE\0" /* 28814 */
	"RECTANGLE_FILTER_DISABLE\0" /* 28835 */
	"TRIANGLE_EXPAND_ENA\0" /* 28860 */
	"LINE_EXPAND_ENA\0" /* 28880 */
	"POINT_EXPAND_ENA\0" /* 28896 */
	"RECTANGLE_EXPAND_ENA\0" /* 28913 */
	"PRIM_EXPAND_CONSTANT\0" /* 28934 */
	"XMAX_RIGHT_EXCLUSION\0" /* 28955 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 28976 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 28998 */
	"MIN_SIZE\0" /* 29023 */
	"MAX_SIZE\0" /* 29032 */
	"LINE_PATTERN\0" /* 29041 */
	"REPEAT_COUNT\0" /* 29054 */
	"PATTERN_BIT_ORDER\0" /* 29067 */
	"AUTO_RESET_CNTL\0" /* 29085 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 29101 */
	"VGT_OUTPATH_TESS_EN\0" /* 29123 */
	"VGT_OUTPATH_PASSTHRU\0" /* 29143 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 29164 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 29185 */
	"PATH_SELECT\0" /* 29206 */
	"TESS_MODE\0" /* 29218 */
	"REUSE_DEPTH\0" /* 29228 */
	"VGT_GRP_3D_POINT\0" /* 29240 */
	"VGT_GRP_3D_LINE\0" /* 29257 */
	"VGT_GRP_3D_TRI\0" /* 29273 */
	"VGT_GRP_3D_RECT\0" /* 29288 */
	"VGT_GRP_3D_QUAD\0" /* 29304 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 29320 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 29344 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 29368 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 29392 */
	"VGT_GRP_2D_FILL_RECT\0" /* 29416 */
	"VGT_GRP_2D_LINE\0" /* 29437 */
	"VGT_GRP_2D_TRI\0" /* 29453 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 29468 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 29492 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 29515 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 29539 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 29559 */
	"VGT_GRP_3D_PATCH\0" /* 29578 */
	"RETAIN_ORDER\0" /* 29595 */
	"RETAIN_QUADS\0" /* 29608 */
	"VGT_GRP_LIST\0" /* 29621 */
	"VGT_GRP_STRIP\0" /* 29634 */
	"VGT_GRP_FAN\0" /* 29648 */
	"VGT_GRP_LOOP\0" /* 29660 */
	"VGT_GRP_POLYGON\0" /* 29673 */
	"PRIM_ORDER\0" /* 29689 */
	"FIRST_DECR\0" /* 29706, 29700 */
	"COMP_X_EN\0" /* 29711 */
	"COMP_Y_EN\0" /* 29721 */
	"COMP_Z_EN\0" /* 29731 */
	"COMP_W_EN\0" /* 29741 */
	"SHIFT\0" /* 29751 */
	"VGT_GRP_INDEX_16\0" /* 29757 */
	"VGT_GRP_INDEX_32\0" /* 29774 */
	"VGT_GRP_UINT_16\0" /* 29791 */
	"VGT_GRP_UINT_32\0" /* 29807 */
	"VGT_GRP_SINT_16\0" /* 29823 */
	"VGT_GRP_SINT_32\0" /* 29839 */
	"VGT_GRP_FLOAT_32\0" /* 29855 */
	"VGT_GRP_AUTO_PRIM\0" /* 29872 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 29890 */
	"X_CONV\0" /* 29916 */
	"Y_CONV\0" /* 29923 */
	"Z_CONV\0" /* 29930 */
	"Z_OFFSET\0" /* 29937 */
	"W_CONV\0" /* 29946 */
	"W_OFFSET\0" /* 29953 */
	"GS_OFF\0" /* 29962 */
	"GS_SCENARIO_A\0" /* 29969 */
	"GS_SCENARIO_B\0" /* 29983 */
	"GS_SCENARIO_G\0" /* 29997 */
	"GS_SCENARIO_C\0" /* 30011 */
	"SPRITE_EN\0" /* 30025 */
	"GS_CUT_1024\0" /* 30035 */
	"GS_CUT_512\0" /* 30047 */
	"GS_CUT_256\0" /* 30058 */
	"GS_CUT_128\0" /* 30069 */
	"CUT_MODE\0" /* 30080 */
	"GS_C_PACK_EN\0" /* 30089 */
	"RESERVED_2\0" /* 30102 */
	"ES_PASSTHRU\0" /* 30113 */
	"COMPUTE_MODE\0" /* 30125 */
	"FAST_COMPUTE_MODE\0" /* 30138 */
	"ELEMENT_INFO_EN\0" /* 30156 */
	"PARTIAL_THD_AT_EOI\0" /* 30172 */
	"SUPPRESS_CUTS\0" /* 30191 */
	"ES_WRITE_OPTIMIZE\0" /* 30205 */
	"GS_WRITE_OPTIMIZE\0" /* 30223 */
	"X_0_OFFCHIP_GS\0" /* 30241 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 30256, 30274 */
	"ES_VERTS_PER_SUBGRP\0" /* 30281 */
	"GS_PRIMS_PER_SUBGRP\0" /* 30301 */
	"MSAA_ENABLE\0" /* 30321 */
	"VPORT_SCISSOR_ENABLE\0" /* 30333 */
	"LINE_STIPPLE_ENABLE\0" /* 30354 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 30374 */
	"WALK_SIZE\0" /* 30399 */
	"WALK_ALIGNMENT\0" /* 30409 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 30424 */
	"WALK_FENCE_ENABLE\0" /* 30449 */
	"WALK_FENCE_SIZE\0" /* 30467 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 30488, 30483 */
	"TILE_COVER_DISABLE\0" /* 30511 */
	"TILE_COVER_NO_SCISSOR\0" /* 30530 */
	"ZMM_LINE_EXTENT\0" /* 30552 */
	"ZMM_LINE_OFFSET\0" /* 30568 */
	"ZMM_RECT_EXTENT\0" /* 30584 */
	"KILL_PIX_POST_HI_Z\0" /* 30600 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 30619 */
	"PS_ITER_SAMPLE\0" /* 30645 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 30660 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 30700 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 30727 */
	"GPU_ID_OVERRIDE\0" /* 30750 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 30766 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 30796 */
	"FORCE_EOV_REZ_ENABLE\0" /* 30820 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 30841 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 30871 */
	"GS_PER_ES\0" /* 30895 */
	"ES_PER_GS\0" /* 30905 */
	"GS_PER_VS\0" /* 30915 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 30925 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 30948 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 30971 */
	"OUTPRIM_TYPE\0" /* 30993 */
	"OUTPRIM_TYPE_1\0" /* 31006 */
	"OUTPRIM_TYPE_2\0" /* 31021 */
	"OUTPRIM_TYPE_3\0" /* 31036 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 31051 */
	"VGT_INDEX_16\0" /* 31074 */
	"VGT_INDEX_32\0" /* 31087 */
	"VGT_INDEX_8\0" /* 31100 */
	"VGT_DMA_SWAP_NONE\0" /* 31112 */
	"VGT_DMA_SWAP_16_BIT\0" /* 31130 */
	"VGT_DMA_SWAP_32_BIT\0" /* 31150 */
	"VGT_DMA_SWAP_WORD\0" /* 31170 */
	"SWAP_MODE\0" /* 31188 */
	"VGT_DMA_BUF_MEM\0" /* 31198 */
	"VGT_DMA_BUF_RING\0" /* 31214 */
	"VGT_DMA_BUF_SETUP\0" /* 31231 */
	"BUF_TYPE\0" /* 31249 */
	"VGT_POLICY_LRU\0" /* 31258 */
	"VGT_POLICY_STREAM\0" /* 31273 */
	"RDREQ_POLICY\0" /* 31291 */
	"RDREQ_POLICY_VI\0" /* 31304 */
	"REQ_PATH\0" /* 31320 */
	"PRIMITIVEID_EN\0" /* 31329 */
	"DISABLE_RESET_ON_EOI\0" /* 31344 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 31365 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 31388 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 31411 */
	"CACHE_FLUSH_TS\0" /* 31434 */
	"CONTEXT_DONE\0" /* 31449 */
	"CACHE_FLUSH\0" /* 31462 */
	"CS_PARTIAL_FLUSH\0" /* 31474 */
	"VGT_STREAMOUT_SYNC\0" /* 31491 */
	"VGT_STREAMOUT_RESET\0" /* 31510 */
	"END_OF_PIPE_INCR_DE\0" /* 31530 */
	"END_OF_PIPE_IB_END\0" /* 31550 */
	"RST_PIX_CNT\0" /* 31569 */
	"VS_PARTIAL_FLUSH\0" /* 31581 */
	"PS_PARTIAL_FLUSH\0" /* 31598 */
	"FLUSH_HS_OUTPUT\0" /* 31615 */
	"FLUSH_LS_OUTPUT\0" /* 31631 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 31647 */
	"ZPASS_DONE\0" /* 31676 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 31687 */
	"PERFCOUNTER_START\0" /* 31713 */
	"PERFCOUNTER_STOP\0" /* 31731 */
	"PIPELINESTAT_START\0" /* 31748 */
	"PIPELINESTAT_STOP\0" /* 31767 */
	"PERFCOUNTER_SAMPLE\0" /* 31785 */
	"FLUSH_ES_OUTPUT\0" /* 31804 */
	"FLUSH_GS_OUTPUT\0" /* 31820 */
	"SAMPLE_PIPELINESTAT\0" /* 31836 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 31856 */
	"SAMPLE_STREAMOUTSTATS\0" /* 31878 */
	"RESET_VTX_CNT\0" /* 31900 */
	"BLOCK_CONTEXT_DONE\0" /* 31914 */
	"CS_CONTEXT_DONE\0" /* 31933 */
	"VGT_FLUSH\0" /* 31949 */
	"SC_SEND_DB_VPZ\0" /* 31959 */
	"BOTTOM_OF_PIPE_TS\0" /* 31974 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 31992 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 32015 */
	"FLUSH_AND_INV_DB_META\0" /* 32040 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 32062 */
	"FLUSH_AND_INV_CB_META\0" /* 32087 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 32109 */
	"THREAD_TRACE_START\0" /* 32137 */
	"THREAD_TRACE_STOP\0" /* 32156 */
	"THREAD_TRACE_MARKER\0" /* 32174 */
	"THREAD_TRACE_FLUSH\0" /* 32194 */
	"THREAD_TRACE_FINISH\0" /* 32213 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 32233 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 32257 */
	"PIXEL_PIPE_STAT_RESET\0" /* 32278 */
	"EVENT_TYPE\0" /* 32300 */
	"EXTENDED_EVENT\0" /* 32311 */
	"RESET_EN\0" /* 32326 */
	"PRIMGROUP_SIZE\0" /* 32335 */
	"PARTIAL_VS_WAVE_ON\0" /* 32350 */
	"SWITCH_ON_EOP\0" /* 32369 */
	"PARTIAL_ES_WAVE_ON\0" /* 32383 */
	"SWITCH_ON_EOI\0" /* 32402 */
	"WD_SWITCH_ON_EOP\0" /* 32416 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 32433 */
	"ITEMSIZE\0" /* 32453 */
	"REUSE_OFF\0" /* 32462 */
	"VTX_CNT_EN\0" /* 32472 */
	"FULL_CACHE\0" /* 32483 */
	"HTILE_USES_PRELOAD_WIN\0" /* 32494 */
	"PRELOAD\0" /* 32517 */
	"PREFETCH_WIDTH\0" /* 32525 */
	"PREFETCH_HEIGHT\0" /* 32540 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 32556 */
	"TC_COMPATIBLE\0" /* 32580 */
	"COMPAREFUNC0\0" /* 32594 */
	"COMPAREVALUE0\0" /* 32607 */
	"COMPAREMASK0\0" /* 32621 */
	"COMPAREFUNC1\0" /* 32634 */
	"COMPAREVALUE1\0" /* 32647 */
	"COMPAREMASK1\0" /* 32661 */
	"START_X\0" /* 32674 */
	"START_Y\0" /* 32682 */
	"MAX_X\0" /* 32690 */
	"MAX_Y\0" /* 32696 */
	"VERTEX_STRIDE\0" /* 32702 */
	"MAX_VERT_OUT\0" /* 32716 */
	"ACCUM_ISOLINE\0" /* 32729 */
	"ACCUM_TRI\0" /* 32743 */
	"ACCUM_QUAD\0" /* 32753 */
	"DONUT_SPLIT\0" /* 32764 */
	"LS_STAGE_OFF\0" /* 32776 */
	"LS_STAGE_ON\0" /* 32789 */
	"CS_STAGE_ON\0" /* 32801 */
	"ES_STAGE_OFF\0" /* 32813 */
	"ES_STAGE_DS\0" /* 32826 */
	"ES_STAGE_REAL\0" /* 32838 */
	"VS_STAGE_REAL\0" /* 32852 */
	"VS_STAGE_DS\0" /* 32866 */
	"VS_STAGE_COPY_SHADER\0" /* 32878 */
	"DYNAMIC_HS\0" /* 32899 */
	"DIS_DEALLOC_ACCUM_0\0" /* 32910 */
	"DIS_DEALLOC_ACCUM_1\0" /* 32930 */
	"VS_WAVE_ID_EN\0" /* 32950 */
	"NUM_PATCHES\0" /* 32964 */
	"HS_NUM_INPUT_CP\0" /* 32976 */
	"HS_NUM_OUTPUT_CP\0" /* 32992 */
	"TESS_ISOLINE\0" /* 33009 */
	"TESS_TRIANGLE\0" /* 33022 */
	"TESS_QUAD\0" /* 33036 */
	"PART_INTEGER\0" /* 33046 */
	"PART_POW2\0" /* 33059 */
	"PART_FRAC_ODD\0" /* 33069 */
	"PART_FRAC_EVEN\0" /* 33083 */
	"PARTITIONING\0" /* 33098 */
	"OUTPUT_POINT\0" /* 33111 */
	"OUTPUT_LINE\0" /* 33124 */
	"OUTPUT_TRIANGLE_CW\0" /* 33136 */
	"OUTPUT_TRIANGLE_CCW\0" /* 33155 */
	"TOPOLOGY\0" /* 33175 */
	"RESERVED_REDUC_AXIS\0" /* 33184 */
	"DEPRECATED\0" /* 33204 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 33215 */
	"DISABLE_DONUTS\0" /* 33237 */
	"VGT_POLICY_BYPASS\0" /* 33252 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 33270 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 33296 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 33322 */
	"DISTRIBUTION_MODE\0" /* 33347 */
	"ALPHA_TO_MASK_ENABLE\0" /* 33365 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 33386 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 33408 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 33430 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 33452 */
	"OFFSET_ROUND\0" /* 33474 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 33487 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 33515 */
	"STREAMOUT_0_EN\0" /* 33543 */
	"STREAMOUT_1_EN\0" /* 33558 */
	"STREAMOUT_2_EN\0" /* 33573 */
	"STREAMOUT_3_EN\0" /* 33588 */
	"RAST_STREAM\0" /* 33603 */
	"RAST_STREAM_MASK\0" /* 33615 */
	"USE_RAST_STREAM_MASK\0" /* 33632 */
	"STREAM_0_BUFFER_EN\0" /* 33653 */
	"STREAM_1_BUFFER_EN\0" /* 33672 */
	"STREAM_2_BUFFER_EN\0" /* 33691 */
	"STREAM_3_BUFFER_EN\0" /* 33710 */
	"DISTANCE_0\0" /* 33729 */
	"DISTANCE_1\0" /* 33740 */
	"DISTANCE_2\0" /* 33751 */
	"DISTANCE_3\0" /* 33762 */
	"DISTANCE_4\0" /* 33773 */
	"DISTANCE_5\0" /* 33784 */
	"DISTANCE_6\0" /* 33795 */
	"DISTANCE_7\0" /* 33806 */
	"DISTANCE_8\0" /* 33817 */
	"DISTANCE_9\0" /* 33828 */
	"DISTANCE_10\0" /* 33839 */
	"DISTANCE_11\0" /* 33851 */
	"DISTANCE_12\0" /* 33863 */
	"DISTANCE_13\0" /* 33875 */
	"DISTANCE_14\0" /* 33887 */
	"DISTANCE_15\0" /* 33899 */
	"EXPAND_LINE_WIDTH\0" /* 33911 */
	"LAST_PIXEL\0" /* 33929 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 33940 */
	"DX10_DIAMOND_TEST_ENA\0" /* 33965 */
	"MSAA_NUM_SAMPLES\0" /* 33987 */
	"AA_MASK_CENTROID_DTMN\0" /* 34004 */
	"MAX_SAMPLE_DIST\0" /* 34026 */
	"MSAA_EXPOSED_SAMPLES\0" /* 34042 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 34063 */
	"PIX_CENTER\0" /* 34086 */
	"X_TRUNCATE\0" /* 34097 */
	"X_ROUND\0" /* 34108 */
	"X_ROUND_TO_EVEN\0" /* 34116 */
	"X_ROUND_TO_ODD\0" /* 34132 */
	"ROUND_MODE\0" /* 34147 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 34158 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 34184 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 34209 */
	"X_16_8_FIXED_POINT_1_2\0" /* 34234 */
	"X_16_8_FIXED_POINT_1\0" /* 34257 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 34278 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 34305 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 34334 */
	"QUANT_MODE\0" /* 34363 */
	"S0_X\0" /* 34374 */
	"S0_Y\0" /* 34379 */
	"S1_X\0" /* 34384 */
	"S1_Y\0" /* 34389 */
	"S2_X\0" /* 34394 */
	"S2_Y\0" /* 34399 */
	"S3_X\0" /* 34404 */
	"S3_Y\0" /* 34409 */
	"S4_X\0" /* 34414 */
	"S4_Y\0" /* 34419 */
	"S5_X\0" /* 34424 */
	"S5_Y\0" /* 34429 */
	"S6_X\0" /* 34434 */
	"S6_Y\0" /* 34439 */
	"S7_X\0" /* 34444 */
	"S7_Y\0" /* 34449 */
	"S8_X\0" /* 34454 */
	"S8_Y\0" /* 34459 */
	"S9_X\0" /* 34464 */
	"S9_Y\0" /* 34469 */
	"S10_X\0" /* 34474 */
	"S10_Y\0" /* 34480 */
	"S11_X\0" /* 34486 */
	"S11_Y\0" /* 34492 */
	"S12_X\0" /* 34498 */
	"S12_Y\0" /* 34504 */
	"S13_X\0" /* 34510 */
	"S13_Y\0" /* 34516 */
	"S14_X\0" /* 34522 */
	"S14_Y\0" /* 34528 */
	"S15_X\0" /* 34534 */
	"S15_Y\0" /* 34540 */
	"AA_MASK_X0Y0\0" /* 34546 */
	"AA_MASK_X1Y0\0" /* 34559 */
	"AA_MASK_X0Y1\0" /* 34572 */
	"AA_MASK_X1Y1\0" /* 34585 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 34598 */
	"VTX_REUSE_DEPTH\0" /* 34627 */
	"DEALLOC_DIST\0" /* 34643 */
	"FMASK_TILE_MAX\0" /* 34656 */
	"ENDIAN_NONE\0" /* 34671 */
	"ENDIAN_8IN16\0" /* 34683 */
	"ENDIAN_8IN32\0" /* 34696 */
	"ENDIAN_8IN64\0" /* 34709 */
	"ENDIAN\0" /* 34722 */
	"COLOR_INVALID\0" /* 34729 */
	"COLOR_8\0" /* 34743 */
	"COLOR_16\0" /* 34751 */
	"COLOR_8_8\0" /* 34760 */
	"COLOR_32\0" /* 34770 */
	"COLOR_16_16\0" /* 34779 */
	"COLOR_10_11_11\0" /* 34791 */
	"COLOR_11_11_10\0" /* 34806 */
	"COLOR_10_10_10_2\0" /* 34821 */
	"COLOR_2_10_10_10\0" /* 34838 */
	"COLOR_8_8_8_8\0" /* 34855 */
	"COLOR_32_32\0" /* 34869 */
	"COLOR_16_16_16_16\0" /* 34881 */
	"COLOR_32_32_32_32\0" /* 34899 */
	"COLOR_5_6_5\0" /* 34917 */
	"COLOR_1_5_5_5\0" /* 34929 */
	"COLOR_5_5_5_1\0" /* 34943 */
	"COLOR_4_4_4_4\0" /* 34957 */
	"COLOR_8_24\0" /* 34971 */
	"COLOR_24_8\0" /* 34982 */
	"COLOR_X24_8_32_FLOAT\0" /* 34993 */
	"NUMBER_UNORM\0" /* 35014 */
	"NUMBER_SNORM\0" /* 35027 */
	"NUMBER_UINT\0" /* 35040 */
	"NUMBER_SINT\0" /* 35052 */
	"NUMBER_SRGB\0" /* 35064 */
	"NUMBER_FLOAT\0" /* 35076 */
	"NUMBER_TYPE\0" /* 35089 */
	"SWAP_STD\0" /* 35101 */
	"SWAP_ALT\0" /* 35110 */
	"SWAP_STD_REV\0" /* 35119 */
	"SWAP_ALT_REV\0" /* 35132 */
	"COMP_SWAP\0" /* 35145 */
	"BLEND_CLAMP\0" /* 35155 */
	"BLEND_BYPASS\0" /* 35167 */
	"SIMPLE_FLOAT\0" /* 35180 */
	"CMASK_IS_LINEAR\0" /* 35193 */
	"FORCE_OPT_AUTO\0" /* 35209 */
	"FORCE_OPT_DISABLE\0" /* 35224 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 35242 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 35270 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 35300 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 35331 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 35359 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 35389 */
	"BLEND_OPT_DONT_RD_DST\0" /* 35420 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 35442 */
	"FMASK_COMPRESSION_DISABLE\0" /* 35466 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 35492 */
	"DCC_ENABLE\0" /* 35518 */
	"CMASK_ADDR_TYPE\0" /* 35529 */
	"FMASK_TILE_MODE_INDEX\0" /* 35545 */
	"FMASK_BANK_HEIGHT\0" /* 35567 */
	"NUM_FRAGMENTS\0" /* 35585 */
	"FORCE_DST_ALPHA_1\0" /* 35599 */
	"KEY_CLEAR_ENABLE\0" /* 35617 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 35634 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 35662 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 35688 */
	"INDEPENDENT_64B_BLOCKS\0" /* 35714 */
	"LOSSY_RGB_PRECISION\0" /* 35737 */
	"LOSSY_ALPHA_PRECISION\0" /* 35757 */
	"CP_DMA_WORD0\0" /* 35779 */
	"CP_DMA_WORD1\0" /* 35792 */
	"CP_DMA_WORD2\0" /* 35805 */
	"CP_DMA_WORD3\0" /* 35818 */
	"COMMAND\0" /* 35831 */
	"DMA_DATA_WORD0\0" /* 35839 */
	"SRBM_STATUS2\0" /* 35854 */
	"SRBM_STATUS\0" /* 35867 */
	"SRBM_STATUS3\0" /* 35879 */
	"SDMA0_STATUS_REG\0" /* 35892 */
	"SDMA1_STATUS_REG\0" /* 35909 */
	"GRBM_STATUS2\0" /* 35926 */
	"GRBM_STATUS\0" /* 35939 */
	"CP_STRMOUT_CNTL\0" /* 35951 */
	"CP_COHER_CNTL\0" /* 35967 */
	"CP_COHER_SIZE\0" /* 35981 */
	"CP_COHER_BASE\0" /* 35995 */
	"GRBM_STATUS_SE0\0" /* 36009 */
	"GRBM_STATUS_SE1\0" /* 36025 */
	"GRBM_STATUS_SE2\0" /* 36041 */
	"GRBM_STATUS_SE3\0" /* 36057 */
	"CP_COHER_BASE_HI\0" /* 36073 */
	"CP_COHER_START_DELAY\0" /* 36090 */
	"CP_COHER_STATUS\0" /* 36111 */
	"CP_CPC_STATUS\0" /* 36127 */
	"CP_CPC_BUSY_STAT\0" /* 36141 */
	"CP_CPC_STALLED_STAT1\0" /* 36158 */
	"CP_CPF_STATUS\0" /* 36179 */
	"CP_CPF_BUSY_STAT\0" /* 36193 */
	"CP_CPF_STALLED_STAT1\0" /* 36210 */
	"CP_COHER_SIZE_HI\0" /* 36231 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 36248 */
	"VGT_CACHE_INVALIDATION\0" /* 36271 */
	"VGT_ESGS_RING_SIZE\0" /* 36294 */
	"VGT_GSVS_RING_SIZE\0" /* 36313 */
	"VGT_GS_VERTEX_REUSE\0" /* 36332 */
	"VGT_PRIMITIVE_TYPE\0" /* 36352 */
	"VGT_INDEX_TYPE\0" /* 36371 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 36386 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 36419 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 36452 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 36485 */
	"VGT_NUM_INDICES\0" /* 36518 */
	"VGT_NUM_INSTANCES\0" /* 36534 */
	"VGT_TF_RING_SIZE\0" /* 36552 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 36569 */
	"VGT_TF_MEMORY_BASE\0" /* 36590 */
	"PA_CL_ENHANCE\0" /* 36609 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 36623 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 36648 */
	"CP_STALLED_STAT3\0" /* 36673 */
	"CP_STALLED_STAT1\0" /* 36690 */
	"CP_STALLED_STAT2\0" /* 36707 */
	"CP_STAT\0" /* 36724 */
	"GRBM_GFX_INDEX\0" /* 36732 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 36747 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 36773 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 36799 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 36825 */
	"PA_SC_ENHANCE\0" /* 36851 */
	"SQC_CACHES\0" /* 36865 */
	"SQ_RANDOM_WAVE_PRI\0" /* 36876 */
	"SQ_EXP_0\0" /* 36895 */
	"TA_CS_BC_BASE_ADDR\0" /* 36904 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 36923 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 36945 */
	"SQ_BUF_RSRC_WORD0\0" /* 36969 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 36987 */
	"SQ_BUF_RSRC_WORD1\0" /* 37010 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 37028 */
	"SQ_BUF_RSRC_WORD2\0" /* 37052 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 37070 */
	"SQ_BUF_RSRC_WORD3\0" /* 37093 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 37111 */
	"SQ_IMG_RSRC_WORD0\0" /* 37135 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 37153 */
	"SQ_IMG_RSRC_WORD1\0" /* 37176 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 37194 */
	"SQ_IMG_RSRC_WORD2\0" /* 37218 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 37236 */
	"SQ_IMG_RSRC_WORD3\0" /* 37259 */
	"SQ_IMG_RSRC_WORD4\0" /* 37277 */
	"SQ_IMG_RSRC_WORD5\0" /* 37295 */
	"SQ_IMG_RSRC_WORD6\0" /* 37313 */
	"SQ_IMG_RSRC_WORD7\0" /* 37331 */
	"SQ_IMG_SAMP_WORD0\0" /* 37349 */
	"SQ_IMG_SAMP_WORD1\0" /* 37367 */
	"SQ_IMG_SAMP_WORD2\0" /* 37385 */
	"SQ_IMG_SAMP_WORD3\0" /* 37403 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 37421 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 37441 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 37466 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 37491 */
	"SPI_PS_MAX_WAVE_ID\0" /* 37516 */
	"SPI_ARB_PRIORITY\0" /* 37535 */
	"SPI_ARB_CYCLES_0\0" /* 37552 */
	"SPI_ARB_CYCLES_1\0" /* 37569 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 37586 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 37608 */
	"DB_ZPASS_COUNT_LOW\0" /* 37630 */
	"DB_ZPASS_COUNT_HI\0" /* 37649 */
	"SPI_CONFIG_CNTL\0" /* 37667 */
	"SPI_CONFIG_CNTL_1\0" /* 37683 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 37701 */
	"DB_SUBTILE_CONTROL\0" /* 37730 */
	"GB_ADDR_CONFIG\0" /* 37749 */
	"GB_TILE_MODE0\0" /* 37764 */
	"GB_TILE_MODE1\0" /* 37778 */
	"GB_TILE_MODE2\0" /* 37792 */
	"GB_TILE_MODE3\0" /* 37806 */
	"GB_TILE_MODE4\0" /* 37820 */
	"GB_TILE_MODE5\0" /* 37834 */
	"GB_TILE_MODE6\0" /* 37848 */
	"GB_TILE_MODE7\0" /* 37862 */
	"GB_TILE_MODE8\0" /* 37876 */
	"GB_TILE_MODE9\0" /* 37890 */
	"GB_TILE_MODE10\0" /* 37904 */
	"GB_TILE_MODE11\0" /* 37919 */
	"GB_TILE_MODE12\0" /* 37934 */
	"GB_TILE_MODE13\0" /* 37949 */
	"GB_TILE_MODE14\0" /* 37964 */
	"GB_TILE_MODE15\0" /* 37979 */
	"GB_TILE_MODE16\0" /* 37994 */
	"GB_TILE_MODE17\0" /* 38009 */
	"GB_TILE_MODE18\0" /* 38024 */
	"GB_TILE_MODE19\0" /* 38039 */
	"GB_TILE_MODE20\0" /* 38054 */
	"GB_TILE_MODE21\0" /* 38069 */
	"GB_TILE_MODE22\0" /* 38084 */
	"GB_TILE_MODE23\0" /* 38099 */
	"GB_TILE_MODE24\0" /* 38114 */
	"GB_TILE_MODE25\0" /* 38129 */
	"GB_TILE_MODE26\0" /* 38144 */
	"GB_TILE_MODE27\0" /* 38159 */
	"GB_TILE_MODE28\0" /* 38174 */
	"GB_TILE_MODE29\0" /* 38189 */
	"GB_TILE_MODE30\0" /* 38204 */
	"GB_TILE_MODE31\0" /* 38219 */
	"GB_MACROTILE_MODE0\0" /* 38234 */
	"GB_MACROTILE_MODE1\0" /* 38253 */
	"GB_MACROTILE_MODE2\0" /* 38272 */
	"GB_MACROTILE_MODE3\0" /* 38291 */
	"GB_MACROTILE_MODE4\0" /* 38310 */
	"GB_MACROTILE_MODE5\0" /* 38329 */
	"GB_MACROTILE_MODE6\0" /* 38348 */
	"GB_MACROTILE_MODE7\0" /* 38367 */
	"GB_MACROTILE_MODE8\0" /* 38386 */
	"GB_MACROTILE_MODE9\0" /* 38405 */
	"GB_MACROTILE_MODE10\0" /* 38424 */
	"GB_MACROTILE_MODE11\0" /* 38444 */
	"GB_MACROTILE_MODE12\0" /* 38464 */
	"GB_MACROTILE_MODE13\0" /* 38484 */
	"GB_MACROTILE_MODE14\0" /* 38504 */
	"GB_MACROTILE_MODE15\0" /* 38524 */
	"SPI_SHADER_TBA_LO_PS\0" /* 38544 */
	"SPI_SHADER_TBA_HI_PS\0" /* 38565 */
	"SPI_SHADER_TMA_LO_PS\0" /* 38586 */
	"SPI_SHADER_TMA_HI_PS\0" /* 38607 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 38628 */
	"SPI_SHADER_PGM_LO_PS\0" /* 38652 */
	"SPI_SHADER_PGM_HI_PS\0" /* 38673 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 38694 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 38718 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 38742 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 38768 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 38794 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 38820 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 38846 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 38872 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 38898 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 38924 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 38950 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 38976 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 39002 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 39029 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 39056 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 39083 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 39110 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 39137 */
	"SPI_SHADER_TBA_LO_VS\0" /* 39164 */
	"SPI_SHADER_TBA_HI_VS\0" /* 39185 */
	"SPI_SHADER_TMA_LO_VS\0" /* 39206 */
	"SPI_SHADER_TMA_HI_VS\0" /* 39227 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 39248 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 39272 */
	"SPI_SHADER_PGM_LO_VS\0" /* 39297 */
	"SPI_SHADER_PGM_HI_VS\0" /* 39318 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 39339 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 39363 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 39387 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 39413 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 39439 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 39465 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 39491 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 39517 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 39543 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 39569 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 39595 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 39621 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 39647 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 39674 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 39701 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 39728 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 39755 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 39782 */
	"SPI_SHADER_TBA_LO_GS\0" /* 39809 */
	"SPI_SHADER_TBA_HI_GS\0" /* 39830 */
	"SPI_SHADER_TMA_LO_GS\0" /* 39851 */
	"SPI_SHADER_TMA_HI_GS\0" /* 39872 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 39893 */
	"SPI_SHADER_PGM_LO_GS\0" /* 39917 */
	"SPI_SHADER_PGM_HI_GS\0" /* 39938 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 39959 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 39983 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 40007 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 40033 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 40059 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 40085 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 40111 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 40137 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 40163 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 40189 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 40215 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 40241 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 40267 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 40294 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 40321 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 40348 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 40375 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 40402 */
	"SPI_SHADER_TBA_LO_ES\0" /* 40429 */
	"SPI_SHADER_TBA_HI_ES\0" /* 40450 */
	"SPI_SHADER_TMA_LO_ES\0" /* 40471 */
	"SPI_SHADER_TMA_HI_ES\0" /* 40492 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 40513 */
	"SPI_SHADER_PGM_LO_ES\0" /* 40537 */
	"SPI_SHADER_PGM_HI_ES\0" /* 40558 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 40579 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 40603 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 40627 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 40653 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 40679 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 40705 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 40731 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 40757 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 40783 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 40809 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 40835 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 40861 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 40887 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 40914 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 40941 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 40968 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 40995 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 41022 */
	"SPI_SHADER_TBA_LO_HS\0" /* 41049 */
	"SPI_SHADER_TBA_HI_HS\0" /* 41070 */
	"SPI_SHADER_TMA_LO_HS\0" /* 41091 */
	"SPI_SHADER_TMA_HI_HS\0" /* 41112 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 41133 */
	"SPI_SHADER_PGM_LO_HS\0" /* 41157 */
	"SPI_SHADER_PGM_HI_HS\0" /* 41178 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 41199 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 41223 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 41247 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 41273 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 41299 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 41325 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 41351 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 41377 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 41403 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 41429 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 41455 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 41481 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 41507 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 41534 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 41561 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 41588 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 41615 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 41642 */
	"SPI_SHADER_TBA_LO_LS\0" /* 41669 */
	"SPI_SHADER_TBA_HI_LS\0" /* 41690 */
	"SPI_SHADER_TMA_LO_LS\0" /* 41711 */
	"SPI_SHADER_TMA_HI_LS\0" /* 41732 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 41753 */
	"SPI_SHADER_PGM_LO_LS\0" /* 41777 */
	"SPI_SHADER_PGM_HI_LS\0" /* 41798 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 41819 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 41843 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 41867 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 41893 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 41919 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 41945 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 41971 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 41997 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 42023 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 42049 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 42075 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 42101 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 42127 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 42154 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 42181 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 42208 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 42235 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 42262 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 42289 */
	"COMPUTE_DIM_X\0" /* 42316 */
	"COMPUTE_DIM_Y\0" /* 42330 */
	"COMPUTE_DIM_Z\0" /* 42344 */
	"COMPUTE_START_X\0" /* 42358 */
	"COMPUTE_START_Y\0" /* 42374 */
	"COMPUTE_START_Z\0" /* 42390 */
	"COMPUTE_NUM_THREAD_X\0" /* 42406 */
	"COMPUTE_NUM_THREAD_Y\0" /* 42427 */
	"COMPUTE_NUM_THREAD_Z\0" /* 42448 */
	"COMPUTE_MAX_WAVE_ID\0" /* 42469 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 42489 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 42517 */
	"COMPUTE_PGM_LO\0" /* 42542 */
	"COMPUTE_PGM_HI\0" /* 42557 */
	"COMPUTE_TBA_LO\0" /* 42572 */
	"COMPUTE_TBA_HI\0" /* 42587 */
	"COMPUTE_TMA_LO\0" /* 42602 */
	"COMPUTE_TMA_HI\0" /* 42617 */
	"COMPUTE_PGM_RSRC1\0" /* 42632 */
	"COMPUTE_PGM_RSRC2\0" /* 42650 */
	"COMPUTE_VMID\0" /* 42668 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 42681 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 42705 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 42736 */
	"COMPUTE_TMPRING_SIZE\0" /* 42767 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 42788 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 42819 */
	"COMPUTE_RESTART_X\0" /* 42850 */
	"COMPUTE_RESTART_Y\0" /* 42868 */
	"COMPUTE_RESTART_Z\0" /* 42886 */
	"COMPUTE_MISC_RESERVED\0" /* 42904 */
	"COMPUTE_DISPATCH_ID\0" /* 42926 */
	"COMPUTE_THREADGROUP_ID\0" /* 42946 */
	"COMPUTE_RELAUNCH\0" /* 42969 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 42986 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 43015 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 43044 */
	"COMPUTE_USER_DATA_0\0" /* 43073 */
	"COMPUTE_USER_DATA_1\0" /* 43093 */
	"COMPUTE_USER_DATA_2\0" /* 43113 */
	"COMPUTE_USER_DATA_3\0" /* 43133 */
	"COMPUTE_USER_DATA_4\0" /* 43153 */
	"COMPUTE_USER_DATA_5\0" /* 43173 */
	"COMPUTE_USER_DATA_6\0" /* 43193 */
	"COMPUTE_USER_DATA_7\0" /* 43213 */
	"COMPUTE_USER_DATA_8\0" /* 43233 */
	"COMPUTE_USER_DATA_9\0" /* 43253 */
	"COMPUTE_USER_DATA_10\0" /* 43273 */
	"COMPUTE_USER_DATA_11\0" /* 43294 */
	"COMPUTE_USER_DATA_12\0" /* 43315 */
	"COMPUTE_USER_DATA_13\0" /* 43336 */
	"COMPUTE_USER_DATA_14\0" /* 43357 */
	"COMPUTE_USER_DATA_15\0" /* 43378 */
	"COMPUTE_NOWHERE\0" /* 43399 */
	"CPG_PERFCOUNTER1_LO\0" /* 43415 */
	"CPG_PERFCOUNTER1_HI\0" /* 43435 */
	"CPG_PERFCOUNTER0_LO\0" /* 43455 */
	"CPG_PERFCOUNTER0_HI\0" /* 43475 */
	"CPC_PERFCOUNTER1_LO\0" /* 43495 */
	"CPC_PERFCOUNTER1_HI\0" /* 43515 */
	"CPC_PERFCOUNTER0_LO\0" /* 43535 */
	"CPC_PERFCOUNTER0_HI\0" /* 43555 */
	"CPF_PERFCOUNTER1_LO\0" /* 43575 */
	"CPF_PERFCOUNTER1_HI\0" /* 43595 */
	"CPF_PERFCOUNTER0_LO\0" /* 43615 */
	"CPF_PERFCOUNTER0_HI\0" /* 43635 */
	"GRBM_PERFCOUNTER0_LO\0" /* 43655 */
	"GRBM_PERFCOUNTER0_HI\0" /* 43676 */
	"GRBM_PERFCOUNTER1_LO\0" /* 43697 */
	"GRBM_PERFCOUNTER1_HI\0" /* 43718 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 43739 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 43763 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 43787 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 43811 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 43835 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 43859 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 43883 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 43907 */
	"WD_PERFCOUNTER0_LO\0" /* 43931 */
	"WD_PERFCOUNTER0_HI\0" /* 43950 */
	"WD_PERFCOUNTER1_LO\0" /* 43969 */
	"WD_PERFCOUNTER1_HI\0" /* 43988 */
	"WD_PERFCOUNTER2_LO\0" /* 44007 */
	"WD_PERFCOUNTER2_HI\0" /* 44026 */
	"WD_PERFCOUNTER3_LO\0" /* 44045 */
	"WD_PERFCOUNTER3_HI\0" /* 44064 */
	"IA_PERFCOUNTER0_LO\0" /* 44083 */
	"IA_PERFCOUNTER0_HI\0" /* 44102 */
	"IA_PERFCOUNTER1_LO\0" /* 44121 */
	"IA_PERFCOUNTER1_HI\0" /* 44140 */
	"IA_PERFCOUNTER2_LO\0" /* 44159 */
	"IA_PERFCOUNTER2_HI\0" /* 44178 */
	"IA_PERFCOUNTER3_LO\0" /* 44197 */
	"IA_PERFCOUNTER3_HI\0" /* 44216 */
	"VGT_PERFCOUNTER0_LO\0" /* 44235 */
	"VGT_PERFCOUNTER0_HI\0" /* 44255 */
	"VGT_PERFCOUNTER1_LO\0" /* 44275 */
	"VGT_PERFCOUNTER1_HI\0" /* 44295 */
	"VGT_PERFCOUNTER2_LO\0" /* 44315 */
	"VGT_PERFCOUNTER2_HI\0" /* 44335 */
	"VGT_PERFCOUNTER3_LO\0" /* 44355 */
	"VGT_PERFCOUNTER3_HI\0" /* 44375 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 44395 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 44417 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 44439 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 44461 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 44483 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 44505 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 44527 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 44549 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 44571 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 44593 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 44615 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 44637 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 44659 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 44681 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 44703 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 44725 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 44747 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 44769 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 44791 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 44813 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 44835 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 44857 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 44879 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 44901 */
	"SPI_PERFCOUNTER0_HI\0" /* 44923 */
	"SPI_PERFCOUNTER0_LO\0" /* 44943 */
	"SPI_PERFCOUNTER1_HI\0" /* 44963 */
	"SPI_PERFCOUNTER1_LO\0" /* 44983 */
	"SPI_PERFCOUNTER2_HI\0" /* 45003 */
	"SPI_PERFCOUNTER2_LO\0" /* 45023 */
	"SPI_PERFCOUNTER3_HI\0" /* 45043 */
	"SPI_PERFCOUNTER3_LO\0" /* 45063 */
	"SPI_PERFCOUNTER4_HI\0" /* 45083 */
	"SPI_PERFCOUNTER4_LO\0" /* 45103 */
	"SPI_PERFCOUNTER5_HI\0" /* 45123 */
	"SPI_PERFCOUNTER5_LO\0" /* 45143 */
	"SQ_PERFCOUNTER0_LO\0" /* 45163 */
	"SQ_PERFCOUNTER0_HI\0" /* 45182 */
	"SQ_PERFCOUNTER1_LO\0" /* 45201 */
	"SQ_PERFCOUNTER1_HI\0" /* 45220 */
	"SQ_PERFCOUNTER2_LO\0" /* 45239 */
	"SQ_PERFCOUNTER2_HI\0" /* 45258 */
	"SQ_PERFCOUNTER3_LO\0" /* 45277 */
	"SQ_PERFCOUNTER3_HI\0" /* 45296 */
	"SQ_PERFCOUNTER4_LO\0" /* 45315 */
	"SQ_PERFCOUNTER4_HI\0" /* 45334 */
	"SQ_PERFCOUNTER5_LO\0" /* 45353 */
	"SQ_PERFCOUNTER5_HI\0" /* 45372 */
	"SQ_PERFCOUNTER6_LO\0" /* 45391 */
	"SQ_PERFCOUNTER6_HI\0" /* 45410 */
	"SQ_PERFCOUNTER7_LO\0" /* 45429 */
	"SQ_PERFCOUNTER7_HI\0" /* 45448 */
	"SQ_PERFCOUNTER8_LO\0" /* 45467 */
	"SQ_PERFCOUNTER8_HI\0" /* 45486 */
	"SQ_PERFCOUNTER9_LO\0" /* 45505 */
	"SQ_PERFCOUNTER9_HI\0" /* 45524 */
	"SQ_PERFCOUNTER10_LO\0" /* 45543 */
	"SQ_PERFCOUNTER10_HI\0" /* 45563 */
	"SQ_PERFCOUNTER11_LO\0" /* 45583 */
	"SQ_PERFCOUNTER11_HI\0" /* 45603 */
	"SQ_PERFCOUNTER12_LO\0" /* 45623 */
	"SQ_PERFCOUNTER12_HI\0" /* 45643 */
	"SQ_PERFCOUNTER13_LO\0" /* 45663 */
	"SQ_PERFCOUNTER13_HI\0" /* 45683 */
	"SQ_PERFCOUNTER14_LO\0" /* 45703 */
	"SQ_PERFCOUNTER14_HI\0" /* 45723 */
	"SQ_PERFCOUNTER15_LO\0" /* 45743 */
	"SQ_PERFCOUNTER15_HI\0" /* 45763 */
	"SX_PERFCOUNTER0_LO\0" /* 45783 */
	"SX_PERFCOUNTER0_HI\0" /* 45802 */
	"SX_PERFCOUNTER1_LO\0" /* 45821 */
	"SX_PERFCOUNTER1_HI\0" /* 45840 */
	"SX_PERFCOUNTER2_LO\0" /* 45859 */
	"SX_PERFCOUNTER2_HI\0" /* 45878 */
	"SX_PERFCOUNTER3_LO\0" /* 45897 */
	"SX_PERFCOUNTER3_HI\0" /* 45916 */
	"GDS_PERFCOUNTER0_LO\0" /* 45935 */
	"GDS_PERFCOUNTER0_HI\0" /* 45955 */
	"GDS_PERFCOUNTER1_LO\0" /* 45975 */
	"GDS_PERFCOUNTER1_HI\0" /* 45995 */
	"GDS_PERFCOUNTER2_LO\0" /* 46015 */
	"GDS_PERFCOUNTER2_HI\0" /* 46035 */
	"GDS_PERFCOUNTER3_LO\0" /* 46055 */
	"GDS_PERFCOUNTER3_HI\0" /* 46075 */
	"TA_PERFCOUNTER0_LO\0" /* 46095 */
	"TA_PERFCOUNTER0_HI\0" /* 46114 */
	"TA_PERFCOUNTER1_LO\0" /* 46133 */
	"TA_PERFCOUNTER1_HI\0" /* 46152 */
	"TD_PERFCOUNTER0_LO\0" /* 46171 */
	"TD_PERFCOUNTER0_HI\0" /* 46190 */
	"TD_PERFCOUNTER1_LO\0" /* 46209 */
	"TD_PERFCOUNTER1_HI\0" /* 46228 */
	"TCP_PERFCOUNTER0_LO\0" /* 46247 */
	"TCP_PERFCOUNTER0_HI\0" /* 46267 */
	"TCP_PERFCOUNTER1_LO\0" /* 46287 */
	"TCP_PERFCOUNTER1_HI\0" /* 46307 */
	"TCP_PERFCOUNTER2_LO\0" /* 46327 */
	"TCP_PERFCOUNTER2_HI\0" /* 46347 */
	"TCP_PERFCOUNTER3_LO\0" /* 46367 */
	"TCP_PERFCOUNTER3_HI\0" /* 46387 */
	"TCC_PERFCOUNTER0_LO\0" /* 46407 */
	"TCC_PERFCOUNTER0_HI\0" /* 46427 */
	"TCC_PERFCOUNTER1_LO\0" /* 46447 */
	"TCC_PERFCOUNTER1_HI\0" /* 46467 */
	"TCC_PERFCOUNTER2_LO\0" /* 46487 */
	"TCC_PERFCOUNTER2_HI\0" /* 46507 */
	"TCC_PERFCOUNTER3_LO\0" /* 46527 */
	"TCC_PERFCOUNTER3_HI\0" /* 46547 */
	"TCA_PERFCOUNTER0_LO\0" /* 46567 */
	"TCA_PERFCOUNTER0_HI\0" /* 46587 */
	"TCA_PERFCOUNTER1_LO\0" /* 46607 */
	"TCA_PERFCOUNTER1_HI\0" /* 46627 */
	"TCA_PERFCOUNTER2_LO\0" /* 46647 */
	"TCA_PERFCOUNTER2_HI\0" /* 46667 */
	"TCA_PERFCOUNTER3_LO\0" /* 46687 */
	"TCA_PERFCOUNTER3_HI\0" /* 46707 */
	"CB_PERFCOUNTER0_LO\0" /* 46727 */
	"CB_PERFCOUNTER0_HI\0" /* 46746 */
	"CB_PERFCOUNTER1_LO\0" /* 46765 */
	"CB_PERFCOUNTER1_HI\0" /* 46784 */
	"CB_PERFCOUNTER2_LO\0" /* 46803 */
	"CB_PERFCOUNTER2_HI\0" /* 46822 */
	"CB_PERFCOUNTER3_LO\0" /* 46841 */
	"CB_PERFCOUNTER3_HI\0" /* 46860 */
	"DB_PERFCOUNTER0_LO\0" /* 46879 */
	"DB_PERFCOUNTER0_HI\0" /* 46898 */
	"DB_PERFCOUNTER1_LO\0" /* 46917 */
	"DB_PERFCOUNTER1_HI\0" /* 46936 */
	"DB_PERFCOUNTER2_LO\0" /* 46955 */
	"DB_PERFCOUNTER2_HI\0" /* 46974 */
	"DB_PERFCOUNTER3_LO\0" /* 46993 */
	"DB_PERFCOUNTER3_HI\0" /* 47012 */
	"RLC_PERFCOUNTER0_LO\0" /* 47031 */
	"RLC_PERFCOUNTER0_HI\0" /* 47051 */
	"RLC_PERFCOUNTER1_LO\0" /* 47071 */
	"RLC_PERFCOUNTER1_HI\0" /* 47091 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 47111 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 47135 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 47160 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 47184 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 47208 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 47233 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 47257 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 47282 */
	"CP_PERFMON_CNTL\0" /* 47306 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 47322 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 47346 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 47371 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 47396 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 47424 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 47452 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 47480 */
	"WD_PERFCOUNTER0_SELECT\0" /* 47508 */
	"WD_PERFCOUNTER1_SELECT\0" /* 47531 */
	"WD_PERFCOUNTER2_SELECT\0" /* 47554 */
	"WD_PERFCOUNTER3_SELECT\0" /* 47577 */
	"IA_PERFCOUNTER0_SELECT\0" /* 47600 */
	"IA_PERFCOUNTER1_SELECT\0" /* 47623 */
	"IA_PERFCOUNTER2_SELECT\0" /* 47646 */
	"IA_PERFCOUNTER3_SELECT\0" /* 47669 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 47692 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 47716 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 47740 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 47764 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 47788 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 47812 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 47837 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 47862 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 47888 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 47914 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 47941 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 47967 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 47994 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 48020 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 48046 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 48072 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 48099 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 48125 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 48151 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 48177 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 48203 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 48229 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 48255 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 48281 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 48305 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 48329 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 48353 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 48377 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 48402 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 48427 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 48452 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 48477 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 48501 */
	"SPI_PERFCOUNTER_BINS\0" /* 48525 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 48546 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 48569 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 48592 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 48615 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 48638 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 48661 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 48684 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 48707 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 48730 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 48753 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 48776 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 48800 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 48824 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 48848 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 48872 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 48896 */
	"SQ_PERFCOUNTER_CTRL\0" /* 48920 */
	"SQ_PERFCOUNTER_MASK\0" /* 48940 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 48960 */
	"SX_PERFCOUNTER0_SELECT\0" /* 48981 */
	"SX_PERFCOUNTER1_SELECT\0" /* 49004 */
	"SX_PERFCOUNTER2_SELECT\0" /* 49027 */
	"SX_PERFCOUNTER3_SELECT\0" /* 49050 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 49073 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 49097 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 49121 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 49145 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 49169 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 49193 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 49217 */
	"TA_PERFCOUNTER0_SELECT\0" /* 49242 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 49265 */
	"TA_PERFCOUNTER1_SELECT\0" /* 49289 */
	"TD_PERFCOUNTER0_SELECT\0" /* 49312 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 49335 */
	"TD_PERFCOUNTER1_SELECT\0" /* 49359 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 49382 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 49406 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 49431 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 49455 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 49480 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 49504 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 49528 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 49552 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 49577 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 49601 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 49626 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 49650 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 49674 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 49698 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 49723 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 49747 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 49772 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 49796 */
	"CB_PERFCOUNTER_FILTER\0" /* 49820 */
	"CB_PERFCOUNTER0_SELECT\0" /* 49842 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 49865 */
	"CB_PERFCOUNTER1_SELECT\0" /* 49889 */
	"CB_PERFCOUNTER2_SELECT\0" /* 49912 */
	"CB_PERFCOUNTER3_SELECT\0" /* 49935 */
	"DB_PERFCOUNTER0_SELECT\0" /* 49958 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 49981 */
	"DB_PERFCOUNTER1_SELECT\0" /* 50005 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 50028 */
	"DB_PERFCOUNTER2_SELECT\0" /* 50052 */
	"DB_PERFCOUNTER3_SELECT\0" /* 50075 */
	"DB_RENDER_CONTROL\0" /* 50098 */
	"DB_COUNT_CONTROL\0" /* 50116 */
	"DB_DEPTH_VIEW\0" /* 50133 */
	"DB_RENDER_OVERRIDE\0" /* 50147 */
	"DB_RENDER_OVERRIDE2\0" /* 50166 */
	"DB_HTILE_DATA_BASE\0" /* 50186 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 50205 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 50225 */
	"DB_STENCIL_CLEAR\0" /* 50245 */
	"DB_DEPTH_CLEAR\0" /* 50262 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 50277 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 50301 */
	"DB_DEPTH_INFO\0" /* 50325 */
	"DB_Z_INFO\0" /* 50339 */
	"DB_STENCIL_INFO\0" /* 50349 */
	"DB_Z_READ_BASE\0" /* 50365 */
	"DB_STENCIL_READ_BASE\0" /* 50380 */
	"DB_Z_WRITE_BASE\0" /* 50401 */
	"DB_STENCIL_WRITE_BASE\0" /* 50417 */
	"DB_DEPTH_SIZE\0" /* 50439 */
	"DB_DEPTH_SLICE\0" /* 50453 */
	"TA_BC_BASE_ADDR\0" /* 50468 */
	"TA_BC_BASE_ADDR_HI\0" /* 50484 */
	"COHER_DEST_BASE_HI_0\0" /* 50503 */
	"COHER_DEST_BASE_HI_1\0" /* 50524 */
	"COHER_DEST_BASE_HI_2\0" /* 50545 */
	"COHER_DEST_BASE_HI_3\0" /* 50566 */
	"COHER_DEST_BASE_2\0" /* 50587 */
	"COHER_DEST_BASE_3\0" /* 50605 */
	"PA_SC_WINDOW_OFFSET\0" /* 50623 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 50643 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 50667 */
	"PA_SC_CLIPRECT_RULE\0" /* 50691 */
	"PA_SC_CLIPRECT_0_TL\0" /* 50711 */
	"PA_SC_CLIPRECT_0_BR\0" /* 50731 */
	"PA_SC_CLIPRECT_1_TL\0" /* 50751 */
	"PA_SC_CLIPRECT_1_BR\0" /* 50771 */
	"PA_SC_CLIPRECT_2_TL\0" /* 50791 */
	"PA_SC_CLIPRECT_2_BR\0" /* 50811 */
	"PA_SC_CLIPRECT_3_TL\0" /* 50831 */
	"PA_SC_CLIPRECT_3_BR\0" /* 50851 */
	"PA_SC_EDGERULE\0" /* 50871 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 50886 */
	"CB_TARGET_MASK\0" /* 50915 */
	"CB_SHADER_MASK\0" /* 50930 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 50945 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 50970 */
	"COHER_DEST_BASE_0\0" /* 50995 */
	"COHER_DEST_BASE_1\0" /* 51013 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 51031 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 51056 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 51081 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 51106 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 51131 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 51156 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 51181 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 51206 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 51231 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 51256 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 51281 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 51306 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 51331 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 51356 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 51381 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 51406 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 51431 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 51456 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 51481 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 51506 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 51531 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 51557 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 51583 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 51609 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 51635 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 51661 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 51687 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 51713 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 51739 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 51765 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 51791 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 51817 */
	"PA_SC_VPORT_ZMIN_0\0" /* 51843 */
	"PA_SC_VPORT_ZMAX_0\0" /* 51862 */
	"PA_SC_VPORT_ZMIN_1\0" /* 51881 */
	"PA_SC_VPORT_ZMAX_1\0" /* 51900 */
	"PA_SC_VPORT_ZMIN_2\0" /* 51919 */
	"PA_SC_VPORT_ZMAX_2\0" /* 51938 */
	"PA_SC_VPORT_ZMIN_3\0" /* 51957 */
	"PA_SC_VPORT_ZMAX_3\0" /* 51976 */
	"PA_SC_VPORT_ZMIN_4\0" /* 51995 */
	"PA_SC_VPORT_ZMAX_4\0" /* 52014 */
	"PA_SC_VPORT_ZMIN_5\0" /* 52033 */
	"PA_SC_VPORT_ZMAX_5\0" /* 52052 */
	"PA_SC_VPORT_ZMIN_6\0" /* 52071 */
	"PA_SC_VPORT_ZMAX_6\0" /* 52090 */
	"PA_SC_VPORT_ZMIN_7\0" /* 52109 */
	"PA_SC_VPORT_ZMAX_7\0" /* 52128 */
	"PA_SC_VPORT_ZMIN_8\0" /* 52147 */
	"PA_SC_VPORT_ZMAX_8\0" /* 52166 */
	"PA_SC_VPORT_ZMIN_9\0" /* 52185 */
	"PA_SC_VPORT_ZMAX_9\0" /* 52204 */
	"PA_SC_VPORT_ZMIN_10\0" /* 52223 */
	"PA_SC_VPORT_ZMAX_10\0" /* 52243 */
	"PA_SC_VPORT_ZMIN_11\0" /* 52263 */
	"PA_SC_VPORT_ZMAX_11\0" /* 52283 */
	"PA_SC_VPORT_ZMIN_12\0" /* 52303 */
	"PA_SC_VPORT_ZMAX_12\0" /* 52323 */
	"PA_SC_VPORT_ZMIN_13\0" /* 52343 */
	"PA_SC_VPORT_ZMAX_13\0" /* 52363 */
	"PA_SC_VPORT_ZMIN_14\0" /* 52383 */
	"PA_SC_VPORT_ZMAX_14\0" /* 52403 */
	"PA_SC_VPORT_ZMIN_15\0" /* 52423 */
	"PA_SC_VPORT_ZMAX_15\0" /* 52443 */
	"PA_SC_RASTER_CONFIG\0" /* 52463 */
	"PA_SC_RASTER_CONFIG_1\0" /* 52483 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 52505 */
	"VGT_MAX_VTX_INDX\0" /* 52533 */
	"VGT_MIN_VTX_INDX\0" /* 52550 */
	"VGT_INDX_OFFSET\0" /* 52567 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 52583 */
	"CB_BLEND_RED\0" /* 52612 */
	"CB_BLEND_GREEN\0" /* 52625 */
	"CB_BLEND_BLUE\0" /* 52640 */
	"CB_BLEND_ALPHA\0" /* 52654 */
	"CB_DCC_CONTROL\0" /* 52669 */
	"DB_STENCIL_CONTROL\0" /* 52684 */
	"DB_STENCILREFMASK\0" /* 52703 */
	"DB_STENCILREFMASK_BF\0" /* 52721 */
	"PA_CL_VPORT_XSCALE\0" /* 52742 */
	"PA_CL_VPORT_XOFFSET\0" /* 52761 */
	"PA_CL_VPORT_YSCALE\0" /* 52781 */
	"PA_CL_VPORT_YOFFSET\0" /* 52800 */
	"PA_CL_VPORT_ZSCALE\0" /* 52820 */
	"PA_CL_VPORT_ZOFFSET\0" /* 52839 */
	"PA_CL_VPORT_XSCALE_1\0" /* 52859 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 52880 */
	"PA_CL_VPORT_YSCALE_1\0" /* 52902 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 52923 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 52945 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 52966 */
	"PA_CL_VPORT_XSCALE_2\0" /* 52988 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 53009 */
	"PA_CL_VPORT_YSCALE_2\0" /* 53031 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 53052 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 53074 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 53095 */
	"PA_CL_VPORT_XSCALE_3\0" /* 53117 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 53138 */
	"PA_CL_VPORT_YSCALE_3\0" /* 53160 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 53181 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 53203 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 53224 */
	"PA_CL_VPORT_XSCALE_4\0" /* 53246 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 53267 */
	"PA_CL_VPORT_YSCALE_4\0" /* 53289 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 53310 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 53332 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 53353 */
	"PA_CL_VPORT_XSCALE_5\0" /* 53375 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 53396 */
	"PA_CL_VPORT_YSCALE_5\0" /* 53418 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 53439 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 53461 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 53482 */
	"PA_CL_VPORT_XSCALE_6\0" /* 53504 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 53525 */
	"PA_CL_VPORT_YSCALE_6\0" /* 53547 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 53568 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 53590 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 53611 */
	"PA_CL_VPORT_XSCALE_7\0" /* 53633 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 53654 */
	"PA_CL_VPORT_YSCALE_7\0" /* 53676 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 53697 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 53719 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 53740 */
	"PA_CL_VPORT_XSCALE_8\0" /* 53762 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 53783 */
	"PA_CL_VPORT_YSCALE_8\0" /* 53805 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 53826 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 53848 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 53869 */
	"PA_CL_VPORT_XSCALE_9\0" /* 53891 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 53912 */
	"PA_CL_VPORT_YSCALE_9\0" /* 53934 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 53955 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 53977 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 53998 */
	"PA_CL_VPORT_XSCALE_10\0" /* 54020 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 54042 */
	"PA_CL_VPORT_YSCALE_10\0" /* 54065 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 54087 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 54110 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 54132 */
	"PA_CL_VPORT_XSCALE_11\0" /* 54155 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 54177 */
	"PA_CL_VPORT_YSCALE_11\0" /* 54200 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 54222 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 54245 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 54267 */
	"PA_CL_VPORT_XSCALE_12\0" /* 54290 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 54312 */
	"PA_CL_VPORT_YSCALE_12\0" /* 54335 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 54357 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 54380 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 54402 */
	"PA_CL_VPORT_XSCALE_13\0" /* 54425 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 54447 */
	"PA_CL_VPORT_YSCALE_13\0" /* 54470 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 54492 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 54515 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 54537 */
	"PA_CL_VPORT_XSCALE_14\0" /* 54560 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 54582 */
	"PA_CL_VPORT_YSCALE_14\0" /* 54605 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 54627 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 54650 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 54672 */
	"PA_CL_VPORT_XSCALE_15\0" /* 54695 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 54717 */
	"PA_CL_VPORT_YSCALE_15\0" /* 54740 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 54762 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 54785 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 54807 */
	"PA_CL_UCP_0_X\0" /* 54830 */
	"PA_CL_UCP_0_Y\0" /* 54844 */
	"PA_CL_UCP_0_Z\0" /* 54858 */
	"PA_CL_UCP_0_W\0" /* 54872 */
	"PA_CL_UCP_1_X\0" /* 54886 */
	"PA_CL_UCP_1_Y\0" /* 54900 */
	"PA_CL_UCP_1_Z\0" /* 54914 */
	"PA_CL_UCP_1_W\0" /* 54928 */
	"PA_CL_UCP_2_X\0" /* 54942 */
	"PA_CL_UCP_2_Y\0" /* 54956 */
	"PA_CL_UCP_2_Z\0" /* 54970 */
	"PA_CL_UCP_2_W\0" /* 54984 */
	"PA_CL_UCP_3_X\0" /* 54998 */
	"PA_CL_UCP_3_Y\0" /* 55012 */
	"PA_CL_UCP_3_Z\0" /* 55026 */
	"PA_CL_UCP_3_W\0" /* 55040 */
	"PA_CL_UCP_4_X\0" /* 55054 */
	"PA_CL_UCP_4_Y\0" /* 55068 */
	"PA_CL_UCP_4_Z\0" /* 55082 */
	"PA_CL_UCP_4_W\0" /* 55096 */
	"PA_CL_UCP_5_X\0" /* 55110 */
	"PA_CL_UCP_5_Y\0" /* 55124 */
	"PA_CL_UCP_5_Z\0" /* 55138 */
	"PA_CL_UCP_5_W\0" /* 55152 */
	"SPI_PS_INPUT_CNTL_0\0" /* 55166 */
	"SPI_PS_INPUT_CNTL_1\0" /* 55186 */
	"SPI_PS_INPUT_CNTL_2\0" /* 55206 */
	"SPI_PS_INPUT_CNTL_3\0" /* 55226 */
	"SPI_PS_INPUT_CNTL_4\0" /* 55246 */
	"SPI_PS_INPUT_CNTL_5\0" /* 55266 */
	"SPI_PS_INPUT_CNTL_6\0" /* 55286 */
	"SPI_PS_INPUT_CNTL_7\0" /* 55306 */
	"SPI_PS_INPUT_CNTL_8\0" /* 55326 */
	"SPI_PS_INPUT_CNTL_9\0" /* 55346 */
	"SPI_PS_INPUT_CNTL_10\0" /* 55366 */
	"SPI_PS_INPUT_CNTL_11\0" /* 55387 */
	"SPI_PS_INPUT_CNTL_12\0" /* 55408 */
	"SPI_PS_INPUT_CNTL_13\0" /* 55429 */
	"SPI_PS_INPUT_CNTL_14\0" /* 55450 */
	"SPI_PS_INPUT_CNTL_15\0" /* 55471 */
	"SPI_PS_INPUT_CNTL_16\0" /* 55492 */
	"SPI_PS_INPUT_CNTL_17\0" /* 55513 */
	"SPI_PS_INPUT_CNTL_18\0" /* 55534 */
	"SPI_PS_INPUT_CNTL_19\0" /* 55555 */
	"SPI_PS_INPUT_CNTL_20\0" /* 55576 */
	"SPI_PS_INPUT_CNTL_21\0" /* 55597 */
	"SPI_PS_INPUT_CNTL_22\0" /* 55618 */
	"SPI_PS_INPUT_CNTL_23\0" /* 55639 */
	"SPI_PS_INPUT_CNTL_24\0" /* 55660 */
	"SPI_PS_INPUT_CNTL_25\0" /* 55681 */
	"SPI_PS_INPUT_CNTL_26\0" /* 55702 */
	"SPI_PS_INPUT_CNTL_27\0" /* 55723 */
	"SPI_PS_INPUT_CNTL_28\0" /* 55744 */
	"SPI_PS_INPUT_CNTL_29\0" /* 55765 */
	"SPI_PS_INPUT_CNTL_30\0" /* 55786 */
	"SPI_PS_INPUT_CNTL_31\0" /* 55807 */
	"SPI_VS_OUT_CONFIG\0" /* 55828 */
	"SPI_PS_INPUT_ENA\0" /* 55846 */
	"SPI_PS_INPUT_ADDR\0" /* 55863 */
	"SPI_INTERP_CONTROL_0\0" /* 55881 */
	"SPI_PS_IN_CONTROL\0" /* 55902 */
	"SPI_BARYC_CNTL\0" /* 55920 */
	"SPI_TMPRING_SIZE\0" /* 55935 */
	"SPI_WAVE_MGMT_1\0" /* 55952 */
	"SPI_WAVE_MGMT_2\0" /* 55968 */
	"SPI_SHADER_POS_FORMAT\0" /* 55984 */
	"SPI_SHADER_Z_FORMAT\0" /* 56006 */
	"SPI_SHADER_COL_FORMAT\0" /* 56026 */
	"SX_PS_DOWNCONVERT\0" /* 56048 */
	"SX_BLEND_OPT_EPSILON\0" /* 56066 */
	"SX_BLEND_OPT_CONTROL\0" /* 56087 */
	"SX_MRT0_BLEND_OPT\0" /* 56108 */
	"SX_MRT1_BLEND_OPT\0" /* 56126 */
	"SX_MRT2_BLEND_OPT\0" /* 56144 */
	"SX_MRT3_BLEND_OPT\0" /* 56162 */
	"SX_MRT4_BLEND_OPT\0" /* 56180 */
	"SX_MRT5_BLEND_OPT\0" /* 56198 */
	"SX_MRT6_BLEND_OPT\0" /* 56216 */
	"SX_MRT7_BLEND_OPT\0" /* 56234 */
	"CB_BLEND0_CONTROL\0" /* 56252 */
	"CB_BLEND1_CONTROL\0" /* 56270 */
	"CB_BLEND2_CONTROL\0" /* 56288 */
	"CB_BLEND3_CONTROL\0" /* 56306 */
	"CB_BLEND4_CONTROL\0" /* 56324 */
	"CB_BLEND5_CONTROL\0" /* 56342 */
	"CB_BLEND6_CONTROL\0" /* 56360 */
	"CB_BLEND7_CONTROL\0" /* 56378 */
	"CS_COPY_STATE\0" /* 56396 */
	"PA_CL_POINT_X_RAD\0" /* 56410 */
	"PA_CL_POINT_Y_RAD\0" /* 56428 */
	"PA_CL_POINT_SIZE\0" /* 56446 */
	"PA_CL_POINT_CULL_RAD\0" /* 56463 */
	"VGT_DMA_BASE_HI\0" /* 56484 */
	"VGT_DMA_BASE\0" /* 56500 */
	"VGT_DRAW_INITIATOR\0" /* 56513 */
	"VGT_IMMED_DATA\0" /* 56532 */
	"VGT_EVENT_ADDRESS_REG\0" /* 56547 */
	"DB_DEPTH_CONTROL\0" /* 56569 */
	"DB_EQAA\0" /* 56586 */
	"CB_COLOR_CONTROL\0" /* 56594 */
	"DB_SHADER_CONTROL\0" /* 56611 */
	"PA_CL_CLIP_CNTL\0" /* 56629 */
	"PA_SU_SC_MODE_CNTL\0" /* 56645 */
	"PA_CL_VTE_CNTL\0" /* 56664 */
	"PA_CL_VS_OUT_CNTL\0" /* 56679 */
	"PA_CL_NANINF_CNTL\0" /* 56697 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 56715 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 56739 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 56764 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 56787 */
	"PA_SU_POINT_SIZE\0" /* 56816 */
	"PA_SU_POINT_MINMAX\0" /* 56833 */
	"PA_SU_LINE_CNTL\0" /* 56852 */
	"PA_SC_LINE_STIPPLE\0" /* 56868 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 56887 */
	"VGT_HOS_CNTL\0" /* 56908 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 56921 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 56944 */
	"VGT_HOS_REUSE_DEPTH\0" /* 56967 */
	"VGT_GROUP_PRIM_TYPE\0" /* 56987 */
	"VGT_GROUP_FIRST_DECR\0" /* 57007 */
	"VGT_GROUP_DECR\0" /* 57028 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 57043 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 57065 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 57087 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 57113 */
	"VGT_GS_MODE\0" /* 57139 */
	"VGT_GS_ONCHIP_CNTL\0" /* 57151 */
	"PA_SC_MODE_CNTL_0\0" /* 57170 */
	"PA_SC_MODE_CNTL_1\0" /* 57188 */
	"VGT_ENHANCE\0" /* 57206 */
	"VGT_GS_PER_ES\0" /* 57218 */
	"VGT_ES_PER_GS\0" /* 57232 */
	"VGT_GS_PER_VS\0" /* 57246 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 57260 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 57283 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 57306 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 57329 */
	"IA_ENHANCE\0" /* 57350 */
	"VGT_DMA_SIZE\0" /* 57361 */
	"VGT_DMA_MAX_SIZE\0" /* 57374 */
	"VGT_DMA_INDEX_TYPE\0" /* 57391 */
	"WD_ENHANCE\0" /* 57410 */
	"VGT_PRIMITIVEID_EN\0" /* 57421 */
	"VGT_DMA_NUM_INSTANCES\0" /* 57440 */
	"VGT_PRIMITIVEID_RESET\0" /* 57462 */
	"VGT_EVENT_INITIATOR\0" /* 57484 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 57504 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 57531 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 57556 */
	"IA_MULTI_VGT_PARAM\0" /* 57581 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 57600 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 57623 */
	"VGT_REUSE_OFF\0" /* 57646 */
	"VGT_VTX_CNT_EN\0" /* 57660 */
	"DB_HTILE_SURFACE\0" /* 57675 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 57692 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 57719 */
	"DB_PRELOAD_CONTROL\0" /* 57746 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 57765 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 57791 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 57816 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 57844 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 57870 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 57895 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 57923 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 57949 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 57974 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 58002 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 58028 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 58053 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 58081 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 58112 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 58155 */
	"VGT_GS_MAX_VERT_OUT\0" /* 58193 */
	"VGT_TESS_DISTRIBUTION\0" /* 58213 */
	"VGT_SHADER_STAGES_EN\0" /* 58235 */
	"VGT_LS_HS_CONFIG\0" /* 58256 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 58273 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 58294 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 58317 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 58340 */
	"VGT_TF_PARAM\0" /* 58363 */
	"DB_ALPHA_TO_MASK\0" /* 58376 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 58393 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 58417 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 58447 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 58471 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 58501 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 58532 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 58561 */
	"VGT_GS_INSTANCE_CNT\0" /* 58591 */
	"VGT_STRMOUT_CONFIG\0" /* 58611 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 58630 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 58656 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 58682 */
	"PA_SC_LINE_CNTL\0" /* 58708 */
	"PA_SC_AA_CONFIG\0" /* 58724 */
	"PA_SU_VTX_CNTL\0" /* 58740 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 58755 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 58778 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 58801 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 58824 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 58847 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 58881 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 58915 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 58949 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 58983 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 59017 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 59051 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 59085 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 59119 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 59153 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 59187 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 59221 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 59255 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 59289 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 59323 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 59357 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 59391 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 59415 */
	"PA_SC_SHADER_CONTROL\0" /* 59439 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 59460 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 59488 */
	"CB_COLOR0_BASE\0" /* 59509 */
	"CB_COLOR0_PITCH\0" /* 59524 */
	"CB_COLOR0_SLICE\0" /* 59540 */
	"CB_COLOR0_VIEW\0" /* 59556 */
	"CB_COLOR0_INFO\0" /* 59571 */
	"CB_COLOR0_ATTRIB\0" /* 59586 */
	"CB_COLOR0_DCC_CONTROL\0" /* 59603 */
	"CB_COLOR0_CMASK\0" /* 59625 */
	"CB_COLOR0_CMASK_SLICE\0" /* 59641 */
	"CB_COLOR0_FMASK\0" /* 59663 */
	"CB_COLOR0_FMASK_SLICE\0" /* 59679 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 59701 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 59723 */
	"CB_COLOR0_DCC_BASE\0" /* 59745 */
	"CB_COLOR1_BASE\0" /* 59764 */
	"CB_COLOR1_PITCH\0" /* 59779 */
	"CB_COLOR1_SLICE\0" /* 59795 */
	"CB_COLOR1_VIEW\0" /* 59811 */
	"CB_COLOR1_INFO\0" /* 59826 */
	"CB_COLOR1_ATTRIB\0" /* 59841 */
	"CB_COLOR1_DCC_CONTROL\0" /* 59858 */
	"CB_COLOR1_CMASK\0" /* 59880 */
	"CB_COLOR1_CMASK_SLICE\0" /* 59896 */
	"CB_COLOR1_FMASK\0" /* 59918 */
	"CB_COLOR1_FMASK_SLICE\0" /* 59934 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 59956 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 59978 */
	"CB_COLOR1_DCC_BASE\0" /* 60000 */
	"CB_COLOR2_BASE\0" /* 60019 */
	"CB_COLOR2_PITCH\0" /* 60034 */
	"CB_COLOR2_SLICE\0" /* 60050 */
	"CB_COLOR2_VIEW\0" /* 60066 */
	"CB_COLOR2_INFO\0" /* 60081 */
	"CB_COLOR2_ATTRIB\0" /* 60096 */
	"CB_COLOR2_DCC_CONTROL\0" /* 60113 */
	"CB_COLOR2_CMASK\0" /* 60135 */
	"CB_COLOR2_CMASK_SLICE\0" /* 60151 */
	"CB_COLOR2_FMASK\0" /* 60173 */
	"CB_COLOR2_FMASK_SLICE\0" /* 60189 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 60211 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 60233 */
	"CB_COLOR2_DCC_BASE\0" /* 60255 */
	"CB_COLOR3_BASE\0" /* 60274 */
	"CB_COLOR3_PITCH\0" /* 60289 */
	"CB_COLOR3_SLICE\0" /* 60305 */
	"CB_COLOR3_VIEW\0" /* 60321 */
	"CB_COLOR3_INFO\0" /* 60336 */
	"CB_COLOR3_ATTRIB\0" /* 60351 */
	"CB_COLOR3_DCC_CONTROL\0" /* 60368 */
	"CB_COLOR3_CMASK\0" /* 60390 */
	"CB_COLOR3_CMASK_SLICE\0" /* 60406 */
	"CB_COLOR3_FMASK\0" /* 60428 */
	"CB_COLOR3_FMASK_SLICE\0" /* 60444 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 60466 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 60488 */
	"CB_COLOR3_DCC_BASE\0" /* 60510 */
	"CB_COLOR4_BASE\0" /* 60529 */
	"CB_COLOR4_PITCH\0" /* 60544 */
	"CB_COLOR4_SLICE\0" /* 60560 */
	"CB_COLOR4_VIEW\0" /* 60576 */
	"CB_COLOR4_INFO\0" /* 60591 */
	"CB_COLOR4_ATTRIB\0" /* 60606 */
	"CB_COLOR4_DCC_CONTROL\0" /* 60623 */
	"CB_COLOR4_CMASK\0" /* 60645 */
	"CB_COLOR4_CMASK_SLICE\0" /* 60661 */
	"CB_COLOR4_FMASK\0" /* 60683 */
	"CB_COLOR4_FMASK_SLICE\0" /* 60699 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 60721 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 60743 */
	"CB_COLOR4_DCC_BASE\0" /* 60765 */
	"CB_COLOR5_BASE\0" /* 60784 */
	"CB_COLOR5_PITCH\0" /* 60799 */
	"CB_COLOR5_SLICE\0" /* 60815 */
	"CB_COLOR5_VIEW\0" /* 60831 */
	"CB_COLOR5_INFO\0" /* 60846 */
	"CB_COLOR5_ATTRIB\0" /* 60861 */
	"CB_COLOR5_DCC_CONTROL\0" /* 60878 */
	"CB_COLOR5_CMASK\0" /* 60900 */
	"CB_COLOR5_CMASK_SLICE\0" /* 60916 */
	"CB_COLOR5_FMASK\0" /* 60938 */
	"CB_COLOR5_FMASK_SLICE\0" /* 60954 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 60976 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 60998 */
	"CB_COLOR5_DCC_BASE\0" /* 61020 */
	"CB_COLOR6_BASE\0" /* 61039 */
	"CB_COLOR6_PITCH\0" /* 61054 */
	"CB_COLOR6_SLICE\0" /* 61070 */
	"CB_COLOR6_VIEW\0" /* 61086 */
	"CB_COLOR6_INFO\0" /* 61101 */
	"CB_COLOR6_ATTRIB\0" /* 61116 */
	"CB_COLOR6_DCC_CONTROL\0" /* 61133 */
	"CB_COLOR6_CMASK\0" /* 61155 */
	"CB_COLOR6_CMASK_SLICE\0" /* 61171 */
	"CB_COLOR6_FMASK\0" /* 61193 */
	"CB_COLOR6_FMASK_SLICE\0" /* 61209 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 61231 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 61253 */
	"CB_COLOR6_DCC_BASE\0" /* 61275 */
	"CB_COLOR7_BASE\0" /* 61294 */
	"CB_COLOR7_PITCH\0" /* 61309 */
	"CB_COLOR7_SLICE\0" /* 61325 */
	"CB_COLOR7_VIEW\0" /* 61341 */
	"CB_COLOR7_INFO\0" /* 61356 */
	"CB_COLOR7_ATTRIB\0" /* 61371 */
	"CB_COLOR7_DCC_CONTROL\0" /* 61388 */
	"CB_COLOR7_CMASK\0" /* 61410 */
	"CB_COLOR7_CMASK_SLICE\0" /* 61426 */
	"CB_COLOR7_FMASK\0" /* 61448 */
	"CB_COLOR7_FMASK_SLICE\0" /* 61464 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 61486 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 61508 */
	"CB_COLOR7_DCC_BASE\0" /* 61530 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 501, 823, 827, 830,
	/* 4 */ 867, 887, 899, 905, 909, 918,
	/* 10 */ 956, 905, 383, 965,
	/* 14 */ 995, 905, -1, 1004,
	/* 18 */ 1093, 1098, 1106, 1114,
	/* 22 */ 1140, 878,
	/* 24 */ 1155, 1165,
	/* 26 */ 5384, 5395, 5411, 5426, 5442, 5456, 5469, 5484, 5499, 5514, 5526, 5545, 5565, 5583, 5602, 5617, 5632, 5654, 5669, 5684, 5699, 5715, 5729, 5756, 5783, 5810, 5837, 5861, 5881,
	/* 55 */ 5910, 5931,
	/* 57 */ 5384, 5395, 5411, 5426, 5442, 5456, 5469, -1, -1, 5514, 5526, 5545, 5565, 5583, -1, -1, 5632, 5654, 5669, 5684, 5699, 5715, 5729, 5756, 5783, 5810, 5837, 5861, 5881,
	/* 86 */ 7891, 7903, 7915, 7927,
	/* 90 */ 8275, -1, -1, -1, -1, -1, -1, -1, 8286, 8298, -1, -1, 8310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8321,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8347,
	/* 186 */ 8442, 8451, 8460, 8478, 8496, 8505, 8514, 8523,
	/* 194 */ 8572, 8593, 8614, 8637, 8660, 8680, 8700, 8725,
	/* 202 */ 8757, 8781, 8799, 8818, 8838, 8857, 8879, 8904, 8929, 8956, 8983, 9007, 9029, 9057, 9082, 9110,
	/* 218 */ 9218, 9230, 9249, 9268,
	/* 222 */ 9295, 9319, 9337, 9356, 9376, 9395, 9417, 9442, 9467, 9494, 9521, 9545, 9567, 9595, 9620, 9648, 9676, 9698, 9722, 9746, 9770, 9791, 9812, 9837, 9866, 9891, 9917, 9940, 9964, 9991, 10019, 10047, 10075, 10097, 10119, 10143, 10163, 10183, 10203, 10223, 10243, 10263, 10283, 10317, 10351, 10380, 10409, 10438, 10467, 10496, 10525, 10556, 10586, 10617, 10647, 10677, 10708, 10739, 10759, 10781, 10799, 10826, 10850, 10876,
	/* 286 */ 10910, 10931, 10952, 10975, 10998, 11018, 11038, 11063, 11084, 11110, 11130, 11152, 11178, 11199, 11223, 11250,
	/* 302 */ 11354, 11373, 11392, 11411, 11430, 11449, 11468, 11487, 11506, 11521, 11536, 11551, 11568, 11589, 11610, 11630,
	/* 318 */ 11813, 11825, 11839, 11863, 11893, 11918, 11949, 11969,
	/* 326 */ 12035, 12062, 12088, 12115, 12146, 12175, 12205, 12239,
	/* 334 */ 12434, 12457,
	/* 336 */ 12434, 12457, 12497, 12526,
	/* 340 */ 12572, 12593, 12615,
	/* 343 */ 12742, 12774, 12807, 12840,
	/* 347 */ 13031,
	/* 348 */ 13330, 13346, 13362, 13378, 13394, 13410, 13426, 13442, 13458, 13474, 13490, 13506, 13521, 13536, 13551, 13567,
	/* 364 */ 13979, 14010, 14038, 14067,
	/* 368 */ 14112, 14133, 14154, 14175, 14196, -1, -1, 14217, 14238, -1, -1, -1, 14260, 14281, 14302, 14324,
	/* 384 */ 14352, 14365, 14388, 14411, 14434, 14454, 14475, 14496, 14517, 14543, 14569, 14595, 14622, 14649, 14676,
	/* 399 */ 14715, 14740, 14766, 14792, 14818, 14843, 14868,
	/* 406 */ 14904, 14927, 14950, 14973,
	/* 410 */ 15007, 15031, 15055, 15079,
	/* 414 */ 15115, 15140, 15165, 15190,
	/* 418 */ 15233, 15250, 15267, 15284,
	/* 422 */ 13979, 14010, 14038, 15312,
	/* 426 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15427, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15441, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15455,
	/* 667 */ 16385, 16403, 16418,
	/* 670 */ 17955, 17965, 17978, 17992,
	/* 674 */ 18289, 18304, 18320, 18336,
	/* 678 */ 18501, 18511, 18529, 18539,
	/* 682 */ 14112, 14133, 14154, -1, 14196, 18944, 18966,
	/* 689 */ 14352, -1, -1, -1, 14434, 14454, 14475, 14496, 14517, 14543, 14569, 14595, 14622, 14649, 14676, -1, 18991, 19018,
	/* 707 */ 19046, 19056, 19061, 19066,
	/* 711 */ 19208, 19224,
	/* 713 */ 19702, 19725, 19748, 19771,
	/* 717 */ 19818, 19843, 19868, 19893,
	/* 721 */ 19943, 19967, 19991, 20015,
	/* 725 */ 20047, 20072, 20097, 20122,
	/* 729 */ 20156, 20181, 20206, 20231,
	/* 733 */ 20265, 20291, 20317, 20343,
	/* 737 */ 20379, 20402, 20425, 20448,
	/* 741 */ 20478, 20512, 20547, 20582,
	/* 745 */ 20625, 20659, 20694, 20729,
	/* 749 */ 20772, 20795, 20818, 20841,
	/* 753 */ 20871, 20905, 20940, 20975,
	/* 757 */ 21018, 21052, 21087, 21122,
	/* 761 */ 21165, 21193, 21221, 21249,
	/* 765 */ 21289, 21328, 21368, 21408,
	/* 769 */ 21461, 21500, 21540, 21580,
	/* 773 */ 21728, 21741, 21754, 21767, 21788, 21807, 21825, 21843, 21858, 21875, 21892, 21904, 21915, 21927, 21940, 21952,
	/* 789 */ 22176,
	/* 790 */ 22705, 22726, 22747, 22768, 22789,
	/* 795 */ 23050,
	/* 796 */ 23230, 23246, 23263, 23280, 23301,
	/* 801 */ 23394, 23410, 23426, 23443, 23460, 23481, 23505, 23529, 23552, 23575,
	/* 811 */ 23762, 23789, 23807, 23825, 23847, 23871, 23892, 23911, 23932, 23953, 23975,
	/* 822 */ 24037, 24043, -1, 24056, -1, -1, -1, 24069, -1, -1, -1, 24081, -1, 24093, -1, 24105,
	/* 838 */ 24612, 24647, 24682, 24714, 24746, 24778, 24810, 24844,
	/* 846 */ 24908, 24922, 24935, 24953, 24966, 24979, 25000, 25024,
	/* 854 */ 25100, 25111, 25121, 25137, 25163, 25179, 25205, 25221, 25247, 25263, 25289, -1, -1, 25314, 25335, 25366, 25383, 25404, 25421, 25442, 25463,
	/* 875 */ 25509, 25527, 25546, 25563, 25580,
	/* 880 */ 25703, 25718, 25739, 25761,
	/* 884 */ 25795, 25811,
	/* 886 */ 25919, 25930, 25940, 25951, 25963, 25976, 25990, 26002,
	/* 894 */ 26030, 26040, 26049, 26059, 26070, 26082, 26095, 26106,
	/* 902 */ 26527, 26538, 26548, 26572, -1, 26583, 26603,
	/* 909 */ 26621, -1, -1, -1, -1, 26628, -1, -1, -1, -1, 26635, -1, -1, -1, -1, 26642, -1, 26649, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26656, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26663, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26670, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26677, -1, -1, -1, -1, 26684, -1, -1, -1, -1, 26691, -1, -1, -1, -1, 26698, -1, -1, -1, -1, -1, -1, 26705, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26712, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26719, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26726, -1, -1, -1, -1, -1, -1, 26733, -1, -1, -1, -1, 26740, -1, -1, -1, -1, 26747, -1, -1, -1, -1, 26754, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26761, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26768, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26775, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26782, -1, 26789, -1, -1, -1, -1, 26796, -1, -1, -1, -1, 26803, -1, -1, -1, -1, 26810,
	/* 1165 */ 26893, 26900, 26920, 26925,
	/* 1169 */ 27071, 27084, 27103, 27125,
	/* 1173 */ 27511, 27531,
	/* 1175 */ 27543, 27557, 27570,
	/* 1178 */ 29101, 29123, 29143, 29164, 29185,
	/* 1183 */ 29240, 29257, 29273, 29288, 29304, 29320, 29344, 29368, 29392, 29416, 29437, 29453, 29468, 29492, 29515, 29539, 29559, 29578,
	/* 1201 */ 29621, 29634, 29648, 29660, 29673,
	/* 1206 */ 29757, 29774, 29791, 29807, 29823, 29839, 29855, 29872, 29890,
	/* 1215 */ 29962, 29969, 29983, 29997, 30011, 30025,
	/* 1221 */ 30035, 30047, 30058, 30069,
	/* 1225 */ 30241, -1, -1, 30256,
	/* 1229 */ 30925, 30948, 30971,
	/* 1232 */ 31074, 31087, 31100,
	/* 1235 */ 31112, 31130, 31150, 31170,
	/* 1239 */ 31198, 31214, 31231,
	/* 1242 */ 31258, 31273,
	/* 1244 */ -1, 31365, 31388, 31411, 31434, 31449, 31462, 31474, 31491, -1, 31510, 31530, 31550, 31569, -1, 31581, 31598, 31615, 31631, -1, 31647, 31676, 31687, 31713, 31731, 31748, 31767, 31785, 31804, 31820, 31836, 31856, 31878, 31900, 31914, 31933, 31949, -1, -1, 31959, 31974, -1, 31992, 32015, 32040, 32062, 32087, 7528, 7555, 32109, -1, 32137, 32156, 32174, 32194, 32213, 32233, 32257, -1, -1, -1, -1, -1, -1, 32278,
	/* 1309 */ 32776, 32789, 32801,
	/* 1312 */ 32813, 32826, 32838,
	/* 1315 */ 32852, 32866, 32878,
	/* 1318 */ 33009, 33022, 33036,
	/* 1321 */ 33046, 33059, 33069, 33083,
	/* 1325 */ 33111, 33124, 33136, 33155,
	/* 1329 */ 31258, 31273, 33252,
	/* 1332 */ 33270, 33296, 33322,
	/* 1335 */ 34097, 34108, 34116, 34132,
	/* 1339 */ 34158, 34184, 34209, 34234, 34257, 34278, 34305, 34334,
	/* 1347 */ 34671, 34683, 34696, 34709,
	/* 1351 */ 34729, 34743, 34751, 34760, 34770, 34779, 34791, 34806, 34821, 34838, 34855, 34869, 34881, -1, 34899, -1, 34917, 34929, 34943, 34957, 34971, 34982, 34993,
	/* 1374 */ 35014, 35027, -1, -1, 35040, 35052, 35064, 35076,
	/* 1382 */ 35101, 35110, 35119, 35132,
	/* 1386 */ 35209, 35224, 35242, 35270, 35300, 35331, 35359,
};

#endif
