/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_STRMOUT_BUFFER_UPDATE},
	{343, PKT3_DRAW_INDEX_OFFSET_2},
	{363, PKT3_DRAW_PREAMBLE},
	{377, PKT3_WRITE_DATA},
	{388, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{414, PKT3_MEM_SEMAPHORE},
	{428, PKT3_MPEG_INDEX},
	{439, PKT3_WAIT_REG_MEM},
	{452, PKT3_MEM_WRITE},
	{462, PKT3_INDIRECT_BUFFER_CIK},
	{482, PKT3_COPY_DATA},
	{492, PKT3_PFP_SYNC_ME},
	{504, PKT3_SURFACE_SYNC},
	{517, PKT3_ME_INITIALIZE},
	{531, PKT3_COND_WRITE},
	{542, PKT3_EVENT_WRITE},
	{554, PKT3_EVENT_WRITE_EOP},
	{570, PKT3_EVENT_WRITE_EOS},
	{586, PKT3_ONE_REG_WRITE},
	{600, PKT3_ACQUIRE_MEM},
	{612, PKT3_SET_CONFIG_REG},
	{627, PKT3_SET_CONTEXT_REG},
	{643, PKT3_SET_SH_REG},
	{654, PKT3_SET_SH_REG_OFFSET},
	{672, PKT3_SET_UCONFIG_REG},
	{688, PKT3_LOAD_CONST_RAM},
	{703, PKT3_WRITE_CONST_RAM},
	{719, PKT3_DUMP_CONST_RAM},
	{734, PKT3_INCREMENT_CE_COUNTER},
	{755, PKT3_INCREMENT_DE_COUNTER},
	{776, PKT3_WAIT_ON_CE_COUNTER},
	{795, PKT3_IT_OPCODE_C},
	{807, PKT3_CP_DMA},
	{814, PKT3_DMA_DATA},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{833, S_370_ENGINE_SEL(~0u), 4, 0},
	{844, S_370_WR_CONFIRM(~0u)},
	{855, S_370_WR_ONE_ADDR(~0u)},
	{928, S_370_DST_SEL(~0u), 6, 4},
	/* 4 */
	{936, S_410_SRC_ADDR_LO(~0u)},
	/* 5 */
	{948, S_411_CP_SYNC(~0u)},
	{980, S_411_SRC_SEL(~0u), 4, 10},
	{988, S_411_ENGINE(~0u), 2, 0},
	{1019, S_411_DSL_SEL(~0u), 4, 14},
	{1027, S_411_SRC_ADDR_HI(~0u)},
	/* 10 */
	{1039, S_412_DST_ADDR_LO(~0u)},
	/* 11 */
	{1051, S_413_DST_ADDR_HI(~0u)},
	/* 12 */
	{1063, S_414_BYTE_COUNT(~0u)},
	{1074, S_414_DISABLE_WR_CONFIRM(~0u)},
	{1122, S_414_SRC_SWAP(~0u), 4, 18},
	{1131, S_414_DST_SWAP(~0u), 4, 18},
	{1147, S_414_SAS(~0u), 2, 22},
	{1151, S_414_DAS(~0u), 2, 22},
	{1178, S_414_SAIC(~0u), 2, 24},
	{1183, S_414_DAIC(~0u), 2, 24},
	{1188, S_414_RAW_WAIT(~0u)},
	/* 21 */
	{948, S_500_CP_SYNC(~0u)},
	{980, S_500_SRC_SEL(~0u), 4, 10},
	{1019, S_500_DSL_SEL(~0u), 4, 14},
	{988, S_500_ENGINE(~0u), 2, 0},
	/* 25 */
	{1197, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{1213, S_000E4C_TST_RQ_PENDING(~0u)},
	{1228, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{1245, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{1261, S_000E4C_VP8_BUSY(~0u)},
	{1270, S_000E4C_SDMA_BUSY(~0u)},
	{1280, S_000E4C_SDMA1_BUSY(~0u)},
	{1291, S_000E4C_VCE0_BUSY(~0u)},
	{1301, S_000E4C_XDMA_BUSY(~0u)},
	{1311, S_000E4C_CHUB_BUSY(~0u)},
	{1321, S_000E4C_SDMA2_BUSY(~0u)},
	{1332, S_000E4C_SDMA3_BUSY(~0u)},
	{1343, S_000E4C_SAMSCP_BUSY(~0u)},
	{1355, S_000E4C_ISP_BUSY(~0u)},
	{1364, S_000E4C_VCE1_BUSY(~0u)},
	{1374, S_000E4C_ODE_BUSY(~0u)},
	{1383, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{1400, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{1417, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{1435, S_000E4C_ISP_RQ_PENDING(~0u)},
	{1450, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 46 */
	{1466, S_000E50_UVD_RQ_PENDING(~0u)},
	{1481, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{1499, S_000E50_ACP_RQ_PENDING(~0u)},
	{1514, S_000E50_SMU_RQ_PENDING(~0u)},
	{1529, S_000E50_GRBM_RQ_PENDING(~0u)},
	{1545, S_000E50_HI_RQ_PENDING(~0u)},
	{1559, S_000E50_VMC_BUSY(~0u)},
	{1568, S_000E50_MCB_BUSY(~0u)},
	{1577, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{1598, S_000E50_MCC_BUSY(~0u)},
	{1607, S_000E50_MCD_BUSY(~0u)},
	{1616, S_000E50_VMC1_BUSY(~0u)},
	{1626, S_000E50_SEM_BUSY(~0u)},
	{1635, S_000E50_ACP_BUSY(~0u)},
	{1644, S_000E50_IH_BUSY(~0u)},
	{1652, S_000E50_UVD_BUSY(~0u)},
	{1661, S_000E50_SAMMSP_BUSY(~0u)},
	{1673, S_000E50_GCATCL2_BUSY(~0u)},
	{1686, S_000E50_OSATCL2_BUSY(~0u)},
	{1699, S_000E50_BIF_BUSY(~0u)},
	/* 66 */
	{1708, S_000E54_MCC0_BUSY(~0u)},
	{1718, S_000E54_MCC1_BUSY(~0u)},
	{1728, S_000E54_MCC2_BUSY(~0u)},
	{1738, S_000E54_MCC3_BUSY(~0u)},
	{1748, S_000E54_MCC4_BUSY(~0u)},
	{1758, S_000E54_MCC5_BUSY(~0u)},
	{1768, S_000E54_MCC6_BUSY(~0u)},
	{1778, S_000E54_MCC7_BUSY(~0u)},
	{1788, S_000E54_MCD0_BUSY(~0u)},
	{1798, S_000E54_MCD1_BUSY(~0u)},
	{1808, S_000E54_MCD2_BUSY(~0u)},
	{1818, S_000E54_MCD3_BUSY(~0u)},
	{1828, S_000E54_MCD4_BUSY(~0u)},
	{1838, S_000E54_MCD5_BUSY(~0u)},
	{1848, S_000E54_MCD6_BUSY(~0u)},
	{1858, S_000E54_MCD7_BUSY(~0u)},
	/* 82 */
	{1868, S_00D034_IDLE(~0u)},
	{1873, S_00D034_REG_IDLE(~0u)},
	{1882, S_00D034_RB_EMPTY(~0u)},
	{1891, S_00D034_RB_FULL(~0u)},
	{1899, S_00D034_RB_CMD_IDLE(~0u)},
	{1911, S_00D034_RB_CMD_FULL(~0u)},
	{1923, S_00D034_IB_CMD_IDLE(~0u)},
	{1935, S_00D034_IB_CMD_FULL(~0u)},
	{1947, S_00D034_BLOCK_IDLE(~0u)},
	{1958, S_00D034_INSIDE_IB(~0u)},
	{1968, S_00D034_EX_IDLE(~0u)},
	{1976, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{2002, S_00D034_PACKET_READY(~0u)},
	{2015, S_00D034_MC_WR_IDLE(~0u)},
	{2026, S_00D034_SRBM_IDLE(~0u)},
	{2036, S_00D034_CONTEXT_EMPTY(~0u)},
	{2050, S_00D034_DELTA_RPTR_FULL(~0u)},
	{2066, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{2082, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{2098, S_00D034_MC_RD_IDLE(~0u)},
	{2109, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{2126, S_00D034_MC_RD_RET_STALL(~0u)},
	{2142, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{2161, S_00D034_PREV_CMD_IDLE(~0u)},
	{2175, S_00D034_SEM_IDLE(~0u)},
	{2184, S_00D034_SEM_REQ_STALL(~0u)},
	{2198, S_00D034_SEM_RESP_STATE(~0u)},
	{2213, S_00D034_INT_IDLE(~0u)},
	{2222, S_00D034_INT_REQ_STALL(~0u)},
	/* 111 */
	{2236, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{2259, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{2282, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{2305, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{2325, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{2345, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{2365, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{2385, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{2405, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{2425, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{2445, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{2465, S_008008_RLC_RQ_PENDING(~0u)},
	{2480, S_008008_RLC_BUSY(~0u)},
	{2489, S_008008_TC_BUSY(~0u)},
	{2497, S_008008_TCC_CC_RESIDENT(~0u)},
	{2513, S_008008_CPF_BUSY(~0u)},
	{2522, S_008008_CPC_BUSY(~0u)},
	{2531, S_008008_CPG_BUSY(~0u)},
	/* 129 */
	{2540, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{2563, S_008010_SRBM_RQ_PENDING(~0u)},
	{2579, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{2602, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{2625, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{2644, S_008010_DB_CLEAN(~0u)},
	{2653, S_008010_CB_CLEAN(~0u)},
	{2662, S_008010_TA_BUSY(~0u)},
	{2670, S_008010_GDS_BUSY(~0u)},
	{2679, S_008010_WD_BUSY_NO_DMA(~0u)},
	{2694, S_008010_VGT_BUSY(~0u)},
	{2703, S_008010_IA_BUSY_NO_DMA(~0u)},
	{2718, S_008010_IA_BUSY(~0u)},
	{2726, S_008010_SX_BUSY(~0u)},
	{2734, S_008010_WD_BUSY(~0u)},
	{2742, S_008010_SPI_BUSY(~0u)},
	{2751, S_008010_BCI_BUSY(~0u)},
	{2760, S_008010_SC_BUSY(~0u)},
	{2768, S_008010_PA_BUSY(~0u)},
	{2776, S_008010_DB_BUSY(~0u)},
	{2784, S_008010_CP_COHERENCY_BUSY(~0u)},
	{1347, S_008010_CP_BUSY(~0u)},
	{1569, S_008010_CB_BUSY(~0u)},
	{2802, S_008010_GUI_ACTIVE(~0u)},
	/* 153 */
	{2813, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 154 */
	{2832, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{2848, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{2864, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{2882, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{2900, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{2918, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{2936, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{2954, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{2972, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{2990, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{3008, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{3025, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{3041, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{3057, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{3073, S_0085F0_TC_ACTION_ENA(~0u)},
	{3087, S_0085F0_CB_ACTION_ENA(~0u)},
	{3101, S_0085F0_DB_ACTION_ENA(~0u)},
	{3115, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3136, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 173 */
	{2644, S_008014_DB_CLEAN(~0u)},
	{2653, S_008014_CB_CLEAN(~0u)},
	{2751, S_008014_BCI_BUSY(~0u)},
	{2694, S_008014_VGT_BUSY(~0u)},
	{2768, S_008014_PA_BUSY(~0u)},
	{2662, S_008014_TA_BUSY(~0u)},
	{2726, S_008014_SX_BUSY(~0u)},
	{2742, S_008014_SPI_BUSY(~0u)},
	{2760, S_008014_SC_BUSY(~0u)},
	{2776, S_008014_DB_BUSY(~0u)},
	{1569, S_008014_CB_BUSY(~0u)},
	/* 184 */
	{2644, S_008018_DB_CLEAN(~0u)},
	{2653, S_008018_CB_CLEAN(~0u)},
	{2751, S_008018_BCI_BUSY(~0u)},
	{2694, S_008018_VGT_BUSY(~0u)},
	{2768, S_008018_PA_BUSY(~0u)},
	{2662, S_008018_TA_BUSY(~0u)},
	{2726, S_008018_SX_BUSY(~0u)},
	{2742, S_008018_SPI_BUSY(~0u)},
	{2760, S_008018_SC_BUSY(~0u)},
	{2776, S_008018_DB_BUSY(~0u)},
	{1569, S_008018_CB_BUSY(~0u)},
	/* 195 */
	{2644, S_008038_DB_CLEAN(~0u)},
	{2653, S_008038_CB_CLEAN(~0u)},
	{2751, S_008038_BCI_BUSY(~0u)},
	{2694, S_008038_VGT_BUSY(~0u)},
	{2768, S_008038_PA_BUSY(~0u)},
	{2662, S_008038_TA_BUSY(~0u)},
	{2726, S_008038_SX_BUSY(~0u)},
	{2742, S_008038_SPI_BUSY(~0u)},
	{2760, S_008038_SC_BUSY(~0u)},
	{2776, S_008038_DB_BUSY(~0u)},
	{1569, S_008038_CB_BUSY(~0u)},
	/* 206 */
	{2644, S_00803C_DB_CLEAN(~0u)},
	{2653, S_00803C_CB_CLEAN(~0u)},
	{2751, S_00803C_BCI_BUSY(~0u)},
	{2694, S_00803C_VGT_BUSY(~0u)},
	{2768, S_00803C_PA_BUSY(~0u)},
	{2662, S_00803C_TA_BUSY(~0u)},
	{2726, S_00803C_SX_BUSY(~0u)},
	{2742, S_00803C_SPI_BUSY(~0u)},
	{2760, S_00803C_SC_BUSY(~0u)},
	{2776, S_00803C_DB_BUSY(~0u)},
	{1569, S_00803C_CB_BUSY(~0u)},
	/* 217 */
	{2813, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 218 */
	{3157, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 219 */
	{3176, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 220 */
	{2832, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{2848, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{3194, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{3211, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{2864, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{2882, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{2900, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{2918, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{2936, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{2954, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{2972, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{2990, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{3008, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{3228, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{3248, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{3266, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{3025, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{3041, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{3057, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{3073, S_0301F0_TC_ACTION_ENA(~0u)},
	{3087, S_0301F0_CB_ACTION_ENA(~0u)},
	{3101, S_0301F0_DB_ACTION_ENA(~0u)},
	{3115, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3283, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{3136, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{3308, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{3332, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 247 */
	{3349, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{3367, S_0301FC_MEID(~0u)},
	{3372, S_0301FC_PHASE1_STATUS(~0u)},
	{3379, S_0301FC_STATUS(~0u)},
	/* 251 */
	{3386, S_008210_MEC1_BUSY(~0u)},
	{3396, S_008210_MEC2_BUSY(~0u)},
	{3406, S_008210_DC0_BUSY(~0u)},
	{3415, S_008210_DC1_BUSY(~0u)},
	{3424, S_008210_RCIU1_BUSY(~0u)},
	{3435, S_008210_RCIU2_BUSY(~0u)},
	{3446, S_008210_ROQ1_BUSY(~0u)},
	{3456, S_008210_ROQ2_BUSY(~0u)},
	{3466, S_008210_TCIU_BUSY(~0u)},
	{3476, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{3493, S_008210_QU_BUSY(~0u)},
	{3501, S_008210_ATCL2IU_BUSY(~0u)},
	{3514, S_008210_CPG_CPC_BUSY(~0u)},
	{3527, S_008210_CPF_CPC_BUSY(~0u)},
	{2522, S_008210_CPC_BUSY(~0u)},
	/* 266 */
	{3540, S_008214_MEC1_LOAD_BUSY(~0u)},
	{3555, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{3575, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{3591, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{3609, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{3629, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{3648, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{3667, S_008214_MEC1_TC_BUSY(~0u)},
	{3680, S_008214_MEC1_DMA_BUSY(~0u)},
	{3694, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{3718, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{3734, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{3750, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{3766, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{3782, S_008214_MEC2_LOAD_BUSY(~0u)},
	{3797, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{3817, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{3833, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{3851, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{3871, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{3890, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{3909, S_008214_MEC2_TC_BUSY(~0u)},
	{3922, S_008214_MEC2_DMA_BUSY(~0u)},
	{3936, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{3960, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{3976, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{3992, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{4008, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 294 */
	{4024, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{4043, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{4063, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{4082, S_008218_MEC1_DECODING_PACKET(~0u)},
	{4103, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{4121, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{4144, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{4166, S_008218_MEC2_DECODING_PACKET(~0u)},
	{4187, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{4205, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{4228, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{4250, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4274, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4298, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 308 */
	{4321, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{4340, S_00821C_CSF_BUSY(~0u)},
	{4349, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{4364, S_00821C_ROQ_RING_BUSY(~0u)},
	{4378, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{4397, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{4416, S_00821C_ROQ_STATE_BUSY(~0u)},
	{4431, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{4448, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4470, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{4492, S_00821C_SEMAPHORE_BUSY(~0u)},
	{4507, S_00821C_INTERRUPT_BUSY(~0u)},
	{3466, S_00821C_TCIU_BUSY(~0u)},
	{4522, S_00821C_HQD_BUSY(~0u)},
	{4531, S_00821C_PRT_BUSY(~0u)},
	{3501, S_00821C_ATCL2IU_BUSY(~0u)},
	{4540, S_00821C_CPF_GFX_BUSY(~0u)},
	{4553, S_00821C_CPF_CMP_BUSY(~0u)},
	{4566, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{4585, S_00821C_CPC_CPF_BUSY(~0u)},
	{2513, S_00821C_CPF_BUSY(~0u)},
	/* 329 */
	{4598, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{4616, S_008220_CSF_RING_BUSY(~0u)},
	{4630, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{4649, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{4668, S_008220_CSF_STATE_BUSY(~0u)},
	{4683, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{4701, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{4719, S_008220_CSF_ARBITER_BUSY(~0u)},
	{4736, S_008220_CSF_INPUT_BUSY(~0u)},
	{4751, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{4773, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{4797, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{4815, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{4833, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{4854, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{4878, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{4904, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{4921, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{4941, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{4961, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{4981, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{5002, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{5025, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{5046, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{5065, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{5082, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{5098, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{5114, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{5130, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{5149, S_008220_HQD_PQ_BUSY(~0u)},
	{5161, S_008220_HQD_IB_BUSY(~0u)},
	/* 360 */
	{5173, S_008224_RING_FETCHING_DATA(~0u)},
	{5192, S_008224_INDR1_FETCHING_DATA(~0u)},
	{5212, S_008224_INDR2_FETCHING_DATA(~0u)},
	{5232, S_008224_STATE_FETCHING_DATA(~0u)},
	{5252, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{5273, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{4250, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4274, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4298, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 369 */
	{5294, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 370 */
	{5313, S_0088B0_PRIM_COUNT(~0u)},
	/* 371 */
	{5324, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{5343, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{5364, S_0088C4_ES_LIMIT(~0u)},
	/* 374 */
	{5373, S_0088D4_VERT_REUSE(~0u)},
	/* 375 */
	{5900, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 376 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 377 */
	{38, S_008988_SIZE(~0u)},
	/* 378 */
	{5952, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 379 */
	{5970, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{5991, S_008A14_NUM_CLIP_SEQ(~0u)},
	{6004, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{6027, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 383 */
	{6047, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 384 */
	{6066, S_008B10_CURRENT_PTR(~0u)},
	{6078, S_008B10_CURRENT_COUNT(~0u)},
	/* 386 */
	{6092, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6117, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{6155, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{6196, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{6219, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{6242, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{6266, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6296, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6325, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{6351, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{6380, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{6405, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{5252, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{5273, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{6440, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6468, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{4250, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4274, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4298, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 405 */
	{6498, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{6525, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{6552, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{6581, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{6610, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{6639, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6667, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{6697, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{6724, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{6752, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{6777, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{6803, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{6828, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{6852, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{6877, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{6905, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 421 */
	{6934, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6960, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{6986, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7013, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{7039, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{7061, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{7088, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{7110, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{7134, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{7159, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7182, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{7209, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{7234, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{7262, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7287, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7312, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{7337, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7366, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7397, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{7425, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{7452, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{7482, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{7509, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{7536, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{7563, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{7589, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{7613, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{7645, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{7672, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 450 */
	{4364, S_008680_ROQ_RING_BUSY(~0u)},
	{4378, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{4397, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{4416, S_008680_ROQ_STATE_BUSY(~0u)},
	{7698, S_008680_DC_BUSY(~0u)},
	{3501, S_008680_ATCL2IU_BUSY(~0u)},
	{7706, S_008680_PFP_BUSY(~0u)},
	{7715, S_008680_MEQ_BUSY(~0u)},
	{7724, S_008680_ME_BUSY(~0u)},
	{7732, S_008680_QUERY_BUSY(~0u)},
	{4492, S_008680_SEMAPHORE_BUSY(~0u)},
	{4507, S_008680_INTERRUPT_BUSY(~0u)},
	{7743, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{1271, S_008680_DMA_BUSY(~0u)},
	{7761, S_008680_RCIU_BUSY(~0u)},
	{3476, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{7771, S_008680_CPC_CPG_BUSY(~0u)},
	{7784, S_008680_CE_BUSY(~0u)},
	{3466, S_008680_TCIU_BUSY(~0u)},
	{4431, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{4448, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4470, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{1347, S_008680_CP_BUSY(~0u)},
	/* 473 */
	{7792, S_030800_INSTANCE_INDEX(~0u)},
	{7807, S_030800_SH_INDEX(~0u)},
	{7816, S_030800_SE_INDEX(~0u)},
	{7825, S_030800_SH_BROADCAST_WRITES(~0u)},
	{7845, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{7871, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 479 */
	{5900, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 480 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 481 */
	{38, S_030938_SIZE(~0u)},
	/* 482 */
	{5952, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{7939, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 484 */
	{6047, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 485 */
	{6066, S_030A04_CURRENT_PTR(~0u)},
	{6078, S_030A04_CURRENT_COUNT(~0u)},
	/* 487 */
	{437, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 489 */
	{437, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 491 */
	{437, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 493 */
	{437, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 495 */
	{7959, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{7985, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{8008, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{8033, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{8064, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{8098, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{8118, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{8145, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{8173, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 504 */
	{8208, S_008C08_INST_INVALIDATE(~0u)},
	{8224, S_008C08_DATA_INVALIDATE(~0u)},
	/* 506 */
	{8208, S_030D20_INST_INVALIDATE(~0u)},
	{8224, S_030D20_DATA_INVALIDATE(~0u)},
	{8240, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 509 */
	{8260, S_008C0C_RET(~0u)},
	{8264, S_008C0C_RUI(~0u)},
	{8268, S_008C0C_RNG(~0u)},
	/* 512 */
	{8272, S_008DFC_EN(~0u)},
	{8334, S_008DFC_TGT(~0u), 33, 90},
	{8338, S_008DFC_COMPR(~0u)},
	{2827, S_008DFC_DONE(~0u)},
	{8344, S_008DFC_VM(~0u)},
	{8364, S_008DFC_ENCODING(~0u), 63, 123},
	/* 518 */
	{8373, S_030E04_ADDRESS(~0u)},
	/* 519 */
	{8381, S_030F04_COUNT_HI(~0u)},
	/* 520 */
	{8390, S_008F04_BASE_ADDRESS_HI(~0u)},
	{8406, S_008F04_STRIDE(~0u)},
	{8413, S_008F04_CACHE_SWIZZLE(~0u)},
	{8427, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 524 */
	{8381, S_030F0C_COUNT_HI(~0u)},
	/* 525 */
	{8532, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{8542, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{8552, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{8562, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{8746, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{9138, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{9150, S_008F0C_ELEMENT_SIZE(~0u)},
	{9163, S_008F0C_INDEX_STRIDE(~0u)},
	{9176, S_008F0C_ADD_TID_ENABLE(~0u)},
	{9191, S_008F0C_ATC(~0u)},
	{9195, S_008F0C_HASH_ENABLE(~0u)},
	{9207, S_008F0C_HEAP(~0u)},
	{9212, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 539 */
	{8381, S_030F14_COUNT_HI(~0u)},
	/* 540 */
	{8390, S_008F14_BASE_ADDRESS_HI(~0u)},
	{9287, S_008F14_MIN_LOD(~0u)},
	{9138, S_008F14_DATA_FORMAT(~0u), 64, 222},
	{8746, S_008F14_NUM_FORMAT(~0u), 16, 286},
	{9212, S_008F14_MTYPE(~0u)},
	/* 545 */
	{11277, S_008F18_WIDTH(~0u)},
	{11283, S_008F18_HEIGHT(~0u)},
	{11290, S_008F18_PERF_MOD(~0u)},
	{11299, S_008F18_INTERLACED(~0u)},
	/* 549 */
	{8381, S_030F1C_COUNT_HI(~0u)},
	/* 550 */
	{8532, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{8542, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{8552, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{8562, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{11310, S_008F1C_BASE_LEVEL(~0u)},
	{11321, S_008F1C_LAST_LEVEL(~0u)},
	{11332, S_008F1C_TILING_INDEX(~0u)},
	{11345, S_008F1C_POW2_PAD(~0u)},
	{9212, S_008F1C_MTYPE(~0u)},
	{9191, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 561 */
	{11656, S_008F20_DEPTH(~0u)},
	{11662, S_008F20_PITCH(~0u)},
	/* 563 */
	{11668, S_008F24_BASE_ARRAY(~0u)},
	{11679, S_008F24_LAST_ARRAY(~0u)},
	/* 565 */
	{11690, S_008F28_MIN_LOD_WARN(~0u)},
	{11703, S_008F28_COUNTER_BANK_ID(~0u)},
	{11719, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{11734, S_008F28_COMPRESSION_EN(~0u)},
	{11749, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{11765, S_008F28_COLOR_TRANSFORM(~0u)},
	{11781, S_008F28_LOST_ALPHA_BITS(~0u)},
	{11797, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 573 */
	{11995, S_008F30_CLAMP_X(~0u), 8, 318},
	{12003, S_008F30_CLAMP_Y(~0u), 8, 318},
	{12011, S_008F30_CLAMP_Z(~0u), 8, 318},
	{12019, S_008F30_MAX_ANISO_RATIO(~0u)},
	{12267, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{12286, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{12305, S_008F30_MC_COORD_TRUNC(~0u)},
	{12320, S_008F30_FORCE_DEGAMMA(~0u)},
	{12334, S_008F30_TRUNC_COORD(~0u)},
	{12346, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{12364, S_008F30_FILTER_MODE(~0u)},
	{12376, S_008F30_COMPAT_MODE(~0u)},
	/* 585 */
	{9287, S_008F34_MIN_LOD(~0u)},
	{12388, S_008F34_MAX_LOD(~0u)},
	{12396, S_008F34_PERF_MIP(~0u)},
	{12405, S_008F34_PERF_Z(~0u)},
	/* 589 */
	{12412, S_008F38_LOD_BIAS(~0u)},
	{12421, S_008F38_LOD_BIAS_SEC(~0u)},
	{12483, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{12558, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{12638, S_008F38_Z_FILTER(~0u), 3, 340},
	{12647, S_008F38_MIP_FILTER(~0u), 3, 340},
	{12658, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{12677, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{12694, S_008F38_FILTER_PREC_FIX(~0u)},
	{12710, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 599 */
	{12725, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{12869, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 601 */
	{12887, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{12904, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{12921, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{12938, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{12955, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 606 */
	{12972, S_0090E0_PS_CU_EN(~0u)},
	{12981, S_0090E0_VS_CU_EN(~0u)},
	/* 608 */
	{12990, S_0090E4_GS_CU_EN(~0u)},
	{12999, S_0090E4_ES_CU_EN(~0u)},
	/* 610 */
	{13008, S_0090E8_LSHS_CU_EN(~0u)},
	/* 611 */
	{13019, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 612 */
	{13019, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 613 */
	{13036, S_0090F0_RING_ORDER_TS0(~0u), 1, 347},
	{13051, S_0090F0_RING_ORDER_TS1(~0u)},
	{13066, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 616 */
	{13081, S_00C700_PIPE_ORDER_TS0(~0u)},
	{13096, S_00C700_PIPE_ORDER_TS1(~0u)},
	{13111, S_00C700_PIPE_ORDER_TS2(~0u)},
	{13126, S_00C700_PIPE_ORDER_TS3(~0u)},
	{13141, S_00C700_TS0_DUR_MULT(~0u)},
	{13154, S_00C700_TS1_DUR_MULT(~0u)},
	{13167, S_00C700_TS2_DUR_MULT(~0u)},
	{13180, S_00C700_TS3_DUR_MULT(~0u)},
	/* 624 */
	{13193, S_0090F4_TS0_DURATION(~0u)},
	{13206, S_0090F4_TS1_DURATION(~0u)},
	/* 626 */
	{13219, S_0090F8_TS2_DURATION(~0u)},
	/* 627 */
	{38, S_008F40_SIZE(~0u)},
	/* 628 */
	{665, S_008F44_OFFSET(~0u)},
	/* 629 */
	{8381, S_030FFC_COUNT_HI(~0u)},
	/* 630 */
	{13232, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{13251, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{13270, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{13292, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{13314, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 635 */
	{13583, S_00913C_VTX_DONE_DELAY(~0u), 16, 348},
	{13598, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{13622, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{13638, S_00913C_PC_LIMIT_STRICT(~0u)},
	{13654, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 640 */
	{13668, S_00936C_TYPE_A(~0u)},
	{13675, S_00936C_VGPR_A(~0u)},
	{13682, S_00936C_SGPR_A(~0u)},
	{13689, S_00936C_LDS_A(~0u)},
	{13695, S_00936C_WAVES_A(~0u)},
	{13703, S_00936C_EN_A(~0u)},
	{13708, S_00936C_TYPE_B(~0u)},
	{13715, S_00936C_VGPR_B(~0u)},
	{13722, S_00936C_SGPR_B(~0u)},
	{13729, S_00936C_LDS_B(~0u)},
	{13735, S_00936C_WAVES_B(~0u)},
	{13743, S_00936C_EN_B(~0u)},
	/* 652 */
	{13748, S_009858_MSAA1_X(~0u)},
	{13756, S_009858_MSAA1_Y(~0u)},
	{13764, S_009858_MSAA2_X(~0u)},
	{13772, S_009858_MSAA2_Y(~0u)},
	{13780, S_009858_MSAA4_X(~0u)},
	{13788, S_009858_MSAA4_Y(~0u)},
	{13796, S_009858_MSAA8_X(~0u)},
	{13804, S_009858_MSAA8_Y(~0u)},
	{13812, S_009858_MSAA16_X(~0u)},
	{13821, S_009858_MSAA16_Y(~0u)},
	/* 662 */
	{13830, S_0098F8_NUM_PIPES(~0u)},
	{13840, S_0098F8_PIPE_INTERLEAVE_SIZE(~0u)},
	{13861, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{13882, S_0098F8_NUM_SHADER_ENGINES(~0u)},
	{13901, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{13925, S_0098F8_NUM_GPUS(~0u)},
	{13934, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{13954, S_0098F8_ROW_SIZE(~0u)},
	{13963, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 671 */
	{14096, S_009910_MICRO_TILE_MODE(~0u), 4, 364},
	{14341, S_009910_ARRAY_MODE(~0u), 16, 368},
	{14703, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{14893, S_009910_TILE_SPLIT(~0u), 7, 399},
	{14996, S_009910_BANK_WIDTH(~0u), 4, 406},
	{15103, S_009910_BANK_HEIGHT(~0u), 4, 410},
	{15215, S_009910_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15302, S_009910_NUM_BANKS(~0u), 4, 418},
	{15343, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{15363, S_009910_SAMPLE_SPLIT(~0u)},
	/* 681 */
	{14996, S_009990_BANK_WIDTH(~0u)},
	{15103, S_009990_BANK_HEIGHT(~0u)},
	{15215, S_009990_MACRO_TILE_ASPECT(~0u)},
	{15302, S_009990_NUM_BANKS(~0u)},
	/* 685 */
	{15376, S_00B004_MEM_BASE(~0u)},
	/* 686 */
	{15376, S_00B00C_MEM_BASE(~0u)},
	/* 687 */
	{12975, S_00B01C_CU_EN(~0u)},
	{15385, S_00B01C_WAVE_LIMIT(~0u)},
	{15396, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 690 */
	{15376, S_00B024_MEM_BASE(~0u)},
	/* 691 */
	{15415, S_00B028_VGPRS(~0u)},
	{15421, S_00B028_SGPRS(~0u)},
	{13242, S_00B028_PRIORITY(~0u)},
	{15470, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{15481, S_00B028_PRIV(~0u)},
	{15486, S_00B028_DX10_CLAMP(~0u)},
	{15497, S_00B028_DEBUG_MODE(~0u)},
	{15508, S_00B028_IEEE_MODE(~0u)},
	{15518, S_00B028_CU_GROUP_DISABLE(~0u)},
	{15535, S_00B028_CACHE_CTL(~0u)},
	{15545, S_00B028_CDBG_USER(~0u)},
	/* 702 */
	{15555, S_00B02C_SCRATCH_EN(~0u)},
	{15566, S_00B02C_USER_SGPR(~0u)},
	{15576, S_00B02C_TRAP_PRESENT(~0u)},
	{15589, S_00B02C_WAVE_CNT_EN(~0u)},
	{15601, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{15616, S_00B02C_EXCP_EN(~0u)},
	{15624, S_00B02C_EXCP_EN_CIK(~0u)},
	/* 709 */
	{15376, S_00B104_MEM_BASE(~0u)},
	/* 710 */
	{15376, S_00B10C_MEM_BASE(~0u)},
	/* 711 */
	{12975, S_00B118_CU_EN(~0u)},
	{15385, S_00B118_WAVE_LIMIT(~0u)},
	{15396, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 714 */
	{5367, S_00B11C_LIMIT(~0u)},
	/* 715 */
	{15376, S_00B124_MEM_BASE(~0u)},
	/* 716 */
	{15415, S_00B128_VGPRS(~0u)},
	{15421, S_00B128_SGPRS(~0u)},
	{13242, S_00B128_PRIORITY(~0u)},
	{15470, S_00B128_FLOAT_MODE(~0u)},
	{15481, S_00B128_PRIV(~0u)},
	{15486, S_00B128_DX10_CLAMP(~0u)},
	{15497, S_00B128_DEBUG_MODE(~0u)},
	{15508, S_00B128_IEEE_MODE(~0u)},
	{15636, S_00B128_VGPR_COMP_CNT(~0u)},
	{15650, S_00B128_CU_GROUP_ENABLE(~0u)},
	{15535, S_00B128_CACHE_CTL(~0u)},
	{15545, S_00B128_CDBG_USER(~0u)},
	/* 728 */
	{15555, S_00B12C_SCRATCH_EN(~0u)},
	{15566, S_00B12C_USER_SGPR(~0u)},
	{15576, S_00B12C_TRAP_PRESENT(~0u)},
	{15666, S_00B12C_OC_LDS_EN(~0u)},
	{15676, S_00B12C_SO_BASE0_EN(~0u)},
	{15688, S_00B12C_SO_BASE1_EN(~0u)},
	{15700, S_00B12C_SO_BASE2_EN(~0u)},
	{15712, S_00B12C_SO_BASE3_EN(~0u)},
	{15724, S_00B12C_SO_EN(~0u)},
	{15616, S_00B12C_EXCP_EN(~0u)},
	{15624, S_00B12C_EXCP_EN_CIK(~0u)},
	{15730, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 740 */
	{15376, S_00B204_MEM_BASE(~0u)},
	/* 741 */
	{15376, S_00B20C_MEM_BASE(~0u)},
	/* 742 */
	{12975, S_00B21C_CU_EN(~0u)},
	{15385, S_00B21C_WAVE_LIMIT(~0u)},
	{15396, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 746 */
	{15376, S_00B224_MEM_BASE(~0u)},
	/* 747 */
	{15415, S_00B228_VGPRS(~0u)},
	{15421, S_00B228_SGPRS(~0u)},
	{13242, S_00B228_PRIORITY(~0u)},
	{15470, S_00B228_FLOAT_MODE(~0u)},
	{15481, S_00B228_PRIV(~0u)},
	{15486, S_00B228_DX10_CLAMP(~0u)},
	{15497, S_00B228_DEBUG_MODE(~0u)},
	{15508, S_00B228_IEEE_MODE(~0u)},
	{15650, S_00B228_CU_GROUP_ENABLE(~0u)},
	{15535, S_00B228_CACHE_CTL(~0u)},
	{15545, S_00B228_CDBG_USER(~0u)},
	/* 758 */
	{15555, S_00B22C_SCRATCH_EN(~0u)},
	{15566, S_00B22C_USER_SGPR(~0u)},
	{15576, S_00B22C_TRAP_PRESENT(~0u)},
	{15616, S_00B22C_EXCP_EN(~0u)},
	{15624, S_00B22C_EXCP_EN_CIK(~0u)},
	/* 763 */
	{15376, S_00B304_MEM_BASE(~0u)},
	/* 764 */
	{15376, S_00B30C_MEM_BASE(~0u)},
	/* 765 */
	{12975, S_00B31C_CU_EN(~0u)},
	{15385, S_00B31C_WAVE_LIMIT(~0u)},
	{15396, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 769 */
	{15376, S_00B324_MEM_BASE(~0u)},
	/* 770 */
	{15415, S_00B328_VGPRS(~0u)},
	{15421, S_00B328_SGPRS(~0u)},
	{13242, S_00B328_PRIORITY(~0u)},
	{15470, S_00B328_FLOAT_MODE(~0u)},
	{15481, S_00B328_PRIV(~0u)},
	{15486, S_00B328_DX10_CLAMP(~0u)},
	{15497, S_00B328_DEBUG_MODE(~0u)},
	{15508, S_00B328_IEEE_MODE(~0u)},
	{15636, S_00B328_VGPR_COMP_CNT(~0u)},
	{15650, S_00B328_CU_GROUP_ENABLE(~0u)},
	{15535, S_00B328_CACHE_CTL(~0u)},
	{15545, S_00B328_CDBG_USER(~0u)},
	/* 782 */
	{15555, S_00B32C_SCRATCH_EN(~0u)},
	{15566, S_00B32C_USER_SGPR(~0u)},
	{15576, S_00B32C_TRAP_PRESENT(~0u)},
	{15666, S_00B32C_OC_LDS_EN(~0u)},
	{15616, S_00B32C_EXCP_EN(~0u)},
	{15607, S_00B32C_LDS_SIZE(~0u)},
	/* 788 */
	{15376, S_00B404_MEM_BASE(~0u)},
	/* 789 */
	{15376, S_00B40C_MEM_BASE(~0u)},
	/* 790 */
	{15385, S_00B41C_WAVE_LIMIT(~0u)},
	{15396, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 793 */
	{15376, S_00B424_MEM_BASE(~0u)},
	/* 794 */
	{15415, S_00B428_VGPRS(~0u)},
	{15421, S_00B428_SGPRS(~0u)},
	{13242, S_00B428_PRIORITY(~0u)},
	{15470, S_00B428_FLOAT_MODE(~0u)},
	{15481, S_00B428_PRIV(~0u)},
	{15486, S_00B428_DX10_CLAMP(~0u)},
	{15497, S_00B428_DEBUG_MODE(~0u)},
	{15508, S_00B428_IEEE_MODE(~0u)},
	{15535, S_00B428_CACHE_CTL(~0u)},
	{15545, S_00B428_CDBG_USER(~0u)},
	/* 804 */
	{15555, S_00B42C_SCRATCH_EN(~0u)},
	{15566, S_00B42C_USER_SGPR(~0u)},
	{15576, S_00B42C_TRAP_PRESENT(~0u)},
	{15666, S_00B42C_OC_LDS_EN(~0u)},
	{15764, S_00B42C_TG_SIZE_EN(~0u)},
	{15616, S_00B42C_EXCP_EN(~0u)},
	/* 810 */
	{15376, S_00B504_MEM_BASE(~0u)},
	/* 811 */
	{15376, S_00B50C_MEM_BASE(~0u)},
	/* 812 */
	{12975, S_00B51C_CU_EN(~0u)},
	{15385, S_00B51C_WAVE_LIMIT(~0u)},
	{15396, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{15747, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 816 */
	{15376, S_00B524_MEM_BASE(~0u)},
	/* 817 */
	{15415, S_00B528_VGPRS(~0u)},
	{15421, S_00B528_SGPRS(~0u)},
	{13242, S_00B528_PRIORITY(~0u)},
	{15470, S_00B528_FLOAT_MODE(~0u)},
	{15481, S_00B528_PRIV(~0u)},
	{15486, S_00B528_DX10_CLAMP(~0u)},
	{15497, S_00B528_DEBUG_MODE(~0u)},
	{15508, S_00B528_IEEE_MODE(~0u)},
	{15636, S_00B528_VGPR_COMP_CNT(~0u)},
	{15535, S_00B528_CACHE_CTL(~0u)},
	{15545, S_00B528_CDBG_USER(~0u)},
	/* 828 */
	{15555, S_00B52C_SCRATCH_EN(~0u)},
	{15566, S_00B52C_USER_SGPR(~0u)},
	{15576, S_00B52C_TRAP_PRESENT(~0u)},
	{15607, S_00B52C_LDS_SIZE(~0u)},
	{15616, S_00B52C_EXCP_EN(~0u)},
	/* 833 */
	{15775, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{15793, S_00B800_PARTIAL_TG_EN(~0u)},
	{15807, S_00B800_FORCE_START_AT_000(~0u)},
	{15826, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{15846, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{15866, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{15888, S_00B800_ORDER_MODE(~0u)},
	{15899, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{15919, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{15937, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{15955, S_00B800_DATA_ATC(~0u)},
	{15964, S_00B800_RESTORE(~0u)},
	/* 845 */
	{15972, S_00B81C_NUM_THREAD_FULL(~0u)},
	{15988, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 847 */
	{15972, S_00B820_NUM_THREAD_FULL(~0u)},
	{15988, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 849 */
	{15972, S_00B824_NUM_THREAD_FULL(~0u)},
	{15988, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 851 */
	{13019, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 852 */
	{16007, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 853 */
	{16027, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 854 */
	{383, S_00B834_DATA(~0u)},
	{16044, S_00B834_INST_ATC(~0u)},
	/* 856 */
	{383, S_00B83C_DATA(~0u)},
	/* 857 */
	{383, S_00B844_DATA(~0u)},
	/* 858 */
	{15415, S_00B848_VGPRS(~0u)},
	{15421, S_00B848_SGPRS(~0u)},
	{13242, S_00B848_PRIORITY(~0u)},
	{15470, S_00B848_FLOAT_MODE(~0u)},
	{15481, S_00B848_PRIV(~0u)},
	{15486, S_00B848_DX10_CLAMP(~0u)},
	{15497, S_00B848_DEBUG_MODE(~0u)},
	{15508, S_00B848_IEEE_MODE(~0u)},
	{16053, S_00B848_BULKY(~0u)},
	{15545, S_00B848_CDBG_USER(~0u)},
	/* 868 */
	{15555, S_00B84C_SCRATCH_EN(~0u)},
	{15566, S_00B84C_USER_SGPR(~0u)},
	{15576, S_00B84C_TRAP_PRESENT(~0u)},
	{16059, S_00B84C_TGID_X_EN(~0u)},
	{16069, S_00B84C_TGID_Y_EN(~0u)},
	{16079, S_00B84C_TGID_Z_EN(~0u)},
	{15764, S_00B84C_TG_SIZE_EN(~0u)},
	{16089, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{16104, S_00B84C_EXCP_EN_MSB(~0u)},
	{15607, S_00B84C_LDS_SIZE(~0u)},
	{15616, S_00B84C_EXCP_EN(~0u)},
	/* 879 */
	{383, S_00B850_DATA(~0u)},
	/* 880 */
	{16116, S_00B854_WAVES_PER_SH(~0u)},
	{16129, S_00B854_WAVES_PER_SH_CIK(~0u)},
	{16146, S_00B854_TG_PER_CU(~0u)},
	{16156, S_00B854_LOCK_THRESHOLD(~0u)},
	{16171, S_00B854_SIMD_DEST_CNTL(~0u)},
	{16186, S_00B854_FORCE_SIMD_DIST(~0u)},
	{16202, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 887 */
	{16217, S_00B858_SH0_CU_EN(~0u)},
	{16227, S_00B858_SH1_CU_EN(~0u)},
	/* 889 */
	{16217, S_00B85C_SH0_CU_EN(~0u)},
	{16227, S_00B85C_SH1_CU_EN(~0u)},
	/* 891 */
	{16237, S_00B860_WAVES(~0u)},
	{16243, S_00B860_WAVESIZE(~0u)},
	/* 893 */
	{16217, S_00B864_SH0_CU_EN(~0u)},
	{16227, S_00B864_SH1_CU_EN(~0u)},
	/* 895 */
	{16217, S_00B868_SH0_CU_EN(~0u)},
	{16227, S_00B868_SH1_CU_EN(~0u)},
	/* 897 */
	{16252, S_00B87C_SEND_SEID(~0u)},
	{14424, S_00B87C_RESERVED2(~0u)},
	{16262, S_00B87C_RESERVED3(~0u)},
	{16272, S_00B87C_RESERVED4(~0u)},
	{16282, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 902 */
	{16295, S_00B888_PAYLOAD(~0u)},
	{16303, S_00B888_IS_EVENT(~0u)},
	{16312, S_00B888_IS_STATE(~0u)},
	/* 905 */
	{862, S_00B890_ADDR(~0u)},
	/* 906 */
	{9191, S_00B894_ATC(~0u)},
	{9212, S_00B894_MTYPE(~0u)},
	/* 908 */
	{16321, S_034404_PERFCOUNTER_HI(~0u)},
	/* 909 */
	{16336, S_036004_PERF_SEL2(~0u)},
	{16346, S_036004_PERF_SEL3(~0u)},
	/* 911 */
	{16356, S_036008_PERF_SEL(~0u)},
	{16365, S_036008_PERF_SEL1(~0u)},
	{16375, S_036008_CNTR_MODE(~0u)},
	/* 914 */
	{16336, S_036010_PERF_SEL2(~0u)},
	{16346, S_036010_PERF_SEL3(~0u)},
	/* 916 */
	{16336, S_036018_PERF_SEL2(~0u)},
	{16346, S_036018_PERF_SEL3(~0u)},
	/* 918 */
	{16356, S_03601C_PERF_SEL(~0u)},
	{16365, S_03601C_PERF_SEL1(~0u)},
	{16375, S_03601C_CNTR_MODE(~0u)},
	/* 921 */
	{16432, S_036020_PERFMON_STATE(~0u), 3, 667},
	{16446, S_036020_SPM_PERFMON_STATE(~0u)},
	{16464, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{16484, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 925 */
	{16356, S_036024_PERF_SEL(~0u)},
	{16365, S_036024_PERF_SEL1(~0u)},
	{16375, S_036024_CNTR_MODE(~0u)},
	/* 928 */
	{16356, S_036100_PERF_SEL(~0u)},
	{16506, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16560, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16587, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16718, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16798, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{16824, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{16850, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{16904, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{16931, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{16957, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 947 */
	{16356, S_036108_PERF_SEL(~0u)},
	{16506, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 959 */
	{16356, S_03610C_PERF_SEL(~0u)},
	{16506, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 971 */
	{16356, S_036110_PERF_SEL(~0u)},
	{16506, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 983 */
	{16356, S_036114_PERF_SEL(~0u)},
	{16506, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16533, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16587, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16613, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16639, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16666, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16746, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16772, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16560, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16692, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16877, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 995 */
	{16356, S_036200_PERF_SEL(~0u)},
	{16983, S_036200_PERF_MODE(~0u)},
	/* 997 */
	{16356, S_036210_PERF_SEL(~0u)},
	{16365, S_036210_PERF_SEL1(~0u)},
	{16375, S_036210_CNTR_MODE(~0u)},
	{16993, S_036210_PERF_MODE1(~0u)},
	{16983, S_036210_PERF_MODE(~0u)},
	/* 1002 */
	{16336, S_036220_PERF_SEL2(~0u)},
	{16346, S_036220_PERF_SEL3(~0u)},
	{17004, S_036220_PERF_MODE3(~0u)},
	{17015, S_036220_PERF_MODE2(~0u)},
	/* 1006 */
	{16356, S_036230_PERF_SEL(~0u)},
	{16365, S_036230_PERF_SEL1(~0u)},
	{16375, S_036230_CNTR_MODE(~0u)},
	{16993, S_036230_PERF_MODE1(~0u)},
	{16983, S_036230_PERF_MODE(~0u)},
	/* 1011 */
	{16336, S_036240_PERF_SEL2(~0u)},
	{16346, S_036240_PERF_SEL3(~0u)},
	{17004, S_036240_PERF_MODE3(~0u)},
	{17015, S_036240_PERF_MODE2(~0u)},
	/* 1015 */
	{17026, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1016 */
	{16356, S_036400_PERF_SEL(~0u)},
	{16365, S_036400_PERF_SEL1(~0u)},
	{16375, S_036400_CNTR_MODE(~0u)},
	/* 1019 */
	{16336, S_036404_PERF_SEL2(~0u)},
	{16346, S_036404_PERF_SEL3(~0u)},
	/* 1021 */
	{16356, S_036500_PERF_SEL(~0u)},
	{16365, S_036500_PERF_SEL1(~0u)},
	{16375, S_036500_CNTR_MODE(~0u)},
	/* 1024 */
	{16336, S_036504_PERF_SEL2(~0u)},
	{16346, S_036504_PERF_SEL3(~0u)},
	/* 1026 */
	{16356, S_036600_PERF_SEL(~0u)},
	{16365, S_036600_PERF_SEL1(~0u)},
	{16375, S_036600_CNTR_MODE(~0u)},
	/* 1029 */
	{16336, S_036610_PERF_SEL2(~0u)},
	{16346, S_036610_PERF_SEL3(~0u)},
	/* 1031 */
	{17048, S_036628_BIN0_MIN(~0u)},
	{17057, S_036628_BIN0_MAX(~0u)},
	{17066, S_036628_BIN1_MIN(~0u)},
	{17075, S_036628_BIN1_MAX(~0u)},
	{17084, S_036628_BIN2_MIN(~0u)},
	{17093, S_036628_BIN2_MAX(~0u)},
	{17102, S_036628_BIN3_MIN(~0u)},
	{17111, S_036628_BIN3_MAX(~0u)},
	/* 1039 */
	{16356, S_036700_PERF_SEL(~0u)},
	{17120, S_036700_SQC_BANK_MASK(~0u)},
	{17134, S_036700_SQC_CLIENT_MASK(~0u)},
	{17150, S_036700_SPM_MODE(~0u)},
	{17159, S_036700_SIMD_MASK(~0u)},
	{16983, S_036700_PERF_MODE(~0u)},
	/* 1045 */
	{17169, S_036780_PS_EN(~0u)},
	{17175, S_036780_VS_EN(~0u)},
	{17181, S_036780_GS_EN(~0u)},
	{17187, S_036780_ES_EN(~0u)},
	{17193, S_036780_HS_EN(~0u)},
	{17199, S_036780_LS_EN(~0u)},
	{17205, S_036780_CS_EN(~0u)},
	{17211, S_036780_CNTR_RATE(~0u)},
	{17221, S_036780_DISABLE_FLUSH(~0u)},
	/* 1054 */
	{17235, S_036784_SH0_MASK(~0u)},
	{17244, S_036784_SH1_MASK(~0u)},
	/* 1056 */
	{17253, S_036788_FORCE_EN(~0u)},
	/* 1057 */
	{17262, S_036900_PERFCOUNTER_SELECT(~0u)},
	{17281, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{16375, S_036900_CNTR_MODE(~0u)},
	/* 1060 */
	{17301, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{17321, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1062 */
	{17262, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{17281, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{16375, S_036A00_CNTR_MODE(~0u)},
	/* 1065 */
	{17301, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{17321, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1067 */
	{16356, S_036B00_PERF_SEL(~0u)},
	{16365, S_036B00_PERF_SEL1(~0u)},
	{16375, S_036B00_CNTR_MODE(~0u)},
	{16993, S_036B00_PERF_MODE1(~0u)},
	{16983, S_036B00_PERF_MODE(~0u)},
	/* 1072 */
	{16336, S_036B04_PERF_SEL2(~0u)},
	{16346, S_036B04_PERF_SEL3(~0u)},
	{17004, S_036B04_PERF_MODE3(~0u)},
	{17015, S_036B04_PERF_MODE2(~0u)},
	/* 1076 */
	{16356, S_036C00_PERF_SEL(~0u)},
	{16365, S_036C00_PERF_SEL1(~0u)},
	{16375, S_036C00_CNTR_MODE(~0u)},
	{16993, S_036C00_PERF_MODE1(~0u)},
	{16983, S_036C00_PERF_MODE(~0u)},
	/* 1081 */
	{16336, S_036C04_PERF_SEL2(~0u)},
	{16346, S_036C04_PERF_SEL3(~0u)},
	{17004, S_036C04_PERF_MODE3(~0u)},
	{17015, S_036C04_PERF_MODE2(~0u)},
	/* 1085 */
	{16356, S_036D00_PERF_SEL(~0u)},
	{16365, S_036D00_PERF_SEL1(~0u)},
	{16375, S_036D00_CNTR_MODE(~0u)},
	{16993, S_036D00_PERF_MODE1(~0u)},
	{16983, S_036D00_PERF_MODE(~0u)},
	/* 1090 */
	{16336, S_036D04_PERF_SEL2(~0u)},
	{16346, S_036D04_PERF_SEL3(~0u)},
	{17004, S_036D04_PERF_MODE3(~0u)},
	{17015, S_036D04_PERF_MODE2(~0u)},
	/* 1094 */
	{16356, S_036E00_PERF_SEL(~0u)},
	{16365, S_036E00_PERF_SEL1(~0u)},
	{16375, S_036E00_CNTR_MODE(~0u)},
	{16993, S_036E00_PERF_MODE1(~0u)},
	{16983, S_036E00_PERF_MODE(~0u)},
	/* 1099 */
	{16336, S_036E04_PERF_SEL2(~0u)},
	{16346, S_036E04_PERF_SEL3(~0u)},
	{17015, S_036E04_PERF_MODE2(~0u)},
	{17004, S_036E04_PERF_MODE3(~0u)},
	/* 1103 */
	{16356, S_036E40_PERF_SEL(~0u)},
	{16365, S_036E40_PERF_SEL1(~0u)},
	{16375, S_036E40_CNTR_MODE(~0u)},
	{16993, S_036E40_PERF_MODE1(~0u)},
	{16983, S_036E40_PERF_MODE(~0u)},
	/* 1108 */
	{16336, S_036E44_PERF_SEL2(~0u)},
	{16346, S_036E44_PERF_SEL3(~0u)},
	{17015, S_036E44_PERF_MODE2(~0u)},
	{17004, S_036E44_PERF_MODE3(~0u)},
	/* 1112 */
	{17341, S_037000_OP_FILTER_ENABLE(~0u)},
	{17358, S_037000_OP_FILTER_SEL(~0u)},
	{17372, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{17393, S_037000_FORMAT_FILTER_SEL(~0u)},
	{17411, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{17431, S_037000_CLEAR_FILTER_SEL(~0u)},
	{17448, S_037000_MRT_FILTER_ENABLE(~0u)},
	{17466, S_037000_MRT_FILTER_SEL(~0u)},
	{17481, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{17507, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{17530, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{17558, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1124 */
	{16356, S_037004_PERF_SEL(~0u)},
	{16365, S_037004_PERF_SEL1(~0u)},
	{16375, S_037004_CNTR_MODE(~0u)},
	{16993, S_037004_PERF_MODE1(~0u)},
	{16983, S_037004_PERF_MODE(~0u)},
	/* 1129 */
	{16336, S_037008_PERF_SEL2(~0u)},
	{16346, S_037008_PERF_SEL3(~0u)},
	{17004, S_037008_PERF_MODE3(~0u)},
	{17015, S_037008_PERF_MODE2(~0u)},
	/* 1133 */
	{16356, S_037100_PERF_SEL(~0u)},
	{16365, S_037100_PERF_SEL1(~0u)},
	{16375, S_037100_CNTR_MODE(~0u)},
	{16993, S_037100_PERF_MODE1(~0u)},
	{16983, S_037100_PERF_MODE(~0u)},
	/* 1138 */
	{16336, S_037104_PERF_SEL2(~0u)},
	{16346, S_037104_PERF_SEL3(~0u)},
	{17004, S_037104_PERF_MODE3(~0u)},
	{17015, S_037104_PERF_MODE2(~0u)},
	/* 1142 */
	{17583, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{17602, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{17623, S_028000_DEPTH_COPY(~0u)},
	{17634, S_028000_STENCIL_COPY(~0u)},
	{17647, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{17666, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{17691, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{17714, S_028000_COPY_CENTROID(~0u)},
	{17728, S_028000_COPY_SAMPLE(~0u)},
	{17740, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1152 */
	{17758, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{17782, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{17803, S_028004_SAMPLE_RATE(~0u)},
	{17815, S_028004_ZPASS_ENABLE(~0u)},
	{17828, S_028004_ZFAIL_ENABLE(~0u)},
	{17841, S_028004_SFAIL_ENABLE(~0u)},
	{17854, S_028004_DBFAIL_ENABLE(~0u)},
	{17868, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{17886, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1161 */
	{17903, S_028008_SLICE_START(~0u)},
	{17915, S_028008_SLICE_MAX(~0u)},
	{17925, S_028008_Z_READ_ONLY(~0u)},
	{17937, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1165 */
	{18007, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 670},
	{18024, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 670},
	{18042, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 670},
	{18060, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{18081, S_02800C_FAST_Z_DISABLE(~0u)},
	{18096, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{18117, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{18135, S_02800C_FORCE_COLOR_KILL(~0u)},
	{18152, S_02800C_FORCE_Z_READ(~0u)},
	{18165, S_02800C_FORCE_STENCIL_READ(~0u)},
	{18184, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 670},
	{18203, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{18227, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{18250, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{18267, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{18352, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 674},
	{18371, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{18388, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{18412, S_02800C_FORCE_Z_DIRTY(~0u)},
	{18426, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{18446, S_02800C_FORCE_Z_VALID(~0u)},
	{18460, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{18480, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1188 */
	{18554, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{18583, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{18614, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{18650, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{18685, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{18713, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{18735, S_028010_DISABLE_REG_SNOOP(~0u)},
	{18753, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{18785, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{18811, S_028010_HIZ_ZFUNC(~0u)},
	{18821, S_028010_HIS_SFUNC_FF(~0u)},
	{18834, S_028010_HIS_SFUNC_BF(~0u)},
	{18847, S_028010_PRESERVE_ZRANGE(~0u)},
	{18863, S_028010_PRESERVE_SRESULTS(~0u)},
	{18881, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1203 */
	{18899, S_028028_CLEAR(~0u)},
	/* 1204 */
	{18905, S_028030_TL_X(~0u)},
	{18910, S_028030_TL_Y(~0u)},
	/* 1206 */
	{18915, S_028034_BR_X(~0u)},
	{18920, S_028034_BR_Y(~0u)},
	/* 1208 */
	{18925, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{14341, S_02803C_ARRAY_MODE(~0u), 7, 682},
	{14703, S_02803C_PIPE_CONFIG(~0u), 18, 689},
	{14996, S_02803C_BANK_WIDTH(~0u), 4, 406},
	{15103, S_02803C_BANK_HEIGHT(~0u), 4, 410},
	{15215, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15302, S_02803C_NUM_BANKS(~0u), 4, 418},
	/* 1215 */
	{8750, S_028040_FORMAT(~0u), 4, 707},
	{19077, S_028040_NUM_SAMPLES(~0u)},
	{14893, S_028040_TILE_SPLIT(~0u), 7, 399},
	{19089, S_028040_TILE_MODE_INDEX(~0u)},
	{19105, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{19129, S_028040_ALLOW_EXPCLEAR(~0u)},
	{19144, S_028040_READ_SIZE(~0u)},
	{19154, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{19174, S_028040_CLEAR_DISALLOWED(~0u)},
	{19191, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1225 */
	{8750, S_028044_FORMAT(~0u), 2, 711},
	{14893, S_028044_TILE_SPLIT(~0u), 7, 399},
	{19089, S_028044_TILE_MODE_INDEX(~0u)},
	{19129, S_028044_ALLOW_EXPCLEAR(~0u)},
	{19234, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{19174, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1231 */
	{19255, S_028058_PITCH_TILE_MAX(~0u)},
	{19270, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1233 */
	{19286, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1234 */
	{8373, S_028084_ADDRESS(~0u)},
	/* 1235 */
	{19301, S_028200_WINDOW_X_OFFSET(~0u)},
	{19317, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1237 */
	{18905, S_028204_TL_X(~0u)},
	{18910, S_028204_TL_Y(~0u)},
	{19333, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1240 */
	{18915, S_028208_BR_X(~0u)},
	{18920, S_028208_BR_Y(~0u)},
	/* 1242 */
	{19355, S_02820C_CLIP_RULE(~0u)},
	/* 1243 */
	{18905, S_028210_TL_X(~0u)},
	{18910, S_028210_TL_Y(~0u)},
	/* 1245 */
	{18915, S_028214_BR_X(~0u)},
	{18920, S_028214_BR_Y(~0u)},
	/* 1247 */
	{19365, S_028230_ER_TRI(~0u)},
	{12448, S_028230_ER_POINT(~0u)},
	{19372, S_028230_ER_RECT(~0u)},
	{19380, S_028230_ER_LINE_LR(~0u)},
	{19391, S_028230_ER_LINE_RL(~0u)},
	{19402, S_028230_ER_LINE_TB(~0u)},
	{19413, S_028230_ER_LINE_BT(~0u)},
	/* 1254 */
	{19424, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{19443, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1256 */
	{19462, S_028238_TARGET0_ENABLE(~0u)},
	{19477, S_028238_TARGET1_ENABLE(~0u)},
	{19492, S_028238_TARGET2_ENABLE(~0u)},
	{19507, S_028238_TARGET3_ENABLE(~0u)},
	{19522, S_028238_TARGET4_ENABLE(~0u)},
	{19537, S_028238_TARGET5_ENABLE(~0u)},
	{19552, S_028238_TARGET6_ENABLE(~0u)},
	{19567, S_028238_TARGET7_ENABLE(~0u)},
	/* 1264 */
	{19582, S_02823C_OUTPUT0_ENABLE(~0u)},
	{19597, S_02823C_OUTPUT1_ENABLE(~0u)},
	{19612, S_02823C_OUTPUT2_ENABLE(~0u)},
	{19627, S_02823C_OUTPUT3_ENABLE(~0u)},
	{19642, S_02823C_OUTPUT4_ENABLE(~0u)},
	{19657, S_02823C_OUTPUT5_ENABLE(~0u)},
	{19672, S_02823C_OUTPUT6_ENABLE(~0u)},
	{19687, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1272 */
	{18905, S_028240_TL_X(~0u)},
	{18910, S_028240_TL_Y(~0u)},
	{19333, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1275 */
	{18915, S_028244_BR_X(~0u)},
	{18920, S_028244_BR_Y(~0u)},
	/* 1277 */
	{18905, S_028250_TL_X(~0u)},
	{18910, S_028250_TL_Y(~0u)},
	{19333, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1280 */
	{18915, S_028254_BR_X(~0u)},
	{18920, S_028254_BR_Y(~0u)},
	/* 1282 */
	{19794, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{19806, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{19918, S_028350_RB_XSEL2(~0u), 4, 717},
	{19927, S_028350_RB_XSEL(~0u)},
	{19935, S_028350_RB_YSEL(~0u)},
	{20039, S_028350_PKR_MAP(~0u), 4, 721},
	{20147, S_028350_PKR_XSEL(~0u), 4, 725},
	{20256, S_028350_PKR_YSEL(~0u), 4, 729},
	{20369, S_028350_PKR_XSEL2(~0u), 4, 733},
	{20471, S_028350_SC_MAP(~0u), 4, 737},
	{20617, S_028350_SC_XSEL(~0u), 4, 741},
	{20764, S_028350_SC_YSEL(~0u), 4, 745},
	{20864, S_028350_SE_MAP(~0u), 4, 749},
	{21010, S_028350_SE_XSEL(~0u), 4, 753},
	{21157, S_028350_SE_YSEL(~0u), 4, 757},
	/* 1297 */
	{21277, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{21448, S_028354_SE_PAIR_XSEL(~0u), 4, 765},
	{21620, S_028354_SE_PAIR_YSEL(~0u), 4, 769},
	/* 1300 */
	{17868, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{17886, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1302 */
	{21633, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{21660, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{21699, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1305 */
	{21965, S_02842C_STENCILFAIL(~0u), 16, 773},
	{21977, S_02842C_STENCILZPASS(~0u), 16, 773},
	{21990, S_02842C_STENCILZFAIL(~0u), 16, 773},
	{22003, S_02842C_STENCILFAIL_BF(~0u), 16, 773},
	{22018, S_02842C_STENCILZPASS_BF(~0u), 16, 773},
	{22034, S_02842C_STENCILZFAIL_BF(~0u), 16, 773},
	/* 1311 */
	{22050, S_028430_STENCILTESTVAL(~0u)},
	{22065, S_028430_STENCILMASK(~0u)},
	{22077, S_028430_STENCILWRITEMASK(~0u)},
	{22094, S_028430_STENCILOPVAL(~0u)},
	/* 1315 */
	{22107, S_028434_STENCILTESTVAL_BF(~0u)},
	{22125, S_028434_STENCILMASK_BF(~0u)},
	{22140, S_028434_STENCILWRITEMASK_BF(~0u)},
	{22160, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1319 */
	{665, S_028644_OFFSET(~0u)},
	{22183, S_028644_DEFAULT_VAL(~0u), 1, 789},
	{22195, S_028644_FLAT_SHADE(~0u)},
	{22206, S_028644_CYL_WRAP(~0u)},
	{22215, S_028644_PT_SPRITE_TEX(~0u)},
	{22229, S_028644_DUP(~0u)},
	{22233, S_028644_FP16_INTERP_MODE(~0u)},
	{22250, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{22268, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{22286, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{22306, S_028644_ATTR0_VALID(~0u)},
	{22318, S_028644_ATTR1_VALID(~0u)},
	/* 1331 */
	{22330, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{22346, S_0286C4_VS_HALF_PACK(~0u)},
	{22359, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{22374, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1335 */
	{22394, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{22411, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{22428, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{22447, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{22468, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{22486, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{22504, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{22524, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{22545, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{22561, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{22577, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{22593, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{22609, S_0286CC_FRONT_FACE_ENA(~0u)},
	{22624, S_0286CC_ANCILLARY_ENA(~0u)},
	{22638, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{22658, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1351 */
	{22394, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{22411, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{22428, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{22447, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{22468, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{22486, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{22504, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{22524, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{22545, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{22561, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{22577, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{22593, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{22609, S_0286D0_FRONT_FACE_ENA(~0u)},
	{22624, S_0286D0_ANCILLARY_ENA(~0u)},
	{22638, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{22658, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1367 */
	{22675, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{22690, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{22813, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 790},
	{22831, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 790},
	{22849, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 790},
	{22867, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 790},
	{22885, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1374 */
	{22902, S_0286D8_NUM_INTERP(~0u)},
	{22913, S_0286D8_PARAM_GEN(~0u)},
	{22923, S_0286D8_FOG_ADDR(~0u)},
	{22932, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{22952, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1379 */
	{22972, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{22990, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{23010, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{23029, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{23099, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 795},
	{23118, S_0286E0_POS_FLOAT_ULC(~0u)},
	{23132, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1386 */
	{16237, S_0286E8_WAVES(~0u)},
	{16243, S_0286E8_WAVESIZE(~0u)},
	/* 1388 */
	{23152, S_028704_NUM_PS_WAVES(~0u)},
	{23165, S_028704_NUM_VS_WAVES(~0u)},
	{23178, S_028704_NUM_GS_WAVES(~0u)},
	{23191, S_028704_NUM_ES_WAVES(~0u)},
	{23204, S_028704_NUM_HS_WAVES(~0u)},
	/* 1393 */
	{23217, S_028708_NUM_LS_WAVES(~0u)},
	/* 1394 */
	{23318, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 796},
	{23337, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 796},
	{23356, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 796},
	{23375, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 796},
	/* 1398 */
	{23594, S_028710_Z_EXPORT_FORMAT(~0u), 10, 801},
	/* 1399 */
	{23610, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 801},
	{23629, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 801},
	{23648, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 801},
	{23667, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 801},
	{23686, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 801},
	{23705, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 801},
	{23724, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 801},
	{23743, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 801},
	/* 1407 */
	{23997, S_028754_MRT0(~0u), 11, 811},
	{24002, S_028754_MRT1(~0u)},
	{24007, S_028754_MRT2(~0u)},
	{24012, S_028754_MRT3(~0u)},
	{24017, S_028754_MRT4(~0u)},
	{24022, S_028754_MRT5(~0u)},
	{24027, S_028754_MRT6(~0u)},
	{24032, S_028754_MRT7(~0u)},
	/* 1415 */
	{24117, S_028758_MRT0_EPSILON(~0u), 16, 822},
	{24130, S_028758_MRT1_EPSILON(~0u)},
	{24143, S_028758_MRT2_EPSILON(~0u)},
	{24156, S_028758_MRT3_EPSILON(~0u)},
	{24169, S_028758_MRT4_EPSILON(~0u)},
	{24182, S_028758_MRT5_EPSILON(~0u)},
	{24195, S_028758_MRT6_EPSILON(~0u)},
	{24208, S_028758_MRT7_EPSILON(~0u)},
	/* 1423 */
	{24221, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{24244, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{24267, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{24290, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{24313, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{24336, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{24359, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{24382, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{24405, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{24428, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{24451, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{24474, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{24497, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{24520, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{24543, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{24566, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{24589, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1440 */
	{24880, S_028760_COLOR_SRC_OPT(~0u), 8, 838},
	{24894, S_028760_COLOR_DST_OPT(~0u)},
	{25042, S_028760_COLOR_COMB_FCN(~0u), 8, 846},
	{25057, S_028760_ALPHA_SRC_OPT(~0u)},
	{25071, S_028760_ALPHA_DST_OPT(~0u)},
	{25085, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1446 */
	{24880, S_028764_COLOR_SRC_OPT(~0u)},
	{24894, S_028764_COLOR_DST_OPT(~0u)},
	{25042, S_028764_COLOR_COMB_FCN(~0u)},
	{25057, S_028764_ALPHA_SRC_OPT(~0u)},
	{25071, S_028764_ALPHA_DST_OPT(~0u)},
	{25085, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1452 */
	{24880, S_028768_COLOR_SRC_OPT(~0u)},
	{24894, S_028768_COLOR_DST_OPT(~0u)},
	{25042, S_028768_COLOR_COMB_FCN(~0u)},
	{25057, S_028768_ALPHA_SRC_OPT(~0u)},
	{25071, S_028768_ALPHA_DST_OPT(~0u)},
	{25085, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1458 */
	{24880, S_02876C_COLOR_SRC_OPT(~0u)},
	{24894, S_02876C_COLOR_DST_OPT(~0u)},
	{25042, S_02876C_COLOR_COMB_FCN(~0u)},
	{25057, S_02876C_ALPHA_SRC_OPT(~0u)},
	{25071, S_02876C_ALPHA_DST_OPT(~0u)},
	{25085, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1464 */
	{24880, S_028770_COLOR_SRC_OPT(~0u)},
	{24894, S_028770_COLOR_DST_OPT(~0u)},
	{25042, S_028770_COLOR_COMB_FCN(~0u)},
	{25057, S_028770_ALPHA_SRC_OPT(~0u)},
	{25071, S_028770_ALPHA_DST_OPT(~0u)},
	{25085, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1470 */
	{24880, S_028774_COLOR_SRC_OPT(~0u)},
	{24894, S_028774_COLOR_DST_OPT(~0u)},
	{25042, S_028774_COLOR_COMB_FCN(~0u)},
	{25057, S_028774_ALPHA_SRC_OPT(~0u)},
	{25071, S_028774_ALPHA_DST_OPT(~0u)},
	{25085, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1476 */
	{24880, S_028778_COLOR_SRC_OPT(~0u)},
	{24894, S_028778_COLOR_DST_OPT(~0u)},
	{25042, S_028778_COLOR_COMB_FCN(~0u)},
	{25057, S_028778_ALPHA_SRC_OPT(~0u)},
	{25071, S_028778_ALPHA_DST_OPT(~0u)},
	{25085, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1482 */
	{24880, S_02877C_COLOR_SRC_OPT(~0u)},
	{24894, S_02877C_COLOR_DST_OPT(~0u)},
	{25042, S_02877C_COLOR_COMB_FCN(~0u)},
	{25057, S_02877C_ALPHA_SRC_OPT(~0u)},
	{25071, S_02877C_ALPHA_DST_OPT(~0u)},
	{25085, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1488 */
	{25494, S_028780_COLOR_SRCBLEND(~0u), 21, 854},
	{25042, S_028780_COLOR_COMB_FCN(~0u), 5, 875},
	{25599, S_028780_COLOR_DESTBLEND(~0u), 21, 854},
	{25615, S_028780_ALPHA_SRCBLEND(~0u), 21, 854},
	{25085, S_028780_ALPHA_COMB_FCN(~0u), 5, 875},
	{25630, S_028780_ALPHA_DESTBLEND(~0u), 21, 854},
	{25646, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{8435, S_028780_ENABLE(~0u)},
	{25667, S_028780_DISABLE_ROP3(~0u)},
	/* 1497 */
	{25680, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1498 */
	{25693, S_0287E4_BASE_ADDR(~0u)},
	/* 1499 */
	{25781, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{25827, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{25838, S_0287F0_NOT_EOP(~0u)},
	{25846, S_0287F0_USE_OPAQUE(~0u)},
	/* 1503 */
	{25857, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1504 */
	{25869, S_028800_STENCIL_ENABLE(~0u)},
	{18015, S_028800_Z_ENABLE(~0u)},
	{25884, S_028800_Z_WRITE_ENABLE(~0u)},
	{25899, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{18815, S_028800_ZFUNC(~0u), 8, 886},
	{26014, S_028800_BACKFACE_ENABLE(~0u)},
	{26117, S_028800_STENCILFUNC(~0u), 8, 894},
	{26129, S_028800_STENCILFUNC_BF(~0u), 8, 894},
	{26144, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{26178, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1514 */
	{26213, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{26232, S_028804_PS_ITER_SAMPLES(~0u)},
	{26248, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{26272, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{26298, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{26325, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{26347, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{26366, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{26384, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{26411, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{26438, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{26463, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1526 */
	{26494, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{26512, S_028808_DEGAMMA_ENABLE(~0u)},
	{12371, S_028808_MODE(~0u), 7, 902},
	{25675, S_028808_ROP3(~0u), 256, 909},
	/* 1530 */
	{26817, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{26833, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{26864, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{18073, S_02880C_Z_ORDER(~0u), 4, 1165},
	{26943, S_02880C_KILL_ENABLE(~0u)},
	{26955, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{26979, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{26998, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{27016, S_02880C_EXEC_ON_NOOP(~0u)},
	{27029, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{27051, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{27141, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{27163, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1543 */
	{27181, S_028810_UCP_ENA_0(~0u)},
	{27191, S_028810_UCP_ENA_1(~0u)},
	{27201, S_028810_UCP_ENA_2(~0u)},
	{27211, S_028810_UCP_ENA_3(~0u)},
	{27221, S_028810_UCP_ENA_4(~0u)},
	{27231, S_028810_UCP_ENA_5(~0u)},
	{27241, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{27260, S_028810_PS_UCP_MODE(~0u)},
	{27272, S_028810_CLIP_DISABLE(~0u)},
	{27285, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{27303, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{27326, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{27344, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{27364, S_028810_VTX_KILL_OR(~0u)},
	{27376, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{27398, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{27422, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{27448, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{27467, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1562 */
	{27485, S_028814_CULL_FRONT(~0u)},
	{27496, S_028814_CULL_BACK(~0u)},
	{27506, S_028814_FACE(~0u)},
	{27521, S_028814_POLY_MODE(~0u), 2, 1173},
	{27587, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{27608, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{27628, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{27653, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{27677, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{27701, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{27726, S_028814_PROVOKING_VTX_LAST(~0u)},
	{27745, S_028814_PERSP_CORR_DIS(~0u)},
	{27760, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1575 */
	{27778, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{27796, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{27815, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{27833, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{27852, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{27870, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{27889, S_028818_VTX_XY_FMT(~0u)},
	{27900, S_028818_VTX_Z_FMT(~0u)},
	{27910, S_028818_VTX_W0_FMT(~0u)},
	/* 1584 */
	{27921, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{27937, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{27953, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{27969, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{27985, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{28001, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{28017, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{28033, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{28049, S_02881C_CULL_DIST_ENA_0(~0u)},
	{28065, S_02881C_CULL_DIST_ENA_1(~0u)},
	{28081, S_02881C_CULL_DIST_ENA_2(~0u)},
	{28097, S_02881C_CULL_DIST_ENA_3(~0u)},
	{28113, S_02881C_CULL_DIST_ENA_4(~0u)},
	{28129, S_02881C_CULL_DIST_ENA_5(~0u)},
	{28145, S_02881C_CULL_DIST_ENA_6(~0u)},
	{28161, S_02881C_CULL_DIST_ENA_7(~0u)},
	{28177, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{28196, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{28214, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{28241, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{28263, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{28281, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{28301, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{28324, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{28347, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{28372, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{28392, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1611 */
	{28411, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{28430, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{28448, S_028820_VTE_W_INF_DISCARD(~0u)},
	{28466, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{28484, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{28502, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{28519, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{28536, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{28557, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{28574, S_028820_VS_XY_INF_RETAIN(~0u)},
	{28591, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{28607, S_028820_VS_Z_INF_RETAIN(~0u)},
	{28623, S_028820_VS_W_NAN_TO_INF(~0u)},
	{28639, S_028820_VS_W_INF_RETAIN(~0u)},
	{28655, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{28680, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1627 */
	{28700, S_028824_LINE_STIPPLE_RESET(~0u)},
	{28719, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{28738, S_028824_FRACTIONAL_ACCUM(~0u)},
	{28755, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1631 */
	{28770, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{28794, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{28814, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{28835, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{28860, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{28880, S_02882C_LINE_EXPAND_ENA(~0u)},
	{28896, S_02882C_POINT_EXPAND_ENA(~0u)},
	{28913, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{28934, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{28955, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{28976, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1642 */
	{11283, S_028A00_HEIGHT(~0u)},
	{11277, S_028A00_WIDTH(~0u)},
	/* 1644 */
	{28998, S_028A04_MIN_SIZE(~0u)},
	{29007, S_028A04_MAX_SIZE(~0u)},
	/* 1646 */
	{11277, S_028A08_WIDTH(~0u)},
	/* 1647 */
	{29016, S_028A0C_LINE_PATTERN(~0u)},
	{29029, S_028A0C_REPEAT_COUNT(~0u)},
	{29042, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{29060, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1651 */
	{29181, S_028A10_PATH_SELECT(~0u), 5, 1178},
	/* 1652 */
	{29193, S_028A14_TESS_MODE(~0u)},
	/* 1653 */
	{29203, S_028A20_REUSE_DEPTH(~0u)},
	/* 1654 */
	{5900, S_028A24_PRIM_TYPE(~0u), 18, 1183},
	{29570, S_028A24_RETAIN_ORDER(~0u)},
	{29583, S_028A24_RETAIN_QUADS(~0u)},
	{29664, S_028A24_PRIM_ORDER(~0u), 5, 1201},
	/* 1658 */
	{29675, S_028A28_FIRST_DECR(~0u)},
	/* 1659 */
	{29681, S_028A2C_DECR(~0u)},
	/* 1660 */
	{29686, S_028A30_COMP_X_EN(~0u)},
	{29696, S_028A30_COMP_Y_EN(~0u)},
	{29706, S_028A30_COMP_Z_EN(~0u)},
	{29716, S_028A30_COMP_W_EN(~0u)},
	{8406, S_028A30_STRIDE(~0u)},
	{29726, S_028A30_SHIFT(~0u)},
	/* 1666 */
	{29686, S_028A34_COMP_X_EN(~0u)},
	{29696, S_028A34_COMP_Y_EN(~0u)},
	{29706, S_028A34_COMP_Z_EN(~0u)},
	{29716, S_028A34_COMP_W_EN(~0u)},
	{8406, S_028A34_STRIDE(~0u)},
	{29726, S_028A34_SHIFT(~0u)},
	/* 1672 */
	{29891, S_028A38_X_CONV(~0u), 9, 1206},
	{19308, S_028A38_X_OFFSET(~0u)},
	{29898, S_028A38_Y_CONV(~0u), 9, 1206},
	{19324, S_028A38_Y_OFFSET(~0u)},
	{29905, S_028A38_Z_CONV(~0u), 9, 1206},
	{29912, S_028A38_Z_OFFSET(~0u)},
	{29921, S_028A38_W_CONV(~0u), 9, 1206},
	{29928, S_028A38_W_OFFSET(~0u)},
	/* 1680 */
	{29891, S_028A3C_X_CONV(~0u), 9, 1206},
	{19308, S_028A3C_X_OFFSET(~0u)},
	{29898, S_028A3C_Y_CONV(~0u), 9, 1206},
	{19324, S_028A3C_Y_OFFSET(~0u)},
	{29905, S_028A3C_Z_CONV(~0u), 9, 1206},
	{29912, S_028A3C_Z_OFFSET(~0u)},
	{29921, S_028A3C_W_CONV(~0u), 9, 1206},
	{29928, S_028A3C_W_OFFSET(~0u)},
	/* 1688 */
	{12371, S_028A40_MODE(~0u), 6, 1215},
	{8467, S_028A40_RESERVED_0(~0u)},
	{30055, S_028A40_CUT_MODE(~0u), 4, 1221},
	{8485, S_028A40_RESERVED_1(~0u)},
	{30064, S_028A40_GS_C_PACK_EN(~0u)},
	{30077, S_028A40_RESERVED_2(~0u)},
	{30088, S_028A40_ES_PASSTHRU(~0u)},
	{30100, S_028A40_COMPUTE_MODE(~0u)},
	{30113, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{30131, S_028A40_ELEMENT_INFO_EN(~0u)},
	{30147, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{30166, S_028A40_SUPPRESS_CUTS(~0u)},
	{30180, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{30198, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{30249, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 1703 */
	{30256, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{30276, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1705 */
	{30296, S_028A48_MSAA_ENABLE(~0u)},
	{30308, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{30329, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{30349, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1709 */
	{30374, S_028A4C_WALK_SIZE(~0u)},
	{30384, S_028A4C_WALK_ALIGNMENT(~0u)},
	{30399, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{30424, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{30442, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{30458, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{30463, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{30486, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{30505, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{30527, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{30543, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{30559, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{30575, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{30594, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{30620, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{30635, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{30675, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{30702, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{30725, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{30741, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{30771, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{30795, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{30816, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{30846, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1733 */
	{30870, S_028A54_GS_PER_ES(~0u)},
	/* 1734 */
	{30880, S_028A58_ES_PER_GS(~0u)},
	/* 1735 */
	{30890, S_028A5C_GS_PER_VS(~0u)},
	/* 1736 */
	{665, S_028A60_OFFSET(~0u)},
	/* 1737 */
	{665, S_028A64_OFFSET(~0u)},
	/* 1738 */
	{665, S_028A68_OFFSET(~0u)},
	/* 1739 */
	{30968, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1229},
	{30981, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{30996, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{31011, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{31026, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1744 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{31163, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{31224, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{31266, S_028A7C_RDREQ_POLICY(~0u), 2, 1242},
	{31279, S_028A7C_RDREQ_POLICY_VI(~0u)},
	{9191, S_028A7C_ATC(~0u)},
	{25838, S_028A7C_NOT_EOP(~0u)},
	{31295, S_028A7C_REQ_PATH(~0u)},
	{9212, S_028A7C_MTYPE(~0u)},
	/* 1753 */
	{31304, S_028A84_PRIMITIVEID_EN(~0u)},
	{31319, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1755 */
	{32275, S_028A90_EVENT_TYPE(~0u), 65, 1244},
	{8395, S_028A90_ADDRESS_HI(~0u)},
	{32286, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1758 */
	{32301, S_028A94_RESET_EN(~0u)},
	/* 1759 */
	{32310, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{32325, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{32344, S_028AA8_SWITCH_ON_EOP(~0u)},
	{32358, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{32377, S_028AA8_SWITCH_ON_EOI(~0u)},
	{32391, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{32408, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1766 */
	{32428, S_028AAC_ITEMSIZE(~0u)},
	/* 1767 */
	{32428, S_028AB0_ITEMSIZE(~0u)},
	/* 1768 */
	{32437, S_028AB4_REUSE_OFF(~0u)},
	/* 1769 */
	{32447, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1770 */
	{12476, S_028ABC_LINEAR(~0u)},
	{32458, S_028ABC_FULL_CACHE(~0u)},
	{32469, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{32492, S_028ABC_PRELOAD(~0u)},
	{32500, S_028ABC_PREFETCH_WIDTH(~0u)},
	{32515, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{32531, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{32555, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1778 */
	{32569, S_028AC0_COMPAREFUNC0(~0u), 8, 894},
	{32582, S_028AC0_COMPAREVALUE0(~0u)},
	{32596, S_028AC0_COMPAREMASK0(~0u)},
	{18034, S_028AC0_ENABLE0(~0u)},
	/* 1782 */
	{32609, S_028AC4_COMPAREFUNC1(~0u), 8, 894},
	{32622, S_028AC4_COMPAREVALUE1(~0u)},
	{32636, S_028AC4_COMPAREMASK1(~0u)},
	{18052, S_028AC4_ENABLE1(~0u)},
	/* 1786 */
	{32649, S_028AC8_START_X(~0u)},
	{32657, S_028AC8_START_Y(~0u)},
	{32665, S_028AC8_MAX_X(~0u)},
	{32671, S_028AC8_MAX_Y(~0u)},
	/* 1790 */
	{8406, S_028AD4_STRIDE(~0u)},
	/* 1791 */
	{8406, S_028AE4_STRIDE(~0u)},
	/* 1792 */
	{8406, S_028AF4_STRIDE(~0u)},
	/* 1793 */
	{8406, S_028B04_STRIDE(~0u)},
	/* 1794 */
	{32677, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1795 */
	{32691, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1796 */
	{32704, S_028B50_ACCUM_ISOLINE(~0u)},
	{32718, S_028B50_ACCUM_TRI(~0u)},
	{32728, S_028B50_ACCUM_QUAD(~0u)},
	{32739, S_028B50_DONUT_SPLIT(~0u)},
	/* 1800 */
	{17199, S_028B54_LS_EN(~0u), 3, 1309},
	{17193, S_028B54_HS_EN(~0u)},
	{17187, S_028B54_ES_EN(~0u), 3, 1312},
	{17181, S_028B54_GS_EN(~0u)},
	{17175, S_028B54_VS_EN(~0u), 3, 1315},
	{32874, S_028B54_DYNAMIC_HS(~0u)},
	{15730, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{32885, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{32905, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{32925, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1810 */
	{32939, S_028B58_NUM_PATCHES(~0u)},
	{32951, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{32967, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1813 */
	{32428, S_028B5C_ITEMSIZE(~0u)},
	/* 1814 */
	{32428, S_028B60_ITEMSIZE(~0u)},
	/* 1815 */
	{32428, S_028B64_ITEMSIZE(~0u)},
	/* 1816 */
	{32428, S_028B68_ITEMSIZE(~0u)},
	/* 1817 */
	{209, S_028B6C_TYPE(~0u), 3, 1318},
	{33073, S_028B6C_PARTITIONING(~0u), 4, 1321},
	{33150, S_028B6C_TOPOLOGY(~0u), 4, 1325},
	{33159, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{33179, S_028B6C_DEPRECATED(~0u)},
	{33190, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{33212, S_028B6C_DISABLE_DONUTS(~0u)},
	{31266, S_028B6C_RDREQ_POLICY(~0u), 3, 1329},
	{31279, S_028B6C_RDREQ_POLICY_VI(~0u)},
	{33322, S_028B6C_DISTRIBUTION_MODE(~0u), 3, 1332},
	{9212, S_028B6C_MTYPE(~0u)},
	/* 1828 */
	{33340, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{33361, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{33383, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{33405, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{33427, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{33449, S_028B70_OFFSET_ROUND(~0u)},
	/* 1834 */
	{33462, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{33490, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1836 */
	{8435, S_028B90_ENABLE(~0u)},
	{15646, S_028B90_CNT(~0u)},
	/* 1838 */
	{33518, S_028B94_STREAMOUT_0_EN(~0u)},
	{33533, S_028B94_STREAMOUT_1_EN(~0u)},
	{33548, S_028B94_STREAMOUT_2_EN(~0u)},
	{33563, S_028B94_STREAMOUT_3_EN(~0u)},
	{33578, S_028B94_RAST_STREAM(~0u)},
	{33590, S_028B94_RAST_STREAM_MASK(~0u)},
	{33607, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1845 */
	{33628, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{33647, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{33666, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{33685, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1849 */
	{33704, S_028BD4_DISTANCE_0(~0u)},
	{33715, S_028BD4_DISTANCE_1(~0u)},
	{33726, S_028BD4_DISTANCE_2(~0u)},
	{33737, S_028BD4_DISTANCE_3(~0u)},
	{33748, S_028BD4_DISTANCE_4(~0u)},
	{33759, S_028BD4_DISTANCE_5(~0u)},
	{33770, S_028BD4_DISTANCE_6(~0u)},
	{33781, S_028BD4_DISTANCE_7(~0u)},
	/* 1857 */
	{33792, S_028BD8_DISTANCE_8(~0u)},
	{33803, S_028BD8_DISTANCE_9(~0u)},
	{33814, S_028BD8_DISTANCE_10(~0u)},
	{33826, S_028BD8_DISTANCE_11(~0u)},
	{33838, S_028BD8_DISTANCE_12(~0u)},
	{33850, S_028BD8_DISTANCE_13(~0u)},
	{33862, S_028BD8_DISTANCE_14(~0u)},
	{33874, S_028BD8_DISTANCE_15(~0u)},
	/* 1865 */
	{33886, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{33904, S_028BDC_LAST_PIXEL(~0u)},
	{33915, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{33940, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1869 */
	{33962, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{33979, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{34001, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{34017, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{34038, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1874 */
	{34061, S_028BE4_PIX_CENTER(~0u)},
	{34122, S_028BE4_ROUND_MODE(~0u), 4, 1335},
	{34338, S_028BE4_QUANT_MODE(~0u), 8, 1339},
	/* 1877 */
	{34349, S_028BF8_S0_X(~0u)},
	{34354, S_028BF8_S0_Y(~0u)},
	{34359, S_028BF8_S1_X(~0u)},
	{34364, S_028BF8_S1_Y(~0u)},
	{34369, S_028BF8_S2_X(~0u)},
	{34374, S_028BF8_S2_Y(~0u)},
	{34379, S_028BF8_S3_X(~0u)},
	{34384, S_028BF8_S3_Y(~0u)},
	/* 1885 */
	{34389, S_028BFC_S4_X(~0u)},
	{34394, S_028BFC_S4_Y(~0u)},
	{34399, S_028BFC_S5_X(~0u)},
	{34404, S_028BFC_S5_Y(~0u)},
	{34409, S_028BFC_S6_X(~0u)},
	{34414, S_028BFC_S6_Y(~0u)},
	{34419, S_028BFC_S7_X(~0u)},
	{34424, S_028BFC_S7_Y(~0u)},
	/* 1893 */
	{34429, S_028C00_S8_X(~0u)},
	{34434, S_028C00_S8_Y(~0u)},
	{34439, S_028C00_S9_X(~0u)},
	{34444, S_028C00_S9_Y(~0u)},
	{34449, S_028C00_S10_X(~0u)},
	{34455, S_028C00_S10_Y(~0u)},
	{34461, S_028C00_S11_X(~0u)},
	{34467, S_028C00_S11_Y(~0u)},
	/* 1901 */
	{34473, S_028C04_S12_X(~0u)},
	{34479, S_028C04_S12_Y(~0u)},
	{34485, S_028C04_S13_X(~0u)},
	{34491, S_028C04_S13_Y(~0u)},
	{34497, S_028C04_S14_X(~0u)},
	{34503, S_028C04_S14_Y(~0u)},
	{34509, S_028C04_S15_X(~0u)},
	{34515, S_028C04_S15_Y(~0u)},
	/* 1909 */
	{34349, S_028C08_S0_X(~0u)},
	{34354, S_028C08_S0_Y(~0u)},
	{34359, S_028C08_S1_X(~0u)},
	{34364, S_028C08_S1_Y(~0u)},
	{34369, S_028C08_S2_X(~0u)},
	{34374, S_028C08_S2_Y(~0u)},
	{34379, S_028C08_S3_X(~0u)},
	{34384, S_028C08_S3_Y(~0u)},
	/* 1917 */
	{34389, S_028C0C_S4_X(~0u)},
	{34394, S_028C0C_S4_Y(~0u)},
	{34399, S_028C0C_S5_X(~0u)},
	{34404, S_028C0C_S5_Y(~0u)},
	{34409, S_028C0C_S6_X(~0u)},
	{34414, S_028C0C_S6_Y(~0u)},
	{34419, S_028C0C_S7_X(~0u)},
	{34424, S_028C0C_S7_Y(~0u)},
	/* 1925 */
	{34429, S_028C10_S8_X(~0u)},
	{34434, S_028C10_S8_Y(~0u)},
	{34439, S_028C10_S9_X(~0u)},
	{34444, S_028C10_S9_Y(~0u)},
	{34449, S_028C10_S10_X(~0u)},
	{34455, S_028C10_S10_Y(~0u)},
	{34461, S_028C10_S11_X(~0u)},
	{34467, S_028C10_S11_Y(~0u)},
	/* 1933 */
	{34473, S_028C14_S12_X(~0u)},
	{34479, S_028C14_S12_Y(~0u)},
	{34485, S_028C14_S13_X(~0u)},
	{34491, S_028C14_S13_Y(~0u)},
	{34497, S_028C14_S14_X(~0u)},
	{34503, S_028C14_S14_Y(~0u)},
	{34509, S_028C14_S15_X(~0u)},
	{34515, S_028C14_S15_Y(~0u)},
	/* 1941 */
	{34349, S_028C18_S0_X(~0u)},
	{34354, S_028C18_S0_Y(~0u)},
	{34359, S_028C18_S1_X(~0u)},
	{34364, S_028C18_S1_Y(~0u)},
	{34369, S_028C18_S2_X(~0u)},
	{34374, S_028C18_S2_Y(~0u)},
	{34379, S_028C18_S3_X(~0u)},
	{34384, S_028C18_S3_Y(~0u)},
	/* 1949 */
	{34389, S_028C1C_S4_X(~0u)},
	{34394, S_028C1C_S4_Y(~0u)},
	{34399, S_028C1C_S5_X(~0u)},
	{34404, S_028C1C_S5_Y(~0u)},
	{34409, S_028C1C_S6_X(~0u)},
	{34414, S_028C1C_S6_Y(~0u)},
	{34419, S_028C1C_S7_X(~0u)},
	{34424, S_028C1C_S7_Y(~0u)},
	/* 1957 */
	{34429, S_028C20_S8_X(~0u)},
	{34434, S_028C20_S8_Y(~0u)},
	{34439, S_028C20_S9_X(~0u)},
	{34444, S_028C20_S9_Y(~0u)},
	{34449, S_028C20_S10_X(~0u)},
	{34455, S_028C20_S10_Y(~0u)},
	{34461, S_028C20_S11_X(~0u)},
	{34467, S_028C20_S11_Y(~0u)},
	/* 1965 */
	{34473, S_028C24_S12_X(~0u)},
	{34479, S_028C24_S12_Y(~0u)},
	{34485, S_028C24_S13_X(~0u)},
	{34491, S_028C24_S13_Y(~0u)},
	{34497, S_028C24_S14_X(~0u)},
	{34503, S_028C24_S14_Y(~0u)},
	{34509, S_028C24_S15_X(~0u)},
	{34515, S_028C24_S15_Y(~0u)},
	/* 1973 */
	{34349, S_028C28_S0_X(~0u)},
	{34354, S_028C28_S0_Y(~0u)},
	{34359, S_028C28_S1_X(~0u)},
	{34364, S_028C28_S1_Y(~0u)},
	{34369, S_028C28_S2_X(~0u)},
	{34374, S_028C28_S2_Y(~0u)},
	{34379, S_028C28_S3_X(~0u)},
	{34384, S_028C28_S3_Y(~0u)},
	/* 1981 */
	{34389, S_028C2C_S4_X(~0u)},
	{34394, S_028C2C_S4_Y(~0u)},
	{34399, S_028C2C_S5_X(~0u)},
	{34404, S_028C2C_S5_Y(~0u)},
	{34409, S_028C2C_S6_X(~0u)},
	{34414, S_028C2C_S6_Y(~0u)},
	{34419, S_028C2C_S7_X(~0u)},
	{34424, S_028C2C_S7_Y(~0u)},
	/* 1989 */
	{34429, S_028C30_S8_X(~0u)},
	{34434, S_028C30_S8_Y(~0u)},
	{34439, S_028C30_S9_X(~0u)},
	{34444, S_028C30_S9_Y(~0u)},
	{34449, S_028C30_S10_X(~0u)},
	{34455, S_028C30_S10_Y(~0u)},
	{34461, S_028C30_S11_X(~0u)},
	{34467, S_028C30_S11_Y(~0u)},
	/* 1997 */
	{34473, S_028C34_S12_X(~0u)},
	{34479, S_028C34_S12_Y(~0u)},
	{34485, S_028C34_S13_X(~0u)},
	{34491, S_028C34_S13_Y(~0u)},
	{34497, S_028C34_S14_X(~0u)},
	{34503, S_028C34_S14_Y(~0u)},
	{34509, S_028C34_S15_X(~0u)},
	{34515, S_028C34_S15_Y(~0u)},
	/* 2005 */
	{34521, S_028C38_AA_MASK_X0Y0(~0u)},
	{34534, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2007 */
	{34547, S_028C3C_AA_MASK_X0Y1(~0u)},
	{34560, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2009 */
	{34573, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2010 */
	{34602, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2011 */
	{34618, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2012 */
	{19261, S_028C64_TILE_MAX(~0u)},
	{34631, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2014 */
	{19261, S_028C68_TILE_MAX(~0u)},
	/* 2015 */
	{17903, S_028C6C_SLICE_START(~0u)},
	{17915, S_028C6C_SLICE_MAX(~0u)},
	/* 2017 */
	{34697, S_028C70_ENDIAN(~0u), 4, 1347},
	{8750, S_028C70_FORMAT(~0u), 23, 1351},
	{14118, S_028C70_LINEAR_GENERAL(~0u)},
	{35064, S_028C70_NUMBER_TYPE(~0u), 8, 1374},
	{35120, S_028C70_COMP_SWAP(~0u), 4, 1382},
	{26561, S_028C70_FAST_CLEAR(~0u)},
	{18489, S_028C70_COMPRESSION(~0u)},
	{35130, S_028C70_BLEND_CLAMP(~0u)},
	{35142, S_028C70_BLEND_BYPASS(~0u)},
	{35155, S_028C70_SIMPLE_FLOAT(~0u)},
	{34122, S_028C70_ROUND_MODE(~0u)},
	{35168, S_028C70_CMASK_IS_LINEAR(~0u)},
	{35395, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1386},
	{35417, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1386},
	{35441, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{35467, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{35493, S_028C70_DCC_ENABLE(~0u)},
	{35504, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2035 */
	{19089, S_028C74_TILE_MODE_INDEX(~0u)},
	{35520, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{35542, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{19077, S_028C74_NUM_SAMPLES(~0u)},
	{35560, S_028C74_NUM_FRAGMENTS(~0u)},
	{35574, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2041 */
	{21633, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{35592, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{35609, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{35637, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{35663, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{11765, S_028C78_COLOR_TRANSFORM(~0u)},
	{35689, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{35712, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{35732, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2050 */
	{19261, S_028C80_TILE_MAX(~0u)},
	/* 2051 */
	{19261, S_028C88_TILE_MAX(~0u)},
};

static const struct si_reg sid_reg_table[] = {
	{195, R_370_CONTROL, 4, 0},
	{1039, R_371_DST_ADDR_LO},
	{1051, R_372_DST_ADDR_HI},
	{35754, R_410_CP_DMA_WORD0, 1, 4},
	{35767, R_411_CP_DMA_WORD1, 5, 5},
	{35780, R_412_CP_DMA_WORD2, 1, 10},
	{35793, R_413_CP_DMA_WORD3, 1, 11},
	{35806, R_414_COMMAND, 9, 12},
	{35814, R_500_DMA_DATA_WORD0, 4, 21},
	{936, R_501_SRC_ADDR_LO},
	{1027, R_502_SRC_ADDR_HI},
	{1039, R_503_DST_ADDR_LO},
	{1051, R_504_DST_ADDR_HI},
	{35829, R_000E4C_SRBM_STATUS2, 21, 25},
	{35842, R_000E50_SRBM_STATUS, 20, 46},
	{35854, R_000E54_SRBM_STATUS3, 16, 66},
	{35867, R_00D034_SDMA0_STATUS_REG, 29, 82},
	{35884, R_00D834_SDMA1_STATUS_REG, 29, 82},
	{35901, R_008008_GRBM_STATUS2, 18, 111},
	{35914, R_008010_GRBM_STATUS, 24, 129},
	{35926, R_0084FC_CP_STRMOUT_CNTL, 1, 153},
	{35942, R_0085F0_CP_COHER_CNTL, 19, 154},
	{35956, R_0085F4_CP_COHER_SIZE},
	{35970, R_0085F8_CP_COHER_BASE},
	{35984, R_008014_GRBM_STATUS_SE0, 11, 173},
	{36000, R_008018_GRBM_STATUS_SE1, 11, 184},
	{36016, R_008038_GRBM_STATUS_SE2, 11, 195},
	{36032, R_00803C_GRBM_STATUS_SE3, 11, 206},
	{35926, R_0300FC_CP_STRMOUT_CNTL, 1, 217},
	{36048, R_0301E4_CP_COHER_BASE_HI, 1, 218},
	{36065, R_0301EC_CP_COHER_START_DELAY, 1, 219},
	{35942, R_0301F0_CP_COHER_CNTL, 27, 220},
	{35956, R_0301F4_CP_COHER_SIZE},
	{35970, R_0301F8_CP_COHER_BASE},
	{36086, R_0301FC_CP_COHER_STATUS, 4, 247},
	{36102, R_008210_CP_CPC_STATUS, 15, 251},
	{36116, R_008214_CP_CPC_BUSY_STAT, 28, 266},
	{36133, R_008218_CP_CPC_STALLED_STAT1, 14, 294},
	{36154, R_00821C_CP_CPF_STATUS, 21, 308},
	{36168, R_008220_CP_CPF_BUSY_STAT, 31, 329},
	{36185, R_008224_CP_CPF_STALLED_STAT1, 9, 360},
	{36206, R_030230_CP_COHER_SIZE_HI, 1, 369},
	{36223, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 370},
	{36246, R_0088C4_VGT_CACHE_INVALIDATION, 3, 371},
	{36269, R_0088C8_VGT_ESGS_RING_SIZE},
	{36288, R_0088CC_VGT_GSVS_RING_SIZE},
	{36307, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 374},
	{36327, R_008958_VGT_PRIMITIVE_TYPE, 1, 375},
	{36346, R_00895C_VGT_INDEX_TYPE, 1, 376},
	{36361, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36394, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36427, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36460, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36493, R_008970_VGT_NUM_INDICES},
	{36509, R_008974_VGT_NUM_INSTANCES},
	{36527, R_008988_VGT_TF_RING_SIZE, 1, 377},
	{36544, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 378},
	{36565, R_0089B8_VGT_TF_MEMORY_BASE},
	{36584, R_008A14_PA_CL_ENHANCE, 4, 379},
	{36598, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 383},
	{36623, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 384},
	{36648, R_008670_CP_STALLED_STAT3, 19, 386},
	{36665, R_008674_CP_STALLED_STAT1, 16, 405},
	{36682, R_008678_CP_STALLED_STAT2, 29, 421},
	{36699, R_008680_CP_STAT, 23, 450},
	{36707, R_030800_GRBM_GFX_INDEX, 6, 473},
	{36269, R_030900_VGT_ESGS_RING_SIZE},
	{36288, R_030904_VGT_GSVS_RING_SIZE},
	{36327, R_030908_VGT_PRIMITIVE_TYPE, 1, 479},
	{36346, R_03090C_VGT_INDEX_TYPE, 1, 480},
	{36361, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36394, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36427, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36460, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36493, R_030930_VGT_NUM_INDICES},
	{36509, R_030934_VGT_NUM_INSTANCES},
	{36527, R_030938_VGT_TF_RING_SIZE, 1, 481},
	{36544, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 482},
	{36565, R_030940_VGT_TF_MEMORY_BASE},
	{36598, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 484},
	{36623, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 485},
	{36722, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 487},
	{36748, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 489},
	{36774, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 491},
	{36800, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 493},
	{36826, R_008BF0_PA_SC_ENHANCE, 9, 495},
	{36840, R_008C08_SQC_CACHES, 2, 504},
	{36840, R_030D20_SQC_CACHES, 3, 506},
	{36851, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 509},
	{36870, R_008DFC_SQ_EXP_0, 6, 512},
	{36879, R_030E00_TA_CS_BC_BASE_ADDR},
	{36898, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 518},
	{36920, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{36944, R_008F00_SQ_BUF_RSRC_WORD0},
	{36962, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 519},
	{36985, R_008F04_SQ_BUF_RSRC_WORD1, 4, 520},
	{37003, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{37027, R_008F08_SQ_BUF_RSRC_WORD2},
	{37045, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 524},
	{37068, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 525},
	{37086, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{37110, R_008F10_SQ_IMG_RSRC_WORD0},
	{37128, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 539},
	{37151, R_008F14_SQ_IMG_RSRC_WORD1, 5, 540},
	{37169, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{37193, R_008F18_SQ_IMG_RSRC_WORD2, 4, 545},
	{37211, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 549},
	{37234, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 550},
	{37252, R_008F20_SQ_IMG_RSRC_WORD4, 2, 561},
	{37270, R_008F24_SQ_IMG_RSRC_WORD5, 2, 563},
	{37288, R_008F28_SQ_IMG_RSRC_WORD6, 8, 565},
	{37306, R_008F2C_SQ_IMG_RSRC_WORD7},
	{37324, R_008F30_SQ_IMG_SAMP_WORD0, 12, 573},
	{37342, R_008F34_SQ_IMG_SAMP_WORD1, 4, 585},
	{37360, R_008F38_SQ_IMG_SAMP_WORD2, 10, 589},
	{37378, R_008F3C_SQ_IMG_SAMP_WORD3, 2, 599},
	{37396, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 601},
	{37416, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 606},
	{37441, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 608},
	{37466, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 610},
	{37491, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 611},
	{37491, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 612},
	{37510, R_0090F0_SPI_ARB_PRIORITY, 3, 613},
	{37510, R_00C700_SPI_ARB_PRIORITY, 8, 616},
	{37527, R_0090F4_SPI_ARB_CYCLES_0, 2, 624},
	{37544, R_0090F8_SPI_ARB_CYCLES_1, 1, 626},
	{37561, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 627},
	{37583, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 628},
	{37605, R_030FF8_DB_ZPASS_COUNT_LOW},
	{37624, R_030FFC_DB_ZPASS_COUNT_HI, 1, 629},
	{37642, R_009100_SPI_CONFIG_CNTL, 5, 630},
	{37658, R_00913C_SPI_CONFIG_CNTL_1, 5, 635},
	{37676, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 640},
	{36879, R_00950C_TA_CS_BC_BASE_ADDR},
	{37705, R_009858_DB_SUBTILE_CONTROL, 10, 652},
	{37724, R_0098F8_GB_ADDR_CONFIG, 9, 662},
	{37739, R_009910_GB_TILE_MODE0, 10, 671},
	{37753, R_009914_GB_TILE_MODE1, 10, 671},
	{37767, R_009918_GB_TILE_MODE2, 10, 671},
	{37781, R_00991C_GB_TILE_MODE3, 10, 671},
	{37795, R_009920_GB_TILE_MODE4, 10, 671},
	{37809, R_009924_GB_TILE_MODE5, 10, 671},
	{37823, R_009928_GB_TILE_MODE6, 10, 671},
	{37837, R_00992C_GB_TILE_MODE7, 10, 671},
	{37851, R_009930_GB_TILE_MODE8, 10, 671},
	{37865, R_009934_GB_TILE_MODE9, 10, 671},
	{37879, R_009938_GB_TILE_MODE10, 10, 671},
	{37894, R_00993C_GB_TILE_MODE11, 10, 671},
	{37909, R_009940_GB_TILE_MODE12, 10, 671},
	{37924, R_009944_GB_TILE_MODE13, 10, 671},
	{37939, R_009948_GB_TILE_MODE14, 10, 671},
	{37954, R_00994C_GB_TILE_MODE15, 10, 671},
	{37969, R_009950_GB_TILE_MODE16, 10, 671},
	{37984, R_009954_GB_TILE_MODE17, 10, 671},
	{37999, R_009958_GB_TILE_MODE18, 10, 671},
	{38014, R_00995C_GB_TILE_MODE19, 10, 671},
	{38029, R_009960_GB_TILE_MODE20, 10, 671},
	{38044, R_009964_GB_TILE_MODE21, 10, 671},
	{38059, R_009968_GB_TILE_MODE22, 10, 671},
	{38074, R_00996C_GB_TILE_MODE23, 10, 671},
	{38089, R_009970_GB_TILE_MODE24, 10, 671},
	{38104, R_009974_GB_TILE_MODE25, 10, 671},
	{38119, R_009978_GB_TILE_MODE26, 10, 671},
	{38134, R_00997C_GB_TILE_MODE27, 10, 671},
	{38149, R_009980_GB_TILE_MODE28, 10, 671},
	{38164, R_009984_GB_TILE_MODE29, 10, 671},
	{38179, R_009988_GB_TILE_MODE30, 10, 671},
	{38194, R_00998C_GB_TILE_MODE31, 10, 671},
	{38209, R_009990_GB_MACROTILE_MODE0, 4, 681},
	{38228, R_009994_GB_MACROTILE_MODE1, 4, 681},
	{38247, R_009998_GB_MACROTILE_MODE2, 4, 681},
	{38266, R_00999C_GB_MACROTILE_MODE3, 4, 681},
	{38285, R_0099A0_GB_MACROTILE_MODE4, 4, 681},
	{38304, R_0099A4_GB_MACROTILE_MODE5, 4, 681},
	{38323, R_0099A8_GB_MACROTILE_MODE6, 4, 681},
	{38342, R_0099AC_GB_MACROTILE_MODE7, 4, 681},
	{38361, R_0099B0_GB_MACROTILE_MODE8, 4, 681},
	{38380, R_0099B4_GB_MACROTILE_MODE9, 4, 681},
	{38399, R_0099B8_GB_MACROTILE_MODE10, 4, 681},
	{38419, R_0099BC_GB_MACROTILE_MODE11, 4, 681},
	{38439, R_0099C0_GB_MACROTILE_MODE12, 4, 681},
	{38459, R_0099C4_GB_MACROTILE_MODE13, 4, 681},
	{38479, R_0099C8_GB_MACROTILE_MODE14, 4, 681},
	{38499, R_0099CC_GB_MACROTILE_MODE15, 4, 681},
	{38519, R_00B000_SPI_SHADER_TBA_LO_PS},
	{38540, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 685},
	{38561, R_00B008_SPI_SHADER_TMA_LO_PS},
	{38582, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 686},
	{38603, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 687},
	{38627, R_00B020_SPI_SHADER_PGM_LO_PS},
	{38648, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 690},
	{38669, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 691},
	{38693, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 702},
	{38717, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{38743, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{38769, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{38795, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{38821, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{38847, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{38873, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{38899, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{38925, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{38951, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{38977, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{39004, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{39031, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{39058, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{39085, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{39112, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{39139, R_00B100_SPI_SHADER_TBA_LO_VS},
	{39160, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 709},
	{39181, R_00B108_SPI_SHADER_TMA_LO_VS},
	{39202, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 710},
	{39223, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 711},
	{39247, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 714},
	{39272, R_00B120_SPI_SHADER_PGM_LO_VS},
	{39293, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 715},
	{39314, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 716},
	{39338, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 728},
	{39362, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{39388, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{39414, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{39440, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{39466, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{39492, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{39518, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{39544, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{39570, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{39596, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{39622, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{39649, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{39676, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{39703, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{39730, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{39757, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{39784, R_00B200_SPI_SHADER_TBA_LO_GS},
	{39805, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 740},
	{39826, R_00B208_SPI_SHADER_TMA_LO_GS},
	{39847, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 741},
	{39868, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 742},
	{39892, R_00B220_SPI_SHADER_PGM_LO_GS},
	{39913, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 746},
	{39934, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 747},
	{39958, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 758},
	{39982, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{40008, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{40034, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{40060, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{40086, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{40112, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{40138, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{40164, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{40190, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{40216, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{40242, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{40269, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{40296, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{40323, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{40350, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{40377, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{40404, R_00B300_SPI_SHADER_TBA_LO_ES},
	{40425, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 763},
	{40446, R_00B308_SPI_SHADER_TMA_LO_ES},
	{40467, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 764},
	{40488, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 765},
	{40512, R_00B320_SPI_SHADER_PGM_LO_ES},
	{40533, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 769},
	{40554, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 770},
	{40578, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 6, 782},
	{40602, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{40628, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{40654, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{40680, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{40706, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{40732, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{40758, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{40784, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{40810, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{40836, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{40862, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{40889, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{40916, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{40943, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{40970, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{40997, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{41024, R_00B400_SPI_SHADER_TBA_LO_HS},
	{41045, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 788},
	{41066, R_00B408_SPI_SHADER_TMA_LO_HS},
	{41087, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 789},
	{41108, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 790},
	{41132, R_00B420_SPI_SHADER_PGM_LO_HS},
	{41153, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 793},
	{41174, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 794},
	{41198, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 6, 804},
	{41222, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{41248, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{41274, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{41300, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{41326, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{41352, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{41378, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{41404, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{41430, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{41456, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{41482, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{41509, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{41536, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{41563, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{41590, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{41617, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{41644, R_00B500_SPI_SHADER_TBA_LO_LS},
	{41665, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 810},
	{41686, R_00B508_SPI_SHADER_TMA_LO_LS},
	{41707, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 811},
	{41728, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 812},
	{41752, R_00B520_SPI_SHADER_PGM_LO_LS},
	{41773, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 816},
	{41794, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 817},
	{41818, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 5, 828},
	{41842, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{41868, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{41894, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{41920, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{41946, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{41972, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{41998, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{42024, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{42050, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{42076, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{42102, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{42129, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{42156, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{42183, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{42210, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{42237, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{42264, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 833},
	{42291, R_00B804_COMPUTE_DIM_X},
	{42305, R_00B808_COMPUTE_DIM_Y},
	{42319, R_00B80C_COMPUTE_DIM_Z},
	{42333, R_00B810_COMPUTE_START_X},
	{42349, R_00B814_COMPUTE_START_Y},
	{42365, R_00B818_COMPUTE_START_Z},
	{42381, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 845},
	{42402, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 847},
	{42423, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 849},
	{42444, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 851},
	{42464, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 852},
	{42492, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 853},
	{42517, R_00B830_COMPUTE_PGM_LO},
	{42532, R_00B834_COMPUTE_PGM_HI, 2, 854},
	{42547, R_00B838_COMPUTE_TBA_LO},
	{42562, R_00B83C_COMPUTE_TBA_HI, 1, 856},
	{42577, R_00B840_COMPUTE_TMA_LO},
	{42592, R_00B844_COMPUTE_TMA_HI, 1, 857},
	{42607, R_00B848_COMPUTE_PGM_RSRC1, 10, 858},
	{42625, R_00B84C_COMPUTE_PGM_RSRC2, 11, 868},
	{42643, R_00B850_COMPUTE_VMID, 1, 879},
	{42656, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 880},
	{42680, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 887},
	{42711, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 889},
	{42742, R_00B860_COMPUTE_TMPRING_SIZE, 2, 891},
	{42763, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 893},
	{42794, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 895},
	{42825, R_00B86C_COMPUTE_RESTART_X},
	{42843, R_00B870_COMPUTE_RESTART_Y},
	{42861, R_00B874_COMPUTE_RESTART_Z},
	{42879, R_00B87C_COMPUTE_MISC_RESERVED, 5, 897},
	{42901, R_00B880_COMPUTE_DISPATCH_ID},
	{42921, R_00B884_COMPUTE_THREADGROUP_ID},
	{42944, R_00B888_COMPUTE_RELAUNCH, 3, 902},
	{42961, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{42990, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 905},
	{43019, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 906},
	{43048, R_00B900_COMPUTE_USER_DATA_0},
	{43068, R_00B904_COMPUTE_USER_DATA_1},
	{43088, R_00B908_COMPUTE_USER_DATA_2},
	{43108, R_00B90C_COMPUTE_USER_DATA_3},
	{43128, R_00B910_COMPUTE_USER_DATA_4},
	{43148, R_00B914_COMPUTE_USER_DATA_5},
	{43168, R_00B918_COMPUTE_USER_DATA_6},
	{43188, R_00B91C_COMPUTE_USER_DATA_7},
	{43208, R_00B920_COMPUTE_USER_DATA_8},
	{43228, R_00B924_COMPUTE_USER_DATA_9},
	{43248, R_00B928_COMPUTE_USER_DATA_10},
	{43269, R_00B92C_COMPUTE_USER_DATA_11},
	{43290, R_00B930_COMPUTE_USER_DATA_12},
	{43311, R_00B934_COMPUTE_USER_DATA_13},
	{43332, R_00B938_COMPUTE_USER_DATA_14},
	{43353, R_00B93C_COMPUTE_USER_DATA_15},
	{43374, R_00B9FC_COMPUTE_NOWHERE},
	{43390, R_034000_CPG_PERFCOUNTER1_LO},
	{43410, R_034004_CPG_PERFCOUNTER1_HI},
	{43430, R_034008_CPG_PERFCOUNTER0_LO},
	{43450, R_03400C_CPG_PERFCOUNTER0_HI},
	{43470, R_034010_CPC_PERFCOUNTER1_LO},
	{43490, R_034014_CPC_PERFCOUNTER1_HI},
	{43510, R_034018_CPC_PERFCOUNTER0_LO},
	{43530, R_03401C_CPC_PERFCOUNTER0_HI},
	{43550, R_034020_CPF_PERFCOUNTER1_LO},
	{43570, R_034024_CPF_PERFCOUNTER1_HI},
	{43590, R_034028_CPF_PERFCOUNTER0_LO},
	{43610, R_03402C_CPF_PERFCOUNTER0_HI},
	{43630, R_034100_GRBM_PERFCOUNTER0_LO},
	{43651, R_034104_GRBM_PERFCOUNTER0_HI},
	{43672, R_03410C_GRBM_PERFCOUNTER1_LO},
	{43693, R_034110_GRBM_PERFCOUNTER1_HI},
	{43714, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{43738, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{43762, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{43786, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{43810, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{43834, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{43858, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{43882, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{43906, R_034200_WD_PERFCOUNTER0_LO},
	{43925, R_034204_WD_PERFCOUNTER0_HI},
	{43944, R_034208_WD_PERFCOUNTER1_LO},
	{43963, R_03420C_WD_PERFCOUNTER1_HI},
	{43982, R_034210_WD_PERFCOUNTER2_LO},
	{44001, R_034214_WD_PERFCOUNTER2_HI},
	{44020, R_034218_WD_PERFCOUNTER3_LO},
	{44039, R_03421C_WD_PERFCOUNTER3_HI},
	{44058, R_034220_IA_PERFCOUNTER0_LO},
	{44077, R_034224_IA_PERFCOUNTER0_HI},
	{44096, R_034228_IA_PERFCOUNTER1_LO},
	{44115, R_03422C_IA_PERFCOUNTER1_HI},
	{44134, R_034230_IA_PERFCOUNTER2_LO},
	{44153, R_034234_IA_PERFCOUNTER2_HI},
	{44172, R_034238_IA_PERFCOUNTER3_LO},
	{44191, R_03423C_IA_PERFCOUNTER3_HI},
	{44210, R_034240_VGT_PERFCOUNTER0_LO},
	{44230, R_034244_VGT_PERFCOUNTER0_HI},
	{44250, R_034248_VGT_PERFCOUNTER1_LO},
	{44270, R_03424C_VGT_PERFCOUNTER1_HI},
	{44290, R_034250_VGT_PERFCOUNTER2_LO},
	{44310, R_034254_VGT_PERFCOUNTER2_HI},
	{44330, R_034258_VGT_PERFCOUNTER3_LO},
	{44350, R_03425C_VGT_PERFCOUNTER3_HI},
	{44370, R_034400_PA_SU_PERFCOUNTER0_LO},
	{44392, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 908},
	{44414, R_034408_PA_SU_PERFCOUNTER1_LO},
	{44436, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 908},
	{44458, R_034410_PA_SU_PERFCOUNTER2_LO},
	{44480, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 908},
	{44502, R_034418_PA_SU_PERFCOUNTER3_LO},
	{44524, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 908},
	{44546, R_034500_PA_SC_PERFCOUNTER0_LO},
	{44568, R_034504_PA_SC_PERFCOUNTER0_HI},
	{44590, R_034508_PA_SC_PERFCOUNTER1_LO},
	{44612, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{44634, R_034510_PA_SC_PERFCOUNTER2_LO},
	{44656, R_034514_PA_SC_PERFCOUNTER2_HI},
	{44678, R_034518_PA_SC_PERFCOUNTER3_LO},
	{44700, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{44722, R_034520_PA_SC_PERFCOUNTER4_LO},
	{44744, R_034524_PA_SC_PERFCOUNTER4_HI},
	{44766, R_034528_PA_SC_PERFCOUNTER5_LO},
	{44788, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{44810, R_034530_PA_SC_PERFCOUNTER6_LO},
	{44832, R_034534_PA_SC_PERFCOUNTER6_HI},
	{44854, R_034538_PA_SC_PERFCOUNTER7_LO},
	{44876, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{44898, R_034600_SPI_PERFCOUNTER0_HI},
	{44918, R_034604_SPI_PERFCOUNTER0_LO},
	{44938, R_034608_SPI_PERFCOUNTER1_HI},
	{44958, R_03460C_SPI_PERFCOUNTER1_LO},
	{44978, R_034610_SPI_PERFCOUNTER2_HI},
	{44998, R_034614_SPI_PERFCOUNTER2_LO},
	{45018, R_034618_SPI_PERFCOUNTER3_HI},
	{45038, R_03461C_SPI_PERFCOUNTER3_LO},
	{45058, R_034620_SPI_PERFCOUNTER4_HI},
	{45078, R_034624_SPI_PERFCOUNTER4_LO},
	{45098, R_034628_SPI_PERFCOUNTER5_HI},
	{45118, R_03462C_SPI_PERFCOUNTER5_LO},
	{45138, R_034700_SQ_PERFCOUNTER0_LO},
	{45157, R_034704_SQ_PERFCOUNTER0_HI},
	{45176, R_034708_SQ_PERFCOUNTER1_LO},
	{45195, R_03470C_SQ_PERFCOUNTER1_HI},
	{45214, R_034710_SQ_PERFCOUNTER2_LO},
	{45233, R_034714_SQ_PERFCOUNTER2_HI},
	{45252, R_034718_SQ_PERFCOUNTER3_LO},
	{45271, R_03471C_SQ_PERFCOUNTER3_HI},
	{45290, R_034720_SQ_PERFCOUNTER4_LO},
	{45309, R_034724_SQ_PERFCOUNTER4_HI},
	{45328, R_034728_SQ_PERFCOUNTER5_LO},
	{45347, R_03472C_SQ_PERFCOUNTER5_HI},
	{45366, R_034730_SQ_PERFCOUNTER6_LO},
	{45385, R_034734_SQ_PERFCOUNTER6_HI},
	{45404, R_034738_SQ_PERFCOUNTER7_LO},
	{45423, R_03473C_SQ_PERFCOUNTER7_HI},
	{45442, R_034740_SQ_PERFCOUNTER8_LO},
	{45461, R_034744_SQ_PERFCOUNTER8_HI},
	{45480, R_034748_SQ_PERFCOUNTER9_LO},
	{45499, R_03474C_SQ_PERFCOUNTER9_HI},
	{45518, R_034750_SQ_PERFCOUNTER10_LO},
	{45538, R_034754_SQ_PERFCOUNTER10_HI},
	{45558, R_034758_SQ_PERFCOUNTER11_LO},
	{45578, R_03475C_SQ_PERFCOUNTER11_HI},
	{45598, R_034760_SQ_PERFCOUNTER12_LO},
	{45618, R_034764_SQ_PERFCOUNTER12_HI},
	{45638, R_034768_SQ_PERFCOUNTER13_LO},
	{45658, R_03476C_SQ_PERFCOUNTER13_HI},
	{45678, R_034770_SQ_PERFCOUNTER14_LO},
	{45698, R_034774_SQ_PERFCOUNTER14_HI},
	{45718, R_034778_SQ_PERFCOUNTER15_LO},
	{45738, R_03477C_SQ_PERFCOUNTER15_HI},
	{45758, R_034900_SX_PERFCOUNTER0_LO},
	{45777, R_034904_SX_PERFCOUNTER0_HI},
	{45796, R_034908_SX_PERFCOUNTER1_LO},
	{45815, R_03490C_SX_PERFCOUNTER1_HI},
	{45834, R_034910_SX_PERFCOUNTER2_LO},
	{45853, R_034914_SX_PERFCOUNTER2_HI},
	{45872, R_034918_SX_PERFCOUNTER3_LO},
	{45891, R_03491C_SX_PERFCOUNTER3_HI},
	{45910, R_034A00_GDS_PERFCOUNTER0_LO},
	{45930, R_034A04_GDS_PERFCOUNTER0_HI},
	{45950, R_034A08_GDS_PERFCOUNTER1_LO},
	{45970, R_034A0C_GDS_PERFCOUNTER1_HI},
	{45990, R_034A10_GDS_PERFCOUNTER2_LO},
	{46010, R_034A14_GDS_PERFCOUNTER2_HI},
	{46030, R_034A18_GDS_PERFCOUNTER3_LO},
	{46050, R_034A1C_GDS_PERFCOUNTER3_HI},
	{46070, R_034B00_TA_PERFCOUNTER0_LO},
	{46089, R_034B04_TA_PERFCOUNTER0_HI},
	{46108, R_034B08_TA_PERFCOUNTER1_LO},
	{46127, R_034B0C_TA_PERFCOUNTER1_HI},
	{46146, R_034C00_TD_PERFCOUNTER0_LO},
	{46165, R_034C04_TD_PERFCOUNTER0_HI},
	{46184, R_034C08_TD_PERFCOUNTER1_LO},
	{46203, R_034C0C_TD_PERFCOUNTER1_HI},
	{46222, R_034D00_TCP_PERFCOUNTER0_LO},
	{46242, R_034D04_TCP_PERFCOUNTER0_HI},
	{46262, R_034D08_TCP_PERFCOUNTER1_LO},
	{46282, R_034D0C_TCP_PERFCOUNTER1_HI},
	{46302, R_034D10_TCP_PERFCOUNTER2_LO},
	{46322, R_034D14_TCP_PERFCOUNTER2_HI},
	{46342, R_034D18_TCP_PERFCOUNTER3_LO},
	{46362, R_034D1C_TCP_PERFCOUNTER3_HI},
	{46382, R_034E00_TCC_PERFCOUNTER0_LO},
	{46402, R_034E04_TCC_PERFCOUNTER0_HI},
	{46422, R_034E08_TCC_PERFCOUNTER1_LO},
	{46442, R_034E0C_TCC_PERFCOUNTER1_HI},
	{46462, R_034E10_TCC_PERFCOUNTER2_LO},
	{46482, R_034E14_TCC_PERFCOUNTER2_HI},
	{46502, R_034E18_TCC_PERFCOUNTER3_LO},
	{46522, R_034E1C_TCC_PERFCOUNTER3_HI},
	{46542, R_034E40_TCA_PERFCOUNTER0_LO},
	{46562, R_034E44_TCA_PERFCOUNTER0_HI},
	{46582, R_034E48_TCA_PERFCOUNTER1_LO},
	{46602, R_034E4C_TCA_PERFCOUNTER1_HI},
	{46622, R_034E50_TCA_PERFCOUNTER2_LO},
	{46642, R_034E54_TCA_PERFCOUNTER2_HI},
	{46662, R_034E58_TCA_PERFCOUNTER3_LO},
	{46682, R_034E5C_TCA_PERFCOUNTER3_HI},
	{46702, R_035018_CB_PERFCOUNTER0_LO},
	{46721, R_03501C_CB_PERFCOUNTER0_HI},
	{46740, R_035020_CB_PERFCOUNTER1_LO},
	{46759, R_035024_CB_PERFCOUNTER1_HI},
	{46778, R_035028_CB_PERFCOUNTER2_LO},
	{46797, R_03502C_CB_PERFCOUNTER2_HI},
	{46816, R_035030_CB_PERFCOUNTER3_LO},
	{46835, R_035034_CB_PERFCOUNTER3_HI},
	{46854, R_035100_DB_PERFCOUNTER0_LO},
	{46873, R_035104_DB_PERFCOUNTER0_HI},
	{46892, R_035108_DB_PERFCOUNTER1_LO},
	{46911, R_03510C_DB_PERFCOUNTER1_HI},
	{46930, R_035110_DB_PERFCOUNTER2_LO},
	{46949, R_035114_DB_PERFCOUNTER2_HI},
	{46968, R_035118_DB_PERFCOUNTER3_LO},
	{46987, R_03511C_DB_PERFCOUNTER3_HI},
	{47006, R_035200_RLC_PERFCOUNTER0_LO},
	{47026, R_035204_RLC_PERFCOUNTER0_HI},
	{47046, R_035208_RLC_PERFCOUNTER1_LO},
	{47066, R_03520C_RLC_PERFCOUNTER1_HI},
	{47086, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 911},
	{47110, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 909},
	{47135, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 911},
	{47159, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 925},
	{47183, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 914},
	{47208, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 918},
	{47232, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 916},
	{47257, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 918},
	{47281, R_036020_CP_PERFMON_CNTL, 4, 921},
	{47297, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 925},
	{47321, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 928},
	{47346, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 928},
	{47371, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 947},
	{47399, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 959},
	{47427, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 971},
	{47455, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 983},
	{47483, R_036200_WD_PERFCOUNTER0_SELECT, 2, 995},
	{47506, R_036204_WD_PERFCOUNTER1_SELECT, 2, 995},
	{47529, R_036208_WD_PERFCOUNTER2_SELECT, 2, 995},
	{47552, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 995},
	{47575, R_036210_IA_PERFCOUNTER0_SELECT, 5, 997},
	{47598, R_036214_IA_PERFCOUNTER1_SELECT, 5, 997},
	{47621, R_036218_IA_PERFCOUNTER2_SELECT, 5, 997},
	{47644, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 997},
	{47667, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1002},
	{47691, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1006},
	{47715, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1006},
	{47739, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1006},
	{47763, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1006},
	{47787, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1011},
	{47812, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{47837, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1015},
	{47863, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1016},
	{47889, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1019},
	{47916, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1016},
	{47942, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{47969, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1016},
	{47995, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1016},
	{48021, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1021},
	{48047, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1024},
	{48074, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1021},
	{48100, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1021},
	{48126, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1021},
	{48152, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1021},
	{48178, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1021},
	{48204, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1021},
	{48230, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1021},
	{48256, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1026},
	{48280, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1026},
	{48304, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1026},
	{48328, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1026},
	{48352, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1029},
	{48377, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{48402, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{48427, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{48452, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1026},
	{48476, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1026},
	{48500, R_036628_SPI_PERFCOUNTER_BINS, 8, 1031},
	{48521, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1039},
	{48544, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1039},
	{48567, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1039},
	{48590, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1039},
	{48613, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1039},
	{48636, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1039},
	{48659, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1039},
	{48682, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1039},
	{48705, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1039},
	{48728, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1039},
	{48751, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1039},
	{48775, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1039},
	{48799, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1039},
	{48823, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1039},
	{48847, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1039},
	{48871, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1039},
	{48895, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1045},
	{48915, R_036784_SQ_PERFCOUNTER_MASK, 2, 1054},
	{48935, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1056},
	{48956, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1057},
	{48979, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1057},
	{49002, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1057},
	{49025, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1057},
	{49048, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1060},
	{49072, R_036914_SX_PERFCOUNTER1_SELECT1},
	{49096, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1062},
	{49120, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1062},
	{49144, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1062},
	{49168, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1062},
	{49192, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1065},
	{49217, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1067},
	{49240, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1072},
	{49264, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1067},
	{49287, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1076},
	{49310, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1081},
	{49334, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1076},
	{49357, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1085},
	{49381, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1090},
	{49406, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1085},
	{49430, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{49455, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1085},
	{49479, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1085},
	{49503, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1094},
	{49527, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1099},
	{49552, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1094},
	{49576, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{49601, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1094},
	{49625, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1094},
	{49649, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1103},
	{49673, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1108},
	{49698, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1103},
	{49722, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{49747, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1103},
	{49771, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1103},
	{49795, R_037000_CB_PERFCOUNTER_FILTER, 12, 1112},
	{49817, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1124},
	{49840, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1129},
	{49864, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1124},
	{49887, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1124},
	{49910, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1124},
	{49933, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1133},
	{49956, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1138},
	{49980, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1133},
	{50003, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{50027, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1133},
	{50050, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1133},
	{50073, R_028000_DB_RENDER_CONTROL, 10, 1142},
	{50091, R_028004_DB_COUNT_CONTROL, 9, 1152},
	{50108, R_028008_DB_DEPTH_VIEW, 4, 1161},
	{50122, R_02800C_DB_RENDER_OVERRIDE, 23, 1165},
	{50141, R_028010_DB_RENDER_OVERRIDE2, 15, 1188},
	{50161, R_028014_DB_HTILE_DATA_BASE},
	{50180, R_028020_DB_DEPTH_BOUNDS_MIN},
	{50200, R_028024_DB_DEPTH_BOUNDS_MAX},
	{50220, R_028028_DB_STENCIL_CLEAR, 1, 1203},
	{50237, R_02802C_DB_DEPTH_CLEAR},
	{50252, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1204},
	{50276, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1206},
	{50300, R_02803C_DB_DEPTH_INFO, 7, 1208},
	{50314, R_028040_DB_Z_INFO, 10, 1215},
	{50324, R_028044_DB_STENCIL_INFO, 6, 1225},
	{50340, R_028048_DB_Z_READ_BASE},
	{50355, R_02804C_DB_STENCIL_READ_BASE},
	{50376, R_028050_DB_Z_WRITE_BASE},
	{50392, R_028054_DB_STENCIL_WRITE_BASE},
	{50414, R_028058_DB_DEPTH_SIZE, 2, 1231},
	{50428, R_02805C_DB_DEPTH_SLICE, 1, 1233},
	{50443, R_028080_TA_BC_BASE_ADDR},
	{50459, R_028084_TA_BC_BASE_ADDR_HI, 1, 1234},
	{50478, R_0281E8_COHER_DEST_BASE_HI_0},
	{50499, R_0281EC_COHER_DEST_BASE_HI_1},
	{50520, R_0281F0_COHER_DEST_BASE_HI_2},
	{50541, R_0281F4_COHER_DEST_BASE_HI_3},
	{50562, R_0281F8_COHER_DEST_BASE_2},
	{50580, R_0281FC_COHER_DEST_BASE_3},
	{50598, R_028200_PA_SC_WINDOW_OFFSET, 2, 1235},
	{50618, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1237},
	{50642, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1240},
	{50666, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1242},
	{50686, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1243},
	{50706, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1245},
	{50726, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1243},
	{50746, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1245},
	{50766, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1243},
	{50786, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1245},
	{50806, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1243},
	{50826, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1245},
	{50846, R_028230_PA_SC_EDGERULE, 7, 1247},
	{50861, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1254},
	{50890, R_028238_CB_TARGET_MASK, 8, 1256},
	{50905, R_02823C_CB_SHADER_MASK, 8, 1264},
	{50920, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1272},
	{50945, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1275},
	{50970, R_028248_COHER_DEST_BASE_0},
	{50988, R_02824C_COHER_DEST_BASE_1},
	{51006, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1277},
	{51031, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1280},
	{51056, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1277},
	{51081, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1280},
	{51106, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1277},
	{51131, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1280},
	{51156, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1277},
	{51181, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1280},
	{51206, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1277},
	{51231, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1280},
	{51256, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1277},
	{51281, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1280},
	{51306, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1277},
	{51331, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1280},
	{51356, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1277},
	{51381, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1280},
	{51406, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1277},
	{51431, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1280},
	{51456, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1277},
	{51481, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1280},
	{51506, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1277},
	{51532, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1280},
	{51558, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1277},
	{51584, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1280},
	{51610, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1277},
	{51636, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1280},
	{51662, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1277},
	{51688, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1280},
	{51714, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1277},
	{51740, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1280},
	{51766, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1277},
	{51792, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1280},
	{51818, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{51837, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{51856, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{51875, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{51894, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{51913, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{51932, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{51951, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{51970, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{51989, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{52008, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{52027, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{52046, R_028300_PA_SC_VPORT_ZMIN_6},
	{52065, R_028304_PA_SC_VPORT_ZMAX_6},
	{52084, R_028308_PA_SC_VPORT_ZMIN_7},
	{52103, R_02830C_PA_SC_VPORT_ZMAX_7},
	{52122, R_028310_PA_SC_VPORT_ZMIN_8},
	{52141, R_028314_PA_SC_VPORT_ZMAX_8},
	{52160, R_028318_PA_SC_VPORT_ZMIN_9},
	{52179, R_02831C_PA_SC_VPORT_ZMAX_9},
	{52198, R_028320_PA_SC_VPORT_ZMIN_10},
	{52218, R_028324_PA_SC_VPORT_ZMAX_10},
	{52238, R_028328_PA_SC_VPORT_ZMIN_11},
	{52258, R_02832C_PA_SC_VPORT_ZMAX_11},
	{52278, R_028330_PA_SC_VPORT_ZMIN_12},
	{52298, R_028334_PA_SC_VPORT_ZMAX_12},
	{52318, R_028338_PA_SC_VPORT_ZMIN_13},
	{52338, R_02833C_PA_SC_VPORT_ZMAX_13},
	{52358, R_028340_PA_SC_VPORT_ZMIN_14},
	{52378, R_028344_PA_SC_VPORT_ZMAX_14},
	{52398, R_028348_PA_SC_VPORT_ZMIN_15},
	{52418, R_02834C_PA_SC_VPORT_ZMAX_15},
	{52438, R_028350_PA_SC_RASTER_CONFIG, 15, 1282},
	{52458, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1297},
	{52480, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1300},
	{52508, R_028400_VGT_MAX_VTX_INDX},
	{52525, R_028404_VGT_MIN_VTX_INDX},
	{52542, R_028408_VGT_INDX_OFFSET},
	{52558, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{52587, R_028414_CB_BLEND_RED},
	{52600, R_028418_CB_BLEND_GREEN},
	{52615, R_02841C_CB_BLEND_BLUE},
	{52629, R_028420_CB_BLEND_ALPHA},
	{52644, R_028424_CB_DCC_CONTROL, 3, 1302},
	{52659, R_02842C_DB_STENCIL_CONTROL, 6, 1305},
	{52678, R_028430_DB_STENCILREFMASK, 4, 1311},
	{52696, R_028434_DB_STENCILREFMASK_BF, 4, 1315},
	{52717, R_02843C_PA_CL_VPORT_XSCALE},
	{52736, R_028440_PA_CL_VPORT_XOFFSET},
	{52756, R_028444_PA_CL_VPORT_YSCALE},
	{52775, R_028448_PA_CL_VPORT_YOFFSET},
	{52795, R_02844C_PA_CL_VPORT_ZSCALE},
	{52814, R_028450_PA_CL_VPORT_ZOFFSET},
	{52834, R_028454_PA_CL_VPORT_XSCALE_1},
	{52855, R_028458_PA_CL_VPORT_XOFFSET_1},
	{52877, R_02845C_PA_CL_VPORT_YSCALE_1},
	{52898, R_028460_PA_CL_VPORT_YOFFSET_1},
	{52920, R_028464_PA_CL_VPORT_ZSCALE_1},
	{52941, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{52963, R_02846C_PA_CL_VPORT_XSCALE_2},
	{52984, R_028470_PA_CL_VPORT_XOFFSET_2},
	{53006, R_028474_PA_CL_VPORT_YSCALE_2},
	{53027, R_028478_PA_CL_VPORT_YOFFSET_2},
	{53049, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{53070, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{53092, R_028484_PA_CL_VPORT_XSCALE_3},
	{53113, R_028488_PA_CL_VPORT_XOFFSET_3},
	{53135, R_02848C_PA_CL_VPORT_YSCALE_3},
	{53156, R_028490_PA_CL_VPORT_YOFFSET_3},
	{53178, R_028494_PA_CL_VPORT_ZSCALE_3},
	{53199, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{53221, R_02849C_PA_CL_VPORT_XSCALE_4},
	{53242, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{53264, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{53285, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{53307, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{53328, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{53350, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{53371, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{53393, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{53414, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{53436, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{53457, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{53479, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{53500, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{53522, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{53543, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{53565, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{53586, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{53608, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{53629, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{53651, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{53672, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{53694, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{53715, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{53737, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{53758, R_028500_PA_CL_VPORT_XOFFSET_8},
	{53780, R_028504_PA_CL_VPORT_YSCALE_8},
	{53801, R_028508_PA_CL_VPORT_YOFFSET_8},
	{53823, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{53844, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{53866, R_028514_PA_CL_VPORT_XSCALE_9},
	{53887, R_028518_PA_CL_VPORT_XOFFSET_9},
	{53909, R_02851C_PA_CL_VPORT_YSCALE_9},
	{53930, R_028520_PA_CL_VPORT_YOFFSET_9},
	{53952, R_028524_PA_CL_VPORT_ZSCALE_9},
	{53973, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{53995, R_02852C_PA_CL_VPORT_XSCALE_10},
	{54017, R_028530_PA_CL_VPORT_XOFFSET_10},
	{54040, R_028534_PA_CL_VPORT_YSCALE_10},
	{54062, R_028538_PA_CL_VPORT_YOFFSET_10},
	{54085, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{54107, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{54130, R_028544_PA_CL_VPORT_XSCALE_11},
	{54152, R_028548_PA_CL_VPORT_XOFFSET_11},
	{54175, R_02854C_PA_CL_VPORT_YSCALE_11},
	{54197, R_028550_PA_CL_VPORT_YOFFSET_11},
	{54220, R_028554_PA_CL_VPORT_ZSCALE_11},
	{54242, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{54265, R_02855C_PA_CL_VPORT_XSCALE_12},
	{54287, R_028560_PA_CL_VPORT_XOFFSET_12},
	{54310, R_028564_PA_CL_VPORT_YSCALE_12},
	{54332, R_028568_PA_CL_VPORT_YOFFSET_12},
	{54355, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{54377, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{54400, R_028574_PA_CL_VPORT_XSCALE_13},
	{54422, R_028578_PA_CL_VPORT_XOFFSET_13},
	{54445, R_02857C_PA_CL_VPORT_YSCALE_13},
	{54467, R_028580_PA_CL_VPORT_YOFFSET_13},
	{54490, R_028584_PA_CL_VPORT_ZSCALE_13},
	{54512, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{54535, R_02858C_PA_CL_VPORT_XSCALE_14},
	{54557, R_028590_PA_CL_VPORT_XOFFSET_14},
	{54580, R_028594_PA_CL_VPORT_YSCALE_14},
	{54602, R_028598_PA_CL_VPORT_YOFFSET_14},
	{54625, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{54647, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{54670, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{54692, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{54715, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{54737, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{54760, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{54782, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{54805, R_0285BC_PA_CL_UCP_0_X},
	{54819, R_0285C0_PA_CL_UCP_0_Y},
	{54833, R_0285C4_PA_CL_UCP_0_Z},
	{54847, R_0285C8_PA_CL_UCP_0_W},
	{54861, R_0285CC_PA_CL_UCP_1_X},
	{54875, R_0285D0_PA_CL_UCP_1_Y},
	{54889, R_0285D4_PA_CL_UCP_1_Z},
	{54903, R_0285D8_PA_CL_UCP_1_W},
	{54917, R_0285DC_PA_CL_UCP_2_X},
	{54931, R_0285E0_PA_CL_UCP_2_Y},
	{54945, R_0285E4_PA_CL_UCP_2_Z},
	{54959, R_0285E8_PA_CL_UCP_2_W},
	{54973, R_0285EC_PA_CL_UCP_3_X},
	{54987, R_0285F0_PA_CL_UCP_3_Y},
	{55001, R_0285F4_PA_CL_UCP_3_Z},
	{55015, R_0285F8_PA_CL_UCP_3_W},
	{55029, R_0285FC_PA_CL_UCP_4_X},
	{55043, R_028600_PA_CL_UCP_4_Y},
	{55057, R_028604_PA_CL_UCP_4_Z},
	{55071, R_028608_PA_CL_UCP_4_W},
	{55085, R_02860C_PA_CL_UCP_5_X},
	{55099, R_028610_PA_CL_UCP_5_Y},
	{55113, R_028614_PA_CL_UCP_5_Z},
	{55127, R_028618_PA_CL_UCP_5_W},
	{55141, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1319},
	{55161, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1319},
	{55181, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1319},
	{55201, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1319},
	{55221, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1319},
	{55241, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1319},
	{55261, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1319},
	{55281, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1319},
	{55301, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1319},
	{55321, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1319},
	{55341, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1319},
	{55362, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1319},
	{55383, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1319},
	{55404, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1319},
	{55425, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1319},
	{55446, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1319},
	{55467, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1319},
	{55488, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1319},
	{55509, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1319},
	{55530, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1319},
	{55551, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1319},
	{55572, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1319},
	{55593, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1319},
	{55614, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1319},
	{55635, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1319},
	{55656, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1319},
	{55677, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1319},
	{55698, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1319},
	{55719, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1319},
	{55740, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1319},
	{55761, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1319},
	{55782, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1319},
	{55803, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1331},
	{55821, R_0286CC_SPI_PS_INPUT_ENA, 16, 1335},
	{55838, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1351},
	{55856, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1367},
	{55877, R_0286D8_SPI_PS_IN_CONTROL, 5, 1374},
	{55895, R_0286E0_SPI_BARYC_CNTL, 7, 1379},
	{55910, R_0286E8_SPI_TMPRING_SIZE, 2, 1386},
	{55927, R_028704_SPI_WAVE_MGMT_1, 5, 1388},
	{55943, R_028708_SPI_WAVE_MGMT_2, 1, 1393},
	{55959, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1394},
	{55981, R_028710_SPI_SHADER_Z_FORMAT, 1, 1398},
	{56001, R_028714_SPI_SHADER_COL_FORMAT, 8, 1399},
	{56023, R_028754_SX_PS_DOWNCONVERT, 8, 1407},
	{56041, R_028758_SX_BLEND_OPT_EPSILON, 8, 1415},
	{56062, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1423},
	{56083, R_028760_SX_MRT0_BLEND_OPT, 6, 1440},
	{56101, R_028764_SX_MRT1_BLEND_OPT, 6, 1446},
	{56119, R_028768_SX_MRT2_BLEND_OPT, 6, 1452},
	{56137, R_02876C_SX_MRT3_BLEND_OPT, 6, 1458},
	{56155, R_028770_SX_MRT4_BLEND_OPT, 6, 1464},
	{56173, R_028774_SX_MRT5_BLEND_OPT, 6, 1470},
	{56191, R_028778_SX_MRT6_BLEND_OPT, 6, 1476},
	{56209, R_02877C_SX_MRT7_BLEND_OPT, 6, 1482},
	{56227, R_028780_CB_BLEND0_CONTROL, 9, 1488},
	{56245, R_028784_CB_BLEND1_CONTROL, 9, 1488},
	{56263, R_028788_CB_BLEND2_CONTROL, 9, 1488},
	{56281, R_02878C_CB_BLEND3_CONTROL, 9, 1488},
	{56299, R_028790_CB_BLEND4_CONTROL, 9, 1488},
	{56317, R_028794_CB_BLEND5_CONTROL, 9, 1488},
	{56335, R_028798_CB_BLEND6_CONTROL, 9, 1488},
	{56353, R_02879C_CB_BLEND7_CONTROL, 9, 1488},
	{56371, R_0287CC_CS_COPY_STATE, 1, 1497},
	{56385, R_0287D4_PA_CL_POINT_X_RAD},
	{56403, R_0287D8_PA_CL_POINT_Y_RAD},
	{56421, R_0287DC_PA_CL_POINT_SIZE},
	{56438, R_0287E0_PA_CL_POINT_CULL_RAD},
	{56459, R_0287E4_VGT_DMA_BASE_HI, 1, 1498},
	{56475, R_0287E8_VGT_DMA_BASE},
	{56488, R_0287F0_VGT_DRAW_INITIATOR, 4, 1499},
	{56507, R_0287F4_VGT_IMMED_DATA},
	{56522, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1503},
	{56544, R_028800_DB_DEPTH_CONTROL, 10, 1504},
	{56561, R_028804_DB_EQAA, 12, 1514},
	{56569, R_028808_CB_COLOR_CONTROL, 4, 1526},
	{56586, R_02880C_DB_SHADER_CONTROL, 13, 1530},
	{56604, R_028810_PA_CL_CLIP_CNTL, 19, 1543},
	{56620, R_028814_PA_SU_SC_MODE_CNTL, 13, 1562},
	{56639, R_028818_PA_CL_VTE_CNTL, 9, 1575},
	{56654, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1584},
	{56672, R_028820_PA_CL_NANINF_CNTL, 16, 1611},
	{56690, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1627},
	{56714, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{56739, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1631},
	{56762, R_028A00_PA_SU_POINT_SIZE, 2, 1642},
	{56779, R_028A04_PA_SU_POINT_MINMAX, 2, 1644},
	{56798, R_028A08_PA_SU_LINE_CNTL, 1, 1646},
	{56814, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1647},
	{56833, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1651},
	{56854, R_028A14_VGT_HOS_CNTL, 1, 1652},
	{56867, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{56890, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{56913, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1653},
	{56933, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1654},
	{56953, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1658},
	{56974, R_028A2C_VGT_GROUP_DECR, 1, 1659},
	{56989, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1660},
	{57011, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1666},
	{57033, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1672},
	{57059, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1680},
	{57085, R_028A40_VGT_GS_MODE, 15, 1688},
	{57097, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1703},
	{57116, R_028A48_PA_SC_MODE_CNTL_0, 4, 1705},
	{57134, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1709},
	{57152, R_028A50_VGT_ENHANCE},
	{57164, R_028A54_VGT_GS_PER_ES, 1, 1733},
	{57178, R_028A58_VGT_ES_PER_GS, 1, 1734},
	{57192, R_028A5C_VGT_GS_PER_VS, 1, 1735},
	{57206, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1736},
	{57229, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1737},
	{57252, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1738},
	{57275, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1739},
	{57296, R_028A70_IA_ENHANCE},
	{57307, R_028A74_VGT_DMA_SIZE},
	{57320, R_028A78_VGT_DMA_MAX_SIZE},
	{57337, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1744},
	{57356, R_028A80_WD_ENHANCE},
	{57367, R_028A84_VGT_PRIMITIVEID_EN, 2, 1753},
	{57386, R_028A88_VGT_DMA_NUM_INSTANCES},
	{57408, R_028A8C_VGT_PRIMITIVEID_RESET},
	{57430, R_028A90_VGT_EVENT_INITIATOR, 3, 1755},
	{57450, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1758},
	{57477, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{57502, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{57527, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1759},
	{57546, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1766},
	{57569, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1767},
	{57592, R_028AB4_VGT_REUSE_OFF, 1, 1768},
	{57606, R_028AB8_VGT_VTX_CNT_EN, 1, 1769},
	{57621, R_028ABC_DB_HTILE_SURFACE, 8, 1770},
	{57638, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1778},
	{57665, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1782},
	{57692, R_028AC8_DB_PRELOAD_CONTROL, 4, 1786},
	{57711, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{57737, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1790},
	{57762, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{57790, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{57816, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1791},
	{57841, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{57869, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{57895, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1792},
	{57920, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{57948, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{57974, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1793},
	{57999, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{58027, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{58058, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{58101, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1794},
	{58139, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1795},
	{58159, R_028B50_VGT_TESS_DISTRIBUTION, 4, 1796},
	{58181, R_028B54_VGT_SHADER_STAGES_EN, 10, 1800},
	{58202, R_028B58_VGT_LS_HS_CONFIG, 3, 1810},
	{58219, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1813},
	{58240, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1814},
	{58263, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1815},
	{58286, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1816},
	{58309, R_028B6C_VGT_TF_PARAM, 11, 1817},
	{58322, R_028B70_DB_ALPHA_TO_MASK, 6, 1828},
	{58339, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{58363, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1834},
	{58393, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{58417, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{58447, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{58478, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{58507, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{58537, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1836},
	{58557, R_028B94_VGT_STRMOUT_CONFIG, 7, 1838},
	{58576, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1845},
	{58602, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1849},
	{58628, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1857},
	{58654, R_028BDC_PA_SC_LINE_CNTL, 4, 1865},
	{58670, R_028BE0_PA_SC_AA_CONFIG, 5, 1869},
	{58686, R_028BE4_PA_SU_VTX_CNTL, 3, 1874},
	{58701, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{58724, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{58747, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{58770, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{58793, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1877},
	{58827, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1885},
	{58861, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1893},
	{58895, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1901},
	{58929, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1909},
	{58963, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1917},
	{58997, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1925},
	{59031, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1933},
	{59065, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1941},
	{59099, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1949},
	{59133, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1957},
	{59167, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1965},
	{59201, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 1973},
	{59235, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 1981},
	{59269, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 1989},
	{59303, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 1997},
	{59337, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2005},
	{59361, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2007},
	{59385, R_028C40_PA_SC_SHADER_CONTROL, 1, 2009},
	{59406, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2010},
	{59434, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2011},
	{59455, R_028C60_CB_COLOR0_BASE},
	{59470, R_028C64_CB_COLOR0_PITCH, 2, 2012},
	{59486, R_028C68_CB_COLOR0_SLICE, 1, 2014},
	{59502, R_028C6C_CB_COLOR0_VIEW, 2, 2015},
	{59517, R_028C70_CB_COLOR0_INFO, 18, 2017},
	{59532, R_028C74_CB_COLOR0_ATTRIB, 6, 2035},
	{59549, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2041},
	{59571, R_028C7C_CB_COLOR0_CMASK},
	{59587, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2050},
	{59609, R_028C84_CB_COLOR0_FMASK},
	{59625, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2051},
	{59647, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{59669, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{59691, R_028C94_CB_COLOR0_DCC_BASE},
	{59710, R_028C9C_CB_COLOR1_BASE},
	{59725, R_028CA0_CB_COLOR1_PITCH, 2, 2012},
	{59741, R_028CA4_CB_COLOR1_SLICE, 1, 2014},
	{59757, R_028CA8_CB_COLOR1_VIEW, 2, 2015},
	{59772, R_028CAC_CB_COLOR1_INFO, 18, 2017},
	{59787, R_028CB0_CB_COLOR1_ATTRIB, 6, 2035},
	{59804, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2041},
	{59826, R_028CB8_CB_COLOR1_CMASK},
	{59842, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2050},
	{59864, R_028CC0_CB_COLOR1_FMASK},
	{59880, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2051},
	{59902, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{59924, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{59946, R_028CD0_CB_COLOR1_DCC_BASE},
	{59965, R_028CD8_CB_COLOR2_BASE},
	{59980, R_028CDC_CB_COLOR2_PITCH, 2, 2012},
	{59996, R_028CE0_CB_COLOR2_SLICE, 1, 2014},
	{60012, R_028CE4_CB_COLOR2_VIEW, 2, 2015},
	{60027, R_028CE8_CB_COLOR2_INFO, 18, 2017},
	{60042, R_028CEC_CB_COLOR2_ATTRIB, 6, 2035},
	{60059, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2041},
	{60081, R_028CF4_CB_COLOR2_CMASK},
	{60097, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2050},
	{60119, R_028CFC_CB_COLOR2_FMASK},
	{60135, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2051},
	{60157, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{60179, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{60201, R_028D0C_CB_COLOR2_DCC_BASE},
	{60220, R_028D14_CB_COLOR3_BASE},
	{60235, R_028D18_CB_COLOR3_PITCH, 2, 2012},
	{60251, R_028D1C_CB_COLOR3_SLICE, 1, 2014},
	{60267, R_028D20_CB_COLOR3_VIEW, 2, 2015},
	{60282, R_028D24_CB_COLOR3_INFO, 18, 2017},
	{60297, R_028D28_CB_COLOR3_ATTRIB, 6, 2035},
	{60314, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2041},
	{60336, R_028D30_CB_COLOR3_CMASK},
	{60352, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2050},
	{60374, R_028D38_CB_COLOR3_FMASK},
	{60390, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2051},
	{60412, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{60434, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{60456, R_028D48_CB_COLOR3_DCC_BASE},
	{60475, R_028D50_CB_COLOR4_BASE},
	{60490, R_028D54_CB_COLOR4_PITCH, 2, 2012},
	{60506, R_028D58_CB_COLOR4_SLICE, 1, 2014},
	{60522, R_028D5C_CB_COLOR4_VIEW, 2, 2015},
	{60537, R_028D60_CB_COLOR4_INFO, 18, 2017},
	{60552, R_028D64_CB_COLOR4_ATTRIB, 6, 2035},
	{60569, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2041},
	{60591, R_028D6C_CB_COLOR4_CMASK},
	{60607, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2050},
	{60629, R_028D74_CB_COLOR4_FMASK},
	{60645, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2051},
	{60667, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{60689, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{60711, R_028D84_CB_COLOR4_DCC_BASE},
	{60730, R_028D8C_CB_COLOR5_BASE},
	{60745, R_028D90_CB_COLOR5_PITCH, 2, 2012},
	{60761, R_028D94_CB_COLOR5_SLICE, 1, 2014},
	{60777, R_028D98_CB_COLOR5_VIEW, 2, 2015},
	{60792, R_028D9C_CB_COLOR5_INFO, 18, 2017},
	{60807, R_028DA0_CB_COLOR5_ATTRIB, 6, 2035},
	{60824, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2041},
	{60846, R_028DA8_CB_COLOR5_CMASK},
	{60862, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2050},
	{60884, R_028DB0_CB_COLOR5_FMASK},
	{60900, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2051},
	{60922, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{60944, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{60966, R_028DC0_CB_COLOR5_DCC_BASE},
	{60985, R_028DC8_CB_COLOR6_BASE},
	{61000, R_028DCC_CB_COLOR6_PITCH, 2, 2012},
	{61016, R_028DD0_CB_COLOR6_SLICE, 1, 2014},
	{61032, R_028DD4_CB_COLOR6_VIEW, 2, 2015},
	{61047, R_028DD8_CB_COLOR6_INFO, 18, 2017},
	{61062, R_028DDC_CB_COLOR6_ATTRIB, 6, 2035},
	{61079, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2041},
	{61101, R_028DE4_CB_COLOR6_CMASK},
	{61117, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2050},
	{61139, R_028DEC_CB_COLOR6_FMASK},
	{61155, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2051},
	{61177, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{61199, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{61221, R_028DFC_CB_COLOR6_DCC_BASE},
	{61240, R_028E04_CB_COLOR7_BASE},
	{61255, R_028E08_CB_COLOR7_PITCH, 2, 2012},
	{61271, R_028E0C_CB_COLOR7_SLICE, 1, 2014},
	{61287, R_028E10_CB_COLOR7_VIEW, 2, 2015},
	{61302, R_028E14_CB_COLOR7_INFO, 18, 2017},
	{61317, R_028E18_CB_COLOR7_ATTRIB, 6, 2035},
	{61334, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2041},
	{61356, R_028E20_CB_COLOR7_CMASK},
	{61372, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2050},
	{61394, R_028E28_CB_COLOR7_FMASK},
	{61410, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2051},
	{61432, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{61454, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{61476, R_028E38_CB_COLOR7_DCC_BASE},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"STRMOUT_BUFFER_UPDATE\0" /* 321 */
	"DRAW_INDEX_OFFSET_2\0" /* 343 */
	"DRAW_PREAMBLE\0" /* 363 */
	"WRITE_DATA\0" /* 377, 383 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 388 */
	"MEM_SEMAPHORE\0" /* 414 */
	"MPEG_INDEX\0" /* 428, 437 */
	"WAIT_REG_MEM\0" /* 439 */
	"MEM_WRITE\0" /* 452 */
	"INDIRECT_BUFFER_CIK\0" /* 462 */
	"COPY_DATA\0" /* 482 */
	"PFP_SYNC_ME\0" /* 492, 501 */
	"SURFACE_SYNC\0" /* 504 */
	"ME_INITIALIZE\0" /* 517 */
	"COND_WRITE\0" /* 531 */
	"EVENT_WRITE\0" /* 542 */
	"EVENT_WRITE_EOP\0" /* 554 */
	"EVENT_WRITE_EOS\0" /* 570 */
	"ONE_REG_WRITE\0" /* 586 */
	"ACQUIRE_MEM\0" /* 600 */
	"SET_CONFIG_REG\0" /* 612 */
	"SET_CONTEXT_REG\0" /* 627 */
	"SET_SH_REG\0" /* 643 */
	"SET_SH_REG_OFFSET\0" /* 665, 654 */
	"SET_UCONFIG_REG\0" /* 672 */
	"LOAD_CONST_RAM\0" /* 688 */
	"WRITE_CONST_RAM\0" /* 703 */
	"DUMP_CONST_RAM\0" /* 719 */
	"INCREMENT_CE_COUNTER\0" /* 734 */
	"INCREMENT_DE_COUNTER\0" /* 755 */
	"WAIT_ON_CE_COUNTER\0" /* 776 */
	"IT_OPCODE_C\0" /* 795 */
	"CP_DMA\0" /* 807 */
	"DMA_DATA\0" /* 814 */
	"PFP\0" /* 823 */
	"CE\0" /* 827 */
	"DE\0" /* 830 */
	"ENGINE_SEL\0" /* 833 */
	"WR_CONFIRM\0" /* 844 */
	"WR_ONE_ADDR\0" /* 862, 855 */
	"MEM_MAPPED_REGISTER\0" /* 867, 878 */
	"MEMORY_SYNC\0" /* 887 */
	"TC_L2\0" /* 899 */
	"GDS\0" /* 905 */
	"RESERVED\0" /* 909 */
	"MEM_ASYNC\0" /* 918 */
	"DST_SEL\0" /* 928 */
	"SRC_ADDR_LO\0" /* 936 */
	"CP_SYNC\0" /* 948 */
	"SRC_ADDR\0" /* 956 */
	"SRC_ADDR_TC_L2\0" /* 965 */
	"SRC_SEL\0" /* 980 */
	"ENGINE\0" /* 988 */
	"DST_ADDR\0" /* 995 */
	"DST_ADDR_TC_L2\0" /* 1004 */
	"DSL_SEL\0" /* 1019 */
	"SRC_ADDR_HI\0" /* 1027 */
	"DST_ADDR_LO\0" /* 1039 */
	"DST_ADDR_HI\0" /* 1051 */
	"BYTE_COUNT\0" /* 1063 */
	"DISABLE_WR_CONFIRM\0" /* 1074 */
	"NONE\0" /* 1093 */
	"8_IN_16\0" /* 1098 */
	"8_IN_32\0" /* 1106 */
	"8_IN_64\0" /* 1114 */
	"SRC_SWAP\0" /* 1122 */
	"DST_SWAP\0" /* 1131 */
	"MEMORY\0" /* 1140 */
	"SAS\0" /* 1147 */
	"DAS\0" /* 1151 */
	"INCREMENT\0" /* 1155 */
	"NO_INCREMENT\0" /* 1165 */
	"SAIC\0" /* 1178 */
	"DAIC\0" /* 1183 */
	"RAW_WAIT\0" /* 1188 */
	"SDMA_RQ_PENDING\0" /* 1197 */
	"TST_RQ_PENDING\0" /* 1213 */
	"SDMA1_RQ_PENDING\0" /* 1228 */
	"VCE0_RQ_PENDING\0" /* 1245 */
	"VP8_BUSY\0" /* 1261 */
	"SDMA_BUSY\0" /* 1270, 1271 */
	"SDMA1_BUSY\0" /* 1280 */
	"VCE0_BUSY\0" /* 1291 */
	"XDMA_BUSY\0" /* 1301 */
	"CHUB_BUSY\0" /* 1311 */
	"SDMA2_BUSY\0" /* 1321 */
	"SDMA3_BUSY\0" /* 1332 */
	"SAMSCP_BUSY\0" /* 1347, 1343 */
	"ISP_BUSY\0" /* 1355 */
	"VCE1_BUSY\0" /* 1364 */
	"ODE_BUSY\0" /* 1374 */
	"SDMA2_RQ_PENDING\0" /* 1383 */
	"SDMA3_RQ_PENDING\0" /* 1400 */
	"SAMSCP_RQ_PENDING\0" /* 1417 */
	"ISP_RQ_PENDING\0" /* 1435 */
	"VCE1_RQ_PENDING\0" /* 1450 */
	"UVD_RQ_PENDING\0" /* 1466 */
	"SAMMSP_RQ_PENDING\0" /* 1481 */
	"ACP_RQ_PENDING\0" /* 1499 */
	"SMU_RQ_PENDING\0" /* 1514 */
	"GRBM_RQ_PENDING\0" /* 1529 */
	"HI_RQ_PENDING\0" /* 1545 */
	"VMC_BUSY\0" /* 1559 */
	"MCB_BUSY\0" /* 1568, 1569 */
	"MCB_NON_DISPLAY_BUSY\0" /* 1577 */
	"MCC_BUSY\0" /* 1598 */
	"MCD_BUSY\0" /* 1607 */
	"VMC1_BUSY\0" /* 1616 */
	"SEM_BUSY\0" /* 1626 */
	"ACP_BUSY\0" /* 1635 */
	"IH_BUSY\0" /* 1644 */
	"UVD_BUSY\0" /* 1652 */
	"SAMMSP_BUSY\0" /* 1661 */
	"GCATCL2_BUSY\0" /* 1673 */
	"OSATCL2_BUSY\0" /* 1686 */
	"BIF_BUSY\0" /* 1699 */
	"MCC0_BUSY\0" /* 1708 */
	"MCC1_BUSY\0" /* 1718 */
	"MCC2_BUSY\0" /* 1728 */
	"MCC3_BUSY\0" /* 1738 */
	"MCC4_BUSY\0" /* 1748 */
	"MCC5_BUSY\0" /* 1758 */
	"MCC6_BUSY\0" /* 1768 */
	"MCC7_BUSY\0" /* 1778 */
	"MCD0_BUSY\0" /* 1788 */
	"MCD1_BUSY\0" /* 1798 */
	"MCD2_BUSY\0" /* 1808 */
	"MCD3_BUSY\0" /* 1818 */
	"MCD4_BUSY\0" /* 1828 */
	"MCD5_BUSY\0" /* 1838 */
	"MCD6_BUSY\0" /* 1848 */
	"MCD7_BUSY\0" /* 1858 */
	"IDLE\0" /* 1868 */
	"REG_IDLE\0" /* 1873 */
	"RB_EMPTY\0" /* 1882 */
	"RB_FULL\0" /* 1891 */
	"RB_CMD_IDLE\0" /* 1899 */
	"RB_CMD_FULL\0" /* 1911 */
	"IB_CMD_IDLE\0" /* 1923 */
	"IB_CMD_FULL\0" /* 1935 */
	"BLOCK_IDLE\0" /* 1947 */
	"INSIDE_IB\0" /* 1958 */
	"EX_IDLE\0" /* 1968 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 1976 */
	"PACKET_READY\0" /* 2002 */
	"MC_WR_IDLE\0" /* 2015 */
	"SRBM_IDLE\0" /* 2026 */
	"CONTEXT_EMPTY\0" /* 2036 */
	"DELTA_RPTR_FULL\0" /* 2050 */
	"RB_MC_RREQ_IDLE\0" /* 2066 */
	"IB_MC_RREQ_IDLE\0" /* 2082 */
	"MC_RD_IDLE\0" /* 2098 */
	"DELTA_RPTR_EMPTY\0" /* 2109 */
	"MC_RD_RET_STALL\0" /* 2126 */
	"MC_RD_NO_POLL_IDLE\0" /* 2142 */
	"PREV_CMD_IDLE\0" /* 2161 */
	"SEM_IDLE\0" /* 2175 */
	"SEM_REQ_STALL\0" /* 2184 */
	"SEM_RESP_STATE\0" /* 2198 */
	"INT_IDLE\0" /* 2213 */
	"INT_REQ_STALL\0" /* 2222 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 2236 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 2259 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 2282 */
	"ME1PIPE0_RQ_PENDING\0" /* 2305 */
	"ME1PIPE1_RQ_PENDING\0" /* 2325 */
	"ME1PIPE2_RQ_PENDING\0" /* 2345 */
	"ME1PIPE3_RQ_PENDING\0" /* 2365 */
	"ME2PIPE0_RQ_PENDING\0" /* 2385 */
	"ME2PIPE1_RQ_PENDING\0" /* 2405 */
	"ME2PIPE2_RQ_PENDING\0" /* 2425 */
	"ME2PIPE3_RQ_PENDING\0" /* 2445 */
	"RLC_RQ_PENDING\0" /* 2465 */
	"RLC_BUSY\0" /* 2480 */
	"TC_BUSY\0" /* 2489 */
	"TCC_CC_RESIDENT\0" /* 2497 */
	"CPF_BUSY\0" /* 2513 */
	"CPC_BUSY\0" /* 2522 */
	"CPG_BUSY\0" /* 2531 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 2540 */
	"SRBM_RQ_PENDING\0" /* 2563 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 2579 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 2602 */
	"GDS_DMA_RQ_PENDING\0" /* 2625 */
	"DB_CLEAN\0" /* 2644 */
	"CB_CLEAN\0" /* 2653 */
	"TA_BUSY\0" /* 2662 */
	"GDS_BUSY\0" /* 2670 */
	"WD_BUSY_NO_DMA\0" /* 2679 */
	"VGT_BUSY\0" /* 2694 */
	"IA_BUSY_NO_DMA\0" /* 2703 */
	"IA_BUSY\0" /* 2718 */
	"SX_BUSY\0" /* 2726 */
	"WD_BUSY\0" /* 2734 */
	"SPI_BUSY\0" /* 2742 */
	"BCI_BUSY\0" /* 2751 */
	"SC_BUSY\0" /* 2760 */
	"PA_BUSY\0" /* 2768 */
	"DB_BUSY\0" /* 2776 */
	"CP_COHERENCY_BUSY\0" /* 2784 */
	"GUI_ACTIVE\0" /* 2802 */
	"OFFSET_UPDATE_DONE\0" /* 2827, 2813 */
	"DEST_BASE_0_ENA\0" /* 2832 */
	"DEST_BASE_1_ENA\0" /* 2848 */
	"CB0_DEST_BASE_ENA\0" /* 2864 */
	"CB1_DEST_BASE_ENA\0" /* 2882 */
	"CB2_DEST_BASE_ENA\0" /* 2900 */
	"CB3_DEST_BASE_ENA\0" /* 2918 */
	"CB4_DEST_BASE_ENA\0" /* 2936 */
	"CB5_DEST_BASE_ENA\0" /* 2954 */
	"CB6_DEST_BASE_ENA\0" /* 2972 */
	"CB7_DEST_BASE_ENA\0" /* 2990 */
	"DB_DEST_BASE_ENA\0" /* 3008 */
	"DEST_BASE_2_ENA\0" /* 3025 */
	"DEST_BASE_3_ENA\0" /* 3041 */
	"TCL1_ACTION_ENA\0" /* 3057 */
	"TC_ACTION_ENA\0" /* 3073 */
	"CB_ACTION_ENA\0" /* 3087 */
	"DB_ACTION_ENA\0" /* 3101 */
	"SH_KCACHE_ACTION_ENA\0" /* 3115 */
	"SH_ICACHE_ACTION_ENA\0" /* 3136 */
	"COHER_BASE_HI_256B\0" /* 3157 */
	"START_DELAY_COUNT\0" /* 3176 */
	"TC_SD_ACTION_ENA\0" /* 3194 */
	"TC_NC_ACTION_ENA\0" /* 3211 */
	"TCL1_VOL_ACTION_ENA\0" /* 3228 */
	"TC_VOL_ACTION_ENA\0" /* 3248 */
	"TC_WB_ACTION_ENA\0" /* 3266 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 3283 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 3308 */
	"SH_SD_ACTION_ENA\0" /* 3332 */
	"MATCHING_GFX_CNTX\0" /* 3349 */
	"MEID\0" /* 3367 */
	"PHASE1_STATUS\0" /* 3379, 3372 */
	"MEC1_BUSY\0" /* 3386 */
	"MEC2_BUSY\0" /* 3396 */
	"DC0_BUSY\0" /* 3406 */
	"DC1_BUSY\0" /* 3415 */
	"RCIU1_BUSY\0" /* 3424 */
	"RCIU2_BUSY\0" /* 3435 */
	"ROQ1_BUSY\0" /* 3446 */
	"ROQ2_BUSY\0" /* 3456 */
	"TCIU_BUSY\0" /* 3466 */
	"SCRATCH_RAM_BUSY\0" /* 3476 */
	"QU_BUSY\0" /* 3493 */
	"ATCL2IU_BUSY\0" /* 3501 */
	"CPG_CPC_BUSY\0" /* 3514 */
	"CPF_CPC_BUSY\0" /* 3527 */
	"MEC1_LOAD_BUSY\0" /* 3540 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 3555 */
	"MEC1_MUTEX_BUSY\0" /* 3575 */
	"MEC1_MESSAGE_BUSY\0" /* 3591 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 3609 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 3629 */
	"MEC1_IB_QUEUE_BUSY\0" /* 3648 */
	"MEC1_TC_BUSY\0" /* 3667 */
	"MEC1_DMA_BUSY\0" /* 3680 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 3694 */
	"MEC1_PIPE0_BUSY\0" /* 3718 */
	"MEC1_PIPE1_BUSY\0" /* 3734 */
	"MEC1_PIPE2_BUSY\0" /* 3750 */
	"MEC1_PIPE3_BUSY\0" /* 3766 */
	"MEC2_LOAD_BUSY\0" /* 3782 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 3797 */
	"MEC2_MUTEX_BUSY\0" /* 3817 */
	"MEC2_MESSAGE_BUSY\0" /* 3833 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 3851 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 3871 */
	"MEC2_IB_QUEUE_BUSY\0" /* 3890 */
	"MEC2_TC_BUSY\0" /* 3909 */
	"MEC2_DMA_BUSY\0" /* 3922 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 3936 */
	"MEC2_PIPE0_BUSY\0" /* 3960 */
	"MEC2_PIPE1_BUSY\0" /* 3976 */
	"MEC2_PIPE2_BUSY\0" /* 3992 */
	"MEC2_PIPE3_BUSY\0" /* 4008 */
	"RCIU_TX_FREE_STALL\0" /* 4024 */
	"RCIU_PRIV_VIOLATION\0" /* 4043 */
	"TCIU_TX_FREE_STALL\0" /* 4063 */
	"MEC1_DECODING_PACKET\0" /* 4082 */
	"MEC1_WAIT_ON_RCIU\0" /* 4103 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 4121 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 4144 */
	"MEC2_DECODING_PACKET\0" /* 4166 */
	"MEC2_WAIT_ON_RCIU\0" /* 4187 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 4205 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 4228 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 4250 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 4274 */
	"ATCL1_WAITING_ON_TRANS\0" /* 4298 */
	"POST_WPTR_GFX_BUSY\0" /* 4321 */
	"CSF_BUSY\0" /* 4340 */
	"ROQ_ALIGN_BUSY\0" /* 4349 */
	"ROQ_RING_BUSY\0" /* 4364 */
	"ROQ_INDIRECT1_BUSY\0" /* 4378 */
	"ROQ_INDIRECT2_BUSY\0" /* 4397 */
	"ROQ_STATE_BUSY\0" /* 4416 */
	"ROQ_CE_RING_BUSY\0" /* 4431 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 4448 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 4470 */
	"SEMAPHORE_BUSY\0" /* 4492 */
	"INTERRUPT_BUSY\0" /* 4507 */
	"HQD_BUSY\0" /* 4522 */
	"PRT_BUSY\0" /* 4531 */
	"CPF_GFX_BUSY\0" /* 4540 */
	"CPF_CMP_BUSY\0" /* 4553 */
	"GRBM_CPF_STAT_BUSY\0" /* 4566 */
	"CPC_CPF_BUSY\0" /* 4585 */
	"REG_BUS_FIFO_BUSY\0" /* 4598 */
	"CSF_RING_BUSY\0" /* 4616 */
	"CSF_INDIRECT1_BUSY\0" /* 4630 */
	"CSF_INDIRECT2_BUSY\0" /* 4649 */
	"CSF_STATE_BUSY\0" /* 4668 */
	"CSF_CE_INDR1_BUSY\0" /* 4683 */
	"CSF_CE_INDR2_BUSY\0" /* 4701 */
	"CSF_ARBITER_BUSY\0" /* 4719 */
	"CSF_INPUT_BUSY\0" /* 4736 */
	"OUTSTANDING_READ_TAGS\0" /* 4751 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 4773 */
	"HQD_DISPATCH_BUSY\0" /* 4797 */
	"HQD_IQ_TIMER_BUSY\0" /* 4815 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 4833 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 4854 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 4878 */
	"HQD_MESSAGE_BUSY\0" /* 4904 */
	"HQD_PQ_FETCHER_BUSY\0" /* 4921 */
	"HQD_IB_FETCHER_BUSY\0" /* 4941 */
	"HQD_IQ_FETCHER_BUSY\0" /* 4961 */
	"HQD_EOP_FETCHER_BUSY\0" /* 4981 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 5002 */
	"HQD_FETCHER_ARB_BUSY\0" /* 5025 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 5046 */
	"HQD_ROQ_EOP_BUSY\0" /* 5065 */
	"HQD_ROQ_IQ_BUSY\0" /* 5082 */
	"HQD_ROQ_PQ_BUSY\0" /* 5098 */
	"HQD_ROQ_IB_BUSY\0" /* 5114 */
	"HQD_WPTR_POLL_BUSY\0" /* 5130 */
	"HQD_PQ_BUSY\0" /* 5149 */
	"HQD_IB_BUSY\0" /* 5161 */
	"RING_FETCHING_DATA\0" /* 5173 */
	"INDR1_FETCHING_DATA\0" /* 5192 */
	"INDR2_FETCHING_DATA\0" /* 5212 */
	"STATE_FETCHING_DATA\0" /* 5232 */
	"TCIU_WAITING_ON_FREE\0" /* 5252 */
	"TCIU_WAITING_ON_TAGS\0" /* 5273 */
	"COHER_SIZE_HI_256B\0" /* 5294 */
	"PRIM_COUNT\0" /* 5313 */
	"VS_NO_EXTRA_BUFFER\0" /* 5324 */
	"STREAMOUT_FULL_FLUSH\0" /* 5343 */
	"ES_LIMIT\0" /* 5364, 5367 */
	"VERT_REUSE\0" /* 5373 */
	"DI_PT_NONE\0" /* 5384 */
	"DI_PT_POINTLIST\0" /* 5395 */
	"DI_PT_LINELIST\0" /* 5411 */
	"DI_PT_LINESTRIP\0" /* 5426 */
	"DI_PT_TRILIST\0" /* 5442 */
	"DI_PT_TRIFAN\0" /* 5456 */
	"DI_PT_TRISTRIP\0" /* 5469 */
	"DI_PT_UNUSED_0\0" /* 5484 */
	"DI_PT_UNUSED_1\0" /* 5499 */
	"DI_PT_PATCH\0" /* 5514 */
	"DI_PT_LINELIST_ADJ\0" /* 5526 */
	"DI_PT_LINESTRIP_ADJ\0" /* 5545 */
	"DI_PT_TRILIST_ADJ\0" /* 5565 */
	"DI_PT_TRISTRIP_ADJ\0" /* 5583 */
	"DI_PT_UNUSED_3\0" /* 5602 */
	"DI_PT_UNUSED_4\0" /* 5617 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 5632 */
	"DI_PT_RECTLIST\0" /* 5654 */
	"DI_PT_LINELOOP\0" /* 5669 */
	"DI_PT_QUADLIST\0" /* 5684 */
	"DI_PT_QUADSTRIP\0" /* 5699 */
	"DI_PT_POLYGON\0" /* 5715 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 5729 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 5756 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 5783 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 5810 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 5837 */
	"DI_PT_2D_LINE_STRIP\0" /* 5861 */
	"DI_PT_2D_TRI_STRIP\0" /* 5881 */
	"PRIM_TYPE\0" /* 5900 */
	"DI_INDEX_SIZE_16_BIT\0" /* 5910 */
	"DI_INDEX_SIZE_32_BIT\0" /* 5931 */
	"OFFCHIP_BUFFERING\0" /* 5952 */
	"CLIP_VTX_REORDER_ENA\0" /* 5970 */
	"NUM_CLIP_SEQ\0" /* 5991 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 6004 */
	"VE_NAN_PROC_DISABLE\0" /* 6027 */
	"LINE_STIPPLE_VALUE\0" /* 6047 */
	"CURRENT_PTR\0" /* 6066 */
	"CURRENT_COUNT\0" /* 6078 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 6092 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 6117 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 6155 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 6196 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 6219 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 6242 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 6266 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 6296 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 6325 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 6351 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 6380 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 6405 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 6440 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6468 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 6498 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 6525 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 6552 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 6581 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 6610 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 6639 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6667 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 6697 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 6724 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 6752 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 6777 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 6803 */
	"RCIU_STALLED_ON_ME_READ\0" /* 6828 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 6852 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 6877 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 6905 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 6934 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 6960 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 6986 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 7013 */
	"PFP_RCIU_READ_PENDING\0" /* 7039 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 7061 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 7088 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 7110 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 7134 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 7159 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 7182 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 7209 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 7234 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7262 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7287 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 7312 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 7337 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7366 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 7397 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 7425 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 7452 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 7482 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 7528, 7509 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 7536, 7555 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 7563 */
	"APPEND_ACTIVE_PARTITION\0" /* 7589 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 7613 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 7645 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 7672 */
	"DC_BUSY\0" /* 7698 */
	"PFP_BUSY\0" /* 7706 */
	"MEQ_BUSY\0" /* 7715 */
	"ME_BUSY\0" /* 7724 */
	"QUERY_BUSY\0" /* 7732 */
	"SURFACE_SYNC_BUSY\0" /* 7743 */
	"RCIU_BUSY\0" /* 7761 */
	"CPC_CPG_BUSY\0" /* 7771 */
	"CE_BUSY\0" /* 7784 */
	"INSTANCE_INDEX\0" /* 7792 */
	"SH_INDEX\0" /* 7807 */
	"SE_INDEX\0" /* 7816 */
	"SH_BROADCAST_WRITES\0" /* 7825 */
	"INSTANCE_BROADCAST_WRITES\0" /* 7845 */
	"SE_BROADCAST_WRITES\0" /* 7871 */
	"X_8K_DWORDS\0" /* 7891 */
	"X_4K_DWORDS\0" /* 7903 */
	"X_2K_DWORDS\0" /* 7915 */
	"X_1K_DWORDS\0" /* 7927 */
	"OFFCHIP_GRANULARITY\0" /* 7939 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 7959 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 7985 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 8008 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 8033 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 8064 */
	"DISABLE_SCISSOR_FIX\0" /* 8098 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 8118 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 8145 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 8173 */
	"INST_INVALIDATE\0" /* 8208 */
	"DATA_INVALIDATE\0" /* 8224 */
	"INVALIDATE_VOLATILE\0" /* 8240 */
	"RET\0" /* 8260 */
	"RUI\0" /* 8264 */
	"RNG\0" /* 8268 */
	"EN\0" /* 8272 */
	"SQ_EXP_MRT\0" /* 8275 */
	"SQ_EXP_MRTZ\0" /* 8286 */
	"SQ_EXP_NULL\0" /* 8298 */
	"SQ_EXP_POS\0" /* 8310 */
	"SQ_EXP_PARAM\0" /* 8321 */
	"TGT\0" /* 8334 */
	"COMPR\0" /* 8338 */
	"VM\0" /* 8344 */
	"SQ_ENC_EXP_FIELD\0" /* 8347 */
	"ENCODING\0" /* 8364 */
	"ADDRESS\0" /* 8373 */
	"COUNT_HI\0" /* 8381 */
	"BASE_ADDRESS_HI\0" /* 8395, 8390 */
	"STRIDE\0" /* 8406 */
	"CACHE_SWIZZLE\0" /* 8413 */
	"SWIZZLE_ENABLE\0" /* 8427, 8435 */
	"SQ_SEL_0\0" /* 8442 */
	"SQ_SEL_1\0" /* 8451 */
	"SQ_SEL_RESERVED_0\0" /* 8467, 8460 */
	"SQ_SEL_RESERVED_1\0" /* 8485, 8478 */
	"SQ_SEL_X\0" /* 8496 */
	"SQ_SEL_Y\0" /* 8505 */
	"SQ_SEL_Z\0" /* 8514 */
	"SQ_SEL_W\0" /* 8523 */
	"DST_SEL_X\0" /* 8532 */
	"DST_SEL_Y\0" /* 8542 */
	"DST_SEL_Z\0" /* 8552 */
	"DST_SEL_W\0" /* 8562 */
	"BUF_NUM_FORMAT_UNORM\0" /* 8572 */
	"BUF_NUM_FORMAT_SNORM\0" /* 8593 */
	"BUF_NUM_FORMAT_USCALED\0" /* 8614 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 8637 */
	"BUF_NUM_FORMAT_UINT\0" /* 8660 */
	"BUF_NUM_FORMAT_SINT\0" /* 8680 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 8700 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 8725 */
	"NUM_FORMAT\0" /* 8746, 8750 */
	"BUF_DATA_FORMAT_INVALID\0" /* 8757 */
	"BUF_DATA_FORMAT_8\0" /* 8781 */
	"BUF_DATA_FORMAT_16\0" /* 8799 */
	"BUF_DATA_FORMAT_8_8\0" /* 8818 */
	"BUF_DATA_FORMAT_32\0" /* 8838 */
	"BUF_DATA_FORMAT_16_16\0" /* 8857 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 8879 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 8904 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 8929 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 8956 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 8983 */
	"BUF_DATA_FORMAT_32_32\0" /* 9007 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 9029 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 9057 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 9082 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 9110 */
	"DATA_FORMAT\0" /* 9138 */
	"ELEMENT_SIZE\0" /* 9150 */
	"INDEX_STRIDE\0" /* 9163 */
	"ADD_TID_ENABLE\0" /* 9176 */
	"ATC\0" /* 9191 */
	"HASH_ENABLE\0" /* 9195 */
	"HEAP\0" /* 9207 */
	"MTYPE\0" /* 9212 */
	"SQ_RSRC_BUF\0" /* 9218 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 9230 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 9249 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 9268 */
	"MIN_LOD\0" /* 9287 */
	"IMG_DATA_FORMAT_INVALID\0" /* 9295 */
	"IMG_DATA_FORMAT_8\0" /* 9319 */
	"IMG_DATA_FORMAT_16\0" /* 9337 */
	"IMG_DATA_FORMAT_8_8\0" /* 9356 */
	"IMG_DATA_FORMAT_32\0" /* 9376 */
	"IMG_DATA_FORMAT_16_16\0" /* 9395 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 9417 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 9442 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 9467 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 9494 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 9521 */
	"IMG_DATA_FORMAT_32_32\0" /* 9545 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 9567 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 9595 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 9620 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 9648 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 9676 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 9698 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 9722 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 9746 */
	"IMG_DATA_FORMAT_8_24\0" /* 9770 */
	"IMG_DATA_FORMAT_24_8\0" /* 9791 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 9812 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 9837 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 9866 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 9891 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 9917 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 9940 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 9964 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 9991 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 10019 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 10047 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 10075 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 10097 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 10119 */
	"IMG_DATA_FORMAT_BC1\0" /* 10143 */
	"IMG_DATA_FORMAT_BC2\0" /* 10163 */
	"IMG_DATA_FORMAT_BC3\0" /* 10183 */
	"IMG_DATA_FORMAT_BC4\0" /* 10203 */
	"IMG_DATA_FORMAT_BC5\0" /* 10223 */
	"IMG_DATA_FORMAT_BC6\0" /* 10243 */
	"IMG_DATA_FORMAT_BC7\0" /* 10263 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16\0" /* 10283 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32\0" /* 10317 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 10351 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 10380 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 10409 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 10438 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 10467 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 10496 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 10525 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 10556 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 10586 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 10617 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 10647 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 10677 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 10708 */
	"IMG_DATA_FORMAT_4_4\0" /* 10739 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 10759 */
	"IMG_DATA_FORMAT_1\0" /* 10781 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 10799 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 10826 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 10850 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 10876 */
	"IMG_NUM_FORMAT_UNORM\0" /* 10910 */
	"IMG_NUM_FORMAT_SNORM\0" /* 10931 */
	"IMG_NUM_FORMAT_USCALED\0" /* 10952 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 10975 */
	"IMG_NUM_FORMAT_UINT\0" /* 10998 */
	"IMG_NUM_FORMAT_SINT\0" /* 11018 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 11038 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 11063 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 11084 */
	"IMG_NUM_FORMAT_SRGB\0" /* 11110 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 11130 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 11152 */
	"IMG_NUM_FORMAT_UBINT\0" /* 11178 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 11199 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 11223 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 11250 */
	"WIDTH\0" /* 11277 */
	"HEIGHT\0" /* 11283 */
	"PERF_MOD\0" /* 11290 */
	"INTERLACED\0" /* 11299 */
	"BASE_LEVEL\0" /* 11310 */
	"LAST_LEVEL\0" /* 11321 */
	"TILING_INDEX\0" /* 11332 */
	"POW2_PAD\0" /* 11345 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 11354 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 11373 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 11392 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 11411 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 11430 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 11449 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 11468 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 11487 */
	"SQ_RSRC_IMG_1D\0" /* 11506 */
	"SQ_RSRC_IMG_2D\0" /* 11521 */
	"SQ_RSRC_IMG_3D\0" /* 11536 */
	"SQ_RSRC_IMG_CUBE\0" /* 11551 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 11568 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 11589 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 11610 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 11630 */
	"DEPTH\0" /* 11656 */
	"PITCH\0" /* 11662 */
	"BASE_ARRAY\0" /* 11668 */
	"LAST_ARRAY\0" /* 11679 */
	"MIN_LOD_WARN\0" /* 11690 */
	"COUNTER_BANK_ID\0" /* 11703 */
	"LOD_HDW_CNT_EN\0" /* 11719 */
	"COMPRESSION_EN\0" /* 11734 */
	"ALPHA_IS_ON_MSB\0" /* 11749 */
	"COLOR_TRANSFORM\0" /* 11765 */
	"LOST_ALPHA_BITS\0" /* 11781 */
	"LOST_COLOR_BITS\0" /* 11797 */
	"SQ_TEX_WRAP\0" /* 11813 */
	"SQ_TEX_MIRROR\0" /* 11825 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 11839 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 11863 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 11893 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 11918 */
	"SQ_TEX_CLAMP_BORDER\0" /* 11949 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 11969 */
	"CLAMP_X\0" /* 11995 */
	"CLAMP_Y\0" /* 12003 */
	"CLAMP_Z\0" /* 12011 */
	"MAX_ANISO_RATIO\0" /* 12019 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 12035 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 12062 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 12088 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 12115 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 12146 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 12175 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 12205 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 12239 */
	"DEPTH_COMPARE_FUNC\0" /* 12267 */
	"FORCE_UNNORMALIZED\0" /* 12286 */
	"MC_COORD_TRUNC\0" /* 12305 */
	"FORCE_DEGAMMA\0" /* 12320 */
	"TRUNC_COORD\0" /* 12334 */
	"DISABLE_CUBE_WRAP\0" /* 12346 */
	"FILTER_MODE\0" /* 12371, 12364 */
	"COMPAT_MODE\0" /* 12376 */
	"MAX_LOD\0" /* 12388 */
	"PERF_MIP\0" /* 12396 */
	"PERF_Z\0" /* 12405 */
	"LOD_BIAS\0" /* 12412 */
	"LOD_BIAS_SEC\0" /* 12421 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 12448, 12434 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 12457, 12476 */
	"XY_MAG_FILTER\0" /* 12483 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 12497 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 12526 */
	"XY_MIN_FILTER\0" /* 12558 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 12572 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 12593 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 12615 */
	"Z_FILTER\0" /* 12638 */
	"MIP_FILTER\0" /* 12647 */
	"MIP_POINT_PRECLAMP\0" /* 12658 */
	"DISABLE_LSB_CEIL\0" /* 12677 */
	"FILTER_PREC_FIX\0" /* 12694 */
	"ANISO_OVERRIDE\0" /* 12710 */
	"BORDER_COLOR_PTR\0" /* 12725 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 12742 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 12774 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 12807 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 12840 */
	"BORDER_COLOR_TYPE\0" /* 12869 */
	"VS_LOW_THRESHOLD\0" /* 12887 */
	"GS_LOW_THRESHOLD\0" /* 12904 */
	"ES_LOW_THRESHOLD\0" /* 12921 */
	"HS_LOW_THRESHOLD\0" /* 12938 */
	"LS_LOW_THRESHOLD\0" /* 12955 */
	"PS_CU_EN\0" /* 12972, 12975 */
	"VS_CU_EN\0" /* 12981 */
	"GS_CU_EN\0" /* 12990 */
	"ES_CU_EN\0" /* 12999 */
	"LSHS_CU_EN\0" /* 13008 */
	"MAX_WAVE_ID\0" /* 13019 */
	"X_R0\0" /* 13031 */
	"RING_ORDER_TS0\0" /* 13036 */
	"RING_ORDER_TS1\0" /* 13051 */
	"RING_ORDER_TS2\0" /* 13066 */
	"PIPE_ORDER_TS0\0" /* 13081 */
	"PIPE_ORDER_TS1\0" /* 13096 */
	"PIPE_ORDER_TS2\0" /* 13111 */
	"PIPE_ORDER_TS3\0" /* 13126 */
	"TS0_DUR_MULT\0" /* 13141 */
	"TS1_DUR_MULT\0" /* 13154 */
	"TS2_DUR_MULT\0" /* 13167 */
	"TS3_DUR_MULT\0" /* 13180 */
	"TS0_DURATION\0" /* 13193 */
	"TS1_DURATION\0" /* 13206 */
	"TS2_DURATION\0" /* 13219 */
	"GPR_WRITE_PRIORITY\0" /* 13232, 13242 */
	"EXP_PRIORITY_ORDER\0" /* 13251 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 13270 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 13292 */
	"RSRC_MGMT_RESET\0" /* 13314 */
	"X_DELAY_14_CLKS\0" /* 13330 */
	"X_DELAY_16_CLKS\0" /* 13346 */
	"X_DELAY_18_CLKS\0" /* 13362 */
	"X_DELAY_20_CLKS\0" /* 13378 */
	"X_DELAY_22_CLKS\0" /* 13394 */
	"X_DELAY_24_CLKS\0" /* 13410 */
	"X_DELAY_26_CLKS\0" /* 13426 */
	"X_DELAY_28_CLKS\0" /* 13442 */
	"X_DELAY_30_CLKS\0" /* 13458 */
	"X_DELAY_32_CLKS\0" /* 13474 */
	"X_DELAY_34_CLKS\0" /* 13490 */
	"X_DELAY_4_CLKS\0" /* 13506 */
	"X_DELAY_6_CLKS\0" /* 13521 */
	"X_DELAY_8_CLKS\0" /* 13536 */
	"X_DELAY_10_CLKS\0" /* 13551 */
	"X_DELAY_12_CLKS\0" /* 13567 */
	"VTX_DONE_DELAY\0" /* 13583 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 13598 */
	"PC_LIMIT_ENABLE\0" /* 13622 */
	"PC_LIMIT_STRICT\0" /* 13638 */
	"PC_LIMIT_SIZE\0" /* 13654 */
	"TYPE_A\0" /* 13668 */
	"VGPR_A\0" /* 13675 */
	"SGPR_A\0" /* 13682 */
	"LDS_A\0" /* 13689 */
	"WAVES_A\0" /* 13695 */
	"EN_A\0" /* 13703 */
	"TYPE_B\0" /* 13708 */
	"VGPR_B\0" /* 13715 */
	"SGPR_B\0" /* 13722 */
	"LDS_B\0" /* 13729 */
	"WAVES_B\0" /* 13735 */
	"EN_B\0" /* 13743 */
	"MSAA1_X\0" /* 13748 */
	"MSAA1_Y\0" /* 13756 */
	"MSAA2_X\0" /* 13764 */
	"MSAA2_Y\0" /* 13772 */
	"MSAA4_X\0" /* 13780 */
	"MSAA4_Y\0" /* 13788 */
	"MSAA8_X\0" /* 13796 */
	"MSAA8_Y\0" /* 13804 */
	"MSAA16_X\0" /* 13812 */
	"MSAA16_Y\0" /* 13821 */
	"NUM_PIPES\0" /* 13830 */
	"PIPE_INTERLEAVE_SIZE\0" /* 13840 */
	"BANK_INTERLEAVE_SIZE\0" /* 13861 */
	"NUM_SHADER_ENGINES\0" /* 13882 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 13901 */
	"NUM_GPUS\0" /* 13925 */
	"MULTI_GPU_TILE_SIZE\0" /* 13934 */
	"ROW_SIZE\0" /* 13954 */
	"NUM_LOWER_PIPES\0" /* 13963 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 13979 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 14010 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 14038 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 14067 */
	"MICRO_TILE_MODE\0" /* 14096 */
	"ARRAY_LINEAR_GENERAL\0" /* 14112, 14118 */
	"ARRAY_LINEAR_ALIGNED\0" /* 14133 */
	"ARRAY_1D_TILED_THIN1\0" /* 14154 */
	"ARRAY_1D_TILED_THICK\0" /* 14175 */
	"ARRAY_2D_TILED_THIN1\0" /* 14196 */
	"ARRAY_2D_TILED_THICK\0" /* 14217 */
	"ARRAY_2D_TILED_XTHICK\0" /* 14238 */
	"ARRAY_3D_TILED_THIN1\0" /* 14260 */
	"ARRAY_3D_TILED_THICK\0" /* 14281 */
	"ARRAY_3D_TILED_XTHICK\0" /* 14302 */
	"ARRAY_POWER_SAVE\0" /* 14324 */
	"ARRAY_MODE\0" /* 14341 */
	"ADDR_SURF_P2\0" /* 14352 */
	"ADDR_SURF_P2_RESERVED0\0" /* 14365 */
	"ADDR_SURF_P2_RESERVED1\0" /* 14388 */
	"ADDR_SURF_P2_RESERVED2\0" /* 14424, 14411 */
	"X_ADDR_SURF_P4_8X16\0" /* 14434 */
	"X_ADDR_SURF_P4_16X16\0" /* 14454 */
	"X_ADDR_SURF_P4_16X32\0" /* 14475 */
	"X_ADDR_SURF_P4_32X32\0" /* 14496 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 14517 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 14543 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 14569 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 14595 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 14622 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 14649 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 14676 */
	"PIPE_CONFIG\0" /* 14703 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 14715 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 14740 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 14766 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 14792 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 14818 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 14843 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 14868 */
	"TILE_SPLIT\0" /* 14893 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 14904 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 14927 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 14950 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 14973 */
	"BANK_WIDTH\0" /* 14996 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 15007 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 15031 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 15055 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 15079 */
	"BANK_HEIGHT\0" /* 15103 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 15115 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 15140 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 15165 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 15190 */
	"MACRO_TILE_ASPECT\0" /* 15215 */
	"ADDR_SURF_2_BANK\0" /* 15233 */
	"ADDR_SURF_4_BANK\0" /* 15250 */
	"ADDR_SURF_8_BANK\0" /* 15267 */
	"ADDR_SURF_16_BANK\0" /* 15284 */
	"NUM_BANKS\0" /* 15302 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 15312 */
	"MICRO_TILE_MODE_NEW\0" /* 15343 */
	"SAMPLE_SPLIT\0" /* 15363 */
	"MEM_BASE\0" /* 15376 */
	"WAVE_LIMIT\0" /* 15385 */
	"LOCK_LOW_THRESHOLD\0" /* 15396 */
	"VGPRS\0" /* 15415 */
	"SGPRS\0" /* 15421 */
	"FP_32_DENORMS\0" /* 15427 */
	"FP_64_DENORMS\0" /* 15441 */
	"FP_ALL_DENORMS\0" /* 15455 */
	"FLOAT_MODE\0" /* 15470 */
	"PRIV\0" /* 15481 */
	"DX10_CLAMP\0" /* 15486 */
	"DEBUG_MODE\0" /* 15497 */
	"IEEE_MODE\0" /* 15508 */
	"CU_GROUP_DISABLE\0" /* 15518 */
	"CACHE_CTL\0" /* 15535 */
	"CDBG_USER\0" /* 15545 */
	"SCRATCH_EN\0" /* 15555 */
	"USER_SGPR\0" /* 15566 */
	"TRAP_PRESENT\0" /* 15576 */
	"WAVE_CNT_EN\0" /* 15589 */
	"EXTRA_LDS_SIZE\0" /* 15601, 15607 */
	"EXCP_EN\0" /* 15616 */
	"EXCP_EN_CIK\0" /* 15624 */
	"VGPR_COMP_CNT\0" /* 15636, 15646 */
	"CU_GROUP_ENABLE\0" /* 15650 */
	"OC_LDS_EN\0" /* 15666 */
	"SO_BASE0_EN\0" /* 15676 */
	"SO_BASE1_EN\0" /* 15688 */
	"SO_BASE2_EN\0" /* 15700 */
	"SO_BASE3_EN\0" /* 15712 */
	"SO_EN\0" /* 15724 */
	"DISPATCH_DRAW_EN\0" /* 15730 */
	"GROUP_FIFO_DEPTH\0" /* 15747 */
	"TG_SIZE_EN\0" /* 15764 */
	"COMPUTE_SHADER_EN\0" /* 15775 */
	"PARTIAL_TG_EN\0" /* 15793 */
	"FORCE_START_AT_000\0" /* 15807 */
	"ORDERED_APPEND_ENBL\0" /* 15826 */
	"ORDERED_APPEND_MODE\0" /* 15846 */
	"USE_THREAD_DIMENSIONS\0" /* 15866 */
	"ORDER_MODE\0" /* 15888 */
	"DISPATCH_CACHE_CNTL\0" /* 15899 */
	"SCALAR_L1_INV_VOL\0" /* 15919 */
	"VECTOR_L1_INV_VOL\0" /* 15937 */
	"DATA_ATC\0" /* 15955 */
	"RESTORE\0" /* 15964 */
	"NUM_THREAD_FULL\0" /* 15972 */
	"NUM_THREAD_PARTIAL\0" /* 15988 */
	"PIPELINESTAT_ENABLE\0" /* 16007 */
	"PERFCOUNT_ENABLE\0" /* 16027 */
	"INST_ATC\0" /* 16044 */
	"BULKY\0" /* 16053 */
	"TGID_X_EN\0" /* 16059 */
	"TGID_Y_EN\0" /* 16069 */
	"TGID_Z_EN\0" /* 16079 */
	"TIDIG_COMP_CNT\0" /* 16089 */
	"EXCP_EN_MSB\0" /* 16104 */
	"WAVES_PER_SH\0" /* 16116 */
	"WAVES_PER_SH_CIK\0" /* 16129 */
	"TG_PER_CU\0" /* 16146 */
	"LOCK_THRESHOLD\0" /* 16156 */
	"SIMD_DEST_CNTL\0" /* 16171 */
	"FORCE_SIMD_DIST\0" /* 16186 */
	"CU_GROUP_COUNT\0" /* 16202 */
	"SH0_CU_EN\0" /* 16217 */
	"SH1_CU_EN\0" /* 16227 */
	"WAVES\0" /* 16237 */
	"WAVESIZE\0" /* 16243 */
	"SEND_SEID\0" /* 16252 */
	"RESERVED3\0" /* 16262 */
	"RESERVED4\0" /* 16272 */
	"WAVE_ID_BASE\0" /* 16282 */
	"PAYLOAD\0" /* 16295 */
	"IS_EVENT\0" /* 16303 */
	"IS_STATE\0" /* 16312 */
	"PERFCOUNTER_HI\0" /* 16321 */
	"PERF_SEL2\0" /* 16336 */
	"PERF_SEL3\0" /* 16346 */
	"PERF_SEL\0" /* 16356 */
	"PERF_SEL1\0" /* 16365 */
	"CNTR_MODE\0" /* 16375 */
	"DISABLE_AND_RESET\0" /* 16385 */
	"START_COUNTING\0" /* 16403 */
	"STOP_COUNTING\0" /* 16418 */
	"PERFMON_STATE\0" /* 16432 */
	"SPM_PERFMON_STATE\0" /* 16446 */
	"PERFMON_ENABLE_MODE\0" /* 16464 */
	"PERFMON_SAMPLE_ENABLE\0" /* 16484 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 16506 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 16533 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 16560 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 16587 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 16613 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 16639 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 16666 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 16692 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 16718 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 16746 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 16772 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 16798 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 16824 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 16850 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 16877 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 16904 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 16931 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 16957 */
	"PERF_MODE\0" /* 16983 */
	"PERF_MODE1\0" /* 16993 */
	"PERF_MODE3\0" /* 17004 */
	"PERF_MODE2\0" /* 17015 */
	"PERF_SEID_IGNORE_MASK\0" /* 17026 */
	"BIN0_MIN\0" /* 17048 */
	"BIN0_MAX\0" /* 17057 */
	"BIN1_MIN\0" /* 17066 */
	"BIN1_MAX\0" /* 17075 */
	"BIN2_MIN\0" /* 17084 */
	"BIN2_MAX\0" /* 17093 */
	"BIN3_MIN\0" /* 17102 */
	"BIN3_MAX\0" /* 17111 */
	"SQC_BANK_MASK\0" /* 17120 */
	"SQC_CLIENT_MASK\0" /* 17134 */
	"SPM_MODE\0" /* 17150 */
	"SIMD_MASK\0" /* 17159 */
	"PS_EN\0" /* 17169 */
	"VS_EN\0" /* 17175 */
	"GS_EN\0" /* 17181 */
	"ES_EN\0" /* 17187 */
	"HS_EN\0" /* 17193 */
	"LS_EN\0" /* 17199 */
	"CS_EN\0" /* 17205 */
	"CNTR_RATE\0" /* 17211 */
	"DISABLE_FLUSH\0" /* 17221 */
	"SH0_MASK\0" /* 17235 */
	"SH1_MASK\0" /* 17244 */
	"FORCE_EN\0" /* 17253 */
	"PERFCOUNTER_SELECT\0" /* 17262 */
	"PERFCOUNTER_SELECT1\0" /* 17281 */
	"PERFCOUNTER_SELECT2\0" /* 17301 */
	"PERFCOUNTER_SELECT3\0" /* 17321 */
	"OP_FILTER_ENABLE\0" /* 17341 */
	"OP_FILTER_SEL\0" /* 17358 */
	"FORMAT_FILTER_ENABLE\0" /* 17372 */
	"FORMAT_FILTER_SEL\0" /* 17393 */
	"CLEAR_FILTER_ENABLE\0" /* 17411 */
	"CLEAR_FILTER_SEL\0" /* 17431 */
	"MRT_FILTER_ENABLE\0" /* 17448 */
	"MRT_FILTER_SEL\0" /* 17466 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 17481 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 17507 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 17530 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 17558 */
	"DEPTH_CLEAR_ENABLE\0" /* 17583 */
	"STENCIL_CLEAR_ENABLE\0" /* 17602 */
	"DEPTH_COPY\0" /* 17623 */
	"STENCIL_COPY\0" /* 17634 */
	"RESUMMARIZE_ENABLE\0" /* 17647 */
	"STENCIL_COMPRESS_DISABLE\0" /* 17666 */
	"DEPTH_COMPRESS_DISABLE\0" /* 17691 */
	"COPY_CENTROID\0" /* 17714 */
	"COPY_SAMPLE\0" /* 17728 */
	"DECOMPRESS_ENABLE\0" /* 17740 */
	"ZPASS_INCREMENT_DISABLE\0" /* 17758 */
	"PERFECT_ZPASS_COUNTS\0" /* 17782 */
	"SAMPLE_RATE\0" /* 17803 */
	"ZPASS_ENABLE\0" /* 17815 */
	"ZFAIL_ENABLE\0" /* 17828 */
	"SFAIL_ENABLE\0" /* 17841 */
	"DBFAIL_ENABLE\0" /* 17854 */
	"SLICE_EVEN_ENABLE\0" /* 17868 */
	"SLICE_ODD_ENABLE\0" /* 17886 */
	"SLICE_START\0" /* 17903 */
	"SLICE_MAX\0" /* 17915 */
	"Z_READ_ONLY\0" /* 17925 */
	"STENCIL_READ_ONLY\0" /* 17937 */
	"FORCE_OFF\0" /* 17955 */
	"FORCE_ENABLE\0" /* 17965 */
	"FORCE_DISABLE\0" /* 17978 */
	"FORCE_RESERVED\0" /* 17992 */
	"FORCE_HIZ_ENABLE\0" /* 18015, 18007 */
	"FORCE_HIS_ENABLE0\0" /* 18024, 18034 */
	"FORCE_HIS_ENABLE1\0" /* 18042, 18052 */
	"FORCE_SHADER_Z_ORDER\0" /* 18073, 18060 */
	"FAST_Z_DISABLE\0" /* 18081 */
	"FAST_STENCIL_DISABLE\0" /* 18096 */
	"NOOP_CULL_DISABLE\0" /* 18117 */
	"FORCE_COLOR_KILL\0" /* 18135 */
	"FORCE_Z_READ\0" /* 18152 */
	"FORCE_STENCIL_READ\0" /* 18165 */
	"FORCE_FULL_Z_RANGE\0" /* 18184 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 18203 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 18227 */
	"IGNORE_SC_ZRANGE\0" /* 18250 */
	"DISABLE_FULLY_COVERED\0" /* 18267 */
	"FORCE_SUMM_OFF\0" /* 18289 */
	"FORCE_SUMM_MINZ\0" /* 18304 */
	"FORCE_SUMM_MAXZ\0" /* 18320 */
	"FORCE_SUMM_BOTH\0" /* 18336 */
	"FORCE_Z_LIMIT_SUMM\0" /* 18352 */
	"MAX_TILES_IN_DTT\0" /* 18371 */
	"DISABLE_TILE_RATE_TILES\0" /* 18388 */
	"FORCE_Z_DIRTY\0" /* 18412 */
	"FORCE_STENCIL_DIRTY\0" /* 18426 */
	"FORCE_Z_VALID\0" /* 18446 */
	"FORCE_STENCIL_VALID\0" /* 18460 */
	"PRESERVE_COMPRESSION\0" /* 18480, 18489 */
	"PSLC_AUTO\0" /* 18501 */
	"PSLC_ON_HANG_ONLY\0" /* 18511 */
	"PSLC_ASAP\0" /* 18529 */
	"PSLC_COUNTDOWN\0" /* 18539 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 18554 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 18583 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 18614 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 18650 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 18685 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 18713 */
	"DISABLE_REG_SNOOP\0" /* 18735 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 18753 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 18785 */
	"HIZ_ZFUNC\0" /* 18811, 18815 */
	"HIS_SFUNC_FF\0" /* 18821 */
	"HIS_SFUNC_BF\0" /* 18834 */
	"PRESERVE_ZRANGE\0" /* 18847 */
	"PRESERVE_SRESULTS\0" /* 18863 */
	"DISABLE_FAST_PASS\0" /* 18881 */
	"CLEAR\0" /* 18899 */
	"TL_X\0" /* 18905 */
	"TL_Y\0" /* 18910 */
	"BR_X\0" /* 18915 */
	"BR_Y\0" /* 18920 */
	"ADDR5_SWIZZLE_MASK\0" /* 18925 */
	"ARRAY_PRT_TILED_THIN1\0" /* 18944 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 18966 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 18991 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 19018 */
	"Z_INVALID\0" /* 19046 */
	"Z_16\0" /* 19056 */
	"Z_24\0" /* 19061 */
	"Z_32_FLOAT\0" /* 19066 */
	"NUM_SAMPLES\0" /* 19077 */
	"TILE_MODE_INDEX\0" /* 19089 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 19105 */
	"ALLOW_EXPCLEAR\0" /* 19129 */
	"READ_SIZE\0" /* 19144 */
	"TILE_SURFACE_ENABLE\0" /* 19154 */
	"CLEAR_DISALLOWED\0" /* 19174 */
	"ZRANGE_PRECISION\0" /* 19191 */
	"STENCIL_INVALID\0" /* 19208 */
	"STENCIL_8\0" /* 19224 */
	"TILE_STENCIL_DISABLE\0" /* 19234 */
	"PITCH_TILE_MAX\0" /* 19261, 19255 */
	"HEIGHT_TILE_MAX\0" /* 19270 */
	"SLICE_TILE_MAX\0" /* 19286 */
	"WINDOW_X_OFFSET\0" /* 19308, 19301 */
	"WINDOW_Y_OFFSET\0" /* 19324, 19317 */
	"WINDOW_OFFSET_DISABLE\0" /* 19333 */
	"CLIP_RULE\0" /* 19355 */
	"ER_TRI\0" /* 19365 */
	"ER_RECT\0" /* 19372 */
	"ER_LINE_LR\0" /* 19380 */
	"ER_LINE_RL\0" /* 19391 */
	"ER_LINE_TB\0" /* 19402 */
	"ER_LINE_BT\0" /* 19413 */
	"HW_SCREEN_OFFSET_X\0" /* 19424 */
	"HW_SCREEN_OFFSET_Y\0" /* 19443 */
	"TARGET0_ENABLE\0" /* 19462 */
	"TARGET1_ENABLE\0" /* 19477 */
	"TARGET2_ENABLE\0" /* 19492 */
	"TARGET3_ENABLE\0" /* 19507 */
	"TARGET4_ENABLE\0" /* 19522 */
	"TARGET5_ENABLE\0" /* 19537 */
	"TARGET6_ENABLE\0" /* 19552 */
	"TARGET7_ENABLE\0" /* 19567 */
	"OUTPUT0_ENABLE\0" /* 19582 */
	"OUTPUT1_ENABLE\0" /* 19597 */
	"OUTPUT2_ENABLE\0" /* 19612 */
	"OUTPUT3_ENABLE\0" /* 19627 */
	"OUTPUT4_ENABLE\0" /* 19642 */
	"OUTPUT5_ENABLE\0" /* 19657 */
	"OUTPUT6_ENABLE\0" /* 19672 */
	"OUTPUT7_ENABLE\0" /* 19687 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 19702 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 19725 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 19748 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 19771 */
	"RB_MAP_PKR0\0" /* 19794 */
	"RB_MAP_PKR1\0" /* 19806 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 19818 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 19843 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 19868 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 19893 */
	"RB_XSEL2\0" /* 19918 */
	"RB_XSEL\0" /* 19927 */
	"RB_YSEL\0" /* 19935 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 19943 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 19967 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 19991 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 20015 */
	"PKR_MAP\0" /* 20039 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 20047 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 20072 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 20097 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 20122 */
	"PKR_XSEL\0" /* 20147 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 20156 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 20181 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 20206 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 20231 */
	"PKR_YSEL\0" /* 20256 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 20265 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 20291 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 20317 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 20343 */
	"PKR_XSEL2\0" /* 20369 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 20379 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 20402 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 20425 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 20448 */
	"SC_MAP\0" /* 20471 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 20478 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 20512 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 20547 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 20582 */
	"SC_XSEL\0" /* 20617 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 20625 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 20659 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 20694 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 20729 */
	"SC_YSEL\0" /* 20764 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 20772 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 20795 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 20818 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 20841 */
	"SE_MAP\0" /* 20864 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 20871 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 20905 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 20940 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 20975 */
	"SE_XSEL\0" /* 21010 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 21018 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 21052 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 21087 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 21122 */
	"SE_YSEL\0" /* 21157 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 21165 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 21193 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 21221 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 21249 */
	"SE_PAIR_MAP\0" /* 21277 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 21289 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 21328 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 21368 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 21408 */
	"SE_PAIR_XSEL\0" /* 21448 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 21461 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 21500 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 21540 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 21580 */
	"SE_PAIR_YSEL\0" /* 21620 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 21633 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 21660 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 21699 */
	"STENCIL_KEEP\0" /* 21728 */
	"STENCIL_ZERO\0" /* 21741 */
	"STENCIL_ONES\0" /* 21754 */
	"STENCIL_REPLACE_TEST\0" /* 21767 */
	"STENCIL_REPLACE_OP\0" /* 21788 */
	"STENCIL_ADD_CLAMP\0" /* 21807 */
	"STENCIL_SUB_CLAMP\0" /* 21825 */
	"STENCIL_INVERT\0" /* 21843 */
	"STENCIL_ADD_WRAP\0" /* 21858 */
	"STENCIL_SUB_WRAP\0" /* 21875 */
	"STENCIL_AND\0" /* 21892 */
	"STENCIL_OR\0" /* 21904 */
	"STENCIL_XOR\0" /* 21915 */
	"STENCIL_NAND\0" /* 21927 */
	"STENCIL_NOR\0" /* 21940 */
	"STENCIL_XNOR\0" /* 21952 */
	"STENCILFAIL\0" /* 21965 */
	"STENCILZPASS\0" /* 21977 */
	"STENCILZFAIL\0" /* 21990 */
	"STENCILFAIL_BF\0" /* 22003 */
	"STENCILZPASS_BF\0" /* 22018 */
	"STENCILZFAIL_BF\0" /* 22034 */
	"STENCILTESTVAL\0" /* 22050 */
	"STENCILMASK\0" /* 22065 */
	"STENCILWRITEMASK\0" /* 22077 */
	"STENCILOPVAL\0" /* 22094 */
	"STENCILTESTVAL_BF\0" /* 22107 */
	"STENCILMASK_BF\0" /* 22125 */
	"STENCILWRITEMASK_BF\0" /* 22140 */
	"STENCILOPVAL_BF\0" /* 22160 */
	"X_0_0F\0" /* 22176 */
	"DEFAULT_VAL\0" /* 22183 */
	"FLAT_SHADE\0" /* 22195 */
	"CYL_WRAP\0" /* 22206 */
	"PT_SPRITE_TEX\0" /* 22215 */
	"DUP\0" /* 22229 */
	"FP16_INTERP_MODE\0" /* 22233 */
	"USE_DEFAULT_ATTR1\0" /* 22250 */
	"DEFAULT_VAL_ATTR1\0" /* 22268 */
	"PT_SPRITE_TEX_ATTR1\0" /* 22286 */
	"ATTR0_VALID\0" /* 22306 */
	"ATTR1_VALID\0" /* 22318 */
	"VS_EXPORT_COUNT\0" /* 22330 */
	"VS_HALF_PACK\0" /* 22346 */
	"VS_EXPORTS_FOG\0" /* 22359 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 22374 */
	"PERSP_SAMPLE_ENA\0" /* 22394 */
	"PERSP_CENTER_ENA\0" /* 22411 */
	"PERSP_CENTROID_ENA\0" /* 22428 */
	"PERSP_PULL_MODEL_ENA\0" /* 22447 */
	"LINEAR_SAMPLE_ENA\0" /* 22468 */
	"LINEAR_CENTER_ENA\0" /* 22486 */
	"LINEAR_CENTROID_ENA\0" /* 22504 */
	"LINE_STIPPLE_TEX_ENA\0" /* 22524 */
	"POS_X_FLOAT_ENA\0" /* 22545 */
	"POS_Y_FLOAT_ENA\0" /* 22561 */
	"POS_Z_FLOAT_ENA\0" /* 22577 */
	"POS_W_FLOAT_ENA\0" /* 22593 */
	"FRONT_FACE_ENA\0" /* 22609 */
	"ANCILLARY_ENA\0" /* 22624 */
	"SAMPLE_COVERAGE_ENA\0" /* 22638 */
	"POS_FIXED_PT_ENA\0" /* 22658 */
	"FLAT_SHADE_ENA\0" /* 22675 */
	"PNT_SPRITE_ENA\0" /* 22690 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 22705 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 22726 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 22747 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 22768 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 22789 */
	"PNT_SPRITE_OVRD_X\0" /* 22813 */
	"PNT_SPRITE_OVRD_Y\0" /* 22831 */
	"PNT_SPRITE_OVRD_Z\0" /* 22849 */
	"PNT_SPRITE_OVRD_W\0" /* 22867 */
	"PNT_SPRITE_TOP_1\0" /* 22885 */
	"NUM_INTERP\0" /* 22902 */
	"PARAM_GEN\0" /* 22913 */
	"FOG_ADDR\0" /* 22923 */
	"BC_OPTIMIZE_DISABLE\0" /* 22932 */
	"PASS_FOG_THROUGH_PS\0" /* 22952 */
	"PERSP_CENTER_CNTL\0" /* 22972 */
	"PERSP_CENTROID_CNTL\0" /* 22990 */
	"LINEAR_CENTER_CNTL\0" /* 23010 */
	"LINEAR_CENTROID_CNTL\0" /* 23029 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 23050 */
	"POS_FLOAT_LOCATION\0" /* 23099 */
	"POS_FLOAT_ULC\0" /* 23118 */
	"FRONT_FACE_ALL_BITS\0" /* 23132 */
	"NUM_PS_WAVES\0" /* 23152 */
	"NUM_VS_WAVES\0" /* 23165 */
	"NUM_GS_WAVES\0" /* 23178 */
	"NUM_ES_WAVES\0" /* 23191 */
	"NUM_HS_WAVES\0" /* 23204 */
	"NUM_LS_WAVES\0" /* 23217 */
	"SPI_SHADER_NONE\0" /* 23230 */
	"SPI_SHADER_1COMP\0" /* 23246 */
	"SPI_SHADER_2COMP\0" /* 23263 */
	"SPI_SHADER_4COMPRESS\0" /* 23280 */
	"SPI_SHADER_4COMP\0" /* 23301 */
	"POS0_EXPORT_FORMAT\0" /* 23318 */
	"POS1_EXPORT_FORMAT\0" /* 23337 */
	"POS2_EXPORT_FORMAT\0" /* 23356 */
	"POS3_EXPORT_FORMAT\0" /* 23375 */
	"SPI_SHADER_ZERO\0" /* 23394 */
	"SPI_SHADER_32_R\0" /* 23410 */
	"SPI_SHADER_32_GR\0" /* 23426 */
	"SPI_SHADER_32_AR\0" /* 23443 */
	"SPI_SHADER_FP16_ABGR\0" /* 23460 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 23481 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 23505 */
	"SPI_SHADER_UINT16_ABGR\0" /* 23529 */
	"SPI_SHADER_SINT16_ABGR\0" /* 23552 */
	"SPI_SHADER_32_ABGR\0" /* 23575 */
	"Z_EXPORT_FORMAT\0" /* 23594 */
	"COL0_EXPORT_FORMAT\0" /* 23610 */
	"COL1_EXPORT_FORMAT\0" /* 23629 */
	"COL2_EXPORT_FORMAT\0" /* 23648 */
	"COL3_EXPORT_FORMAT\0" /* 23667 */
	"COL4_EXPORT_FORMAT\0" /* 23686 */
	"COL5_EXPORT_FORMAT\0" /* 23705 */
	"COL6_EXPORT_FORMAT\0" /* 23724 */
	"COL7_EXPORT_FORMAT\0" /* 23743 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 23762 */
	"SX_RT_EXPORT_32_R\0" /* 23789 */
	"SX_RT_EXPORT_32_A\0" /* 23807 */
	"SX_RT_EXPORT_10_11_11\0" /* 23825 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 23847 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 23871 */
	"SX_RT_EXPORT_5_6_5\0" /* 23892 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 23911 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 23932 */
	"SX_RT_EXPORT_16_16_GR\0" /* 23953 */
	"SX_RT_EXPORT_16_16_AR\0" /* 23975 */
	"MRT0\0" /* 23997 */
	"MRT1\0" /* 24002 */
	"MRT2\0" /* 24007 */
	"MRT3\0" /* 24012 */
	"MRT4\0" /* 24017 */
	"MRT5\0" /* 24022 */
	"MRT6\0" /* 24027 */
	"MRT7\0" /* 24032 */
	"EXACT\0" /* 24037 */
	"11BIT_FORMAT\0" /* 24043 */
	"10BIT_FORMAT\0" /* 24056 */
	"8BIT_FORMAT\0" /* 24069 */
	"6BIT_FORMAT\0" /* 24081 */
	"5BIT_FORMAT\0" /* 24093 */
	"4BIT_FORMAT\0" /* 24105 */
	"MRT0_EPSILON\0" /* 24117 */
	"MRT1_EPSILON\0" /* 24130 */
	"MRT2_EPSILON\0" /* 24143 */
	"MRT3_EPSILON\0" /* 24156 */
	"MRT4_EPSILON\0" /* 24169 */
	"MRT5_EPSILON\0" /* 24182 */
	"MRT6_EPSILON\0" /* 24195 */
	"MRT7_EPSILON\0" /* 24208 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 24221 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 24244 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 24267 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 24290 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 24313 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 24336 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 24359 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 24382 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 24405 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 24428 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 24451 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 24474 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 24497 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 24520 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 24543 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 24566 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 24589 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 24612 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 24647 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 24682 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 24714 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 24746 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 24778 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 24810 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 24844 */
	"COLOR_SRC_OPT\0" /* 24880 */
	"COLOR_DST_OPT\0" /* 24894 */
	"OPT_COMB_NONE\0" /* 24908 */
	"OPT_COMB_ADD\0" /* 24922 */
	"OPT_COMB_SUBTRACT\0" /* 24935 */
	"OPT_COMB_MIN\0" /* 24953 */
	"OPT_COMB_MAX\0" /* 24966 */
	"OPT_COMB_REVSUBTRACT\0" /* 24979 */
	"OPT_COMB_BLEND_DISABLED\0" /* 25000 */
	"OPT_COMB_SAFE_ADD\0" /* 25024 */
	"COLOR_COMB_FCN\0" /* 25042 */
	"ALPHA_SRC_OPT\0" /* 25057 */
	"ALPHA_DST_OPT\0" /* 25071 */
	"ALPHA_COMB_FCN\0" /* 25085 */
	"BLEND_ZERO\0" /* 25100 */
	"BLEND_ONE\0" /* 25111 */
	"BLEND_SRC_COLOR\0" /* 25121 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 25137 */
	"BLEND_SRC_ALPHA\0" /* 25163 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 25179 */
	"BLEND_DST_ALPHA\0" /* 25205 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 25221 */
	"BLEND_DST_COLOR\0" /* 25247 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 25263 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 25289 */
	"BLEND_CONSTANT_COLOR\0" /* 25314 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 25335 */
	"BLEND_SRC1_COLOR\0" /* 25366 */
	"BLEND_INV_SRC1_COLOR\0" /* 25383 */
	"BLEND_SRC1_ALPHA\0" /* 25404 */
	"BLEND_INV_SRC1_ALPHA\0" /* 25421 */
	"BLEND_CONSTANT_ALPHA\0" /* 25442 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 25463 */
	"COLOR_SRCBLEND\0" /* 25494 */
	"COMB_DST_PLUS_SRC\0" /* 25509 */
	"COMB_SRC_MINUS_DST\0" /* 25527 */
	"COMB_MIN_DST_SRC\0" /* 25546 */
	"COMB_MAX_DST_SRC\0" /* 25563 */
	"COMB_DST_MINUS_SRC\0" /* 25580 */
	"COLOR_DESTBLEND\0" /* 25599 */
	"ALPHA_SRCBLEND\0" /* 25615 */
	"ALPHA_DESTBLEND\0" /* 25630 */
	"SEPARATE_ALPHA_BLEND\0" /* 25646 */
	"DISABLE_ROP3\0" /* 25675, 25667 */
	"SRC_STATE_ID\0" /* 25680 */
	"BASE_ADDR\0" /* 25693 */
	"DI_SRC_SEL_DMA\0" /* 25703 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 25718 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 25739 */
	"DI_SRC_SEL_RESERVED\0" /* 25761 */
	"SOURCE_SELECT\0" /* 25781 */
	"DI_MAJOR_MODE_0\0" /* 25795 */
	"DI_MAJOR_MODE_1\0" /* 25811 */
	"MAJOR_MODE\0" /* 25827 */
	"NOT_EOP\0" /* 25838 */
	"USE_OPAQUE\0" /* 25846 */
	"ADDRESS_LOW\0" /* 25857 */
	"STENCIL_ENABLE\0" /* 25869 */
	"Z_WRITE_ENABLE\0" /* 25884 */
	"DEPTH_BOUNDS_ENABLE\0" /* 25899 */
	"FRAG_NEVER\0" /* 25919 */
	"FRAG_LESS\0" /* 25930 */
	"FRAG_EQUAL\0" /* 25940 */
	"FRAG_LEQUAL\0" /* 25951 */
	"FRAG_GREATER\0" /* 25963 */
	"FRAG_NOTEQUAL\0" /* 25976 */
	"FRAG_GEQUAL\0" /* 25990 */
	"FRAG_ALWAYS\0" /* 26002 */
	"BACKFACE_ENABLE\0" /* 26014 */
	"REF_NEVER\0" /* 26030 */
	"REF_LESS\0" /* 26040 */
	"REF_EQUAL\0" /* 26049 */
	"REF_LEQUAL\0" /* 26059 */
	"REF_GREATER\0" /* 26070 */
	"REF_NOTEQUAL\0" /* 26082 */
	"REF_GEQUAL\0" /* 26095 */
	"REF_ALWAYS\0" /* 26106 */
	"STENCILFUNC\0" /* 26117 */
	"STENCILFUNC_BF\0" /* 26129 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 26144 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 26178 */
	"MAX_ANCHOR_SAMPLES\0" /* 26213 */
	"PS_ITER_SAMPLES\0" /* 26232 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 26248 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 26272 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 26298 */
	"INCOHERENT_EQAA_READS\0" /* 26325 */
	"INTERPOLATE_COMP_Z\0" /* 26347 */
	"INTERPOLATE_SRC_Z\0" /* 26366 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 26384 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 26411 */
	"OVERRASTERIZATION_AMOUNT\0" /* 26438 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 26463 */
	"DISABLE_DUAL_QUAD\0" /* 26494 */
	"DEGAMMA_ENABLE\0" /* 26512 */
	"CB_DISABLE\0" /* 26527 */
	"CB_NORMAL\0" /* 26538 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 26561, 26548 */
	"CB_RESOLVE\0" /* 26572 */
	"CB_FMASK_DECOMPRESS\0" /* 26583 */
	"CB_DCC_DECOMPRESS\0" /* 26603 */
	"X_0X00\0" /* 26621 */
	"X_0X05\0" /* 26628 */
	"X_0X0A\0" /* 26635 */
	"X_0X0F\0" /* 26642 */
	"X_0X11\0" /* 26649 */
	"X_0X22\0" /* 26656 */
	"X_0X33\0" /* 26663 */
	"X_0X44\0" /* 26670 */
	"X_0X50\0" /* 26677 */
	"X_0X55\0" /* 26684 */
	"X_0X5A\0" /* 26691 */
	"X_0X5F\0" /* 26698 */
	"X_0X66\0" /* 26705 */
	"X_0X77\0" /* 26712 */
	"X_0X88\0" /* 26719 */
	"X_0X99\0" /* 26726 */
	"X_0XA0\0" /* 26733 */
	"X_0XA5\0" /* 26740 */
	"X_0XAA\0" /* 26747 */
	"X_0XAF\0" /* 26754 */
	"X_0XBB\0" /* 26761 */
	"X_0XCC\0" /* 26768 */
	"X_0XDD\0" /* 26775 */
	"X_0XEE\0" /* 26782 */
	"X_0XF0\0" /* 26789 */
	"X_0XF5\0" /* 26796 */
	"X_0XFA\0" /* 26803 */
	"X_0XFF\0" /* 26810 */
	"Z_EXPORT_ENABLE\0" /* 26817 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 26833 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 26864 */
	"LATE_Z\0" /* 26893 */
	"EARLY_Z_THEN_LATE_Z\0" /* 26900 */
	"RE_Z\0" /* 26920 */
	"EARLY_Z_THEN_RE_Z\0" /* 26925 */
	"KILL_ENABLE\0" /* 26943 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 26955 */
	"MASK_EXPORT_ENABLE\0" /* 26979 */
	"EXEC_ON_HIER_FAIL\0" /* 26998 */
	"EXEC_ON_NOOP\0" /* 27016 */
	"ALPHA_TO_MASK_DISABLE\0" /* 27029 */
	"DEPTH_BEFORE_SHADER\0" /* 27051 */
	"EXPORT_ANY_Z\0" /* 27071 */
	"EXPORT_LESS_THAN_Z\0" /* 27084 */
	"EXPORT_GREATER_THAN_Z\0" /* 27103 */
	"EXPORT_RESERVED\0" /* 27125 */
	"CONSERVATIVE_Z_EXPORT\0" /* 27141 */
	"DUAL_QUAD_DISABLE\0" /* 27163 */
	"UCP_ENA_0\0" /* 27181 */
	"UCP_ENA_1\0" /* 27191 */
	"UCP_ENA_2\0" /* 27201 */
	"UCP_ENA_3\0" /* 27211 */
	"UCP_ENA_4\0" /* 27221 */
	"UCP_ENA_5\0" /* 27231 */
	"PS_UCP_Y_SCALE_NEG\0" /* 27241 */
	"PS_UCP_MODE\0" /* 27260 */
	"CLIP_DISABLE\0" /* 27272 */
	"UCP_CULL_ONLY_ENA\0" /* 27285 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 27303 */
	"DX_CLIP_SPACE_DEF\0" /* 27326 */
	"DIS_CLIP_ERR_DETECT\0" /* 27344 */
	"VTX_KILL_OR\0" /* 27364 */
	"DX_RASTERIZATION_KILL\0" /* 27376 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 27398 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 27422 */
	"ZCLIP_NEAR_DISABLE\0" /* 27448 */
	"ZCLIP_FAR_DISABLE\0" /* 27467 */
	"CULL_FRONT\0" /* 27485 */
	"CULL_BACK\0" /* 27496 */
	"FACE\0" /* 27506 */
	"X_DISABLE_POLY_MODE\0" /* 27521, 27511 */
	"X_DUAL_MODE\0" /* 27531 */
	"X_DRAW_POINTS\0" /* 27543 */
	"X_DRAW_LINES\0" /* 27557 */
	"X_DRAW_TRIANGLES\0" /* 27570 */
	"POLYMODE_FRONT_PTYPE\0" /* 27587 */
	"POLYMODE_BACK_PTYPE\0" /* 27608 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 27628 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 27653 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 27677 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 27701 */
	"PROVOKING_VTX_LAST\0" /* 27726 */
	"PERSP_CORR_DIS\0" /* 27745 */
	"MULTI_PRIM_IB_ENA\0" /* 27760 */
	"VPORT_X_SCALE_ENA\0" /* 27778 */
	"VPORT_X_OFFSET_ENA\0" /* 27796 */
	"VPORT_Y_SCALE_ENA\0" /* 27815 */
	"VPORT_Y_OFFSET_ENA\0" /* 27833 */
	"VPORT_Z_SCALE_ENA\0" /* 27852 */
	"VPORT_Z_OFFSET_ENA\0" /* 27870 */
	"VTX_XY_FMT\0" /* 27889 */
	"VTX_Z_FMT\0" /* 27900 */
	"VTX_W0_FMT\0" /* 27910 */
	"CLIP_DIST_ENA_0\0" /* 27921 */
	"CLIP_DIST_ENA_1\0" /* 27937 */
	"CLIP_DIST_ENA_2\0" /* 27953 */
	"CLIP_DIST_ENA_3\0" /* 27969 */
	"CLIP_DIST_ENA_4\0" /* 27985 */
	"CLIP_DIST_ENA_5\0" /* 28001 */
	"CLIP_DIST_ENA_6\0" /* 28017 */
	"CLIP_DIST_ENA_7\0" /* 28033 */
	"CULL_DIST_ENA_0\0" /* 28049 */
	"CULL_DIST_ENA_1\0" /* 28065 */
	"CULL_DIST_ENA_2\0" /* 28081 */
	"CULL_DIST_ENA_3\0" /* 28097 */
	"CULL_DIST_ENA_4\0" /* 28113 */
	"CULL_DIST_ENA_5\0" /* 28129 */
	"CULL_DIST_ENA_6\0" /* 28145 */
	"CULL_DIST_ENA_7\0" /* 28161 */
	"USE_VTX_POINT_SIZE\0" /* 28177 */
	"USE_VTX_EDGE_FLAG\0" /* 28196 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 28214 */
	"USE_VTX_VIEWPORT_INDX\0" /* 28241 */
	"USE_VTX_KILL_FLAG\0" /* 28263 */
	"VS_OUT_MISC_VEC_ENA\0" /* 28281 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 28301 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 28324 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 28347 */
	"USE_VTX_GS_CUT_FLAG\0" /* 28372 */
	"USE_VTX_LINE_WIDTH\0" /* 28392 */
	"VTE_XY_INF_DISCARD\0" /* 28411 */
	"VTE_Z_INF_DISCARD\0" /* 28430 */
	"VTE_W_INF_DISCARD\0" /* 28448 */
	"VTE_0XNANINF_IS_0\0" /* 28466 */
	"VTE_XY_NAN_RETAIN\0" /* 28484 */
	"VTE_Z_NAN_RETAIN\0" /* 28502 */
	"VTE_W_NAN_RETAIN\0" /* 28519 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 28536 */
	"VS_XY_NAN_TO_INF\0" /* 28557 */
	"VS_XY_INF_RETAIN\0" /* 28574 */
	"VS_Z_NAN_TO_INF\0" /* 28591 */
	"VS_Z_INF_RETAIN\0" /* 28607 */
	"VS_W_NAN_TO_INF\0" /* 28623 */
	"VS_W_INF_RETAIN\0" /* 28639 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 28655 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 28680 */
	"LINE_STIPPLE_RESET\0" /* 28700 */
	"EXPAND_FULL_LENGTH\0" /* 28719 */
	"FRACTIONAL_ACCUM\0" /* 28738 */
	"DIAMOND_ADJUST\0" /* 28755 */
	"TRIANGLE_FILTER_DISABLE\0" /* 28770 */
	"LINE_FILTER_DISABLE\0" /* 28794 */
	"POINT_FILTER_DISABLE\0" /* 28814 */
	"RECTANGLE_FILTER_DISABLE\0" /* 28835 */
	"TRIANGLE_EXPAND_ENA\0" /* 28860 */
	"LINE_EXPAND_ENA\0" /* 28880 */
	"POINT_EXPAND_ENA\0" /* 28896 */
	"RECTANGLE_EXPAND_ENA\0" /* 28913 */
	"PRIM_EXPAND_CONSTANT\0" /* 28934 */
	"XMAX_RIGHT_EXCLUSION\0" /* 28955 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 28976 */
	"MIN_SIZE\0" /* 28998 */
	"MAX_SIZE\0" /* 29007 */
	"LINE_PATTERN\0" /* 29016 */
	"REPEAT_COUNT\0" /* 29029 */
	"PATTERN_BIT_ORDER\0" /* 29042 */
	"AUTO_RESET_CNTL\0" /* 29060 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 29076 */
	"VGT_OUTPATH_TESS_EN\0" /* 29098 */
	"VGT_OUTPATH_PASSTHRU\0" /* 29118 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 29139 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 29160 */
	"PATH_SELECT\0" /* 29181 */
	"TESS_MODE\0" /* 29193 */
	"REUSE_DEPTH\0" /* 29203 */
	"VGT_GRP_3D_POINT\0" /* 29215 */
	"VGT_GRP_3D_LINE\0" /* 29232 */
	"VGT_GRP_3D_TRI\0" /* 29248 */
	"VGT_GRP_3D_RECT\0" /* 29263 */
	"VGT_GRP_3D_QUAD\0" /* 29279 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 29295 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 29319 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 29343 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 29367 */
	"VGT_GRP_2D_FILL_RECT\0" /* 29391 */
	"VGT_GRP_2D_LINE\0" /* 29412 */
	"VGT_GRP_2D_TRI\0" /* 29428 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 29443 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 29467 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 29490 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 29514 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 29534 */
	"VGT_GRP_3D_PATCH\0" /* 29553 */
	"RETAIN_ORDER\0" /* 29570 */
	"RETAIN_QUADS\0" /* 29583 */
	"VGT_GRP_LIST\0" /* 29596 */
	"VGT_GRP_STRIP\0" /* 29609 */
	"VGT_GRP_FAN\0" /* 29623 */
	"VGT_GRP_LOOP\0" /* 29635 */
	"VGT_GRP_POLYGON\0" /* 29648 */
	"PRIM_ORDER\0" /* 29664 */
	"FIRST_DECR\0" /* 29681, 29675 */
	"COMP_X_EN\0" /* 29686 */
	"COMP_Y_EN\0" /* 29696 */
	"COMP_Z_EN\0" /* 29706 */
	"COMP_W_EN\0" /* 29716 */
	"SHIFT\0" /* 29726 */
	"VGT_GRP_INDEX_16\0" /* 29732 */
	"VGT_GRP_INDEX_32\0" /* 29749 */
	"VGT_GRP_UINT_16\0" /* 29766 */
	"VGT_GRP_UINT_32\0" /* 29782 */
	"VGT_GRP_SINT_16\0" /* 29798 */
	"VGT_GRP_SINT_32\0" /* 29814 */
	"VGT_GRP_FLOAT_32\0" /* 29830 */
	"VGT_GRP_AUTO_PRIM\0" /* 29847 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 29865 */
	"X_CONV\0" /* 29891 */
	"Y_CONV\0" /* 29898 */
	"Z_CONV\0" /* 29905 */
	"Z_OFFSET\0" /* 29912 */
	"W_CONV\0" /* 29921 */
	"W_OFFSET\0" /* 29928 */
	"GS_OFF\0" /* 29937 */
	"GS_SCENARIO_A\0" /* 29944 */
	"GS_SCENARIO_B\0" /* 29958 */
	"GS_SCENARIO_G\0" /* 29972 */
	"GS_SCENARIO_C\0" /* 29986 */
	"SPRITE_EN\0" /* 30000 */
	"GS_CUT_1024\0" /* 30010 */
	"GS_CUT_512\0" /* 30022 */
	"GS_CUT_256\0" /* 30033 */
	"GS_CUT_128\0" /* 30044 */
	"CUT_MODE\0" /* 30055 */
	"GS_C_PACK_EN\0" /* 30064 */
	"RESERVED_2\0" /* 30077 */
	"ES_PASSTHRU\0" /* 30088 */
	"COMPUTE_MODE\0" /* 30100 */
	"FAST_COMPUTE_MODE\0" /* 30113 */
	"ELEMENT_INFO_EN\0" /* 30131 */
	"PARTIAL_THD_AT_EOI\0" /* 30147 */
	"SUPPRESS_CUTS\0" /* 30166 */
	"ES_WRITE_OPTIMIZE\0" /* 30180 */
	"GS_WRITE_OPTIMIZE\0" /* 30198 */
	"X_0_OFFCHIP_GS\0" /* 30216 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 30249, 30231 */
	"ES_VERTS_PER_SUBGRP\0" /* 30256 */
	"GS_PRIMS_PER_SUBGRP\0" /* 30276 */
	"MSAA_ENABLE\0" /* 30296 */
	"VPORT_SCISSOR_ENABLE\0" /* 30308 */
	"LINE_STIPPLE_ENABLE\0" /* 30329 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 30349 */
	"WALK_SIZE\0" /* 30374 */
	"WALK_ALIGNMENT\0" /* 30384 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 30399 */
	"WALK_FENCE_ENABLE\0" /* 30424 */
	"WALK_FENCE_SIZE\0" /* 30442 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 30458, 30463 */
	"TILE_COVER_DISABLE\0" /* 30486 */
	"TILE_COVER_NO_SCISSOR\0" /* 30505 */
	"ZMM_LINE_EXTENT\0" /* 30527 */
	"ZMM_LINE_OFFSET\0" /* 30543 */
	"ZMM_RECT_EXTENT\0" /* 30559 */
	"KILL_PIX_POST_HI_Z\0" /* 30575 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 30594 */
	"PS_ITER_SAMPLE\0" /* 30620 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 30635 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 30675 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 30702 */
	"GPU_ID_OVERRIDE\0" /* 30725 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 30741 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 30771 */
	"FORCE_EOV_REZ_ENABLE\0" /* 30795 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 30816 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 30846 */
	"GS_PER_ES\0" /* 30870 */
	"ES_PER_GS\0" /* 30880 */
	"GS_PER_VS\0" /* 30890 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 30900 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 30923 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 30946 */
	"OUTPRIM_TYPE\0" /* 30968 */
	"OUTPRIM_TYPE_1\0" /* 30981 */
	"OUTPRIM_TYPE_2\0" /* 30996 */
	"OUTPRIM_TYPE_3\0" /* 31011 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 31026 */
	"VGT_INDEX_16\0" /* 31049 */
	"VGT_INDEX_32\0" /* 31062 */
	"VGT_INDEX_8\0" /* 31075 */
	"VGT_DMA_SWAP_NONE\0" /* 31087 */
	"VGT_DMA_SWAP_16_BIT\0" /* 31105 */
	"VGT_DMA_SWAP_32_BIT\0" /* 31125 */
	"VGT_DMA_SWAP_WORD\0" /* 31145 */
	"SWAP_MODE\0" /* 31163 */
	"VGT_DMA_BUF_MEM\0" /* 31173 */
	"VGT_DMA_BUF_RING\0" /* 31189 */
	"VGT_DMA_BUF_SETUP\0" /* 31206 */
	"BUF_TYPE\0" /* 31224 */
	"VGT_POLICY_LRU\0" /* 31233 */
	"VGT_POLICY_STREAM\0" /* 31248 */
	"RDREQ_POLICY\0" /* 31266 */
	"RDREQ_POLICY_VI\0" /* 31279 */
	"REQ_PATH\0" /* 31295 */
	"PRIMITIVEID_EN\0" /* 31304 */
	"DISABLE_RESET_ON_EOI\0" /* 31319 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 31340 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 31363 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 31386 */
	"CACHE_FLUSH_TS\0" /* 31409 */
	"CONTEXT_DONE\0" /* 31424 */
	"CACHE_FLUSH\0" /* 31437 */
	"CS_PARTIAL_FLUSH\0" /* 31449 */
	"VGT_STREAMOUT_SYNC\0" /* 31466 */
	"VGT_STREAMOUT_RESET\0" /* 31485 */
	"END_OF_PIPE_INCR_DE\0" /* 31505 */
	"END_OF_PIPE_IB_END\0" /* 31525 */
	"RST_PIX_CNT\0" /* 31544 */
	"VS_PARTIAL_FLUSH\0" /* 31556 */
	"PS_PARTIAL_FLUSH\0" /* 31573 */
	"FLUSH_HS_OUTPUT\0" /* 31590 */
	"FLUSH_LS_OUTPUT\0" /* 31606 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 31622 */
	"ZPASS_DONE\0" /* 31651 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 31662 */
	"PERFCOUNTER_START\0" /* 31688 */
	"PERFCOUNTER_STOP\0" /* 31706 */
	"PIPELINESTAT_START\0" /* 31723 */
	"PIPELINESTAT_STOP\0" /* 31742 */
	"PERFCOUNTER_SAMPLE\0" /* 31760 */
	"FLUSH_ES_OUTPUT\0" /* 31779 */
	"FLUSH_GS_OUTPUT\0" /* 31795 */
	"SAMPLE_PIPELINESTAT\0" /* 31811 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 31831 */
	"SAMPLE_STREAMOUTSTATS\0" /* 31853 */
	"RESET_VTX_CNT\0" /* 31875 */
	"BLOCK_CONTEXT_DONE\0" /* 31889 */
	"CS_CONTEXT_DONE\0" /* 31908 */
	"VGT_FLUSH\0" /* 31924 */
	"SC_SEND_DB_VPZ\0" /* 31934 */
	"BOTTOM_OF_PIPE_TS\0" /* 31949 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 31967 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 31990 */
	"FLUSH_AND_INV_DB_META\0" /* 32015 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 32037 */
	"FLUSH_AND_INV_CB_META\0" /* 32062 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 32084 */
	"THREAD_TRACE_START\0" /* 32112 */
	"THREAD_TRACE_STOP\0" /* 32131 */
	"THREAD_TRACE_MARKER\0" /* 32149 */
	"THREAD_TRACE_FLUSH\0" /* 32169 */
	"THREAD_TRACE_FINISH\0" /* 32188 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 32208 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 32232 */
	"PIXEL_PIPE_STAT_RESET\0" /* 32253 */
	"EVENT_TYPE\0" /* 32275 */
	"EXTENDED_EVENT\0" /* 32286 */
	"RESET_EN\0" /* 32301 */
	"PRIMGROUP_SIZE\0" /* 32310 */
	"PARTIAL_VS_WAVE_ON\0" /* 32325 */
	"SWITCH_ON_EOP\0" /* 32344 */
	"PARTIAL_ES_WAVE_ON\0" /* 32358 */
	"SWITCH_ON_EOI\0" /* 32377 */
	"WD_SWITCH_ON_EOP\0" /* 32391 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 32408 */
	"ITEMSIZE\0" /* 32428 */
	"REUSE_OFF\0" /* 32437 */
	"VTX_CNT_EN\0" /* 32447 */
	"FULL_CACHE\0" /* 32458 */
	"HTILE_USES_PRELOAD_WIN\0" /* 32469 */
	"PRELOAD\0" /* 32492 */
	"PREFETCH_WIDTH\0" /* 32500 */
	"PREFETCH_HEIGHT\0" /* 32515 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 32531 */
	"TC_COMPATIBLE\0" /* 32555 */
	"COMPAREFUNC0\0" /* 32569 */
	"COMPAREVALUE0\0" /* 32582 */
	"COMPAREMASK0\0" /* 32596 */
	"COMPAREFUNC1\0" /* 32609 */
	"COMPAREVALUE1\0" /* 32622 */
	"COMPAREMASK1\0" /* 32636 */
	"START_X\0" /* 32649 */
	"START_Y\0" /* 32657 */
	"MAX_X\0" /* 32665 */
	"MAX_Y\0" /* 32671 */
	"VERTEX_STRIDE\0" /* 32677 */
	"MAX_VERT_OUT\0" /* 32691 */
	"ACCUM_ISOLINE\0" /* 32704 */
	"ACCUM_TRI\0" /* 32718 */
	"ACCUM_QUAD\0" /* 32728 */
	"DONUT_SPLIT\0" /* 32739 */
	"LS_STAGE_OFF\0" /* 32751 */
	"LS_STAGE_ON\0" /* 32764 */
	"CS_STAGE_ON\0" /* 32776 */
	"ES_STAGE_OFF\0" /* 32788 */
	"ES_STAGE_DS\0" /* 32801 */
	"ES_STAGE_REAL\0" /* 32813 */
	"VS_STAGE_REAL\0" /* 32827 */
	"VS_STAGE_DS\0" /* 32841 */
	"VS_STAGE_COPY_SHADER\0" /* 32853 */
	"DYNAMIC_HS\0" /* 32874 */
	"DIS_DEALLOC_ACCUM_0\0" /* 32885 */
	"DIS_DEALLOC_ACCUM_1\0" /* 32905 */
	"VS_WAVE_ID_EN\0" /* 32925 */
	"NUM_PATCHES\0" /* 32939 */
	"HS_NUM_INPUT_CP\0" /* 32951 */
	"HS_NUM_OUTPUT_CP\0" /* 32967 */
	"TESS_ISOLINE\0" /* 32984 */
	"TESS_TRIANGLE\0" /* 32997 */
	"TESS_QUAD\0" /* 33011 */
	"PART_INTEGER\0" /* 33021 */
	"PART_POW2\0" /* 33034 */
	"PART_FRAC_ODD\0" /* 33044 */
	"PART_FRAC_EVEN\0" /* 33058 */
	"PARTITIONING\0" /* 33073 */
	"OUTPUT_POINT\0" /* 33086 */
	"OUTPUT_LINE\0" /* 33099 */
	"OUTPUT_TRIANGLE_CW\0" /* 33111 */
	"OUTPUT_TRIANGLE_CCW\0" /* 33130 */
	"TOPOLOGY\0" /* 33150 */
	"RESERVED_REDUC_AXIS\0" /* 33159 */
	"DEPRECATED\0" /* 33179 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 33190 */
	"DISABLE_DONUTS\0" /* 33212 */
	"VGT_POLICY_BYPASS\0" /* 33227 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 33245 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 33271 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 33297 */
	"DISTRIBUTION_MODE\0" /* 33322 */
	"ALPHA_TO_MASK_ENABLE\0" /* 33340 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 33361 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 33383 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 33405 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 33427 */
	"OFFSET_ROUND\0" /* 33449 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 33462 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 33490 */
	"STREAMOUT_0_EN\0" /* 33518 */
	"STREAMOUT_1_EN\0" /* 33533 */
	"STREAMOUT_2_EN\0" /* 33548 */
	"STREAMOUT_3_EN\0" /* 33563 */
	"RAST_STREAM\0" /* 33578 */
	"RAST_STREAM_MASK\0" /* 33590 */
	"USE_RAST_STREAM_MASK\0" /* 33607 */
	"STREAM_0_BUFFER_EN\0" /* 33628 */
	"STREAM_1_BUFFER_EN\0" /* 33647 */
	"STREAM_2_BUFFER_EN\0" /* 33666 */
	"STREAM_3_BUFFER_EN\0" /* 33685 */
	"DISTANCE_0\0" /* 33704 */
	"DISTANCE_1\0" /* 33715 */
	"DISTANCE_2\0" /* 33726 */
	"DISTANCE_3\0" /* 33737 */
	"DISTANCE_4\0" /* 33748 */
	"DISTANCE_5\0" /* 33759 */
	"DISTANCE_6\0" /* 33770 */
	"DISTANCE_7\0" /* 33781 */
	"DISTANCE_8\0" /* 33792 */
	"DISTANCE_9\0" /* 33803 */
	"DISTANCE_10\0" /* 33814 */
	"DISTANCE_11\0" /* 33826 */
	"DISTANCE_12\0" /* 33838 */
	"DISTANCE_13\0" /* 33850 */
	"DISTANCE_14\0" /* 33862 */
	"DISTANCE_15\0" /* 33874 */
	"EXPAND_LINE_WIDTH\0" /* 33886 */
	"LAST_PIXEL\0" /* 33904 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 33915 */
	"DX10_DIAMOND_TEST_ENA\0" /* 33940 */
	"MSAA_NUM_SAMPLES\0" /* 33962 */
	"AA_MASK_CENTROID_DTMN\0" /* 33979 */
	"MAX_SAMPLE_DIST\0" /* 34001 */
	"MSAA_EXPOSED_SAMPLES\0" /* 34017 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 34038 */
	"PIX_CENTER\0" /* 34061 */
	"X_TRUNCATE\0" /* 34072 */
	"X_ROUND\0" /* 34083 */
	"X_ROUND_TO_EVEN\0" /* 34091 */
	"X_ROUND_TO_ODD\0" /* 34107 */
	"ROUND_MODE\0" /* 34122 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 34133 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 34159 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 34184 */
	"X_16_8_FIXED_POINT_1_2\0" /* 34209 */
	"X_16_8_FIXED_POINT_1\0" /* 34232 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 34253 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 34280 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 34309 */
	"QUANT_MODE\0" /* 34338 */
	"S0_X\0" /* 34349 */
	"S0_Y\0" /* 34354 */
	"S1_X\0" /* 34359 */
	"S1_Y\0" /* 34364 */
	"S2_X\0" /* 34369 */
	"S2_Y\0" /* 34374 */
	"S3_X\0" /* 34379 */
	"S3_Y\0" /* 34384 */
	"S4_X\0" /* 34389 */
	"S4_Y\0" /* 34394 */
	"S5_X\0" /* 34399 */
	"S5_Y\0" /* 34404 */
	"S6_X\0" /* 34409 */
	"S6_Y\0" /* 34414 */
	"S7_X\0" /* 34419 */
	"S7_Y\0" /* 34424 */
	"S8_X\0" /* 34429 */
	"S8_Y\0" /* 34434 */
	"S9_X\0" /* 34439 */
	"S9_Y\0" /* 34444 */
	"S10_X\0" /* 34449 */
	"S10_Y\0" /* 34455 */
	"S11_X\0" /* 34461 */
	"S11_Y\0" /* 34467 */
	"S12_X\0" /* 34473 */
	"S12_Y\0" /* 34479 */
	"S13_X\0" /* 34485 */
	"S13_Y\0" /* 34491 */
	"S14_X\0" /* 34497 */
	"S14_Y\0" /* 34503 */
	"S15_X\0" /* 34509 */
	"S15_Y\0" /* 34515 */
	"AA_MASK_X0Y0\0" /* 34521 */
	"AA_MASK_X1Y0\0" /* 34534 */
	"AA_MASK_X0Y1\0" /* 34547 */
	"AA_MASK_X1Y1\0" /* 34560 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 34573 */
	"VTX_REUSE_DEPTH\0" /* 34602 */
	"DEALLOC_DIST\0" /* 34618 */
	"FMASK_TILE_MAX\0" /* 34631 */
	"ENDIAN_NONE\0" /* 34646 */
	"ENDIAN_8IN16\0" /* 34658 */
	"ENDIAN_8IN32\0" /* 34671 */
	"ENDIAN_8IN64\0" /* 34684 */
	"ENDIAN\0" /* 34697 */
	"COLOR_INVALID\0" /* 34704 */
	"COLOR_8\0" /* 34718 */
	"COLOR_16\0" /* 34726 */
	"COLOR_8_8\0" /* 34735 */
	"COLOR_32\0" /* 34745 */
	"COLOR_16_16\0" /* 34754 */
	"COLOR_10_11_11\0" /* 34766 */
	"COLOR_11_11_10\0" /* 34781 */
	"COLOR_10_10_10_2\0" /* 34796 */
	"COLOR_2_10_10_10\0" /* 34813 */
	"COLOR_8_8_8_8\0" /* 34830 */
	"COLOR_32_32\0" /* 34844 */
	"COLOR_16_16_16_16\0" /* 34856 */
	"COLOR_32_32_32_32\0" /* 34874 */
	"COLOR_5_6_5\0" /* 34892 */
	"COLOR_1_5_5_5\0" /* 34904 */
	"COLOR_5_5_5_1\0" /* 34918 */
	"COLOR_4_4_4_4\0" /* 34932 */
	"COLOR_8_24\0" /* 34946 */
	"COLOR_24_8\0" /* 34957 */
	"COLOR_X24_8_32_FLOAT\0" /* 34968 */
	"NUMBER_UNORM\0" /* 34989 */
	"NUMBER_SNORM\0" /* 35002 */
	"NUMBER_UINT\0" /* 35015 */
	"NUMBER_SINT\0" /* 35027 */
	"NUMBER_SRGB\0" /* 35039 */
	"NUMBER_FLOAT\0" /* 35051 */
	"NUMBER_TYPE\0" /* 35064 */
	"SWAP_STD\0" /* 35076 */
	"SWAP_ALT\0" /* 35085 */
	"SWAP_STD_REV\0" /* 35094 */
	"SWAP_ALT_REV\0" /* 35107 */
	"COMP_SWAP\0" /* 35120 */
	"BLEND_CLAMP\0" /* 35130 */
	"BLEND_BYPASS\0" /* 35142 */
	"SIMPLE_FLOAT\0" /* 35155 */
	"CMASK_IS_LINEAR\0" /* 35168 */
	"FORCE_OPT_AUTO\0" /* 35184 */
	"FORCE_OPT_DISABLE\0" /* 35199 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 35217 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 35245 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 35275 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 35306 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 35334 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 35364 */
	"BLEND_OPT_DONT_RD_DST\0" /* 35395 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 35417 */
	"FMASK_COMPRESSION_DISABLE\0" /* 35441 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 35467 */
	"DCC_ENABLE\0" /* 35493 */
	"CMASK_ADDR_TYPE\0" /* 35504 */
	"FMASK_TILE_MODE_INDEX\0" /* 35520 */
	"FMASK_BANK_HEIGHT\0" /* 35542 */
	"NUM_FRAGMENTS\0" /* 35560 */
	"FORCE_DST_ALPHA_1\0" /* 35574 */
	"KEY_CLEAR_ENABLE\0" /* 35592 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 35609 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 35637 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 35663 */
	"INDEPENDENT_64B_BLOCKS\0" /* 35689 */
	"LOSSY_RGB_PRECISION\0" /* 35712 */
	"LOSSY_ALPHA_PRECISION\0" /* 35732 */
	"CP_DMA_WORD0\0" /* 35754 */
	"CP_DMA_WORD1\0" /* 35767 */
	"CP_DMA_WORD2\0" /* 35780 */
	"CP_DMA_WORD3\0" /* 35793 */
	"COMMAND\0" /* 35806 */
	"DMA_DATA_WORD0\0" /* 35814 */
	"SRBM_STATUS2\0" /* 35829 */
	"SRBM_STATUS\0" /* 35842 */
	"SRBM_STATUS3\0" /* 35854 */
	"SDMA0_STATUS_REG\0" /* 35867 */
	"SDMA1_STATUS_REG\0" /* 35884 */
	"GRBM_STATUS2\0" /* 35901 */
	"GRBM_STATUS\0" /* 35914 */
	"CP_STRMOUT_CNTL\0" /* 35926 */
	"CP_COHER_CNTL\0" /* 35942 */
	"CP_COHER_SIZE\0" /* 35956 */
	"CP_COHER_BASE\0" /* 35970 */
	"GRBM_STATUS_SE0\0" /* 35984 */
	"GRBM_STATUS_SE1\0" /* 36000 */
	"GRBM_STATUS_SE2\0" /* 36016 */
	"GRBM_STATUS_SE3\0" /* 36032 */
	"CP_COHER_BASE_HI\0" /* 36048 */
	"CP_COHER_START_DELAY\0" /* 36065 */
	"CP_COHER_STATUS\0" /* 36086 */
	"CP_CPC_STATUS\0" /* 36102 */
	"CP_CPC_BUSY_STAT\0" /* 36116 */
	"CP_CPC_STALLED_STAT1\0" /* 36133 */
	"CP_CPF_STATUS\0" /* 36154 */
	"CP_CPF_BUSY_STAT\0" /* 36168 */
	"CP_CPF_STALLED_STAT1\0" /* 36185 */
	"CP_COHER_SIZE_HI\0" /* 36206 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 36223 */
	"VGT_CACHE_INVALIDATION\0" /* 36246 */
	"VGT_ESGS_RING_SIZE\0" /* 36269 */
	"VGT_GSVS_RING_SIZE\0" /* 36288 */
	"VGT_GS_VERTEX_REUSE\0" /* 36307 */
	"VGT_PRIMITIVE_TYPE\0" /* 36327 */
	"VGT_INDEX_TYPE\0" /* 36346 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 36361 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 36394 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 36427 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 36460 */
	"VGT_NUM_INDICES\0" /* 36493 */
	"VGT_NUM_INSTANCES\0" /* 36509 */
	"VGT_TF_RING_SIZE\0" /* 36527 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 36544 */
	"VGT_TF_MEMORY_BASE\0" /* 36565 */
	"PA_CL_ENHANCE\0" /* 36584 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 36598 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 36623 */
	"CP_STALLED_STAT3\0" /* 36648 */
	"CP_STALLED_STAT1\0" /* 36665 */
	"CP_STALLED_STAT2\0" /* 36682 */
	"CP_STAT\0" /* 36699 */
	"GRBM_GFX_INDEX\0" /* 36707 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 36722 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 36748 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 36774 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 36800 */
	"PA_SC_ENHANCE\0" /* 36826 */
	"SQC_CACHES\0" /* 36840 */
	"SQ_RANDOM_WAVE_PRI\0" /* 36851 */
	"SQ_EXP_0\0" /* 36870 */
	"TA_CS_BC_BASE_ADDR\0" /* 36879 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 36898 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 36920 */
	"SQ_BUF_RSRC_WORD0\0" /* 36944 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 36962 */
	"SQ_BUF_RSRC_WORD1\0" /* 36985 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 37003 */
	"SQ_BUF_RSRC_WORD2\0" /* 37027 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 37045 */
	"SQ_BUF_RSRC_WORD3\0" /* 37068 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 37086 */
	"SQ_IMG_RSRC_WORD0\0" /* 37110 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 37128 */
	"SQ_IMG_RSRC_WORD1\0" /* 37151 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 37169 */
	"SQ_IMG_RSRC_WORD2\0" /* 37193 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 37211 */
	"SQ_IMG_RSRC_WORD3\0" /* 37234 */
	"SQ_IMG_RSRC_WORD4\0" /* 37252 */
	"SQ_IMG_RSRC_WORD5\0" /* 37270 */
	"SQ_IMG_RSRC_WORD6\0" /* 37288 */
	"SQ_IMG_RSRC_WORD7\0" /* 37306 */
	"SQ_IMG_SAMP_WORD0\0" /* 37324 */
	"SQ_IMG_SAMP_WORD1\0" /* 37342 */
	"SQ_IMG_SAMP_WORD2\0" /* 37360 */
	"SQ_IMG_SAMP_WORD3\0" /* 37378 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 37396 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 37416 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 37441 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 37466 */
	"SPI_PS_MAX_WAVE_ID\0" /* 37491 */
	"SPI_ARB_PRIORITY\0" /* 37510 */
	"SPI_ARB_CYCLES_0\0" /* 37527 */
	"SPI_ARB_CYCLES_1\0" /* 37544 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 37561 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 37583 */
	"DB_ZPASS_COUNT_LOW\0" /* 37605 */
	"DB_ZPASS_COUNT_HI\0" /* 37624 */
	"SPI_CONFIG_CNTL\0" /* 37642 */
	"SPI_CONFIG_CNTL_1\0" /* 37658 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 37676 */
	"DB_SUBTILE_CONTROL\0" /* 37705 */
	"GB_ADDR_CONFIG\0" /* 37724 */
	"GB_TILE_MODE0\0" /* 37739 */
	"GB_TILE_MODE1\0" /* 37753 */
	"GB_TILE_MODE2\0" /* 37767 */
	"GB_TILE_MODE3\0" /* 37781 */
	"GB_TILE_MODE4\0" /* 37795 */
	"GB_TILE_MODE5\0" /* 37809 */
	"GB_TILE_MODE6\0" /* 37823 */
	"GB_TILE_MODE7\0" /* 37837 */
	"GB_TILE_MODE8\0" /* 37851 */
	"GB_TILE_MODE9\0" /* 37865 */
	"GB_TILE_MODE10\0" /* 37879 */
	"GB_TILE_MODE11\0" /* 37894 */
	"GB_TILE_MODE12\0" /* 37909 */
	"GB_TILE_MODE13\0" /* 37924 */
	"GB_TILE_MODE14\0" /* 37939 */
	"GB_TILE_MODE15\0" /* 37954 */
	"GB_TILE_MODE16\0" /* 37969 */
	"GB_TILE_MODE17\0" /* 37984 */
	"GB_TILE_MODE18\0" /* 37999 */
	"GB_TILE_MODE19\0" /* 38014 */
	"GB_TILE_MODE20\0" /* 38029 */
	"GB_TILE_MODE21\0" /* 38044 */
	"GB_TILE_MODE22\0" /* 38059 */
	"GB_TILE_MODE23\0" /* 38074 */
	"GB_TILE_MODE24\0" /* 38089 */
	"GB_TILE_MODE25\0" /* 38104 */
	"GB_TILE_MODE26\0" /* 38119 */
	"GB_TILE_MODE27\0" /* 38134 */
	"GB_TILE_MODE28\0" /* 38149 */
	"GB_TILE_MODE29\0" /* 38164 */
	"GB_TILE_MODE30\0" /* 38179 */
	"GB_TILE_MODE31\0" /* 38194 */
	"GB_MACROTILE_MODE0\0" /* 38209 */
	"GB_MACROTILE_MODE1\0" /* 38228 */
	"GB_MACROTILE_MODE2\0" /* 38247 */
	"GB_MACROTILE_MODE3\0" /* 38266 */
	"GB_MACROTILE_MODE4\0" /* 38285 */
	"GB_MACROTILE_MODE5\0" /* 38304 */
	"GB_MACROTILE_MODE6\0" /* 38323 */
	"GB_MACROTILE_MODE7\0" /* 38342 */
	"GB_MACROTILE_MODE8\0" /* 38361 */
	"GB_MACROTILE_MODE9\0" /* 38380 */
	"GB_MACROTILE_MODE10\0" /* 38399 */
	"GB_MACROTILE_MODE11\0" /* 38419 */
	"GB_MACROTILE_MODE12\0" /* 38439 */
	"GB_MACROTILE_MODE13\0" /* 38459 */
	"GB_MACROTILE_MODE14\0" /* 38479 */
	"GB_MACROTILE_MODE15\0" /* 38499 */
	"SPI_SHADER_TBA_LO_PS\0" /* 38519 */
	"SPI_SHADER_TBA_HI_PS\0" /* 38540 */
	"SPI_SHADER_TMA_LO_PS\0" /* 38561 */
	"SPI_SHADER_TMA_HI_PS\0" /* 38582 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 38603 */
	"SPI_SHADER_PGM_LO_PS\0" /* 38627 */
	"SPI_SHADER_PGM_HI_PS\0" /* 38648 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 38669 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 38693 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 38717 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 38743 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 38769 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 38795 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 38821 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 38847 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 38873 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 38899 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 38925 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 38951 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 38977 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 39004 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 39031 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 39058 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 39085 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 39112 */
	"SPI_SHADER_TBA_LO_VS\0" /* 39139 */
	"SPI_SHADER_TBA_HI_VS\0" /* 39160 */
	"SPI_SHADER_TMA_LO_VS\0" /* 39181 */
	"SPI_SHADER_TMA_HI_VS\0" /* 39202 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 39223 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 39247 */
	"SPI_SHADER_PGM_LO_VS\0" /* 39272 */
	"SPI_SHADER_PGM_HI_VS\0" /* 39293 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 39314 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 39338 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 39362 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 39388 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 39414 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 39440 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 39466 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 39492 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 39518 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 39544 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 39570 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 39596 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 39622 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 39649 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 39676 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 39703 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 39730 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 39757 */
	"SPI_SHADER_TBA_LO_GS\0" /* 39784 */
	"SPI_SHADER_TBA_HI_GS\0" /* 39805 */
	"SPI_SHADER_TMA_LO_GS\0" /* 39826 */
	"SPI_SHADER_TMA_HI_GS\0" /* 39847 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 39868 */
	"SPI_SHADER_PGM_LO_GS\0" /* 39892 */
	"SPI_SHADER_PGM_HI_GS\0" /* 39913 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 39934 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 39958 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 39982 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 40008 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 40034 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 40060 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 40086 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 40112 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 40138 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 40164 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 40190 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 40216 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 40242 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 40269 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 40296 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 40323 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 40350 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 40377 */
	"SPI_SHADER_TBA_LO_ES\0" /* 40404 */
	"SPI_SHADER_TBA_HI_ES\0" /* 40425 */
	"SPI_SHADER_TMA_LO_ES\0" /* 40446 */
	"SPI_SHADER_TMA_HI_ES\0" /* 40467 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 40488 */
	"SPI_SHADER_PGM_LO_ES\0" /* 40512 */
	"SPI_SHADER_PGM_HI_ES\0" /* 40533 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 40554 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 40578 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 40602 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 40628 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 40654 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 40680 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 40706 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 40732 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 40758 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 40784 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 40810 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 40836 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 40862 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 40889 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 40916 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 40943 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 40970 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 40997 */
	"SPI_SHADER_TBA_LO_HS\0" /* 41024 */
	"SPI_SHADER_TBA_HI_HS\0" /* 41045 */
	"SPI_SHADER_TMA_LO_HS\0" /* 41066 */
	"SPI_SHADER_TMA_HI_HS\0" /* 41087 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 41108 */
	"SPI_SHADER_PGM_LO_HS\0" /* 41132 */
	"SPI_SHADER_PGM_HI_HS\0" /* 41153 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 41174 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 41198 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 41222 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 41248 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 41274 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 41300 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 41326 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 41352 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 41378 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 41404 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 41430 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 41456 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 41482 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 41509 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 41536 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 41563 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 41590 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 41617 */
	"SPI_SHADER_TBA_LO_LS\0" /* 41644 */
	"SPI_SHADER_TBA_HI_LS\0" /* 41665 */
	"SPI_SHADER_TMA_LO_LS\0" /* 41686 */
	"SPI_SHADER_TMA_HI_LS\0" /* 41707 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 41728 */
	"SPI_SHADER_PGM_LO_LS\0" /* 41752 */
	"SPI_SHADER_PGM_HI_LS\0" /* 41773 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 41794 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 41818 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 41842 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 41868 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 41894 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 41920 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 41946 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 41972 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 41998 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 42024 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 42050 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 42076 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 42102 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 42129 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 42156 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 42183 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 42210 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 42237 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 42264 */
	"COMPUTE_DIM_X\0" /* 42291 */
	"COMPUTE_DIM_Y\0" /* 42305 */
	"COMPUTE_DIM_Z\0" /* 42319 */
	"COMPUTE_START_X\0" /* 42333 */
	"COMPUTE_START_Y\0" /* 42349 */
	"COMPUTE_START_Z\0" /* 42365 */
	"COMPUTE_NUM_THREAD_X\0" /* 42381 */
	"COMPUTE_NUM_THREAD_Y\0" /* 42402 */
	"COMPUTE_NUM_THREAD_Z\0" /* 42423 */
	"COMPUTE_MAX_WAVE_ID\0" /* 42444 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 42464 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 42492 */
	"COMPUTE_PGM_LO\0" /* 42517 */
	"COMPUTE_PGM_HI\0" /* 42532 */
	"COMPUTE_TBA_LO\0" /* 42547 */
	"COMPUTE_TBA_HI\0" /* 42562 */
	"COMPUTE_TMA_LO\0" /* 42577 */
	"COMPUTE_TMA_HI\0" /* 42592 */
	"COMPUTE_PGM_RSRC1\0" /* 42607 */
	"COMPUTE_PGM_RSRC2\0" /* 42625 */
	"COMPUTE_VMID\0" /* 42643 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 42656 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 42680 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 42711 */
	"COMPUTE_TMPRING_SIZE\0" /* 42742 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 42763 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 42794 */
	"COMPUTE_RESTART_X\0" /* 42825 */
	"COMPUTE_RESTART_Y\0" /* 42843 */
	"COMPUTE_RESTART_Z\0" /* 42861 */
	"COMPUTE_MISC_RESERVED\0" /* 42879 */
	"COMPUTE_DISPATCH_ID\0" /* 42901 */
	"COMPUTE_THREADGROUP_ID\0" /* 42921 */
	"COMPUTE_RELAUNCH\0" /* 42944 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 42961 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 42990 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 43019 */
	"COMPUTE_USER_DATA_0\0" /* 43048 */
	"COMPUTE_USER_DATA_1\0" /* 43068 */
	"COMPUTE_USER_DATA_2\0" /* 43088 */
	"COMPUTE_USER_DATA_3\0" /* 43108 */
	"COMPUTE_USER_DATA_4\0" /* 43128 */
	"COMPUTE_USER_DATA_5\0" /* 43148 */
	"COMPUTE_USER_DATA_6\0" /* 43168 */
	"COMPUTE_USER_DATA_7\0" /* 43188 */
	"COMPUTE_USER_DATA_8\0" /* 43208 */
	"COMPUTE_USER_DATA_9\0" /* 43228 */
	"COMPUTE_USER_DATA_10\0" /* 43248 */
	"COMPUTE_USER_DATA_11\0" /* 43269 */
	"COMPUTE_USER_DATA_12\0" /* 43290 */
	"COMPUTE_USER_DATA_13\0" /* 43311 */
	"COMPUTE_USER_DATA_14\0" /* 43332 */
	"COMPUTE_USER_DATA_15\0" /* 43353 */
	"COMPUTE_NOWHERE\0" /* 43374 */
	"CPG_PERFCOUNTER1_LO\0" /* 43390 */
	"CPG_PERFCOUNTER1_HI\0" /* 43410 */
	"CPG_PERFCOUNTER0_LO\0" /* 43430 */
	"CPG_PERFCOUNTER0_HI\0" /* 43450 */
	"CPC_PERFCOUNTER1_LO\0" /* 43470 */
	"CPC_PERFCOUNTER1_HI\0" /* 43490 */
	"CPC_PERFCOUNTER0_LO\0" /* 43510 */
	"CPC_PERFCOUNTER0_HI\0" /* 43530 */
	"CPF_PERFCOUNTER1_LO\0" /* 43550 */
	"CPF_PERFCOUNTER1_HI\0" /* 43570 */
	"CPF_PERFCOUNTER0_LO\0" /* 43590 */
	"CPF_PERFCOUNTER0_HI\0" /* 43610 */
	"GRBM_PERFCOUNTER0_LO\0" /* 43630 */
	"GRBM_PERFCOUNTER0_HI\0" /* 43651 */
	"GRBM_PERFCOUNTER1_LO\0" /* 43672 */
	"GRBM_PERFCOUNTER1_HI\0" /* 43693 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 43714 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 43738 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 43762 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 43786 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 43810 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 43834 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 43858 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 43882 */
	"WD_PERFCOUNTER0_LO\0" /* 43906 */
	"WD_PERFCOUNTER0_HI\0" /* 43925 */
	"WD_PERFCOUNTER1_LO\0" /* 43944 */
	"WD_PERFCOUNTER1_HI\0" /* 43963 */
	"WD_PERFCOUNTER2_LO\0" /* 43982 */
	"WD_PERFCOUNTER2_HI\0" /* 44001 */
	"WD_PERFCOUNTER3_LO\0" /* 44020 */
	"WD_PERFCOUNTER3_HI\0" /* 44039 */
	"IA_PERFCOUNTER0_LO\0" /* 44058 */
	"IA_PERFCOUNTER0_HI\0" /* 44077 */
	"IA_PERFCOUNTER1_LO\0" /* 44096 */
	"IA_PERFCOUNTER1_HI\0" /* 44115 */
	"IA_PERFCOUNTER2_LO\0" /* 44134 */
	"IA_PERFCOUNTER2_HI\0" /* 44153 */
	"IA_PERFCOUNTER3_LO\0" /* 44172 */
	"IA_PERFCOUNTER3_HI\0" /* 44191 */
	"VGT_PERFCOUNTER0_LO\0" /* 44210 */
	"VGT_PERFCOUNTER0_HI\0" /* 44230 */
	"VGT_PERFCOUNTER1_LO\0" /* 44250 */
	"VGT_PERFCOUNTER1_HI\0" /* 44270 */
	"VGT_PERFCOUNTER2_LO\0" /* 44290 */
	"VGT_PERFCOUNTER2_HI\0" /* 44310 */
	"VGT_PERFCOUNTER3_LO\0" /* 44330 */
	"VGT_PERFCOUNTER3_HI\0" /* 44350 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 44370 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 44392 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 44414 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 44436 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 44458 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 44480 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 44502 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 44524 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 44546 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 44568 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 44590 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 44612 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 44634 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 44656 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 44678 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 44700 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 44722 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 44744 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 44766 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 44788 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 44810 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 44832 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 44854 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 44876 */
	"SPI_PERFCOUNTER0_HI\0" /* 44898 */
	"SPI_PERFCOUNTER0_LO\0" /* 44918 */
	"SPI_PERFCOUNTER1_HI\0" /* 44938 */
	"SPI_PERFCOUNTER1_LO\0" /* 44958 */
	"SPI_PERFCOUNTER2_HI\0" /* 44978 */
	"SPI_PERFCOUNTER2_LO\0" /* 44998 */
	"SPI_PERFCOUNTER3_HI\0" /* 45018 */
	"SPI_PERFCOUNTER3_LO\0" /* 45038 */
	"SPI_PERFCOUNTER4_HI\0" /* 45058 */
	"SPI_PERFCOUNTER4_LO\0" /* 45078 */
	"SPI_PERFCOUNTER5_HI\0" /* 45098 */
	"SPI_PERFCOUNTER5_LO\0" /* 45118 */
	"SQ_PERFCOUNTER0_LO\0" /* 45138 */
	"SQ_PERFCOUNTER0_HI\0" /* 45157 */
	"SQ_PERFCOUNTER1_LO\0" /* 45176 */
	"SQ_PERFCOUNTER1_HI\0" /* 45195 */
	"SQ_PERFCOUNTER2_LO\0" /* 45214 */
	"SQ_PERFCOUNTER2_HI\0" /* 45233 */
	"SQ_PERFCOUNTER3_LO\0" /* 45252 */
	"SQ_PERFCOUNTER3_HI\0" /* 45271 */
	"SQ_PERFCOUNTER4_LO\0" /* 45290 */
	"SQ_PERFCOUNTER4_HI\0" /* 45309 */
	"SQ_PERFCOUNTER5_LO\0" /* 45328 */
	"SQ_PERFCOUNTER5_HI\0" /* 45347 */
	"SQ_PERFCOUNTER6_LO\0" /* 45366 */
	"SQ_PERFCOUNTER6_HI\0" /* 45385 */
	"SQ_PERFCOUNTER7_LO\0" /* 45404 */
	"SQ_PERFCOUNTER7_HI\0" /* 45423 */
	"SQ_PERFCOUNTER8_LO\0" /* 45442 */
	"SQ_PERFCOUNTER8_HI\0" /* 45461 */
	"SQ_PERFCOUNTER9_LO\0" /* 45480 */
	"SQ_PERFCOUNTER9_HI\0" /* 45499 */
	"SQ_PERFCOUNTER10_LO\0" /* 45518 */
	"SQ_PERFCOUNTER10_HI\0" /* 45538 */
	"SQ_PERFCOUNTER11_LO\0" /* 45558 */
	"SQ_PERFCOUNTER11_HI\0" /* 45578 */
	"SQ_PERFCOUNTER12_LO\0" /* 45598 */
	"SQ_PERFCOUNTER12_HI\0" /* 45618 */
	"SQ_PERFCOUNTER13_LO\0" /* 45638 */
	"SQ_PERFCOUNTER13_HI\0" /* 45658 */
	"SQ_PERFCOUNTER14_LO\0" /* 45678 */
	"SQ_PERFCOUNTER14_HI\0" /* 45698 */
	"SQ_PERFCOUNTER15_LO\0" /* 45718 */
	"SQ_PERFCOUNTER15_HI\0" /* 45738 */
	"SX_PERFCOUNTER0_LO\0" /* 45758 */
	"SX_PERFCOUNTER0_HI\0" /* 45777 */
	"SX_PERFCOUNTER1_LO\0" /* 45796 */
	"SX_PERFCOUNTER1_HI\0" /* 45815 */
	"SX_PERFCOUNTER2_LO\0" /* 45834 */
	"SX_PERFCOUNTER2_HI\0" /* 45853 */
	"SX_PERFCOUNTER3_LO\0" /* 45872 */
	"SX_PERFCOUNTER3_HI\0" /* 45891 */
	"GDS_PERFCOUNTER0_LO\0" /* 45910 */
	"GDS_PERFCOUNTER0_HI\0" /* 45930 */
	"GDS_PERFCOUNTER1_LO\0" /* 45950 */
	"GDS_PERFCOUNTER1_HI\0" /* 45970 */
	"GDS_PERFCOUNTER2_LO\0" /* 45990 */
	"GDS_PERFCOUNTER2_HI\0" /* 46010 */
	"GDS_PERFCOUNTER3_LO\0" /* 46030 */
	"GDS_PERFCOUNTER3_HI\0" /* 46050 */
	"TA_PERFCOUNTER0_LO\0" /* 46070 */
	"TA_PERFCOUNTER0_HI\0" /* 46089 */
	"TA_PERFCOUNTER1_LO\0" /* 46108 */
	"TA_PERFCOUNTER1_HI\0" /* 46127 */
	"TD_PERFCOUNTER0_LO\0" /* 46146 */
	"TD_PERFCOUNTER0_HI\0" /* 46165 */
	"TD_PERFCOUNTER1_LO\0" /* 46184 */
	"TD_PERFCOUNTER1_HI\0" /* 46203 */
	"TCP_PERFCOUNTER0_LO\0" /* 46222 */
	"TCP_PERFCOUNTER0_HI\0" /* 46242 */
	"TCP_PERFCOUNTER1_LO\0" /* 46262 */
	"TCP_PERFCOUNTER1_HI\0" /* 46282 */
	"TCP_PERFCOUNTER2_LO\0" /* 46302 */
	"TCP_PERFCOUNTER2_HI\0" /* 46322 */
	"TCP_PERFCOUNTER3_LO\0" /* 46342 */
	"TCP_PERFCOUNTER3_HI\0" /* 46362 */
	"TCC_PERFCOUNTER0_LO\0" /* 46382 */
	"TCC_PERFCOUNTER0_HI\0" /* 46402 */
	"TCC_PERFCOUNTER1_LO\0" /* 46422 */
	"TCC_PERFCOUNTER1_HI\0" /* 46442 */
	"TCC_PERFCOUNTER2_LO\0" /* 46462 */
	"TCC_PERFCOUNTER2_HI\0" /* 46482 */
	"TCC_PERFCOUNTER3_LO\0" /* 46502 */
	"TCC_PERFCOUNTER3_HI\0" /* 46522 */
	"TCA_PERFCOUNTER0_LO\0" /* 46542 */
	"TCA_PERFCOUNTER0_HI\0" /* 46562 */
	"TCA_PERFCOUNTER1_LO\0" /* 46582 */
	"TCA_PERFCOUNTER1_HI\0" /* 46602 */
	"TCA_PERFCOUNTER2_LO\0" /* 46622 */
	"TCA_PERFCOUNTER2_HI\0" /* 46642 */
	"TCA_PERFCOUNTER3_LO\0" /* 46662 */
	"TCA_PERFCOUNTER3_HI\0" /* 46682 */
	"CB_PERFCOUNTER0_LO\0" /* 46702 */
	"CB_PERFCOUNTER0_HI\0" /* 46721 */
	"CB_PERFCOUNTER1_LO\0" /* 46740 */
	"CB_PERFCOUNTER1_HI\0" /* 46759 */
	"CB_PERFCOUNTER2_LO\0" /* 46778 */
	"CB_PERFCOUNTER2_HI\0" /* 46797 */
	"CB_PERFCOUNTER3_LO\0" /* 46816 */
	"CB_PERFCOUNTER3_HI\0" /* 46835 */
	"DB_PERFCOUNTER0_LO\0" /* 46854 */
	"DB_PERFCOUNTER0_HI\0" /* 46873 */
	"DB_PERFCOUNTER1_LO\0" /* 46892 */
	"DB_PERFCOUNTER1_HI\0" /* 46911 */
	"DB_PERFCOUNTER2_LO\0" /* 46930 */
	"DB_PERFCOUNTER2_HI\0" /* 46949 */
	"DB_PERFCOUNTER3_LO\0" /* 46968 */
	"DB_PERFCOUNTER3_HI\0" /* 46987 */
	"RLC_PERFCOUNTER0_LO\0" /* 47006 */
	"RLC_PERFCOUNTER0_HI\0" /* 47026 */
	"RLC_PERFCOUNTER1_LO\0" /* 47046 */
	"RLC_PERFCOUNTER1_HI\0" /* 47066 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 47086 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 47110 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 47135 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 47159 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 47183 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 47208 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 47232 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 47257 */
	"CP_PERFMON_CNTL\0" /* 47281 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 47297 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 47321 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 47346 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 47371 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 47399 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 47427 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 47455 */
	"WD_PERFCOUNTER0_SELECT\0" /* 47483 */
	"WD_PERFCOUNTER1_SELECT\0" /* 47506 */
	"WD_PERFCOUNTER2_SELECT\0" /* 47529 */
	"WD_PERFCOUNTER3_SELECT\0" /* 47552 */
	"IA_PERFCOUNTER0_SELECT\0" /* 47575 */
	"IA_PERFCOUNTER1_SELECT\0" /* 47598 */
	"IA_PERFCOUNTER2_SELECT\0" /* 47621 */
	"IA_PERFCOUNTER3_SELECT\0" /* 47644 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 47667 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 47691 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 47715 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 47739 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 47763 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 47787 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 47812 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 47837 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 47863 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 47889 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 47916 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 47942 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 47969 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 47995 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 48021 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 48047 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 48074 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 48100 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 48126 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 48152 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 48178 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 48204 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 48230 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 48256 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 48280 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 48304 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 48328 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 48352 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 48377 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 48402 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 48427 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 48452 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 48476 */
	"SPI_PERFCOUNTER_BINS\0" /* 48500 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 48521 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 48544 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 48567 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 48590 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 48613 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 48636 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 48659 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 48682 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 48705 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 48728 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 48751 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 48775 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 48799 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 48823 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 48847 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 48871 */
	"SQ_PERFCOUNTER_CTRL\0" /* 48895 */
	"SQ_PERFCOUNTER_MASK\0" /* 48915 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 48935 */
	"SX_PERFCOUNTER0_SELECT\0" /* 48956 */
	"SX_PERFCOUNTER1_SELECT\0" /* 48979 */
	"SX_PERFCOUNTER2_SELECT\0" /* 49002 */
	"SX_PERFCOUNTER3_SELECT\0" /* 49025 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 49048 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 49072 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 49096 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 49120 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 49144 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 49168 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 49192 */
	"TA_PERFCOUNTER0_SELECT\0" /* 49217 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 49240 */
	"TA_PERFCOUNTER1_SELECT\0" /* 49264 */
	"TD_PERFCOUNTER0_SELECT\0" /* 49287 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 49310 */
	"TD_PERFCOUNTER1_SELECT\0" /* 49334 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 49357 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 49381 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 49406 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 49430 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 49455 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 49479 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 49503 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 49527 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 49552 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 49576 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 49601 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 49625 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 49649 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 49673 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 49698 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 49722 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 49747 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 49771 */
	"CB_PERFCOUNTER_FILTER\0" /* 49795 */
	"CB_PERFCOUNTER0_SELECT\0" /* 49817 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 49840 */
	"CB_PERFCOUNTER1_SELECT\0" /* 49864 */
	"CB_PERFCOUNTER2_SELECT\0" /* 49887 */
	"CB_PERFCOUNTER3_SELECT\0" /* 49910 */
	"DB_PERFCOUNTER0_SELECT\0" /* 49933 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 49956 */
	"DB_PERFCOUNTER1_SELECT\0" /* 49980 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 50003 */
	"DB_PERFCOUNTER2_SELECT\0" /* 50027 */
	"DB_PERFCOUNTER3_SELECT\0" /* 50050 */
	"DB_RENDER_CONTROL\0" /* 50073 */
	"DB_COUNT_CONTROL\0" /* 50091 */
	"DB_DEPTH_VIEW\0" /* 50108 */
	"DB_RENDER_OVERRIDE\0" /* 50122 */
	"DB_RENDER_OVERRIDE2\0" /* 50141 */
	"DB_HTILE_DATA_BASE\0" /* 50161 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 50180 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 50200 */
	"DB_STENCIL_CLEAR\0" /* 50220 */
	"DB_DEPTH_CLEAR\0" /* 50237 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 50252 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 50276 */
	"DB_DEPTH_INFO\0" /* 50300 */
	"DB_Z_INFO\0" /* 50314 */
	"DB_STENCIL_INFO\0" /* 50324 */
	"DB_Z_READ_BASE\0" /* 50340 */
	"DB_STENCIL_READ_BASE\0" /* 50355 */
	"DB_Z_WRITE_BASE\0" /* 50376 */
	"DB_STENCIL_WRITE_BASE\0" /* 50392 */
	"DB_DEPTH_SIZE\0" /* 50414 */
	"DB_DEPTH_SLICE\0" /* 50428 */
	"TA_BC_BASE_ADDR\0" /* 50443 */
	"TA_BC_BASE_ADDR_HI\0" /* 50459 */
	"COHER_DEST_BASE_HI_0\0" /* 50478 */
	"COHER_DEST_BASE_HI_1\0" /* 50499 */
	"COHER_DEST_BASE_HI_2\0" /* 50520 */
	"COHER_DEST_BASE_HI_3\0" /* 50541 */
	"COHER_DEST_BASE_2\0" /* 50562 */
	"COHER_DEST_BASE_3\0" /* 50580 */
	"PA_SC_WINDOW_OFFSET\0" /* 50598 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 50618 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 50642 */
	"PA_SC_CLIPRECT_RULE\0" /* 50666 */
	"PA_SC_CLIPRECT_0_TL\0" /* 50686 */
	"PA_SC_CLIPRECT_0_BR\0" /* 50706 */
	"PA_SC_CLIPRECT_1_TL\0" /* 50726 */
	"PA_SC_CLIPRECT_1_BR\0" /* 50746 */
	"PA_SC_CLIPRECT_2_TL\0" /* 50766 */
	"PA_SC_CLIPRECT_2_BR\0" /* 50786 */
	"PA_SC_CLIPRECT_3_TL\0" /* 50806 */
	"PA_SC_CLIPRECT_3_BR\0" /* 50826 */
	"PA_SC_EDGERULE\0" /* 50846 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 50861 */
	"CB_TARGET_MASK\0" /* 50890 */
	"CB_SHADER_MASK\0" /* 50905 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 50920 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 50945 */
	"COHER_DEST_BASE_0\0" /* 50970 */
	"COHER_DEST_BASE_1\0" /* 50988 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 51006 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 51031 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 51056 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 51081 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 51106 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 51131 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 51156 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 51181 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 51206 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 51231 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 51256 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 51281 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 51306 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 51331 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 51356 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 51381 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 51406 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 51431 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 51456 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 51481 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 51506 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 51532 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 51558 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 51584 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 51610 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 51636 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 51662 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 51688 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 51714 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 51740 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 51766 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 51792 */
	"PA_SC_VPORT_ZMIN_0\0" /* 51818 */
	"PA_SC_VPORT_ZMAX_0\0" /* 51837 */
	"PA_SC_VPORT_ZMIN_1\0" /* 51856 */
	"PA_SC_VPORT_ZMAX_1\0" /* 51875 */
	"PA_SC_VPORT_ZMIN_2\0" /* 51894 */
	"PA_SC_VPORT_ZMAX_2\0" /* 51913 */
	"PA_SC_VPORT_ZMIN_3\0" /* 51932 */
	"PA_SC_VPORT_ZMAX_3\0" /* 51951 */
	"PA_SC_VPORT_ZMIN_4\0" /* 51970 */
	"PA_SC_VPORT_ZMAX_4\0" /* 51989 */
	"PA_SC_VPORT_ZMIN_5\0" /* 52008 */
	"PA_SC_VPORT_ZMAX_5\0" /* 52027 */
	"PA_SC_VPORT_ZMIN_6\0" /* 52046 */
	"PA_SC_VPORT_ZMAX_6\0" /* 52065 */
	"PA_SC_VPORT_ZMIN_7\0" /* 52084 */
	"PA_SC_VPORT_ZMAX_7\0" /* 52103 */
	"PA_SC_VPORT_ZMIN_8\0" /* 52122 */
	"PA_SC_VPORT_ZMAX_8\0" /* 52141 */
	"PA_SC_VPORT_ZMIN_9\0" /* 52160 */
	"PA_SC_VPORT_ZMAX_9\0" /* 52179 */
	"PA_SC_VPORT_ZMIN_10\0" /* 52198 */
	"PA_SC_VPORT_ZMAX_10\0" /* 52218 */
	"PA_SC_VPORT_ZMIN_11\0" /* 52238 */
	"PA_SC_VPORT_ZMAX_11\0" /* 52258 */
	"PA_SC_VPORT_ZMIN_12\0" /* 52278 */
	"PA_SC_VPORT_ZMAX_12\0" /* 52298 */
	"PA_SC_VPORT_ZMIN_13\0" /* 52318 */
	"PA_SC_VPORT_ZMAX_13\0" /* 52338 */
	"PA_SC_VPORT_ZMIN_14\0" /* 52358 */
	"PA_SC_VPORT_ZMAX_14\0" /* 52378 */
	"PA_SC_VPORT_ZMIN_15\0" /* 52398 */
	"PA_SC_VPORT_ZMAX_15\0" /* 52418 */
	"PA_SC_RASTER_CONFIG\0" /* 52438 */
	"PA_SC_RASTER_CONFIG_1\0" /* 52458 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 52480 */
	"VGT_MAX_VTX_INDX\0" /* 52508 */
	"VGT_MIN_VTX_INDX\0" /* 52525 */
	"VGT_INDX_OFFSET\0" /* 52542 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 52558 */
	"CB_BLEND_RED\0" /* 52587 */
	"CB_BLEND_GREEN\0" /* 52600 */
	"CB_BLEND_BLUE\0" /* 52615 */
	"CB_BLEND_ALPHA\0" /* 52629 */
	"CB_DCC_CONTROL\0" /* 52644 */
	"DB_STENCIL_CONTROL\0" /* 52659 */
	"DB_STENCILREFMASK\0" /* 52678 */
	"DB_STENCILREFMASK_BF\0" /* 52696 */
	"PA_CL_VPORT_XSCALE\0" /* 52717 */
	"PA_CL_VPORT_XOFFSET\0" /* 52736 */
	"PA_CL_VPORT_YSCALE\0" /* 52756 */
	"PA_CL_VPORT_YOFFSET\0" /* 52775 */
	"PA_CL_VPORT_ZSCALE\0" /* 52795 */
	"PA_CL_VPORT_ZOFFSET\0" /* 52814 */
	"PA_CL_VPORT_XSCALE_1\0" /* 52834 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 52855 */
	"PA_CL_VPORT_YSCALE_1\0" /* 52877 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 52898 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 52920 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 52941 */
	"PA_CL_VPORT_XSCALE_2\0" /* 52963 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 52984 */
	"PA_CL_VPORT_YSCALE_2\0" /* 53006 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 53027 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 53049 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 53070 */
	"PA_CL_VPORT_XSCALE_3\0" /* 53092 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 53113 */
	"PA_CL_VPORT_YSCALE_3\0" /* 53135 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 53156 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 53178 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 53199 */
	"PA_CL_VPORT_XSCALE_4\0" /* 53221 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 53242 */
	"PA_CL_VPORT_YSCALE_4\0" /* 53264 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 53285 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 53307 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 53328 */
	"PA_CL_VPORT_XSCALE_5\0" /* 53350 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 53371 */
	"PA_CL_VPORT_YSCALE_5\0" /* 53393 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 53414 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 53436 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 53457 */
	"PA_CL_VPORT_XSCALE_6\0" /* 53479 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 53500 */
	"PA_CL_VPORT_YSCALE_6\0" /* 53522 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 53543 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 53565 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 53586 */
	"PA_CL_VPORT_XSCALE_7\0" /* 53608 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 53629 */
	"PA_CL_VPORT_YSCALE_7\0" /* 53651 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 53672 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 53694 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 53715 */
	"PA_CL_VPORT_XSCALE_8\0" /* 53737 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 53758 */
	"PA_CL_VPORT_YSCALE_8\0" /* 53780 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 53801 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 53823 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 53844 */
	"PA_CL_VPORT_XSCALE_9\0" /* 53866 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 53887 */
	"PA_CL_VPORT_YSCALE_9\0" /* 53909 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 53930 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 53952 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 53973 */
	"PA_CL_VPORT_XSCALE_10\0" /* 53995 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 54017 */
	"PA_CL_VPORT_YSCALE_10\0" /* 54040 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 54062 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 54085 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 54107 */
	"PA_CL_VPORT_XSCALE_11\0" /* 54130 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 54152 */
	"PA_CL_VPORT_YSCALE_11\0" /* 54175 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 54197 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 54220 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 54242 */
	"PA_CL_VPORT_XSCALE_12\0" /* 54265 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 54287 */
	"PA_CL_VPORT_YSCALE_12\0" /* 54310 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 54332 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 54355 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 54377 */
	"PA_CL_VPORT_XSCALE_13\0" /* 54400 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 54422 */
	"PA_CL_VPORT_YSCALE_13\0" /* 54445 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 54467 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 54490 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 54512 */
	"PA_CL_VPORT_XSCALE_14\0" /* 54535 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 54557 */
	"PA_CL_VPORT_YSCALE_14\0" /* 54580 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 54602 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 54625 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 54647 */
	"PA_CL_VPORT_XSCALE_15\0" /* 54670 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 54692 */
	"PA_CL_VPORT_YSCALE_15\0" /* 54715 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 54737 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 54760 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 54782 */
	"PA_CL_UCP_0_X\0" /* 54805 */
	"PA_CL_UCP_0_Y\0" /* 54819 */
	"PA_CL_UCP_0_Z\0" /* 54833 */
	"PA_CL_UCP_0_W\0" /* 54847 */
	"PA_CL_UCP_1_X\0" /* 54861 */
	"PA_CL_UCP_1_Y\0" /* 54875 */
	"PA_CL_UCP_1_Z\0" /* 54889 */
	"PA_CL_UCP_1_W\0" /* 54903 */
	"PA_CL_UCP_2_X\0" /* 54917 */
	"PA_CL_UCP_2_Y\0" /* 54931 */
	"PA_CL_UCP_2_Z\0" /* 54945 */
	"PA_CL_UCP_2_W\0" /* 54959 */
	"PA_CL_UCP_3_X\0" /* 54973 */
	"PA_CL_UCP_3_Y\0" /* 54987 */
	"PA_CL_UCP_3_Z\0" /* 55001 */
	"PA_CL_UCP_3_W\0" /* 55015 */
	"PA_CL_UCP_4_X\0" /* 55029 */
	"PA_CL_UCP_4_Y\0" /* 55043 */
	"PA_CL_UCP_4_Z\0" /* 55057 */
	"PA_CL_UCP_4_W\0" /* 55071 */
	"PA_CL_UCP_5_X\0" /* 55085 */
	"PA_CL_UCP_5_Y\0" /* 55099 */
	"PA_CL_UCP_5_Z\0" /* 55113 */
	"PA_CL_UCP_5_W\0" /* 55127 */
	"SPI_PS_INPUT_CNTL_0\0" /* 55141 */
	"SPI_PS_INPUT_CNTL_1\0" /* 55161 */
	"SPI_PS_INPUT_CNTL_2\0" /* 55181 */
	"SPI_PS_INPUT_CNTL_3\0" /* 55201 */
	"SPI_PS_INPUT_CNTL_4\0" /* 55221 */
	"SPI_PS_INPUT_CNTL_5\0" /* 55241 */
	"SPI_PS_INPUT_CNTL_6\0" /* 55261 */
	"SPI_PS_INPUT_CNTL_7\0" /* 55281 */
	"SPI_PS_INPUT_CNTL_8\0" /* 55301 */
	"SPI_PS_INPUT_CNTL_9\0" /* 55321 */
	"SPI_PS_INPUT_CNTL_10\0" /* 55341 */
	"SPI_PS_INPUT_CNTL_11\0" /* 55362 */
	"SPI_PS_INPUT_CNTL_12\0" /* 55383 */
	"SPI_PS_INPUT_CNTL_13\0" /* 55404 */
	"SPI_PS_INPUT_CNTL_14\0" /* 55425 */
	"SPI_PS_INPUT_CNTL_15\0" /* 55446 */
	"SPI_PS_INPUT_CNTL_16\0" /* 55467 */
	"SPI_PS_INPUT_CNTL_17\0" /* 55488 */
	"SPI_PS_INPUT_CNTL_18\0" /* 55509 */
	"SPI_PS_INPUT_CNTL_19\0" /* 55530 */
	"SPI_PS_INPUT_CNTL_20\0" /* 55551 */
	"SPI_PS_INPUT_CNTL_21\0" /* 55572 */
	"SPI_PS_INPUT_CNTL_22\0" /* 55593 */
	"SPI_PS_INPUT_CNTL_23\0" /* 55614 */
	"SPI_PS_INPUT_CNTL_24\0" /* 55635 */
	"SPI_PS_INPUT_CNTL_25\0" /* 55656 */
	"SPI_PS_INPUT_CNTL_26\0" /* 55677 */
	"SPI_PS_INPUT_CNTL_27\0" /* 55698 */
	"SPI_PS_INPUT_CNTL_28\0" /* 55719 */
	"SPI_PS_INPUT_CNTL_29\0" /* 55740 */
	"SPI_PS_INPUT_CNTL_30\0" /* 55761 */
	"SPI_PS_INPUT_CNTL_31\0" /* 55782 */
	"SPI_VS_OUT_CONFIG\0" /* 55803 */
	"SPI_PS_INPUT_ENA\0" /* 55821 */
	"SPI_PS_INPUT_ADDR\0" /* 55838 */
	"SPI_INTERP_CONTROL_0\0" /* 55856 */
	"SPI_PS_IN_CONTROL\0" /* 55877 */
	"SPI_BARYC_CNTL\0" /* 55895 */
	"SPI_TMPRING_SIZE\0" /* 55910 */
	"SPI_WAVE_MGMT_1\0" /* 55927 */
	"SPI_WAVE_MGMT_2\0" /* 55943 */
	"SPI_SHADER_POS_FORMAT\0" /* 55959 */
	"SPI_SHADER_Z_FORMAT\0" /* 55981 */
	"SPI_SHADER_COL_FORMAT\0" /* 56001 */
	"SX_PS_DOWNCONVERT\0" /* 56023 */
	"SX_BLEND_OPT_EPSILON\0" /* 56041 */
	"SX_BLEND_OPT_CONTROL\0" /* 56062 */
	"SX_MRT0_BLEND_OPT\0" /* 56083 */
	"SX_MRT1_BLEND_OPT\0" /* 56101 */
	"SX_MRT2_BLEND_OPT\0" /* 56119 */
	"SX_MRT3_BLEND_OPT\0" /* 56137 */
	"SX_MRT4_BLEND_OPT\0" /* 56155 */
	"SX_MRT5_BLEND_OPT\0" /* 56173 */
	"SX_MRT6_BLEND_OPT\0" /* 56191 */
	"SX_MRT7_BLEND_OPT\0" /* 56209 */
	"CB_BLEND0_CONTROL\0" /* 56227 */
	"CB_BLEND1_CONTROL\0" /* 56245 */
	"CB_BLEND2_CONTROL\0" /* 56263 */
	"CB_BLEND3_CONTROL\0" /* 56281 */
	"CB_BLEND4_CONTROL\0" /* 56299 */
	"CB_BLEND5_CONTROL\0" /* 56317 */
	"CB_BLEND6_CONTROL\0" /* 56335 */
	"CB_BLEND7_CONTROL\0" /* 56353 */
	"CS_COPY_STATE\0" /* 56371 */
	"PA_CL_POINT_X_RAD\0" /* 56385 */
	"PA_CL_POINT_Y_RAD\0" /* 56403 */
	"PA_CL_POINT_SIZE\0" /* 56421 */
	"PA_CL_POINT_CULL_RAD\0" /* 56438 */
	"VGT_DMA_BASE_HI\0" /* 56459 */
	"VGT_DMA_BASE\0" /* 56475 */
	"VGT_DRAW_INITIATOR\0" /* 56488 */
	"VGT_IMMED_DATA\0" /* 56507 */
	"VGT_EVENT_ADDRESS_REG\0" /* 56522 */
	"DB_DEPTH_CONTROL\0" /* 56544 */
	"DB_EQAA\0" /* 56561 */
	"CB_COLOR_CONTROL\0" /* 56569 */
	"DB_SHADER_CONTROL\0" /* 56586 */
	"PA_CL_CLIP_CNTL\0" /* 56604 */
	"PA_SU_SC_MODE_CNTL\0" /* 56620 */
	"PA_CL_VTE_CNTL\0" /* 56639 */
	"PA_CL_VS_OUT_CNTL\0" /* 56654 */
	"PA_CL_NANINF_CNTL\0" /* 56672 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 56690 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 56714 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 56739 */
	"PA_SU_POINT_SIZE\0" /* 56762 */
	"PA_SU_POINT_MINMAX\0" /* 56779 */
	"PA_SU_LINE_CNTL\0" /* 56798 */
	"PA_SC_LINE_STIPPLE\0" /* 56814 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 56833 */
	"VGT_HOS_CNTL\0" /* 56854 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 56867 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 56890 */
	"VGT_HOS_REUSE_DEPTH\0" /* 56913 */
	"VGT_GROUP_PRIM_TYPE\0" /* 56933 */
	"VGT_GROUP_FIRST_DECR\0" /* 56953 */
	"VGT_GROUP_DECR\0" /* 56974 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 56989 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 57011 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 57033 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 57059 */
	"VGT_GS_MODE\0" /* 57085 */
	"VGT_GS_ONCHIP_CNTL\0" /* 57097 */
	"PA_SC_MODE_CNTL_0\0" /* 57116 */
	"PA_SC_MODE_CNTL_1\0" /* 57134 */
	"VGT_ENHANCE\0" /* 57152 */
	"VGT_GS_PER_ES\0" /* 57164 */
	"VGT_ES_PER_GS\0" /* 57178 */
	"VGT_GS_PER_VS\0" /* 57192 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 57206 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 57229 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 57252 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 57275 */
	"IA_ENHANCE\0" /* 57296 */
	"VGT_DMA_SIZE\0" /* 57307 */
	"VGT_DMA_MAX_SIZE\0" /* 57320 */
	"VGT_DMA_INDEX_TYPE\0" /* 57337 */
	"WD_ENHANCE\0" /* 57356 */
	"VGT_PRIMITIVEID_EN\0" /* 57367 */
	"VGT_DMA_NUM_INSTANCES\0" /* 57386 */
	"VGT_PRIMITIVEID_RESET\0" /* 57408 */
	"VGT_EVENT_INITIATOR\0" /* 57430 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 57450 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 57477 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 57502 */
	"IA_MULTI_VGT_PARAM\0" /* 57527 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 57546 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 57569 */
	"VGT_REUSE_OFF\0" /* 57592 */
	"VGT_VTX_CNT_EN\0" /* 57606 */
	"DB_HTILE_SURFACE\0" /* 57621 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 57638 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 57665 */
	"DB_PRELOAD_CONTROL\0" /* 57692 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 57711 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 57737 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 57762 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 57790 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 57816 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 57841 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 57869 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 57895 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 57920 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 57948 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 57974 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 57999 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 58027 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 58058 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 58101 */
	"VGT_GS_MAX_VERT_OUT\0" /* 58139 */
	"VGT_TESS_DISTRIBUTION\0" /* 58159 */
	"VGT_SHADER_STAGES_EN\0" /* 58181 */
	"VGT_LS_HS_CONFIG\0" /* 58202 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 58219 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 58240 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 58263 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 58286 */
	"VGT_TF_PARAM\0" /* 58309 */
	"DB_ALPHA_TO_MASK\0" /* 58322 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 58339 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 58363 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 58393 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 58417 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 58447 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 58478 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 58507 */
	"VGT_GS_INSTANCE_CNT\0" /* 58537 */
	"VGT_STRMOUT_CONFIG\0" /* 58557 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 58576 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 58602 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 58628 */
	"PA_SC_LINE_CNTL\0" /* 58654 */
	"PA_SC_AA_CONFIG\0" /* 58670 */
	"PA_SU_VTX_CNTL\0" /* 58686 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 58701 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 58724 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 58747 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 58770 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 58793 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 58827 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 58861 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 58895 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 58929 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 58963 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 58997 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 59031 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 59065 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 59099 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 59133 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 59167 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 59201 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 59235 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 59269 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 59303 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 59337 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 59361 */
	"PA_SC_SHADER_CONTROL\0" /* 59385 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 59406 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 59434 */
	"CB_COLOR0_BASE\0" /* 59455 */
	"CB_COLOR0_PITCH\0" /* 59470 */
	"CB_COLOR0_SLICE\0" /* 59486 */
	"CB_COLOR0_VIEW\0" /* 59502 */
	"CB_COLOR0_INFO\0" /* 59517 */
	"CB_COLOR0_ATTRIB\0" /* 59532 */
	"CB_COLOR0_DCC_CONTROL\0" /* 59549 */
	"CB_COLOR0_CMASK\0" /* 59571 */
	"CB_COLOR0_CMASK_SLICE\0" /* 59587 */
	"CB_COLOR0_FMASK\0" /* 59609 */
	"CB_COLOR0_FMASK_SLICE\0" /* 59625 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 59647 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 59669 */
	"CB_COLOR0_DCC_BASE\0" /* 59691 */
	"CB_COLOR1_BASE\0" /* 59710 */
	"CB_COLOR1_PITCH\0" /* 59725 */
	"CB_COLOR1_SLICE\0" /* 59741 */
	"CB_COLOR1_VIEW\0" /* 59757 */
	"CB_COLOR1_INFO\0" /* 59772 */
	"CB_COLOR1_ATTRIB\0" /* 59787 */
	"CB_COLOR1_DCC_CONTROL\0" /* 59804 */
	"CB_COLOR1_CMASK\0" /* 59826 */
	"CB_COLOR1_CMASK_SLICE\0" /* 59842 */
	"CB_COLOR1_FMASK\0" /* 59864 */
	"CB_COLOR1_FMASK_SLICE\0" /* 59880 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 59902 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 59924 */
	"CB_COLOR1_DCC_BASE\0" /* 59946 */
	"CB_COLOR2_BASE\0" /* 59965 */
	"CB_COLOR2_PITCH\0" /* 59980 */
	"CB_COLOR2_SLICE\0" /* 59996 */
	"CB_COLOR2_VIEW\0" /* 60012 */
	"CB_COLOR2_INFO\0" /* 60027 */
	"CB_COLOR2_ATTRIB\0" /* 60042 */
	"CB_COLOR2_DCC_CONTROL\0" /* 60059 */
	"CB_COLOR2_CMASK\0" /* 60081 */
	"CB_COLOR2_CMASK_SLICE\0" /* 60097 */
	"CB_COLOR2_FMASK\0" /* 60119 */
	"CB_COLOR2_FMASK_SLICE\0" /* 60135 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 60157 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 60179 */
	"CB_COLOR2_DCC_BASE\0" /* 60201 */
	"CB_COLOR3_BASE\0" /* 60220 */
	"CB_COLOR3_PITCH\0" /* 60235 */
	"CB_COLOR3_SLICE\0" /* 60251 */
	"CB_COLOR3_VIEW\0" /* 60267 */
	"CB_COLOR3_INFO\0" /* 60282 */
	"CB_COLOR3_ATTRIB\0" /* 60297 */
	"CB_COLOR3_DCC_CONTROL\0" /* 60314 */
	"CB_COLOR3_CMASK\0" /* 60336 */
	"CB_COLOR3_CMASK_SLICE\0" /* 60352 */
	"CB_COLOR3_FMASK\0" /* 60374 */
	"CB_COLOR3_FMASK_SLICE\0" /* 60390 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 60412 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 60434 */
	"CB_COLOR3_DCC_BASE\0" /* 60456 */
	"CB_COLOR4_BASE\0" /* 60475 */
	"CB_COLOR4_PITCH\0" /* 60490 */
	"CB_COLOR4_SLICE\0" /* 60506 */
	"CB_COLOR4_VIEW\0" /* 60522 */
	"CB_COLOR4_INFO\0" /* 60537 */
	"CB_COLOR4_ATTRIB\0" /* 60552 */
	"CB_COLOR4_DCC_CONTROL\0" /* 60569 */
	"CB_COLOR4_CMASK\0" /* 60591 */
	"CB_COLOR4_CMASK_SLICE\0" /* 60607 */
	"CB_COLOR4_FMASK\0" /* 60629 */
	"CB_COLOR4_FMASK_SLICE\0" /* 60645 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 60667 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 60689 */
	"CB_COLOR4_DCC_BASE\0" /* 60711 */
	"CB_COLOR5_BASE\0" /* 60730 */
	"CB_COLOR5_PITCH\0" /* 60745 */
	"CB_COLOR5_SLICE\0" /* 60761 */
	"CB_COLOR5_VIEW\0" /* 60777 */
	"CB_COLOR5_INFO\0" /* 60792 */
	"CB_COLOR5_ATTRIB\0" /* 60807 */
	"CB_COLOR5_DCC_CONTROL\0" /* 60824 */
	"CB_COLOR5_CMASK\0" /* 60846 */
	"CB_COLOR5_CMASK_SLICE\0" /* 60862 */
	"CB_COLOR5_FMASK\0" /* 60884 */
	"CB_COLOR5_FMASK_SLICE\0" /* 60900 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 60922 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 60944 */
	"CB_COLOR5_DCC_BASE\0" /* 60966 */
	"CB_COLOR6_BASE\0" /* 60985 */
	"CB_COLOR6_PITCH\0" /* 61000 */
	"CB_COLOR6_SLICE\0" /* 61016 */
	"CB_COLOR6_VIEW\0" /* 61032 */
	"CB_COLOR6_INFO\0" /* 61047 */
	"CB_COLOR6_ATTRIB\0" /* 61062 */
	"CB_COLOR6_DCC_CONTROL\0" /* 61079 */
	"CB_COLOR6_CMASK\0" /* 61101 */
	"CB_COLOR6_CMASK_SLICE\0" /* 61117 */
	"CB_COLOR6_FMASK\0" /* 61139 */
	"CB_COLOR6_FMASK_SLICE\0" /* 61155 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 61177 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 61199 */
	"CB_COLOR6_DCC_BASE\0" /* 61221 */
	"CB_COLOR7_BASE\0" /* 61240 */
	"CB_COLOR7_PITCH\0" /* 61255 */
	"CB_COLOR7_SLICE\0" /* 61271 */
	"CB_COLOR7_VIEW\0" /* 61287 */
	"CB_COLOR7_INFO\0" /* 61302 */
	"CB_COLOR7_ATTRIB\0" /* 61317 */
	"CB_COLOR7_DCC_CONTROL\0" /* 61334 */
	"CB_COLOR7_CMASK\0" /* 61356 */
	"CB_COLOR7_CMASK_SLICE\0" /* 61372 */
	"CB_COLOR7_FMASK\0" /* 61394 */
	"CB_COLOR7_FMASK_SLICE\0" /* 61410 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 61432 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 61454 */
	"CB_COLOR7_DCC_BASE\0" /* 61476 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 501, 823, 827, 830,
	/* 4 */ 867, 887, 899, 905, 909, 918,
	/* 10 */ 956, 905, 383, 965,
	/* 14 */ 995, 905, -1, 1004,
	/* 18 */ 1093, 1098, 1106, 1114,
	/* 22 */ 1140, 878,
	/* 24 */ 1155, 1165,
	/* 26 */ 5384, 5395, 5411, 5426, 5442, 5456, 5469, 5484, 5499, 5514, 5526, 5545, 5565, 5583, 5602, 5617, 5632, 5654, 5669, 5684, 5699, 5715, 5729, 5756, 5783, 5810, 5837, 5861, 5881,
	/* 55 */ 5910, 5931,
	/* 57 */ 5384, 5395, 5411, 5426, 5442, 5456, 5469, -1, -1, 5514, 5526, 5545, 5565, 5583, -1, -1, 5632, 5654, 5669, 5684, 5699, 5715, 5729, 5756, 5783, 5810, 5837, 5861, 5881,
	/* 86 */ 7891, 7903, 7915, 7927,
	/* 90 */ 8275, -1, -1, -1, -1, -1, -1, -1, 8286, 8298, -1, -1, 8310, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8321,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8347,
	/* 186 */ 8442, 8451, 8460, 8478, 8496, 8505, 8514, 8523,
	/* 194 */ 8572, 8593, 8614, 8637, 8660, 8680, 8700, 8725,
	/* 202 */ 8757, 8781, 8799, 8818, 8838, 8857, 8879, 8904, 8929, 8956, 8983, 9007, 9029, 9057, 9082, 9110,
	/* 218 */ 9218, 9230, 9249, 9268,
	/* 222 */ 9295, 9319, 9337, 9356, 9376, 9395, 9417, 9442, 9467, 9494, 9521, 9545, 9567, 9595, 9620, 9648, 9676, 9698, 9722, 9746, 9770, 9791, 9812, 9837, 9866, 9891, 9917, 9940, 9964, 9991, 10019, 10047, 10075, 10097, 10119, 10143, 10163, 10183, 10203, 10223, 10243, 10263, 10283, 10317, 10351, 10380, 10409, 10438, 10467, 10496, 10525, 10556, 10586, 10617, 10647, 10677, 10708, 10739, 10759, 10781, 10799, 10826, 10850, 10876,
	/* 286 */ 10910, 10931, 10952, 10975, 10998, 11018, 11038, 11063, 11084, 11110, 11130, 11152, 11178, 11199, 11223, 11250,
	/* 302 */ 11354, 11373, 11392, 11411, 11430, 11449, 11468, 11487, 11506, 11521, 11536, 11551, 11568, 11589, 11610, 11630,
	/* 318 */ 11813, 11825, 11839, 11863, 11893, 11918, 11949, 11969,
	/* 326 */ 12035, 12062, 12088, 12115, 12146, 12175, 12205, 12239,
	/* 334 */ 12434, 12457,
	/* 336 */ 12434, 12457, 12497, 12526,
	/* 340 */ 12572, 12593, 12615,
	/* 343 */ 12742, 12774, 12807, 12840,
	/* 347 */ 13031,
	/* 348 */ 13330, 13346, 13362, 13378, 13394, 13410, 13426, 13442, 13458, 13474, 13490, 13506, 13521, 13536, 13551, 13567,
	/* 364 */ 13979, 14010, 14038, 14067,
	/* 368 */ 14112, 14133, 14154, 14175, 14196, -1, -1, 14217, 14238, -1, -1, -1, 14260, 14281, 14302, 14324,
	/* 384 */ 14352, 14365, 14388, 14411, 14434, 14454, 14475, 14496, 14517, 14543, 14569, 14595, 14622, 14649, 14676,
	/* 399 */ 14715, 14740, 14766, 14792, 14818, 14843, 14868,
	/* 406 */ 14904, 14927, 14950, 14973,
	/* 410 */ 15007, 15031, 15055, 15079,
	/* 414 */ 15115, 15140, 15165, 15190,
	/* 418 */ 15233, 15250, 15267, 15284,
	/* 422 */ 13979, 14010, 14038, 15312,
	/* 426 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15427, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15441, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15455,
	/* 667 */ 16385, 16403, 16418,
	/* 670 */ 17955, 17965, 17978, 17992,
	/* 674 */ 18289, 18304, 18320, 18336,
	/* 678 */ 18501, 18511, 18529, 18539,
	/* 682 */ 14112, 14133, 14154, -1, 14196, 18944, 18966,
	/* 689 */ 14352, -1, -1, -1, 14434, 14454, 14475, 14496, 14517, 14543, 14569, 14595, 14622, 14649, 14676, -1, 18991, 19018,
	/* 707 */ 19046, 19056, 19061, 19066,
	/* 711 */ 19208, 19224,
	/* 713 */ 19702, 19725, 19748, 19771,
	/* 717 */ 19818, 19843, 19868, 19893,
	/* 721 */ 19943, 19967, 19991, 20015,
	/* 725 */ 20047, 20072, 20097, 20122,
	/* 729 */ 20156, 20181, 20206, 20231,
	/* 733 */ 20265, 20291, 20317, 20343,
	/* 737 */ 20379, 20402, 20425, 20448,
	/* 741 */ 20478, 20512, 20547, 20582,
	/* 745 */ 20625, 20659, 20694, 20729,
	/* 749 */ 20772, 20795, 20818, 20841,
	/* 753 */ 20871, 20905, 20940, 20975,
	/* 757 */ 21018, 21052, 21087, 21122,
	/* 761 */ 21165, 21193, 21221, 21249,
	/* 765 */ 21289, 21328, 21368, 21408,
	/* 769 */ 21461, 21500, 21540, 21580,
	/* 773 */ 21728, 21741, 21754, 21767, 21788, 21807, 21825, 21843, 21858, 21875, 21892, 21904, 21915, 21927, 21940, 21952,
	/* 789 */ 22176,
	/* 790 */ 22705, 22726, 22747, 22768, 22789,
	/* 795 */ 23050,
	/* 796 */ 23230, 23246, 23263, 23280, 23301,
	/* 801 */ 23394, 23410, 23426, 23443, 23460, 23481, 23505, 23529, 23552, 23575,
	/* 811 */ 23762, 23789, 23807, 23825, 23847, 23871, 23892, 23911, 23932, 23953, 23975,
	/* 822 */ 24037, 24043, -1, 24056, -1, -1, -1, 24069, -1, -1, -1, 24081, -1, 24093, -1, 24105,
	/* 838 */ 24612, 24647, 24682, 24714, 24746, 24778, 24810, 24844,
	/* 846 */ 24908, 24922, 24935, 24953, 24966, 24979, 25000, 25024,
	/* 854 */ 25100, 25111, 25121, 25137, 25163, 25179, 25205, 25221, 25247, 25263, 25289, -1, -1, 25314, 25335, 25366, 25383, 25404, 25421, 25442, 25463,
	/* 875 */ 25509, 25527, 25546, 25563, 25580,
	/* 880 */ 25703, 25718, 25739, 25761,
	/* 884 */ 25795, 25811,
	/* 886 */ 25919, 25930, 25940, 25951, 25963, 25976, 25990, 26002,
	/* 894 */ 26030, 26040, 26049, 26059, 26070, 26082, 26095, 26106,
	/* 902 */ 26527, 26538, 26548, 26572, -1, 26583, 26603,
	/* 909 */ 26621, -1, -1, -1, -1, 26628, -1, -1, -1, -1, 26635, -1, -1, -1, -1, 26642, -1, 26649, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26656, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26663, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26670, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26677, -1, -1, -1, -1, 26684, -1, -1, -1, -1, 26691, -1, -1, -1, -1, 26698, -1, -1, -1, -1, -1, -1, 26705, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26712, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26719, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26726, -1, -1, -1, -1, -1, -1, 26733, -1, -1, -1, -1, 26740, -1, -1, -1, -1, 26747, -1, -1, -1, -1, 26754, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26761, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26768, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26775, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26782, -1, 26789, -1, -1, -1, -1, 26796, -1, -1, -1, -1, 26803, -1, -1, -1, -1, 26810,
	/* 1165 */ 26893, 26900, 26920, 26925,
	/* 1169 */ 27071, 27084, 27103, 27125,
	/* 1173 */ 27511, 27531,
	/* 1175 */ 27543, 27557, 27570,
	/* 1178 */ 29076, 29098, 29118, 29139, 29160,
	/* 1183 */ 29215, 29232, 29248, 29263, 29279, 29295, 29319, 29343, 29367, 29391, 29412, 29428, 29443, 29467, 29490, 29514, 29534, 29553,
	/* 1201 */ 29596, 29609, 29623, 29635, 29648,
	/* 1206 */ 29732, 29749, 29766, 29782, 29798, 29814, 29830, 29847, 29865,
	/* 1215 */ 29937, 29944, 29958, 29972, 29986, 30000,
	/* 1221 */ 30010, 30022, 30033, 30044,
	/* 1225 */ 30216, -1, -1, 30231,
	/* 1229 */ 30900, 30923, 30946,
	/* 1232 */ 31049, 31062, 31075,
	/* 1235 */ 31087, 31105, 31125, 31145,
	/* 1239 */ 31173, 31189, 31206,
	/* 1242 */ 31233, 31248,
	/* 1244 */ -1, 31340, 31363, 31386, 31409, 31424, 31437, 31449, 31466, -1, 31485, 31505, 31525, 31544, -1, 31556, 31573, 31590, 31606, -1, 31622, 31651, 31662, 31688, 31706, 31723, 31742, 31760, 31779, 31795, 31811, 31831, 31853, 31875, 31889, 31908, 31924, -1, -1, 31934, 31949, -1, 31967, 31990, 32015, 32037, 32062, 7528, 7555, 32084, -1, 32112, 32131, 32149, 32169, 32188, 32208, 32232, -1, -1, -1, -1, -1, -1, 32253,
	/* 1309 */ 32751, 32764, 32776,
	/* 1312 */ 32788, 32801, 32813,
	/* 1315 */ 32827, 32841, 32853,
	/* 1318 */ 32984, 32997, 33011,
	/* 1321 */ 33021, 33034, 33044, 33058,
	/* 1325 */ 33086, 33099, 33111, 33130,
	/* 1329 */ 31233, 31248, 33227,
	/* 1332 */ 33245, 33271, 33297,
	/* 1335 */ 34072, 34083, 34091, 34107,
	/* 1339 */ 34133, 34159, 34184, 34209, 34232, 34253, 34280, 34309,
	/* 1347 */ 34646, 34658, 34671, 34684,
	/* 1351 */ 34704, 34718, 34726, 34735, 34745, 34754, 34766, 34781, 34796, 34813, 34830, 34844, 34856, -1, 34874, -1, 34892, 34904, 34918, 34932, 34946, 34957, 34968,
	/* 1374 */ 34989, 35002, -1, -1, 35015, 35027, 35039, 35051,
	/* 1382 */ 35076, 35085, 35094, 35107,
	/* 1386 */ 35184, 35199, 35217, 35245, 35275, 35306, 35334,
};

#endif
