.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XWarpPntr.man,v 1.2 2001/01/27 18:20:06 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XWarpPointer __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XWarpPointer \- move pointer
.SH SYNTAX
.HP
int XWarpPointer\^(\^Display *\fIdisplay\fP\^, Window \fIsrc_w\fP\^, Window
\fIdest_w\fP\^, int \fIsrc_x\fP\^, int \fIsrc_y\fP\^, unsigned int
\fIsrc_width\fP\^, unsigned int \fIsrc_height\fP\^, int \fIdest_x\fP\^, int
\fIdest_y\fP\^); 
.SH ARGUMENTS
.IP \fIdest_w\fP 1i
Specifies the destination window or
.ZN None .
.IP \fIdest_x\fP 1i
.br
.ns
.IP \fIdest_y\fP 1i
Specify the x and y coordinates within the destination window.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIsrc_x\fP 1i
.br
.ns
.IP \fIsrc_y\fP 1i
.br
.ns
.IP \fIsrc_width\fP 1i
.br
.ns
.IP \fIsrc_height\fP 1i
Specify a rectangle in the source window.
.IP \fIsrc_w\fP 1i
Specifies the source window or
.ZN None .
.SH DESCRIPTION
If dest_w is
.ZN None ,
.ZN XWarpPointer
moves the pointer by the offsets (dest_x, dest_y) relative to the current
position of the pointer.
If dest_w is a window,
.ZN XWarpPointer
moves the pointer to the offsets (dest_x, dest_y) relative to the origin of
dest_w.
However, if src_w is a window,
the move only takes place if the window src_w contains the pointer 
and if the specified rectangle of src_w contains the pointer.
.LP
The src_x and src_y coordinates are relative to the origin of src_w.
If src_height is zero,
it is replaced with the current height of src_w minus src_y.
If src_width is zero,
it is replaced with the current width of src_w minus src_x.
.LP
There is seldom any reason for calling this function. 
The pointer should normally be left to the user.
If you do use this function, however, it generates events just as if the user
had instantaneously moved the pointer from one position to another.
Note that you cannot use
.ZN XWarpPointer
to move the pointer outside the confine_to window of an active pointer grab.
An attempt to do so will only move the pointer as far as the closest edge of the
confine_to window. 
.LP
.ZN XWarpPointer
can generate a
.ZN BadWindow 
error.
.SH DIAGNOSTICS
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XSetInputFocus(3X11)
.br
\fI\*(xL\fP
