.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XFlush.man,v 1.2 2001/01/27 18:19:59 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XFlush __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XFlush, XSync, XEventsQueued, XPending \- handle output buffer or event queue
.SH SYNTAX
.HP
int XFlush\^(\^Display *\fIdisplay\fP\^); 
.HP
int XSync\^(\^Display *\fIdisplay\fP\^, Bool \fIdiscard\fP\^); 
.HP
int XEventsQueued\^(\^Display *\fIdisplay\fP\^, int \fImode\fP\^); 
.HP
int XPending\^(\^Display *\fIdisplay\fP\^); 
.SH ARGUMENTS
.IP \fIdiscard\fP 1i
Specifies a Boolean value that indicates whether 
.ZN XSync
discards all events on the event queue.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fImode\fP 1i
Specifies the mode.
You can pass
.ZN QueuedAlready ,
.ZN QueuedAfterFlush ,
or
.ZN QueuedAfterReading .
.SH DESCRIPTION
The
.ZN XFlush
function
flushes the output buffer.
Most client applications need not use this function because the output
buffer is automatically flushed as needed by calls to
.ZN XPending ,
.ZN XNextEvent ,
and
.ZN XWindowEvent .
.IN "XPending"
.IN "XNextEvent"
.IN "XWindowEvent"
Events generated by the server may be enqueued into the library's event queue.
.LP
The
.ZN XSync
function
flushes the output buffer and then waits until all requests have been received
and processed by the X server.
Any errors generated must be handled by the error handler.
For each protocol error received by Xlib,
.ZN XSync
calls the client application's error handling routine (see section 11.8.2).
Any events generated by the server are enqueued into the library's 
event queue.
.LP
Finally, if you passed 
.ZN False ,
.ZN XSync
does not discard the events in the queue.
If you passed 
.ZN True ,
.ZN XSync 
discards all events in the queue,
including those events that were on the queue before
.ZN XSync
was called.
Client applications seldom need to call
.ZN XSync .
.LP
If mode is 
.ZN QueuedAlready ,
.ZN XEventsQueued 
returns the number of events
already in the event queue (and never performs a system call).
If mode is 
.ZN QueuedAfterFlush , 
.ZN XEventsQueued
returns the number of events already in the queue if the number is nonzero.
If there are no events in the queue, 
.ZN XEventsQueued
flushes the output buffer, 
attempts to read more events out of the application's connection,
and returns the number read.
If mode is 
.ZN QueuedAfterReading , 
.ZN XEventsQueued
returns the number of events already in the queue if the number is nonzero. 
If there are no events in the queue, 
.ZN XEventsQueued
attempts to read more events out of the application's connection 
without flushing the output buffer and returns the number read.
.LP
.ZN XEventsQueued
always returns immediately without I/O if there are events already in the
queue.
.ZN XEventsQueued
with mode 
.ZN QueuedAfterFlush
is identical in behavior to
.ZN XPending .
.ZN XEventsQueued
with mode
.ZN QueuedAlready
is identical to the
.ZN XQLength
function.
.LP
The
.ZN XPending
function returns the number of events that have been received from the
X server but have not been removed from the event queue.
.ZN XPending
is identical to
.ZN XEventsQueued
with the mode
.ZN QueuedAfterFlush
specified.
.SH "SEE ALSO"
AllPlanes(3X11),
XIfEvent(3X11),
XNextEvent(3X11),
XPutBackEvent(3X11)
.br
\fI\*(xL\fP
