.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH EVDEV __drivermansuffix__ __vendorversion__
.SH NAME
evdev \- Generic Linux input driver
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" devname \*q
.B  "  Driver \*qevdev\*q"
.BI "  Option \*qDevice\*q   \*q" devpath \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B evdev 
is an __xservername__ input driver for Linux\'s generic event devices.  It
therefore supports all input devices that the kernel knows about, including
most mice and keyboards.
.PP
The 
.B evdev
driver can serve as both a pointer and a keyboard input device, and may be
used as both the core keyboard and the core pointer.  Multiple input devices
are supported by multiple instances of this driver, with one Load
directive for evdev in the Module section of your __xconfigfile__ for each
input device that will use this driver.
.PP
.SH SUPPORTED HARDWARE
In general, any input device that the kernel has a driver for can be accessed
through the 
.B evdev
driver.  See the Linux kernel documentation for a complete list.
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
.SH BASIC CONFIGURATIONS
Most users of this driver will probably be quite happy with the following for
all QWERTY keyboards:
.PP
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" keyboard \*q
.B  "  Driver \*qevdev\*q"
.BI  "  Option \*qevBits\*q  \*q" "+1" \*q
.BI  "  Option \*qkeyBits\*q \*q" "~1-255 ~352-511" \*q
.BI  "  Option \*qPass\*q    \*q" "3" \*q
\ \ ...
.B EndSection
.fi
.PP
And the following for all mice:
.PP
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" mouse \*q
.B  "  Driver \*qevdev\*q"
.BI  "  Option \*qevBits\*q  \*q" "+1-2" \*q
.BI  "  Option \*qkeyBits\*q \*q" "~272-287" \*q
.BI  "  Option \*qrelBits\*q \*q" "~0-2 ~6 ~8" \*q
.BI  "  Option \*qPass\*q    \*q" "3" \*q
\ \ ...
.B EndSection
.fi
.PP
To understand what those Bits options do, or for more complex
configurations, please see
.BR "ADVANCED OPTIONS"
below.
.PP
.SH ADVANCED OPTIONS
.SS DEVICE SPECIFICATION
For this section you'll want to have knowledge of
.B glob (7)
and our evil
.B "BIT MATCHING SPECIFICATION"
stuff.
.PP
The following driver 
.B Options
control what devices are accepted:

.TP 7
.BI "Option \*qDevice\*q \*q" string \*q
Specifies the device note through which the device can be accessed.
At this time ONLY /dev/input/event<N>, where <N> is an integer, are
matched against this this field.
.fi
This option uses globbing.
.fi
Please note that use of this option is strongly discouraged.

.TP 7
.BI "Option \*qName\*q \*q" string \*q
Specifies the device name for the device you wish to use.
.fi
The device name is generally the only consistent identifier for devices 
that are commonly unplugged and plugged back into different ports.
.fi
A list of currently plugged in devices and associated device names can be 
obtained by typing \*qcat /proc/bus/input/devices\*q, the \*qName\*q field 
is the value you want for this option.
.fi
This option uses globbing.

.TP 7
.BI "Option \*qPhys\*q \*q" string \*q
Specifies the device phys string for the device you wish to use.
.fi
The phys string is generally consistant to the USB port a device is plugged 
into.
.fi
A list of currently plugged in devices and associated device names can be 
obtained by typing \*qcat /proc/bus/input/devices\*q, the \*qPhys\*q field 
is the value you want for this option.
.fi
This option uses globbing.

.TP 7
.BI "Option \*q<map>Bits\*q \*q" "bit specifier" \*q
Specifies device capability bits which must be set, possibly set, or unset.
.fi
<map>Bits: Where map is one of ev, key, rel, abs, msc, led, snd, or
ff.
.fi
The bit specifier format is a string consisting of +<n>, -<n>, and ~<n>
space sepirated specifiers, where <n> is a positive integer or integer range.
(The latter given in the format of 2-6.)
.fi
+ specifies bits which must be set.
.fi
- specifies bits which must not be set.
.fi
~ is a little more complex, it specifies that at least one of the bits given
with ~ for the field in question must be set, but it doesn't matter how many
or which of the bits. (It is actually the most useful of the 3 specifiers.)
.fi
As an example '+0 +3 -1-2 ~5-10', requires bits 0 and 3 be set,
bits 1 and 2 to not be set, and at least one bit in the range of 5 to
10 be set.
.fi
An annoyingly formatted set of bitmasks for your devices can be obtained
by typing \*qcat /proc/bus/input/devices\*q, and
.B /usr/include/linux/input.h
should contain the defines which declare what bits are what for each field.

.TP 7
.BI "Option \*qbustype\*q \*q" integer \*q
Specifies the bus ID for the device you wish to use.
.fi
This is either 0 (the default, matches anything), or the Bus=<n> field in
.B /proc/bus/input/devices
for your device.
.fi
This value depends on what type of bus your device is connected to.

.TP 7
.BI "Option \*qvendor\*q \*q" integer \*q
Specifies the vendor ID for the device you wish to use.
.fi
This is either 0 (the default, matches anything), or the Vendor=<n> field in
.B /proc/bus/input/devices
for your device.
.fi
This value should remain constant barring perhaps firmware updates to the
device itself.

.TP 7
.BI "Option \*qversion\*q \*q" integer \*q
Specifies the version for the device you wish to use.
.fi
This is either 0 (the default, matches anything), or the Version=<n> field in
.B /proc/bus/input/devices
for your device.
.fi
This value should remain constant barring perhaps firmware updates to the
device itself.

.TP 7
.BI "Option \*qproduct\*q \*q" integer \*q
Specifies the product ID for the device you wish to use.
.fi
This is either 0 (the default, matches anything), or the Product=<n> field in
.B /proc/bus/input/devices
for your device.
.fi
This value should remain constant barring perhaps firmware updates to the
device itself.

.TP 7
.BI "Option \*qPass\*q \*q" integer \*q
Specifies the order in which evdev will scan for devices.
.fi
This is in the range of 0 to 3, and is used for the case
where more then one evdev inputsection matches the same device.
.fi
An inputsection with a lower pass number will always beat out
one with a higher pass number.  Order when both sections are
the same number is undefined.
.fi
The default is 0.


.PP
.SS RELATIVE AXIS CONFIGURATION
The relative axis portion of this driver handle all reported relative axies.
.fi
The axies are named X, Y, Z, RX, RY, RZ, HWHEEL, DIAL, WHEEL, MISC, 10, 11,
12, 13, 14, and 15.
.fi
The axies are reported to X as valuators, with the default mapping of axies
to valuators being the first axies found to the first valuator, the second
found to the second valuator, and so on, so that if you have axies X, Y,
HWHEEL, and WHEEL, you would have X=0, Y=1, HWHEEL=2, WHEEL=3.
.fi
If the driver is reporting core events, valuators 0 and 1 are always mapped
to x and y coordinates, respectively.
.fi
The following driver 
.B Options
control the relative axis portion of the driver:
.TP 7
.BI "Option \*q<axis>RelativeAxisMap\*q \*q" number \*q
This remaps the axis specified to the specified valuator.
.TP 7
.BI "Option \*q<axis>RelativeAxisButtons\*q \*q" number " number\*q
This remaps the axis specified to the specified buttons.
.fi
Note that the physical buttons are always remapped around 'fake' buttons 
created by this option, so that if you have physical buttons 1 2 3 4 5,
and map the Wheel axis to buttons 4 5, you get buttons 1 2 3
.B 4 5
6 7, with buttons 6 and 7 being physical buttons 4 and 5.
.PP
.SS ABSOLUTE AXIS CONFIGURATION
The relative axis portion of this driver handle all reported relative axies.
.fi
The axies are named X, Y, Z, RX, RY, RZ, THROTTLE, RUDDER, WHEEL, GAS, BREAK,
<11-15>, HAT0X, HAT0Y, HAT1X, HAT1Y, HAT2X, HAT2Y, HAT3X, HAT3Y, PRESSURE,
TILT_X, TILT_Y, TOOL_WIDTH, VOLUME, <29-39>, MISC, <41-62>.
.fi
The axies are reported to X as valuators, with the default mapping of axies
to valuators being the first axies found to the first valuator, the second
found to the second valuator, and so on, so that if you have axies X, Y,
TILT_X, and TILT_Y, you would have X=0, Y=1, TILT_X=2, TILT_Y=3.
.fi
If the driver is reporting core events, valuators 0 and 1 are always mapped
to x and y coordinates, respectively.
.fi
The following driver 
.B Options
control the relative axis portion of the driver:
.TP 7
.BI "Option \*q<axis>AbsoluteAxisMap\*q \*q" number \*q
This remaps the axis specified to the specified valuator.
.TP 7
.BI "Option \*qAbsoluteScreen\*q \*q" number \*q
This binds the device to a specific screen, scaling it to
the coordinate space of that screen.
.fi
The number can either be -1, or a valid screen number.
.fi
If -1 or if in relative mode no scaling or screen fixing is done.
.fi
This is of most use for digitizers, where the screen and the input
device are the same surface.
.TP 7
.BI "Option \*qMode\*q \*q" <mode>\*q
This selects the default mode for the device.
.fi
Valid values are \*qabsolute\*q and \*qrelative\*q.
.fi
This can be set at run time per actual device with the xinput utility.
.PP
.SS BUTTON CONFIGURATION
At the moment, the button portion of this driver only handles buttons
reported as mouse buttons, that is from BTN_MOUSE to BTN_JOYSTICK - 1.
.fi
At this time there are no configuration options for buttens.
.SS KEYBOARD CONFIGURATION
The keyboard portion of this driver handles all keys reported and requires 
XKB support.
.fi
The following driver 
.B Options
control the relative axis portion of the driver:
.TP 7
.BI "Option \*qXkbRules\*q \*q" rules \*q
specifies which XKB rules file to use for interpreting the
.BR XkbModel ,
.BR XkbLayout ,
.BR XkbVariant ,
and
.B XkbOptions
settings.  Default: "xorg" for most platforms, but "xfree98" for the
Japanese PC-98 platforms.
.TP 7
.BI "Option \*qXkbModel\*q \*q" modelname \*q
specifies the XKB keyboard model name.  Default: "evdev".
.TP 7
.BI "Option \*qXkbLayout\*q \*q" layoutname \*q
specifies the XKB keyboard layout name.  This is usually the country or
language type of the keyboard.  Default: "us".
.TP 7
.BI "Option \*qXkbVariant\*q \*q" variants \*q
specifies the XKB keyboard variant components.  These can be used to
enhance the keyboard layout details.  Default: not set.
.TP 7
.BI "Option \*qXkbOptions\*q \*q" options \*q
specifies the XKB keyboard option components.  These can be used to
enhance the keyboard behaviour.  Default: not set.

.PP
.SH AUTHORS
Zephaniah E. Hull.
.fi
Kristian Høgsberg.
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__).
