.\" $XdotOrg: $
.\"
.\" Copyright 1996 Hewlett-Packard Company
.\" Copyright 1996 International Business Machines Corp.
.\" Copyright 1996, 1999, 2004 Sun Microsystems, Inc.
.\" Copyright 1996 Novell, Inc.
.\" Copyright 1996 Digital Equipment Corp.
.\" Copyright 1996 Fujitsu Limited
.\" Copyright 1996 Hitachi, Ltd.
.\" Copyright 1996 X Consortium, Inc.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a 
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, subject to the following
.\" conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the names of the copyright holders
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from said copyright holders.
.\"
.TH XpGetPrinterList 3Xp __xorgversion__ "XPRINT FUNCTIONS"
.SH NAME
XpGetPrinterList \- Retrieves a list of all printers supported on an X Print 
Server.
.SH SYNOPSIS
.br
      cc [ flag... ] file... -lXp [ library... ]	
.br
      #include <X11/extensions/Print.h>
.LP    
.B XPPrinterList XpGetPrinterList
(
.I display, 
.I printer_name, 
.I list_count_return 
)
.br
      Display *\fIdisplay\fP\^;
.br
      char *\fIprinter_name\fP\^;
.br
      int *\fIlist_count_return\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies a pointer to the Display structure; returned from XOpenDisplay.
.TP
.I printer_name
Specifies the name of the printer for which information is desired. If NULL, 
then information is returned for all printers associated with the server.
.TP
.I list_count_return
Returns the number of printers in the list.
.SH DESCRIPTION
.LP
XpGetPrinterList returns a list of printer records where each record describes a 
printer supported by the X Print Server, or NULL if any errors occur.

If 
.I printer_name 
is NULL, then a list of all printers supported is returned. If 
.I printer_name 
is non-NULL, only print records matching 
.I printer_name 
are returned, 
and if no records match 
.I printer_name
, then NULL is returned.

.I printer_name 
is a COMPOUND_TEXT string, and the name and desc fields in the 
returned list will be in COMPOUND_TEXT (note, ISO 8859-1 (Latin-1) is a proper 
subset of COMPOUND_TEXT, so can be used directly). If 
.I printer_name 
is in a code-set that the X Print Server cannot convert (into its operating 
code-set), then the X Print Server may fail to locate the requested printer.   
If 
.I printer_name 
is NULL, then all printer names, regardless of their code-set, can 
be returned, leaving the task of specific printer recognition up to the caller.

When XpGetPrinterList is called, the caller's locale (see XpSetLocaleHinter) is 
included in the request as a "hint" to the X Print Server. If supported by the 
implementation, the X Print Server will use the hint to locate a localized 
description for each printer in the list. If the X Print Server cannot 
understand the hint, the X Print Server will choose a default.
The returned printer list can be freed by calling XpFreePrinterList.

The XPPrinterList structure defined in <X11/extensions/Print.h> contains:
.nf

typedef struct {
    char *name;	/* name */
    char *desc;	/* localized description */
} XPPrinterRec, *XPPrinterList;

.fi
.SH DIAGNOSTICS
.TP 15
.SM BadAlloc
Insufficient memory.
.SH "SEE ALSO"
.BR XpFreePrinterList (3Xp),
.BR XpSetLocaleHinter (3Xp)

