Copyright (c) 2005 X.Org Foundation L.L.C.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
$Header: /usr4/cvs/vsw5/lib/error/EMat3.mc,v 8.0 1998/12/23 23:23:45 mar Rel $

Copyright (c) Applied Testing and Technology, Inc. 1995
All Rights Reserved.

>>#
>># Project: VSW5
>>#
>># File: tset/lib/error/EMat3.mc
>>#
>># Description:
>>#     BadMatch error test
>>#
>># Modifications:
>># $Log: EMat3.mc,v $
>># Revision 8.0  1998/12/23 23:23:45  mar
>># Branch point for Release 5.0.2
>>#
>># Revision 7.0  1998/10/30 22:41:51  mar
>># Branch point for Release 5.0.2b1
>>#
>># Revision 6.0  1998/03/02 05:16:14  tbr
>># Branch point for Release 5.0.1
>>#
>># Revision 5.0  1998/01/26 03:12:46  tbr
>># Branch point for Release 5.0.1b1
>>#
>># Revision 4.0  1995/12/15 08:40:05  tbr
>># Branch point for Release 5.0.0
>>#
>># Revision 3.1  1995/12/15  00:36:32  andy
>># Prepare for GA Release
>>#
/*
Portions of this software are based on Xlib and X Protocol Test Suite.
We have used this material under the terms of its copyright, which grants
free use, subject to the conditions below.  Note however that those
portions of this software that are based on the original Test Suite have
been significantly revised and that all such revisions are copyright (c)
1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
revisions cannot be separated from the freely copyable material, the net
result is that use of this software is governed by the ApTest copyright.

Copyright (c) 1990, 1991  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

Copyright 1990, 1991 by UniSoft Group Limited.

Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of UniSoft not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  UniSoft
makes no representations about the suitability of this software for any
purpose.  It is provided "as is" without express or implied warranty.
 */
>>ASSERTION Bad A
>>### Match gc-drawable-screen
When the graphics context and the drawable were not created for the same
root, then a
.S BadMatch
error occurs.
>>STRATEGY
If multiple screens are supported
  Create pixmap of depth 1.
  Create gc on alternate screen.
  Call test function with this pixmap and gc.
  Verify that a BadMatch error occurs.
else
  report UNSUPPORTED
>>CODE BadMatch
XVisualInfo	vi;
Pixmap	errpm;
int 	scr_num;

        if (config.alt_screen == -1) {
                unsupported("No alternate root supported");
                return;
        }

	scr_num = config.alt_screen;
	if (scr_num == DefaultScreen(A_DISPLAY)) {
		delete("The alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(A_DISPLAY)) {
		delete("The alternate root could not be accessed");
		return;
	}

	vi.visual = NULL;
	vi.screen = DefaultScreen(A_DISPLAY);	/* XXX */
	vi.depth = 1;
	A_DRAWABLE = makepixm(A_DISPLAY, &vi);
#ifdef A_DRAWABLE2
	A_DRAWABLE2 = makepixm(A_DISPLAY, &vi);
#endif
#ifdef A_IMAGE
	A_IMAGE = makeimg(A_DISPLAY, &vi, ZPixmap);
	dsetimg(A_IMAGE, W_FG);
#endif

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */
	errpm = XCreatePixmap(A_DISPLAY, RootWindow(A_DISPLAY, scr_num), 1, 1, 1);
	A_GC = makegc(A_DISPLAY, errpm);

	XCALL;

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreePixmap(A_DISPLAY, errpm);
