.TH aplay 1 "Release 1"  "AF Version 3"
.SH NAME
aplay - An AF play client.
.SH SYNOPSIS
.B
aplay 
[\fB\-server\fP \fIaudioserver\fP] 
[\fB\-d\fP \fIdevice\fP] 
[\fB-t\fP \fItime\fP] 
[\fB-g\fP \fIgain\fP] 
[\fB-e\fP \fIencoding\fP] 
[\fB-f\fP ] 
[\fB-c\fP]
[\fB-b\fP]
[\fB-l\fP]
[\fIfile\fP]
.SH DESCRIPTION
\fIaplay\fP reads samples from \fIfile\fP,
or stdin if \fIfile\fP is not specified, and sends the sound data to the 
audio server for playback.  The file is assumed to be of a sample format
appropriate for the playback device.
.SH OPTIONS
.TP
.B \-server \fIaudioserver\fP
.IP 
Specifies which audio server to connect to in order to play the sound 
file.
If \fIaudioserver\fP is not specified, \fIaplay\fP 
uses the default server.  See the AUDIOFILE environment variable.
.TP
.B \-d \fIdevice\fP
.IP 
Specifies which audio device to play the sound file through.
If \fIdevice\fP is not specified, \fIaplay\fP 
defaults to the first device that isn't connected to the telephone.
.TP
.B \-t \fItime\fP
.IP
\fItime\fP can be used to adjust the audio device time at which the 
the \fIaplay\fP client begins to play the sound data.
A positive value of \fItime\fP will begin playing \fItime\fP seconds
in the future.
If \fItime\fP is negative, \fItime\fP seconds of sound data will be
"thrown away".  The default is 0.1 seconds.
.TP
.B \-e \fencoding\fP
.IP
\fIencoding\fP will specify the type of the data being read from the
file or standard input.  Legal values are described in the audio.h
header file, and may be obtained via aplay -e xxx.  The -e flag simply
informs the AF server of the datatype.Some encodings may fail if they
are not supported by the AF server.  See also aconvert(1).
.TP
.B \-g \fIgain\fP
.IP
A \fIgain\fP in dB can be used to attenuate or amplify the sound
data prior to mixing in the audio server.
.TP
.B \-f
.IP
The -f switch turns on flush mode, which forces \fIaplay\fP to wait until the 
last sound has been played before exiting.
.TP
.B \-c
.IP
The -c switch instructs \fIaplay\fP to play to the canonical sound bytes
shipped with the AF kit.  
This switch depends on the
.B SOUND_PATH
environment variable.
.TP
.B \-b
.IP
Specifies that for 16 bit data, the bytes are in "Big Endian" byte order
(e.g. Sparc, RIOS, PA).
.TP
.B \-l
.IP
Specifies that for 16 bit data, the bytes are in "Little Endian" byte order
(e.g. Alpha, Intel x86, VAX).
.TP
.B \fIfile\fP
.IP
\fIaplay\fP attempts to read from \fIfile\fP in the current working 
directory or from one of the directories in the
.B SOUND_PATH
environment variable if it is set.
.SH ENVIRONMENT
.TP 15
.B AUDIOFILE
specifies the host and server to use.
.TP 15
.B SOUND_PATH
specifies a colon-separated list of directories in which sounds may be found.
.SH BUGS
There is no way to play back a file in preempt mode.
.PP
If you encounter a \fBreproducible\fP bug, please submit a problem report to
(af-bugs@crl.dec.com).
.SH "SEE ALSO"
AF(1), arecord(1)
.SH COPYRIGHT
Copyright 1992-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Digital Cambridge Research Lab
