.\"    Copyright (c) 1994 Cray Research Inc.
.\" 
.\" The X Consortium, and any party obtaining a copy of these files from
.\" the X Consortium, directly or indirectly, is granted, free of charge, a
.\" full and unrestricted irrevocable, world-wide, paid up, royalty-free,
.\" nonexclusive right and license to deal in this software and
.\" documentation files (the "Software"), including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons who receive
.\" copies from any such party to do so.  This license includes without
.\" limitation a license to do the foregoing actions under any patents of
.\" the party supplying this software to the X Consortium.
.\" 
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS". EXCEPT AS EXPRESSLY PROVIDED IN
.\" THE CONTRIBUTION LETTER, ALL WARRANTIES WITH RESPECT TO THE SOFTWARE
.\" ARE, EXPRESS OR IMPLIED, ARE HEREBY DISCLAIMED AND EXCLUDED, INCLUDING
.\" WITHOUT LIMITATION ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
.\" PARTICULAR PURPOSE OR USE, OR FREEDOM FROM INFRINGEMENT OR VIOLATION
.\" OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, AND ALL OBLIGATIONS
.\" OR LIABILITIES FOR DAMAGES ARISING OUT OF OR IN CONNECTION WITH THE
.\" PERFORMANCE OF, OR THE USE OF THE SOFTWARE.
.\"

.TH XMANDEL N " 07 March 1989" "X Version 11"
.UC 4
.SH NAME
xmandel \- window based interface to Mandelbrot sets and Julia sets
.SH SYNOPSIS
xmandel [-display display]
.SH DESCRIPTION
.PP
.IR Xmandel
is a user friendly interface for generating Mandelbrot sets and Julia sets.
It initially comes up with with several command buttons,
which are described below, for controlling the execution.
A Mandelbrot set is drawn in the window of the initial form
when the \fImandel\fP button is selected.
A separate window is created for drawing the Julia sets.
.SH THEORY
Let z0 be a number in the complex plane (x + yi). 
Choose a complex constant C.  
Calculate z1 = z0 ** 2 + C.
Repeat this recursively, so that z2 = z1 ** 2 + C,
z3 = z2 ** 2 + C and so on.
z[n] will either tend to infinity or zero, depending
on its initial value and the constant C.
Specifically if the absolute value of z[n], 
expressed as |z| = sqrt(x**2 + y**2) is greater than 2,
then the recursive formula will diverge.
.PP
So, to calculate a Julia set, take each point near (0,0i),
and use the formula z = z**2 + C recursively.
The Julia set is the set of points for which
z = z**2 + C would iterate indefinitely for the constant C.
Pixels, which represent numbers in the complex plane,
are set to the number of iterations before |z| exceeds 2.
This then becomes an index into the hardware colormap.
Each color then represents the number of iterations before
divergence is detected.
.PP
To calculate a Mandelbrot set, again take each point near (0,0i),
use the same formula z = z**2 + C recursively.
This time let C be the initial value of the point itself (C = z0).
Rather than having the same C for every point in the complex plane
as in Julia set calculations,
C is different for each point in the plane.
Again let the pixel value be the number of iterations
before |z| exceeds 2.
.PP
On monochrome displays, the pixel value is set to 1
if the iteration count is 64, otherwise 0.
.PP
Mandelbrot sets and Julia sets are obviously closely
related as can be seen from the similarity of their
respective formulas.
If the constant C is chosen from the interior of the
Mandelbrot set, then the Julia set calculated from that
constant C will be connected, that is have no gaps or discontinuities.
If the constant C is chosen from outside the Mandelbrot set,
the Julia set will be disconnected, more like grains of dust (Fatou clouds).
If the constant C is chosen from the border of the Mandelbrot set, 
then the Julia set will be more convoluted.
Given this relationship between points in the Mandelbrot set
and the Julia set generated, 
Xmandel provides user selection of the constant C
by mouse selection in the Mandelbrot window.
.SH BUTTONS
To control execution of the calculations, various buttons
are provided.
The buttons are:
.TP
.B mandel \-
Calculates a Mandelbrot set from (-2.0, -1.5) to (1.0, 1.5)
and display it in the window provided.
.TP
.B mandelzoom \-
In order to zoom in on a given area in the Mandelbrot set,
a zoom button is provided.
The area to be zoomed in on is selected with the left mouse button.
Left button down begins the selection,
dragging with left button down draws a rubber banded box to show the zoom area,
and left button up begins the calculation.
You can zoom in on a zoomed in area until you reach
the limits of the precision of your hardware.
Selecting a zoom area that crosses a window border doesn't work.
.TP
.B unzoom \-
Return to previous zoom.  
Note that you can zoom all the way out by selecting the \fImandel\fP button.
.TP
.B redo \-
Because the Mandelbrot calculations are CPU intensive,
xmandel does not restart the calculation
automatically on receipt of an exposure event.
This is left up to user control.
The redo button will simply recalculate the current zoom level
and display it in the Mandelbrot window.
This is also useful for seeing new detail when the iteration count is increased.
.TP
.B julia \-
Calculates a Julia set.
The user is required to select a point inside the Mandelbrot window using 
the left mouse button as the constant C for the Julia set calculation.
It will open a new window if needed.
The Julia set is centered around (0,0),
going from (-1.5, -1.5) to (1.5, 1.5).
Julia set points can be selected from zoomed in Mandelbrot windows as well.
Beware of selecting points outside the Mandelbrot window.
.TP
.B clear \-
Clears the Mandelbrot window.
.TP
.B quit \-
Exit the xmandel program.
.TP
.B increate iterations \-
On color displays, the iteration count (sometimes called dwell)
is initially set to 256, on monochrome, 64.
The \fIincreate iteration\fP button will increase the interation count
 by 256 on color or 64 on monochrome.
This is useful for seeing more detail when zoomed in.
.TP
.B reset iterations \-
Will reset the iteration count to its default value of 256 or 64.
.SH LABELS
.TP
.B hostname \-
The name of the host is displayed in the topmost pane.
This is handy when comparing the performance of multiple copies
of xmandel.
.TP
.B iteration count \-
The current iteration count is displayed in the second pane.
.TP
.B current view \-
The region of the Mandelbrot being displayed is given in the
bottommost pane, as a range of x and y values in real coordinates.
.TP
.B Julia set constant \-
Julia sets are displayed in a separate window, and the value of
the constant used for the Julia set calculation is given to the
window manager to be displayed in the title bar.
.SH BUGS
Xmandel uses hard coded values for button colors,
assuming a 256 color colormap.
.PP
Xmandel deliberately does not handle exposure events.
.PP
Selecting a zoom area that crosses a window border doesn't work.
.PP
Performance is slow on workstations,
especially workstations without floating point hardware.
.SH AUTHOR
John L. Freeman
.br
jlf@cray.com
